const proc = require("child_process");
const fs = require("fs");
console.log("Start post installation script...");
let glibc;
try {
    glibc = parseFloat(proc.execSync(`ldd --version`)
        .toString("utf8")
        .split("\n")[0]
        .split(")")[1].trim());
} catch (e) {
    console.error("Postinstall error", e);
    process.exit(1)
}

let isAstra17 = false;
let isAstraSE = false;
try {
    const info = proc.execSync(`lsb_release -a`).toString("utf8");
    isAstra17 = info.includes('Astra Linux 1.7');
    isAstraSE = info.includes('Astra Linux');
} catch (e) {
    console.error("Postinstall error", e);
}

if (isAstra17 || isAstraSE) {
    try {
        const path = `/opt/perco-school/lib/${isAstra17 ? 'astra_17' : 'astra_se'}`
        fs.writeFileSync("/etc/ld.so.conf.d/perco-school.conf", path);
        process.exit(0);
    } catch (e) {
        console.error("Postinstall error", e);
        process.exit(1);
    }
}

if (glibc < 2.19) {
    try {
        let buf = fs.readFileSync("/opt/perco-school/lib/rosa/s30-video.node");
        fs.writeFileSync("/opt/perco-school/sysserver/s30-video.node", buf, {mode: 0x777});
        buf = fs.readFileSync("/opt/perco-school/lib/rosa/s30-perco.node");
        fs.writeFileSync("/opt/perco-school/sysserver/s30-perco.node", buf, {mode: 0x777});
        buf = fs.readFileSync("/opt/perco-school/lib/rosa/s30-suprema.node");
        fs.writeFileSync("/opt/perco-school/sysserver/s30-suprema.node", buf, {mode: 0x777});
    } catch (e) {
        console.error("Postinstall error", e);
        process.exit(1)
    }
}

if (glibc <= 2.24) {
    try {
        fs.writeFileSync("/etc/ld.so.conf.d/perco-school.conf",
            "/opt/perco-school/lib/16\n/opt/perco-school/sysserver");
        process.exit(0);
    } catch (e) {
        console.error("Postinstall error", e);
        process.exit(1);
    }
} else {
    try {
        fs.writeFileSync("/etc/ld.so.conf.d/perco-school.conf",
            "/opt/perco-school/lib/18\n/opt/perco-school/sysserver");
        process.exit(0);
    } catch (e) {
        console.error("Postinstall error", e);
        process.exit(1)
    }
}

console.error("Unsupported operation system!");
process.exit(1);
