PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE `access_template` (
  `id` integer NOT NULL primary key autoincrement,
  `name` varchar(150)  NOT NULL,
  `comment` varchar(150)  DEFAULT NULL,
  `is_const` integer NOT NULL DEFAULT '0',
  `is_removed` integer NOT NULL DEFAULT '0'
);
CREATE TABLE `access_zone` (
  `id` integer NOT NULL primary key autoincrement,
  `is_const` integer NOT NULL DEFAULT '0',
  `name` varchar(150)  NOT NULL,
  `parent_id` integer DEFAULT NULL,
  `is_removed` integer NOT NULL DEFAULT '0'
);
INSERT INTO access_zone VALUES(1,1,'Неконтролируемая территория',NULL,0);
CREATE TABLE `available_right` (
  `id` integer NOT NULL primary key autoincrement,
  `type_id` integer NOT NULL,
  `object_id` integer NOT NULL,
  `user_role_id` integer NOT NULL
);
CREATE TABLE `available_type` (
  `id` integer NOT NULL primary key autoincrement,
  `type` varchar(50)  NOT NULL,
  `license_id` integer NOT NULL,
  `source` varchar(50)  NOT NULL
);
INSERT INTO available_type VALUES(1,'Помещения',4,'access_zone');
INSERT INTO available_type VALUES(2,'Подразделения',4,'division');
INSERT INTO available_type VALUES(3,'Должности',4,'position');
INSERT INTO available_type VALUES(4,'Графики работы',6,'work_schedule');
INSERT INTO available_type VALUES(5,'Шаблоны доступа',4,'access_template');
INSERT INTO available_type VALUES(6,'Шаблоны пропусков',5,'pass_template_design');
INSERT INTO available_type VALUES(7,'Устройства',4,'device');
INSERT INTO available_type VALUES(10,'Шаблоны верификации',7,'verify_template');
CREATE TABLE `category_tab` (
  `id` integer NOT NULL primary key autoincrement,
  `parent_id` integer DEFAULT NULL,
  `sort_id` integer DEFAULT NULL,
  `name` varchar(150)  NOT NULL,
  `title` varchar(150)  DEFAULT NULL,
  `description` varchar(150)  DEFAULT NULL,
  `is_active` integer NOT NULL DEFAULT '1',
  `help_link` varchar(255)  DEFAULT NULL,
  `icon_name` varchar(150)  DEFAULT NULL,
  `license_id` integer NOT NULL,
  `schema_id` integer DEFAULT NULL
, api_methods mediumtext);
INSERT INTO category_tab VALUES(1,NULL,0,'##Разделы##',NULL,NULL,1,NULL,NULL,0,NULL,NULL);
INSERT INTO category_tab VALUES(2,1,10,'##Персонал##','personal',NULL,1,NULL,'icon-personal',4,NULL,'{"devicesChangePOST":{},"timeAttendanceScheduleHolidaysListGET":{},"systemChangeLanguagePOST":{}}');
INSERT INTO category_tab VALUES(3,1,20,'##Бюро пропусков##','passoffice',NULL,1,NULL,'icon-passOffice',4,NULL,'{"devicesChangePOST":{},"systemChangeLanguagePOST":{}}');
INSERT INTO category_tab VALUES(4,1,30,'##Учёт рабочего времени##','timetracking',NULL,1,NULL,'icon-timetracking',6,NULL,'{"systemChangeLanguagePOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{}}');
INSERT INTO category_tab VALUES(5,1,40,'##Контроль доступа##','controlaccess',NULL,1,NULL,'icon-dostup',4,NULL,'{"systemChangeLanguagePOST":{},"roomsTreeGET":{},"roomsListGET":{}}');
INSERT INTO category_tab VALUES(6,1,60,'##Заказ пропуска##','orderpass',NULL,1,NULL,'icon-orderpass',5,NULL,'{"systemChangeLanguagePOST":{},"usersIdGET":{},"usersVisitorTableGET":{},"usersVisitorTableHtmlGET":{},"usersStaffListGET":{},"usersVisitorListGET":{},"usersStaffFullListGET":{},"usersStaffCommissionListGET":{},"usersStaffPUT":{},"usersStaffPOST":{},"usersVisitorPUT":{},"usersVisitorPOST":{},"usersStaffIdGET":{},"usersVisitorIdGET":{},"usersVisitorIdPOST":{},"usersVisitorCardExtractPOST":{},"usersAdditionalFieldListGET":{},"usersGetFingerprintCount":{},"usersGetFingerprints":{},"usersAddFingerprint":{},"usersDeleteFingerprint":{},"exportPOST":{},"divisionsIdGET":{},"devicesGET":{}}');
INSERT INTO category_tab VALUES(8,1,50,'##Верификация##','verification',NULL,1,NULL,'icon-verification',7,NULL,'{"systemChangeLanguagePOST":{},"roomWithDevicesGET":{}}');
INSERT INTO category_tab VALUES(9,1,70,'##Администрирование##','administration',NULL,1,NULL,'icon-administration',4,NULL,'{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"exportPOST":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{}}');
INSERT INTO category_tab VALUES(10,2,10,'##Сотрудники##','staff',NULL,1,'sn01ar_operator_add.htm',NULL,4,NULL,'{"devicesChangePOST":{},"timeAttendanceScheduleHolidaysListGET":{},"systemChangeLanguagePOST":{},"usersIdGET":{},"usersStaffListGET":{},"usersStaffFullListGET":{},"usersStaffPUT":{},"usersStaffPOST":{},"usersStaffIdGET":{},"usersAdditionalFieldListGET":{},"usersGetFingerprintCount":{},"usersGetFingerprints":{},"usersAddFingerprint":{},"usersDeleteFingerprint":{},"exportPOST":{},"divisionsIdGET":{},"devicesGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdImageGET":{},"usersStaffTableGET":{},"usersStaffTableHtmlGET":{},"usersStaffIdPOST":{},"usersIdDocsTableGET":{},"usersIdDocsPUT":{},"usersIdDocsReasonPUT":{},"usersIdPlannerGET":{},"usersIdPlannerPUT":{},"usersIdErrorsGET":{},"usersPlannerIdGET":{},"usersPlannerIdPOST":{},"usersPlannerIdDELETE":{},"usersIdDocsIdGET":{},"userDocsIdPOST":{},"usersDocsIdDELETE":{},"positionsListGET":{},"passDesignTemplatesListGET":{},"passDesignTemplateUserData":{},"devicesIdReaderGET":{},"roomsWithDeviceTypeGET":{},"accessTemplatesListGET":{},"accessTemplatesIdGET":{},"accessSchedulesTypesGET":{},"accessSchedulesListGET":{},"accessSchedulesPUT":{},"accessSchedulesIdGET":{},"accessSchedulesIdPOST":{},"accessTemplatesAccessRightsGET":{},"accessTemplatesCommissionTypesGET":{},"timeAttendanceScheduleListGET":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"systemCardAutoincrementGET":{},"systemCardRandomGET":{},"parseFilePOST":{},"associatePOST":{},"importPOST":{},"getStatusImportGET":{},"exportUnimportedPOST":{},"eventActionMessengerUsersGET":{},"eventActionMessengerSendPOST":{},"tasksMailSendPOST":{},"devicesIdGET":{},"timeAttendanceDocsTypesGET":{},"usersGetFaces":{},"usersAddFace":{},"usersDeleteFace":{},"deviceIdImportGET":{},"deviceIdImportPUT":{}}');
INSERT INTO category_tab VALUES(12,2,30,'##Подразделения##','divisions',NULL,1,NULL,NULL,4,NULL,'{"devicesChangePOST":{},"timeAttendanceScheduleHolidaysListGET":{},"systemChangeLanguagePOST":{},"usersStaffListGET":{},"exportPOST":{},"divisionsIdGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"roomsWithDeviceTypeGET":{},"accessTemplatesListGET":{},"accessTemplatesIdGET":{},"accessSchedulesTypesGET":{},"accessSchedulesListGET":{},"accessSchedulesPUT":{},"accessSchedulesIdGET":{},"accessSchedulesIdPOST":{},"accessTemplatesAccessRightsGET":{},"accessTemplatesCommissionTypesGET":{},"timeAttendanceScheduleListGET":{},"parseFilePOST":{},"associatePOST":{},"importPOST":{},"getStatusImportGET":{},"exportUnimportedPOST":{},"divisionsPUT":{},"divisionsTreeHtmlGET":{},"divisionsListHtmlGET":{},"divisionsIdPOST":{},"divisionsIdDELETE":{}}');
INSERT INTO category_tab VALUES(14,3,20,'##Сотрудники##','staff',NULL,1,NULL,NULL,4,NULL,'{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"usersIdGET":{},"usersStaffListGET":{},"usersStaffFullListGET":{},"usersStaffPOST":{},"usersStaffIdGET":{},"usersAdditionalFieldListGET":{},"usersGetFingerprintCount":{},"usersGetFingerprints":{},"usersAddFingerprint":{},"usersDeleteFingerprint":{},"exportPOST":{},"divisionsIdGET":{},"devicesGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdImageGET":{},"usersStaffTableGET":{},"usersStaffTableHtmlGET":{},"usersStaffIdPOST":{},"usersIdErrorsGET":{},"passDesignTemplatesListGET":{},"passDesignTemplateUserData":{},"devicesIdReaderGET":{},"roomsWithDeviceTypeGET":{},"accessTemplatesListGET":{},"accessTemplatesIdGET":{},"accessSchedulesTypesGET":{},"accessSchedulesListGET":{},"accessSchedulesPUT":{},"accessSchedulesIdGET":{},"accessSchedulesIdPOST":{},"accessTemplatesAccessRightsGET":{},"accessTemplatesCommissionTypesGET":{},"systemCardAutoincrementGET":{},"systemCardRandomGET":{},"parseFilePOST":{},"associatePOST":{},"importPOST":{},"getStatusImportGET":{},"devicesIdGET":{},"usersSearchCardGET":{},"userIdMainCardPOST":{},"userIdMainCardDELETE":{},"devicesIdResourceGET":{},"usersGetFaces":{},"usersAddFace":{},"usersDeleteFace":{}}');
INSERT INTO category_tab VALUES(15,3,10,'##Посетители##','visitors',NULL,1,NULL,NULL,5,NULL,'{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"usersIdGET":{},"usersVisitorTableGET":{},"usersVisitorTableHtmlGET":{},"usersStaffListGET":{},"usersVisitorListGET":{},"usersVisitorPUT":{},"usersVisitorPOST":{},"usersStaffIdGET":{},"usersVisitorIdGET":{},"usersVisitorIdPOST":{},"usersVisitorCardExtractPOST":{},"usersAdditionalFieldListGET":{},"usersGetFingerprintCount":{},"usersGetFingerprints":{},"usersAddFingerprint":{},"usersDeleteFingerprint":{},"exportPOST":{},"divisionsIdGET":{},"devicesGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdImageGET":{},"usersIdErrorsGET":{},"passDesignTemplatesListGET":{},"passDesignTemplateUserData":{},"devicesIdReaderGET":{},"roomsWithDeviceTypeGET":{},"accessTemplatesListGET":{},"accessTemplatesIdGET":{},"accessSchedulesTypesGET":{},"accessSchedulesListGET":{},"accessSchedulesPUT":{},"accessSchedulesIdGET":{},"accessSchedulesIdPOST":{},"accessTemplatesAccessRightsGET":{},"accessTemplatesCommissionTypesGET":{},"systemCardAutoincrementGET":{},"systemCardRandomGET":{},"parseFilePOST":{},"associatePOST":{},"importPOST":{},"getStatusImportGET":{},"exportUnimportedPOST":{},"devicesIdGET":{},"usersSearchCardGET":{},"userIdMainCardPOST":{},"userIdMainCardDELETE":{},"devicesIdResourceGET":{},"usersGetFaces":{},"usersAddFace":{},"usersDeleteFace":{}}');
INSERT INTO category_tab VALUES(16,3,30,'##Шаблоны доступа##','access',NULL,1,'sn01ea_template_new.htm',NULL,4,NULL,'{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"roomsTreeGET":{},"roomsListGET":{},"usersStaffCommissionListGET":{},"roomWithDevicesGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"roomsWithDeviceTypeGET":{},"accessTemplatesIdGET":{},"accessSchedulesTypesGET":{},"accessSchedulesListGET":{},"accessSchedulesPUT":{},"accessSchedulesIdGET":{},"accessSchedulesIdPOST":{},"accessTemplatesAccessRightsGET":{},"accessTemplatesCommissionTypesGET":{},"accessTemplatesPUT":{},"accessTemplatesTableGET":{},"accessTemplatesIdPOST":{},"accessTemplatesIdDELETE":{},"accessSchedulesTableGET":{},"accessSchedulesTimeZonePUT":{},"accessSchedulesTimeZoneIdPOST":{},"accessSchedulesWeeklyPUT":{},"accessSchedulesWeeklyIdPOST":{},"accessSchedulesFlexDayPUT":{},"accessSchedulesFlexDayPOST":{},"accessSchedulesFlexWeeklyPUT":{},"accessSchedulesFlexWeeklyIdPOST":{},"accessCommissionRoomIdPOST":{},"accessSchedulesIdDELETE":{},"accessSchedulesHolidaysGroupIdPOST":{},"roomIdCommissionTypesGET":{}}');
INSERT INTO category_tab VALUES(17,4,10,'##Журнал отработанного времени##','workedjournal',NULL,1,NULL,NULL,6,NULL,'{"systemChangeLanguagePOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"usersIdGET":{},"usersStaffListGET":{},"usersStaffIdGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdImageGET":{},"usersIdDocsTableGET":{},"usersIdDocsPUT":{},"usersIdDocsReasonPUT":{},"usersIdDocsIdGET":{},"userDocsIdPOST":{},"usersDocsIdDELETE":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"timeAttendanceScheduleIdGET":{},"timeAttendanceReportsTimeTrackingGET":{},"timeAttendanceReportsTimeTrackingHtmlGET":{}}');
INSERT INTO category_tab VALUES(18,4,30,'##Формирование табеля##','timesheetsformation',NULL,1,NULL,NULL,6,NULL,'{"systemChangeLanguagePOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"usersStaffListGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"timeAttendanceReportsTimesheetHtmlGET":{},"timeAttendanceReportsTimesheetGET":{}}');
INSERT INTO category_tab VALUES(21,4,50,'##Отчеты по дисциплине##','disciplinereports',NULL,1,NULL,NULL,6,NULL,'{"systemChangeLanguagePOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"usersIdGET":{},"usersStaffIdGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdDocsReasonPUT":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"timeAttendanceReportsViolatorsGET":{},"timeAttendanceReportsViolatorsHtmlGET":{},"timeAttendanceReportsPresenceGET":{},"timeAttendanceReportsPresenceHtmlGET":{},"timeAttendanceReportsAbsenceGET":{},"timeAttendanceReportsAbsenceHtmlGET":{},"timeAttendanceReportsLateGET":{},"timeAttendanceReportsLateHtmlGET":{},"timeAttendanceReportsEarlyGET":{},"timeAttendanceReportsEarlyHtmlGET":{},"timeAttendanceReportsOverworkGET":{},"timeAttendanceReportsOverworkHtmlGET":{}}');
INSERT INTO category_tab VALUES(22,5,60,'##Местонахождение##','whereabouts',NULL,1,NULL,NULL,6,NULL,'{"systemChangeLanguagePOST":{},"roomsTreeGET":{},"roomsListGET":{},"usersStaffListGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"accessReportsWhereaboutsGET":{},"accessReportsWhereaboutsHtmlGET":{}}');
INSERT INTO category_tab VALUES(23,5,40,'##Журнал верификации##','verificationjournal',NULL,1,NULL,NULL,7,NULL,'{"systemChangeLanguagePOST":{},"roomsTreeGET":{},"roomsListGET":{},"usersIdGET":{},"usersStaffListGET":{},"usersStaffIdGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"verifyGetEvent":{},"verifyGetEventHtml":{},"verifyGetLastEvent":{},"verifyFilterPoints":{},"verifyFilterEvents":{},"verifyFilterResponses":{},"verifyFilterOperators":{}}');
INSERT INTO category_tab VALUES(24,3,50,'##Отчет по посетителям##','visitorsreport',NULL,1,NULL,NULL,5,NULL,'{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"usersStaffListGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"accessReportsVisitorsGET":{},"accessReportsVisitorsHtmlGET":{}}');
INSERT INTO category_tab VALUES(25,5,10,'##Отчет о проходах##','premisesaccess',NULL,1,'sn01ev_wind_main.htm',NULL,5,NULL,'{"systemChangeLanguagePOST":{},"roomsTreeGET":{},"roomsListGET":{},"usersStaffListGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"accessReportsEventsGET":{},"accessReportsEventsHtmlGET":{}}');
INSERT INTO category_tab VALUES(32,9,60,'##Роли и права операторов##','roles',NULL,1,'sn01ar_wind_main.htm',NULL,4,NULL,'{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"roomsTreeGET":{},"usersStaffListGET":{},"exportPOST":{},"devicesGET":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"positionsListGET":{},"accessTemplatesListGET":{},"rolesTableGET":{},"rolesPUT":{},"rolesIdGET":{},"rolesIdPOST":{},"rolesIdDELETE":{}}');
INSERT INTO category_tab VALUES(33,9,20,'##События системы##','eventssystem',NULL,1,'sn01ev_wind_main.htm',NULL,4,NULL,'{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"roomsTreeGET":{},"roomsListGET":{},"exportPOST":{},"devicesGET":{},"roomWithDevicesGET":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"positionsListGET":{},"verifyGetEvent":{},"eventsystemGET":{},"eventsystemHtmlGET":{},"eventTypesGET":{},"eventActionListGET":{},"eventActionItemGET":{},"operatorChangeLogGET":{}}');
INSERT INTO category_tab VALUES(34,9,30,'##Реакции на события##','eventaction',NULL,0,NULL,NULL,4,NULL,'{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"exportPOST":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"eventActionListGET":{},"eventActionItemGET":{},"eventActionTableGET":{},"eventActionItemPOST":{},"eventActionItemDELETE":{},"eventActionItemPUT":{},"eventActionHardwareEventsGET":{},"devicesIdEventResourceGET":{}}');
INSERT INTO category_tab VALUES(36,4,20,'##Оправдательные документы##','documenttype',NULL,1,NULL,NULL,6,NULL,'{"systemChangeLanguagePOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"timeAttendanceDocsTypesGET":{},"timeAttendanceDocsTableGET":{},"timeAttendanceDocsIdPOST":{},"timeAttendanceDocsIdDELETE":{},"timeAttendanceDocsPUT":{},"timeAttendanceDocsCalcMethodsGET":{}}');
INSERT INTO category_tab VALUES(37,2,60,'##Дополнительные данные##','additionaldata',NULL,1,NULL,NULL,5,NULL,'{"devicesChangePOST":{},"timeAttendanceScheduleHolidaysListGET":{},"systemChangeLanguagePOST":{},"usersAdditionalFieldsTableGET":{},"usersAdditionalFieldsPUT":{},"usersAdditionalFieldsIdGET":{},"usersAdditionalFieldsIdPOST":{},"usersAdditionalFieldsIdDELETE":{}}');
INSERT INTO category_tab VALUES(38,9,50,'##Операторы##','operators',NULL,1,'sn01ar_operator_add.htm',NULL,4,NULL,'{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"usersStaffListGET":{},"exportPOST":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"operatorsGET":{},"operatorsPUT":{},"operatorsIdGET":{},"operatorsIdPOST":{},"operatorsIdDELETE":{},"operatorsIdLockPOST":{},"operatorsIdUnlockPOST":{},"rolesListGET":{}}');
INSERT INTO category_tab VALUES(50,3,40,'##Дизайн пропуска##','design',NULL,1,NULL,NULL,5,NULL,'{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"usersAdditionalFieldListGET":{},"passDesignTemplatesListGET":{},"passDesignTemplateUserData":{},"passDesignTemplatesTableGET":{},"passDesignTemplatesItemGET":{},"passDesignTemplatesItemPOST":{},"passDesignTemplatesItemDELETE":{},"passDesignTemplatesItemPUT":{}}');
INSERT INTO category_tab VALUES(54,2,40,'##Должности##','positions',NULL,1,NULL,NULL,4,NULL,'{"devicesChangePOST":{},"timeAttendanceScheduleHolidaysListGET":{},"systemChangeLanguagePOST":{},"exportPOST":{},"parseFilePOST":{},"associatePOST":{},"importPOST":{},"getStatusImportGET":{},"exportUnimportedPOST":{},"positionsPUT":{},"positionsTableGET":{},"positionsTableHtmlGET":{},"positionsIdGET":{},"positionsIdPOST":{},"positionsIdDELETE":{}}');
INSERT INTO category_tab VALUES(56,5,20,'##Управление устройствами##','devicemanagement',NULL,1,NULL,NULL,4,NULL,'{"systemChangeLanguagePOST":{},"roomsTreeGET":{},"roomsListGET":{},"devicesGET":{},"roomWithDevicesGET":{},"devicesIdReaderGET":{},"devicesIdGET":{},"devicesIdCommandPOST":{},"deviceIdCommandSchemaGET":{},"roomIdCommandSchemaGET":{},"deviceIdErrorsGET":{}}');
INSERT INTO category_tab VALUES(58,8,10,'##Верификация##','verification',NULL,1,NULL,NULL,7,NULL,'{"systemChangeLanguagePOST":{},"usersIdGET":{},"usersStaffIdGET":{},"roomWithDevicesGET":{},"verifyTemplatesLIST":{},"verifyGetTemplate":{}}');
INSERT INTO category_tab VALUES(59,9,10,'##Конфигурация##','premisesconfiguration',NULL,1,NULL,NULL,4,NULL,'{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"roomsTreeGET":{},"roomsListGET":{},"exportPOST":{},"devicesGET":{},"roomWithDevicesGET":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"eventActionMessengerUsersGET":{},"eventActionMessengerSendPOST":{},"tasksMailSendPOST":{},"devicesIdGET":{},"devicesIdResourceGET":{},"devicesIdCommandPOST":{},"deviceIdErrorsGET":{},"eventSystemClearDELETE":{},"devicesPUT":{},"devicesIdPOST":{},"devicesIdDELETE":{},"devicesIdActivatePOST":{},"devicesIdDeactivatePOST":{},"devicesIdAttachPOST":{},"devicesIdDetachPOST":{},"devicesSchemaGET":{},"devicesSearchGET":{},"devicesCameraTemplateTableGET":{},"devicesCameraTemplateListGET":{},"devicesCameraTemplateManufacturerListGET":{},"devicesCameraTemplatePUT":{},"devicesCameraTemplateIdGET":{},"devicesCameraTemplateIdPOST":{},"devicesCameraTemplateIdDELETE":{},"devicesCameraPUT":{},"devicesGatewayPUT":{},"roomsPUT":{},"roomsIdPOST":{},"roomsIdDELETE":{},"systemDatabaseBackup":{},"systemUploadUpdatePackageGET":{},"eventActionSmppProvidersGET":{},"eventActionSmppSendPOST":{},"mobileTerminalDevicePOST":{},"mobileTerminalDeviceDELETE":{},"mobileTerminalDeviceListGET":{}}');
INSERT INTO category_tab VALUES(61,9,40,'##Задания##','task',NULL,1,NULL,NULL,4,NULL,'{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"exportPOST":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"eventActionListGET":{},"eventActionItemGET":{},"systemDatabaseBackup":{},"tasksGET":{},"tasksPUT":{},"tasksIdGET":{},"tasksIdPOST":{},"tasksIdDELETE":{},"tasksIdStatusPOST":{},"tasksTypesGET":{}}');
INSERT INTO category_tab VALUES(62,6,10,'##Заказ пропуска##','index',NULL,1,NULL,NULL,5,NULL,'{"systemChangeLanguagePOST":{},"usersIdGET":{},"usersVisitorTableGET":{},"usersVisitorTableHtmlGET":{},"usersStaffListGET":{},"usersVisitorListGET":{},"usersStaffFullListGET":{},"usersStaffCommissionListGET":{},"usersStaffPUT":{},"usersStaffPOST":{},"usersVisitorPUT":{},"usersVisitorPOST":{},"usersStaffIdGET":{},"usersVisitorIdGET":{},"usersVisitorIdPOST":{},"usersVisitorCardExtractPOST":{},"usersAdditionalFieldListGET":{},"usersGetFingerprintCount":{},"usersGetFingerprints":{},"usersAddFingerprint":{},"usersDeleteFingerprint":{},"exportPOST":{},"divisionsIdGET":{},"devicesGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"systemCardAutoincrementGET":{},"systemCardRandomGET":{},"parseFilePOST":{},"associatePOST":{},"importPOST":{},"getStatusImportGET":{},"exportUnimportedPOST":{}}');
INSERT INTO category_tab VALUES(64,8,20,'##Конфигурация верификации##','verificationconfig',NULL,1,NULL,NULL,7,NULL,'{"systemChangeLanguagePOST":{},"devicesGET":{},"roomWithDevicesGET":{},"devicesIdReaderGET":{},"verifyTemplatesLIST":{},"verifyGetTemplate":{},"verifyTemplateTABLE":{},"verifyTemplatePUT":{},"verifyTemplateGET":{},"verifyTemplatePOST":{},"verifyTemplateDELETE":{},"verifyGetPoint":{},"verifyPointPUT":{},"verifyPointIdGET":{},"verifyPointPOST":{},"verifyPointDELETE":{},"verifyPointMove":{},"verifyPointLIST":{},"verifyPointTABLE":{},"verifyPointIdSchemaGET":{}}');
INSERT INTO category_tab VALUES(65,5,50,'##Отчет по доступу в помещения##','premisesaccessreport',NULL,1,NULL,NULL,5,NULL,'{"systemChangeLanguagePOST":{},"roomsTreeGET":{},"roomsListGET":{},"usersStaffListGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"accessReportsAccessZoneGET":{},"accessReportsAccessZoneHtmlGET":{}}');
INSERT INTO category_tab VALUES(66,1,80,'##Мониторинг##','centralpost',NULL,0,NULL,'icon-shield',4,NULL,'{"systemChangeLanguagePOST":{}}');
INSERT INTO category_tab VALUES(67,66,81,'##Интерактивный план##','plan',NULL,0,NULL,NULL,4,NULL,'{"systemChangeLanguagePOST":{}}');
INSERT INTO category_tab VALUES(69,9,70,'##Лицензии##','license',NULL,1,NULL,NULL,4,NULL,'{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"exportPOST":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"licensesGET":{},"licensesLicenseControllersGET":{},"licensesSetLicenseKeyPOST":{},"licensesCurrentLicenseControllerGET":{},"licensesSetLicenseControllerPOST":{},"licensesLicenseActivatePOST":{},"licensesLicenseDeactivatePOST":{}}');
INSERT INTO category_tab VALUES(70,2,20,'##Графики работы##','schedules',NULL,1,NULL,NULL,6,NULL,'{"devicesChangePOST":{},"timeAttendanceScheduleHolidaysListGET":{},"systemChangeLanguagePOST":{},"roomsTreeGET":{},"timeAttendanceScheduleListGET":{},"timeAttendanceScheduleIdGET":{},"timeAttendanceSchedulePUT":{},"timeAttendanceScheduleTableGET":{},"timeAttendanceScheduleIdPOST":{},"timeAttendanceScheduleIdDELETE":{},"timeAttendanceScheduleNightTimeGET":{},"timeAttendanceScheduleNightTimePOST":{}}');
INSERT INTO category_tab VALUES(71,2,50,'##Праздничные дни##','holidays',NULL,1,NULL,NULL,4,NULL,'{"devicesChangePOST":{},"timeAttendanceScheduleHolidaysListGET":{},"systemChangeLanguagePOST":{},"timeAttendanceScheduleHolidaysPUT":{},"timeAttendanceScheduleHolidaysFillPOST":{},"timeAttendanceScheduleHolidaysClearPOST":{},"timeAttendanceScheduleHolidaysIdGET":{},"timeAttendanceScheduleHolidaysIdPOST":{},"timeAttendanceScheduleHolidaysIdDELETE":{},"timeAttendancePresetHolidaysGET":{},"timeAttendancePresetHolidaysPUT":{},"timeAttendancePresetHolidaysIdDELETE":{}}');
INSERT INTO category_tab VALUES(72,16,31,'##Шаблоны##','accesstemplates',NULL,1,NULL,NULL,4,NULL,'{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"roomsTreeGET":{},"roomsListGET":{},"usersStaffCommissionListGET":{},"roomWithDevicesGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"roomsWithDeviceTypeGET":{},"accessTemplatesIdGET":{},"accessSchedulesTypesGET":{},"accessSchedulesListGET":{},"accessSchedulesPUT":{},"accessSchedulesIdGET":{},"accessSchedulesIdPOST":{},"accessTemplatesAccessRightsGET":{},"accessTemplatesCommissionTypesGET":{},"accessTemplatesPUT":{},"accessTemplatesTableGET":{},"accessTemplatesIdPOST":{},"accessTemplatesIdDELETE":{},"accessSchedulesTableGET":{},"accessSchedulesTimeZonePUT":{},"accessSchedulesTimeZoneIdPOST":{},"accessSchedulesWeeklyPUT":{},"accessSchedulesWeeklyIdPOST":{},"accessSchedulesFlexDayPUT":{},"accessSchedulesFlexDayPOST":{},"accessSchedulesFlexWeeklyPUT":{},"accessSchedulesFlexWeeklyIdPOST":{},"accessCommissionRoomIdPOST":{},"accessSchedulesIdDELETE":{},"accessSchedulesHolidaysGroupIdPOST":{},"roomIdCommissionTypesGET":{}}');
INSERT INTO category_tab VALUES(73,16,32,'##Временные критерии доступа##','accessschedules',NULL,1,NULL,NULL,4,NULL,'{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"roomsTreeGET":{},"roomsListGET":{},"usersStaffCommissionListGET":{},"roomWithDevicesGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"roomsWithDeviceTypeGET":{},"accessTemplatesIdGET":{},"accessSchedulesTypesGET":{},"accessSchedulesListGET":{},"accessSchedulesPUT":{},"accessSchedulesIdGET":{},"accessSchedulesIdPOST":{},"accessTemplatesAccessRightsGET":{},"accessTemplatesCommissionTypesGET":{},"accessTemplatesPUT":{},"accessTemplatesTableGET":{},"accessTemplatesIdPOST":{},"accessTemplatesIdDELETE":{},"accessSchedulesTableGET":{},"accessSchedulesTimeZonePUT":{},"accessSchedulesTimeZoneIdPOST":{},"accessSchedulesWeeklyPUT":{},"accessSchedulesWeeklyIdPOST":{},"accessSchedulesFlexDayPUT":{},"accessSchedulesFlexDayPOST":{},"accessSchedulesFlexWeeklyPUT":{},"accessSchedulesFlexWeeklyIdPOST":{},"accessCommissionRoomIdPOST":{},"accessSchedulesIdDELETE":{},"accessSchedulesHolidaysGroupIdPOST":{},"roomIdCommissionTypesGET":{}}');
INSERT INTO category_tab VALUES(78,56,21,'##Помещения##','rooms',NULL,1,NULL,NULL,4,NULL,'{"systemChangeLanguagePOST":{},"roomsTreeGET":{},"roomsListGET":{},"devicesGET":{},"roomWithDevicesGET":{},"devicesIdReaderGET":{},"devicesIdGET":{},"devicesIdCommandPOST":{},"deviceIdCommandSchemaGET":{},"roomIdCommandSchemaGET":{},"deviceIdErrorsGET":{}}');
INSERT INTO category_tab VALUES(79,56,22,'##Устройства##','controllers',NULL,1,NULL,NULL,4,NULL,'{"systemChangeLanguagePOST":{},"roomsTreeGET":{},"roomsListGET":{},"devicesGET":{},"roomWithDevicesGET":{},"devicesIdReaderGET":{},"devicesIdGET":{},"devicesIdCommandPOST":{},"deviceIdCommandSchemaGET":{},"roomIdCommandSchemaGET":{},"deviceIdErrorsGET":{}}');
INSERT INTO category_tab VALUES(82,59,13,'##Шаблоны камер##','cameratemplates',NULL,1,NULL,NULL,4,NULL,'{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"roomsTreeGET":{},"roomsListGET":{},"exportPOST":{},"devicesGET":{},"roomWithDevicesGET":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"eventActionMessengerUsersGET":{},"eventActionMessengerSendPOST":{},"tasksMailSendPOST":{},"devicesIdGET":{},"devicesIdResourceGET":{},"devicesIdCommandPOST":{},"deviceIdErrorsGET":{},"eventSystemClearDELETE":{},"devicesPUT":{},"devicesIdPOST":{},"devicesIdDELETE":{},"devicesIdActivatePOST":{},"devicesIdDeactivatePOST":{},"devicesIdAttachPOST":{},"devicesIdDetachPOST":{},"devicesSchemaGET":{},"devicesSearchGET":{},"devicesCameraTemplateTableGET":{},"devicesCameraTemplateListGET":{},"devicesCameraTemplateManufacturerListGET":{},"devicesCameraTemplatePUT":{},"devicesCameraTemplateIdGET":{},"devicesCameraTemplateIdPOST":{},"devicesCameraTemplateIdDELETE":{},"devicesCameraPUT":{},"devicesGatewayPUT":{},"roomsPUT":{},"roomsIdPOST":{},"roomsIdDELETE":{},"systemDatabaseBackup":{},"systemUploadUpdatePackageGET":{},"eventActionSmppProvidersGET":{},"eventActionSmppSendPOST":{},"mobileTerminalDevicePOST":{},"mobileTerminalDeviceDELETE":{},"mobileTerminalDeviceListGET":{}}');
INSERT INTO category_tab VALUES(83,59,11,'##Помещения##','rooms',NULL,1,NULL,NULL,4,NULL,'{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"roomsTreeGET":{},"roomsListGET":{},"exportPOST":{},"devicesGET":{},"roomWithDevicesGET":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"eventActionMessengerUsersGET":{},"eventActionMessengerSendPOST":{},"tasksMailSendPOST":{},"devicesIdGET":{},"devicesIdResourceGET":{},"devicesIdCommandPOST":{},"deviceIdErrorsGET":{},"eventSystemClearDELETE":{},"devicesPUT":{},"devicesIdPOST":{},"devicesIdDELETE":{},"devicesIdActivatePOST":{},"devicesIdDeactivatePOST":{},"devicesIdAttachPOST":{},"devicesIdDetachPOST":{},"devicesSchemaGET":{},"devicesSearchGET":{},"devicesCameraTemplateTableGET":{},"devicesCameraTemplateListGET":{},"devicesCameraTemplateManufacturerListGET":{},"devicesCameraTemplatePUT":{},"devicesCameraTemplateIdGET":{},"devicesCameraTemplateIdPOST":{},"devicesCameraTemplateIdDELETE":{},"devicesCameraPUT":{},"devicesGatewayPUT":{},"roomsPUT":{},"roomsIdPOST":{},"roomsIdDELETE":{},"systemDatabaseBackup":{},"systemUploadUpdatePackageGET":{},"eventActionSmppProvidersGET":{},"eventActionSmppSendPOST":{},"mobileTerminalDevicePOST":{},"mobileTerminalDeviceDELETE":{},"mobileTerminalDeviceListGET":{}}');
INSERT INTO category_tab VALUES(84,59,12,'##Устройства##','controllers',NULL,1,NULL,NULL,4,NULL,'{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"roomsTreeGET":{},"roomsListGET":{},"usersStaffListGET":{},"exportPOST":{},"devicesGET":{},"roomWithDevicesGET":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"eventActionMessengerUsersGET":{},"eventActionMessengerSendPOST":{},"tasksMailSendPOST":{},"devicesIdGET":{},"devicesIdResourceGET":{},"devicesIdCommandPOST":{},"deviceIdErrorsGET":{},"eventSystemClearDELETE":{},"devicesPUT":{},"devicesIdPOST":{},"devicesIdDELETE":{},"devicesIdActivatePOST":{},"devicesIdDeactivatePOST":{},"devicesIdAttachPOST":{},"devicesIdDetachPOST":{},"devicesSchemaGET":{},"devicesSearchGET":{},"devicesCameraTemplateTableGET":{},"devicesCameraTemplateListGET":{},"devicesCameraTemplateManufacturerListGET":{},"devicesCameraTemplatePUT":{},"devicesCameraTemplateIdGET":{},"devicesCameraTemplateIdPOST":{},"devicesCameraTemplateIdDELETE":{},"devicesCameraPUT":{},"devicesGatewayPUT":{},"roomsPUT":{},"roomsIdPOST":{},"roomsIdDELETE":{},"systemDatabaseBackup":{},"systemUploadUpdatePackageGET":{},"eventActionSmppProvidersGET":{},"eventActionSmppSendPOST":{},"mobileTerminalDevicePOST":{},"mobileTerminalDeviceDELETE":{},"mobileTerminalDeviceListGET":{}}');
INSERT INTO category_tab VALUES(85,59,14,'##Система##','system',NULL,1,NULL,NULL,4,NULL,'{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"roomsTreeGET":{},"roomsListGET":{},"exportPOST":{},"devicesGET":{},"roomWithDevicesGET":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"eventActionMessengerUsersGET":{},"eventActionMessengerSendPOST":{},"tasksMailSendPOST":{},"devicesIdGET":{},"devicesIdResourceGET":{},"devicesIdCommandPOST":{},"deviceIdErrorsGET":{},"eventSystemClearDELETE":{},"devicesPUT":{},"devicesIdPOST":{},"devicesIdDELETE":{},"devicesIdActivatePOST":{},"devicesIdDeactivatePOST":{},"devicesIdAttachPOST":{},"devicesIdDetachPOST":{},"devicesSchemaGET":{},"devicesSearchGET":{},"devicesCameraTemplateTableGET":{},"devicesCameraTemplateListGET":{},"devicesCameraTemplateManufacturerListGET":{},"devicesCameraTemplatePUT":{},"devicesCameraTemplateIdGET":{},"devicesCameraTemplateIdPOST":{},"devicesCameraTemplateIdDELETE":{},"devicesCameraPUT":{},"devicesGatewayPUT":{},"roomsPUT":{},"roomsIdPOST":{},"roomsIdDELETE":{},"systemDatabaseBackup":{},"systemUploadUpdatePackageGET":{},"eventActionSmppProvidersGET":{},"eventActionSmppSendPOST":{},"mobileTerminalDevicePOST":{},"mobileTerminalDeviceDELETE":{},"mobileTerminalDeviceListGET":{}}');
INSERT INTO category_tab VALUES(86,21,51,'##Нарушители##','violators',NULL,1,NULL,NULL,6,NULL,'{"systemChangeLanguagePOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"usersIdGET":{},"usersStaffListGET":{},"usersStaffIdGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdDocsTableGET":{},"usersIdDocsPUT":{},"usersIdDocsReasonPUT":{},"usersIdDocsIdGET":{},"userDocsIdPOST":{},"usersDocsIdDELETE":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"timeAttendanceReportsViolatorsGET":{},"timeAttendanceReportsViolatorsHtmlGET":{},"timeAttendanceReportsPresenceGET":{},"timeAttendanceReportsPresenceHtmlGET":{},"timeAttendanceReportsAbsenceGET":{},"timeAttendanceReportsAbsenceHtmlGET":{},"timeAttendanceReportsLateGET":{},"timeAttendanceReportsLateHtmlGET":{},"timeAttendanceReportsEarlyGET":{},"timeAttendanceReportsEarlyHtmlGET":{},"timeAttendanceReportsOverworkGET":{},"timeAttendanceReportsOverworkHtmlGET":{}}');
INSERT INTO category_tab VALUES(87,21,52,'##Присутствующие на данный момент##','presences',NULL,1,NULL,NULL,6,NULL,'{"systemChangeLanguagePOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"usersIdGET":{},"usersStaffListGET":{},"usersStaffIdGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdDocsTableGET":{},"usersIdDocsPUT":{},"usersIdDocsReasonPUT":{},"usersIdDocsIdGET":{},"userDocsIdPOST":{},"usersDocsIdDELETE":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"timeAttendanceReportsViolatorsGET":{},"timeAttendanceReportsViolatorsHtmlGET":{},"timeAttendanceReportsPresenceGET":{},"timeAttendanceReportsPresenceHtmlGET":{},"timeAttendanceReportsAbsenceGET":{},"timeAttendanceReportsAbsenceHtmlGET":{},"timeAttendanceReportsLateGET":{},"timeAttendanceReportsLateHtmlGET":{},"timeAttendanceReportsEarlyGET":{},"timeAttendanceReportsEarlyHtmlGET":{},"timeAttendanceReportsOverworkGET":{},"timeAttendanceReportsOverworkHtmlGET":{}}');
INSERT INTO category_tab VALUES(88,21,53,'##Отсутствующие сегодня##','absents',NULL,1,NULL,NULL,6,NULL,'{"systemChangeLanguagePOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"usersIdGET":{},"usersStaffListGET":{},"usersStaffIdGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdDocsTableGET":{},"usersIdDocsPUT":{},"usersIdDocsReasonPUT":{},"usersIdDocsIdGET":{},"userDocsIdPOST":{},"usersDocsIdDELETE":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"timeAttendanceReportsViolatorsGET":{},"timeAttendanceReportsViolatorsHtmlGET":{},"timeAttendanceReportsPresenceGET":{},"timeAttendanceReportsPresenceHtmlGET":{},"timeAttendanceReportsAbsenceGET":{},"timeAttendanceReportsAbsenceHtmlGET":{},"timeAttendanceReportsLateGET":{},"timeAttendanceReportsLateHtmlGET":{},"timeAttendanceReportsEarlyGET":{},"timeAttendanceReportsEarlyHtmlGET":{},"timeAttendanceReportsOverworkGET":{},"timeAttendanceReportsOverworkHtmlGET":{}}');
INSERT INTO category_tab VALUES(89,21,54,'##Опоздавшие сегодня##','lates',NULL,1,NULL,NULL,6,NULL,'{"systemChangeLanguagePOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"usersIdGET":{},"usersStaffListGET":{},"usersStaffIdGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdDocsTableGET":{},"usersIdDocsPUT":{},"usersIdDocsReasonPUT":{},"usersIdDocsIdGET":{},"userDocsIdPOST":{},"usersDocsIdDELETE":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"timeAttendanceReportsViolatorsGET":{},"timeAttendanceReportsViolatorsHtmlGET":{},"timeAttendanceReportsPresenceGET":{},"timeAttendanceReportsPresenceHtmlGET":{},"timeAttendanceReportsAbsenceGET":{},"timeAttendanceReportsAbsenceHtmlGET":{},"timeAttendanceReportsLateGET":{},"timeAttendanceReportsLateHtmlGET":{},"timeAttendanceReportsEarlyGET":{},"timeAttendanceReportsEarlyHtmlGET":{},"timeAttendanceReportsOverworkGET":{},"timeAttendanceReportsOverworkHtmlGET":{}}');
INSERT INTO category_tab VALUES(90,21,55,'##Ушедшие раньше сегодня##','earlys',NULL,1,NULL,NULL,6,NULL,'{"systemChangeLanguagePOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"usersIdGET":{},"usersStaffListGET":{},"usersStaffIdGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdDocsTableGET":{},"usersIdDocsPUT":{},"usersIdDocsReasonPUT":{},"usersIdDocsIdGET":{},"userDocsIdPOST":{},"usersDocsIdDELETE":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"timeAttendanceReportsViolatorsGET":{},"timeAttendanceReportsViolatorsHtmlGET":{},"timeAttendanceReportsPresenceGET":{},"timeAttendanceReportsPresenceHtmlGET":{},"timeAttendanceReportsAbsenceGET":{},"timeAttendanceReportsAbsenceHtmlGET":{},"timeAttendanceReportsLateGET":{},"timeAttendanceReportsLateHtmlGET":{},"timeAttendanceReportsEarlyGET":{},"timeAttendanceReportsEarlyHtmlGET":{},"timeAttendanceReportsOverworkGET":{},"timeAttendanceReportsOverworkHtmlGET":{}}');
INSERT INTO category_tab VALUES(91,21,56,'##Переработка##','overworks',NULL,1,NULL,NULL,6,NULL,'{"systemChangeLanguagePOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"usersIdGET":{},"usersStaffListGET":{},"usersStaffIdGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdDocsTableGET":{},"usersIdDocsPUT":{},"usersIdDocsReasonPUT":{},"usersIdDocsIdGET":{},"userDocsIdPOST":{},"usersDocsIdDELETE":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"timeAttendanceReportsViolatorsGET":{},"timeAttendanceReportsViolatorsHtmlGET":{},"timeAttendanceReportsPresenceGET":{},"timeAttendanceReportsPresenceHtmlGET":{},"timeAttendanceReportsAbsenceGET":{},"timeAttendanceReportsAbsenceHtmlGET":{},"timeAttendanceReportsLateGET":{},"timeAttendanceReportsLateHtmlGET":{},"timeAttendanceReportsEarlyGET":{},"timeAttendanceReportsEarlyHtmlGET":{},"timeAttendanceReportsOverworkGET":{},"timeAttendanceReportsOverworkHtmlGET":{}}');
INSERT INTO category_tab VALUES(92,16,33,'##Комиссионирование##','accesscommission',NULL,1,NULL,NULL,4,NULL,'{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"roomsTreeGET":{},"roomsListGET":{},"usersStaffCommissionListGET":{},"roomWithDevicesGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"roomsWithDeviceTypeGET":{},"accessTemplatesIdGET":{},"accessSchedulesTypesGET":{},"accessSchedulesListGET":{},"accessSchedulesPUT":{},"accessSchedulesIdGET":{},"accessSchedulesIdPOST":{},"accessTemplatesAccessRightsGET":{},"accessTemplatesCommissionTypesGET":{},"accessTemplatesPUT":{},"accessTemplatesTableGET":{},"accessTemplatesIdPOST":{},"accessTemplatesIdDELETE":{},"accessSchedulesTableGET":{},"accessSchedulesTimeZonePUT":{},"accessSchedulesTimeZoneIdPOST":{},"accessSchedulesWeeklyPUT":{},"accessSchedulesWeeklyIdPOST":{},"accessSchedulesFlexDayPUT":{},"accessSchedulesFlexDayPOST":{},"accessSchedulesFlexWeeklyPUT":{},"accessSchedulesFlexWeeklyIdPOST":{},"accessCommissionRoomIdPOST":{},"accessSchedulesIdDELETE":{},"accessSchedulesHolidaysGroupIdPOST":{},"roomIdCommissionTypesGET":{}}');
CREATE TABLE `device` (
  `id` integer NOT NULL primary key autoincrement,
  `parent_id` integer DEFAULT NULL,
  `device_type_id` integer NOT NULL,
  `hard_number` integer DEFAULT NULL,
  `ip_addr` varchar(70)  DEFAULT NULL,
  `name` varchar(150)  NOT NULL,
  `port` integer DEFAULT NULL,
  `login` varchar(150)  DEFAULT NULL,
  `password` varchar(150)  DEFAULT NULL,
  `access_zone_id1` integer DEFAULT NULL,
  `access_zone_id2` integer DEFAULT NULL,
  `is_removed` integer NOT NULL DEFAULT '1',
  `net_mask` varchar(15)  DEFAULT NULL,
  `ip_router` varchar(15)  DEFAULT NULL,
  `mac_address` varchar(17)  DEFAULT NULL,
  `resource_data` json DEFAULT NULL,
  `schema_data` json DEFAULT NULL,
  `sub_type` integer DEFAULT NULL,
  `firmware_version` varchar(50)  DEFAULT NULL,
  `protocol_id` integer DEFAULT NULL
);
INSERT INTO device VALUES(0,NULL,0,NULL,NULL,'Общие настройки',NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
CREATE TABLE `device_camera_stream` (
  `id` integer NOT NULL primary key autoincrement,
  `name` varchar(150)  NOT NULL,
  `comment` varchar(150)  DEFAULT NULL
);
INSERT INTO device_camera_stream VALUES(1,'mjpeg_over_http',NULL);
INSERT INTO device_camera_stream VALUES(2,'webcam',NULL);
INSERT INTO device_camera_stream VALUES(3,'ONVIF',NULL);
CREATE TABLE `device_camera_type` (
  `id` integer NOT NULL primary key autoincrement,
  `is_const` integer NOT NULL DEFAULT '0',
  `manufacturer` varchar(150)  NOT NULL,
  `model` varchar(150)  NOT NULL,
  `camera_stream_type_id` integer NOT NULL,
  `path` varchar(150)  NOT NULL
);
INSERT INTO device_camera_type VALUES(2,1,'AXIS','All',1,'/mjpg/video.mjpg');
INSERT INTO device_camera_type VALUES(7,1,'ACTi','ACM-4000',1,'/cgi-bin/cmd/encoder?GET_STREAM=VIDEO');
INSERT INTO device_camera_type VALUES(8,1,'TP-LINK','All',1,'/video.mjpg');
INSERT INTO device_camera_type VALUES(9,1,'ONVIF','All',3,'/');
CREATE TABLE `device_resource_type` (
  `id` integer NOT NULL primary key autoincrement,
  `name` varchar(150)  NOT NULL,
  `title` varchar(150)  NOT NULL
);
INSERT INTO device_resource_type VALUES(1,'Временные зоны','time_zone');
INSERT INTO device_resource_type VALUES(2,'Недельные графики','weekly_schedule');
INSERT INTO device_resource_type VALUES(3,'Скользящие подневные графики','shift_day_schedule');
INSERT INTO device_resource_type VALUES(4,'Скользящие понедельные графики','shift_weekly_schedule');
INSERT INTO device_resource_type VALUES(5,'Календарь праздничных дней','holidays');
INSERT INTO device_resource_type VALUES(6,'Генератор тревоги','alarm_gen');
INSERT INTO device_resource_type VALUES(7,'Вход','input');
INSERT INTO device_resource_type VALUES(8,'Выход','output');
INSERT INTO device_resource_type VALUES(9,'Замок','lock');
INSERT INTO device_resource_type VALUES(10,'Считыватель','reader');
INSERT INTO device_resource_type VALUES(11,'Карты комиссионирования','comission_card');
INSERT INTO device_resource_type VALUES(14,'Свойства ЛИКОНа','licon_config');
INSERT INTO device_resource_type VALUES(16,'строки ЛИКОНа','licon_string');
INSERT INTO device_resource_type VALUES(20,'Пространственные зоны','spatial_zone');
INSERT INTO device_resource_type VALUES(25,'Общие настройки','general');
INSERT INTO device_resource_type VALUES(26,'Камера','camera');
INSERT INTO device_resource_type VALUES(27,'Сеть','network');
INSERT INTO device_resource_type VALUES(28,'Разное','settings');
INSERT INTO device_resource_type VALUES(29,'Состояние','hw_state');
INSERT INTO device_resource_type VALUES(30,'Внешние подключения','connection');
INSERT INTO device_resource_type VALUES(31,'Общие параметры','parameters');
INSERT INTO device_resource_type VALUES(32,'Направление','direction');
INSERT INTO device_resource_type VALUES(33,'Считыватель или сканер s30','reader_ext');
INSERT INTO device_resource_type VALUES(34,'Шлюз или составной объект','gateway');
INSERT INTO device_resource_type VALUES(35,'Точка верификации','verify_point');
CREATE TABLE `division` (
  `id` integer NOT NULL primary key autoincrement,
  `is_const` integer NOT NULL DEFAULT '0',
  `parent_id` integer DEFAULT NULL,
  `name` varchar(150)  NOT NULL,
  `comment` varchar(150)  DEFAULT NULL,
  `accompanying_id` integer DEFAULT NULL,
  `staff_access_template_id` integer DEFAULT NULL,
  `visitor_access_template_id` integer DEFAULT NULL,
  `work_schedule_id` integer DEFAULT NULL,
  `is_removed` integer NOT NULL DEFAULT '0',
  `tel` varchar(150)  DEFAULT NULL
);
INSERT INTO division VALUES(1,1,NULL,'##Администраторы системы##',NULL,NULL,NULL,NULL,NULL,0,NULL);
CREATE TABLE `doc` (
  `id` integer NOT NULL primary key autoincrement,
  `type_id` integer NOT NULL,
  `sort_id` integer DEFAULT NULL,
  `name` varchar(170)  NOT NULL,
  `char_code` varchar(2)  DEFAULT NULL,
  `digit_code` integer DEFAULT NULL,
  `is_work_time` integer NOT NULL DEFAULT '0',
  `calc_method_id` integer NOT NULL DEFAULT '1',
  `is_holiday_overtime` integer NOT NULL DEFAULT '0',
  `is_removed` integer NOT NULL DEFAULT '0'
);
INSERT INTO doc VALUES(5,1,NULL,'Продолжительность работы вахтовым методом','ВМ',5,1,1,0,0);
INSERT INTO doc VALUES(7,1,NULL,'Повышение квалификации с отрывом от работы','ПК',7,0,1,0,0);
INSERT INTO doc VALUES(8,1,NULL,'Повышение квалификации с отрывом от работы в другой местности','ПМ',8,0,1,0,0);
INSERT INTO doc VALUES(9,1,NULL,'Ежегодный основной оплачиваемый отпуск','ОТ',9,0,1,0,0);
INSERT INTO doc VALUES(10,1,NULL,'Ежегодный дополнительный оплачиваемый отпуск','ОД',10,0,1,0,0);
INSERT INTO doc VALUES(11,1,NULL,'Дополнительный отпуск в связи с обучением с сохранением среднего заработка работникам, совмещающим работу с обучением','У',11,0,2,0,0);
INSERT INTO doc VALUES(12,1,NULL,'Сокращенная продолжительность рабочего времени для обучающихся без отрыва от производства с частичным сохранением заработной платы','УВ',12,0,1,0,0);
INSERT INTO doc VALUES(13,1,NULL,'Дополнительный отпуск в связи с обучением без сохранения заработной платы','УД',13,0,1,0,0);
INSERT INTO doc VALUES(14,1,NULL,'Отпуск по беременности и родам (отпуск в связи с усыновлением новорожденного ребенка)','Р',14,0,2,0,0);
INSERT INTO doc VALUES(15,1,NULL,'Отпуск по уходу за ребенком до достижения им возраста трех лет','ОЖ',15,0,2,0,0);
INSERT INTO doc VALUES(17,1,NULL,'Отпуск без сохранения заработной платы при условиях, предусмотренных действующим  законодательством Российской Федерации','ОЗ',17,0,2,0,0);
INSERT INTO doc VALUES(18,1,NULL,'Ежегодный дополнительный отпуск без сохранения заработной платы','ДБ',18,0,2,0,0);
INSERT INTO doc VALUES(22,1,NULL,'Время вынужденного прогула в случае признания увольнения, перевода на другую работу или отстранения от работы незаконными с восстановлением на прежней работе','ПВ',22,0,1,0,0);
INSERT INTO doc VALUES(23,1,NULL,'Невыходы на время исполнения государственных или общественных обязанностей согласно законодательству','Г',23,0,1,0,0);
INSERT INTO doc VALUES(25,1,NULL,'Продолжительность работы в режиме неполного рабочего времени по инициативе работодателя в случаях, предусмотренных законодательством','НС',25,0,1,0,0);
INSERT INTO doc VALUES(26,1,NULL,'Выходные дни (еженедельный отпуск) и нерабочие праздничные дни','В',26,0,2,0,0);
INSERT INTO doc VALUES(27,1,NULL,'Дополнительные выходные дни (оплачиваемые)','ОВ',27,0,1,0,0);
INSERT INTO doc VALUES(28,1,NULL,'Дополнительные выходные дни (без сохранения заработной платы)','НВ',28,0,1,0,0);
INSERT INTO doc VALUES(29,1,NULL,'Забастовка (при условиях и в порядке, предусмотренных законом)','ЗБ',29,0,1,0,0);
INSERT INTO doc VALUES(30,1,NULL,'Неявки по невыясненным причинам (до выяснения обстоятельств)','НН',30,0,1,0,0);
INSERT INTO doc VALUES(31,1,NULL,'Время простоя по вине работодателя','РП',31,0,1,0,0);
INSERT INTO doc VALUES(34,1,NULL,'Отстранение от работы (недопущение к работе) с оплатой (пособием) в соответствии с законодательством','НО',34,0,1,0,0);
INSERT INTO doc VALUES(35,1,NULL,'Отстранение от работы (недопущение к работе) по причинам, предусмотренным законодательством, без начисления заработной платы','НБ',35,0,1,0,0);
INSERT INTO doc VALUES(36,1,NULL,'Время приостановки работы в случае задержки выплаты заработной платы','НЗ',36,0,1,0,0);
INSERT INTO doc VALUES(92,2,NULL,'Продолжительность сверхурочной работы','С',4,0,1,0,0);
INSERT INTO doc VALUES(93,2,NULL,'Продолжительность работы в выходные и нерабочие праздничные дни','РВ',3,0,1,1,0);
INSERT INTO doc VALUES(97,1,NULL,'Временная нетрудоспособность (кроме случаев, предусмотренных кодом "Т") с назначением пособия согласно законодательству','Б',19,1,1,0,0);
INSERT INTO doc VALUES(98,1,NULL,'Временная нетрудоспособность без назначения пособия в случаях, предусмотренных законодательством','Т',20,0,3,0,0);
INSERT INTO doc VALUES(99,1,NULL,'Время простоя по вине работника','ВП',33,0,1,0,0);
INSERT INTO doc VALUES(100,1,NULL,'Время простоя по причинам, не зависящим от работодателя и работника','НП',32,0,1,0,0);
INSERT INTO doc VALUES(105,1,NULL,'Отпуск без сохранения заработной платы, предоставленный работнику по разрешению работодателя','ДО',16,0,2,0,0);
INSERT INTO doc VALUES(106,1,NULL,'Прогулы (отсутствие на рабочем месте без уважительных причин в течение времени, установленного законодательством)','ПР',24,0,1,0,0);
INSERT INTO doc VALUES(107,1,NULL,'Служебная командировка','К',6,0,1,0,0);
INSERT INTO doc VALUES(134,1,NULL,'Сокращенная продолжительность рабочего времени против нормальной продолжительности рабочего дня в случаях, предусмотренных законодательством','ЛЧ',21,0,1,0,0);
INSERT INTO doc VALUES(135,3,NULL,'##Отпуск##',NULL,NULL,0,1,0,0);
INSERT INTO doc VALUES(136,3,NULL,'##Выходной день##',NULL,NULL,0,1,0,0);
INSERT INTO doc VALUES(137,3,NULL,'##Командировка##',NULL,NULL,0,1,0,0);
INSERT INTO doc VALUES(138,3,NULL,'##Больничный##',NULL,NULL,0,1,0,0);
INSERT INTO doc VALUES(139,3,NULL,'##Отпуск без сохранения ЗП##',NULL,NULL,0,1,0,0);
CREATE TABLE `doc_calc_method` (
  `id` integer NOT NULL primary key autoincrement,
  `name` varchar(150)  NOT NULL
);
INSERT INTO doc_calc_method VALUES(1,'В рабочих днях');
INSERT INTO doc_calc_method VALUES(2,'В календарных днях включая праздничные дни');
INSERT INTO doc_calc_method VALUES(3,'В календарных днях исключая праздничные дни');
CREATE TABLE `doc_type` (
  `id` integer NOT NULL primary key autoincrement,
  `name` varchar(150)  NOT NULL
);
INSERT INTO doc_type VALUES(1,'Оправдательный');
INSERT INTO doc_type VALUES(2,'Сверхурочный');
INSERT INTO doc_type VALUES(3,'Объяснительная');
CREATE TABLE `event_action` (
  `id` integer NOT NULL primary key autoincrement,
  `name` varchar(150)  NOT NULL
);
CREATE TABLE `event_action_object` (
  `id` integer NOT NULL primary key autoincrement,
  `action_id` integer DEFAULT NULL,
  `type_id` integer DEFAULT NULL,
  `object_id` integer DEFAULT NULL,
  `options` json DEFAULT NULL
);
CREATE TABLE `event_category` (
  `id` integer NOT NULL primary key autoincrement,
  `name` varchar(150)  NOT NULL
);
INSERT INTO event_category VALUES(1,'События контроллеров');
INSERT INTO event_category VALUES(2,'Действия пользователя');
INSERT INTO event_category VALUES(3,'События сервера оборудования');
INSERT INTO event_category VALUES(4,'События верификации');
CREATE TABLE `event_resource_type` (
  `id` integer NOT NULL primary key autoincrement,
  `name` varchar(150)  NOT NULL
);
INSERT INTO event_resource_type VALUES(1,'Считыватель');
INSERT INTO event_resource_type VALUES(2,'Исполнительное устройство');
INSERT INTO event_resource_type VALUES(3,'Генератор тревоги');
INSERT INTO event_resource_type VALUES(4,'Вход');
INSERT INTO event_resource_type VALUES(5,'Выход');
INSERT INTO event_resource_type VALUES(6,'Охранная зона');
INSERT INTO event_resource_type VALUES(7,'Ресурс');
INSERT INTO event_resource_type VALUES(8,'Причина сброса');
INSERT INTO event_resource_type VALUES(9,'Шаблон верификации');
INSERT INTO event_resource_type VALUES(10,'Код ошибки');
INSERT INTO event_resource_type VALUES(11,'Лицензия');
INSERT INTO event_resource_type VALUES(12,'Точка верификации');
INSERT INTO event_resource_type VALUES(13,'Направление');
INSERT INTO event_resource_type VALUES(14,'Отпечаток');
INSERT INTO event_resource_type VALUES(15,'Сообщение');
CREATE TABLE `event_subcategory` (
  `id` integer NOT NULL primary key autoincrement,
  `event_category_id` integer NOT NULL,
  `name` varchar(150)  NOT NULL
);
INSERT INTO event_subcategory VALUES(1,1,'События связанные с доступом по коду идентификатора');
INSERT INTO event_subcategory VALUES(2,1,'События, связанные с изменениями состояний ОЗ');
INSERT INTO event_subcategory VALUES(3,1,'События, связанные с изменением текущего состояния ШС, входящих в ОЗ');
INSERT INTO event_subcategory VALUES(4,1,'События связанные с состояниями входов/выходов');
INSERT INTO event_subcategory VALUES(5,1,'События, связанные с проходами через ИУ без идентификаторов');
INSERT INTO event_subcategory VALUES(6,1,'События связанные с функционированием');
INSERT INTO event_subcategory VALUES(8,3,'Взаимодействие с базой данных');
INSERT INTO event_subcategory VALUES(9,3,'Соединение с контроллером');
INSERT INTO event_subcategory VALUES(10,3,'Взаимодействие с web- сервером');
INSERT INTO event_subcategory VALUES(11,4,'События, связанные с верификацией');
INSERT INTO event_subcategory VALUES(12,3,'Функционирование сервера оборудования');
INSERT INTO event_subcategory VALUES(13,2,'Лицензирование');
INSERT INTO event_subcategory VALUES(14,2,'Команды пользователя в контроллер');
INSERT INTO event_subcategory VALUES(15,3,'Команды записи конфигурации в контроллер');
INSERT INTO event_subcategory VALUES(16,2,'Работа с картами Mifare');
INSERT INTO event_subcategory VALUES(10000,2,'Изменение учетных данных');
INSERT INTO event_subcategory VALUES(10011,2,'Работа с графиками работы');
INSERT INTO event_subcategory VALUES(10012,2,'Работа с подразделениями');
INSERT INTO event_subcategory VALUES(10014,2,'Работа с сотрудниками');
INSERT INTO event_subcategory VALUES(10015,1,'Работа с посетителями');
INSERT INTO event_subcategory VALUES(10016,2,'Работа с шаблонами доступа');
INSERT INTO event_subcategory VALUES(10017,2,'Работа с временными критериями доступа');
INSERT INTO event_subcategory VALUES(10025,2,'Работа с событиями прохода');
INSERT INTO event_subcategory VALUES(10032,2,'Работа с ролями операторов');
INSERT INTO event_subcategory VALUES(10036,2,'Работа с оправдательными документами');
INSERT INTO event_subcategory VALUES(10037,2,'Работа с дополнительными данными');
INSERT INTO event_subcategory VALUES(10038,2,'Работа с операторами');
INSERT INTO event_subcategory VALUES(10050,2,'Работа с дизайнами пропуска');
INSERT INTO event_subcategory VALUES(10054,2,'Работа с должностями');
INSERT INTO event_subcategory VALUES(10059,2,'Работа с помещениями');
INSERT INTO event_subcategory VALUES(10061,3,'Работа с планировщиком заданий');
INSERT INTO event_subcategory VALUES(10064,2,'Работа с конфигурацией верификации');
INSERT INTO event_subcategory VALUES(10069,2,'Работа с лицензиями');
INSERT INTO event_subcategory VALUES(11059,2,'Работа с контроллерами');
INSERT INTO event_subcategory VALUES(12000,2,'Учет рабочего времени');
CREATE TABLE `event_verify_result` (
  `id` integer NOT NULL primary key autoincrement,
  `name` varchar(150)  DEFAULT NULL
);
INSERT INTO event_verify_result VALUES(1,'Нет подтверждения');
INSERT INTO event_verify_result VALUES(2,'Проход разрешён оператором');
INSERT INTO event_verify_result VALUES(3,'Проход разрешён автоматически');
INSERT INTO event_verify_result VALUES(4,'Проход запрещён оператором');
INSERT INTO event_verify_result VALUES(5,NULL);
CREATE TABLE `language` (
  `id` integer NOT NULL primary key autoincrement,
  `name` varchar(150)  NOT NULL,
  `code` varchar(10)  NOT NULL,
  `is_active` integer NOT NULL DEFAULT '1'
);
INSERT INTO language VALUES(1,'Русский','ru',1);
INSERT INTO language VALUES(2,'English','en',1);
INSERT INTO language VALUES(3,'Italiano','it',1);
INSERT INTO language VALUES(4,'Español','es',1);
CREATE TABLE `license` (
  `id` integer NOT NULL primary key autoincrement,
  `module_number` integer NOT NULL,
  `name` varchar(150)  NOT NULL,
  `license_key` varchar(24)  DEFAULT NULL,
  `demo_begin_date` datetime DEFAULT NULL,
  `demo_day_count` integer DEFAULT NULL,
  `last_verify` datetime DEFAULT NULL,
  `connection_count` integer DEFAULT NULL,
  `short_name` varchar(150)  NOT NULL,
  `bad_verify_day_count` integer DEFAULT NULL,
  `data` varchar(32)  DEFAULT NULL,
  `license_state_id` integer NOT NULL DEFAULT '0',
  `is_active` integer NOT NULL,
  `description` mediumtext,
  `string_constant` varchar(150)  DEFAULT NULL
);
INSERT INTO license VALUES(4,15,'Базовый пакет',NULL,NULL,60,'now',1,'PERCo-WB',NULL,'8b3376ecf59af1694ab7052aa9cd7197',0,1,'PERCo-WB «Базовый пакет ПО» предназначен для организации системы контроля доступа на предприятии, имеющем в штате не более 100 сотрудников. Базовое ПО поддерживает все основные функции обеспечения безопасности, в том числе: контроль доступа по времени, контроль зональности (antipass), доступ с комиссионированием.<br><br>Раздел «Администрирование» позволяет произвести первичное конфигурирование оборудования системы, добавление операторов системы и ее лицензирование, контролировать работу системы, составляя отчеты о событиях системы.<br><br>Раздел «Персонал» позволяет автоматизировать процесс ввода и хранения учетных данных сотрудников и создания графиков работы. В разделе предусмотрена возможность ведения списка должностей и подразделений предприятия.<br><br>Раздел «Бюро пропусков» позволяет автоматизировать процесс выдачи пропусков сотрудникам предприятия.<br><br>Раздел «Контроль доступа» позволяет автоматизировать формирование отчетов о правах доступа сотрудников. При необходимости оперативного реагирования предусмотрена возможность удаленного управления устройствами системы.','Base');
INSERT INTO license VALUES(5,16,'Стандартный пакет',NULL,NULL,60,'now',1,'PERCo-WS',30,'c07ac6a930e6504cafe19d14b1c15c81',0,0,'PERCo-WS «Стандартный пакет ПО» предназначен для организации полноценной СКУД с поддержкой всех основных функций обеспечения безопасности, в том числе: контроль доступа по времени, контроль зональности (antipass), доступ с комиссионированием.<br><br>Раздел «Администрирование» позволяет произвести первичное конфигурирование оборудования системы, добавление операторов системы и ее лицензирование, контролировать работу системы, составляя отчеты о событиях системы.<br><br>Раздел «Персонал» позволяет автоматизировать процесс ввода и хранения учетных данных сотрудников и создания графиков работы. В разделе предусмотрена возможность ведения списка должностей и подразделений предприятия.<br><br>Раздел «Бюро пропусков» позволяет автоматизировать процесс выдачи пропусков сотрудникам и посетителям предприятия.<br><br>Раздел «Контроль доступа» позволяет автоматизировать формирование отчетов о проходах через турникеты, входах/выходах в помещения. При необходимости оперативного реагирования предусмотрена возможность удаленного управления устройствами системы.<br><br>Раздел «Заказ пропуска» позволяет автоматизировать процесс предварительного заказа пропусков посетителям. Вкладка Заказ пропуска предназначена для заказа пропусков посетителям для последующей выдачи в разделе «Бюро пропусков». Вкладка Архив предназначена для повторного заказа пропусков посетителям, данные которых были сохранены в архиве ранее.','Standart');
INSERT INTO license VALUES(6,17,'Учёт рабочего времени',NULL,NULL,60,'now',1,'PERCo-WM01',30,'2d3e636d970666e2665ed49992bc4248',0,0,'PERCo-WM-01 Модуль «Учет рабочего времени» предназначен для ведения учета рабочего времени сотрудников и составления отчетов о дисциплине труда.<br><br>Раздел «Учет рабочего времени» позволяет автоматизировать построение отчетов об отработанном времени и дисциплине труда, формирование табеля учета рабочего времени в формате Т-13. В разделе предусмотрена возможность добавления новых типов оправдательных документов и документов на сверхурочную работу.<br><br>Для работы раздела необходимо, чтобы каждому сотруднику в подразделе «Сотрудники» раздела «Персонал» был установлен график работы, определяющий его расписание работы, норму рабочего времени, параметры контроля дисциплины труда и место работы (регистрирующие помещения).<br><br>В процессе работы сотрудник предъявляет карту доступа при входе и выходе из регистрирующих помещений. На основании данных о проходах и установленного графика работы автоматически подсчитывается рабочее время сотрудника. Вследствие некорректного предъявления сотрудником карты доступа возможен некорректный подсчет рабочего времени. Контроль и корректировка подобных случаев осуществляется в подразделе «Журнал отработанного времени».<br><br>Для контроля трудовой дисциплины сотрудников используется подраздел «Отчеты по дисциплине». К нарушениям трудовой дисциплины относятся неявка, опоздание, выход в течение рабочего дня, уход раньше.<br><br>Документы на сверхурочную работу оформляются в подразделе «Журнал отработанного времени» или «Сотрудники» раздела «Персонал». При необходимости, новые типы документов создаются в подразделе «Оправдательные документы».','TimeTracking');
INSERT INTO license VALUES(7,18,'Верификация',NULL,NULL,60,'now',1,'PERCo-WM02',30,'1065cd4bc95565a91c178c9667106cfc',0,0,'PERCo-WM-02 Модуль «Верификация» предназначен для усиления контроля доступа на территорию предприятия и предотвращения случаев прохода по чужому пропуску.<br><br>Модуль устанавливается на рабочее место сотрудника службы охраны и позволяет производить идентификацию владельца карты доступа, сравнивая личность проходящего сотрудника или изображение с видеокамеры и его фото, хранящееся в базе данных системы.','Verification');
INSERT INTO license VALUES(8,19,'Интеграция с 1С',NULL,NULL,60,'now',1,'PERCo-WM03',30,NULL,0,0,'PERCo-WM-03 Модуль интеграции с 1С [url href="/1s/1s-module.zip"]Скачать модуль интеграции[/url]','1s');
INSERT INTO license VALUES(9,20,'Интеграция с внешними системами',NULL,NULL,60,'now',1,'PERCo-WM04',30,NULL,0,0,'PERCo-WM-04 Модуль интеграции с внешними системами [url href="/dev"]Документация[/url]','sdk');
CREATE TABLE `message_template` (
  `id` integer NOT NULL primary key autoincrement,
  `name` varchar(150)  NOT NULL,
  `schema_data` json DEFAULT NULL,
  `id_action_type` integer DEFAULT NULL
);
INSERT INTO message_template VALUES(1,'вход , информационное','{"ID_PLC": "465", "ID_USER": "876", "ID_EVENT": "556"}',1);
INSERT INTO message_template VALUES(2,'выход , информационное','{"ID:PLC": "2259", "ID_USER": "777"}',1);
INSERT INTO message_template VALUES(3,'sms , родителям учащегося','{"ID:PLC": "2258", "ID_USER": "1"}',5);
INSERT INTO message_template VALUES(4,'управляющий сигнал "Включить реле"','{"ID:PLC": "2259", "ID_USER": "777", "ID_EVENT_PLC": "56465"}',7);
INSERT INTO message_template VALUES(5,'STASI ACHTUNG MILKE!','{"ID:PLC": "2259", "ID_USER": "777", "ID_EVENT_PLC": "56165"}',8);
INSERT INTO message_template VALUES(6,'Gross Berta feuer !!!','{"ID_PLC": "465", "ID_USER": "876", "ID_EVENT": "556"}',7);
INSERT INTO message_template VALUES(7,'test','{"test": "test", "test1": "test1"}',NULL);
INSERT INTO message_template VALUES(12,'arr','{"plc": [123, 1234, 321]}',NULL);
INSERT INTO message_template VALUES(13,'arr_long','{"plc": [123, 1234, 321], "user": ["Vanya", "Petya"]}',NULL);
CREATE TABLE `message_to_screenshot` (
  `sourcemessage_id` integer NOT NULL,
  `screenshot_id` integer NOT NULL
);
CREATE TABLE `mobile_terminal_device` (
  `id` integer NOT NULL primary key autoincrement,
  `uid` varchar(64)  NOT NULL,
  `name` varchar(150)  DEFAULT NULL,
  `model` varchar(150)  NOT NULL DEFAULT '',
  `is_active` integer NOT NULL DEFAULT '0',
  `device_id` integer DEFAULT NULL,
  CONSTRAINT `mobile_terminal_device_device_id_fk` FOREIGN KEY (`device_id`) REFERENCES `device` (`id`) 
);
CREATE TABLE `plan` (
  `id` integer NOT NULL primary key autoincrement,
  `building` integer DEFAULT NULL,
  `floor` integer DEFAULT NULL,
  `property` mediumtext 
, event_filter mediumtext null);
CREATE TABLE `position` (
  `id` integer NOT NULL primary key autoincrement,
  `is_const` integer NOT NULL DEFAULT '0',
  `name` varchar(255)  NOT NULL,
  `comment` varchar(150)  DEFAULT NULL,
  `is_removed` integer NOT NULL DEFAULT '0'
);
CREATE TABLE `schedule` (
  `id` integer NOT NULL primary key autoincrement,
  `is_const` integer NOT NULL DEFAULT '0',
  `name` varchar(150)  NOT NULL,
  `comment` varchar(150)  DEFAULT NULL,
  `schedule_type_id` integer NOT NULL,
  `date` date DEFAULT NULL
);
INSERT INTO schedule VALUES(1,1,'Никогда',NULL,1,NULL);
INSERT INTO schedule VALUES(2,1,'Всегда',NULL,1,NULL);
INSERT INTO schedule VALUES(3,0,'Праздничное расписание',NULL,5,NULL);
INSERT INTO schedule VALUES(4,0,'Тип 1',NULL,6,NULL);
INSERT INTO schedule VALUES(5,0,'Тип 2',NULL,6,NULL);
INSERT INTO schedule VALUES(6,0,'Тип 3',NULL,6,NULL);
INSERT INTO schedule VALUES(7,0,'Тип 4',NULL,6,NULL);
INSERT INTO schedule VALUES(8,0,'Тип 5',NULL,6,NULL);
INSERT INTO schedule VALUES(9,0,'Тип 6',NULL,6,NULL);
INSERT INTO schedule VALUES(10,0,'Тип 7',NULL,6,NULL);
INSERT INTO schedule VALUES(11,0,'Тип 8',NULL,6,NULL);
CREATE TABLE `schedule_item` (
  `id` integer NOT NULL primary key autoincrement,
  `type` integer NOT NULL,
  `number` integer NOT NULL,
  `schedule_id` integer DEFAULT NULL,
  `parent_id` integer DEFAULT NULL,
  `data` json DEFAULT NULL
);
INSERT INTO schedule_item VALUES(1,1,1,NULL,1,'{"end": "00:00:00", "begin": "00:00:00"}');
INSERT INTO schedule_item VALUES(2,1,1,NULL,2,'{"end": "23:59:00", "begin": "00:00:00"}');
CREATE TABLE `schedule_item_type` (
  `id` integer NOT NULL primary key autoincrement,
  `item` varchar(50)  NOT NULL,
  `description` varchar(150)  DEFAULT NULL
);
INSERT INTO schedule_item_type VALUES(1,'HOUR','Часовой интервал');
INSERT INTO schedule_item_type VALUES(2,'DAY','День недели');
INSERT INTO schedule_item_type VALUES(3,'HOLIDAY','Дата праздника');
INSERT INTO schedule_item_type VALUES(4,'WEEK','Недельное расписание');
INSERT INTO schedule_item_type VALUES(5,'YEAR','Идентификатор годового расписания (зарезервировано для дальнейшего расширения)');
CREATE TABLE `schedule_type` (
  `id` integer NOT NULL primary key autoincrement,
  `name` varchar(150)  NOT NULL,
  `schema_title` varchar(150)  NOT NULL
);
INSERT INTO schedule_type VALUES(0,'Все','all');
INSERT INTO schedule_type VALUES(1,'Временные зоны','time_zone_schedule');
INSERT INTO schedule_type VALUES(2,'Недельный график','weekly_schedule');
INSERT INTO schedule_type VALUES(3,'Скользящий посуточный график','shift_day_schedule');
INSERT INTO schedule_type VALUES(4,'Скользящий понедельный график','shift_weekly_schedule');
INSERT INTO schedule_type VALUES(5,'Праздничное расписание','holiday_schedule');
INSERT INTO schedule_type VALUES(6,'Виртуальное праздничное расписание','virtual_holiday_schedule');
CREATE TABLE `screenshot` (
  `id` integer NOT NULL,
  `name` varchar(150)  DEFAULT NULL,
  `image` longblob NOT NULL
);
CREATE TABLE `sourcemessage` (
  `id` integer NOT NULL primary key autoincrement,
  `category` varchar(32)  NOT NULL,
  `message` mediumtext  NOT NULL,
  `source_file` mediumtext,
  `time_label` datetime DEFAULT NULL,
  `help` integer DEFAULT NULL
);
INSERT INTO sourcemessage VALUES(1269,'public','Действующие','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1270,'public','Уволенные','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1271,'public','Добавить','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1272,'public','Восстановить','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1273,'','Редактировать','','2018-07-04 12:43:14',0);
INSERT INTO sourcemessage VALUES(1274,'public','Уволить','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1275,'public','Удалить','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1276,'public','Заблокировать','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1277,'public','Разблокировать','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1278,'public','Изъять карту','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1279,'public','Дополнительно','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1280,'public','Печать пропусков','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1281,'public','Печать таблицы','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1282,'public','Экспорт в XLS','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1283,'public','Экспорт в CSV','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1284,'public','Поиск по истории учетных данных','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1285,'public','Сбросить фильтры','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1286,'public','Параметры отображения таблицы','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1287,'public','Поиск','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1288,'public','Найти','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1289,'public','Подразделение','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1290,'public','Показать все','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1291,'public','Выбрать из списка','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1292,'public','Сбросить','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1293,'public','Учетная карточка сотрудника','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1294,'public','Фамилия','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1295,'public','Имя','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1296,'public','Отчество','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1297,'public','Табельный номер','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1298,'public','Дата приемa','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1299,'public','Учетные данные','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1300,'public','Не определено','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1301,'public','Должность','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1302,'public','График работы','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1303,'public','Шаблон доступа','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1304,'public','Действуют с','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1305,'public','Планировщик','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1306,'public','Изображения','','2017-07-14 14:34:56',0);
INSERT INTO sourcemessage VALUES(1307,'public','Загрузить с ПК','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1308,'public','Загрузить с веб-камеры','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1309,'public','Удалить изображение','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1310,'public','Дополнительные поля','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1311,'public','Документы','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1312,'public','Идентификатор доступа','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1313,'public','№','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1314,'public','Дата документа','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1315,'public','Тип','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1316,'public','Код','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1317,'public','Дата начала','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1318,'public','Дата окончания','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1319,'public','Длительность','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1320,'public','Карта / идентификатор','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1321,'public','Выдать карту','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1322,'public','Действительно до','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1323,'public','Сохранить','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1324,'public','Сотрудник','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1325,'public','Шаблон','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1326,'public','Блокировка','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1327,'public','Карта','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1328,'public','Фото','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1329,'public','Отображать столбцы по ширине таблицы','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1330,'public','Поиск по наименованию','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1331,'public','Ок','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1332,'public','Добавление нового документа','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1333,'public','Номер документа','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1334,'public','Дата создания','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1335,'public','Тип документа','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1336,'public','Оправдательный','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1337,'public','Сверхурочный','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1338,'public','Имя / наименование','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1339,'public','Дата начала и окончания','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1340,'public','Идентификатор карты','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1341,'public','Получить с контроллера','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1342,'public','Увольнение сотрудника','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1343,'public','Уволить сотрудника с','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1344,'public','Внимание!','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1345,'public','Сотрудник будет перемещен в раздел "уволенные", карта будет изъята.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1346,'public','Восстановление сотрудника','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1347,'public','Вы действительно хотите восстановить сотрудника?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1348,'public','Удаление сотрудника','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1349,'public','Вы действительно хотите удалить сотрудника?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1350,'public','Сотрудник будет удален безвозвратно, его восстановление в дальнейшем будет невозможно.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1351,'public','Блокировка сотрудника','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1352,'public','Вы действительно хотите заблокировать сотрудника?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1353,'public','Разблокировка сотрудника','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1354,'public','Вы действительно хотите разблокировать сотрудника?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1355,'public','Изъятие карты','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1356,'public','Вы действительно хотите изъять карты у сотрудников?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1357,'public','Изъять','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1358,'public','Графики','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1359,'public','Таблица','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1360,'public','Добавить график замены','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1361,'public','Очистить','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1362,'public','Шаблон пропуска','','2017-07-14 14:07:10',0);
INSERT INTO sourcemessage VALUES(1363,'public','Рамка / граница пропуска','','2017-07-14 14:06:21',0);
INSERT INTO sourcemessage VALUES(1364,'public','Стандарт','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1365,'public','Пунктир','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1366,'public','Без рамки','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1367,'public','Печать','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1369,'public','Заказанные','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1370,'public','Архив','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1371,'public','Удалить в архив','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1372,'public','Удалить безвозвратно','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1373,'public','Удаление посетителя в архив','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1374,'public','Вы действительно хотите удалить посетителя в архив?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1375,'public','Карта будет отвязана.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1376,'public','Удаление посетителя','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1377,'public','Вы действительно хотите удалить посетителя?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1378,'public','Посететитель будет удален безвозвратно, его восстановление в дальнейшем будет невозможно.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1379,'public','Блокировка посетителя','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1380,'public','Вы действительно хотите заблокировать посетителя?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1381,'public','Разблокировка посетителя','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1382,'public','Вы действительно хотите разблокировать посетителя?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1383,'public','Посетитель','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1384,'public','Документ','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1385,'public','Сопровождающий','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1386,'public','Действителен с','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1387,'public','Действителен до','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1388,'public','Учетные данные посетителя','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1389,'public','Сопровождающий документ','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1390,'public','Фотография','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1391,'public','Дата события','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1392,'public','Событие','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1393,'public','Устройство','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1394,'public','IP-адрес','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1395,'public','Ресурс устройства','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1396,'public','Карта №','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1397,'public','Таб. №','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1398,'public','Сотрудник/Посетитель','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1399,'public','Помещение','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1400,'public','Категория','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1401,'public','Подкатегория','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1402,'public','Дата добавления','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1403,'public','Загрузка, подождите.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1405,'public','Обновить данные','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1406,'public','Журнал событий','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1407,'public','Время окончания действия пропуска, шаблон доступа и все параметры временной замены прав доступа будут удалены.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1408,'public','Редактирование пропуска сотрудника','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1409,'public','Заказ пропуска','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1410,'public','Удаление пропуска в архив','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1411,'public','Вы действительно хотите удалить заказанный пропуск в архив?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1412,'public','Нет доступных подразделений.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1413,'public','Не выбрано ни одного элемента','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1414,'public','Подразделения сброшены','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1415,'public','Посетитель удален в архив','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1416,'public','Посетитель удален','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1417,'public','Посетитель заблокирован','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1418,'public','Посетитель разблокирован','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1419,'public','Фильтры сортировки сброшены','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1420,'public','Неверно заполнены поля','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1421,'public','Сохранено','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1422,'public','Посетитель не сохранен! Неверно заполнены поля.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1423,'public','Нет доступных подразделений','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1424,'public','Нет доступных шаблонов доступа','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1425,'public','Нет сотрудников из доступных подразделений','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1426,'public','Загрузка...','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1427,'public','Ошибка','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1428,'public','Сотрудник заблокирован','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1429,'public','Сотрудник разблокирован','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1430,'public','Карта изъята','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1431,'public','Введите идентификатор','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1432,'public','Неверный идентификатор','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1433,'public','Карта уже привязана к другому посетителю','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1434,'public','Сканирование...','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1435,'public','Пропуск сотрудника не сохранен! Неверно заполнены поля.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1436,'public','Производилась смена учетных данных. При открытии планировщика, параметры не будут сохранены. Продолжить?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1437,'public','Сотрудник уволен','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1438,'public','Сотрудник восстановлен','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1439,'public','Сотрудник удален','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1440,'public','Не сохранять','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1441,'public','Заполните все обязательные поля','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1442,'public','Сотрудник не сохранен! Неверно заполнены поля.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1443,'public','График','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1444,'public','Нет доступных наименований документов для добления.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1445,'public','Дата начала не может быть позже даты окончания.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1446,'public','Дата создания документа не может быть раньше даты приема на работу.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1447,'public','Наименование документа не может быть пустым.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1448,'public','Нет доступных должностей','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1449,'public','Нет доступных графиков работы','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1450,'public','Выберите тип','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1451,'public','Выберите имя','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1452,'public','Доступ','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1453,'public','Сохранить изменения?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1454,'public','Добавить событие изменения учетных данных / интервал временной замены','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1455,'public','Точно?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1456,'public','Дата начала интервала должна быть раньше даты окончания.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1457,'public','Подразделение должно быть указано.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1458,'public','В будущем может содержаться только одно событие изменения учетных данных.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1459,'public','Событие измения учетных данных с такой датой начала уже существует.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1460,'public','Временные замены не должны пересекаться.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1461,'public','Нельзя создавать интервал временной замены, в остутствии события изменения учетных данных.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1462,'public','Интервал временной замены не может начинаться раньше события изменения учетных данных.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1463,'public','Должен быть хоть один интервал «подразделения».','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1464,'public','Должен быть хоть один интервал «блокировки».','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1465,'public','Учетные данные и параметры замены обновлены','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1466,'public','Ошибка сохранения','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1467,'public','Операция','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1468,'public','Дата конца','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1469,'public','Значение','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1470,'public','ID','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1471,'public','Значение не выбрано','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1472,'public','Редактировать событие изменения учетных данных','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1473,'public','Редактировать интервал временной замены','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1474,'public','ФИО','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1475,'public','Дата','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1476,'public','Откуда/Куда','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1477,'public','Подтверждающий документ','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1478,'public','Выберите помещение','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1479,'public','Временной интервал не корректен','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1480,'public','Вс','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1481,'public','Пн','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1482,'public','Вт','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1483,'public','Ср','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1484,'public','Чт','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1485,'public','Пт','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1486,'public','Сб','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1487,'public','Январь','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1488,'public','Февраль','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1489,'public','Март','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1490,'public','Апрель','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1491,'public','Май','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1492,'public','Июнь','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1493,'public','Июль','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1494,'public','Август','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1495,'public','Сентябрь','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1496,'public','Октябрь','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1497,'public','Ноябрь','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1498,'public','Декабрь','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1499,'public','Не выбрано','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1500,'public','Помещения','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1501,'public','Все','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1502,'public','Посетители','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1503,'public','Персонал','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1504,'public','Применить','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1505,'public','Доступ к помещениям','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1506,'public','Понедельник','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1507,'public','Вторник','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1508,'public','Среда','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1509,'public','Четверг','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1510,'public','Пятница','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1511,'public','Суббота','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1512,'public','Воскресенье','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1513,'public','Название','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1514,'public','Тип графика','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1515,'public','Описание','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1516,'public','Скр','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1517,'public','Не выбран график','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1518,'public','Служебный график редактировать запрещено.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1519,'public','Служебный график копировать запрещено.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1520,'public','Служебный график удалять запрещено.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1521,'public','Вход','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1522,'public','Выход','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1523,'public','Пользователь','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1524,'public','Действие','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1525,'public','Выбрать месяц','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1526,'public','Сформировать Т12','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1527,'public','Номер карты','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1528,'public','Вы действительно хотите удалить этот (эти) график(и)?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1529,'public','Выбранный график не может быть удален, так как используется следующими людьми: ','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1530,'public','Смена типа графика сбросит все временные интервалы. Вы действительно хотите продолжить?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1531,'public','Вы действительно хотите выйти без сохранений?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1532,'public','Пустое имя','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1533,'public','Часы должны быть заданы в интервале от 0 до 23','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1534,'public','График содержит ошибочные интервалы','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1535,'public','Минуты должны быть заданы в интервале от 0 до 59','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1536,'public','Скользящие интервалы не могут использоваться с переменными интервалами','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1537,'public','Постоянная величина не может быть больше рабочего времени','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1538,'public','Постоянная величина не может равняться 0','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1539,'public','Данное имя уже используется','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1540,'public','Не указана дата начала смены','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1541,'public','Выбранные сутки содержат переменный инервал. Удалите его','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1542,'public','Дней не может быть больше 30','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1543,'public','Необходимо выбрать сутки','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1544,'public','Дней не может быть меньше 1','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1545,'public','Рабочее время','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1546,'public','ч','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1547,'public','м','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1548,'public','Постоянная величина','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1549,'public','День','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1550,'public','Добавление графика работы','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1551,'public','Редактирование графика работы','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1552,'public','Копирование графика работы','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1553,'public','Января','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1554,'public','Февраля','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1555,'public','Марта','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1556,'public','Апреля','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1557,'public','Мая','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1558,'public','Июня','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1559,'public','Июля','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1560,'public','Августа','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1561,'public','Сентября','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1562,'public','Октября','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1563,'public','Ноября','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1564,'public','Декабря','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1565,'public','Обычный день','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1566,'public','Праздник','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1567,'public','Предпраздничный день','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1568,'public','Рабочий выходной','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1569,'public','Пометка','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1570,'public','Наименование не может быть пустым','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1571,'public','Дата переноса должна быть указана','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1572,'public','Сотрудники','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1573,'public','Присутствие','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1574,'public','Отсутствие','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1575,'public','Работа ночью','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1576,'public','Переработка','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1577,'public','Баланс отработанного времени','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1578,'public','Оправдательные документы','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1579,'public','Ошибки','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1580,'public','Детали','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1581,'public','Есть','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1582,'public','в помещение','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1583,'public','из помещения','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1584,'public','Время присутствия','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1585,'public','Время прохода','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1586,'public','Тип прохода','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1587,'public','Участвует в расчетах','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1588,'public','№ документа','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1589,'public','Наименование документа','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1590,'public','Продолжительность','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1591,'public','Начало действия документа','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1592,'public','Конец действия документа','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1593,'public','Подразделение...','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1594,'public','Перемещения','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1595,'public','Закрыть','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1596,'public','Закрыть и пересчитать','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1597,'public','Праздничные дни','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1598,'public','Копировать','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1599,'public','Заполнить предопределенными значениями','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1600,'public','Ночное время с','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1602,'public','Вечернее время с','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1603,'public','Вечернее время','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1605,'public','Имя графика','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1606,'public','Недельный','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1607,'public','Суточный','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1609,'public','Описание графика','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1610,'public','Не учитывать праздники (только для недельных графиков)','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1611,'public','Учитывать только первый и последний выход','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1612,'public','Интервалы','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1613,'public','Регистрирующие помещения','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1614,'public','Настройки отчетов','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1615,'public','Дата начала смены','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1616,'public','Добавить день','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1618,'public','Удалить день','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1619,'public','Учет','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1620,'public','Контроль дисциплины','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1621,'public','Контроль','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1622,'public','прихода ранее чем за','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1623,'public','задержки более чем на','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1624,'public','Не считать нарушением, разрешить','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1625,'public','опоздание не более чем на','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1626,'public','уход раньше не более чем на','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1627,'public','Не считать нарушением, разрешить (для скользящих дней смены)','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1628,'public','Наименование','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1629,'public','Величина сокращения','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1630,'public','Дата переноса','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1631,'public','Календарь предопределенных значений','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1632,'public','Основные поля: ','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1633,'public','Добавить подразделение','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1634,'public','Редактировать подразделение','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1635,'public','Удалить подразделение','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1636,'public','Значения по умолчанию','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1637,'public','Шаблон доступа для сотрудников','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1638,'public','Шаблон доступа для посетителей','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1639,'public','Шаблоны доступа','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1640,'public','Графики работы','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1641,'public','Имя подразделения','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1645,'public','Должности','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1647,'public','Должность не выбрана','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1648,'public','Служебную запись запрещено редактировать','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1649,'public','Вы действительно хотите удалить должность?','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1650,'public','Добавить должность','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1651,'public','Редактировать должность','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1652,'public','Должность не может быть пустой','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1653,'public','Должность с таким именем уже существует','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1654,'public','по','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1657,'public','Удалить должность','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1658,'public','Текстовый','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1659,'public','Графический','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1660,'public','Название поля','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1661,'public','Тип поля','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1662,'public','Не выбрано поле','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1663,'public','Вы действительно хотите удалить это поле?','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1664,'public','Добавить поле','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1665,'public','Редактировать поле','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1666,'public','Удалить поле','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1670,'public','Вернуть значение','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1671,'public','Смена года. Вы действительно хотите продолжить?','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1673,'public','сб','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1674,'public','вс','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1675,'public','Запретить доступ','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1676,'public','Разрешить доступ','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1677,'public','Временные зоны','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1678,'public','Сменный суточный','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1679,'public','Скользящий недельный','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1680,'public','Доступ и постановка/снятие на/с охран(у/ы)','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1681,'public','Доступ и постановка/снятие на/с охран(у/ы) с комиссионированием','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1682,'public','Доступ с комиссионированием','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1683,'public','Доступ с комиссионированием и постановка/снятие на/с охран(у/ы) с комиссионированием','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1684,'public','Пред','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1685,'public','След','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1712,'public','Не','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1713,'public','Служебный шаблон удалять запрещено','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1714,'public','Не выбран шаблон','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1715,'public','Вы действительно хотите удалить этот шаблон?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1716,'public','Копировать можно только один шаблон','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1717,'public','Служебный шаблон копировать запрещено','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1718,'public','Копия','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1719,'public','Добавление шаблона','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1720,'public','Редактирование шаблона','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1721,'public','Копирование шаблона','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1722,'public','Редактирование шаблонов','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1723,'public','Новый шаблон','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1724,'public','Служебный шаблон редактировать запрещено','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1725,'public','Необходимо установить хотя бы один доступ','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1726,'public','Имя графика обязательно для заполнения','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1727,'public','Имя шаблона обязательно для заполнения','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1728,'public','Шаблон с таким именем уже существует','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1729,'public','Дни особого типа','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1730,'public','Служебные временные интервалы запрещено редактировать','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1733,'public','Необходимо выбрать временную зону!','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1734,'public','Служебные недельные графики запрещено редактировать','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1735,'public','Необходимо выбрать недельный график','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1736,'public','Служебные сменные суточные графики запрещено редактировать','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1737,'public','Дней в графике не может быть больше 30','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1738,'public','Никогда','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1739,'public','Необходимо выбрать график!','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1740,'public','Неделей в графике не может быть больше 30','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1741,'public','Доступ запрещён','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1742,'public','Шаблоны','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1743,'public','Календарь праздников для недельных графиков','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1744,'public','Имя шаблона','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1745,'public','Описание шаблона','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1746,'public','Тип права','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1747,'public','Antipass','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1748,'public','Защита от передачи карт','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1749,'public','Нет','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1750,'public','Недельные режимы доступа','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1751,'public','Редактировать недельный график','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1752,'public','Редактировать временной интервал','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1753,'public','Сменные суточные режимы доступа','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1754,'public','Редактировать сменный суточного режима доступа','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1755,'public','Добавить временной интервал','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1756,'public','Удалить временной интервал','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1757,'public','Добавить сменный суточный график','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1758,'public','Удалить сменный суточный график','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1759,'public','Начало смены','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1760,'public','Скользящие недельные режимы доступа','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1761,'public','Редактировать сменный недельного режима доступа','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1762,'public','Добавить недельный график','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1763,'public','Удалить недельный график','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1787,'public','Тип шаблона','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1788,'public','Смена типа шаблона очистит пропуск. Вы действительно хотите продолжить?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1789,'public','Добавление шаблона пропуска','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1790,'public','Редактирование шаблона пропуска','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1791,'public','Копирование шаблона пропуска','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1792,'public','Элемент выходит за пределы шаблона','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1793,'public','Некоректные размеры','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1794,'public','Редактировать можно только произвольный текст','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1795,'public','Для персонала','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1796,'public','Для посетителей','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1797,'public','Положение и размеры','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1798,'public','Выше','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1799,'public','Ниже','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(1800,'public','Положение левого верхнего угла по оси X','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1801,'public','Положение левого верхнего угла по оси Y','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1802,'public','Длина','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1803,'public','Ширина','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1804,'public','Поместить на пропуск','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1805,'public','Параметры области','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1806,'public','Цвет фона','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1807,'public','Стиль линии','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1808,'public','Цвет линии','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1809,'public','Толщина линии','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1810,'public','Параметры текста','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1811,'public','Полужирный','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1812,'public','Курсив','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1813,'public','Подчеркивание','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1814,'public','Цвет текста','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1815,'public','Изменить текст','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1816,'public','Шрифт','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1817,'public','Кегль','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1818,'public','Перетащите необходимые поля на пропуск','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1819,'public','Текстовые поля','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1820,'public','Для пропуска','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1821,'public','Графические поля','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1822,'public','Дополнительные','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1823,'public','Произвольный текст','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1824,'public','Название типа документа','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1825,'public','Код документа буквенный','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1826,'public','Код документа числовой','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1827,'public','Добавляется к рабочему времени','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1828,'public','Способ исчисления','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1829,'public','Добавить к рабочему времени','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1830,'public','Сверхурочные в праздничные и выходные дни','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1831,'public','В рабочих днях','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1832,'public','В календарных днях включая праздничные дни','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1833,'public','В календарных днях исключая праздничные дни','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1834,'public','Добавлять','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1835,'public','Сверхурочные','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1836,'public','Не выбран документ','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1837,'public','Добавить тип документа','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1838,'public','Редактировать тип документа','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1839,'public','Название типа документа не может быть пустой','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1840,'public','Код документа должен быть заполнен','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1841,'public','Буквенный код документа не может быть больше 2-х символов','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1842,'public','Тип документа с данным буквенным кодом уже существует','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1843,'public','Тип документа с данным цифровым кодом уже существует','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1844,'public','Цифровой код должен быть от 0 до 99','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1845,'public','Цифровой код документа не может быть больше 2-х символов','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1846,'public','Документ с таким именем уже существует','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1847,'public','Оправдательные','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1848,'public','Добавить документ','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1849,'public','Редактировать документ','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1850,'public','Удалить документ','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1851,'public','Название документа','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1852,'public','Логин','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1853,'public','Роль','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1854,'public','Контроллер','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1855,'public','Заблокирован','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1856,'public','Не выбран оператор','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1857,'public','Служебного оператора удалять запрещено','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1858,'public','Служебного оператора блокировать запрещено','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1859,'public','Роли еще не созданы. Добавьте роль, чтобы продолжть добавление пользователей.','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1860,'public','Пароль и подтверждения не совпадают','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1861,'public','Имя пользователя должно быть заполнено','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1862,'public','Необходимо указать пароль','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1863,'public','Имя пользователя уже используется','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1864,'public','Пароль должен быть длиннее 6 символов и содержать хотя бы одну букву латинского алфавита или цифру','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1865,'public','Добавление оператора','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1866,'public','Редактирование оператора','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1867,'public','Внимание, Это критически важный пользователь, в случае утери пароля, доступ к системе будет невозможен','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1868,'public','Необходимо выбрать оператора','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1869,'public','Выберите оператора','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1870,'public','У вас нет выбранных пунктов меню','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1871,'public','Разделы','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1873,'public','Полномочия','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1874,'public','Добавить оператора','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1875,'public','Пароль','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1876,'public','Подтверждение','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1877,'public','Активность','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1878,'public','Не выбрана роль','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1879,'public','Имя роли должно быть заполнено','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1880,'public','Имя роли уже используется','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1881,'public','Добавление роли','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1882,'public','Редактирование роли','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1883,'public','Подразделения','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1884,'public','Шаблоны пропусков','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1885,'public','Контроллеры','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1886,'public','Добавить Роль','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1887,'public','Данное имя уже используется. Придумайте другое','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1888,'public','Новое имя','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1890,'public','Данный контроллер уже добавлен в','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1891,'public','Нельзя создавать 2 корневых узла','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1892,'public','Список комиссионирующих карт','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1893,'public','Не может быть пустым','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1894,'public','Значение должно быть от 0 до 251','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1895,'public','Оба помещения должны быть указаны','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1897,'public','Вы пытаетесь выбрать территорию, которая Вам не доступна','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1898,'public','Необходимо выбрать одно помещение','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1899,'public','Помещения должны отличаться','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1900,'public','Это помещение Вам не доступно','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1901,'public','Вы действительно хотите отвязать выбранный контроллер?','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1902,'public','Вы действительно хотите удалить это помещение?','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1903,'public','Выберите помещение / контроллер','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1904,'public','Необходимо восстановить контроллер','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1905,'public','Контроллер привязан к помещению. Удалите его','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1906,'public','Выберите контроллер','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1907,'public','Нельзя удалить контроллер с дочерними котроллерами','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1908,'public','Вы действительно хотите удалить этот контроллер?','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1909,'public','Вы действительно хотите удалить выбранный контроллер? Все его события также будут удалены','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1910,'public','Дочерние контроллеры активировать нельзя','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1911,'public','Дочерние контроллеры деактивировать нельзя','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1912,'public','Выберите помещение или контроллер','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1913,'public','Контроллеры можно добавлять только в помещение','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1914,'public','В неконтролируемое помещение переносить контроллер нельзя','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1915,'public','Помещение не выбрано','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1916,'public','Устройство не выбрано','','2017-12-22 09:48:39',0);
INSERT INTO sourcemessage VALUES(1917,'public','Необходимо выбрать один контроллер','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1919,'public','Количество карт выше допустимого!','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1920,'public','Вы действительно хотите удалить этих людей?','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1921,'public','Генератор тревоги','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1922,'public','Считыватель','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1923,'public','Исполнительное устройство','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1924,'public','Охранная зона','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1925,'public','Ресурс','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1926,'public','Причина сброса','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1927,'public','Не задан','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1928,'public','Дополнительный вход №1','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1929,'public','Дополнительный вход №2','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1930,'public','Турникет','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1931,'public','Замок','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1932,'public','Дополнительный выход','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1933,'public','Дополнительный выход №1','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1934,'public','Дополнительный выход №2','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1935,'public','Дополнительный выход №3','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1936,'public','Дополнительный выход №4','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1937,'public','Контроллер замка (CL05) 1','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1938,'public','ЛИКОН1','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1939,'public','Контроллер турникета1','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1940,'public','Контроллер турникета1-8','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1941,'public','Контроллер замка1','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1942,'public','Контроллер замка1-8','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1943,'public','Контроллер замка2-8','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1944,'public','Электронная проходная (KT2.3) 1','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1945,'public','Электронная проходная (KT2.3) 1-8','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1946,'public','Электронная проходная (KR05) 1','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1947,'public','Электронная проходная (KR05) 1-8','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1948,'public','Электронная проходная с картоприёмником1','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1949,'public','Электронная проходная с картоприёмником1-8','#св-ва_контроллера','2016-04-13 14:05:01',0);
INSERT INTO sourcemessage VALUES(1950,'public','Контроллер АТП1','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1951,'public','Контроллер АТП1-8','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1952,'public','Контроллер замка второго уровня1','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1953,'public','Контроллер второго уровня','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1954,'public','Стойка турникета','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1955,'public','Контроллер замка','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1956,'public','1 CL05Контроллер замка1','#св-ва_контроллера','2016-04-13 14:06:48',0);
INSERT INTO sourcemessage VALUES(1957,'public','4 5 Контроллер турникета1-8','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1958,'public','400 Контроллер турникета1-8 [Стойка турникета. Виртуальный контроллер второго уровня]','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1959,'public','401 Контроллер турникета1-8 [CL201. Контроллер второго уровня]','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1960,'public','6 2 Контроллер замка1-8','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1961,'public','600 Контроллер замка1-8 [Контроллер второго уровня (Виртуальный или CL201)]','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1962,'public','7 3 Контроллер замка2-8','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1963,'public','700 Контроллер замка2-8 [Контроллер второго уровня (Виртуальный или CL201)]','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1964,'public','Активизировать','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1965,'public','В РЕЖИМЕ РАБОТЫ "Закрыто"','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1966,'public','В РЕЖИМЕ РАБОТЫ "Контроль"','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1967,'public','В РЕЖИМЕ РАБОТЫ "Охрана"','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1968,'public','В РЕЖИМЕ РАБОТЫ "Совещание"','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1969,'public','Верифицировать идентификаторы ПОСЕТИТЕЛЕЙ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1970,'public','Верифицировать идентификаторы СОТРУДНИКОВ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1971,'public','Внутренняя защита от передачи идентификаторов (Local Antipass)','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1972,'public','Время','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1973,'public','Время активизации','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1974,'public','Время ожидания комиссионирования','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1975,'public','Время ожидания подтверждения при верификации','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1976,'public','Время удержания в разблокированном состоянии (время анализа идентификатора)','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1977,'public','Генератор тревоги (1)','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1978,'public','Генератор тревоги (1,2)','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1979,'public','Генератор тревоги (3-10)','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1980,'public','Генерация тревоги по датчику вскрытия корпуса','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1981,'public','Генерация тревоги по недопустимо долгому открытию ИУ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1982,'public','Генерация тревоги при несанкционированной разблокировке ИУ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1983,'public','Генерация тревоги при предъявлении идентификатора','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1984,'public','Громкая','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1985,'public','Да','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1986,'public','Дополнительные входы','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1987,'public','Дополнительные входы, маскируемые при активизации','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1988,'public','Дополнительные входы, маскируемые при разблокировке ИУ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1989,'public','Дополнительные выходы','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1990,'public','Дополнительные выходы, активизируемые при активизации','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1991,'public','Дополнительные выходы, активизируемые при предъявлении валидных идентификаторов ПОСЕТИТЕЛЕЙ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1992,'public','Дополнительные выходы, активизируемые при предъявлении валидных идентификаторов СОТРУДНИКОВ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1993,'public','Дополнительные выходы, активизируемые при разблокировке ИУ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1994,'public','Дополнительные выходы, нормализируемые при разблокировке ИУ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1995,'public','Дополнительные выходы, нормализуемые при активизации','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1996,'public','Если ИДЕНТИФИКАТОР ЗАПРЕЩЁН','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1997,'public','Если ИДЕНТИФИКАТОР ИЗ СТОП-ЛИСТА','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1998,'public','Если ИДЕНТИФИКАТОР НЕ ЗАРЕГИСТРИРОВАН','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(1999,'public','Если ИСТЁК СРОК ДЕЙСТВИЯ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2000,'public','Если НАРУШЕН РЕЖИМ РАБОТЫ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2001,'public','Если НАРУШЕНА ЗОНАЛЬНОСТЬ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2002,'public','Если НАРУШЕНО ВРЕМЯ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2003,'public','Если НАРУШЕНО КОМИССИОНИРОВАНИЕ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2004,'public','Жёсткая','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2005,'public','Жёсткий','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2006,'public','Закрыть (заблокировать) ИУ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2007,'public','Замкнут','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2008,'public','Запитан','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2009,'public','Запрещение ДУ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2010,'public','Защита от передачи идентификаторов ПОСЕТИТЕЛЕЙ (Antipass)','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2011,'public','Защита от передачи идентификаторов СОТРУДНИКОВ (Antipass)','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2012,'public','Импульсный','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2013,'public','Команды считывателя','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2014,'public','Команды управления выходом','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2015,'public','Команды управления тревогой СКУД','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2016,'public','Контроль времени для идентификаторов ПОСЕТИТЕЛЕЙ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2017,'public','Контроль времени для идентификаторов ПОСЕТИТЕЛЕЙ (Antipass)','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2018,'public','Контроль времени для идентификаторов СОТРУДНИКОВ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2019,'public','Контроль времени для идентификаторов СОТРУДНИКОВ (Antipass)','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2020,'public','Критерий активизации','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2021,'public','Критерий маскирования','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2022,'public','Критерий нормализации','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2023,'public','Мягкая','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2024,'public','Мягкий','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2025,'public','На время срабатывания','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2026,'public','На время срабатывания и после срабатывания','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2027,'public','На указанное время','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2028,'public','Не запитан','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2029,'public','Новый элемент','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2030,'public','Нормализация выхода ИУ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2031,'public','Нормализовать','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2032,'public','Нормально замкнут','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2033,'public','Нормально разомкнут','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2034,'public','Нормальное (т.е. заблокированное) состояние контакта (вход ИУ)','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2035,'public','Нормальное состояние','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2036,'public','Нормальное состояние "Закрыто " выхода ИУ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2037,'public','Нормальное состояние контакта','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2038,'public','Обычный','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2039,'public','Открыть (разблокировать) ИУ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2040,'public','Поднять тревогу','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2041,'public','Подтверждение от ДУ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2042,'public','После "Закрытия"','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2043,'public','После "Открытия"','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2044,'public','Потенциальный','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2045,'public','Предельное время разблокировки','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2046,'public','При проходе','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2047,'public','При проходе с НАРУШЕНИЕМ ВРЕМЕНИ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2048,'public','При проходе с НАРУШЕНИЕМ ЗОНАЛЬНОСТИ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2049,'public','Прямое направление прохода','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2050,'public','Разомкнут','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2051,'public','Регистрация прохода по предъявлению идентификатора','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2052,'public','Режим работы выхода управления ИУ','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2053,'public','Сброс сирены (Выход "С" ОПС)','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2054,'public','Сброс тревоги (Генератор тревоги)','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2055,'public','Сбросить тревогу','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2056,'public','Специальный','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2057,'public','Тихая','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2058,'public','Установить режим работы "Закрыто"','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2059,'public','Установить режим работы "Контроль"','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2060,'public','Установить режим работы "Открыто"','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2061,'public','Установить режим работы "Совещание"','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2062,'public','Активировать','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2063,'public','Деактивировать','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2064,'public','Передать изменения конфигурации в контроллеры','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2065,'public','Передать всю конфигурацию в контроллеры','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2066,'public','Команда','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2067,'public','Перетащить','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2068,'public','Поиск устройств','','2017-12-22 10:31:46',0);
INSERT INTO sourcemessage VALUES(2069,'public','Поиск устройств по IP','','2017-12-22 10:32:12',0);
INSERT INTO sourcemessage VALUES(2070,'public','Добавить контроллер','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2071,'public','Найти устройства по IP-адресу','','2017-12-22 09:42:09',0);
INSERT INTO sourcemessage VALUES(2073,'public','день соответствует 1-му типу;','#дни_замены','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2074,'public','день соответствует 2-му типу;','#дни_замены','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2075,'public','день соответствует 3-му типу;','#дни_замены','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2076,'public','день соответствует 4-му типу;','#дни_замены','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2077,'public','день соответствует 5-му типу;','#дни_замены','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2078,'public','день соответствует 6-му типу;','#дни_замены','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2079,'public','день соответствует 7-му типу;','#дни_замены','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2080,'public','день соответствует 8-му типу;','#дни_замены','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2081,'public','События контроллеров системы безопасности','EVENT_CATEGORY','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2082,'public','Изменение учетных данных','EVENT_CATEGORY','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2083,'public','События сервера оборудования','EVENT_CATEGORY','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2084,'public','13.2 События связанные с доступом по коду идентификатора (категория 1)','EVENT_SUBCATEGORY','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2085,'public','13.3 События, связанные с изменениями состояний ОЗ (категория 2)','EVENT_SUBCATEGORY','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2086,'public','13.4 События, связанные с изменением текущего состояния ШС, входящих в ОЗ (категория 3)','EVENT_SUBCATEGORY','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2087,'public','13.5 События связанные с состояниями входов/выходов (категория 4)','EVENT_SUBCATEGORY','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2088,'public','13.6 События, связанные с проходами через ИУ без идентификаторов (категория 5)','EVENT_SUBCATEGORY','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2089,'public','13.7 События связанные с функционированием (категория 6)','EVENT_SUBCATEGORY','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2090,'public','Действия пользователя','EVENT_SUBCATEGORY','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2091,'public','Взаимодействие с базой данных','EVENT_SUBCATEGORY','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2092,'public','Соединение с контроллером','EVENT_SUBCATEGORY','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2093,'public','Взаимодействие с web- сервером','EVENT_SUBCATEGORY','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2095,'public','Взятие ИУ на охрану: ИУ перешел в режим ВЗЯТИЕ','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2096,'public','Взятие ОЗ на охрану по идентификатору: ОЗ перешла в режим ВЗЯТИЕ','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2097,'public','Взятие ОЗ на охрану по команде оператора: ОЗ перешла в режим ВЗЯТИЕ','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2098,'public','Взятие ОШС на охрану: ОШС перешел в режим ВЗЯТИЕ','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2099,'public','Восстановление ОШС в режиме ТРЕВОГА','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2100,'public','ИУ взят на охрану: ИУ перешел в режим ОХРАНА','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2101,'public','ИУ снят с охраны: ИУ перешел в режим СНЯТ, в том числе и если стоит "снять при невзятии"','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2102,'public','Корпус извещателя вскрыт','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2103,'public','Корпус извещателя закрыт: ','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2104,'public','Нарушение ИУ, режим ТРЕВОГА: ИУ перешел в режим ТРЕВОГА','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2105,'public','Нарушение ОШС в режиме ТРЕВОГА','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2106,'public','Нарушение ОШС, режим ТРЕВОГА с опцией тихая: ОШС перешел в режим ТРЕВОГА, в том числе и если стоит "тревога при невзятии"','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2107,'public','Нарушение ОШС, режим ТРЕВОГА: ОШС перешел в режим ТРЕВОГА, в том числе и если стоит "тревога при невзятии"','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2108,'public','Нарушение снятого ОШС','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2109,'public','Нормализация снятого ОШС','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2110,'public','ОЗ взята на охрану по идентификатору с подтверждением: ОЗ перешла в режим ОХРАНА','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2111,'public','ОЗ взята на охрану по идентификатору: ОЗ перешла в режим ОХРАНА','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2112,'public','ОЗ взята на охрану по команде оператора: ОЗ перешла в режим ОХРАНА','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2113,'public','ОЗ снята с охраны по идентификатору с подтверждением: ОЗ перешла в режим СНЯТА','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2114,'public','ОЗ снята с охраны по идентификатору: ОЗ перешла в режим СНЯТА','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2115,'public','ОЗ снята с охраны по команде оператора: ОЗ перешла в режим СНЯТА','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2116,'public','ОШС взят на охрану: ОШС перешел в режим ОХРАНА','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2117,'public','ОШС не взят на охрану: ОШС перешел в режим АВТОПЕРЕВЗЯТИЕ','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2118,'public','ОШС отключен','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2119,'public','ОШС снят с охраны: ОШС перешел в режим СНЯТ, в том числе и если стоит "снять при невзятии"','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2120,'public','Попытка взятия ОЗ (невозможно взять) по идентификатору: нарушение комиссионирования','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2121,'public','Попытка взятия ОЗ (невозможно взять) по идентификатору: нарушение состояния ресурса ИУ','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2122,'public','Попытка взятия ОЗ (невозможно взять) по идентификатору: нарушение состояния ресурса ШС (если стоит "снять при невзятии")','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2123,'public','Попытка взятия ОЗ (невозможно взять) по идентификатору: несоответствие временным критериям доступа и текущему местоположению','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2124,'public','Попытка взятия ОЗ (невозможно взять) по идентификатору: несоответствие временных критериев доступа','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2125,'public','Попытка взятия ОЗ (невозможно взять) по идентификатору: несоответствие текущему местоположению','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2126,'public','Попытка взятия ОЗ (невозможно взять) по идентификатору: отказ в подтверждении взятия от верификации','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2127,'public','Попытка взятия ОЗ (невозможно взять) по идентификатору: отказ от постановки','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2128,'public','Попытка взятия ОЗ (невозможно взять) по команде оператора: нарушение состояния ресурса ИУ','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2129,'public','Попытка взятия ОЗ (невозможно взять) по команде оператора: нарушение состояния ресурса ШС (если стоит "снять при невзятии")','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2130,'public','Попытка снятия ОЗ (невозможно снять) по идентификатору: нарушение комиссионирования','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2131,'public','Попытка снятия ОЗ (невозможно снять) по идентификатору: несоответствие временным критериям доступа и текущему местоположению','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2132,'public','Попытка снятия ОЗ (невозможно снять) по идентификатору: несоответствие временных критериев доступа','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2133,'public','Попытка снятия ОЗ (невозможно снять) по идентификатору: несоответствие текущему местоположению','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2134,'public','Попытка снятия ОЗ (невозможно снять) по идентификатору: отказ в подтверждении снятия от верификации','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2135,'public','Попытка снятия ОЗ (невозможно снять) по идентификатору: отказ от снятия','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2136,'public','Сброс тревоги ИУ','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2137,'public','Сброс тревоги ОШС','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2138,'public','Сброс тревоги по ОЗ','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2139,'public','Тихая тревога по ОЗ: ОЗ перешла в режим ТРЕВОГА, в том числе и если стоит "тревога при невзятии"','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2140,'public','Тревога по ОЗ: ОЗ перешла в режим ТРЕВОГА, в том числе и если стоит "тревога при невзятии"','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2141,'public','Автономный сброс тревоги: Кнопкой "Сброс"','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2142,'public','Активация выхода невозможна, причина - КЗ: Только для выходов с контролем состояния','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2143,'public','Активизация входа','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2144,'public','Активизация выхода','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2145,'public','Включение питания контроллера','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2146,'public','Восстановление ИП +18В: Формируется встроенным АЦП при возвращении напряжения питания ШС в рабочий диапазон','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2147,'public','Восстановление ИП: При условии, что напряжение питания в рабочем диапазоне.','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2148,'public','Восстановление выхода: Только для выходов с контролем состояния. Восстановление линии после КЗ или обрыва.','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2149,'public','Восстановление после неисправности контроллера 2-го уровня','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2150,'public','Восстановление связи','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2151,'public','Восстановление связи с контроллером 2-го уровня','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2152,'public','Выключение питания контроллера','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2153,'public','Запрет прохода по команде оператора: ','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2154,'public','Запрет прохода по команде от ДУ: ','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2155,'public','Запрет прохода: ','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2156,'public','Запрет прохода: нарушение комиссионирования','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2157,'public','Запрет прохода: несоответствие временным критериям доступа','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2158,'public','Запрет прохода: несоответствие временным критериям доступа и текущему местоположению','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2159,'public','Запрет прохода: несоответствие текущему местоположению','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2160,'public','Запрет прохода: отказ в подтверждении прохода от верификации','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2161,'public','Запуск задержки активизации выхода','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2162,'public','ИУ не закрыто после прохода по идентификатору','EVENT_TYPE','2017-07-14 14:14:06',0);
INSERT INTO sourcemessage VALUES(2163,'public','Изменение режима работы на режим "Охрана" по идентификатору: режим "Охрана"','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2164,'public','Изменение режима работы по команде ИК-пульта: режим "Закрыто"','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2165,'public','Изменение режима работы по команде ИК-пульта: режим "Контроль"','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2166,'public','Изменение режима работы по команде ИК-пульта: режим "Открыто"','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2167,'public','Изменение режима работы по команде ИК-пульта: режим "Совещание"','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2168,'public','Изменение режима работы по команде оператора: режим "Закрыто"','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2169,'public','Изменение режима работы по команде оператора: режим "Контроль"','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2170,'public','Изменение режима работы по команде оператора: режим "Открыто"','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2171,'public','Изменение режима работы по команде оператора: режим "Охрана"','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2172,'public','Изменение режима работы по команде оператора: режим "Совещание"','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2173,'public','Изменение режима работы с режима "Охрана" по идентификатору: режим "Контроль"','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2174,'public','Изменение режима работы с режима "Охрана" по идентификатору: режим "Открыто"','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2175,'public','Изменение режима работы с режима "Охрана" по идентификатору: режим "Совещание"','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2176,'public','Изменение учетных данных пользователя','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2177,'public','КЗ на выходе: Только для выходов с контролем состояния','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2178,'public','Корпус контроллера закрыт','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2179,'public','Корпус контроллера открыт','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2180,'public','Нарушение связи','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2181,'public','Неисправность ИП +18В: Формируется встроенным АЦП при выходе напряжения питания ШС за рабочий диапазон','EVENT_TYPE\r\n\r\nчто значат аббревиатуры? и что такое 18В?\r\n\r\nИП - Источник питания, \r\nШС - Шлейф связи,\r\nАЦП - Аналого-цифровой преобразователь (Analog-to-digital converter, ADC)\r\n+18 В - +18 Вольт','2017-04-19 14:33:06',0);
INSERT INTO sourcemessage VALUES(2182,'public','Неисправность ИП: Формируется встроенным АЦП при выходе напряжения питания за рабочий диапазон','EVENT_TYPE\r\nчто значат аббревиатуры? и что такое 18В?\r\n\r\nИП - Источник питания\r\nАЦП - Аналого-цифровой преобразователь ( англ. Analog-to-digital converter, ADC)','2017-04-19 14:35:36',0);
INSERT INTO sourcemessage VALUES(2183,'public','Неисправность контроллера 2-го уровня','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2184,'public','Неисправность контроллера: память DataFlash','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2185,'public','Неисправность контроллера: память FRAM','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2186,'public','Неисправность контроллера: часы RTC','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2187,'public','Неисправность контроллера: шина I2C','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2188,'public','Несанкционированный проход через ИУ (взлом ИУ)','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2189,'public','Нормализация входа','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2190,'public','Нормализация выхода','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2191,'public','Обрыв на выходе: Только для выходов с контролем состояния','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2192,'public','Объект контроллер создан','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2193,'public','Объект контроллер удалён','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2194,'public','Отказ от прохода','EVENT_TYPE','2017-07-14 14:10:11',0);
INSERT INTO sourcemessage VALUES(2195,'public','Очистка журнала регистрации','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2196,'public','Перезапуск контроллера: WatchDog','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2197,'public','Переполнение журнала регистрации','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2198,'public','Переполнение списка идентификаторов','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2199,'public','Предъявлена комиссионирующая карта: ','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2200,'public','Предъявление запрещенной карты: нарушение РКД','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2201,'public','Предъявление невалидной карты: Идентификатор запрещён','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2202,'public','Предъявление невалидной карты: Идентификатор из "стоп-листа"','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2203,'public','Предъявление невалидной карты: Идентификатор не зарегистрирован','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2204,'public','Предъявление невалидной карты: Идентификатор просрочен','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2205,'public','Пропадание связи с контроллером 2-го уровня','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2206,'public','Проход по идентификатору','EVENT_TYPE','2017-07-19 11:16:48',0);
INSERT INTO sourcemessage VALUES(2207,'public','Проход по идентификатору: несоответствие временным критериям доступа и текущему местоположению','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2208,'public','Проход по идентификатору: несоответствие временным критериям доступа и текущему местоположению и при отказе в подтверждении прохода от верификации','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2209,'public','Проход по идентификатору: несоответствие временным критериям доступа и текущему местоположению и с нарушением комиссионирования','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2210,'public','Проход по идентификатору: при отказе в подтверждении прохода от верификации','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2211,'public','Проход по идентификатору: с нарушением комиссионирования','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2212,'public','Проход по идентификатору: с несоответствием временным критериям доступа','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2213,'public','Проход по идентификатору: с несоответствием временным критериям доступа и при отказе в подтверждении прохода от верификации','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2214,'public','Проход по идентификатору: с несоответствием временным критериям доступа и с нарушением комиссионирования','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2215,'public','Проход по идентификатору: с несоответствием текущему местоположению','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2216,'public','Проход по идентификатору: с несоответствием текущему местоположению и при отказе в подтверждении прохода от верификации','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2217,'public','Проход по идентификатору: с несоответствием текущему местоположению и с нарушением комиссионирования','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2218,'public','Проход по команде ИК-пульта','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2219,'public','Проход по команде от ДУ','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2220,'public','Проход по команде от ПК','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2221,'public','Проход с подтверждением от ДУ: ','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2222,'public','Проход с подтверждением от ДУ: несоответствие временным критериям доступа и текущему местоположению','EVENT_TYPE','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2223,'public','Проход с подтверждением от ДУ: с несоответствием временным критериям доступа','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2224,'public','Проход с подтверждением от ДУ: с несоответствием текущему местоположению','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2225,'public','Проход с подтверждением от верификации: ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2226,'public','Проход с подтверждением от верификации: несоответствие временным критериям доступа и текущему местоположению','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2227,'public','Проход с подтверждением от верификации: с несоответствием временным критериям доступа','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2228,'public','Проход с подтверждением от верификации: с несоответствием текущему местоположению','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2229,'public','Сбой физического уровня Ethernet','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2230,'public','Сброс тревоги: От софта','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2231,'public','Сессия с контроллером открыта','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2232,'public','Соединение с web-сервером разорвано','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2233,'public','Соединение с web-сервером установлено','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2234,'public','Соединение с базой данных разорвано','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2235,'public','Соединение с базой данных установлено','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2236,'public','Соединение с контроллером разорвано','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2237,'public','Соединение с контроллером установлено','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2238,'public','Тестирование ШС завершено','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2239,'public','Тестирование ШС начато','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2240,'public','Тестирование прибора выявило неисправности','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2241,'public','Тестирование прибора завершено успешно','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2242,'public','Тестирование прибора начато','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2243,'public','Тревога по команде ИК-пульта','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2244,'public','Тревога: От Генератора тревоги','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2245,'public','Форматирование памяти: журнал событий','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2246,'public','Форматирование памяти: конфигурация','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2247,'public','Форматирование памяти: прошивка','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2248,'public','Форматирование памяти: список карт','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2249,'public','Форматирование памяти: текущие установки (режимы работы и т.д.)','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2250,'public','Только в базу данных','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2251,'public','Все в контроллер','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2252,'public','Измененные в контроллер','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2253,'public','Миллисекунды',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2254,'public','Секунды','#св-ва_контроллера','2016-04-08 16:20:17',0);
INSERT INTO sourcemessage VALUES(2255,'public','Бесконечность','#св-ва_контроллера','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(2435,'public','Таймаут верификации (время, в течение которого контроллер, отправивший запрос на верификацию, будет ожидать ответа оператора)',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2981,'public','Бюро пропусков','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2982,'public','Учёт рабочего времени','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2983,'public','Верификация','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2984,'public','Администрирование','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2985,'public','Дизайн пропуска','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2986,'public','Журнал отработанного времени','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2987,'public','Формирование табеля','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2988,'public','Контроль доступа','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2989,'public','Список событий','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2990,'public','Отчеты по дисциплине','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2991,'public','Местонахождение','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2992,'public','Журнал верификации','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2993,'public','Отчет по посетителям','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2994,'public','События доступа в помещения','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2995,'public','Конфигурация верификации','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2996,'public','Роли и права операторов','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2997,'public','События системы','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2998,'public','Операторы','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(2999,'public','Дополнительные данные','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3000,'public','Планировщик заданий','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3001,'public','Управление устройствами','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3002,'public','Конфигурация','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3004,'public','Скрыть меню','#каркас','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3005,'public','Раскрыть меню','#каркас','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3006,'public','Войти','#каркас','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3008,'public','Все помещения','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3009,'public','Все подразделения','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3010,'public','Свернуть','#Меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3011,'public','Страница','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3012,'public','из','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3013,'public','Поиск...','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3014,'public','Запись','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3015,'public','Отображение','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3016,'public','Автообновление','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3017,'public','Нарушители','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3018,'public','Недоработка','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3019,'public','Информация о проходах','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3020,'public','Вы действительно хотите удалить этот график?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3021,'public','Копировать день','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3022,'public','Вставить день','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3023,'public','День содержит переходящие интервалы, копирование запрещено','','2017-04-19 12:02:50',0);
INSERT INTO sourcemessage VALUES(3024,'public','День содержит переходящие интервалы, вставка запрещена','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3025,'public','г','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3026,'public','Данное подразделение уже создано','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3027,'public','Не выбрано подразделение','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3028,'public','Хотите удалить','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3029,'public','Слишком длинное имя','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3030,'public','Добавление подразделения','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3031,'public','Редактирование подразделения','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3032,'public','Текстовые данные','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3033,'public','Телефон','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3034,'public','Нач','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3035,'public','Пересчитать','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3036,'public','Сформировать Т12 (Exce','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3037,'public','Т12','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3038,'public','Проводится перерасчет.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3039,'public','Сделать перерасчет','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3040,'public','Доступ и постановка/снятие на/с охран[у/ы]','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3041,'public','Доступ и постановка/снятие на/с охран[у/ы] с комиссионированием','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3042,'public','Доступ с комиссионированием и постановка/снятие на/с охран[у/ы] с комиссионированием','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3044,'public','Всегда','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3045,'public','Параметры пропуска','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3046,'public','Цвет пропуска','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3047,'public','Добавить картинку','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3049,'public','Считыватели','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3050,'public','Генераторы тревоги','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3051,'public','Замки','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3052,'public','Данный контроллер не активен. Обратитесь к администратору системы за помощью','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3053,'public','Установить значения по умолчанию для выбранного подразделения?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3054,'public','Дата заказа','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3055,'public','Дата архивирования','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3056,'public','Отправка идентификаторов в контроллеры...','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3057,'public','Валидность карты','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3058,'public','В следующих контроллерах возможны проблемы с доступом.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3059,'public','Валидность','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3060,'public','Идентификатор не валиден','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3061,'public','Идентификатор не валиден в','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3062,'public','контроллерах','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3063,'public','Не выбран','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3064,'public','Шаблон верификации','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3065,'public','Обновить таблицу','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3066,'public','Передать измененные идентификаторы в контроллеры','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3067,'public','Дата заказа пропуска','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3068,'public','Дата архивирования пропуска','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3069,'public','Передать изменения в оборудование','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3070,'public','Печать информации о проходе','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3071,'public','Точка верификации','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3072,'public','Все точки','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3073,'public','Событие','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3074,'public','Ответ на запрос','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3075,'public','Все считыватели','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3076,'public','Все пользователи','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3077,'public','Кадр прохода','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3078,'public','Раскадровка','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3079,'public','Видео','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3080,'public','Пользователи','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3081,'public','Точки верификации','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3082,'public','Тип события','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3083,'public','Идентификатор','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3084,'public','Пропуск','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3085,'public','Пропуск?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3090,'public','Кадра нет','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3091,'public','Кадров нет','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3092,'public','Все события','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3093,'public','Событие не выбрано','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3094,'public','Создать отчет','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3095,'public','Не выбраны шаблоны','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3096,'public','Вы действительно хотите удалить этот [эти] шаблоны[и]?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3097,'public','Необходимо добавить точки верификации','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3098,'public','Имя уже используется','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3099,'public','Добавление шаблона верификации','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3100,'public','Редактирование шаблона верификации','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3101,'public','Выбранный считыватель уже используется в текущем шаблоне','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3102,'public','Необходимо выбрать Считыватель','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3103,'public','Не выбрана точка верификации','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3104,'public','Вы действительно хотите удалить эту точку верификации?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3105,'public','Считыватель ст','','2017-04-20 14:06:19',0);
INSERT INTO sourcemessage VALUES(3106,'public','Камера','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3107,'public','Добавление контрольной точки','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3108,'public','Редактирование контрольной точки','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3109,'public','Копирование контрольной точки','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3110,'public','Новая точка верификации','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3111,'public','Время отображение информации не может быть больше 120 секунд','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3112,'public','Выбранные горячие клавиши уже используются в текущем шаблоне','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3113,'public','В одном шаблоне нельзя использовать камеры из разных серверов','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3114,'public','Считыватель не выбран','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3115,'public','Не выбран видеосервер','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3116,'public','Не выбрана камера','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3117,'public','Не выбраны видеосерверы','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3118,'public','Вы действительно хотите удалить этот [эти] видеосервер[ы]?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3119,'public','Выбранная камера уже используется','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3120,'public','Не выбраны камеры','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3121,'public','Вы действительно хотите удалить этот [эти] камеры[ы]?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3122,'public','Добавление видеосервера','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3123,'public','Редактирование видеосервера','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3124,'public','Выберите видеосервер к которому будет добавлена камера','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3125,'public','Добавление камеры','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3126,'public','Редактирование камеры','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3127,'public','Имя не указано','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3128,'public','Хост не указан','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3129,'public','Шаблон камеры не указан','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3130,'public','Имя уже существует','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3131,'public','Производители','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3132,'public','Модели','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3133,'public','Производитель','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3134,'public','Модель','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3135,'public','Тип потока','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3136,'public','Фиксированный','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3137,'public','Количество каналов','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3138,'public','Путь','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3139,'public','Не выбран шаблон камеры','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3140,'public','Вы действительно хотите удалить этот [эти] шаблон[ы]?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3141,'public','Выбрать из существующих','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3142,'public','Добавление шаблона камеры','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3143,'public','Редактирование шаблона камеры','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3144,'public','Копирование шаблона камеры','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3145,'public','Фиксированные шаблоны запрещены для редактирования','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3146,'public','Производитель не указан','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3147,'public','Модель не указана','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3148,'public','Количество каналов может быть от 0 до 25','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3149,'public','Шаблон с такими параметрами уже существует','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3150,'public','Сч. 1','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3151,'public','Сч. 2','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3152,'public','Основные параметры','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3153,'public','Строки','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3154,'public','Ok','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3155,'public','Системная ошибка','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3156,'public','Необходимо выбрать один контроллер / помещение','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3157,'public','Редактировать помещение','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3158,'public','Это помещение нельзя переименовывать','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3159,'public','Добавить помещение','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3160,'public','Устройство не активно','','2017-12-22 09:48:29',0);
INSERT INTO sourcemessage VALUES(3161,'public','Строка','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3163,'public','Доступ к разделам','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3164,'public','Полномочия ролей','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3165,'public','Камеры','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3166,'public','Видео серверы','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3167,'public','2 ЛИКОН','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3168,'public','IP-адрес шлюза','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3169,'public','MAC-адрес','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3170,'public','Wiegand 26','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3171,'public','Вертикальная','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3172,'public','Взлом ИУ','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3173,'public','Длительность записи (секунд)','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3174,'public','Время ожидания ответа на запрос от сервера системы (максимально 12 сек; по умолчанию 5 сек)','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3175,'public','Время показа информации о сотруднике (по умолчанию 2 сек)','#св-ва_контроллера','2016-06-14 13:04:38',0);
INSERT INTO sourcemessage VALUES(3176,'public','Время предзаписи (секунд)','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3177,'public','Горизонтальная','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3178,'public','Доступ к Web-интерфейсу','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3179,'public','Запись кадров видеокамеры','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3180,'public','Защита от передачи идентификаторов (Antipass)','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3181,'public','Идентификатор ЗАБЛОКИРОВАН','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3182,'public','Идентификатор НЕ ЗАРЕГИСТРИРОВАН','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3183,'public','Идентификатор ПРОСРОЧЕН','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3184,'public','Индикация баланса рабочего времени','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3185,'public','Локализация','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3186,'public','Маска подсети','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3187,'public','Нарушение режима доступа','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3188,'public','Не более чем','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3189,'public','Не отслеживать','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3190,'public','Нормальное (т.е. заблокированное) состояние контакта (вход ИУ)','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3191,'public','Общие','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3192,'public','Ориентация','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3193,'public','Отображение информации','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3194,'public','Отслеживать','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3195,'public','Параметры видеозаписи','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3196,'public','Параметры видеоточки','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3197,'public','Параметры точки верификации','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3198,'public','Параметры точки верификации для ЛИКОН','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3199,'public','Поставить на охрану','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3200,'public','Постановка на охрану','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3201,'public','Постоянно','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3202,'public','Проход','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3203,'public','Проход от ДУ','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3204,'public','Проход с нарушением ВРЕМЕНИ','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3205,'public','Проход с нарушением ЗОНАЛЬНОСТИ','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3206,'public','Разное','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3207,'public','Разрешение ДУ','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3208,'public','Разрешить','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3209,'public','Реакция на события','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3210,'public','Режим отображения информации','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3211,'public','Режим работы считывателей','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3212,'public','Свойства ЛИКОНА','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3213,'public','Сеть','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3214,'public','Снятие с охраны','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3215,'public','Снять с охраны','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3216,'public','Снять тревогу','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3217,'public','События при проходе посетителей','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3218,'public','События при проходе сотрудников','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3219,'public','Таймаут верификации(см. раздел Администрирование/Свойства контроллера)','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3220,'public','Уведомляющие события','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3221,'public','Узел общий для всех контроллеров первого уровня','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3222,'public','Универсальный (8 байт)','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3223,'public','Управление охранными зонами','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3224,'public','Частота записи видеокадров','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3225,'public','Доступ в помещения','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3226,'public','Отчет о проходах','#меню','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3227,'public','Учитывать','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3228,'public','Не учитывать','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3229,'public','Всего','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3230,'public','Опоздание','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3231,'public','Уход раньше','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3232,'public','Опозданий','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3233,'public','Уходов раньше','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3234,'public','Отсутствий','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3235,'public','Время отсутствия','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3236,'public','Переработка до начала рабочего дня','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3237,'public','Переработка после окончания рабочего дня','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3238,'public','Общая переработка','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3239,'public','Переработок до начала рабочего дня','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3240,'public','Переработок после окончания рабочего дня','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3241,'public','Всего переработано','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3242,'public','Текущий день','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3243,'public','Предыдущий день','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3244,'public','Текущая неделя','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3245,'public','Текущий месяц','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3246,'public','Указанный период','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3247,'public','Подсеть','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3248,'public','Устройства не обнаружены или уже добавлены','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3249,'public','недоработку менее чем на','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3250,'public','переработку более чем на','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3251,'public','Доступ разрешён','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3252,'public','Запретить','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3253,'public','Шаблоны верификации','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3254,'public','Видеосервер','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3255,'public','Шаблоны камер','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3256,'public','Отображаемые данные сотрудников','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3257,'public','Отображаемые данные посетителей','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3258,'public','Имя точки','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3259,'public','Горячая клавиша "Разрешить"','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3260,'public','Горячая клавиша "Запретить"','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3261,'public','Автоподтверждение','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3262,'public','Имя видеосервера','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3263,'public','Хост видеосервера','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3264,'public','Порт','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3265,'public','Имя камеры','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3266,'public','Шаблон камеры','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3267,'public','Хост камеры','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3268,'public','Канал','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3269,'public','Валидность ресурсов','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3270,'public','Внимание','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3271,'public','Следующие ресурсы контроллера невалидны','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3272,'public','Свойства устройства','#св-ва_контроллера','2017-12-22 10:19:13',0);
INSERT INTO sourcemessage VALUES(3273,'public','Имя устройства','#св-ва_контроллера','2017-12-22 10:25:14',0);
INSERT INTO sourcemessage VALUES(3274,'public','Тип контроллера','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3275,'public','Вход [Сч. 1]','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3276,'public','Выход [Сч. 2]','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3277,'public','Оригинал строки','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3278,'public','Дерево','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3279,'public','Список','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3280,'public','Идентификация','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3281,'public','Считыватели в контроллере','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3282,'public','Имя помещения','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3283,'public','входы в','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3284,'public','выходы из','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3285,'public','Вы действительно хотите удалить этот документ?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3286,'public','Вы действительно хотите удалить этого оператора?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3287,'public','Скрыть нулевые значения','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3288,'public','Сброс тревоги:  По команде от ПО','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3289,'public','Объект шаблон верификации загружен','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3291,'public','Верификация: проход разрешён пользователем','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3292,'public','Верификация: проход разрешён автоматически','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3293,'public','Сервер оборудования запущен','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3294,'public','Регистрация Индицирующего устройства','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3295,'public','Добавление поля','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3296,'public','Сервер оборудования остановлен','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3297,'public','Регистрация верифицирующего устройства','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3298,'public','Верификация: проход посетителя','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3299,'public','Верификация: проход посетителя и нарушение времени','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3300,'public','Верификация: проход посетителя и нарушение местоположения','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3301,'public','Верификация: проход посетителя и нарушение местоположения и нарушение времени','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3302,'public','Верификация: проход посетителя и снятие верификации в связи несанкционированным проходом','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3303,'public','Верификация: проход посетителя и снятие верификации в связи несанкционированным проходом и нарушение времени','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3304,'public','Верификация: проход посетителя и снятие верификации в связи несанкционированным проходом и нарушение местоположения','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3305,'public','Верификация: проход посетителя и снятие верификации в связи несанкционированным проходом и нарушение местоположения и нарушение времени','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3306,'public','Верификация: проход сотрудника','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3307,'public','Верификация: проход сотрудника и нарушение времени','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3308,'public','Верификация: проход сотрудника и нарушение местоположения','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3309,'public','Верификация: проход сотрудника и нарушение местоположения и нарушение времени','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3310,'public','Верификация: проход сотрудника и снятие верификации в связи несанкционированным проходом','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3311,'public','Верификация: проход сотрудника и снятие верификации в связи несанкционированным проходом и нарушение времени','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3312,'public','Верификация: проход сотрудника и снятие верификации в связи несанкционированным проходом и нарушение местоположения','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3313,'public','Верификация: проход сотрудника и снятие верификации в связи несанкционированным проходом и нарушение местоположения и нарушение времени','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3314,'public','Верификация: постановка на «Охрану»','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3315,'public','Верификация: постановка на «Охрану» и нарушение времени','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3316,'public','Верификация: постановка на «Охрану» и нарушение местоположения','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3317,'public','Верификация: постановка на «Охрану» и нарушение местоположения и нарушение времени','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3318,'public','Верификация: постановка на «Охрану» и снятие верификации в связи несанкционированным проходом','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3319,'public','Верификация: постановка на «Охрану» и снятие верификации в связи несанкционированным проходом и нарушение времени','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3320,'public','Верификация: постановка на «Охрану» и снятие верификации в связи несанкционированным проходом и нарушение местоположения','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3321,'public','Верификация: постановка на «Охрану» и снятие верификации в связи несанкционированным проходом и нарушение местоположения и нарушение времени','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3322,'public','Верификация: снятие с «Охраны»','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3323,'public','Верификация: снятие с «Охраны» и нарушение времени','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3324,'public','Верификация: снятие с «Охраны» и нарушение местоположения','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3325,'public','Верификация: снятие с «Охраны» и нарушение местоположения и нарушение времени','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3326,'public','Верификация: снятие с «Охраны» и снятие верификации в связи несанкционированным проходом','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3327,'public','Верификация: снятие с «Охраны» и снятие верификации в связи несанкционированным проходом и нарушение времени','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3328,'public','Верификация: снятие с «Охраны» и снятие верификации в связи несанкционированным проходом и нарушение местоположения','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3329,'public','Верификация: снятие с «Охраны» и снятие верификации в связи несанкционированным проходом и нарушение местоположения и нарушение времени','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3330,'public','Верификация: проход запрещён пользователем','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3331,'public','Редактирование поля','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3332,'public','Удаление поля','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3333,'public','Добавление должности','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3334,'public','Редактирование должности','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3335,'public','Удаление должности','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3336,'public','Добавление дизайна пропуска','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3337,'public','Редактирование дизайна пропуска','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3338,'public','Удаление подразделения','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3339,'public','Удаление дизайна пропуска','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3340,'public','Добавление типа документа','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3341,'public','Редактирование типа документа','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3342,'public','Удаление типа документа','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3343,'public','Удаление оператора','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3344,'public','Смена полномочий пользователя','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3345,'public','Блокировка пользователя','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3346,'public','Снятие блокировки пользователя','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3347,'public','Удаление роли','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3348,'public','Изменение полномочий роли','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3349,'public','Удаление графика работы','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3350,'public','Редактирование календаря','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3351,'public','Редактирование опций календаря','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3352,'public','Добавление шаблона доступа','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3353,'public','Редактирование шаблона доступа','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3354,'public','Удаление шаблона доступа','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3355,'public','Редактирование временной зоны','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3356,'public','Редактирование недельного режима доступа','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3357,'public','Редактирование сменного суточного режима доступа','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3358,'public','Редактирование скользящего недельного режима доступа','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3359,'public','Добавление помещения','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3360,'public','Редактирование календаря праздников для недельных графиков','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3361,'public','Редактирование помещения','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3362,'public','Удаление помещения','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3363,'public','Добавление контроллера','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3364,'public','Редактирование контроллера','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3365,'public','Удаление контроллера','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3366,'public','Блокировка контроллера','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3367,'public','Снятие блокировки контроллера','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3368,'public','Сессия с контроллером не установлена и контроллер деактивирован: неверный пароль','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3369,'public','Действия пользователя','#Категории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3370,'public','События контроллеров системы безопасности','#Категории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3371,'public','События сервера оборудования','#Категории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3372,'public','13.2 События связанные с доступом по коду идентификатора (категория 1)','#Подкатегории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3373,'public','13.3 События, связанные с изменениями состояний ОЗ (категория 2)','#Подкатегории событий системы\r\nОЗ? охранная зона','2017-06-01 13:43:37',0);
INSERT INTO sourcemessage VALUES(3374,'public','13.4 События, связанные с изменением текущего состояния ШС, входящих в ОЗ (категория 3)','ШС? ОЗ? ШС - шлейф связи, ОЗ - зона охранной сигнализации','2017-05-29 09:33:02',0);
INSERT INTO sourcemessage VALUES(3375,'public','13.5 События связанные с состояниями входов/выходов (категория 4)','#Подкатегории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3376,'public','13.6 События, связанные с проходами через ИУ без идентификаторов (категория 5)','#Подкатегории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3377,'public','13.7 События связанные с функционированием (категория 6)','#Подкатегории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3378,'public','Изменение учетных данных','#Подкатегории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3379,'public','Работа с графиками работы','#Подкатегории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3380,'public','Работа с дизайнами пропуска','#Подкатегории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3381,'public','Работа с должностями','#Подкатегории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3382,'public','Работа с дополнительными данными','#Подкатегории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3383,'public','Работа с контроллерами','#Подкатегории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3384,'public','Работа с конфигурацией верификации','#Подкатегории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3385,'public','Работа с операторами','#Подкатегории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3386,'public','Работа с оправдательными документами','#Подкатегории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3387,'public','Работа с подразделениями','#Подкатегории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3388,'public','Работа с помещениями','#Подкатегории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3389,'public','Работа с ролями операторов','#Подкатегории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3390,'public','Работа с шаблонами доступа','#Подкатегории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3391,'public','События, связанные с верификацией','#Подкатегории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3392,'public','Соединение с контроллером','#Подкатегории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3393,'public','Функционирование сервера оборудования','#Подкатегории событий системы','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3394,'public','Неконтролируемая территория','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3395,'public','Нет подтверждения','#События верификации','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3396,'public','Проход разрешён пользователем','#События верификации','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3397,'public','Проход разрешён автоматически','#События верификации','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3398,'public','Проход запрещён пользователем','#События верификации','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3399,'public','Индикация: проход сотрудника','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3400,'public','Индикация: проход посетителя','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3401,'public','Индикация: проход сотрудника и нарушение времени ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3402,'public','Индикация: проход посетителя и нарушение времени ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3403,'public','Индикация: проход сотрудника и нарушение местоположения ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3404,'public','Индикация: проход посетителя и нарушение местоположения ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3405,'public','Индикация: проход сотрудника и нарушение времени и нарушение местоположения ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3406,'public','Индикация: проход посетителя и нарушение времени и нарушение местоположения ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3407,'public','Индикация: проход сотрудника и нарушение режима доступа ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3408,'public','Индикация: проход посетителя и нарушение режима доступа ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3409,'public','Индикация: проход сотрудника и разрешение прохода ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3410,'public','Индикация: проход посетителя и разрешение прохода ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3411,'public','Индикация: проход сотрудника и запрос на проход от пульта ДУ ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3412,'public','Индикация: проход посетителя и запрос на проход от пульта ДУ ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3413,'public','Индикация: проход сотрудника и постановка на «Охрану» ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3414,'public','Индикация: проход посетителя и постановка на «Охрану» ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3415,'public','Индикация: проход сотрудника и карта не зарегистрирована ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3416,'public','Индикация: проход посетителя и карта не зарегистрирована ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3417,'public','Индикация: проход сотрудника и катра заблокирована ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3418,'public','Индикация: проход посетителя и катра заблокирована ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3419,'public','Индикация: проход сотрудника и карта в стоп-листе ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3420,'public','Индикация: проход посетителя и карта в стоп-листе ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3421,'public','Индикация: проход сотрудника и истёк срок действия карты ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3422,'public','Индикация: проход посетителя и истёк срок действия карты ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3423,'public','Индикация: проход сотрудника и взлом ИУ ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3424,'public','Индикация: проход посетителя и взлом ИУ ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3425,'public','Индикация: проход сотрудника и разрешение прохода от ДУ ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3426,'public','Индикация: проход посетителя и разрешение прохода от ДУ ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3427,'public','Индикация: проход сотрудника и ожидание комиссионирования ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3428,'public','Индикация: проход посетителя и ожидание комиссионирования ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3429,'public','Индикация: проход сотрудника и запрет прохода (нарушение комиссионирования)','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3430,'public','Индикация: проход посетителя и запрет прохода (нарушение комиссионирования)','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3431,'public','Индикация: проход сотрудника и снятие с «Охраны» ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3432,'public','Индикация: проход посетителя и снятие с «Охраны» ','EVENT_TYPE','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3433,'public','Антипасс',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3435,'public','Направление прохода','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3436,'public','Вход в','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3437,'public','Выход из',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3438,'public','Вход: Считыватель','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3439,'public','Вход: Считыватель 1 Выход: Считыватель 2','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3440,'public','Не верифицируется',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3441,'public','Выключен',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3442,'public','Верифицируется',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3443,'public','Включен','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3444,'public','Нарушение времени','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3445,'public','Нарушение местоположения','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3446,'public','Снятие верификации в связи несанкционированным проходом','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3447,'public','Постановка на охрану','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3448,'public','Снятие с охраны','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3449,'public','Нарушение режима доступа','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3450,'public','Разрешение прохода','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3451,'public','Запрос на проход от пульта ДУ','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3452,'public','Нет в списке','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3453,'public','Истечение срока действия идентификатора','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3454,'public','Взлом ИУ','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3455,'public','Разрешение прохода от ДУ','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3456,'public','Ожидание коммисионирования по списку коммисионирующих карт','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3457,'public','Запрет прохода','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3459,'public','Роли операторов','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3460,'public','Скользящие подневные графики','#валидация','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3461,'public','Скользящие понедельные графики','#валидация','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3462,'public','Календарь праздничных дней','#валидация','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3463,'public','Карты комиссионирования','#валидация','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3464,'public','Конфигурация ЛИКОН','#валидация','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3465,'public','Конфигурация масок для верификации пультом ДУ (картоприёмником)','#валидация','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3466,'public','Конфигурация ЛИКОН -строки','#валидация','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3467,'public','Очистка списка идентификаторов','#валидация','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3468,'public','Список идентификаторов','#валидация','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3469,'public','Сделать снимок','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3470,'public','Подтвердите действие в верхней части браузера','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3471,'public','Камера отключена или ее использование заблокировано пользователем','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3472,'public','Событие верификации','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3475,'public','Нет изображения','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3476,'public','Локальный контроллер PERCo-IR05','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3478,'public','установить Java','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3479,'public','Ошибка! Контроллер не подключен.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3480,'public','Получить с','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3481,'public','Подключение к контроллеру','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3482,'public','Ожидание подключения...','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3483,'public','Java не определен. Попробуйте','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3484,'public','В шаблоне не установлены точки верификации','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3485,'public','Нет связи с видеосервером (ответ не получен)','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3487,'public','Контрольный считыватель','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3488,'public','Ошибка! Считыватель не подключен.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3489,'public','Не удается получить видео. Закройте все прочие программы использующие веб-камеру и перезагрузите страницу.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3490,'public','В данной версии браузера функция недоступна','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3491,'public','Выделить все','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3492,'public','Снять выделение','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3493,'public','Обновить помещения и контроллеры','devicemanagement,php','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3494,'public','Копировать можно только одну роль','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3495,'public','Система','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3496,'public','Перезагрузка сервера оборудования','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3497,'public','Необходимо наличие хотя бы одного раздела второго уровня','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3498,'public','Вы действительно хотите удалить эту роль','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3499,'public','В шаблоне не установлены камеры','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3500,'public','Вы пользуетесь устаревшей версией браузера, не поддерживающей данную технологию. Пожалуйста, обновите браузер и перезагрузите страницу.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3501,'public','Ошибка соединения с контроллерами.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3502,'public','Ошибка на стороне сервера. Контроллеры недоступны.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3503,'public','Проход подтвержден автоматически','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3504,'public','Стоп-лист','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3505,'public','Данный шаблон для данного пользователя уже открыт на другом устройстве или в другом окне. Соединение разорвано.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3506,'public','Данный шаблон уже открыт на другом устройстве или в другом окне. Соединение разорвано.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3507,'public','Баланс','DB::PLC::PLC_CREATE_RESOURCE_BI0','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3508,'public','Вход','DB::PLC::PLC_CREATE_RESOURCE_BI0 #св-ва_контроллера','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3509,'public','Вход повторно','DB::PLC::PLC_CREATE_RESOURCE_BI0 #св-ва_контроллера','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3510,'public','Выход','DB::PLC::PLC_CREATE_RESOURCE_BI0','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3511,'public','Выход повторно','DB::PLC::PLC_CREATE_RESOURCE_BI0','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3512,'public','Для регистрации ','DB::PLC::PLC_CREATE_RESOURCE_BI0','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3513,'public','К отработке','DB::PLC::PLC_CREATE_RESOURCE_BI0','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3514,'public','Карты','DB::PLC::PLC_CREATE_RESOURCE_BI0','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3515,'public','Нарушение зоны','DB::PLC::PLC_CREATE_RESOURCE_BI0','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3516,'public','Нарушение зоны: вход','DB::PLC::PLC_CREATE_RESOURCE_BI0 #св-ва_контроллера','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3517,'public','Нарушение зоны: выход','DB::PLC::PLC_CREATE_RESOURCE_BI0','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3518,'public','Нарушения','DB::PLC::PLC_CREATE_RESOURCE_BI0','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3519,'public','Нет связи','DB::PLC::PLC_CREATE_RESOURCE_BI0','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3520,'public','Предъявите карту','DB::PLC::PLC_CREATE_RESOURCE_BI0','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3521,'public','Расчет прерван','DB::PLC::PLC_CREATE_RESOURCE_BI0','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3522,'public','баланса','DB::PLC::PLC_CREATE_RESOURCE_BI0','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3523,'public','вход','DB::PLC::PLC_CREATE_RESOURCE_BI0 #св-ва_контроллера','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3524,'public','входа используйте','DB::PLC::PLC_CREATE_RESOURCE_BI0 #св-ва_контроллера','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3525,'public','выход','DB::PLC::PLC_CREATE_RESOURCE_BI0','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3526,'public','выхода используйте','DB::PLC::PLC_CREATE_RESOURCE_BI0','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3527,'public','для просмотра','DB::PLC::PLC_CREATE_RESOURCE_BI0','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3528,'public','не зарегистрирован','DB::PLC::PLC_CREATE_RESOURCE_BI0','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3529,'public','нет в списке','DB::PLC::PLC_CREATE_RESOURCE_BI0','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3530,'public','считыватель ','DB::PLC::PLC_CREATE_RESOURCE_BI0','2018-04-26 15:51:07',0);
INSERT INTO sourcemessage VALUES(3531,'public','Настройки','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3532,'public','Воспроизвести','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3533,'public','Пауза','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3534,'public','Ускорить воспроизведение','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3535,'public','Замедлить воспроизведенние','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3536,'public','Снятие верификации в связи с несанкционированным проходом','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3537,'public','Статус','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3538,'public','нет связи','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3539,'public','Ответ от сервера не получен. Возможно, веб-сокеты блокируются прокси-сервером.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3540,'public','связь установлена','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3541,'public','Контрольный считыватель уже открыт в другом шаблоне. Соединение разорвано.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3542,'public','Идет соединение с контроллерами, подождите...','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3543,'public','Идет подключение к видео серверу','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3544,'public','Добавить считыватель','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3545,'public','Редактировать считыватель','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3546,'public','Удалить считыватель','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3547,'public','Скачать ярлык быстрого доступа к шаблону','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3548,'public','Добавить точку верификации','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3549,'public','Добавить видеосервер','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3550,'public','Добавить камеру','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3551,'public','Редактировать камеру','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3552,'public','Удалить камеру','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3553,'public','Редактировать видеосервер / камеру','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3554,'public','Удалить видеосервер / камеру','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3555,'public','Сохранить и продолжить','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3556,'public','Вы действительно хотите удалить эту [эти] камеру[ы]?','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3557,'public','Нельзя удалить встроенный видеосервер','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3558,'public','Введите имя сервера','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3559,'public','Введите адрес видеосервера','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3560,'public','Не указан порт сервера','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3561,'public','Фиксированный шаблон камеры удалять запрещено.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3562,'public','Время ожидания результата выполнения команды истекло.','percophpext,HardServer','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3563,'public','Выполнение было остановлено и приём запросов был прекращён.','percophpext,HardServer','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3564,'public','Повторный запрос.1','percophpext,HardServer','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3565,'public','Повторный запрос.2','percophpext,HardServer','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3566,'public','Нет связи с сервером системы','percophpext,HardServer','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3567,'public','Ошибка создания команды.','percophpext,HardServer','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3568,'public','Проблема соединения. Web-сервер не отвечает.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3569,'public','Помощь','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3570,'public','Свободные контроллеры отстутствуют','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3571,'public','Настройки системы','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3572,'public','Язык системы по умолчанию','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3573,'public','Установить контроллеры','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3574,'public','Общие настройки контроллеров','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3575,'public','В это помещение добавление контроллеров запрещено','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3576,'public','Неверный формат файла (К загрузке разрешены файлы форматов: .jpg .jpeg .pjpeg .png .gif .bmp)',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3577,'public','Не выбран сотрудник','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3578,'public','Редактировать строку','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3579,'public','Множественное редактирование',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3580,'public','Параметры системы','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3581,'public','Общие параметры','#св-ва_контроллера','2017-12-22 09:30:39',0);
INSERT INTO sourcemessage VALUES(3582,'public','Изменить пароль','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3583,'public','Копирование роли','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3584,'public','Карта уже используется',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3585,'public','Карта будет изъята',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3586,'public','Карта доступа',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3587,'public','Если Java установлен, необходимо включить его для браузера Chrome: ',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3588,'public','1. В адресной строке откройте chrome: //flags/#enable-npapi',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3589,'public','2. Выберите "включить" для опции "Включить NPAPI".',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3590,'public','3. Нажмите "Перезапустить" внизу страницы.',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3591,'public','Янв',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3592,'public','Фев',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3593,'public','Мар',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3594,'public','Апр',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3595,'public','Май',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3596,'public','Июн',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3597,'public','Июл',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3598,'public','Авг',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3599,'public','Сен',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3600,'public','Окт',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3601,'public','Ноя',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3602,'public','Дек',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3603,'public','Печать карточки сотрудника',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3604,'public','Выберите данные для печати',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3605,'public','Основные поля',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3606,'public','Действует с',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3607,'public','Печатать оправдательные документы',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3608,'public','Не выбрано ни одного сотрудника!',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3609,'public','Служебное поле','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3610,'public','0x00 Нет ошибки','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3611,'public','0x01 Неверное семейство команды','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3612,'public','0x02 Неверный тип команды','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3613,'public','0x03 Неверный параметр команды','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3614,'public','0x04 Неверный тип ресурса','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3615,'public','0x05 Неверный номер ресурса','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3616,'public','0x06 Переполнение при записи','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3617,'public','0x07 Ошибка поллинга I2C','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3618,'public','0x08 Ошибка I2C - нет ответа на передачу адреса','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3619,'public','0x09 Ошибка I2C - нет ответа на передачу данных','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3620,'public','0x0A Ошибка чтения таймера','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3621,'public','0x0B Ошибка записи в DATAFLASH','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3622,'public','0x0C Ошибка CRC в DATAFLASH','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3623,'public','0x0D Ошибка занятости в DATAFLASH','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3624,'public','0x0E Неисправность контроллера','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3625,'public','0x10 Отклонение запроса на регистрацию вер-го/инд-го уст-ва','#св-ва_контроллера\r\nсокращения? Отклонение запроса на регистрацию устройства верификации/индикации','2017-06-01 13:45:43',0);
INSERT INTO sourcemessage VALUES(3626,'public','0x20 Ошибка передачи адреса','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3627,'public','0x21 Ошибка передачи данных','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3628,'public','0x22 Ошибка приёма данных','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3629,'public','0x23 Неисправность линии','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3630,'public','0x30 Ошибка управления - отсутствует конфигурация','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3631,'public','0x31 Ошибка разблокировки, происходит обработка кода карты','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3632,'public','0x32 Ошибка - датчик прохода в неопределённом состоянии','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3633,'public','0x33 Ошибка - попытка установки РКД "Охрана"','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3634,'public','0x34 Невалидная команда','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3635,'public','0x35 Ошибка управления - несоответствие типа ресурса','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3636,'public','0x36 Ошибка конфигурации - группа на охране или в тревоге','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3637,'public','0x37 Ошибка конфигурации - ресурс на охране или в тревоге','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3638,'public','0x38 Ошибка управления - ресурс на охране','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3639,'public','0x39 Ошибка управления - ресурс ставиться охрану','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3640,'public','0x3A Ошибка управления/конф-и - контроллер форматируется','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3641,'public','0x3B Ошибка - отсутствие конф-и','#св-ва_контроллера конф? конфигурации','2017-06-01 13:23:41',0);
INSERT INTO sourcemessage VALUES(3642,'public','0x3C Ошибка управления выходом оповещения - КЗ выхода.','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3643,'public','0x3E Ошибка конфигурации CL201','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3644,'public','0x3F Ошибка батареи часов','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3645,'public','0x40 Ошибка часов','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3646,'public','0x80 Ошибка пароля','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3647,'public','0xFF Команда ещё не выполнена или принудительно удалена из очереди сервером оборудования','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3648,'public','Аппаратное состояние','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3649,'public','Вход №1','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3650,'public','Вход №2','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3651,'public','Вход №3','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3652,'public','Вход №4','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3653,'public','Выход №1','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3654,'public','Выход №2','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3655,'public','Выход №3','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3656,'public','Выход №4','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3657,'public','Да','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3658,'public','Закрыто','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3659,'public','ИУ №1','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3660,'public','ИУ №10','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3661,'public','ИУ №2','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3662,'public','ИУ №3','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3663,'public','ИУ №4','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3664,'public','ИУ №5','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3665,'public','ИУ №6','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3666,'public','ИУ №7','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3667,'public','ИУ №8','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3668,'public','ИУ №9','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3669,'public','Исправность шины SPI','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3670,'public','КЗ','#св-ва_контроллера\r\nрасшифруйте, пожалуйста\r\n: короткое замыкание','2017-05-24 11:21:20',0);
INSERT INTO sourcemessage VALUES(3671,'public','Код возврата команды подключения','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3672,'public','Контроль','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3673,'public','Логическое состояние','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3674,'public','Маска логического состояния входов','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3675,'public','Маска логического состояния выходов','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3677,'public','Нет','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3678,'public','Нет связи','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3679,'public','Низкий','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3680,'public','Обрыв','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3681,'public','Общее состояние','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3682,'public','Открыто','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3683,'public','Охрана','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3684,'public','Ошибка пароля','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3685,'public','Подключение','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3686,'public','РКД считывателей','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3687,'public','Работает','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3688,'public','Режим','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3689,'public','Режим тестирования прибора','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3690,'public','Совещание','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3691,'public','Состояние','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3692,'public','Состояние ИУ (Исполнительные Устройства)','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3693,'public','Состояние ШС (Шина Сигнализации) №1','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3694,'public','Состояние ШС (Шина Сигнализации) №2','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3695,'public','Состояние выхода оповещения №1','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3696,'public','Состояние выхода оповещения №1 (исправность / неисправность)','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3697,'public','Состояние соединения с контроллером','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3698,'public','Состояния генераторов тревоги (при наличии соответствующего ИУ)','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3699,'public','Состояния неисправности устройств на RS-485 (контроллеров 2-го уровня) (при наличии)','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3700,'public','Состояния связи с устройствами на RS-485 (с контроллерами 2-го уровня) (при наличии)','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3701,'public','Состояния служебных входов (конфигурационных перемычек)','#св-ва_контроллера. Вход имеется ввиду input.','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3702,'public','Считыватель №1','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3703,'public','Считыватель №10','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3704,'public','Считыватель №2','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3705,'public','Считыватель №3','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3706,'public','Считыватель №4','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3707,'public','Считыватель №5','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3708,'public','Считыватель №6','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3709,'public','Считыватель №7','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3710,'public','Считыватель №8','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3711,'public','Считыватель №9','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3712,'public','Тип шлейфа','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3713,'public','Устройство №1','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3714,'public','Устройство №2','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3715,'public','Устройство №3','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3716,'public','Устройство №4','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3717,'public','Устройство №5','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3718,'public','Устройство №6','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3719,'public','Устройство №7','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3720,'public','Устройство №8','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3721,'public','Физическое состояние','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3722,'public','автоперевзятие','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3723,'public','активизирован','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3724,'public','взлом','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3725,'public','взят','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3726,'public','взятие','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3727,'public','вскрытие корпуса','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3728,'public','высокий','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3729,'public','для каждого бита значение 0 – низкий логический уровень на входе / 1 – высокий логический уровень на входе','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3730,'public','есть связь','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3731,'public','заблокировано','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3732,'public','исправен','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3733,'public','исправно','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3734,'public','исправность встроенного источника питания ШС 18 В','#св-ва_контроллера','2017-06-01 13:46:30',0);
INSERT INTO sourcemessage VALUES(3735,'public','исправность памяти (Data Flash)','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3736,'public','исправность памяти (FRAM)','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3737,'public','исправность часов (RTC)','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3738,'public','исправность шины I2C (FRAM)','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3739,'public','логическое состояние (в составе ОПС)','#св-ва_контроллера\r\nОПС?\r\n\r\nОПС - это охранно-пожарная сигнализация','2017-06-01 13:35:48',0);
INSERT INTO sourcemessage VALUES(3740,'public','неисправен','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3741,'public','неисправно','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3742,'public','неисправность ИП','#св-ва_контроллера ИП? источника питания (power supply unit)','2017-06-01 13:42:11',0);
INSERT INTO sourcemessage VALUES(3743,'public','неисправность прибора','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3744,'public','неопределено','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3745,'public','нет связи','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3746,'public','норма','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3747,'public','нормализован','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3748,'public','обрыв','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3749,'public','открыт корпус','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3750,'public','охранный','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3751,'public','перемычка IP_DEFAULT','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3752,'public','перемычка IP_MODE','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3753,'public','перемычка XP3.1','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3754,'public','перемычка XP3.2','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3755,'public','перемычка XP3.3','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3756,'public','переполнение журнала регистрации','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3757,'public','рабочий (дежурный)','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3758,'public','разблокировано','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3759,'public','резерв','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3760,'public','снят','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3761,'public','состояние (СКУД)','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3762,'public','сработал датчик','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3763,'public','тестирования','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3764,'public','тестирования ШС','#св-ва_контроллера ШС? шлейф сигнализации','2017-06-01 13:41:35',0);
INSERT INTO sourcemessage VALUES(3765,'public','тихая тревога - ОПС','#св-ва_контроллера\r\nОПС?  охранно-пожарная сигнализация','2017-06-01 13:38:46',0);
INSERT INTO sourcemessage VALUES(3766,'public','тревога','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3767,'public','тревога СКУД (генератор тревоги)','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3768,'public','тревога — ОПС','#св-ва_контроллера\r\nОПС?  охранно-пожарная сигнализация','2017-06-01 13:38:35',0);
INSERT INTO sourcemessage VALUES(3769,'public','физическое состояние (в составе ОПС)','#св-ва_контроллера\r\nОПС? ОПС - это охранно-пожарная сигнализация','2017-06-01 13:38:24',0);
INSERT INTO sourcemessage VALUES(3770,'public','форматирование памяти прибора','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3771,'public','Контроллер с данным id не найден сервером оборудования.','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3772,'public','Закрыть без сохранения','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3773,'public','Редактирование пропусков выбранных сотрудников','staff,js,php','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3774,'public','Неконтролируемую территорию редактировать нельзя','http://172.17.0.20/administration/premisesconfiguration','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3775,'public','Найти устройства','','2017-12-22 09:42:01',0);
INSERT INTO sourcemessage VALUES(3776,'public','Установить контроллер','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3777,'public','Найти карту',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3778,'public','Строка не выбрана','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3779,'public','Сбросить на значение по умолчанию','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3780,'public','Оправдательный',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3781,'public','Отвязать контроллер','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3782,'public','Центральный пост',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3783,'public','Логин системного оператора изменять нельзя',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3784,'public','Логин оператора должен быть заполнен',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3785,'public','Выводить с учетом временной замены',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3786,'public','Выводить без учета временной замены',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3787,'public','Добавлено значение',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3788,'public','Изменено значение',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3789,'public','Было',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3790,'public','Стало',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3791,'public','Удалено',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3792,'public','Добавление сотрудника',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3793,'public','Редактирование сотрудника',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3794,'public','Добавление посетителя',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3795,'public','Редактирование посетителя',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3796,'public','произвел действия в разделе',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3797,'public','Уволен',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3798,'public','Восстановлен',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3799,'public','Удален',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3800,'public','заблокирован',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3801,'public','разблокирован',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3802,'public','от',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3803,'public','Удалены все графики, шаблоны доступа, должности и подразделения, установленные с',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3804,'public','Ф.И.О.',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3805,'public','номер',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3806,'public','Роль не может быть удалена, так как используется следующими операторами','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3807,'public','Глобальный антипас','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3808,'public','Внешние подключения','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3809,'public','Порт для конфигурации, управления и диагностики','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3810,'public','Удалённый IP-адрес','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3811,'public','Удалённый MAC-адрес','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3812,'public','Состояние сокета','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3813,'public','Удалённый порт','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3814,'public','Локальный порт','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3815,'public','Порт для передачи журнала мониторинга','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3816,'public','Порт для передачи журнала регистрации','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3817,'public','Порт для обмена с индицирующим устройством','#св-ва_контроллера\r\n','2017-05-11 11:21:36',0);
INSERT INTO sourcemessage VALUES(3818,'public','Порт для обмена с верифицирующим устройством','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3819,'public','Порт для передачи журнала отладки','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3820,'public','Отключен','#св-ва_контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3821,'public','Поле не может быть пустым',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3822,'public','изображение',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3823,'public','Карта заменена',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3824,'public','Работа с сотрудниками',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3825,'public','Работа с посетителями',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3826,'public','Выделить все контроллеры','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3827,'public','Буквенный код документа должен быть заполнен','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3828,'public','Числовой код документа должен быть заполнен','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3829,'public','В неактивные контроллеры команда передана не будет','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3830,'public','Название типа документа не может быть пустым','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3831,'public','Неверный формат файла',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3832,'public','Повторить попытку',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3833,'public','Больше не показывать это сообщение',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3834,'public','не может быть сохранена',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3835,'public','Пустая запись','запись чего? в поле для ввода данных не введены значения','2017-05-24 11:21:15',0);
INSERT INTO sourcemessage VALUES(3836,'public','не существует',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3837,'public','нет прав',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3838,'public','Импорт из',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3839,'public','Куда сохраняем',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3840,'public','Что сохраняем',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3841,'public','уже существует',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3843,'public','в подразделении',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3844,'public','Создать нового',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3845,'public','Пропустить',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3846,'public','Повторять то же действие для всех',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3847,'public','Обработано',NULL,'2017-11-10 09:40:04',0);
INSERT INTO sourcemessage VALUES(3848,'public','Импорт завершен',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3849,'public','записей из',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3850,'public','не было импортировано',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3851,'public','Экспорт остатка в файл',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3852,'public','Добавление / удаление дней запрещено при наличии временных интервалов','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3853,'public','Серия',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3854,'public','Номер',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3855,'public','График должен содержать интервалы','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3856,'public','Файл слишком большой (Максимальный размер 5 Мб.)',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3857,'public','Файл не выбран',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3858,'public','При смене режима работы считывателей все выданные карты станут недействительны','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3859,'public','Получение карты от',NULL,'2017-07-17 11:00:15',0);
INSERT INTO sourcemessage VALUES(3860,'public','контроллера',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3861,'public','контрольного считывателя',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3862,'public','Индикация: истек срок действия карты',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3863,'public','Индикация: карта не зарегистрирована',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3864,'public','Индикация: карта заблокирована',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3865,'public','Индикация: проход посетителя и разрешение прохода',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3866,'public','Индикация: проход сотрудника и нарушение режима доступа',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3867,'public','Индикация: проход сотрудника и разрешение прохода',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3868,'public','Неконтролируемую территорию удалять нельзя',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3869,'public','не может быть удален(а), так как используется следующими людьми: ',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3870,'public','План',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3871,'public','Протокол',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3872,'public','События контроллеров',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3873,'public','Устройство не существует или деактивировано',NULL,'2017-12-22 09:49:04',0);
INSERT INTO sourcemessage VALUES(3874,'public','Выбрать шаблон камеры',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3875,'public','Дата увольнения',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3876,'public','для уволенных',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3877,'public','Пароль и подтверждение должны совпадать','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3878,'public','События пользователя',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3879,'public','Только команды пользователя',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3880,'public','Неверно указаны серия и номер',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3881,'public','Неверно указана серия',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3882,'public','Неверно указан номер карты',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3883,'public','Помещения, учитывающие рабочее время','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3884,'public','Учёт','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3885,'public','Сначала добавьте роль','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3886,'public','Данный сотрудник не заблокирован',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3887,'public','Данный сотрудник уже заблокирован',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3888,'public','Куда (подразделение)',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3889,'public','Переход в полноэкранный режим (F11)',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3890,'public','Файл не выбран или пустой',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3891,'public','Подключение к устройству',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3892,'public','Передать зоны безопасности считывателей','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3893,'public','Смена типа поля приведет к потере данных этого поля','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3894,'public','Не проверена',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3895,'public','Ключ не проверен',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3896,'public','Повреждена',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3897,'public','Проверена',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3898,'public','Новый ключ установлен',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3899,'public','В вашем файле более 1 листа. Удалите все лишние листы для правильного чтения данных.',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3900,'public','Лицензии',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3901,'public','активирована','что активировано? лицензия','2017-05-24 11:21:17',0);
INSERT INTO sourcemessage VALUES(3902,'public','дней осталось, нет лицензионного контроллера',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3903,'public','период закончен',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3904,'public','Нет лицензионного контроллера',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3905,'public','не ограничен','что не ограничено?\r\n: срок лицензии','2017-05-24 11:21:27',0);
INSERT INTO sourcemessage VALUES(3906,'public','ознакомительная',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3907,'public','дней осталось',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3908,'public','нет кода активации',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3909,'public','Лицензионный контроллер',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3910,'public','Лицензионный ключ',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3911,'public','Введите лицензионный ключ',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3912,'public','Компонент',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3913,'public','Тип лицензии',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3914,'public','Срок действия',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3915,'public','Базовая функциональность',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3916,'public','Копировать можно только интервалы из одних суток','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3917,'public','* - обязательные поля',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3918,'public','Недействительна',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3919,'public','Новый ключ некорректен',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3920,'public','Неверный формат строки лицензионного ключа',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3921,'public','Лицензирующий контроллер не задан',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3922,'public','Внутренняя ошибка. Ключ не установлен',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3923,'public','Ошибка обновления лицензии',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3924,'public','Куда',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3925,'public','Откуда',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3926,'public','Выберите лицензионный контроллер',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3927,'public','Выбрать',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3928,'public','Доступные возможности',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3929,'public','Не удалось загрузить данные',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3930,'public','Введите лицензионный ключ для компонента',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3931,'public','Для ввода ключа необходимо выбрать лицензионный контроллер',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3932,'public','Ключ введен корректно. Для лицензирования компонента нажмите кнопку «Отправить»',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3933,'public','Ключ содержит недопустимые символы',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3934,'public','Лицензионный ключ не введен',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3935,'public','Ключ слишком короткий и содержит недопустимые символы',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3936,'public','Ключ слишком короткий',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3937,'public','Некорректный ключ',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3938,'public','Отправить',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3939,'public','Задания',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3940,'public','Когда выполнять',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3941,'public','Начало',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3942,'public','Окончание',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3943,'public','Задание',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3944,'public','Дата выполнения',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3945,'public','Статус выполнения',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3946,'public','Задача не выбрана',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3947,'public','Резервное копирование базы данных',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3948,'public','Учет рабочего времени',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3949,'public','Запустить приложение',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3950,'public','Перерасчёт текущих шаблонов доступа и блокировок',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3951,'public','Выполнено',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3952,'public','Выполнено с ошибками',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3953,'public','ПН',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3954,'public','ВТ',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3955,'public','СР',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3956,'public','ЧТ',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3957,'public','ПТ',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3958,'public','СБ',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3959,'public','ВС',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3960,'public','Редактирование задачи',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3961,'public','Дни недели',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3962,'public','Время начала',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3963,'public','Время окончания',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3964,'public','Тип задачи',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3965,'public','Не действительна','что не действительно? от этого зависит окончание в итальянском слове\r\n: лицензия','2017-05-24 11:21:23',0);
INSERT INTO sourcemessage VALUES(3966,'public','Импорт данных из файла',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3967,'public','Работа с планировщиком заданий',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3968,'public','Добавление задания',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3969,'public','Редактирование задания','чем отличается редактирование задания от редактирования задачи?','2017-04-20 16:58:05',0);
INSERT INTO sourcemessage VALUES(3970,'public','Удаление задания',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3971,'public','Контроллеры не выбраны',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3972,'public','Оправдательные документы: тип',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3973,'public','Оправдательные документы: наименование',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3974,'public','Оправдательные документы: дата создания',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3975,'public','Оправдательные документы: дата начала',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3976,'public','Оправдательные документы: дата окончания',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3977,'public','Оправдательные документы: длительность',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3978,'public','Оправдательные документы: номер',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3979,'public','Проход разрешён оператором',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3980,'public','Проход запрещён оператором',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3981,'public','Все операторы',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3982,'public','Выбранный(ые) контроллер(ы) уже существует(ют)',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3983,'public','Нельзя передать изменения в неактивный контроллер',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3984,'public','Неизвестный контроллер с типом',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3985,'public','Контроллер замка CL05 [1]',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3986,'public','ЛИКОН',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3987,'public','Контроллер турникета CT/L04 [1]',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3988,'public','Контроллер турникета CT/L04 [1+8]',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3989,'public','Контроллер замка CT/L04 [1]','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3990,'public','Контроллер замка CT/L04 [1+8]',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3991,'public','Контроллер замка CT/L04 [2+8]',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3992,'public','Электронная проходная KT2.3 [1]',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3993,'public','Электронная проходная KT2.3 [1+8]',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3994,'public','Электронная проходная KR05 [1]',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3995,'public','Электронная проходная KR05 [1+8]',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3996,'public','Электронная проходная с картоприёмником КТС01.3 [1]',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3997,'public','Электронная проходная с картоприёмником КТС0101.3 [1+8]',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(3998,'public','Контроллер АТП CT/L04 [1]','АТП? Автотранспортная проходная','2017-06-01 13:43:39',0);
INSERT INTO sourcemessage VALUES(3999,'public','Контроллер АТП CT/L04 [1+8]','АТП?\r\nАвтотранспортная проходная','2017-06-01 13:37:24',0);
INSERT INTO sourcemessage VALUES(4000,'public','Электронная проходная KT2.3 [1]',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4001,'public','Электронная проходная KT2.3 [1+8]',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4002,'public','Электронная проходная KT2.3 [1]',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4003,'public','Электронная проходная KT2.3 [1+8]',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4004,'public','Контроллер замка CL05.1 [1]',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4006,'public','Стойка турникета [1]',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4007,'public','Контроллер замка CL201 [1]',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4008,'public','Контроллер замка [1]',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4009,'public','Контроллер турникета',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4010,'public','Электронная проходная',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4011,'public','Нет лицензии для данного раздела',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4012,'public','Нет прав доступа для данного раздела',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4013,'public','Обратитесь к администратору',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4014,'public','Посмотреть доступные лицензии',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4015,'public','Помещение содержит контроллеры, сперва отвяжите их',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4016,'public','Сервер оборудования не смог выполнить запрос по причине',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4017,'public','Попробуйте повторить операцию или обратитесь к администратору',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4018,'public','Сервер оборудования PERCo-Web',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4019,'public','Видеосервер не может быть удален, поскольку содержит камеры. Предварительно удалите все камеры и повторите действие.',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4020,'public','Пользовательский запуск пересчета рабочего времени',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4021,'public','Фиксированные шаблоны запрещены для копирования',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4022,'public','Для следующих помещений не установлено имя режима доступа',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4023,'public','Необходимо наличие доступа на неконтролируемая территорию',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4024,'public','Необходимо установить хотя бы один доступ в помещение, отличное от неконтролируемой территории',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4025,'public','Удаление шаблона верификации',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4026,'public','Удаление видеосервера',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4027,'public','Редактирование точки верификации',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4028,'public','Указаны уже используемые хост и порт',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4029,'public','Указано уже существующее имя сервера',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4030,'public','Удаление шаблона камеры',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4031,'public','Передать все карты доступа в контроллеры',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4032,'public','Путь к видеопотоку',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4033,'public','Переполнение поля',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4034,'public','Календарь праздников для недельных режимов доступа',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4035,'public','Тип режима доступа',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4036,'public','Имя режима доступа',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4037,'public','Параметры доступа',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4038,'public','Служебные графики редактировать запрещено',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4039,'public','Имя временной зоны',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4040,'public','Описание временной зоны',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4041,'public','Имя недельного режима доступа',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4042,'public','Описание недельного режима доступа',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4043,'public','Необходимо выбрать неделю',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4044,'public','Необходимо выбрать день',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4045,'public','Зафиксировано разработчиком',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4046,'public','Необходимо выбрать тип режима доступа',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4047,'public','Точка верификации уже открыта в другом шаблоне',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4048,'public','нет ответа на команду',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4049,'public','нет связи с контроллером',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4050,'public','Нет ответа на команду',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4051,'public','Показать скрытые',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4052,'public','Не учёт',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4053,'public','Ввод недопустимых символов',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4054,'public','Вы действительно хотите удалить это помещение(я)',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4055,'public','Редактирование общих параметров контроллеров',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4056,'public','Выбрать язык',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4057,'public','На этот день праздник уже добавлен',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4058,'public','Порядок сортировки',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4059,'public','Не найдено',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4061,'public','приложение','Приложение - программа.','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4062,'public','Ваш аккаунт заблокирован',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4063,'public','Неправильная пара логин-пароль',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4064,'public','Войти в систему',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4065,'public','Описание режима доступа',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4066,'public','Служебные режимы доступа редактировать запрещено',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4067,'public','Режим доступа не выбран',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4068,'public','Заблокирована карта',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4069,'public','Разблокирована карта',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4070,'public','контроллере(ах)',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4071,'public','Добавить временную зону',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4072,'public','Изменить временную зону',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4073,'public','Удалить временную зону',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4074,'public','Добавить недельный режим доступа',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4075,'public','Изменить недельный режим доступа',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4076,'public','Удалить недельный режим доступа',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4077,'public','Величина сокращения должна быть больше 0',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4078,'public','Величина сокращения должна быть меньше 2 часов',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4079,'public','Найдено устройств',NULL,'2017-12-22 10:11:58',0);
INSERT INTO sourcemessage VALUES(4080,'public','Экспорт остатка',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4081,'public','Оператор',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4082,'public','Всего подразделений',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4083,'public','Замена некорректна: нижняя или верхняя граница раньше даты приема на работу',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4084,'public','Дата приема',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4085,'public','Замена не указана',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4086,'public','Событие изменения учетных данных повторяется',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4087,'public','Ошибка: нет связи с контрольным считывателем. Для работы скачайте и запустите следующее',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4088,'public','Копирование оператора',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4089,'public','Вы действительно хотите разблокировать этого оператора?',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4090,'public','Вы действительно хотите заблокировать этого оператора?',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4091,'public','Логин оператора уже используется',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4092,'public','Копировать можно только одного оператора',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4093,'public','Дата окончания',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4094,'public','Выбор устройства для получения идентификатора',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4096,'public','Нет доступа к данному помещению',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4097,'public','В виде графиков',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4098,'public','В виде таблицы',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4099,'public','Попытка ввода лицензионного ключа',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4100,'public','Установка контроллера на помещение',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4101,'public','В помещение',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4102,'public','установили: ',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4103,'public','Снятие контроллера с помещения',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4104,'public','Добавлен в помещение',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4105,'public','Для всех контроллеров в помещения',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4106,'public','Вы действительно хотите удалить выбранный контроллер? Часть информации о его событиях будет удалена',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4107,'public','до',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4108,'public','восстановлен','имеется в виду уволенный сотрудник','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4109,'public','восстановлено',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4110,'public','восстановлена',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4111,'public','чч',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4112,'public','мм',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4113,'public','сс',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4114,'public','Электронная проходная с картоприемником KT2.3 [1+8]',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4115,'public','Сортировка',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4116,'public','График восстановлен',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4117,'public','Должность восстановлена',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4118,'public','Подразделение восстановлено',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4119,'public','Шаблон доступа восстановлен',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4120,'public','Добавление комиссионирующей карты',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4121,'public','Удаление комиссионирующей карты',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4122,'public','в',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4123,'public','Установить РКД «Закрыто»: Выполнено',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4124,'public','Установить РКД «Закрыто»: Не выполнено',NULL,'2017-06-01 11:03:08',0);
INSERT INTO sourcemessage VALUES(4125,'public','Установить РКД «Контроль»: Выполнено',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4126,'public','Установить РКД «Контроль»: Не выполнено',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4127,'public','Установить РКД «Открыто»: Выполнено',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4128,'public','Установить РКД «Открыто»: Не выполнено',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4129,'public','Установить РКД «Совещание»: Выполнено',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4130,'public','Установить РКД «Совещание»: Не выполнено',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4131,'public','Модуль',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4132,'public','Код ошибки',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4133,'public','Электронная проходная с картоприемником KT2.3 [1]',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4134,'public','Электронная проходная с картоприемником KT2.3 [1+8]',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4135,'public','Электронная проходная с картоприемником №1',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4136,'public','Активизировать выход: Выполнено','##св-во контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4137,'public','Активизировать выход: Не выполнено','##св-во контроллера','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4138,'public','Нормализовать выход: Выполнено',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4139,'public','Нормализовать выход: Не выполнено',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4140,'public','Пароль не должен превышать 10 символов',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4141,'public','Посетитель удален в архив',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4142,'public','Не заполнено поле',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4143,'public','Переполнение поля',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4144,'public','Пересоздать посетителя',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4145,'public','Праздники для недельных режимов доступа',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4146,'public','Не указано подразделение',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4147,'public','Учитывать только первый вход и последний выход','для помещений','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4148,'public','Редактировать/Восстановить',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4149,'public','Добавление/удаление дней запрещено при наличии временных интервалов хотя бы в один из дней смены',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4150,'public','Проходы',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4151,'public','Регистрирующие',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4152,'public','Вычисленное',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4153,'public','Оправдательные документы с добавлением рабочего времени',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4154,'public','Уволен с',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4155,'public','Множественное редактирование сотрудников',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4156,'public','Действует до',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4157,'public','Вы действительно хотите закрыть окно? Все изменения будут потеряны!',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4158,'public','Регистрирующие учет рабочего времени',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4159,'public','Регистрирующие учет нерабочего времени',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4160,'public','Запущен перерасчет с',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4161,'public','Код / наименование',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4162,'public','Дата вступления в силу учетных данных меньше даты приема на работу',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4163,'public','Редактировать день',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4164,'public','Для контроллера',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4165,'public','Месяц',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4166,'public','Посмотреть график работы',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4167,'public','Не выбрано ни одного сотрудника',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4168,'public','Документы без добавления времени',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4169,'public','Отчет',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4170,'public','Сотрудник с таким же именем уже существует в подразделении',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4171,'public','Сотрудник с таким же именем уже существует в подразделениях',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4172,'public','Значение должно быть в диапазоне от 0 до 251',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4173,'public','Вы действительно хотите изъять карту у сотрудника?',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4174,'public','день соответствует 1-му типу',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4175,'public','день соответствует 2-му типу',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4176,'public','день соответствует 3-му типу',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4177,'public','день соответствует 4-му типу',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4178,'public','день соответствует 5-му типу',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4179,'public','день соответствует 6-му типу',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4180,'public','день соответствует 7-му типу',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4181,'public','день соответствует 8-му типу',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4182,'public','Ошибка: нет связи с контрольным считывателем, проверьте подключение',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4183,'public','Первый вход','в контексте прохода человека, те для помещений','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4184,'public','Последний выход',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4185,'public','Ошибка: документ с таким буквенным кодом уже существует',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4186,'public','Ошибка: документ с таким числовым кодом уже существует',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4187,'public','Ошибка: документ с таким буквенным и числовым кодами уже существует',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4188,'public','Нарушений дисциплины в течение рабочего дня',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4189,'public','Итого нарушений дисциплины',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4190,'public','с переходом через 0',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4191,'public','Изымать идентификаторы посетителей после прохода',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4192,'public','Сбросить зональность идентификаторов',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4193,'public','Таймаут верификации',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4194,'public','Запомнить данные и войти в систему',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4195,'public','Что-то пошло не так... попробуйте отредактировать импортируемый файл, подробности в HELP.',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4196,'public','шаблон верификации открыт в другом окне',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4197,'public','точка верификации занята',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4198,'public','Присутствие до начала рабочего дня',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4199,'public','Присутствие после окончания рабочего дня',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4200,'public','Индикация: проход посетителя и изъятие карты',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4201,'public','Значение должно быть от 1 до 12',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4202,'public','Занят другим сервером',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4203,'public','Несоответствие типа или шаблона контроллера','EVENT_TYPE','2017-11-23 10:38:19',0);
INSERT INTO sourcemessage VALUES(4204,'public','Количество графиков превышает возможно допустимое',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4205,'public','Количество заданий превышает возможно допустимое',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4206,'public','Невозможно создать задание. Количество заданий максимально',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4207,'public','Невозможно создать шаблон пропуска. Количество шаблонов пропусков максимально',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4208,'public','Невозможно создать поле. Количество полей максимально',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4209,'public','Невозможно создать графическое поле. Количество графических полей максимально',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4210,'public','Невозможно создать шаблон доступа. Количество шаблонов доступа максимально',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4211,'public','Невозможно добавить контроллер. Количество контроллеров максимально',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4212,'public','Невозможно добавить помещение. Количество помещений максимально',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4213,'public','Невозможно создать оператора. Количество операторов максимально',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4214,'public','Невозможно создать роль. Количество ролей максимально',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4215,'public','Невозможно добавить видеосервер. Количество видеосерверов максимально',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4216,'public','Невозможно добавить шаблон верификации. Количество шаблонов верификации максимально',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4217,'public','Невозможно создать посетителя. Количество посетителей максимально',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4218,'public','Отчет по доступу в помещения',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4219,'public','Учет рабочего времени за предыдущий день',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4220,'public','Сервер системы работает',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4221,'public','Сервер системы работает с ошибками',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4222,'public','Подключение к серверу системы...',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4223,'public','Невозможно создать действующего посетителя. Количество действующих посетителей максимально',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4224,'public','Невозможно отправить посетителя в архив. Количество посетителей в архиве максимально',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4225,'public','Невозможно создать сотрудника. Количество сотрудников максимально',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4226,'public','Невозможно уволить сотрудника. Количество уволенных сотрудников максимально',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4227,'public','Длительность импульса управления ИУ (миллисекунд)',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4228,'public','штук',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4229,'public','выход в',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4230,'public','Значение (секунд)',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4231,'public','Подключение к контроллеру...',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4232,'public','контроллер отключен',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4233,'public','Все в контроллер(ы)',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4234,'public','Измененные в контроллер(ы)',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4235,'public','Отображение информации (в течение какого времени после прохода (или другого события) будет отображаться информация о проходе/событии)',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4236,'public','Постановка на охрану (только для контроллеров замка)',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4237,'public','Снятие с охраны (только для контроллеров замка)',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4238,'public','Должно быть указано хотя бы одно постоянное подразделение.',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4239,'public','Параметры отображения информации',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4240,'public','Да (режим верификации)',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4241,'public','Нет (режим индикации)',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4242,'public','пожалуйста, подождите...',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4243,'public','Продолжительность записи (секунд)',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4244,'public','Продолжительность предзаписи (секунд)',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4245,'public','Редактировать точку верификации',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4246,'public','Удалить точку верификации',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4247,'public','В данный момент управление указанным контроллером невозможно. Обратитесь к администратору системы за помощью',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4248,'public','Искомая карта в данной таблице не обнаружена. Однако она найдена на странице',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4249,'public','во вкладке',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4250,'public','С ошибками',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4251,'public','Всего устройств',NULL,'2017-12-22 10:39:49',0);
INSERT INTO sourcemessage VALUES(4252,'public','Состояние системы',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4253,'public','Работает',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4254,'public','Отключено',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4255,'public','Отсутствующие на текущий момент',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4256,'public','Пароль может содержать любые символы, кроме пробела, должен быть длиннее 6 символов и содержать хотя бы одну букву латинского алфавита или цифру',NULL,'2016-06-23 11:54:36',0);
INSERT INTO sourcemessage VALUES(4257,'public','Данный дизайн был удален',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4258,'public','Ошибка сохранения в базу данных.',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4259,'public','Выбранный шаблон доступа был удален',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4260,'public','Выбранная должность была удалена',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4261,'public','Выбранное подразделение было удалено',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4262,'public','Выбранный график был удален',NULL,'2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4265,'public','Значение (секунд, 2 - 120)','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4284,'public','Подразделение не найдено!','','2016-04-08 15:39:30',0);
INSERT INTO sourcemessage VALUES(4285,'public','Слишком большая вложенность! Максимальная вложенность не может превышать 128','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4286,'public','истекла','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4287,'public','истек','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4288,'public','Выбранный видео сервер был удален','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4289,'public','Выбранный человек был удален','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4290,'public','Выбранная камера была удалена','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4291,'public','Выбранная карта была удалена','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4292,'public','Выбранное устройство было удалено','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4293,'public','Выбранный сотрудник был удален','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4294,'public','Выбранный посетитель был удален','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4295,'public','Выбранное событие было удалено','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4296,'public','Выбранный день отсутствует в выбранном месяце','Выводится сообщение, если указанный день отсутствует в месяце. Например выбрано 31 число, а месяц февраль.','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4297,'public','Вы действительно хотите очистить календарь?','Персона - Графики работы - праздничные дни - кнопка "Очистить" http://172.17.0.20/personal/schedule','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4299,'public','Установленные ранее праздники, совпадающие с предопределенными значениями будут перезатерты!','Персона - Графики работы - праздничные дни - кнопка "Заполнить предопределенными значениями" http://172.17.0.20/personal/schedule','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4300,'public','Выбранный праздник был удален','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4301,'public','Создаваемый праздник уже существует','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4302,'public','Верификация: снятие верификации в связи с несанкционированным проходом','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4303,'public','Создаваемый шаблон доступа уже существует','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4304,'public','Создаваемая должность уже существует','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4305,'public','Создаваемое подразделение уже существует','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4306,'public','Создаваемый график уже существует','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4307,'public','Создаваемый видео сервер уже существует','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4308,'public','Создаваемый человек уже существует','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4309,'public','Создаваемая камера уже существует','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4310,'public','Создаваемая карта уже существует','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4311,'public','Создаваемое устройство уже существует','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4312,'public','Создаваемый сотрудник уже существует','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4313,'public','Создаваемый посетитель уже существует','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4314,'public','Создаваемое событие уже существует','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4315,'public','Верификация: запрещено оператором','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4316,'public','Верификация: разрешено оператором','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4317,'public','Выберите вариант восстановления сотрудника:','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4319,'public','Редактировать и восстановить','##event_type. Персонал - сотрудники - уволенные - восстановление сотрудника. http://172.17.0.20/personal/staff','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4320,'public','Сохранить и восстановить','##event_type. Персонал - сотрудники - уволенные - учетная карточка сотрудника. http://172.17.0.20/personal/staff','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4321,'public','Возможно требуется','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4322,'public','подтверждение','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4323,'public','для работы через защищенное соединение','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4324,'public','Сообщение','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4325,'public','Печать данных','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4326,'public','Вы действительно хотите изъять карты у сотрудника(ов)?','public','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4327,'public','Учётные данные','Персонал - сотрудники - учетная карточка сотрудника - планировщикз(заголовок таблицы). http://172.17.0.20/personal/staff','2016-04-13 12:07:31',0);
INSERT INTO sourcemessage VALUES(4328,'public','Слишком большое значение (число или длина строки)','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4330,'public','вск','Праздничные дни http://172.17.0.20/personal/schedule','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4331,'public','пн','Праздничные дни\r\nhttp://172.17.0.20/personal/schedule','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4332,'public','вт','Праздничные дни\r\nhttp://172.17.0.20/personal/schedule','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4333,'public','ср','Праздничные дни http://172.17.0.20/personal/schedule','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4334,'public','чт','Праздничные дни\r\nhttp://172.17.0.20/personal/schedule','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4335,'public','пт','http://172.17.0.20/personal/schedule','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4336,'public','Дополнительные текстовые поля','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4337,'public','Дополнительные графические поля','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4338,'public','Документы без добавления времени / Сверхурочные','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4339,'public','Сбросить зональность','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4340,'public','Авторизация пользователя','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4341,'public','Вход оператора в систему','Вход имеется в виду логинится','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4342,'public','с IP-адреса:','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4343,'public','не определен','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4344,'public','Список заказанных пропусков','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4345,'public','Выход оператора из системы','человек разлогинивается','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4346,'public','Работа с событиями прохода','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4347,'public','Редактирование события прохода','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4348,'public','Дата и время события','','2016-04-08 15:39:31',0);
INSERT INTO sourcemessage VALUES(4366,'public','Одно из обязательных полей не заполнено (фамилия, имя или подразделение).','','2016-04-14 09:31:28',0);
INSERT INTO sourcemessage VALUES(4367,'public','Лицензирующий контроллер занят другим сервером','','2016-04-12 12:44:34',0);
INSERT INTO sourcemessage VALUES(4368,'public','Ошибка типа лицензирующего контроллера','','2016-04-12 12:45:37',0);
INSERT INTO sourcemessage VALUES(4369,'public','Ошибка пароля лицензирующего контроллера','','2016-04-12 12:50:17',0);
INSERT INTO sourcemessage VALUES(4370,'public','Лицензия','','2016-04-12 15:25:34',0);
INSERT INTO sourcemessage VALUES(4371,'public','Дополнительная информация','','2016-04-13 12:45:30',0);
INSERT INTO sourcemessage VALUES(4372,'public','уволенные сотрудники','','2016-04-14 12:37:43',0);
INSERT INTO sourcemessage VALUES(4373,'public','действующие сотрудники','','2016-04-14 12:37:55',0);
INSERT INTO sourcemessage VALUES(4374,'public','Неизвестная ошибка','','2016-04-14 16:21:44',0);
INSERT INTO sourcemessage VALUES(4375,'public','Архив пропусков','пропуск - это "прогул" или "карточка для прохода"? - это карточка','2017-05-26 10:48:27',0);
INSERT INTO sourcemessage VALUES(4376,'public','Архив посетителей','','2016-04-14 17:39:10',0);
INSERT INTO sourcemessage VALUES(4377,'public','Для редактирования необходимо выбрать один элемент','','2016-04-18 10:03:56',0);
INSERT INTO sourcemessage VALUES(4378,'public','В архиве уволенных слишком много записей. Пожалуйста, удалите вручную не нужные вам, или обратитесь к администратору.','','2016-04-26 12:57:16',0);
INSERT INTO sourcemessage VALUES(4379,'public','Превышено время ожидания ответа от веб-сервера, попробуйте уменьшить размер импортируемого файла или повторите попытку позже.','','2016-04-18 15:54:34',0);
INSERT INTO sourcemessage VALUES(4380,'public','Вы действительно хотите прервать импорт?','','2016-04-20 12:14:54',0);
INSERT INTO sourcemessage VALUES(4381,'public','Расширенный поиск','','2016-04-25 12:52:58',0);
INSERT INTO sourcemessage VALUES(4382,'public','Очередь команд','','2016-05-05 15:52:55',0);
INSERT INTO sourcemessage VALUES(4383,'public','Нет подтверждения (запрет прохода)','','2016-05-06 10:24:20',0);
INSERT INTO sourcemessage VALUES(4384,'public','Формат даты','','2016-05-12 13:30:41',0);
INSERT INTO sourcemessage VALUES(4385,'public','Ошибка конфигурации - группа на охране или в тревоге','','2016-05-13 10:17:51',0);
INSERT INTO sourcemessage VALUES(4386,'public','Ошибка управления - ресурс на охране','','2016-05-13 10:19:19',0);
INSERT INTO sourcemessage VALUES(4387,'public','Начало выполнения задания','','2016-05-13 10:19:32',0);
INSERT INTO sourcemessage VALUES(4388,'public','От веб-сервера не было ответа длительное время. Попробуйте обновить страницу или повторите попытку позднее','','2016-05-16 11:13:08',0);
INSERT INTO sourcemessage VALUES(4389,'public','Список событий изменился. Возможно, люди, помещения или контроллеры, связанные с ними, были изменены или удалены','','2016-05-24 08:45:46',0);
INSERT INTO sourcemessage VALUES(4390,'public','Пересечение интервалов','','2016-05-24 10:17:15',0);
INSERT INTO sourcemessage VALUES(4391,'public','Для сотрудника','','2016-05-25 17:34:27',0);
INSERT INTO sourcemessage VALUES(4392,'public','Данные текущего контроллера не сохранены. Сохранить?','','2016-05-26 12:34:42',0);
INSERT INTO sourcemessage VALUES(4393,'public','Сохранить и закрыть','','2016-05-26 12:36:25',0);
INSERT INTO sourcemessage VALUES(4394,'public','Дата входа','','2016-05-26 14:48:14',0);
INSERT INTO sourcemessage VALUES(4395,'public','Находится в помещении','','2016-05-26 15:22:02',0);
INSERT INTO sourcemessage VALUES(4396,'public','бессрочная','','2016-05-27 11:52:32',0);
INSERT INTO sourcemessage VALUES(4397,'public','Данный поператор уже заблокирован','','2016-05-31 11:44:28',0);
INSERT INTO sourcemessage VALUES(4398,'public','Данный оператор не заблокирован','','2016-05-31 11:44:37',0);
INSERT INTO sourcemessage VALUES(4399,'public','Имя графика содержит недопустимый символ','','2016-05-31 17:49:29',0);
INSERT INTO sourcemessage VALUES(4400,'public','содержит недопустимый символ','','2016-06-01 13:18:53',0);
INSERT INTO sourcemessage VALUES(4401,'public','Имя должности','','2016-06-01 13:24:33',0);
INSERT INTO sourcemessage VALUES(4402,'public','Не учитывать нарушения менее чем на','','2016-06-07 16:31:46',0);
INSERT INTO sourcemessage VALUES(4403,'public','нарушения менее чем на','','2016-06-07 16:39:42',0);
INSERT INTO sourcemessage VALUES(4404,'public','Поместить на задний план','','2016-06-09 12:51:07',0);
INSERT INTO sourcemessage VALUES(4405,'public','Поместить на передний план','','2016-06-09 12:51:14',0);
INSERT INTO sourcemessage VALUES(4406,'public','Номер подтверждающего документа','','2016-06-10 09:13:48',0);
INSERT INTO sourcemessage VALUES(4407,'public','Добавить точку верифкации','','2016-06-14 12:46:41',0);
INSERT INTO sourcemessage VALUES(4408,'public','Нарушение РКД','РКД? -  режим контроля доступа','2017-05-26 10:48:08',0);
INSERT INTO sourcemessage VALUES(4409,'public','&#34;Действителен до&#34; должно быть больше сегодняшней даты','','2016-06-17 15:37:55',0);
INSERT INTO sourcemessage VALUES(4410,'public','Пароль и подтверждение пароля не совпадают','','2016-06-23 11:56:10',0);
INSERT INTO sourcemessage VALUES(4411,'public','Пароль должен быть длиннее 6 символов','','2016-06-23 11:56:45',0);
INSERT INTO sourcemessage VALUES(4412,'public','Пароль должен содержать хотя бы одну латинскую букву','','2016-06-23 11:57:15',0);
INSERT INTO sourcemessage VALUES(4413,'public','Пароль должен содержать хотя бы одну цифру','','2016-06-23 11:57:40',0);
INSERT INTO sourcemessage VALUES(4414,'public','Требуется корректировка проходов','','2016-06-28 13:48:02',0);
INSERT INTO sourcemessage VALUES(4417,'public','Ошибка: контроллер не найден или отключен','','2016-06-29 15:15:43',0);
INSERT INTO sourcemessage VALUES(4418,'public','Пароль должен содержать хотя бы одну букву и хотя бы одну цифру','','2016-07-01 13:04:28',0);
INSERT INTO sourcemessage VALUES(4419,'public','Все ответы','','2016-07-05 09:15:00',0);
INSERT INTO sourcemessage VALUES(4420,'public','Пароль может содержать любые символы, кроме пробела, должен быть длиннее 6 символов, содержать хотя бы одну букву латинского алфавита и хотя бы одну цифру','','2016-07-06 15:29:14',0);
INSERT INTO sourcemessage VALUES(4421,'public','Только оператор с правами администратора имеет возможность отключения или включения модулей','','2016-07-15 11:15:40',0);
INSERT INTO sourcemessage VALUES(4422,'public','Лицензия для данного раздела отключена','','2016-07-15 12:27:14',0);
INSERT INTO sourcemessage VALUES(4423,'public','Максимальное количество действующих карт доступа в базовой версии программного обеспечения 100 штук.','','2016-07-26 13:34:45',0);
INSERT INTO sourcemessage VALUES(4424,'public','В бесплатной версии пользование картами для посетителей заблокировано','','2016-07-18 12:28:25',0);
INSERT INTO sourcemessage VALUES(4425,'public','Осталось','','2016-07-20 10:15:01',0);
INSERT INTO sourcemessage VALUES(4426,'public','дней','','2016-07-20 10:15:39',0);
INSERT INTO sourcemessage VALUES(4427,'public','Ознакомительный период','','2016-07-20 10:16:20',0);
INSERT INTO sourcemessage VALUES(4428,'public','Ошибка авторизации','','2017-04-11 16:33:04',0);
INSERT INTO sourcemessage VALUES(4429,'public','Дата увольнения не может быть раньше даты приема на работу','','2016-07-25 17:23:40',0);
INSERT INTO sourcemessage VALUES(4430,'public','Для активизации данной лицензии необходимо предварительно активировать Стандартный пакет.','','2016-07-26 16:44:56',0);
INSERT INTO sourcemessage VALUES(4431,'public','Максимальное количество действующих карт доступа в базовой версии программного обеспечения - 100 штук.','','2016-07-27 14:15:30',0);
INSERT INTO sourcemessage VALUES(4432,'public','карт','','2016-08-01 10:35:05',0);
INSERT INTO sourcemessage VALUES(4433,'public','более','','2016-08-01 10:35:40',0);
INSERT INTO sourcemessage VALUES(4434,'public','Дата начала не может быть раньше даты приема','','2016-08-01 10:38:15',0);
INSERT INTO sourcemessage VALUES(4435,'public','Отключение "Стандартного пакета"','','2017-07-19 15:37:56',0);
INSERT INTO sourcemessage VALUES(4436,'public','При отключении модуля "Стандартный пакет" количество действующих карт будет ограничено 100 картами сотрудников. Ранее введенные карты посетителей и карты сотрудников больше 100 (в порядке добавления) будут заблокированы. Также будут отключены зависимые модули "Учёт рабочего времени" и "Верификации". <br/><br/>  Вы уверены, что хотите отключить "Стандартный пакет"?','','2017-07-19 15:53:32',0);
INSERT INTO sourcemessage VALUES(4437,'public','Не выбран ни один считыватель','','2016-08-02 10:26:56',0);
INSERT INTO sourcemessage VALUES(4438,'public','Пароль должен быть длиннее 6 символов и содержать хотя бы одну букву латинского алфавита и хотя бы одну цифру.','','2016-08-03 09:34:57',0);
INSERT INTO sourcemessage VALUES(4439,'public','Для работы с разделом необходимо сначала создать подразделение или запросить доступ к ним у администратора системы PERCo-Web','','2016-08-03 09:43:02',0);
INSERT INTO sourcemessage VALUES(4440,'public','не может быть удалено, так как к нему приписаны следующие сотрудники/посетители','','2017-08-24 17:16:02',0);
INSERT INTO sourcemessage VALUES(4441,'public','Добавить праздничный день','','2016-08-03 12:11:20',0);
INSERT INTO sourcemessage VALUES(4442,'public','Календарь предопределенных праздничных дней','','2016-08-03 12:39:30',0);
INSERT INTO sourcemessage VALUES(4443,'public','для следующих сотрудников','','2016-08-03 14:18:49',0);
INSERT INTO sourcemessage VALUES(4444,'public','Величина сокращения не должна превышать 2 часа','','2016-08-03 17:11:34',0);
INSERT INTO sourcemessage VALUES(4445,'public','Дата начала не может быть раньше даты приема.','','2016-08-05 11:11:42',0);
INSERT INTO sourcemessage VALUES(4446,'public','Повторяющийся номер карты','','2016-08-05 14:49:39',0);
INSERT INTO sourcemessage VALUES(4447,'public','Видеосервер не может быть удален.','','2016-08-08 11:33:57',0);
INSERT INTO sourcemessage VALUES(4448,'public','Шаблон не может быть удален, поскольку задействован в одной из камер.','','2016-08-15 16:24:55',0);
INSERT INTO sourcemessage VALUES(4449,'public','Выберите видеосервер для добавления камеры','','2016-08-16 09:12:44',0);
INSERT INTO sourcemessage VALUES(4450,'public','Ошибка сохранения изображения','','2016-08-24 17:07:16',0);
INSERT INTO sourcemessage VALUES(4451,'public','день','','2016-08-29 15:23:23',0);
INSERT INTO sourcemessage VALUES(4452,'public','дня','','2016-08-29 15:24:14',0);
INSERT INTO sourcemessage VALUES(4453,'public','осталось','','2016-08-29 16:30:28',0);
INSERT INTO sourcemessage VALUES(4454,'public','остался','','2016-08-29 16:32:55',0);
INSERT INTO sourcemessage VALUES(4455,'public','Превышено максимальное число сотрудников в выбранных подразделениях (500 сотрудников). Попробуйте построить несколько отчётов по отдельным вложенным подразделениям.','','2016-09-07 14:39:12',0);
INSERT INTO sourcemessage VALUES(4456,'public','Работа с лицензиями','','2016-09-09 16:42:13',0);
INSERT INTO sourcemessage VALUES(4457,'public','Включение лицензии','','2016-09-09 16:48:14',0);
INSERT INTO sourcemessage VALUES(4458,'public','Отключение лицензии','','2016-09-09 16:48:51',0);
INSERT INTO sourcemessage VALUES(4459,'public','Смена лицензионного контроллера','','2016-09-09 17:06:19',0);
INSERT INTO sourcemessage VALUES(4460,'public','Права доступа','','2016-09-12 14:34:40',0);
INSERT INTO sourcemessage VALUES(4461,'public','Невозможно создать подразделение. Количество подразделений максимально','','2016-09-13 12:06:16',0);
INSERT INTO sourcemessage VALUES(4462,'public','Невозможно создать должность. Количество должностей максимально','','2016-09-13 12:07:44',0);
INSERT INTO sourcemessage VALUES(4463,'public','Карта и отпечатки пальцев будут изъяты.','','2016-12-05 16:32:31',0);
INSERT INTO sourcemessage VALUES(4464,'public','Передать все данные в контроллеры','','2016-12-06 10:55:28',0);
INSERT INTO sourcemessage VALUES(4465,'public','Не указан идентификатор','','2016-12-14 17:19:30',0);
INSERT INTO sourcemessage VALUES(4466,'public','Сотрудник будет перемещен в раздел "уволенные", идентификаторы будут изъяты.','','2016-12-14 17:26:59',0);
INSERT INTO sourcemessage VALUES(4467,'public','Сотрудники будут перемещены в раздел `уволенные`, идентификаторы будут изъяты.','','2016-12-14 17:34:10',0);
INSERT INTO sourcemessage VALUES(4468,'public','ВНИМАНИЕ! В случае изменения данных параметров Вы не сможете поднять уровень безопасности у уже используемых карт данного типа. Рекомендуем или поднять его до максимально желаемого уровня до изменения данных параметров, или сохранить где-либо значения данных параметров, чтобы их можно было ввести повторно при необходимости поднятия уровня у используемых сейчас карт данного типа','','2017-01-31 17:13:15',0);
INSERT INTO sourcemessage VALUES(4469,'public','Ключи для карт Mifare не могут иметь пустое или неполное значение','','2017-02-10 12:36:58',0);
INSERT INTO sourcemessage VALUES(4470,'public','Поле не может иметь неполное значение','','2017-02-10 12:37:31',0);
INSERT INTO sourcemessage VALUES(4471,'public','Текущие изменения не были сохранены в память','','2017-02-10 15:56:33',0);
INSERT INTO sourcemessage VALUES(4473,'public','Не правильный формат карты','','2017-02-21 09:41:17',0);
INSERT INTO sourcemessage VALUES(4474,'public','Не удалось аутентифицироваться. Неверный ключ в конфигурации для карты','','2017-03-31 12:24:04',0);
INSERT INTO sourcemessage VALUES(4476,'public','Карты Mifare','','2017-04-11 17:03:08',0);
INSERT INTO sourcemessage VALUES(4477,'public','Запись конфигурации в память','','2017-04-11 17:13:18',0);
INSERT INTO sourcemessage VALUES(4478,'public','Запись конфигурации на мастер-карту','','2017-04-11 17:15:11',0);
INSERT INTO sourcemessage VALUES(4479,'public','Изменить ключ','','2017-04-11 17:17:03',0);
INSERT INTO sourcemessage VALUES(4480,'public','Получить информацию о карте','','2017-04-11 17:17:56',0);
INSERT INTO sourcemessage VALUES(4481,'public','Старый ключ аутентификации','','2017-04-11 17:23:26',0);
INSERT INTO sourcemessage VALUES(4482,'public','Ключ аутентификации','','2017-04-11 17:24:20',0);
INSERT INTO sourcemessage VALUES(4483,'public','Команды управления картами','','2017-04-11 17:25:23',0);
INSERT INTO sourcemessage VALUES(4484,'public','Номер блока','','2017-04-11 17:25:59',0);
INSERT INTO sourcemessage VALUES(4485,'public','Старый тип ключа для аутентификации','','2017-04-11 17:27:20',0);
INSERT INTO sourcemessage VALUES(4486,'public','Тип ключа аутентификации','','2017-04-11 17:27:53',0);
INSERT INTO sourcemessage VALUES(4487,'public','ВНИМАНИЕ! В случае изменения данных параметров необходимо записать мастер-карту с новыми параметрами, после чего переконфигурировать ей все считыватели и перепрограммировать все карты доступа этого типа','','2017-04-11 17:28:25',0);
INSERT INTO sourcemessage VALUES(4488,'public','Предупреждение','','2017-04-11 17:29:38',0);
INSERT INTO sourcemessage VALUES(4489,'public','Номер сектора','','2017-04-11 17:30:23',0);
INSERT INTO sourcemessage VALUES(4490,'public','Старый ключ для уровня безопасности SL3 при типе ключа A','','2017-04-11 17:31:47',0);
INSERT INTO sourcemessage VALUES(4491,'public','Старый ключ для уровня безопасности SL3 при типе ключа B','','2017-04-11 17:33:02',0);
INSERT INTO sourcemessage VALUES(4492,'public','Ключ для уровня безопасности SL3 при типе ключа A','','2017-04-11 17:33:34',0);
INSERT INTO sourcemessage VALUES(4493,'public','Ключ для уровня безопасности SL3 при типе ключа B','','2017-04-11 17:34:17',0);
INSERT INTO sourcemessage VALUES(4494,'public','Уровень безопасности SL','','2017-04-11 17:34:53',0);
INSERT INTO sourcemessage VALUES(4495,'public','Мастер ключ','','2017-04-11 17:45:07',0);
INSERT INTO sourcemessage VALUES(4496,'public','Конфигурационный ключ','','2017-04-11 17:46:58',0);
INSERT INTO sourcemessage VALUES(4497,'public','Ключ аутентификации для уровня безопасности SL1','','2017-04-11 17:50:16',0);
INSERT INTO sourcemessage VALUES(4498,'public','Ключ переключения на уровень безопасности SL2','','2017-04-11 17:51:29',0);
INSERT INTO sourcemessage VALUES(4499,'public','Ключ переключения на уровень безопасности SL3','','2017-04-11 17:52:14',0);
INSERT INTO sourcemessage VALUES(4500,'public','Повысить уровень безопасности SL','','2017-04-11 17:54:51',0);
INSERT INTO sourcemessage VALUES(4501,'public','Старый номер приложения','','2017-04-11 17:55:20',0);
INSERT INTO sourcemessage VALUES(4502,'public','Старый тип ключа карты','','2017-04-11 17:56:26',0);
INSERT INTO sourcemessage VALUES(4503,'public','Старый ключ карты','','2017-04-12 09:49:12',0);
INSERT INTO sourcemessage VALUES(4504,'public','Старый тип ключа приложения','','2017-04-12 09:49:47',0);
INSERT INTO sourcemessage VALUES(4505,'public','Старый ключ приложения','','2017-04-12 09:50:09',0);
INSERT INTO sourcemessage VALUES(4506,'public','Номер приложения','','2017-04-12 09:50:31',0);
INSERT INTO sourcemessage VALUES(4507,'public','Тип ключа карты','','2017-04-12 09:51:00',0);
INSERT INTO sourcemessage VALUES(4508,'public','Ключ карты','','2017-04-12 09:51:49',0);
INSERT INTO sourcemessage VALUES(4509,'public','Тип ключа приложения','','2017-04-12 09:52:14',0);
INSERT INTO sourcemessage VALUES(4510,'public','Ключ приложения','','2017-04-12 09:52:35',0);
INSERT INTO sourcemessage VALUES(4511,'public','Форматировать','','2017-04-12 09:53:14',0);
INSERT INTO sourcemessage VALUES(4512,'public','Выберите типы карт','','2017-04-12 09:53:46',0);
INSERT INTO sourcemessage VALUES(4513,'public','Типы карт Mifare','','2017-04-12 09:55:08',0);
INSERT INTO sourcemessage VALUES(4514,'public','Контроллеры Suprema','','2017-04-12 09:56:18',0);
INSERT INTO sourcemessage VALUES(4515,'public','Норма','Состояние контроллера (в обычном режиме)','2017-04-12 10:17:18',0);
INSERT INTO sourcemessage VALUES(4516,'public','Ошибка RTC','','2017-04-12 10:18:41',0);
INSERT INTO sourcemessage VALUES(4517,'public','Ожидание поднесения пальца','','2017-04-12 10:19:18',0);
INSERT INTO sourcemessage VALUES(4518,'public','Ожидание DHCP','','2017-04-12 10:19:54',0);
INSERT INTO sourcemessage VALUES(4519,'public','Сканирование пальца','','2017-04-12 10:20:27',0);
INSERT INTO sourcemessage VALUES(4520,'public','Сканирование карты','','2017-04-12 10:24:17',0);
INSERT INTO sourcemessage VALUES(4521,'public','Идентификация успешна','','2017-04-12 10:26:18',0);
INSERT INTO sourcemessage VALUES(4522,'public','Ошибка идентификации','','2017-04-12 10:26:50',0);
INSERT INTO sourcemessage VALUES(4523,'public','Бесконечно','','2017-04-12 10:27:27',0);
INSERT INTO sourcemessage VALUES(4524,'public','раз','количество раз ','2017-04-12 10:29:06',0);
INSERT INTO sourcemessage VALUES(4525,'public','Задержка','перерыв между сигналами','2017-04-12 10:29:53',0);
INSERT INTO sourcemessage VALUES(4526,'public','затухание','звуковой сигнал приглушается в конце','2017-04-12 10:32:27',0);
INSERT INTO sourcemessage VALUES(4527,'public','мс','миллисекунда','2017-04-12 10:34:25',0);
INSERT INTO sourcemessage VALUES(4528,'public','Красный','','2017-04-12 10:36:02',0);
INSERT INTO sourcemessage VALUES(4529,'public','Желтый','','2017-04-12 10:36:25',0);
INSERT INTO sourcemessage VALUES(4530,'public','Зеленый','','2017-04-12 10:36:45',0);
INSERT INTO sourcemessage VALUES(4531,'public','Голубой','','2017-04-12 10:37:09',0);
INSERT INTO sourcemessage VALUES(4532,'public','Синий','','2017-04-12 10:37:22',0);
INSERT INTO sourcemessage VALUES(4533,'public','Пурпурный','','2017-04-12 10:37:44',0);
INSERT INTO sourcemessage VALUES(4534,'public','Белый','','2017-04-12 10:38:13',0);
INSERT INTO sourcemessage VALUES(4535,'public','Средний','Тон звучания','2017-04-12 10:48:22',0);
INSERT INTO sourcemessage VALUES(4536,'public','Высокий','Тон звучания','2017-04-12 10:49:06',0);
INSERT INTO sourcemessage VALUES(4537,'public','Тон','Тон звучания','2017-04-12 10:49:54',0);
INSERT INTO sourcemessage VALUES(4538,'public','Звук','звуковой сигнал','2017-04-12 10:50:24',0);
INSERT INTO sourcemessage VALUES(4539,'public','Подсветка','','2017-04-12 10:50:55',0);
INSERT INTO sourcemessage VALUES(4540,'public','Цвет','','2017-04-12 10:51:14',0);
INSERT INTO sourcemessage VALUES(4541,'public','Общие настройки карт Mifare','','2017-04-12 10:53:08',0);
INSERT INTO sourcemessage VALUES(4542,'public','Чтение из защищенной области','','2017-04-12 10:53:50',0);
INSERT INTO sourcemessage VALUES(4543,'public','Ключ закрытия мастер-карты','','2017-04-12 10:54:10',0);
INSERT INTO sourcemessage VALUES(4544,'public','Новый ключ закрытия мастер-карты','','2017-04-12 10:54:29',0);
INSERT INTO sourcemessage VALUES(4545,'public','Простое чтение','','2017-04-12 10:55:06',0);
INSERT INTO sourcemessage VALUES(4546,'public','С записью карты','','2017-04-12 10:55:32',0);
INSERT INTO sourcemessage VALUES(4547,'public','Версия прошивки','св-ва контроллера','2017-04-12 11:06:44',0);
INSERT INTO sourcemessage VALUES(4548,'public','Электронная проходная KT05.3A [1]','','2017-04-12 11:11:39',0);
INSERT INTO sourcemessage VALUES(4549,'public','Не задано','св-ва контроллера замка','2017-04-12 11:16:49',0);
INSERT INTO sourcemessage VALUES(4550,'public','Выбрать подразделение','','2017-04-12 11:18:50',0);
INSERT INTO sourcemessage VALUES(4551,'public','Выберите подразделение','','2017-04-12 11:19:34',0);
INSERT INTO sourcemessage VALUES(4552,'public','«Вход»','','2017-04-12 11:23:45',0);
INSERT INTO sourcemessage VALUES(4553,'public','Назначение','','2017-04-12 11:32:00',0);
INSERT INTO sourcemessage VALUES(4554,'public','1-я строка «Карты нет в списке»','','2017-04-12 11:40:02',0);
INSERT INTO sourcemessage VALUES(4555,'public','«Выход»','','2017-04-12 11:40:45',0);
INSERT INTO sourcemessage VALUES(4556,'public','2-я строка «Карты нет в списке»','','2017-04-12 11:42:27',0);
INSERT INTO sourcemessage VALUES(4557,'public','«зарегистрирован повторно» для входа','','2017-04-12 11:43:35',0);
INSERT INTO sourcemessage VALUES(4558,'public','«зарегистрирован повторно» для выхода','','2017-04-12 11:44:14',0);
INSERT INTO sourcemessage VALUES(4559,'public','«нарушение зоны» для входа','','2017-04-12 11:45:01',0);
INSERT INTO sourcemessage VALUES(4560,'public','«нарушение зоны» для выхода','','2017-04-12 11:45:37',0);
INSERT INTO sourcemessage VALUES(4561,'public','строка направления прохода правая верхняя','','2017-04-12 11:46:09',0);
INSERT INTO sourcemessage VALUES(4562,'public','строка направления прохода левая нижняя','','2017-04-12 11:47:06',0);
INSERT INTO sourcemessage VALUES(4563,'public','1-я строка «Вход не зарегистрирован. Нарушение зоны»','','2017-04-12 11:47:28',0);
INSERT INTO sourcemessage VALUES(4564,'public','2-я строка «Вход не зарегистрирован. Нарушение зоны»','','2017-04-12 11:47:51',0);
INSERT INTO sourcemessage VALUES(4565,'public','3-я строка «Вход не зарегистрирован. Нарушение зоны»','','2017-04-12 11:48:12',0);
INSERT INTO sourcemessage VALUES(4566,'public','1-я строка «Выход не зарегистрирован. Нарушение зоны»','','2017-04-12 11:49:21',0);
INSERT INTO sourcemessage VALUES(4567,'public','2-я строка «Выход не зарегистрирован. Нарушение зоны»','','2017-04-12 11:49:55',0);
INSERT INTO sourcemessage VALUES(4568,'public','3-я строка «Выход не зарегистрирован. Нарушение зоны»','','2017-04-12 11:50:20',0);
INSERT INTO sourcemessage VALUES(4569,'public','1-я строка «Для регистрации выхода используйте считыватель "Выход"»','','2017-04-12 11:50:44',0);
INSERT INTO sourcemessage VALUES(4570,'public','2-я строка «Для регистрации выхода используйте считыватель "Выход"»','','2017-04-12 11:51:38',0);
INSERT INTO sourcemessage VALUES(4571,'public','3-я строка «Для регистрации выхода используйте считыватель "Выход"»','','2017-04-12 11:52:01',0);
INSERT INTO sourcemessage VALUES(4572,'public','1-я строка «Для регистрации входа используйте считыватель "Вход"»','','2017-04-12 11:52:39',0);
INSERT INTO sourcemessage VALUES(4573,'public','2-я строка «Для регистрации входа используйте считыватель "Вход"»','','2017-04-12 11:53:57',0);
INSERT INTO sourcemessage VALUES(4574,'public','3-я строка «Для регистрации входа используйте считыватель "Вход"»','','2017-04-12 11:54:35',0);
INSERT INTO sourcemessage VALUES(4575,'public','подключен','св-ва контроллера','2017-04-12 12:03:30',0);
INSERT INTO sourcemessage VALUES(4576,'public','ожидание','св-ва контроллера','2017-04-12 12:04:10',0);
INSERT INTO sourcemessage VALUES(4577,'public','Удалить помещение / Отвязать контроллер','всплывающая подсказка для кнопки','2017-04-12 12:25:48',0);
INSERT INTO sourcemessage VALUES(4578,'public','Версия системы','','2017-07-20 10:27:54',0);
INSERT INTO sourcemessage VALUES(4579,'public','Внутренняя ошибка сервера','','2017-04-12 12:43:07',0);
INSERT INTO sourcemessage VALUES(4580,'public','Оператор записал идентификатор','событие системы','2017-04-12 12:47:15',0);
INSERT INTO sourcemessage VALUES(4581,'public','Команды записи конфигурации в контроллер','подкатегория события','2017-04-12 13:47:01',0);
INSERT INTO sourcemessage VALUES(4582,'public','Команды пользователя в контроллер','Подкатегория событий системы','2017-04-12 13:48:56',0);
INSERT INTO sourcemessage VALUES(4583,'public','Лицензирование','Подкатегория событий системы','2017-04-12 13:49:46',0);
INSERT INTO sourcemessage VALUES(4584,'public','Работа с картами Mifare','Подкатегория событий системы','2017-04-12 13:50:42',0);
INSERT INTO sourcemessage VALUES(4585,'public','Окончание пересчета рабочего времени','событие системы','2017-04-12 13:52:34',0);
INSERT INTO sourcemessage VALUES(4586,'public','Пересчёт рабочего времени','задание системы','2017-04-12 13:54:07',0);
INSERT INTO sourcemessage VALUES(4587,'public','Новое задание','','2017-04-12 13:55:20',0);
INSERT INTO sourcemessage VALUES(4588,'public','Идентификатор не зарегистрирован','','2017-04-12 13:56:47',0);
INSERT INTO sourcemessage VALUES(4590,'public','Сегодня:','день календаря','2017-04-12 14:19:15',0);
INSERT INTO sourcemessage VALUES(4591,'public','Настольный считыватель отпечатков','','2017-07-26 09:26:27',0);
INSERT INTO sourcemessage VALUES(4592,'public','Контроллер отпечатков','','2017-07-26 09:25:46',0);
INSERT INTO sourcemessage VALUES(4593,'public','Считыватель 1','','2017-04-12 14:35:12',0);
INSERT INTO sourcemessage VALUES(4594,'public','Считыватель 2','','2017-04-12 14:35:24',0);
INSERT INTO sourcemessage VALUES(4595,'public','Видеосерверы','','2017-04-12 14:40:05',0);
INSERT INTO sourcemessage VALUES(4596,'public','Стандартный пакет','лицензия','2017-04-12 14:49:30',0);
INSERT INTO sourcemessage VALUES(4597,'public','Базовый пакет','лицензия','2017-07-17 14:30:12',0);
INSERT INTO sourcemessage VALUES(4598,'public','Идентификатор запрещен','события системы','2017-04-13 15:41:37',0);
INSERT INTO sourcemessage VALUES(4599,'public','Отпечатки пальцев','название вкладки где добавляются отпечатки','2017-04-13 15:56:35',0);
INSERT INTO sourcemessage VALUES(4600,'public','Сканировать','Запустить сканирование отпечатка пальца','2017-04-13 16:10:00',0);
INSERT INTO sourcemessage VALUES(4601,'public','Качество','качество изображения отпечатка пальца','2017-07-18 17:26:06',0);
INSERT INTO sourcemessage VALUES(4602,'public','Добавить палец','Добавить еще одну позицию куда можно будет сохранить изображение отпечатка одного из пальцев','2017-04-13 16:19:08',0);
INSERT INTO sourcemessage VALUES(4603,'public','Идет экспорт. Это может занять некоторое время.','информационное сообщение при экспорте','2017-04-13 16:21:54',0);
INSERT INTO sourcemessage VALUES(4604,'public','Посмотреть','Открыть карточку учетных данных для просмотра','2017-04-13 16:31:04',0);
INSERT INTO sourcemessage VALUES(4605,'public','По присутствию','тип графика работы','2017-04-13 16:36:42',0);
INSERT INTO sourcemessage VALUES(4606,'public','Учет нерабочего времени','помещения учитывающие нерабочее время','2017-04-13 16:38:05',0);
INSERT INTO sourcemessage VALUES(4607,'public','Не учитывать праздники','','2017-04-13 16:40:13',0);
INSERT INTO sourcemessage VALUES(4608,'public','Не учитывать переработку менее чем на','для графиков работы','2017-04-13 16:43:28',0);
INSERT INTO sourcemessage VALUES(4609,'public','Промежуточный интервал','интервал графика работы','2017-04-13 16:44:40',0);
INSERT INTO sourcemessage VALUES(4610,'public','Конец смены','интервал графика работы','2017-04-13 16:45:11',0);
INSERT INTO sourcemessage VALUES(4611,'public','Полная смена','интервал графика работы','2017-04-13 16:45:38',0);
INSERT INTO sourcemessage VALUES(4612,'public','Копировать интервал','действия с интервалом рабочего времени','2017-04-13 16:47:18',0);
INSERT INTO sourcemessage VALUES(4613,'public','Вставить интервал','','2017-04-13 16:47:36',0);
INSERT INTO sourcemessage VALUES(4614,'public','Удалить выбранный интервал','','2017-04-13 16:47:55',0);
INSERT INTO sourcemessage VALUES(4615,'public','Сменный','тип графика','2017-04-13 16:51:31',0);
INSERT INTO sourcemessage VALUES(4616,'public','Название праздника','','2017-04-13 16:53:36',0);
INSERT INTO sourcemessage VALUES(4617,'public','День: ','','2017-04-13 16:56:30',0);
INSERT INTO sourcemessage VALUES(4618,'public','Наименование: ','','2017-04-13 16:58:47',0);
INSERT INTO sourcemessage VALUES(4619,'public','Вы действительно хотите закрыть планировщик? Все изменения будут потеряны','','2017-04-13 17:12:30',0);
INSERT INTO sourcemessage VALUES(4620,'public','Будут перезаписаны только значения дней, установленных в календаре предопределенных значений.','','2017-04-13 17:14:17',0);
INSERT INTO sourcemessage VALUES(4621,'public','Рамка (граница пропуска)','','2017-07-18 14:59:30',0);
INSERT INTO sourcemessage VALUES(4622,'public','Первое событие','','2017-04-13 17:44:17',0);
INSERT INTO sourcemessage VALUES(4623,'public','Последнее событие','','2017-04-13 17:44:44',0);
INSERT INTO sourcemessage VALUES(4624,'public','Действительно c','','2017-04-13 17:45:27',0);
INSERT INTO sourcemessage VALUES(4625,'public','Текстовые дополнительные данные','','2017-04-13 17:50:58',0);
INSERT INTO sourcemessage VALUES(4630,'public','Пожалуйста, ждите, данные будут обновлены автоматически после окончания перерасчёта.','Сообщение при пересчете рабочего времени.','2017-04-14 11:51:13',0);
INSERT INTO sourcemessage VALUES(4631,'public','Весь месяц','построение табеля.','2017-04-14 12:18:11',0);
INSERT INTO sourcemessage VALUES(4632,'public','Первую половину месяца','построение табеля','2017-04-14 12:19:37',0);
INSERT INTO sourcemessage VALUES(4633,'public','Вторую половину месяца','Построение табеля.','2017-04-14 12:21:07',0);
INSERT INTO sourcemessage VALUES(4634,'public','Сформировать Т12 (Excel)','формирование табеля','2017-04-14 12:38:02',0);
INSERT INTO sourcemessage VALUES(4635,'public','Сформировать Т13 (Excel)','Формирование табеля.','2017-04-14 12:45:10',0);
INSERT INTO sourcemessage VALUES(4636,'public','Показ минут','','2017-04-14 12:54:04',0);
INSERT INTO sourcemessage VALUES(4637,'public','Присутствующие на данный момент','Отчеты по дисциплине','2017-04-14 14:08:46',0);
INSERT INTO sourcemessage VALUES(4638,'public','Отсутствующие сегодня','Отчеты по дисциплине','2017-04-14 14:14:03',0);
INSERT INTO sourcemessage VALUES(4639,'public','Опоздавшие сегодня',' Отчеты по дисцилине','2017-04-14 14:17:50',0);
INSERT INTO sourcemessage VALUES(4640,'public','Ушедшие раньше сегодня','Отчеты по дисциплине','2017-04-14 14:25:21',0);
INSERT INTO sourcemessage VALUES(4641,'public','Неявок','Отчеты по дисциплине','2017-04-14 14:27:14',0);
INSERT INTO sourcemessage VALUES(4642,'public','Обновить','Вкладка присутствующие на данный момент в отчете по дисциплине','2017-04-14 14:34:30',0);
INSERT INTO sourcemessage VALUES(4643,'public','Запрос','Контроль доступа (журнал верификации)','2017-04-14 15:31:49',0);
INSERT INTO sourcemessage VALUES(4644,'public','Индикация взлом ИУ','Контроль доступа журнал (верификации)','2017-04-14 15:44:51',0);
INSERT INTO sourcemessage VALUES(4645,'public','Индикация: разрешение прохода от ДУ','Контроль доступа ( журнал верификации)','2017-04-14 15:47:24',0);
INSERT INTO sourcemessage VALUES(4646,'public','Вход из','Контроль доступа в помещение - на итальянском не правильно','2017-07-19 10:52:44',0);
INSERT INTO sourcemessage VALUES(4647,'public','Дополнительные текстовые поля:','Заказ пропуска (параметры отображения таблицы)','2017-04-14 16:57:18',0);
INSERT INTO sourcemessage VALUES(4649,'public','Сначала выберите контроллер','','2017-04-19 14:46:02',0);
INSERT INTO sourcemessage VALUES(4650,'public','Поднесите палец к сканеру','','2017-04-20 10:24:35',0);
INSERT INTO sourcemessage VALUES(4651,'public','Время сканирования истекло','','2017-04-20 10:24:53',0);
INSERT INTO sourcemessage VALUES(4652,'public','Поднесите палец к сканеру еще раз','','2017-04-20 10:26:30',0);
INSERT INTO sourcemessage VALUES(4653,'public','Отпечатки не совпадают','отпечатки пальцев? да','2017-05-24 11:21:10',0);
INSERT INTO sourcemessage VALUES(4654,'public','Промежуточный интервал должен иметь и начало и окончание!','','2017-04-20 13:57:03',0);
INSERT INTO sourcemessage VALUES(4655,'public','Отсутствует конфигурация для данного типа карты','','2017-04-21 15:17:13',0);
INSERT INTO sourcemessage VALUES(4656,'public','Команда выполнена успешно','','2017-04-27 13:50:46',0);
INSERT INTO sourcemessage VALUES(4657,'public','Завершено','','2017-04-27 13:51:02',0);
INSERT INTO sourcemessage VALUES(4658,'public','Контроллер отпечатков деактивирован','','2017-05-26 10:56:20',0);
INSERT INTO sourcemessage VALUES(4659,'public','Прижмите палец сильнее к сканеру','','2017-05-26 11:00:59',0);
INSERT INTO sourcemessage VALUES(4660,'public','Сканирование успешно завершено','сканирование отпечатка пальца','2017-05-26 11:03:45',0);
INSERT INTO sourcemessage VALUES(4661,'public','Вы действительно хотите удалить отпечаток пальца?','','2017-05-26 11:06:07',0);
INSERT INTO sourcemessage VALUES(4662,'public','Подтверждение удаления отпечатка пальца','','2017-05-26 11:06:35',0);
INSERT INTO sourcemessage VALUES(4663,'public','Отмена','отмена действия','2017-05-26 11:07:57',0);
INSERT INTO sourcemessage VALUES(4664,'public','Документ не выбран','при попытке применить команду редактирования документа без документа','2017-05-26 11:09:04',0);
INSERT INTO sourcemessage VALUES(4665,'public','нет карты в поле считывателя','','2018-04-09 09:56:29',0);
INSERT INTO sourcemessage VALUES(4666,'public','Информация о карте','','2017-05-26 11:29:05',0);
INSERT INTO sourcemessage VALUES(4667,'public','Тип карты','','2017-08-23 10:04:20',0);
INSERT INTO sourcemessage VALUES(4668,'public','Серия UID','','2017-05-26 11:31:10',0);
INSERT INTO sourcemessage VALUES(4669,'public','Номер UID','UID User identifier','2017-05-26 11:32:24',0);
INSERT INTO sourcemessage VALUES(4670,'public','Ошибка: Не удалось подключится.','','2017-05-26 11:32:48',0);
INSERT INTO sourcemessage VALUES(4671,'public','Текущий уровень мастер-карты:','','2017-05-26 11:36:00',0);
INSERT INTO sourcemessage VALUES(4672,'public','Уровень безопасности:','','2017-05-26 11:36:31',0);
INSERT INTO sourcemessage VALUES(4673,'public','пользовательская карта, обычная','','2018-04-09 09:56:33',0);
INSERT INTO sourcemessage VALUES(4674,'public','мастер-карта','','2018-04-09 09:56:25',0);
INSERT INTO sourcemessage VALUES(4675,'public','Выполнение команды','','2017-05-26 11:45:15',0);
INSERT INTO sourcemessage VALUES(4676,'public','Нет карты в поле считывателя','','2017-05-26 11:45:35',0);
INSERT INTO sourcemessage VALUES(4677,'public','Команда не для мастер-карты','','2017-05-26 11:46:05',0);
INSERT INTO sourcemessage VALUES(4678,'public','Тип мастер-карты','','2017-05-26 11:46:35',0);
INSERT INTO sourcemessage VALUES(4679,'public','Обычная','Тип мастер-карты','2017-05-26 11:47:18',0);
INSERT INTO sourcemessage VALUES(4680,'public','Первичная','Тип мастер-карты','2017-05-26 11:47:40',0);
INSERT INTO sourcemessage VALUES(4681,'public','Ошибка: карта должна быть типа Plus','','2017-05-26 11:49:06',0);
INSERT INTO sourcemessage VALUES(4682,'public','Карта имеет ключ аутентификации идентичный параметру «текущий ключ» («старый ключ» не подошел)','','2017-05-26 11:49:51',0);
INSERT INTO sourcemessage VALUES(4683,'public','Неверное новое значение уровня безопасности','','2017-05-26 11:52:32',0);
INSERT INTO sourcemessage VALUES(4684,'public','Старый тип ключа аутентификации','','2017-05-26 11:53:23',0);
INSERT INTO sourcemessage VALUES(4685,'public','Ошибка выполнения','ошибка выполнения команды','2017-05-26 12:01:23',0);
INSERT INTO sourcemessage VALUES(4686,'public','Генерация номера','','2017-05-26 12:04:11',0);
INSERT INTO sourcemessage VALUES(4687,'public','Ручной ввод','','2017-05-26 12:04:42',0);
INSERT INTO sourcemessage VALUES(4688,'public','Случайный номер','','2017-05-26 12:06:01',0);
INSERT INTO sourcemessage VALUES(4689,'public','Автоинкремент','','2017-05-26 12:06:31',0);
INSERT INTO sourcemessage VALUES(4690,'public','Ввод номера карты с сохранением','','2017-05-26 12:07:28',0);
INSERT INTO sourcemessage VALUES(4691,'public','Неверный уровень безопасности карты Plus (поднесенная карта имеет уровень безопасности отличный от уровня сконфигурированного в считывателе)','','2017-05-26 12:07:58',0);
INSERT INTO sourcemessage VALUES(4692,'public','Выберите помещение или активный контроллер','','2017-07-13 16:19:55',0);
INSERT INTO sourcemessage VALUES(4693,'public','Подтверждение пароля','','2017-07-14 12:54:14',0);
INSERT INTO sourcemessage VALUES(4694,'public','Необходимо заполнить поле «Пароль».','','2017-07-14 13:42:53',0);
INSERT INTO sourcemessage VALUES(4695,'public','Нет подразделений','','2017-07-14 13:43:56',0);
INSERT INTO sourcemessage VALUES(4696,'public','Ознакомительный период 60 дней. Осталось 60 дней.','','2017-07-14 13:48:41',0);
INSERT INTO sourcemessage VALUES(4697,'public','Купить лицензию','','2017-07-14 13:49:01',0);
INSERT INTO sourcemessage VALUES(4698,'public','Не включена','про лицензию','2017-07-14 13:49:39',0);
INSERT INTO sourcemessage VALUES(4699,'public','Ваша версия приложения устарела. Для работы скачайте и запустите следующее','','2017-07-18 16:42:39',0);
INSERT INTO sourcemessage VALUES(4700,'public','Дополнительный вывод','свойства контроллера','2017-07-18 17:07:27',0);
INSERT INTO sourcemessage VALUES(4701,'public','ИУ заблокировано','','2017-07-18 17:51:33',0);
INSERT INTO sourcemessage VALUES(4702,'public','Не найден настольный считыватель отпечатков','','2017-07-19 11:30:27',0);
INSERT INTO sourcemessage VALUES(4706,'public','Недельные критерии доступа','доступ в помещения','2017-07-19 12:46:33',0);
INSERT INTO sourcemessage VALUES(4707,'public','Сменные суточные критерии доступа','доступ в помещения по сменному графику','2017-07-19 12:48:31',0);
INSERT INTO sourcemessage VALUES(4708,'public','Скользящие недельные критерии доступа','доступ в помещения по скользящему графику','2017-07-19 12:48:21',0);
INSERT INTO sourcemessage VALUES(4709,'public','Праздники для недельных критериев доступа','доступ в помещения в праздничные дни','2017-07-19 12:48:07',0);
INSERT INTO sourcemessage VALUES(4710,'public','Дверь не закрыта после прохода','table_event_name','2017-07-19 14:54:07',0);
INSERT INTO sourcemessage VALUES(4711,'public','ИУ разблокировано','','2017-07-19 15:07:03',0);
INSERT INTO sourcemessage VALUES(4712,'public','Дверь открыта','','2017-07-19 15:18:29',0);
INSERT INTO sourcemessage VALUES(4713,'public','Дверь закрыта','','2017-07-19 15:19:00',0);
INSERT INTO sourcemessage VALUES(4714,'public','Доступ по карте и отпечатку','','2017-07-19 15:20:29',0);
INSERT INTO sourcemessage VALUES(4715,'public','Доступ по отпечатку','','2017-07-19 15:20:46',0);
INSERT INTO sourcemessage VALUES(4716,'public','Доступ по карте','','2017-07-19 15:20:58',0);
INSERT INTO sourcemessage VALUES(4717,'public','Оправдательные и сверхурочные документы','','2017-07-19 17:37:25',0);
INSERT INTO sourcemessage VALUES(4718,'public','Не выполнялось','резервное копирование базы данных/пересчет УРВ за прошлый день','2017-07-20 10:33:13',0);
INSERT INTO sourcemessage VALUES(4719,'public','Контроллер Suprema BioEntry W2','','2017-07-21 15:14:55',0);
INSERT INTO sourcemessage VALUES(4720,'public','Видеокамера','','2017-07-21 15:17:01',0);
INSERT INTO sourcemessage VALUES(4721,'public','Контроллер Suprema BioEntry Plus','','2017-07-21 15:18:08',0);
INSERT INTO sourcemessage VALUES(4722,'public','Контроллер замка CL05.2','','2017-07-21 15:19:23',0);
INSERT INTO sourcemessage VALUES(4723,'public','Контроллер замка CT/L04.2','','2017-07-21 15:21:14',0);
INSERT INTO sourcemessage VALUES(4724,'public','ЛИКОН 2','','2017-07-21 15:29:51',0);
INSERT INTO sourcemessage VALUES(4725,'public','Неподдерживаемый контроллер','','2017-07-21 15:31:44',0);
INSERT INTO sourcemessage VALUES(4726,'public','Электронная проходная KR05','','2017-07-21 15:33:04',0);
INSERT INTO sourcemessage VALUES(4727,'public','Электронная проходная KT02.3','','2017-07-21 15:33:43',0);
INSERT INTO sourcemessage VALUES(4728,'public','Электронная проходная KT05.3A','','2017-07-21 15:34:28',0);
INSERT INTO sourcemessage VALUES(4729,'public','Электронная проходная KTC01.x с картоприёмником','','2017-07-21 15:35:16',0);
INSERT INTO sourcemessage VALUES(4730,'public','Электронная проходная КТ02.x/КТ05.x','','2017-07-21 15:35:47',0);
INSERT INTO sourcemessage VALUES(4731,'public','Электронная проходная КТ0х.A с антипаникой','','2017-07-21 15:36:20',0);
INSERT INTO sourcemessage VALUES(4732,'public','Электронная проходная КТС0х.A с картоприемником и антипаникой','','2017-07-21 15:37:16',0);
INSERT INTO sourcemessage VALUES(4733,'public','Электронная проходная с картоприемником KTC01.3A','','2017-07-21 15:37:58',0);
INSERT INTO sourcemessage VALUES(4734,'public','Электронная проходная с картоприёмником КТС01.3','','2017-07-21 15:39:57',0);
INSERT INTO sourcemessage VALUES(4737,'public','Кнопка "Выход"','','2017-07-24 09:13:28',0);
INSERT INTO sourcemessage VALUES(4738,'public','Датчик двери','','2017-07-24 09:57:37',0);
INSERT INTO sourcemessage VALUES(4740,'public','Сегодня','','2017-07-24 14:23:16',0);
INSERT INTO sourcemessage VALUES(4741,'public','ОК','','2017-07-24 16:10:41',0);
INSERT INTO sourcemessage VALUES(4742,'public','Нормально замкнута','','2017-07-24 17:08:10',0);
INSERT INTO sourcemessage VALUES(4743,'public','Нормально разомкнута','','2017-07-24 17:09:06',0);
INSERT INTO sourcemessage VALUES(4744,'public','Вход датчика двери','','2017-07-24 17:09:51',0);
INSERT INTO sourcemessage VALUES(4745,'public','вход 0','','2017-07-24 17:10:45',0);
INSERT INTO sourcemessage VALUES(4746,'public','Ознакомительный период 60 дней. Осталось','осталось N ','2017-07-24 17:11:15',0);
INSERT INTO sourcemessage VALUES(4747,'public','Предельное время открытия двери','','2017-07-24 17:11:48',0);
INSERT INTO sourcemessage VALUES(4748,'public','Блокировать дверь после закрытия','','2017-07-24 17:12:34',0);
INSERT INTO sourcemessage VALUES(4749,'public','Низкая','','2017-07-24 17:14:17',0);
INSERT INTO sourcemessage VALUES(4750,'public','Отсутствует лицензионный контроллер. Осталось {{num}} дней','','2018-11-21 15:28:33',0);
INSERT INTO sourcemessage VALUES(4751,'public','Уровень 1','','2017-07-24 17:15:01',0);
INSERT INTO sourcemessage VALUES(4752,'public','Уровень 2','','2017-07-24 17:15:41',0);
INSERT INTO sourcemessage VALUES(4753,'public','Уровень 3','','2017-07-24 17:16:25',0);
INSERT INTO sourcemessage VALUES(4754,'public','Уровень 4','','2017-07-24 17:17:07',0);
INSERT INTO sourcemessage VALUES(4755,'public','Уровень 5','','2017-07-24 17:17:37',0);
INSERT INTO sourcemessage VALUES(4756,'public','Уровень 6','','2017-07-24 17:18:06',0);
INSERT INTO sourcemessage VALUES(4757,'public','Высокая','','2017-07-24 17:19:02',0);
INSERT INTO sourcemessage VALUES(4758,'public','Чувствительность','','2017-07-24 17:19:38',0);
INSERT INTO sourcemessage VALUES(4759,'public','Лицензирующий контроллер не существует или деактивирован','','2017-07-24 17:20:51',0);
INSERT INTO sourcemessage VALUES(4761,'public','Ошибка: Не удалось подключиться.','','2017-07-25 14:36:52',0);
INSERT INTO sourcemessage VALUES(4762,'public','Отсутствует лицензионный контроллер','','2017-07-25 15:37:18',0);
INSERT INTO sourcemessage VALUES(4763,'public','Вход кнопки "Выход"','','2017-07-25 16:15:11',0);
INSERT INTO sourcemessage VALUES(4764,'public','вход 1','','2017-07-25 16:17:15',0);
INSERT INTO sourcemessage VALUES(4765,'public','Время открытия двери','','2017-07-25 16:19:55',0);
INSERT INTO sourcemessage VALUES(4766,'public','Настольный считыватель','','2017-07-26 11:03:24',0);
INSERT INTO sourcemessage VALUES(4770,'public','При смене режима работы считывателей все данные карты станут недействительны! Продолжить?','','2017-07-26 15:41:29',0);
INSERT INTO sourcemessage VALUES(4771,'public','Подтвердите действие на','','2017-07-26 15:43:15',0);
INSERT INTO sourcemessage VALUES(4772,'public','Идет изменение конфигурации','','2017-07-26 15:53:12',0);
INSERT INTO sourcemessage VALUES(4773,'public','Нет связи с контроллером отпечатков','','2017-07-26 16:04:28',0);
INSERT INTO sourcemessage VALUES(4774,'public','Ошибка сканирования','','2017-07-26 16:06:24',0);
INSERT INTO sourcemessage VALUES(4775,'public','Сканер отпечатков пальцев не найден','','2017-07-26 16:07:37',0);
INSERT INTO sourcemessage VALUES(4776,'public','Отпечаток не был удален','','2017-07-26 16:08:48',0);
INSERT INTO sourcemessage VALUES(4777,'public','Не выбран сканер отпечатков пальцев','','2017-07-26 16:10:56',0);
INSERT INTO sourcemessage VALUES(4778,'public','Устройство для идентификации','','2017-07-27 09:50:28',0);
INSERT INTO sourcemessage VALUES(4779,'public','Контроллер занят другим сервером','','2017-07-28 11:39:01',0);
INSERT INTO sourcemessage VALUES(4780,'public','IP адрес','','2017-07-28 11:40:08',0);
INSERT INTO sourcemessage VALUES(4781,'public','Вы действительно хотите удалить задание? Это приведет к отключению резервного копирования базы данных!','','2017-07-28 12:41:07',0);
INSERT INTO sourcemessage VALUES(4783,'public','переработку менее чем на','','2017-07-28 15:24:52',0);
INSERT INTO sourcemessage VALUES(4784,'public','Для работы скачайте и запустите следующее','','2017-07-28 16:58:56',0);
INSERT INTO sourcemessage VALUES(4785,'public','Служебные критерии доступа редактировать запрещено','','2017-07-31 14:53:15',0);
INSERT INTO sourcemessage VALUES(4786,'public','Временной критерий доступа','','2017-07-31 14:56:21',0);
INSERT INTO sourcemessage VALUES(4787,'public','Название критерия','','2017-07-31 14:57:12',0);
INSERT INTO sourcemessage VALUES(4788,'public','Имя недельного критерия доступа','','2017-07-31 14:58:54',0);
INSERT INTO sourcemessage VALUES(4789,'public','Описание недельного критерия доступа','','2017-07-31 15:00:17',0);
INSERT INTO sourcemessage VALUES(4790,'public','Редактирование недельного критерия доступа','','2017-07-31 15:04:57',0);
INSERT INTO sourcemessage VALUES(4791,'public','Описание критерия доступа','','2017-07-31 15:07:38',0);
INSERT INTO sourcemessage VALUES(4792,'public','Редактирование сменного суточного критерия доступа','#Редактирование сменного суточного критерия доступа','2017-07-31 15:13:34',0);
INSERT INTO sourcemessage VALUES(4793,'public','Изменить критерий доступа','','2017-07-31 15:15:26',0);
INSERT INTO sourcemessage VALUES(4794,'public','Добавить недельный критерий доступа','','2017-07-31 15:22:18',0);
INSERT INTO sourcemessage VALUES(4795,'public','Изменить недельный критерий доступа','','2017-07-31 15:23:10',0);
INSERT INTO sourcemessage VALUES(4796,'public','Удалить недельный критерий доступа','','2017-07-31 15:23:57',0);
INSERT INTO sourcemessage VALUES(4797,'public','Редактирование скользящего недельного критерия доступа','','2017-07-31 15:25:23',0);
INSERT INTO sourcemessage VALUES(4798,'public','Пустой дизайн пропуска сохранить нельзя','','2017-07-31 15:40:44',0);
INSERT INTO sourcemessage VALUES(4799,'public','Считать за','','2017-07-31 16:02:40',0);
INSERT INTO sourcemessage VALUES(4800,'public','Копирование оператора admin запрещено. Данная запись является системной','','2017-08-07 17:42:15',0);
INSERT INTO sourcemessage VALUES(4801,'public','Нет связи с лицензирующим контроллером','','2017-08-08 09:28:10',0);
INSERT INTO sourcemessage VALUES(4802,'public','Минуты','','2017-08-08 09:39:48',0);
INSERT INTO sourcemessage VALUES(4803,'public','Смена зоны при проходе','','2017-08-08 09:41:43',0);
INSERT INTO sourcemessage VALUES(4804,'public','Fire Alarm в режиме работы "Охрана"','','2017-08-08 09:50:39',0);
INSERT INTO sourcemessage VALUES(4805,'public','Обычный выход','','2017-08-08 10:34:30',0);
INSERT INTO sourcemessage VALUES(4806,'public','Синхронизирующий вход/выход','','2017-08-08 10:35:56',0);
INSERT INTO sourcemessage VALUES(4807,'public','Данный контроллер уже активирован','','2017-08-08 12:44:12',0);
INSERT INTO sourcemessage VALUES(4808,'public','Данный контроллер уже деактивирован','','2017-08-08 12:45:45',0);
INSERT INTO sourcemessage VALUES(4810,'public','Вы действительно хотите отвязать выбранный контроллер(ы)','','2017-08-08 12:49:13',0);
INSERT INTO sourcemessage VALUES(4813,'public','Неправильный IP','','2017-08-10 10:49:29',0);
INSERT INTO sourcemessage VALUES(4814,'public','Неправильно указан порт','','2017-08-10 10:50:26',0);
INSERT INTO sourcemessage VALUES(4815,'public','Лицензионный ключ введен','','2017-08-14 17:58:33',0);
INSERT INTO sourcemessage VALUES(4816,'public','Посетитель будет удален безвозвратно, его восстановление в дальнейшем будет невозможно','','2017-08-15 15:36:27',0);
INSERT INTO sourcemessage VALUES(4817,'public','Выдать карту можно только одному человеку','','2017-08-15 15:47:21',0);
INSERT INTO sourcemessage VALUES(4818,'public','Объект шаблон верификации выгружен','','2017-08-17 12:35:32',0);
INSERT INTO sourcemessage VALUES(4819,'public','По возрастанию','','2017-08-21 17:20:26',0);
INSERT INTO sourcemessage VALUES(4820,'public','Сбор данных о роли. Пожалуйста, подождите.','','2017-08-23 11:14:40',0);
INSERT INTO sourcemessage VALUES(4821,'public','Считыватель 3','','2017-08-23 11:55:45',0);
INSERT INTO sourcemessage VALUES(4822,'public','Считыватель 4','','2017-08-23 11:56:23',0);
INSERT INTO sourcemessage VALUES(4823,'public','Считыватель 5','','2017-08-23 11:56:52',0);
INSERT INTO sourcemessage VALUES(4824,'public','Считыватель 6','','2017-08-23 11:57:33',0);
INSERT INTO sourcemessage VALUES(4825,'public','Считыватель 7','','2017-08-23 11:58:17',0);
INSERT INTO sourcemessage VALUES(4826,'public','Считыватель 8','','2017-08-23 11:58:52',0);
INSERT INTO sourcemessage VALUES(4827,'public','Считыватель 9','','2017-08-23 11:59:18',0);
INSERT INTO sourcemessage VALUES(4828,'public','Считыватель 10','','2017-08-23 11:59:51',0);
INSERT INTO sourcemessage VALUES(4830,'public','Идет формирования табеля, подождите.','','2017-08-25 11:55:35',0);
INSERT INTO sourcemessage VALUES(4831,'public','Нет данных для печати','','2017-08-25 12:30:31',0);
INSERT INTO sourcemessage VALUES(4832,'public','Вы действительно хотите удалить сотрудника(ов)?','','2017-08-25 15:44:49',0);
INSERT INTO sourcemessage VALUES(4833,'public','Уволить сотрудника(ов)','','2017-08-25 15:51:51',0);
INSERT INTO sourcemessage VALUES(4834,'public','Увольнение группы сотрудников','','2017-08-25 15:53:14',0);
INSERT INTO sourcemessage VALUES(4835,'public','Совпадение в базе','','2017-09-08 12:42:06',0);
INSERT INTO sourcemessage VALUES(4836,'public','запись','','2017-09-08 12:42:42',0);
INSERT INTO sourcemessage VALUES(4837,'public','Вход Fire Alarm','','2017-09-11 12:08:23',0);
INSERT INTO sourcemessage VALUES(4838,'public','Часть информации будет удалена безвозвратно (данные о проходах, журнал верификации и другое). Вы действительно хотите удалить выбранный контроллер?','','2017-09-11 12:16:53',0);
INSERT INTO sourcemessage VALUES(4839,'public','Вы действительно хотите закрыть планировщик? Все изменения будут потеряны!','','2017-09-11 15:11:18',0);
INSERT INTO sourcemessage VALUES(4840,'public','Необходимо выбрать тип временного критерия доступа','','2017-09-12 10:36:36',0);
INSERT INTO sourcemessage VALUES(4841,'public','Файл слишком большой (Максимальный размер 40 кб.)','','2017-09-12 11:02:59',0);
INSERT INTO sourcemessage VALUES(4842,'public','Включить контрольный считыватель','','2017-09-12 13:56:11',0);
INSERT INTO sourcemessage VALUES(4843,'public','Для использования команд управления картами необходимо выбрать контрольный считыватель Mifare.','','2017-09-12 13:56:45',0);
INSERT INTO sourcemessage VALUES(4844,'public','Устройство не найдено','','2017-12-22 09:48:48',0);
INSERT INTO sourcemessage VALUES(4845,'public','Односторонний замок','','2017-09-20 12:26:09',0);
INSERT INTO sourcemessage VALUES(4846,'public','Замок CL201','','2017-11-09 12:39:57',0);
INSERT INTO sourcemessage VALUES(4847,'public','Замок CL201 №2','','2017-09-20 12:33:00',0);
INSERT INTO sourcemessage VALUES(4848,'public','Замок CL201 №3','','2017-09-20 12:33:28',0);
INSERT INTO sourcemessage VALUES(4849,'public','Замок CL201 №4','','2017-09-20 12:33:57',0);
INSERT INTO sourcemessage VALUES(4850,'public','Замок CL201 №5','','2017-09-20 12:34:26',0);
INSERT INTO sourcemessage VALUES(4851,'public','Замок CL201 №6','','2017-09-20 12:35:02',0);
INSERT INTO sourcemessage VALUES(4852,'public','Замок CL201 №7','','2017-09-20 12:35:39',0);
INSERT INTO sourcemessage VALUES(4853,'public','Замок CL201 №8','','2017-09-20 12:36:04',0);
INSERT INTO sourcemessage VALUES(4854,'public','Дополнительный вход №8','','2017-09-20 12:41:37',0);
INSERT INTO sourcemessage VALUES(4855,'public','Дополнительный выход №5','','2017-09-20 12:43:23',0);
INSERT INTO sourcemessage VALUES(4856,'public','Дополнительный выход №6','','2017-09-20 12:43:56',0);
INSERT INTO sourcemessage VALUES(4857,'public','Дополнительный выход №7','','2017-09-20 12:45:09',0);
INSERT INTO sourcemessage VALUES(4858,'public','Дополнительный выход №8','','2017-09-20 12:46:07',0);
INSERT INTO sourcemessage VALUES(4860,'public','Дополнительный выход №9','','2017-09-20 12:47:05',0);
INSERT INTO sourcemessage VALUES(4861,'public','Дополнительный вход №3','','2017-09-20 12:49:32',0);
INSERT INTO sourcemessage VALUES(4862,'public','Дополнительный вход №4','','2017-09-20 12:49:54',0);
INSERT INTO sourcemessage VALUES(4863,'public','Дополнительный вход №5','','2017-09-20 12:50:40',0);
INSERT INTO sourcemessage VALUES(4864,'public','Дополнительный вход №6','','2017-09-20 12:51:35',0);
INSERT INTO sourcemessage VALUES(4865,'public','Дополнительный вход №7','','2017-09-20 12:52:09',0);
INSERT INTO sourcemessage VALUES(4866,'public','Следующие контроллеры привязаны к помещению. Сначала отвяжите их','','2018-01-16 16:31:24',0);
INSERT INTO sourcemessage VALUES(4867,'public','Контроллер с этим IP-адресом уже добавлен.','','2017-09-20 13:11:30',0);
INSERT INTO sourcemessage VALUES(4868,'public','Сбросить тревогу: Не выполнено','','2017-09-27 17:31:58',0);
INSERT INTO sourcemessage VALUES(4869,'public','Поднять тревогу: Не выполнено','','2017-09-27 17:32:55',0);
INSERT INTO sourcemessage VALUES(4870,'public','Сбросить тревогу: Выполнено','','2017-09-27 17:33:46',0);
INSERT INTO sourcemessage VALUES(4871,'public','Сброс тревоги: По команде от ПО','','2017-09-27 17:34:38',0);
INSERT INTO sourcemessage VALUES(4872,'public','Поднять тревогу: Выполнено','','2017-09-27 17:35:25',0);
INSERT INTO sourcemessage VALUES(4873,'public','Открыть (разблокировать) ИУ: Выполнено','','2017-09-27 17:37:05',0);
INSERT INTO sourcemessage VALUES(4874,'public','Очистить пространственные зоны для идентификаторов: Выполнено','','2017-09-27 17:40:35',0);
INSERT INTO sourcemessage VALUES(4875,'public','Закрыть (заблокировать) ИУ: Выполнено','','2017-09-27 17:43:25',0);
INSERT INTO sourcemessage VALUES(4876,'public','Двусторонний замок №1','','2017-09-28 11:46:39',0);
INSERT INTO sourcemessage VALUES(4877,'public','Двусторонний замок №2','','2017-09-28 11:47:17',0);
INSERT INTO sourcemessage VALUES(4878,'public','Индикация: взлом ИУ','','2017-09-29 11:41:54',0);
INSERT INTO sourcemessage VALUES(4879,'public','Контроллер замка CL05.1','','2017-09-29 11:47:51',0);
INSERT INTO sourcemessage VALUES(4880,'public','Двусторонний замок №3','','2017-10-20 16:12:10',0);
INSERT INTO sourcemessage VALUES(4881,'public','Контроллер замка CL05','','2017-10-20 16:15:24',0);
INSERT INTO sourcemessage VALUES(4882,'public','Ввод недопустимого значения','','2017-10-23 12:24:36',0);
INSERT INTO sourcemessage VALUES(4883,'public','Срок действия пропуска задан неверно','','2017-10-24 17:11:23',0);
INSERT INTO sourcemessage VALUES(4884,'public','Дверь заблокирована  по команде с ПК','','2017-10-25 11:22:00',0);
INSERT INTO sourcemessage VALUES(4885,'public','Дверь разблокирована по команде с ПК','','2017-10-25 11:22:59',0);
INSERT INTO sourcemessage VALUES(4886,'public','Контроллер турникета CT/L04.2','','2017-11-08 10:57:40',0);
INSERT INTO sourcemessage VALUES(4887,'public','«Вход» при индикации баланса','','2017-11-09 10:43:58',0);
INSERT INTO sourcemessage VALUES(4888,'public','«Выход» при индикации баланса','','2017-11-09 10:44:36',0);
INSERT INTO sourcemessage VALUES(4889,'public','«Расчет прерван» при индикации баланса','','2017-11-09 10:45:12',0);
INSERT INTO sourcemessage VALUES(4890,'public','«Расчет прерван»','','2017-11-09 10:45:42',0);
INSERT INTO sourcemessage VALUES(4891,'public','3-я строка «Предъявите карту для просмотра баланса»','','2017-11-09 10:47:51',0);
INSERT INTO sourcemessage VALUES(4892,'public','2-я строка «Предъявите карту для просмотра баланса»','','2017-11-09 10:48:15',0);
INSERT INTO sourcemessage VALUES(4893,'public','1-я строка «Предъявите карту для просмотра баланса»','','2017-11-09 10:48:35',0);
INSERT INTO sourcemessage VALUES(4894,'public','«Нет связи»','','2017-11-09 10:49:58',0);
INSERT INTO sourcemessage VALUES(4895,'public','«Нарушения»','','2018-07-04 12:46:24',0);
INSERT INTO sourcemessage VALUES(4896,'public','«Баланс»','','2017-11-09 10:58:54',0);
INSERT INTO sourcemessage VALUES(4897,'public','«К отработке»','','2017-11-09 11:04:09',0);
INSERT INTO sourcemessage VALUES(4898,'public','Редактирование документа','','2017-11-10 16:22:15',0);
INSERT INTO sourcemessage VALUES(4899,'public','Нет связи с видеосервером','','2017-11-13 09:20:17',0);
INSERT INTO sourcemessage VALUES(4900,'public','Вход при персонализации баланса','','2017-11-13 09:22:01',0);
INSERT INTO sourcemessage VALUES(4901,'public','Выход при персонализации баланса','','2017-11-13 09:22:50',0);
INSERT INTO sourcemessage VALUES(4902,'public','Устройства',NULL,'2017-12-22 10:46:47',0);
INSERT INTO sourcemessage VALUES(4903,'public','Необходимо указать хотя бы одно регистрирующее помещение для ГР','ГР?  - График работ','2018-01-18 13:27:13',0);
INSERT INTO sourcemessage VALUES(4905,'public','Найти контроллеры','','2018-01-16 12:04:22',0);
INSERT INTO sourcemessage VALUES(4906,'public','Свободные контроллеры отсутствуют','','2018-01-16 12:08:46',0);
INSERT INTO sourcemessage VALUES(4907,'public','Поиск контроллеров','','2018-01-16 13:56:00',0);
INSERT INTO sourcemessage VALUES(4908,'public','Свойства контроллера','','2018-01-16 15:15:41',0);
INSERT INTO sourcemessage VALUES(4909,'public','Контроллер не найден','','2018-01-16 15:21:40',0);
INSERT INTO sourcemessage VALUES(4910,'public','Верифицировать идентификаторы СОТРУДНИКОВ от ПДУ','ПДУ - пульт дистанционного управления','2018-01-16 15:24:49',0);
INSERT INTO sourcemessage VALUES(4911,'public','Верифицировать идентификаторы ПОСЕТИТЕЛЕЙ от ПДУ','ПДУ - пульт дистанционного управления','2018-01-16 15:25:42',0);
INSERT INTO sourcemessage VALUES(4912,'public','Верифицировать идентификаторы СОТРУДНИКОВ от ВВУ','ВВУ – внешнее верифицирующее устройство','2018-01-16 15:27:00',0);
INSERT INTO sourcemessage VALUES(4913,'public','Верифицировать идентификаторы ПОСЕТИТЕЛЕЙ от ВВУ','ВВУ – внешнее верифицирующее устройство','2018-01-16 15:27:37',0);
INSERT INTO sourcemessage VALUES(4914,'public','ПДУ','ПДУ - пульт дистанционного управления','2018-01-16 15:28:52',0);
INSERT INTO sourcemessage VALUES(4915,'public','Софт','','2018-01-16 15:29:16',0);
INSERT INTO sourcemessage VALUES(4916,'public','ВВУ','ВВУ – внешнее верифицирующее устройство','2018-01-16 15:30:44',0);
INSERT INTO sourcemessage VALUES(4917,'public','При доступности софта, иначе ПДУ','ПДУ - пульт дистанционного управления','2018-01-16 15:32:12',0);
INSERT INTO sourcemessage VALUES(4919,'public','ПДУ или софт','ПДУ - пульт дистанционного управления','2018-01-16 15:36:56',0);
INSERT INTO sourcemessage VALUES(4920,'public','Сначала ПДУ затем софт','ПДУ - пульт дистанционного управления','2018-01-16 15:38:52',0);
INSERT INTO sourcemessage VALUES(4921,'public','Сначала ВВУ затем ПДУ','ВВУ – внешнее верифицирующее устройство\r\nПДУ - пульт дистанционного управления','2018-01-16 15:40:06',0);
INSERT INTO sourcemessage VALUES(4922,'public','Сначала ВВУ затем софт','ВВУ – внешнее верифицирующее устройство','2018-01-16 15:41:11',0);
INSERT INTO sourcemessage VALUES(4923,'public','При доступности софт, иначе ВВУ','ВВУ – внешнее верифицирующее устройство','2018-01-16 15:42:54',0);
INSERT INTO sourcemessage VALUES(4924,'public','При отсутствии ответа от ВВУ','ВВУ – внешнее верифицирующее устройство','2018-01-16 15:43:38',0);
INSERT INTO sourcemessage VALUES(4925,'public','Запрет','','2018-01-16 15:44:22',0);
INSERT INTO sourcemessage VALUES(4927,'public','Двусторонний замок','','2018-01-16 15:53:02',0);
INSERT INTO sourcemessage VALUES(4928,'public','Всего контроллеров','','2018-01-16 15:58:45',0);
INSERT INTO sourcemessage VALUES(4929,'public','установили','','2018-01-16 16:25:41',0);
INSERT INTO sourcemessage VALUES(4930,'public','Действительно с','Экспорт','2018-01-17 10:01:00',0);
INSERT INTO sourcemessage VALUES(4931,'public','Найдено контроллеров','','2018-01-17 10:14:47',0);
INSERT INTO sourcemessage VALUES(4932,'public','Подтверждение от ВВУ','','2018-01-17 10:17:19',0);
INSERT INTO sourcemessage VALUES(4933,'public','Запрет от ВВУ','','2018-01-17 10:18:08',0);
INSERT INTO sourcemessage VALUES(4934,'public','Дополнительный вход №9','','2018-01-17 10:19:55',0);
INSERT INTO sourcemessage VALUES(4935,'public','ИУ 1 направление 1','ИУ – исполнительное устройство','2018-01-17 10:24:10',0);
INSERT INTO sourcemessage VALUES(4936,'public','ИУ 1 направление 2','ИУ – исполнительное устройство','2018-01-17 10:25:02',0);
INSERT INTO sourcemessage VALUES(4937,'public','ИУ 3 направление 1','ИУ – исполнительное устройство','2018-01-17 10:25:45',0);
INSERT INTO sourcemessage VALUES(4938,'public','ИУ 3 направление 2','ИУ – исполнительное устройство','2018-01-17 10:26:20',0);
INSERT INTO sourcemessage VALUES(4939,'public','При смене режима работы считывателей все выданные карты станут недействительны! Продолжить?','','2018-01-17 10:55:44',0);
INSERT INTO sourcemessage VALUES(4940,'public','Подключение...','','2018-01-17 11:09:07',0);
INSERT INTO sourcemessage VALUES(4941,'public','Общие параметры контроллеров','','2018-01-17 11:15:20',0);
INSERT INTO sourcemessage VALUES(4943,'public','Невозможно передать команду в контроллер с состоянием','','2018-01-17 11:37:22',0);
INSERT INTO sourcemessage VALUES(4944,'public','Вы действительно хотите удалить задание?','','2018-01-17 12:08:11',0);
INSERT INTO sourcemessage VALUES(4945,'public','Видео-сервер','','2018-01-17 12:10:19',0);
INSERT INTO sourcemessage VALUES(4946,'public','Ошибка: Не удалось подключиться к службе','','2018-01-17 12:12:28',0);
INSERT INTO sourcemessage VALUES(4947,'public','Контроллер не выбран','','2018-01-17 12:15:19',0);
INSERT INTO sourcemessage VALUES(4948,'public','Окончанию смены не сопоставлено ни одно начало смены!','','2018-01-17 14:08:32',0);
INSERT INTO sourcemessage VALUES(4949,'public','Параметры доступа контроллера PERCo','','2018-01-17 14:09:21',0);
INSERT INTO sourcemessage VALUES(4950,'public','Параметры доступа контроллера Suprema','','2018-01-17 14:10:38',0);
INSERT INTO sourcemessage VALUES(4951,'public','Необходимо установить доступ хотя бы в одно помещение','','2018-01-17 14:12:33',0);
INSERT INTO sourcemessage VALUES(4952,'public','Ошибка сохранения в базу данных. Создаваемое подразделение уже существует','','2018-01-17 14:23:15',0);
INSERT INTO sourcemessage VALUES(4953,'public','Ошибка: нет подключенных настольных считывателей.','','2018-01-17 15:05:30',0);
INSERT INTO sourcemessage VALUES(4954,'public','Электронная проходная с картоприёмником','','2018-01-17 16:07:02',0);
INSERT INTO sourcemessage VALUES(4955,'public','Совпадение в базе: запись','','2018-01-17 16:11:17',0);
INSERT INTO sourcemessage VALUES(4956,'public','Нет доступных шаблонов пропусков','шаблон пропуска - дизайн карты для печати','2018-01-17 16:18:50',0);
INSERT INTO sourcemessage VALUES(4957,'public','Превышено максимальное число доступных для обработки подразделений (200 подразделений). Попробуйте построить несколько отчётов по отдельным вложенным подразделениям.','','2018-01-18 11:23:56',0);
INSERT INTO sourcemessage VALUES(4958,'public','Превышено максимальное число доступных для обработки подразделений (100 подразделений). Попробуйте построить несколько отчётов по отдельным вложенным подразделениям.','','2018-01-18 11:24:56',0);
INSERT INTO sourcemessage VALUES(4959,'public','Внимание! Сейчас будет произведен перезапуск службы базы данных и службы сервера оборудования. На время перезапуска работа на клиентских местах будет приостановлена. Для начала перезапуска нажмите кнопку "Перезапуск".',NULL,'2018-01-18 11:31:09',0);
INSERT INTO sourcemessage VALUES(4960,'public','Электронная проходная с картоприемником','','2018-01-18 12:30:01',0);
INSERT INTO sourcemessage VALUES(4961,'public','Неверный формат содержимого файла','','2018-01-18 14:14:33',0);
INSERT INTO sourcemessage VALUES(4962,'public','(К загрузке разрешены файлы форматов: .jpg .jpeg .pjpeg .png .gif)','','2018-01-18 14:14:33',0);
INSERT INTO sourcemessage VALUES(4963,'public','Ошибка: Не удалось подключиться к службе.','','2018-01-18 14:50:31',0);
INSERT INTO sourcemessage VALUES(4964,'public','Вы изменили дату "Действуют с" в учетных данных, но не изменили значения других полей. Новая дата не будет сохранена','','2018-01-18 15:20:23',0);
INSERT INTO sourcemessage VALUES(4965,'public','У этого сотрудника нет карты!','','2018-01-18 15:21:55',0);
INSERT INTO sourcemessage VALUES(4966,'public','Не задан тип','','2018-01-18 15:48:47',0);
INSERT INTO sourcemessage VALUES(4967,'public','Ничего не выбрано','','2018-01-18 15:49:55',0);
INSERT INTO sourcemessage VALUES(4968,'public','Обновление данных в таблице...','','2018-01-18 16:33:56',0);
INSERT INTO sourcemessage VALUES(4969,'public','Время ожидания подтверждения при верификации от ВВУ','ВВУ - внешнее верифицирующее устройство','2018-01-19 11:14:13',0);
INSERT INTO sourcemessage VALUES(4970,'public','При доступности софт, иначе ПДУ','ПДУ - пульт дистанционного управления','2018-01-19 11:12:23',0);
INSERT INTO sourcemessage VALUES(4971,'public','ПДУ или софт','ПДУ - пульт дистанционного управления','2018-01-19 11:12:02',0);
INSERT INTO sourcemessage VALUES(4972,'public','Время ожидания подтверждения при верификации от ПДУ','ПДУ - пульт дистанционного управления','2018-01-19 11:13:24',0);
INSERT INTO sourcemessage VALUES(4973,'public','Внимание! Карта будет изъята.','','2018-01-19 11:46:52',0);
INSERT INTO sourcemessage VALUES(4974,'public','Данный посетитель уже заблокирован','','2018-01-19 11:51:23',0);
INSERT INTO sourcemessage VALUES(4975,'public','Данный посетитель не заблокирован','','2018-01-19 11:53:36',0);
INSERT INTO sourcemessage VALUES(4976,'public','Скрыть дополнительную информацию','','2018-01-19 12:25:22',0);
INSERT INTO sourcemessage VALUES(4977,'public','Снять тревогу с зоны: Выполнено','','2018-01-19 16:40:44',0);
INSERT INTO sourcemessage VALUES(4978,'public','Поставить зону на охрану: Выполнено','','2018-01-19 16:41:42',0);
INSERT INTO sourcemessage VALUES(4979,'public','Снять зону с охраны: Выполнено','','2018-01-19 16:42:49',0);
INSERT INTO sourcemessage VALUES(4980,'public','Открыть (разблокировать) ИУ: Не выполнено','','2018-01-19 16:46:03',0);
INSERT INTO sourcemessage VALUES(4981,'public','Закрыть (заблокировать) ИУ: Не выполнено','','2018-01-19 16:47:41',0);
INSERT INTO sourcemessage VALUES(4982,'public','Проход с подтверждением от ПДУ/верификации','','2018-01-19 16:49:17',0);
INSERT INTO sourcemessage VALUES(4983,'public','Вы действительно хотите отвязать выбранный контроллер(ы)?.','','2018-01-23 14:02:20',0);
INSERT INTO sourcemessage VALUES(4984,'public','Началу смены не сопоставлено ни одного окончания смены!','','2018-01-22 16:23:57',0);
INSERT INTO sourcemessage VALUES(4985,'public','Для шаблона:','','2018-01-23 12:45:57',0);
INSERT INTO sourcemessage VALUES(4986,'public','Установлен доступ PERCo-контроллера на помещение:','','2018-01-23 15:00:09',0);
INSERT INTO sourcemessage VALUES(4987,'public','Тип режима доступа:','','2018-01-23 15:01:03',0);
INSERT INTO sourcemessage VALUES(4988,'public','Отредактировано содержание','','2018-01-23 15:06:11',0);
INSERT INTO sourcemessage VALUES(4989,'public','Имя режима доступа:','','2018-01-23 15:09:18',0);
INSERT INTO sourcemessage VALUES(4990,'public','Тип права:','','2018-01-23 15:20:17',0);
INSERT INTO sourcemessage VALUES(4991,'public','Верификация:','','2018-01-23 15:21:24',0);
INSERT INTO sourcemessage VALUES(4992,'public','Снят доступ PERCo-контроллера с помещения:','','2018-01-23 15:23:24',0);
INSERT INTO sourcemessage VALUES(4993,'public','Изменения PERCo-контроллера для помещения:','','2018-01-23 15:24:49',0);
INSERT INTO sourcemessage VALUES(4994,'public','Установлен доступ SUPREMA-контроллера на помещение:','','2018-01-23 15:25:50',0);
INSERT INTO sourcemessage VALUES(4995,'public','Снят доступ SUPREMA-контроллера с помещения:','','2018-01-23 15:26:53',0);
INSERT INTO sourcemessage VALUES(4996,'public','Изменения SUPREMA-контроллера для помещения:','','2018-01-23 15:28:51',0);
INSERT INTO sourcemessage VALUES(4997,'public','с интервалами:','','2018-01-23 16:05:33',0);
INSERT INTO sourcemessage VALUES(4998,'public','Был изменен график','','2018-01-23 16:07:30',0);
INSERT INTO sourcemessage VALUES(5000,'public','дата','','2018-01-23 16:14:46',0);
INSERT INTO sourcemessage VALUES(5001,'public','Год','','2018-01-23 16:16:54',0);
INSERT INTO sourcemessage VALUES(5002,'public','Добавлен','','2018-01-23 16:23:39',0);
INSERT INTO sourcemessage VALUES(5003,'public','Добавлен день','','2018-01-23 16:24:15',0);
INSERT INTO sourcemessage VALUES(5004,'public','Проход с подтверждением от ПДУ/верификации: с несоответствием временным критериям доступа','','2018-01-24 15:18:00',0);
INSERT INTO sourcemessage VALUES(5005,'public','Для контроллера:','','2018-01-24 15:19:46',0);
INSERT INTO sourcemessage VALUES(5006,'public','выкл','','2018-01-24 15:21:07',0);
INSERT INTO sourcemessage VALUES(5007,'public','вкл','','2018-01-24 15:22:33',0);
INSERT INTO sourcemessage VALUES(5008,'public','Родительская категория','для помещений','2018-01-24 15:26:14',0);
INSERT INTO sourcemessage VALUES(5009,'public','Установить устройства',NULL,'2018-01-25 12:40:55',0);
INSERT INTO sourcemessage VALUES(5010,'public','Нет связи с камерой',NULL,'2018-01-25 12:45:00',0);
INSERT INTO sourcemessage VALUES(5011,'public','Номер ИУ','','2018-01-26 10:18:31',0);
INSERT INTO sourcemessage VALUES(5012,'public','ИУ CL201 1','','2018-01-26 10:21:31',0);
INSERT INTO sourcemessage VALUES(5013,'public','ИУ CL201','','2018-01-26 10:21:45',0);
INSERT INTO sourcemessage VALUES(5014,'public','ИУ CL201 2','','2018-01-26 10:21:55',0);
INSERT INTO sourcemessage VALUES(5015,'public','ИУ CL201 3','','2018-01-26 10:22:13',0);
INSERT INTO sourcemessage VALUES(5016,'public','ИУ CL201 4','','2018-01-26 10:22:49',0);
INSERT INTO sourcemessage VALUES(5017,'public','ИУ CL201 5','','2018-01-26 10:23:01',0);
INSERT INTO sourcemessage VALUES(5018,'public','ИУ CL201 6','','2018-01-26 10:23:11',0);
INSERT INTO sourcemessage VALUES(5019,'public','ИУ CL201 7','','2018-01-26 10:23:21',0);
INSERT INTO sourcemessage VALUES(5020,'public','ИУ CL201 8','','2018-01-26 10:23:33',0);
INSERT INTO sourcemessage VALUES(5021,'public','Дня','','2018-01-26 11:13:42',0);
INSERT INTO sourcemessage VALUES(5022,'public','Дней','','2018-01-26 11:14:43',0);
INSERT INTO sourcemessage VALUES(5023,'public','Добавлен интервал','','2018-01-26 12:07:20',0);
INSERT INTO sourcemessage VALUES(5024,'public','без перехода через 0','','2018-01-26 12:07:57',0);
INSERT INTO sourcemessage VALUES(5025,'public','дата:','','2018-01-26 12:20:48',0);
INSERT INTO sourcemessage VALUES(5026,'public','Видеозапись не найдена',NULL,'2018-01-26 12:45:13',0);
INSERT INTO sourcemessage VALUES(5027,'public','Для подразделения','','2018-01-26 12:46:53',0);
INSERT INTO sourcemessage VALUES(5029,'public','Передать изменения конфигурации в устройства',NULL,'2018-01-26 13:30:33',0);
INSERT INTO sourcemessage VALUES(5030,'public','Передать всю конфигурацию в устройства',NULL,'2018-01-26 13:31:12',0);
INSERT INTO sourcemessage VALUES(5031,'public','Наименование поля','','2018-01-26 13:35:04',0);
INSERT INTO sourcemessage VALUES(5032,'public','Удалить помещение / Отвязать устройство',NULL,'2018-01-26 13:36:53',0);
INSERT INTO sourcemessage VALUES(5033,'public','Установить устройство',NULL,'2018-01-26 13:41:58',0);
INSERT INTO sourcemessage VALUES(5034,'public','Все в устройство(а)',NULL,'2018-01-26 13:54:19',0);
INSERT INTO sourcemessage VALUES(5035,'public','Измененные в устройство(а)',NULL,'2018-01-26 13:55:28',0);
INSERT INTO sourcemessage VALUES(5036,'public','с','Изменяется с чего-то на что-то','2018-01-29 11:09:51',0);
INSERT INTO sourcemessage VALUES(5037,'public','на','Изменяется с чего-то на что-то','2018-01-29 11:12:15',0);
INSERT INTO sourcemessage VALUES(5038,'public','Изменена временная зона','','2018-01-29 11:13:30',0);
INSERT INTO sourcemessage VALUES(5039,'public','Старые значения интервалов','','2018-01-29 11:14:03',0);
INSERT INTO sourcemessage VALUES(5040,'public','Новые значения интервалов','','2018-01-29 11:14:47',0);
INSERT INTO sourcemessage VALUES(5041,'public','Имя зоны','','2018-01-29 11:49:39',0);
INSERT INTO sourcemessage VALUES(5042,'public','стало','','2018-01-29 11:55:08',0);
INSERT INTO sourcemessage VALUES(5043,'public','Для недельного режима доступа','','2018-01-29 12:02:43',0);
INSERT INTO sourcemessage VALUES(5044,'public','Изменен сменный суточный режим доступа','','2018-01-29 16:15:35',0);
INSERT INTO sourcemessage VALUES(5045,'public','Старые временные зоны','','2018-01-29 16:16:06',0);
INSERT INTO sourcemessage VALUES(5046,'public','Новые временные зоны','','2018-01-29 16:16:32',0);
INSERT INTO sourcemessage VALUES(5047,'public','заблокирована карта','','2018-01-30 10:40:54',0);
INSERT INTO sourcemessage VALUES(5048,'public','Не указана длительность документа','','2018-01-30 11:07:54',0);
INSERT INTO sourcemessage VALUES(5050,'public','Нет доступных наименований документов для добавления','','2018-01-30 11:14:33',0);
INSERT INTO sourcemessage VALUES(5051,'public','Документ удален','','2018-01-30 11:18:50',0);
INSERT INTO sourcemessage VALUES(5052,'public','Такое значение сортировки уже используется','','2018-01-30 11:59:05',0);
INSERT INTO sourcemessage VALUES(5053,'public','Для документа','','2018-01-30 12:05:57',0);
INSERT INTO sourcemessage VALUES(5054,'public','Вы действительно хотите отвязать выбранный контроллер(ы)?','','2018-01-30 14:06:22',0);
INSERT INTO sourcemessage VALUES(5055,'public','Необходимо выбрать временную зону','','2018-01-31 11:46:15',0);
INSERT INTO sourcemessage VALUES(5056,'public','Просмотр графика работы','','2018-01-31 13:11:51',0);
INSERT INTO sourcemessage VALUES(5057,'public','Ошибка: нет подключенных настольных считывателей типа Mifare','','2018-02-01 11:14:29',0);
INSERT INTO sourcemessage VALUES(5058,'public','Критерий доступа не выбран','','2018-02-01 12:51:39',0);
INSERT INTO sourcemessage VALUES(5059,'public','Необходимо выбрать критерий доступа','','2018-02-01 12:52:29',0);
INSERT INTO sourcemessage VALUES(5060,'public','Данный оператор уже заблокирован','','2018-02-01 14:14:23',0);
INSERT INTO sourcemessage VALUES(5061,'public','Началу смены не сопоставлено ни одного окончания смены','','2018-02-05 11:58:45',0);
INSERT INTO sourcemessage VALUES(5062,'public','Шаблон не выбран','','2018-02-05 14:57:20',0);
INSERT INTO sourcemessage VALUES(5063,'public','Временной интервал не должен превышать 31 день','','2018-02-05 15:15:44',0);
INSERT INTO sourcemessage VALUES(5064,'public','Замедлить воспроизведение','','2018-02-05 15:49:35',0);
INSERT INTO sourcemessage VALUES(5065,'public','Задание не выбрано','','2018-02-05 16:17:07',0);
INSERT INTO sourcemessage VALUES(5066,'public','Название роли должно быть заполнено','','2018-02-05 16:22:32',0);
INSERT INTO sourcemessage VALUES(5067,'public','Блокировка оператора','','2018-02-08 10:41:52',0);
INSERT INTO sourcemessage VALUES(5068,'public','Снятие блокировки оператора','','2018-02-08 10:42:22',0);
INSERT INTO sourcemessage VALUES(5069,'public','Запись идентификатора в карту','','2018-02-08 11:57:09',0);
INSERT INTO sourcemessage VALUES(5070,'public','В это помещение добавление устройств запрещено\r\n',NULL,'2018-02-14 15:56:28',0);
INSERT INTO sourcemessage VALUES(5071,'public','здесь','','2018-02-15 12:45:08',0);
INSERT INTO sourcemessage VALUES(5072,'public','Срок действия работы с ознакомительной лицензией истек. Для полноценного использования Вы должны купить лицензию на пакеты ПО PERCo-WS; PERCo-WM-01; PERCo-WM-02 или активировать лицензию на бесплатное бессрочное использование пакета программного обеспечения PERCo-WB. Для заказа пройдите по ссылке. Подробнее об использовании пакета бесплатного ПО PERCo-WB Вы можете узнать','','2018-02-15 12:45:34',0);
INSERT INTO sourcemessage VALUES(5073,'public','Купить(заказать) лицензию','','2018-02-15 12:46:04',0);
INSERT INTO sourcemessage VALUES(5074,'public','Выйти из системы','','2018-02-15 17:14:36',0);
INSERT INTO sourcemessage VALUES(5075,'public','Параметры камеры','','2018-02-19 11:24:51',0);
INSERT INTO sourcemessage VALUES(5076,'public','Прошивка','','2018-02-19 11:25:27',0);
INSERT INTO sourcemessage VALUES(5078,'public','Серийный номер','','2018-02-19 11:26:00',0);
INSERT INTO sourcemessage VALUES(5079,'public','О камере','','2018-02-21 10:20:28',0);
INSERT INTO sourcemessage VALUES(5080,'public','Тип устройства','','2018-03-19 09:53:37',0);
INSERT INTO sourcemessage VALUES(5081,'public','Нет ни одного оператора','','2018-04-04 10:43:23',0);
INSERT INTO sourcemessage VALUES(5082,'public','Изменился тип контроллера','','2018-04-05 16:14:52',0);
INSERT INTO sourcemessage VALUES(5083,'public','супер-карта\r\n',NULL,'2018-04-09 09:59:12',0);
INSERT INTO sourcemessage VALUES(5084,'public','неизвестный тип карты\r\n',NULL,'2018-04-09 10:01:20',0);
INSERT INTO sourcemessage VALUES(5085,'public','неизвестно (не подошли ключи: ключ по умолчанию, текущий ключ карты, старый ключ карты, мастер ключ, ключ супер-карты)\r\n',NULL,'2018-04-09 10:03:25',0);
INSERT INTO sourcemessage VALUES(5086,'public','ключ карты отличается от ключа в конфигурации\r\n',NULL,'2018-04-09 10:06:53',0);
INSERT INTO sourcemessage VALUES(5089,'public','ВНИМАНИЕ! В случае изменения данного ключа необходимо записать мастер-карту с новым ключом, после чего переконфигурировать ей все считыватели (в том числе и временно выключенные)','','2018-04-10 12:31:16',0);
INSERT INTO sourcemessage VALUES(5090,'public','Неизвестный тип карты','','2018-04-10 12:32:55',0);
INSERT INTO sourcemessage VALUES(5091,'public','Приложите карту','','2018-04-11 09:23:51',0);
INSERT INTO sourcemessage VALUES(5092,'public','Карта не персонифицирована','','2018-04-11 09:25:43',0);
INSERT INTO sourcemessage VALUES(5093,'public','Сохранение в карту','','2018-04-12 15:12:19',0);
INSERT INTO sourcemessage VALUES(5094,'public','Если приложение уже установлено','','2018-04-12 15:13:01',0);
INSERT INTO sourcemessage VALUES(5095,'public','нажмите сюда','','2018-04-12 15:13:42',0);
INSERT INTO sourcemessage VALUES(5096,'public','Ошибка: нет связи с контрольным считывателем.','','2018-04-12 15:32:49',0);
INSERT INTO sourcemessage VALUES(5097,'public','Ошибка: ответа от службы не поступило.','','2018-04-12 15:34:31',0);
INSERT INTO sourcemessage VALUES(5098,'public','Ошибка: Нет связи с приложением, попробуйте настроить его.','','2018-04-12 15:35:23',0);
INSERT INTO sourcemessage VALUES(5099,'public','Ваша версия приложения устарела.','','2018-04-12 15:35:50',0);
INSERT INTO sourcemessage VALUES(5100,'public','Ошибка: нет подключенных настольных считывателей типа Mifare.','','2018-04-12 15:36:53',0);
INSERT INTO sourcemessage VALUES(5101,'public','Неверный пароль','','2018-04-12 15:38:05',0);
INSERT INTO sourcemessage VALUES(5102,'public','Ошибка записи на карту','','2018-04-12 15:40:15',0);
INSERT INTO sourcemessage VALUES(5103,'public','Ошибка чтения с карты','','2018-04-12 15:40:38',0);
INSERT INTO sourcemessage VALUES(5104,'public','Ошибка изменения ключа','','2018-04-12 15:40:56',0);
INSERT INTO sourcemessage VALUES(5105,'public','Ошибка персонализации карты','','2018-04-12 15:41:10',0);
INSERT INTO sourcemessage VALUES(5106,'public','Ошибка изменения уровня безопасности','','2018-04-12 15:42:00',0);
INSERT INTO sourcemessage VALUES(5107,'public','Ошибка записи конфигурации','','2018-04-12 15:42:19',0);
INSERT INTO sourcemessage VALUES(5108,'public','Ошибка чтения конфигурации','','2018-04-12 15:42:36',0);
INSERT INTO sourcemessage VALUES(5109,'public','Недостаточно памяти на карте','','2018-04-12 15:42:50',0);
INSERT INTO sourcemessage VALUES(5110,'public','Нет свободного приложения на карте','','2018-04-12 15:43:08',0);
INSERT INTO sourcemessage VALUES(5111,'public','Ошибка создания приложения','','2018-04-12 15:43:41',0);
INSERT INTO sourcemessage VALUES(5112,'public','Превышено максимально допустимое значение номера карты','','2018-04-12 15:44:58',0);
INSERT INTO sourcemessage VALUES(5113,'public','Статус карты:','','2018-04-12 15:46:55',0);
INSERT INTO sourcemessage VALUES(5114,'public','Карта имеет ключ аутентификации идентичный параметру «старый ключ»','','2018-04-12 15:47:34',0);
INSERT INTO sourcemessage VALUES(5115,'public','Ответ от считывателя не получен','','2018-04-12 15:48:56',0);
INSERT INTO sourcemessage VALUES(5116,'public','Добавлено новое приложение, возникает когда есть сторонние приложения на карте','','2018-04-12 15:49:23',0);
INSERT INTO sourcemessage VALUES(5117,'public','Невозможно записать мастер-карту. В памяти считывателя конфигурация по умолчанию','','2018-04-12 15:50:32',0);
INSERT INTO sourcemessage VALUES(5118,'public','Неверный ключ карты (ключ или тип)','','2018-04-12 15:51:52',0);
INSERT INTO sourcemessage VALUES(5119,'public','Неверный ID приложения','','2018-04-12 15:52:56',0);
INSERT INTO sourcemessage VALUES(5120,'public','Ошибка форматирования','','2018-04-12 15:53:26',0);
INSERT INTO sourcemessage VALUES(5121,'public','Карта имеет ключ аутентификации идентичный параметру «старый ключ» («текущий ключ» не подошел)','','2018-04-12 15:53:59',0);
INSERT INTO sourcemessage VALUES(5122,'public','Карта имеет ключ аутентификации идентичный параметру «текущий ключ» («старый ключ»  не подошел)','','2018-04-12 15:54:29',0);
INSERT INTO sourcemessage VALUES(5123,'public','Карту Plus S не перевести на уровень безопасности SL2 (доступен только SL1 и SL3)','','2018-04-12 15:54:56',0);
INSERT INTO sourcemessage VALUES(5124,'public','Карта должна находится на SL1 или SL2','','2018-04-12 15:55:11',0);
INSERT INTO sourcemessage VALUES(5125,'public','Добавлено новое приложение','','2018-04-12 15:55:38',0);
INSERT INTO sourcemessage VALUES(5126,'public','Карта имеет ключ аутентификации идентичный параметру «старый ключ» («текущий ключ» не подошел), добавлено новое приложение','','2018-04-12 15:55:55',0);
INSERT INTO sourcemessage VALUES(5127,'public','Неверный ключ приложения (ключ или тип)','','2018-04-12 15:56:21',0);
INSERT INTO sourcemessage VALUES(5128,'public','Неверный «Номер команды»','','2018-04-12 15:56:35',0);
INSERT INTO sourcemessage VALUES(5129,'public','Недопустимое значение параметра "Тип мастер-карты"','','2018-04-12 15:56:53',0);
INSERT INTO sourcemessage VALUES(5130,'public','Неправильный текущий уровень мастер-карты','','2018-04-12 15:57:09',0);
INSERT INTO sourcemessage VALUES(5131,'public','Неправильный размер выхода Wiegand','','2018-04-12 15:57:27',0);
INSERT INTO sourcemessage VALUES(5132,'public','Неправильное количество линий управления индикацией','','2018-04-12 15:57:43',0);
INSERT INTO sourcemessage VALUES(5139,'public','Неправильный номер блока','','2018-04-12 16:01:14',0);
INSERT INTO sourcemessage VALUES(5140,'public','Неправильный номер сектора','','2018-04-12 16:01:37',0);
INSERT INTO sourcemessage VALUES(5141,'public','Неправильный номер страницы','','2018-04-12 16:03:02',0);
INSERT INTO sourcemessage VALUES(5142,'public','Неправильный тип ключа для аутентификации','','2018-04-12 16:03:23',0);
INSERT INTO sourcemessage VALUES(5143,'public','Ключ не должен быть идентичен ключу по умолчанию (FF FF FF FF FF FF)(старый)','','2018-04-12 16:03:53',0);
INSERT INTO sourcemessage VALUES(5144,'public','Ключ не должен быть идентичен ключу по умолчанию (FF FF FF FF FF FF)','','2018-04-12 16:04:20',0);
INSERT INTO sourcemessage VALUES(5145,'public','Неправильный уровень безопасности','','2018-04-12 16:04:38',0);
INSERT INTO sourcemessage VALUES(5146,'public','Тип ключа карты (DESFire)','','2018-04-12 16:05:29',0);
INSERT INTO sourcemessage VALUES(5147,'public','Тип ключа приложения (DESFire) старый','','2018-04-12 16:06:49',0);
INSERT INTO sourcemessage VALUES(5148,'public','Тип ключа приложения (DESFire)','','2018-04-12 16:07:10',0);
INSERT INTO sourcemessage VALUES(5149,'public','Номер приложения (текущий или старый) не должен быть равным нулю','','2018-04-12 16:08:23',0);
INSERT INTO sourcemessage VALUES(5150,'public','В выбранное','','2018-04-12 16:10:39',0);
INSERT INTO sourcemessage VALUES(5151,'public','нет доступа','','2018-04-12 16:11:02',0);
INSERT INTO sourcemessage VALUES(5152,'public','Можно записывать только одну карту за раз!','','2018-04-12 16:16:06',0);
INSERT INTO sourcemessage VALUES(5153,'public','Контроллер Suprema BioEntry P2','','2018-04-12 16:52:44',0);
INSERT INTO sourcemessage VALUES(5154,'public','Отключение Стандартного пакета','','2018-04-13 13:47:05',0);
INSERT INTO sourcemessage VALUES(5155,'public','Не удалось выполнить запрос','','2018-04-13 13:47:27',0);
INSERT INTO sourcemessage VALUES(5156,'public','Ключ слишком длинный и содержит недопустимые символы','','2018-04-13 13:47:39',0);
INSERT INTO sourcemessage VALUES(5157,'public','Ключ слишком длинный','','2018-04-13 13:48:08',0);
INSERT INTO sourcemessage VALUES(5158,'public','Выберите роль','','2018-04-13 13:48:21',0);
INSERT INTO sourcemessage VALUES(5159,'public','Значением первого октета не может быть нуль','','2018-04-13 13:48:32',0);
INSERT INTO sourcemessage VALUES(5160,'public','Значение октета не может превышать 255','','2018-04-13 13:48:45',0);
INSERT INTO sourcemessage VALUES(5161,'public','Значением последнего октета ip-адреса не может быть нуль','','2018-04-13 13:48:59',0);
INSERT INTO sourcemessage VALUES(5162,'public','Изменения не будут сохранены','','2018-04-13 13:49:24',0);
INSERT INTO sourcemessage VALUES(5163,'public','Нет доступа к помещению','','2018-04-13 13:49:38',0);
INSERT INTO sourcemessage VALUES(5164,'public','Пустая строка','','2018-04-13 13:49:49',0);
INSERT INTO sourcemessage VALUES(5165,'public','Ожидает отключения','','2018-04-13 13:50:01',0);
INSERT INTO sourcemessage VALUES(5166,'public','Ожидает включения','','2018-04-13 13:50:13',0);
INSERT INTO sourcemessage VALUES(5167,'public','Контроллер можно удалить только вместе с дочерними элементами','','2018-04-13 13:50:25',0);
INSERT INTO sourcemessage VALUES(5168,'public','Исправьте поля с ошибками','','2018-04-13 13:50:40',0);
INSERT INTO sourcemessage VALUES(5169,'public','Неправильный формат','','2018-04-13 13:50:52',0);
INSERT INTO sourcemessage VALUES(5170,'public','Значение должно быть от 1 до 251','','2018-04-13 13:51:04',0);
INSERT INTO sourcemessage VALUES(5171,'public','сек','','2018-04-13 13:51:15',0);
INSERT INTO sourcemessage VALUES(5172,'public','бесконечность','','2018-04-13 13:51:29',0);
INSERT INTO sourcemessage VALUES(5173,'public','Имя должно быть указано','','2018-04-13 13:54:15',0);
INSERT INTO sourcemessage VALUES(5174,'public','Идет подключение к серверу системы','','2018-04-13 13:55:05',0);
INSERT INTO sourcemessage VALUES(5175,'public','Пароль должен быть длиннее 6 символов, короче 10 и содержать хотя бы одну букву латинского алфавита и цифру','','2018-04-13 13:55:22',0);
INSERT INTO sourcemessage VALUES(5176,'public','Вск','','2018-04-13 13:55:43',0);
INSERT INTO sourcemessage VALUES(5177,'public','Пнд','','2018-04-13 13:56:44',0);
INSERT INTO sourcemessage VALUES(5178,'public','Втр','','2018-04-13 13:56:56',0);
INSERT INTO sourcemessage VALUES(5179,'public','Срд','','2018-04-13 13:57:07',0);
INSERT INTO sourcemessage VALUES(5180,'public','Чтв','','2018-04-13 13:57:18',0);
INSERT INTO sourcemessage VALUES(5181,'public','Птн','','2018-04-13 13:57:29',0);
INSERT INTO sourcemessage VALUES(5182,'public','Суб','','2018-04-13 13:57:45',0);
INSERT INTO sourcemessage VALUES(5183,'public','Не выбрано ни одного дня','','2018-04-13 13:57:58',0);
INSERT INTO sourcemessage VALUES(5184,'public','Это приведет к отключению резервного копирования базы данных!','','2018-04-13 13:58:14',0);
INSERT INTO sourcemessage VALUES(5185,'public','Это приведет к увеличению продолжительности расчета отчетов по УРВ!','','2018-05-16 14:53:18',0);
INSERT INTO sourcemessage VALUES(5186,'public','Это приведет к отмене ввода всех автоматических замен, прав доступа/шаблонов доступа!','','2018-04-13 13:59:23',0);
INSERT INTO sourcemessage VALUES(5187,'public','Ошибка: запрос свободной памяти карты','','2018-04-13 13:59:37',0);
INSERT INTO sourcemessage VALUES(5188,'public','Ошибка: неверный тип карты','','2018-04-13 13:59:51',0);
INSERT INTO sourcemessage VALUES(5189,'public','Недопустимое значение параметра Тип мастер-карты','','2018-04-13 14:00:05',0);
INSERT INTO sourcemessage VALUES(5190,'public','Неправильный номер страницы (Ultralight, Ultralight EV1)','','2018-04-13 14:10:14',0);
INSERT INTO sourcemessage VALUES(5191,'public','Неправильный номер страницы (Ultralight EV1 128)','','2018-04-13 14:10:26',0);
INSERT INTO sourcemessage VALUES(5192,'public','Неправильный номер страницы (Ultralight C)','','2018-04-13 14:10:39',0);
INSERT INTO sourcemessage VALUES(5193,'public','Неправильный номер блока Mifare ID','','2018-04-13 14:10:52',0);
INSERT INTO sourcemessage VALUES(5194,'public','Неправильный номер сектора Classic 1KB','','2018-04-13 14:11:06',0);
INSERT INTO sourcemessage VALUES(5195,'public','Неправильный номер блока Classic 1KB','','2018-04-13 14:11:26',0);
INSERT INTO sourcemessage VALUES(5196,'public','Неправильный номер сектора Classic 4KB','','2018-04-13 14:11:39',0);
INSERT INTO sourcemessage VALUES(5197,'public','Неправильный номер блока Classic 4KB','','2018-04-13 14:11:54',0);
INSERT INTO sourcemessage VALUES(5198,'public','Неправильный номер сектора Plus 2KB','','2018-04-13 14:12:08',0);
INSERT INTO sourcemessage VALUES(5199,'public','Неправильный номер блока Plus 2KB','','2018-04-13 14:12:22',0);
INSERT INTO sourcemessage VALUES(5200,'public','Неправильный номер сектора Plus 4KB','','2018-04-13 14:12:34',0);
INSERT INTO sourcemessage VALUES(5201,'public','Неправильный номер блока Plus 4KB','','2018-04-13 14:12:47',0);
INSERT INTO sourcemessage VALUES(5202,'public','Неправильный номер сектора Plus SE 1KB','','2018-04-13 14:12:59',0);
INSERT INTO sourcemessage VALUES(5203,'public','Неправильный номер блока Plus SE 1KB','','2018-04-13 14:13:12',0);
INSERT INTO sourcemessage VALUES(5204,'public','Тип ключа карты (DESFire) старый','','2018-04-13 14:13:25',0);
INSERT INTO sourcemessage VALUES(5205,'public','Номер приложения (текущий или старый) не должен быть равным нулю (DESFire)','','2018-04-13 14:13:58',0);
INSERT INTO sourcemessage VALUES(5206,'public','Поднесите карту к считывателю','','2018-04-13 14:14:20',0);
INSERT INTO sourcemessage VALUES(5207,'public','Ошибка: Не удалось подключиться','','2018-04-13 14:15:10',0);
INSERT INTO sourcemessage VALUES(5208,'public','Остановить','','2018-04-13 14:17:47',0);
INSERT INTO sourcemessage VALUES(5209,'public','Архивные','','2018-04-13 14:17:59',0);
INSERT INTO sourcemessage VALUES(5210,'public','Нет доступа к контроллеру','','2018-04-13 14:18:14',0);
INSERT INTO sourcemessage VALUES(5211,'public','Ваш браузер не поддерживает canvas','','2018-04-13 14:19:02',0);
INSERT INTO sourcemessage VALUES(5213,'public','За один раз можно напечатать информацию только об одном событии','','2018-04-13 14:19:34',0);
INSERT INTO sourcemessage VALUES(5214,'public','Искать по столбцу','','2018-04-13 14:19:47',0);
INSERT INTO sourcemessage VALUES(5215,'public','Поиск по','','2018-04-13 14:20:02',0);
INSERT INTO sourcemessage VALUES(5216,'public','Уведомление','','2018-04-13 14:20:49',0);
INSERT INTO sourcemessage VALUES(5217,'public','IP Адрес','','2018-04-13 14:21:01',0);
INSERT INTO sourcemessage VALUES(5218,'public','Информация','','2018-04-13 14:22:00',0);
INSERT INTO sourcemessage VALUES(5219,'public','Ваша учетная запись была заблокирована. Обратитесь к администратору.','','2018-04-13 14:22:58',0);
INSERT INTO sourcemessage VALUES(5220,'public','Нет соединения с веб-сервером','','2018-04-13 14:23:12',0);
INSERT INTO sourcemessage VALUES(5221,'public','Обрезать до','','2018-04-13 14:23:28',0);
INSERT INTO sourcemessage VALUES(5222,'public','Некорректная серия','','2018-04-13 14:23:39',0);
INSERT INTO sourcemessage VALUES(5223,'public','не может быть добавлена','','2018-04-13 14:23:52',0);
INSERT INTO sourcemessage VALUES(5224,'public','Идет загрузка таблицы. Пожалуйста, ждите!','','2018-04-13 14:24:19',0);
INSERT INTO sourcemessage VALUES(5225,'public','Ошибка доступа к разделу: Нет доступных подразделений','','2018-04-13 14:24:44',0);
INSERT INTO sourcemessage VALUES(5226,'public','Редактирование пропусков выбранных посетителей','','2018-04-13 14:24:58',0);
INSERT INTO sourcemessage VALUES(5227,'public','Пересоздать можно только одного посетителя за раз','','2018-04-13 14:25:43',0);
INSERT INTO sourcemessage VALUES(5228,'public','Сканирование','','2018-04-13 14:26:12',0);
INSERT INTO sourcemessage VALUES(5229,'public','Переполнение значения поля','','2018-04-13 14:27:02',0);
INSERT INTO sourcemessage VALUES(5231,'public','символов','','2018-04-13 14:27:30',0);
INSERT INTO sourcemessage VALUES(5232,'public','Всего записей','','2018-04-13 14:27:41',0);
INSERT INTO sourcemessage VALUES(5233,'public','Для следующих помещений не установлено название критерия','','2018-04-13 14:27:59',0);
INSERT INTO sourcemessage VALUES(5234,'public','Количество временных зон максимально','','2018-04-13 14:28:15',0);
INSERT INTO sourcemessage VALUES(5235,'public','Некорректные размеры','','2018-04-13 14:28:26',0);
INSERT INTO sourcemessage VALUES(5236,'public','Сброс информации сотрудника','','2018-04-13 14:28:40',0);
INSERT INTO sourcemessage VALUES(5237,'public','Не указана дата начала','','2018-04-13 14:31:50',0);
INSERT INTO sourcemessage VALUES(5238,'public','У этого сотрудника нет карты','','2018-04-13 14:32:13',0);
INSERT INTO sourcemessage VALUES(5239,'public','Данные сотрудники уже заблокированы','','2018-04-13 14:33:55',0);
INSERT INTO sourcemessage VALUES(5240,'public','Будут заблокированы','','2018-04-13 14:34:34',0);
INSERT INTO sourcemessage VALUES(5241,'public','Будет заблокирован','','2018-04-13 14:34:51',0);
INSERT INTO sourcemessage VALUES(5242,'public','У данных сотрудников нет карт','','2018-04-13 14:35:07',0);
INSERT INTO sourcemessage VALUES(5243,'public','У данного сотрудника нет карты','','2018-04-13 14:35:24',0);
INSERT INTO sourcemessage VALUES(5244,'public','Данные сотрудники не заблокированы','','2018-04-13 14:40:13',0);
INSERT INTO sourcemessage VALUES(5245,'public','Будут разблокированы','','2018-04-13 14:40:29',0);
INSERT INTO sourcemessage VALUES(5246,'public','Будет разблокирован','','2018-04-13 14:40:44',0);
INSERT INTO sourcemessage VALUES(5247,'public','Данные посетители уже заблокированы','','2018-04-13 14:42:31',0);
INSERT INTO sourcemessage VALUES(5248,'public','Данные посетители не заблокированы','','2018-04-13 14:42:43',0);
INSERT INTO sourcemessage VALUES(5249,'public','Не указан шаблон доступа','','2018-04-13 14:42:54',0);
INSERT INTO sourcemessage VALUES(5250,'public','Дата окончания не может быть раньше даты начала!','','2018-04-13 15:21:29',0);
INSERT INTO sourcemessage VALUES(5251,'public','Дата и время окончания не может быть ранее текущей даты и времени!','','2018-04-13 15:21:56',0);
INSERT INTO sourcemessage VALUES(5252,'public','Нет доступа к подразделению','','2018-04-13 15:22:11',0);
INSERT INTO sourcemessage VALUES(5253,'public','Всего должностей','','2018-04-13 15:22:24',0);
INSERT INTO sourcemessage VALUES(5254,'public','Не выбрана должность','','2018-04-13 15:22:37',0);
INSERT INTO sourcemessage VALUES(5255,'public','Слишком длинное описание','','2018-04-13 15:22:49',0);
INSERT INTO sourcemessage VALUES(5256,'public','Дней в графике должно быть больше 0','','2018-04-13 15:25:03',0);
INSERT INTO sourcemessage VALUES(5257,'public','Окончанию смены не сопоставлено ни одно начало смены','','2018-04-13 15:25:43',0);
INSERT INTO sourcemessage VALUES(5258,'public','Полная смена не может лежать внутри другой смены','','2018-04-13 15:27:54',0);
INSERT INTO sourcemessage VALUES(5259,'public','В одном дне может находится только одно начало смены или одна полная смена','','2018-04-13 15:28:21',0);
INSERT INTO sourcemessage VALUES(5260,'public','Промежуточный интервал должен иметь и начало и окончание','','2018-04-13 15:28:57',0);
INSERT INTO sourcemessage VALUES(5261,'public','Одна смена не может быть длиннее 47:59 или дважды переходить через ноль','','2018-04-13 15:34:13',0);
INSERT INTO sourcemessage VALUES(5262,'public','В одном дне может находится только один конец смены','','2018-04-13 15:34:31',0);
INSERT INTO sourcemessage VALUES(5263,'public','Смены в недельном графике не могут переходить через 0','','2018-04-13 15:35:05',0);
INSERT INTO sourcemessage VALUES(5264,'public','Удаление дня запрещено при наличии временных интервалов в этот день','','2018-04-13 15:35:23',0);
INSERT INTO sourcemessage VALUES(5265,'public','Дней не может быть меньше 2','','2018-04-13 15:36:26',0);
INSERT INTO sourcemessage VALUES(5266,'public','Войти в рабочий режим','','2018-04-13 15:38:01',0);
INSERT INTO sourcemessage VALUES(5267,'public','Копируемый интервал заменит имеющиеся в этом диапазоне времени. Продолжить?','','2018-04-13 15:39:40',0);
INSERT INTO sourcemessage VALUES(5268,'public','Неверное значение времени','','2018-04-13 15:41:40',0);
INSERT INTO sourcemessage VALUES(5269,'public','Максимальное количество действующих карт доступа в базовой версии программного обеспечения - 100 штук','','2018-04-13 15:44:24',0);
INSERT INTO sourcemessage VALUES(5270,'public','У этих сотрудников нет карт','','2018-04-13 15:45:22',0);
INSERT INTO sourcemessage VALUES(5271,'public','Карты будут изъяты у следующих сотрудников','','2018-04-13 15:45:35',0);
INSERT INTO sourcemessage VALUES(5272,'public','Карта будет изъята у сотрудника','','2018-04-13 15:45:47',0);
INSERT INTO sourcemessage VALUES(5273,'public','Вы изменили дату приёма на работу. Проверьте соответствие данных в планировщике','','2018-04-13 15:46:00',0);
INSERT INTO sourcemessage VALUES(5274,'public','Вы изменили дату Действуют с в учетных данных, но не изменили значения других полей. Новая дата не будет сохранена','','2018-04-13 15:46:17',0);
INSERT INTO sourcemessage VALUES(5275,'public','Нет доступных наименований документов для добавления.','','2018-04-13 15:50:51',0);
INSERT INTO sourcemessage VALUES(5276,'public','Документ добавлен','','2018-04-13 15:51:36',0);
INSERT INTO sourcemessage VALUES(5277,'public','Документ сохранен','','2018-04-13 15:51:47',0);
INSERT INTO sourcemessage VALUES(5278,'public','Включена','','2018-04-13 15:52:19',0);
INSERT INTO sourcemessage VALUES(5279,'public','Отключена','','2018-04-13 15:52:32',0);
INSERT INTO sourcemessage VALUES(5280,'public','Событие изменения учетных данных с такой датой начала уже существует.','','2018-04-13 15:53:33',0);
INSERT INTO sourcemessage VALUES(5281,'public','Для следующих помещений не установлено название критерия!','','2018-04-13 16:02:54',0);
INSERT INTO sourcemessage VALUES(5282,'public','Необходимо выбрать режим доступа','','2018-04-13 16:04:08',0);
INSERT INTO sourcemessage VALUES(5283,'public','Неизвестно','','2018-04-13 16:04:35',0);
INSERT INTO sourcemessage VALUES(5284,'public','Несоответствие типа контроллера состоянию перемычек','','2018-04-13 16:07:26',0);
INSERT INTO sourcemessage VALUES(5285,'public','Куда(подразделение)','','2018-04-13 16:07:54',0);
INSERT INTO sourcemessage VALUES(5286,'public','Выбранный тип документа уже используется в расчетах.','','2018-04-13 16:18:13',0);
INSERT INTO sourcemessage VALUES(5287,'public','Сохранить изменения','','2018-04-13 16:18:41',0);
INSERT INTO sourcemessage VALUES(5288,'public','Выйти из полноэкранного режима (ESC)','','2018-04-13 16:26:42',0);
INSERT INTO sourcemessage VALUES(5289,'public','Скачать','','2018-04-13 16:30:53',0);
INSERT INTO sourcemessage VALUES(5290,'public','Верификация: проход сотрудника и нарушение времени и нарушение местоположения','','2018-04-13 16:31:56',0);
INSERT INTO sourcemessage VALUES(5291,'public','Верификация: проход посетителя и нарушение времени и нарушение местоположения','','2018-04-13 16:32:11',0);
INSERT INTO sourcemessage VALUES(5292,'public','контроллер занят другим сервером','','2018-04-13 16:36:49',0);
INSERT INTO sourcemessage VALUES(5293,'public','ошибка типа контроллера','','2018-04-13 16:54:09',0);
INSERT INTO sourcemessage VALUES(5294,'public','ошибка запуска верификации/индикации','','2018-04-13 16:55:53',0);
INSERT INTO sourcemessage VALUES(5295,'public','ошибка шаблона','','2018-04-13 16:56:27',0);
INSERT INTO sourcemessage VALUES(5296,'public','Отсутствуют права доступа к данной точке','','2018-04-13 17:22:36',0);
INSERT INTO sourcemessage VALUES(5297,'public','Неверное значение поля','','2018-04-13 17:23:24',0);
INSERT INTO sourcemessage VALUES(5298,'public','Неверный формат','','2018-04-13 17:27:01',0);
INSERT INTO sourcemessage VALUES(5299,'public','Идентификатор:','','2018-04-13 17:27:58',0);
INSERT INTO sourcemessage VALUES(5300,'public','не установлен','','2018-04-13 17:32:15',0);
INSERT INTO sourcemessage VALUES(5301,'public','установлен','','2018-04-13 17:32:34',0);
INSERT INTO sourcemessage VALUES(5302,'public','Неверный формат файла (К загрузке разрешены файлы форматов: .jpg .jpeg .pjpeg .png)','','2018-04-13 17:47:56',0);
INSERT INTO sourcemessage VALUES(5303,'public','Превышен максимально допустимый номер карты','','2018-04-13 17:49:27',0);
INSERT INTO sourcemessage VALUES(5304,'public','Удален в архив','','2018-04-13 17:49:45',0);
INSERT INTO sourcemessage VALUES(5305,'public','Ошибка: документ с таким буквенным и символьным кодами уже существует','','2018-04-13 17:52:11',0);
INSERT INTO sourcemessage VALUES(5306,'public','Ошибка: документ с таким символьным кодом уже существует','','2018-04-13 17:52:24',0);
INSERT INTO sourcemessage VALUES(5307,'public','Разблокирован','','2018-04-13 17:53:41',0);
INSERT INTO sourcemessage VALUES(5308,'public','не действительна','','2018-04-13 17:54:59',0);
INSERT INTO sourcemessage VALUES(5309,'public','Невозможно создать точку верификации. Количество точек в данном шаблоне максимально','','2018-04-13 17:58:56',0);
INSERT INTO sourcemessage VALUES(5311,'public','Взломан','','2018-04-13 18:00:46',0);
INSERT INTO sourcemessage VALUES(5312,'public','Невозможно добавить комиссионирующую карту. Количество комиссионирующих карт для данного контроллера максимально','','2018-04-13 18:02:13',0);
INSERT INTO sourcemessage VALUES(5313,'public','Шаблон пропуска:','','2018-04-13 18:05:29',0);
INSERT INTO sourcemessage VALUES(5314,'public','Рамка (граница пропуска):','','2018-04-13 18:06:23',0);
INSERT INTO sourcemessage VALUES(5315,'public','Для помещений','','2018-04-13 18:07:24',0);
INSERT INTO sourcemessage VALUES(5316,'public','Тип доступа','','2018-04-13 18:08:09',0);
INSERT INTO sourcemessage VALUES(5317,'public','Действующие посетители','','2018-04-13 18:09:19',0);
INSERT INTO sourcemessage VALUES(5318,'public','Ваш браузер не поддерживается. Смотрите','','2018-04-13 18:14:27',0);
INSERT INTO sourcemessage VALUES(5319,'public','требования к программным средствам','','2018-04-13 18:14:38',0);
INSERT INTO sourcemessage VALUES(5320,'public','Дождитесь окончания предыдущего расчета.','','2018-04-13 18:15:34',0);
INSERT INTO sourcemessage VALUES(5321,'public','№ карты','','2018-04-13 18:23:05',0);
INSERT INTO sourcemessage VALUES(5322,'public','Документ добавлен в указанный временной диапазон','','2018-04-18 10:48:03',0);
INSERT INTO sourcemessage VALUES(5323,'public','Документ сохранен в указанном временном диапазоне','','2018-04-18 10:48:12',0);
INSERT INTO sourcemessage VALUES(5324,'public','Максимальная длина','','2018-04-18 11:05:06',0);
INSERT INTO sourcemessage VALUES(5325,'public','Карта переполнена (достигнуто максимальное количество отпечатков)','','2018-04-18 14:23:32',0);
INSERT INTO sourcemessage VALUES(5326,'public','На карте нет приложения с отпечатком','','2018-04-18 14:23:55',0);
INSERT INTO sourcemessage VALUES(5327,'public','Команда поддерживается только с Mifare каналом','','2018-04-18 14:24:13',0);
INSERT INTO sourcemessage VALUES(5328,'public','Неверный номер отпечатка (на карте меньше отпечатков)','','2018-04-18 14:24:34',0);
INSERT INTO sourcemessage VALUES(5329,'public','Не удалось зарезервировать  необходимое количество блоков для отпечатка (необходимо уменьшить номер сектора)','','2018-04-18 14:24:50',0);
INSERT INTO sourcemessage VALUES(5330,'public','Ошибка длины команды (ожидается меньше байт, чем передается)','','2018-04-18 14:25:07',0);
INSERT INTO sourcemessage VALUES(5331,'public','Новый тип ключа и старый тип ключа приложения должны быть идентичны, при команде изменения ключей (ошибка только для карт DESFire)','','2018-04-18 14:25:28',0);
INSERT INTO sourcemessage VALUES(5332,'public','Устройство не сконфигурировано для работы с отпечатком (использовалось команда с конфигурацией без отпечатка)','','2018-04-18 14:25:41',0);
INSERT INTO sourcemessage VALUES(5333,'public','Запись не производится при старом ключе карты','','2018-04-18 14:26:05',0);
INSERT INTO sourcemessage VALUES(5334,'public','Перед записью отпечатка необходимо записать ID','','2018-04-18 14:26:45',0);
INSERT INTO sourcemessage VALUES(5335,'public','Не удалось аутентифицироваться старым комплектом (тип и/или ключ не подошли)','','2018-04-18 14:27:04',0);
INSERT INTO sourcemessage VALUES(5336,'public','SL2 больше не поддерживается, рекомендуется перейти на SL3','','2018-04-25 14:22:27',0);
INSERT INTO sourcemessage VALUES(5337,'public',' баланса',NULL,'2018-04-26 16:29:39',0);
INSERT INTO sourcemessage VALUES(5338,'public','Нет ни одной точки','','2018-04-28 15:44:06',0);
INSERT INTO sourcemessage VALUES(5339,'public','Нет точек верификации','','2018-04-28 15:44:44',0);
INSERT INTO sourcemessage VALUES(5340,'public','Проход с подтверждением от ПДУ/верификации: с несоответствием временным критериям доступа и текущему местоположению','','2018-05-14 16:20:51',0);
INSERT INTO sourcemessage VALUES(5341,'public','Проход с подтверждением от ПДУ/верификации: с несоответствием текущему местоположению','','2018-05-14 16:24:42',0);
INSERT INTO sourcemessage VALUES(5342,'public','Событие прохода','','2018-05-15 11:54:26',0);
INSERT INTO sourcemessage VALUES(5343,'public','Участвует в расчете','','2018-05-15 11:54:41',0);
INSERT INTO sourcemessage VALUES(5344,'public','Не участвует в расчете','','2018-05-15 11:55:21',0);
INSERT INTO sourcemessage VALUES(5345,'public','Пароль изменен','','2018-05-15 12:41:11',0);
INSERT INTO sourcemessage VALUES(5346,'public','Добавил полномочие на','','2018-05-15 12:41:22',0);
INSERT INTO sourcemessage VALUES(5347,'public','Для оператора:','','2018-05-15 12:42:10',0);
INSERT INTO sourcemessage VALUES(5348,'public','Тип id','','2018-05-15 12:42:23',0);
INSERT INTO sourcemessage VALUES(5349,'public','Для роли','','2018-05-15 12:42:35',0);
INSERT INTO sourcemessage VALUES(5350,'public','Описание зоны','','2018-05-15 12:43:11',0);
INSERT INTO sourcemessage VALUES(5351,'public','Удален интервал','','2018-05-15 12:43:46',0);
INSERT INTO sourcemessage VALUES(5352,'public','Ночное время по','','2018-05-15 12:44:07',0);
INSERT INTO sourcemessage VALUES(5353,'public','ID события','','2018-05-15 12:45:11',0);
INSERT INTO sourcemessage VALUES(5354,'public','Установил доступ на','','2018-05-15 15:19:12',0);
INSERT INTO sourcemessage VALUES(5355,'public','Идентификатор просрочен','','2018-05-15 17:17:39',0);
INSERT INTO sourcemessage VALUES(5356,'public','Автоматический пересчет рабочего времени','','2018-05-15 17:37:44',0);
INSERT INTO sourcemessage VALUES(5357,'public','Изменение конфигурации устройства','','2018-05-25 15:24:55',0);
INSERT INTO sourcemessage VALUES(5373,'public','Тест','','2018-07-04 12:08:25',0);
INSERT INTO sourcemessage VALUES(5375,'public','Свернуть меню','','2018-07-05 13:27:51',0);
INSERT INTO sourcemessage VALUES(5376,'public','Нет прав доступа для данного раздела','','2018-07-06 13:25:32',0);
INSERT INTO sourcemessage VALUES(5378,'public','Комментарий','','2018-07-11 14:55:13',0);
INSERT INTO sourcemessage VALUES(5379,'public','Дополнительные функции','','2018-08-16 14:23:17',0);
INSERT INTO sourcemessage VALUES(5380,'public','Палец #{{num}}','','2018-08-16 14:29:02',0);
INSERT INTO sourcemessage VALUES(5381,'public','Фамилия Имя Отчество','','2018-08-29 12:29:21',0);
INSERT INTO sourcemessage VALUES(5382,'public','Выбрать все','','2018-08-29 12:29:32',0);
INSERT INTO sourcemessage VALUES(5383,'public','Экспорт','','2018-08-29 12:33:56',0);
INSERT INTO sourcemessage VALUES(5384,'public','Интервал','','2018-08-29 12:38:52',0);
INSERT INTO sourcemessage VALUES(5385,'public','Такое помещение не существует','','2018-11-20 14:50:38',0);
INSERT INTO sourcemessage VALUES(5386,'public','Период','Период времени','2018-11-20 17:20:36',0);
INSERT INTO sourcemessage VALUES(5387,'public','Рус',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5388,'public',' Отсутствует лицензионный контроллер. Осталось',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5389,'public',replace('В это помещение добавление устройств запрещено\r','\r',char(13)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5390,'public',replace('супер-карта\r','\r',char(13)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5391,'public',replace('неизвестный тип карты\r','\r',char(13)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5392,'public',replace('неизвестно (не подошли ключи: ключ по умолчанию, текущий ключ карты, старый ключ карты, мастер ключ, ключ супер-карты)\r','\r',char(13)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5393,'public',replace('ключ карты отличается от ключа в конфигурации\r','\r',char(13)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5394,'public','Запрет прохода от ВВУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5395,'public','Проход с подтверждением от ВВУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5396,'public','с',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5397,'public','секунд',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5398,'public','Проход с подтверждением от ВВУ: с несоответствием текущему местоположению',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5399,'public','Проход с подтверждением от ВВУ: с несоответствием временным критериям доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5400,'public','Проход с подтверждением от ВВУ: с несоответствием временным критериям доступа и текущему местоположению',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5401,'public','Проход с подтверждением от ВВУ и далее ПДУ/верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5402,'public','Проход с подтверждением от ВВУ и далее ПДУ/верификации: с несоответствием текущему местоположению',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5403,'public','Проход с подтверждением от ВВУ и далее ПДУ/верификации: с несоответствием временным критериям доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5404,'public','Проход с подтверждением от ВВУ и далее ПДУ/верификации: с несоответствием временным критериям доступа и текущему местоположению',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5405,'public','Отпечаток не распознан',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5406,'public','Поставить зону на охрану: Не выполнено',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5407,'public','Снять зону с охраны: Не выполнено',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5408,'public','Снять тревогу с зоны: Не выполнено',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5409,'public','Очистить пространственные зоны для идентификаторов: Не выполнено',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5410,'public','Проход с подтверждением от ДУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5411,'public','Запрет прохода по команде от ДУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5412,'public','Запрет прохода: несоответствие режиму доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5413,'public','РУС',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5414,'public','Получение подробных сведений о пользователе',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5415,'public','Секретный ключ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5416,'public','Идентификатор пользователя в системе',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5417,'public','Запрос обработан успешно',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5418,'public','Получение полноразмерного изображения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5419,'public','ID изображения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5420,'public','Получение таблицы сотрудников',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5421,'public','Фильтр действующие/заказанные/активные',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5422,'public','Фильтр по одному или нескольким подразделениям',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5423,'public','Количество строк',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5424,'public','Номер страницы (пагинатор)',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5425,'public','Имя столбца для сортировки',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5426,'public','Порядок сортировки (ASC или DESC)',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5427,'public','Строка поиска',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5428,'public','Отображаемые колонки',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5429,'public','Расширенный фильтр',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5430,'public','Получение печатной версии таблицы сотрудников',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5431,'public','Получение таблицы посетителей',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5432,'public','Получение печатной версии таблицы посетителей',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5433,'public','Получение списка сотрудников',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5434,'public','Получение списка посетителей',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5435,'public','Получение расширенного списка сотрудников',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5436,'public','Получение списка сотрудников с доступом в помещение',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5437,'public','ID помещения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5438,'public','Сохранение нового сотрудника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5439,'public','Данные пользователя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5440,'public','Массив ID редактируемых сотрудников',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5441,'public','Данные сотрудников',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5442,'public','Сохранение нового посетителя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5443,'public','Множественное редактирование посетителей',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5444,'public','Массив ID редактируемых посетителей',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5445,'public','Данные посетителей',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5446,'public','Получение подробных сведений о сотруднике',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5447,'public','Идентификатор сотрудника в системе',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5448,'public','Данные сотрудника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5449,'public','Получение подробных сведений о посетителе',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5450,'public','Идентификатор посетителя в системе',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5451,'public','Данные посетителя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5452,'public','Изъятие идентификатора посетителя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5453,'public','ID посетителя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5454,'public','изымать только в последний день действия идентификатора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5455,'public','Поиск карты',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5456,'public','Признак сотрудник или посетитель',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5457,'public','Получение таблицы дополнительных данных',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5458,'public','Сотрудники / Посетители',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5459,'public','Добавление нового поля дополнительных данных',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5460,'public','Данные нового дополнительного поля',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5461,'public','Получение списка дополнительных данных',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5462,'public','Получение подробных сведений о дополнительном поле',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5463,'public','ID дополнительного поля',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5464,'public','Редактирование дополнительного поля',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5465,'public','Данные дополнительного поля для редактирования',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5466,'public','Удаление дополнительного поля',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5467,'public','Получение таблицы с оправдательными документами у пользователя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5468,'public','фильтр по дате',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5469,'public','Добавление нового документа для пользователя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5470,'public','Добавление нового объяснительного документа для пользователя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5471,'public','Имя объяснительного документа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5472,'public','Получение таблицы планировщика для пользователя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5473,'public','Добавление новой записи планировщика',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5474,'public','Получение данных о не переданных идентификаторов в устройство',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5475,'public','Добавление или замена основной карты для пользователя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5476,'public','ID пользователя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5477,'public','Данные сотрудника или нескольких сотрудников',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5478,'public','Удаление основной карты для пользователя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5479,'public','Получение подробных сведений о конкретном событии планировщика',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5480,'public','ID события планировщика',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5481,'public','Редактирование события планировщика',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5482,'public','Данные события планировщика',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5483,'public','Удаление события планировщика',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5484,'public','Получение подробных сведений о конкретном документе',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5485,'public','ID документа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5486,'public','Редактирование оправдательного документа для пользователя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5487,'public','ID документа для редактирования',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5488,'public','Удаление оправдательного документа у пользователя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5489,'public','Получение количества отпечатков',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5490,'public','Идентификатор пользователя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5491,'public','Получение списка отпечатков',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5492,'public','Добавить отпечаток',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5493,'public','Шаблоны и изображения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5494,'public','Номер отпечатка',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5495,'public','Тип отпечатка 1-Suprema, 2-Morpho',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5496,'public','Имя отпечатка',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5497,'public','Удалить отпечаток',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5498,'public','Получение таблицы операторов системы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5499,'public','Объект, содержащий список операторов',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5500,'public','Получение списка операторов системы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5501,'public','Фильтр значений',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5502,'public','Создание нового оператора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5503,'public','Данные нового оператора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5504,'public','Получение данных одного оператора по ID',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5505,'public','ID оператора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5506,'public','Обновить данные одного оператора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5507,'public','Данные оператора для перезаписи',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5508,'public','Удаление одного или нескольких операторов',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5509,'public','ID или массив ID операторов для удаления',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5510,'public','ID или массив ID операторов для действия над ними',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5511,'public','Разблокировка оператора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5512,'public','Получение текущих прав оператора на использование API методов',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5513,'public','Получение списка ролей',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5514,'public','Получение таблицы ролей',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5515,'public','Данные роли для сoхранения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5516,'public','Получение данных одной роли по ID',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5517,'public','ID роли',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5518,'public','Обновить данные одной роли',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5519,'public','Данные роли для перезаписи',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5520,'public','ID роли для удаления',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5521,'public','Создание нового подразделения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5522,'public','Создание нового подраздения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5523,'public','Данные нового подразделения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5524,'public','Получение дерева подразделений',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5525,'public','Показать подразделения, которые были удалены',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5526,'public','Проверка прав на подразделения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5527,'public','Получение списка подразделений',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5528,'public','Получение печатной версии дерева подразделений',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5529,'public','Получение печатной версии списка подразделений',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5530,'public','Получение подробных данных по подразделению',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5531,'public','ID подразделения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5532,'public','редактирование подразделения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5533,'public','Данные подразделения для изменения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5534,'public','Получение списка должностей',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5535,'public','Показать должности, которые были удалены',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5536,'public','Получение таблицы должностей',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5537,'public','Получение печатной версии таблицы подразделений',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5538,'public','Создание новой должности',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5539,'public','Данные новой должности',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5540,'public','Получение данных по должности',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5541,'public','ID должности',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5542,'public','редактирование должности',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5543,'public','Данные должности для изменения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5544,'public','Получение списка шаблонов дизайна пропуска',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5545,'public','Тип пользователя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5546,'public','Таблица дизайна шаблонов пропуска',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5547,'public','Таблица дизайна шаблона пропусков',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5548,'public','Количество строк таблицы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5549,'public','Получение данных пользователя для шаблона',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5550,'public','ID шаблона',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5551,'public','Получение шаблона дизайна пропуска',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5552,'public','ID шаблона дизайна',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5553,'public','Редактирование шаблона дизайна пропусков',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5554,'public','Данные шаблона',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5555,'public','Удаление шаблона дизайна пропусков',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5556,'public','Добавление шаблона дизайна пропуска',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5557,'public','Добавление шаблона дизайна прорпуска',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5558,'public','Получение списка доступных устройств',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5559,'public','С правами операторов',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5560,'public','С общими параметрами контроллеров',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5561,'public','Формат данных - дерево или список',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5562,'public','Объект, содержащий список доступных устройств',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5563,'public','Добавление нового устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5564,'public','Данные нового контроллера для добавления',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5565,'public','ID добавленного устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5566,'public','Получение общих данных о устройстве',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5567,'public','ID контроллера',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5568,'public','Редактирование устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5569,'public','Данные контроллера',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5570,'public','Получение значений ресурса контроллера',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5571,'public','Номер дочернего устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5572,'public','Тип ресурса',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5573,'public','Некий объект',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5574,'public','Изменение значений ресурса контроллера',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5575,'public','Данные для сохранения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5576,'public','Получение списка считывателей контроллера',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5577,'public','Считыватели для верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5578,'public','Считыватели для отпечатков',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5579,'public','Активирование контроллера',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5580,'public','Деактивирование контроллера',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5581,'public','Добавить контроллер в помещение',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5582,'public','Помещение, куда будет привязан контроллер',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5583,'public','Отвязать контроллер от помещения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5584,'public','метод для сборки схемы контроллера по ресурсам',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5585,'public','Отправка команды на устройство',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5586,'public','ID устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5587,'public','Данные команды',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5588,'public','Метод получения всех доступных команд для устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5589,'public','Получение данных о не переданных ресурсов в устройство',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5590,'public','Идентификатор устройства в системе',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5591,'public','IP-адрес для поиска конкретного устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5592,'public','Получение данных о всех устройствах или о конкретном',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5593,'public','ID для конкретного устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5594,'public','Передача параметров в контроллер / контроллеры',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5595,'public','Все параметры или только изменения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5596,'public','Уведомление об изменениях в системе',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5597,'public','Тип изменения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5598,'public','Таблица шаблонов камер',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5599,'public','Список шаблонов камер',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5600,'public','Список добавленных производителей камер',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5601,'public','Данные шаблона камеры',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5602,'public','Получение данных о шаблоне камеры',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5603,'public','ID шаблона камеры',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5604,'public','Добавление шлюза или составного объекта',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5605,'public','Тип шлюза или составного объекта',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5606,'public','Получение дерева помещений',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5607,'public','Объект, содержащий список доступных помещений',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5608,'public','Получение списка помещений',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5609,'public','Данные помещения для добавления',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5610,'public','Данные помещения для перезаписи',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5611,'public','Метод получения всех доступных команд для контроллеров в помещении',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5612,'public','Получение списка доступных групп комиссионирования в помещении',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5613,'public','Получение списка помещений с привязанными к ним контроллерами',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5614,'public','С правами оператора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5615,'public','Фильтр по типам устройств',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5616,'public','Объект, содержащий список помещений с контроллерами',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5617,'public','Получение списка доступных помещений c типами контроллеров',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5618,'public','Получение таблицы событий системы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5619,'public','Начало интервала даты / времени',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5620,'public','Окончание интервала даты / времени',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5621,'public','Удаление событий по критериям',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5622,'public','Тип удаления',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5623,'public','Получение типов событий системы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5624,'public','Категория событий',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5625,'public','Получение списка реакций на события',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5626,'public','Таблица реакций на события',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5627,'public','Получение списка реакций на события с данными',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5628,'public','Получение данных о реакции',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5629,'public','ID реакции',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5630,'public','Редактирование реакции',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5631,'public','Условия реакции',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5632,'public','Удаление реакции',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5633,'public','Добавление реакции',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5634,'public','Получение списка подписчиков мессенджера',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5635,'public','Тип мессенджера',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5636,'public','Получение списка шаблонов доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5637,'public','Показать шаблоны доступа, которые были удалены',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5638,'public','Таблица шаблонов доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5639,'public','Строка для поиска',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5640,'public','Показать шаблоны, которые были удалены',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5641,'public','Создание шаблона доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5642,'public','Данные нового шаблона доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5643,'public','Получение шаблона доступа по ID',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5644,'public','ID шаблона доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5645,'public','Данные шаблона доступа для изменения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5646,'public','Получение списка временных критериев доступа в зависимости от типа шаблона',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5647,'public','Таблица временных критериев доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5648,'public','Тип временного критериев доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5649,'public','Список временных критериев доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5650,'public','Тип временного критерия доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5651,'public','Создание временной зоны',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5652,'public','Данные новой временной зоны',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5653,'public','id временной зоны',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5654,'public','Данные временной зоны для редактирования',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5655,'public','Создание недельного расписания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5656,'public','Данные нового недельного расписания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5657,'public','Редактирование недельного расписания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5658,'public','id недельного расписания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5659,'public','Данные недельного расписания для редактирования',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5660,'public','Создание скользящего посуточного расписания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5661,'public','Данные нового скользящего посуточного расписания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5662,'public','Редактирование скользящего посуточного расписания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5663,'public','id скользящего посуточного расписания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5664,'public','Данные скользящего посуточного расписания для редактирования',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5665,'public','Создание скользящего понедельного расписания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5666,'public','Данные нового скользящего понедельного расписания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5667,'public','Редактирование скользящего понедельного расписания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5668,'public','id скользящего понедельного расписания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5669,'public','Редактирование праздничного расписания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5670,'public','id праздничного расписания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5671,'public','Данные праздничного расписания для редактирования',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5672,'public','Создание временного критерия доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5673,'public','Данные нового временного критерия доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5674,'public','Получение временного критерия доступа по ID',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5675,'public','id временного критерия доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5676,'public','Редактирование временного критерия доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5677,'public','Удаление временного критерия доступа по ID',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5678,'public','Получение списка типов прав доступа в зависимости от типа шаблона',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5679,'public','Получение списка типов комиссионирования в зависимости от помещения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5680,'public','Номер помещения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5681,'public','Редактирование настроек комиссионирования для помещения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5682,'public','id помещения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5683,'public','Данные комиссионирования',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5684,'public','Отчет о местонахождении',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5685,'public','Группа пользователей',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5686,'public','Дата и время, на момент которых проверяется местонахождение',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5687,'public','Список подразделений',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5688,'public','Объект, содержащий данные о местонахождении',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5689,'public','Отчет о местонахождении для печати',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5690,'public','Журнал доступа в помещение',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5691,'public','Список помещений',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5692,'public','Объект, содержащий данные доступа в помещение',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5693,'public','Журнал доступа в помещение для печати',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5694,'public','Дата начала периода',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5695,'public','Дата окончания периода',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5696,'public','Объект, содержащий отчет о проходах',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5697,'public','Отчет о проходах для печати',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5698,'public','Отчет о посетителях',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5699,'public','Отчет о посетителях для печати',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5700,'public','Получение списка схем помещений',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5701,'public','Получение плана',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5702,'public','ID плана',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5703,'public','Редактирование плана',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5704,'public','Параметры плана',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5705,'public','Получение помещений с контроллерами',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5706,'public','Получение списка шаблонов верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5707,'public','Получение таблицы шаблонов верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5708,'public','Секретный ключ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5709,'public','Получение шаблона верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5710,'public','Идентификатор шаблона верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5711,'public','Параметры шаблона верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5712,'public','Получение точки верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5713,'public','Идентификатор точки верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5714,'public','Создание точки верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5715,'public','Получение точки верификации по ID',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5716,'public','id точки верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5717,'public','Удаление точки верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5718,'public','удаление точки верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5719,'public','Сортировка точек верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5720,'public','параметры переноса отображения точки верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5721,'public','метод для сборки схемы верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5722,'public','ID точки верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5723,'public','Получение списка точек верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5724,'public','Получение таблицы точек верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5725,'public','ID шаблона верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5726,'public','Получение событий верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5727,'public','Фильтр по точкам верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5728,'public','Фильтр по событиям',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5729,'public','Фильтр по ответам',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5730,'public','Фильтр по операторам',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5731,'public','Добавить событие верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5732,'public','Идентификатор оператора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5733,'public','Идентификатор сотрудника или посетителя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5734,'public','Идентификатор устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5735,'public','Наличие видеозаписи',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5736,'public','Изменить событие верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5737,'public','Идентификатор записи',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5738,'public','Идентификатор результата верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5739,'public','Получить идентификатор последнего события точки верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5740,'public','Выбор точек верификации для фильтрации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5741,'public','Дата начала событий',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5742,'public','Дата конца событий',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5743,'public','Получение списка графиков работы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5744,'public','Показать графики, которые были удалены',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5745,'public','Таблица графиков работы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5746,'public','Добавление нового графика работы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5747,'public','данные графика работы для сохранения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5748,'public','Получение всех данных по графику работы по ID',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5749,'public','ID графика работы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5750,'public','Данные графика для изменения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5751,'public','Получение ночного времени',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5752,'public','Редактирование ночного времени',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5753,'public','Данные ночного времени для изменения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5754,'public','Получение всех отмеченных дней',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5755,'public','Добавление нового праздника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5756,'public','данные праздника для сохранения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5757,'public','Заполнение календаря предопределенными значениями',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5758,'public','Очищение календаря',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5759,'public','Получение всех данных по празднику по его дате',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5760,'public','Дата праздника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5761,'public','Редактирование праздника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5762,'public','Удаление праздника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5763,'public','Получение таблицы предустановленных праздников',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5764,'public','Столбец для сортировки',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5765,'public','Направление сортировки',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5766,'public','Добавление нового предустановленного праздника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5767,'public','Данные нового предустановленного праздника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5768,'public','Удаление предустановленного праздника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5769,'public','ID предустановленного праздника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5770,'public','Получение списка оправдательных документов',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5771,'public','Оправдательные/Сверхурочные/Объяснительные',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5772,'public','Получение таблицы оправдательных документов',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5773,'public','Получение документа по ID',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5774,'public','Тип документа Оправдательный/сверхурочный/Объяснительный',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5775,'public','Данные документа для изменения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5776,'public','Удаление документа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5777,'public','Тип документа Оправдательный/сверхурочный',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5778,'public','Данные нового документа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5779,'public','Получение списка типов оправдательных документов',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5780,'public','Получение списка методов расчета оправдательных документов',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5781,'public','Журнал учета рабочего времени',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5782,'public','Объект, содержащий данные журнала',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5783,'public','Журнал учета рабочего времени для 1C',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5784,'public','Журнал учета рабочего времени для печати',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5785,'public','Баланс пользователя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5786,'public','ID сотрудника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5787,'public','Период, за который запрашиваются данные',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5788,'public','Объект, содержащий баланс пользователя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5789,'public','1С: получение УРВ пользователя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5790,'public','Массив, содержащий данные УРВ пользователя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5791,'public','Отчет о дисциплине труда',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5792,'public','Отчет о дисциплине',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5793,'public','Тип периода',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5794,'public','Объект, содержащий отчет о нарушениях',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5795,'public','Отчет о дисциплине труда для печати',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5796,'public','Отчет о дисциплине для печати',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5797,'public','Присутствующие на данный момент для печати',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5798,'public','Отсутствующие на данный момент',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5799,'public','Объект, содержащий отчет об отсутствующих',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5800,'public','Отсутствующие на данный момент для печати',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5801,'public','Опоздавшие сегодня для печати',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5802,'public','Ушедшие раньше сегодня для печати',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5803,'public','Отчет о переработке',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5804,'public','Отчет о переработке для печати',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5805,'public','Формирование табеля в HTML',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5806,'public','Отчетный месяц',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5807,'public','0 - весь месяц, 1 - первая половина, 2 - вторая',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5808,'public','HTML, содержащий таблицу Excel',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5809,'public','Объект, содержащий таблицу Excel',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5810,'public','События проходов, Список',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5811,'public','Объект, содержащий данные о проходах',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5812,'public','События проходов, Таблица',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5813,'public','Дата событий',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5814,'public','Только учитываемые при расчетах',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5815,'public','Учет/неучет события прохода',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5816,'public','Пустой объект',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5817,'public','Прогресс расчета',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5818,'public','Запуск перерасчета рабочего времени',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5819,'public','Время с которого считать',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5820,'public','Время по которое считать',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5821,'public','Требуемое действие - пересчет по подразделениям или по сотруднику',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5822,'public','Массив id подразделений или массив с единственным элементом - id сотрудника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5823,'public','Получение таблицы заданий',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5824,'public','Создание нового задания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5825,'public','Данные нового задания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5826,'public','Получение данных конкретного задания по ID',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5827,'public','ID задания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5828,'public','редактирование задания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5829,'public','Данные задания для изменения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5830,'public','обновление состояния задания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5831,'public','Данные о выполнении задания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5832,'public','Получение списка доступных заданий',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5833,'public','Список лицензий',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5834,'public','Объект, содержащий список лицензий',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5835,'public','Список лицензионных контроллеров',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5836,'public','Установка нового лицензионного ключа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5837,'public','Ключ и номер модуля',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5838,'public','Установка статуса проверки лицензии',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5839,'public','Номер модуля и статус лицензии',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5840,'public','Текущий лицензионный контроллер',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5841,'public','Объект, содержащий информация о лицензионном контроллере',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5842,'public','Изменение лицензионного контроллера',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5843,'public','id контроллера',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5844,'public','объект, с id контроллера',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5845,'public','Активирование лицензии',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5846,'public','номер модуля',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5847,'public','Деактивирование лицензии',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5848,'public','Получение данных о состоянии сервера системы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5849,'public','Получение списка устройств',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5850,'public','Активация/деактивация устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5851,'public','Активировать илм деактивировать',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5852,'public','Изменение типа устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5853,'public','Название устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5854,'public','Добавить дочернее устройство',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5855,'public','IP-адрес устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5856,'public','Удалить дочернее устройство',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5857,'public','Получение списка устройств второго уровня',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5858,'public','Идентификатор контроллера',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5859,'public','Получение списка устройств для зоны доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5860,'public','Идентификатор зоны',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5861,'public','Получение информации о камере',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5862,'public','Установка признака изменений в доступе пользователя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5863,'public','Сброс признака изменений в доступе пользователя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5864,'public','Массив идентификаторов пользователей',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5865,'public','Получение списка карт',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5866,'public','Полный список или только изменения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5867,'public','Также выбрать и другие дочерние устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5868,'public','Получение списка комиссионирующих карт',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5869,'public','Получение списка удаленных сотрудников',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5870,'public','Получение списка устройств для обновления данных пользователей',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5871,'public','Полный список или только в которые нужно передать изменения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5872,'public','Получение списка ресурсов, которые изменились',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5873,'public','Сброс атрибута, что ресурс был изменен',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5874,'public','Номер ресурса',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5875,'public','Сброс пользовательских данных ресурса',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5876,'public','Получение данных ресурса устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5877,'public','Добавление ресурса устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5878,'public','Подтип ресурса',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5879,'public','Дополнительные настройки (JSON-строка)',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5880,'public','Параметры schema_data по-умолчанию (JSON-строка)',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5881,'public','Изменение ресурса устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5882,'public','Удаление ресурса устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5883,'public','Получение параметра устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5884,'public','Параметр(ы)',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5885,'public','Изменение параметра устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5886,'public','Параметр',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5887,'public','Получение информации об устройстве',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5888,'public','Тип информации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5889,'public','Получение информации о типе устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5890,'public','Получение информации о системе',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5891,'public','Получение информации о пользователе',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5892,'public','Получение списка лицензий',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5893,'public','Номер модуля',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5894,'public','Измененение статуса лицензии',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5895,'public','Номер команды',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5896,'public','Опции команды',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5897,'public','Состояние лицензии',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5898,'public','Данные лицензии',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5899,'public','Количество подключений',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5900,'public','Результат',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5901,'public','Ключ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5902,'public','Добавить массив событий от устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5903,'public','Массив событий',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5904,'public','Изменение события системы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5905,'public','Идентификатор события',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5906,'public','Информация о событии',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5907,'public','Получение иерархического списка доступных разделов системы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5908,'public','Получение JSON-схемы по ID',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5909,'public','ID схемы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5910,'public','Редактирование JSON-схемы по ID',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5911,'public','Данные схемы для редактирования',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5912,'public','Получение JSON-схемы по title',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5913,'public','Title схемы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5914,'public','Получение списка JSON-схем',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5915,'public','Добавление новой JSON-схемы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5916,'public','Данные новой JSON-схемы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5917,'public','Получение объекта переводов на доступные языки',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5918,'public','Код языка',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5919,'public','Добавление перевода',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5920,'public','ID исходной фразы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5921,'public','Редактирование перевода',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5922,'public','Удаление перевода',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5923,'public','Список исходных фраз для перевода',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5924,'public','Список языков',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5925,'public','Статус переводов для отображения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5926,'public','Добавление фразы для перевода',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5927,'public','Информация о фразе для перевода',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5928,'public','ID фразы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5929,'public','Режим отображения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5930,'public','Редактирование фразы для перевода',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5931,'public','Удаление фразы для перевода',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5932,'public','Получение доступных языков системы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5933,'public','Получение доступных регионов системы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5934,'public','Смена языка оператора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5935,'public','Данные языка для перезаписи',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5936,'public','Авторизация',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5937,'public','Логин оператора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5938,'public','Установка логина и пароля администратора при первом входе в систему',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5939,'public','логин и пароль администратора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5940,'public','Удаление сессии оператора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5941,'public','Создание резервной копии базы данных',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5942,'public','Создает резервную копию базы данных',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5943,'public','Запустить резервное копирование или запросить статус',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5944,'public','Получение номера карты с автоинкрементом',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5945,'public','Получение случайного номера карты',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5946,'public','получение случайного номера карты',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5947,'public','Изменение параметров конфигурации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5948,'public','Параметры конфигурации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5949,'public','Получение настроек',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5950,'public','Название настройки',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5951,'public','Изменение настроек',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5952,'public','Отладочный метод универсальный',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5953,'public','Тестовый параметр',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5954,'public','Получение открытого ключа для служебного оператора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5955,'public','Загрузка пакета обновления',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5956,'public','Файл пакета обновления',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5957,'public','Импорт данных из Excel и CSV',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5958,'public','Импорт данных и формирование заголовков для сопоставления',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5959,'public','Имя выполняемой операции',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5960,'public','Файл импорта',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5961,'public','Пользовательская ассоциация заголовков',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5962,'public','Импорт данных из Excel и SCV',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5963,'public','Импорт пользователей',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5964,'public','Объект для экспорта',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5965,'public','Тип файла экспорта',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5966,'public','Получение статуса операции',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5967,'public','Удаление данных сервиса и остановка',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5968,'public','удаление данных сервиса и остановка',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5969,'public','Получение описания действия оператора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5970,'public','Секретный клюя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5971,'public','Добавление нового устройства мобильного терминала',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5972,'public','Данные нового устройства для добавления',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5973,'public','Редактирование мобильного терминала',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5974,'public','ID терминала',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5975,'public','Данные устройства для редактирования',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5976,'public','Удаление устройства мобильного терминала',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5977,'public','Получение ключа инсталляции',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5978,'public','Идентификатор мобильного терминала',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5979,'public','Получение списка устройств мобильного терминала',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5980,'public','Фильтр по активированным устройствам',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5981,'public','Получение списка пользователей для мобильного терминала',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5982,'public','Получение открытого ключа для авторизации мобильного терминала',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5983,'public','Добавление событий с мобильного терминала',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5984,'public','Данные события',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5985,'public','Добавление графика из 1С',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5986,'public','Данные графика',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5987,'public','Начало интервала не может быть меньше 00:00',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5988,'public','Конец интервала не может быть больше 23:59',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5989,'public','Начало интервала не может быть меньше конца',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5990,'public','Интервал не может быть меньше 30 минут',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5991,'public','Интервалов не может быть меньше одного или больше 4-х',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5992,'public','Интервалы не могут пересекаться',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5993,'public','В недельном критерии должно быть 7 дней',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5994,'public','в сменном суточном критерии доступа должно быть от 1 до 30 дней',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5995,'public','Для скользящего недельного критерия доступа количество недель должно быть от 1 до 52',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5996,'public','Праздник с такой датой уже существует в этом праздничном расписании',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5997,'public','В феврале может быть только 29 дней',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5998,'public','Несуществующий идентификатор праздничного расписания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(5999,'public','График содержит несуществующие временные зоны',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6000,'public','Такой график доступа не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6001,'public','Для сменного графика должна быть указана дата начала',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6002,'public','Служебные графики удалять запрещено',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6003,'public','График доступа используется и не может быть удален',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6004,'public','Такое название уже используется',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6005,'public','В одном недельном графике нельзя использовать одинаковые праздничные расписания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6006,'public','Некорректное значение дня или месяца',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6007,'public','На данный день и месяц уже добавлен праздник',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6008,'public','Такого праздника не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6009,'public','Служебного оператора нельзя заблокировать',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6010,'public','Для системных операторов изменить можно только пароль',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6011,'public','Данная запись в планировщике не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6012,'public','Запись не найдена',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6013,'public','Нет id сотрудника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6014,'public','Сотрудник с таким ID не найден',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6015,'public','дата приема на работу',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6016,'public','Номера карт не должны совпадать!',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6017,'public','При увольнении должна быть заполнена дата увольнения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6018,'public','Дата увольнения не может быть меньше даты приема на работу',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6019,'public','Превышен максимальный номер карты!',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6020,'public','сотрудника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6021,'public','посетителя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6022,'public','У данного пользователя нет карт',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6023,'public','сотрудник',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6024,'public','посетитель',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6025,'public','Для сверхурочного документа длительность не может быть равна 0',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6026,'public','Такой сотрудник не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6027,'public','Такой документ не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6028,'public','Дата начала не может быть больше даты окончания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6029,'public','Документ не найден',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6030,'public','Такого документа не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6031,'public','Дата начала не может быть больше даты конца',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6032,'public','Карта не найдена',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6033,'public','Превышен максимально допустимый размер изображения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6034,'public','Расширенные фильтры должны быть в формате JSON',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6035,'public','Некорректный статус для сотрудника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6036,'public','Некорректный статус для посетителя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6037,'public','сотрудники',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6038,'public','посетители',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6039,'public','заблокированы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6040,'public','разблокированы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6041,'public','Неверное условие в расширенном фильтре',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6042,'public','Нет доступа к выбранной должности или она не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6043,'public','Нет доступа к выбранному подразделению или оно не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6044,'public','Нет доступа к выбранному графику работы или он не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6045,'public','Нет доступа к выбранному шаблону доступа или он не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6046,'public','Посетитель с таким ID не найден',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6047,'public','Дата окончания не может быть меньше текущей даты',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6048,'public','Операция импорта/экспорта уже выполняется другим оператором. Пожалуйста, попробуйте повторить через 5 минут',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6049,'public','Направление',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6050,'public','Всего отпечатков',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6051,'public','Использовано отпечатков',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6052,'public','Свободно отпечатков',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6053,'public','Общие настройки',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6054,'public','Глобальный антипасс',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6055,'public','Контроллеры PERCo',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6056,'public','Уровень мастер-карты',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6057,'public','Выбрать типы карт',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6058,'public','Смартфон (SIM-карта)',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6059,'public',replace(replace('ВНИМАНИЕ! В случае изменения данных параметров необходимо записать мастер-карту с новыми параметрами, \r\n после чего переконфигурировать этой картой все считыватели и изменить ключи на всех картах доcтупа этого типа','\r',char(13)),'\n',char(10)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6060,'public','Общие настройки карт Classic',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6061,'public','Общие настройки карт Plus',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6062,'public','Количество повторов',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6063,'public','Цвета',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6064,'public','Первый цвет',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6065,'public','Длительность (мс)',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6066,'public','Задержка (мс)',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6067,'public','Второй цвет',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6068,'public','Третий цвет',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6069,'public','Тональности',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6070,'public','Первый тон',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6071,'public','Затухание',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6072,'public','Второй тон',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6073,'public','Третий тон',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6074,'public','0x3C Ошибка управления выходом оповещения - КЗ выхода',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6075,'public','Перемычка IP_MODE',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6076,'public','Перемычка IP_DEFAULT',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6077,'public','Перемычка XP 3.1',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6078,'public','Перемычка XP 3.2',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6079,'public','Перемычка XP 3.3',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6080,'public','Свойства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6081,'public','Контроль времени для  идентификаторов СОТРУДНИКОВ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6082,'public','Для регистрации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6083,'public','считыватель',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6084,'public','Дополнительный вход',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6085,'public','Генерация тревоги',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6086,'public','Контроль времени для  идентификаторов ПОСЕТИТЕЛЕЙ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6087,'public','Кнопка ПДУ - выход',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6088,'public','Кнопка ПДУ - стоп',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6089,'public','Сигнал прохода',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6090,'public','Вход Fire alarm',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6091,'public','Вход подтверждения ВВУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6092,'public','Вход запрета ВВУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6093,'public','Вход сброса тревоги',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6094,'public','Выход управления ИУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6095,'public','Выход индикации ПДУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6096,'public','ИУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6097,'public','Алгоритм',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6098,'public','АТП',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6099,'public','Шлюз',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6100,'public','Реакция на Fire alarm в режиме работы "Охрана"',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6101,'public','Блокировать МУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6102,'public','Разблокировать МУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6103,'public','Время идентификации постановки/снятия РКД "Охрана"',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6104,'public','В РЕЖИМЕ РАБОТЫ "Открыто"',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6105,'public','Уровни',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6106,'public','Софт, если подключен',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6107,'public','ПДУ выборочно',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6108,'public','ВВУ выборочно',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6109,'public','Счетчик проходов',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6110,'public','Время ожидания подтверждения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6111,'public','Подтверждение прохода',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6112,'public','При проходе СОТРУДНИКОВ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6113,'public','При проходе СОТРУДНИКОВ с НАРУШЕНИЕМ ВРЕМЕНИ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6114,'public','При проходе СОТРУДНИКОВ с НАРУШЕНИЕМ ЗОНАЛЬНОСТИ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6115,'public','При проходе ПОСЕТИТЕЛЕЙ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6116,'public','При проходе ПОСЕТИТЕЛЕЙ с НАРУШЕНИЕМ ВРЕМЕНИ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6117,'public','При проходе ПОСЕТИТЕЛЕЙ с НАРУШЕНИЕМ ЗОНАЛЬНОСТИ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6118,'public','Подтверждение прохода для ПОСЕТИТЕЛЕЙ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6119,'public','В последний день действия идентификатора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6120,'public','Вероятность запуска верификации (0..100%)',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6121,'public','По истечению времени подтверждения генерировать событие',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6122,'public','Отказ от прохода, нет ответа от ВВУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6123,'public','Счётчик',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6124,'public','Изымать идентификаторы ПОСЕТИТЕЛЕЙ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6125,'public','После любого прохода',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6126,'public','После прохода в последний день действия идентификатора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6127,'public','Время идентификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6128,'public','Время ожидания персонализации от сервера',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6129,'public','Время отображения информации на дисплее',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6130,'public','Временная зона входа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6131,'public','Временная зона выхода',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6132,'public','Алгоритм прохода',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6133,'public','Жесткий',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6134,'public','Время нахождения в шлюзе',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6135,'public','Дверь 1 - вход в шлюз',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6136,'public','Режим доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6137,'public','По считывателю',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6138,'public','ПО ДУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6139,'public','По считывателю и ДУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6140,'public','Дверь 1 - выход из шлюза',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6141,'public','Дверь 2 - выход из шлюза',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6142,'public','Дверь 2 - вход в шлюз',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6143,'public','Управление замком',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6144,'public','Вход 0',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6145,'public','Вход 1',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6146,'public','Составной объект',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6147,'public','Контроллер 1',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6148,'public','Контроллер 2',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6149,'public','Положение сенсора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6150,'public','Нормальное',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6151,'public','Развёрнутое на 180 градусов',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6152,'public','Нормальное и развёрнутое',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6153,'public','Вероятность несанкционированного допуска',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6154,'public','меньше 1 %',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6155,'public','меньше 0.5 %',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6156,'public','меньше 0.1 %',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6157,'public','меньше 0.05 %',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6158,'public','меньше 0.01 %',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6159,'public','меньше 0.001 %',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6160,'public','меньше 0.0001 %',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6161,'public','меньше 0.00001 %',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6162,'public','меньше 0.0000001 %',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6163,'public','Отсутствует файл конфигурации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6164,'public','Ошибка подключения к базе данных. Проверьте правильность ввода логина и пароля базы данных в менеджере PERCo-Web',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6165,'public','Ошибка подключения к базе данных. Проверьте правильность указания хоста сервера базы данных в менеджере PERCo-Web',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6166,'public','Что-то пошло не так. Проверьте настройки подключения к базе данных. Код ошибки:',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6167,'public','Создание кластера...',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6168,'public','Запуск сервера...',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6169,'public','Проверка базы данных...',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6170,'public','Попытка подключения к базе данных...',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6171,'public','Не удалось подключиться к базе данных. Код ошибки:',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6172,'public','Проверка файловой системы...',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6173,'public','Создание базы данных...',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6174,'public','Дата приема на работу',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6175,'public','Действителен с',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6176,'public','Работа в ночное время',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6177,'public','Дата истечения срока действия',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6178,'public','Не удалось прочитать данные из файла',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6179,'public','Не удалось извлечь заголовки файла',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6180,'public','Нельзя импортировать серию или номер карты по отдельности',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6181,'public','Отсутствуют полномочия для выполнения операции импорта',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6182,'public','Невозможно получить текущее количество записей',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6183,'public','Превышен лимит сотрудников, максимум',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6184,'public','Импорт невозможен - отсутствуют подразделения в системе',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6185,'public','Импорт невозможен - отсутствуют должности в системе',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6186,'public','Импорт невозможен - отсутствуют графики работы в системе',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6187,'public','Импорт невозможен - отсутствуют шаблоны доступа в системе',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6188,'public','Не возможно получить текущее количество записей',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6189,'public','Превышен лимит должностей, максимум',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6190,'public','Превышен лимит подразделений, максимум',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6191,'public','Не указано подразделение для импорта',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6192,'public','Превышен лимит посетителей, максимум',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6193,'public','Отсутствуют полномочия для выполнения операции экспорта',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6194,'public','Отсутствуют данные для экспорта',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6195,'public','Отсутствуют права для выполнения данного запроса',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6196,'public','Не существующий отдел в цепочке отделов',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6197,'public','Отсутствует объект для применения стилей',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6198,'public','Отсутствуют заголовки колонок в данных экспорта',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6199,'public','Подразделение не валидно или не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6200,'public','Подразделения не существуют',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6201,'public','Цепочка подразделений не валидна',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6202,'public','Отсутствуют права на добавление в текущий отдел',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6203,'public','Не указано подразделение для сотрудника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6204,'public','Отдел уже существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6205,'public','Цепочка отделов не валидна или отдел существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6206,'public','Сопровождающий не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6207,'public','Шаблона доступа не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6208,'public','Отпечаток',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6209,'public','Карта и отпечаток',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6210,'public','Карта или отпечаток',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6211,'public','Отсутствует описание для данного метода',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6212,'public','Не возможно получить тип события',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6213,'public','Не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6214,'public','Отсутствуют данные для записи в лог',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6215,'public','выполнил действие',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6216,'public','Отсутствуют данные операции',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6217,'public','Текст',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6218,'public','Изображение',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6219,'public','Изменена фотография',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6220,'public','Добавлена фотография',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6221,'public','Удалена фотография',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6222,'public','Изменены интервалы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6223,'public','Отсутствуют данные операторов',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6224,'public','Неизвестный тип поля',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6225,'public','Неизвестный модуль',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6226,'public','Не известный контроллер',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6227,'public','Не известный модуль',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6228,'public','Не передан айди типа события, не возможно записать данные лога',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6229,'public','Событие с указанным идентификатором отсутствует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6230,'public','Не указан идентификатор оператора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6231,'public','Не возможно прочитать лог, не известный идентификатор класса',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6232,'public','Неизвестный контроллер',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6233,'public','Невозможно прочитать лог, неизвестный идентификатор класса',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6234,'public','Документ №',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6235,'public','Права',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6236,'public','Тип критерия доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6237,'public','Название критерия доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6238,'public','Тип прав',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6239,'public','Тип комиссионирования',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6240,'public','Группа комиссионирования 1',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6241,'public','Группа комиссионирования 2',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6242,'public','Критерий верификации от ПО',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6243,'public','Критерий верификации от ВВУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6244,'public','Критерий верификации от ПДУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6245,'public','Права роли',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6246,'public','Зоны доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6247,'public','Шаблоны дизайна пропуска',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6248,'public','Родительское помещение',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6249,'public','Настройки устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6250,'public','MAC адрес',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6251,'public','Язык',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6252,'public','родительский отдел',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6253,'public','Шаблон доступа сотрудника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6254,'public','Шаблон доступа посетителя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6255,'public','Не считать нарушением, разрешить опоздание не более чем на',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6256,'public','Не считать нарушением, разрешить уход раньше не более чем на',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6257,'public','Начало действия',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6258,'public','Зоны учета рабочего времени',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6259,'public','Зоны учета нерабочего времени',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6260,'public','Начало интервала',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6261,'public','Конец интервала',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6262,'public','Тип интервала',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6263,'public','Символьный код',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6264,'public','Числовой код',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6265,'public','Является рабочим временем',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6266,'public','Метод подсчета',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6267,'public','Переработка в выходные',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6268,'public','Постоянный',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6269,'public','Дни',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6270,'public','Время конца',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6271,'public','Тип задания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6272,'public','Промежуточный интервал смены',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6273,'public','Какой-то еще интервал',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6274,'public','Некорректный тип аргумента: оба аргумента должны быть строковыми',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6275,'public','Нет данных для отображения.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6276,'public','Такого контроллера не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6277,'public','Такой контроллер не найден',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6278,'public','Для данного контроллера не поддерживается точка верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6279,'public','Не найдена схема верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6280,'public','Входы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6281,'public','Выводы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6282,'public','Выходы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6283,'public','Нормализован',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6284,'public','Активизирован',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6285,'public','не выбрано',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6286,'public','Команда не распознана',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6287,'public','Неправильный формат данных: ожидается JSON',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6288,'public','Нет активной подписки для текущего клиента',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6289,'public','Ошибка: в запросе не указано имя модуля',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6290,'public','Ошибка: отсутствует тело сообщения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6291,'public','Сессии не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6292,'public','Ключ userId доступен только для чтения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6293,'public','Ошибка создания сессии оператора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6294,'public','Мастер-токен не удаляется',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6295,'public','Сессия оператора удалена',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6296,'public','Неизвестный оператор',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6297,'public','Отсутствует лицензия для выполнения данного запроса',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6298,'public','Отсутствует токен',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6299,'public','Неверный тип переданных данных',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6300,'public','Отсутствует обязательное поле при запросе',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6301,'public','Нет прав для просмотра подразделения:',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6302,'public','карты',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6303,'public','Праздничное расписание удалить нельзя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6304,'public','Нет доступа к данному шаблону или его не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6305,'public','Такое имя уже используется',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6306,'public','Нет доступных помещений',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6307,'public','На некоторые помещения доступа нет',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6308,'public','Не указаны обязательные параметры',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6309,'public','Запрос не может быть пустым',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6310,'public','Шаблон доступа используется и не может быть удален',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6311,'public','Шаблон доступа используется для замены в планировщике и не может быть удален',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6312,'public','Нет доступа к выбранному помещению или оно не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6313,'public','Контроллер с таким MAC-адресом уже добавлен',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6314,'public','Вход и выход должны быть разные помещения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6315,'public','Такое устройство не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6316,'public','Нельзя изменить настройки в неактивном устройстве',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6317,'public','Такой зоны для входа не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6318,'public','Такой зоны для выхода не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6319,'public','Какие-то из мобильных терминалов не существуют',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6320,'public','Входы и выходы шлюза CTL14 можно задавать только для того же устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6321,'public','Направления входов и выходов шлюза CTL14 должны быть разными',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6322,'public','Контроллеры CL15 должны быть разными',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6323,'public','Заданы не все параметры шлюза',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6324,'public','Контроллер с таким IP-адресом уже добавлен в систему',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6325,'public','пока не работает',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6326,'public','Поиск выполняется. Пожалуйста, подождите...',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6327,'public','Направление 1',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6328,'public','Направление 2',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6329,'public','Любое направление',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6330,'public','Любой считыватель',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6331,'public','Несоответствие тип контроллера состоянию перемычек',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6332,'public','Ожидание отключения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6333,'public','Ожидание включения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6334,'public','Такой шаблон камеры не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6335,'public','Шаблон для камеры такого типа уже добавлен',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6336,'public','Такого шаблона камеры не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6337,'public','Фиксированные шаблоны нельзя удалять',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6338,'public','Данный шаблон используется и не может быть удален',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6339,'public','Устройство с таким IP-адресом уже добавлено',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6340,'public','новое устройство',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6341,'public','Нет доступа к данному подразделению, или оно не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6342,'public','Нет доступа к данному подразделению или его не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6343,'public','Нет доступа к родительскому подразделению или его не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6344,'public','В служебное подразделение нельзя добавить дочернее подразделение',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6345,'public','Нет доступа к выбранному родительскому подразделению',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6346,'public','Нет доступа к данному шаблону доступа для сотрудников',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6347,'public','Нет доступа к данному шаблону доступа для посетителей',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6348,'public','Нет доступа к выбранному графику работы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6349,'public','Нет доступа к выбранному сотруднику',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6350,'public','Родительское подразделение не может быть его же дочерним!',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6351,'public','Нет доступа к выбранному шаблону доступа для персонала',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6352,'public','Нет доступа к выбранному шаблону для посетителя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6353,'public','Нет доступа к выбранному сопровождающему',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6354,'public','Такое подразделение уже существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6355,'public','Подразделение используется и не может быть удалено',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6356,'public','Нельзя удалить подразделение, содержащее дочерние подразделения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6357,'public','Подразделение используется для замены в планировщике и не может быть удалена',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6358,'public','Реакции не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6359,'public','Содержит',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6360,'public','Не содержит',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6361,'public','время',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6362,'public','Команда в устройство',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6363,'public','Показать камеру',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6364,'public','Включить запись для камеры',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6365,'public','Заблокировать сотрудника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6366,'public','Разблокировать сотрудника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6367,'public','SMS сообщение предъявившему идентификатор',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6368,'public','Viber сообщение предъявившему идентификатор',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6369,'public','Сообщение оператору',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6370,'public','SMS сообщение сотруднику',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6371,'public','Viber сообщение сотруднику',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6372,'public','Ошибка: это ваш номер телефона?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6373,'public','Получать уведомления по номеру телефона',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6374,'public','отпечаток',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6375,'public','Операция импорта/экспорта уже выполняется другим оператором. Пожалуйста, попробуйте повторить через 5 минут.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6376,'public','Персонал - 100 карт',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6377,'public','Персонал - более 100 карт',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6378,'public','деактивирована',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6379,'public','Не возможно прочитать лог, отсутствует идентификатор события',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6380,'public','Устройство с таким идентификатором уже добавлено',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6381,'public','Выбранный контроллер не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6382,'public','Сначала нужно деактивировать мобильный терминал',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6383,'public','Устройство с таким идентификатором не добавлено',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6384,'public','Данный мобильный терминал не добавлен в систему',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6385,'public','Мобильный терминал не привязан к контроллеру',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6386,'public','Нет доступа к выбранному шаблону пропуска или его не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6387,'public','Шаблон не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6388,'public','Такой дизайн пропуска не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6389,'public','Нет плана',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6390,'public','Данную роль редактировать нельзя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6391,'public','Такой роли не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6392,'public','Такая роль не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6393,'public','Служебную роль удалить нельзя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6394,'public','Роль используется и не может быть удалена',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6395,'public','Данное родительское помещение не существует или было удалено',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6396,'public','В данном помещении нет устройств поддерживающих комиссионирование',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6397,'public','Группы 2-8 поддерживаются только контроллерами s30',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6398,'public','Такого ресурса не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6399,'public','Дополнительные параметры должны быть валидной JSON-строкой',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6400,'public','Параметры контроллера должны быть валидной JSON-строкой',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6401,'public','такой фразы нет в переводчике',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6402,'public','Перевод для этой фразы на выбранный язык уже существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6403,'public','Для этой фразы не существует перевода на выбранный язык',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6404,'public','Неправильный или не существующий логин или пароль',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6405,'public','Учетная запись заблокирована',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6406,'public','Для мобильного терминала обязателен идентификатор устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6407,'public','Мобильный терминал не активен или не добавлен в систему',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6408,'public','Установить пароль администратора возможно только при первом входе в систему',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6409,'public','Превышен максимальный номер карты',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6410,'public','Присутствующие',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6411,'public','Превышен лимит экспорта',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6412,'public','сотрудников',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6413,'public','Данные отсутствуют',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6414,'public','График работы не содержит интервалов',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6415,'public','График работы не содержит помещений учета рабочего времени',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6416,'public','График работы используется и не может быть удалён',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6417,'public','График работы используется для замены в планировщике и не может быть удален',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6418,'public','Не заполнено время сокращения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6419,'public','На этот день уже добавлен праздник',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6420,'public','На эту дату уже назначен перенос',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6421,'public','Перенос можно выполнить только на праздничный день',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6422,'public','Данный тип не поддерживается',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6423,'public','Неизвестный тип графика',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6424,'public','Не правильно заданы переходящие интервалы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6425,'public','В одном дне смены не может быть несколько полных смен',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6426,'public','Одна смена не может дважды переходить через ноль',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6427,'public','Один интервал должен быть меньше либо равен 24 часам',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6428,'public','Один день смены может содержать только одно начало',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6429,'public','Смена может содержать только одно начало',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6430,'public','Смена может содержать только один конец',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6431,'public','Смена должна начинаться с начала смены или содержать только полную смену',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6432,'public','Смена должна заканчиваться концом смены или содержать только полную смену',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6433,'public','Такого задания не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6434,'public','Отправить отчет по подразделению',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6435,'public','сотруднику',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6436,'public','Запрос не должен быть пустым',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6437,'public','Одновременно задать дату и дни нельзя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6438,'public','Время начала должно быть раньше времени окончания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6439,'public','Должно быть выбрано или день, или дата',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6440,'public','Не выбраны действия',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6441,'public','Такого сообщения не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6442,'public','Пользователь не найден',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6443,'public','К некоторым подразделениям нет доступа или они не существуют',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6444,'public','Служебного пользователя редактировать запрещено',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6445,'public','Отсутствуют права для чтения шаблона',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6446,'public','Шаблон верификации не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6447,'public','Отсутствуют права для редактирования шаблона',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6448,'public','Такое имя уже существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6449,'public','Отсутствуют права для удаления шаблона',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6450,'public','Такой шаблон верификации не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6451,'public','Такой точки верификации не существует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6452,'public','Отсутствуют права для шаблона',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6453,'public','Отсутствуют права для удаления точки из шаблона',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6454,'public','Отсутствуют точки верификации для данного шаблона',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6455,'public','Не возможно переместить точку верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6456,'public','Расширенный фильтр должен быть в формате JSON',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6457,'public','Резервное копирование не запущено',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6458,'public','Резервное копирование выполняется',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6459,'public','Резервное копирование завершено',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6460,'public','Резервное копирование завершилось с ошибкой',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6461,'public','Резервное копирование уже запущено',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6462,'public','Невозможно создать каталог для резервных копий',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6463,'public','Резервное копирование запущено',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6464,'public','Импорт данных выполняется',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6465,'public','Импорт данных не запущен',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6466,'public','Выполняется блокирующая операция',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6467,'public','Импорт данных завершен',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6468,'public','Ожидание запроса',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6469,'public','Завершено по таймауту',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6470,'public','Отсутствуют данные для импорта',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6471,'public','Сессия импорта истекла. Начните процедуру импорта заново.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6472,'public','Отсутствуют данные для импорта в сервисе',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6473,'public','Неизвестная цель для экспорта',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6474,'public','сервис импорт-экспорт остановлен',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6475,'public','Об утверждении унифицированных форм первичной учетной документации по учету труда и его оплаты',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6476,'public','Идет расчет УРВ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6477,'public','Расчет УРВ запущен',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6478,'public','Интеграция с внешними системами',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6479,'public','PERCo-WM-04 Модуль интеграции с внешними системами',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6480,'public','PERCo-WM-03 Модуль интеграции с 1С',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6481,'public','Скачать модуль интеграции',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6482,'public','PERCo-WM-04 Модуль интеграции с внешними системами',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6483,'public','Документация',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6484,'public','записей',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6485,'public','Пожарная тревога',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6486,'public','Тревога',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6487,'public','Изменить имя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6488,'public','Присвоить новое имя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6489,'public','Ожидание клавиши',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6490,'public','Данный сотрудник еще не имеет дополнительных карт, [url click=''addCard'']нажмите сюда[/url], что бы выдать её.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6491,'public','Подтвердите действие',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6492,'public','Вы действительно хотите удалить эту карту?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6493,'public','Одно или несколько полей под карту не задано.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6494,'public','Нужно сначала выдать основную карту.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6495,'public','Загрузка изображения...',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6496,'public','Ошибка при вводе данных',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6497,'public','Выбор даты',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6498,'public','Копировать с заменой',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6499,'public','Шаблон верификации не выбран. Нажмите [url click=''selectTemplate'']сюда[/url] чтобы выбрать его',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6500,'public','Выполнение всех условий',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6501,'public','Выполнение одного из условий',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6502,'public','Ошибка: Не удалось подключиться к службе. Для работы [url href=''download'']скачайте[/url] и запустите следующее приложение.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6503,'public','Не создан',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6504,'public','Ошибка сканирования. Код ошибки: {{code}}',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6505,'public','Контроллер не существует или деактивирован',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6506,'public','Некорректный формат файла',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6507,'public','Удалить элемент',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6508,'public','Вы уверены, что хотите очистить данный шаблон?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6509,'public','Группа комиссионирования {{NUM}}',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6510,'public','Введите лицензионный ключ для компонента {{NAME_MODULE}}',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6511,'public','Вы уверены, что хотите отключить модуль?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6512,'public',replace(replace('\r\n                При отключении модуля <b>"Стандартный пакет"</b> количество действующих карт будет ограничено 100 картами сотрудников. \r\n                Ранее введенные карты посетителей и карты сотрудников больше 100 (в порядке добавления) будут заблокированы. \r\n                Также будут отключены остальные модули, кроме <b>"Базовый пакет"</b>.','\r',char(13)),'\n',char(10)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6513,'public','Лицензия не соответствует данному модулю',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6514,'public','Поле скопировано в буфер обмена.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6515,'public','обязательный параметр',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6516,'public','Любой тип',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6517,'public','Новые',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6518,'public','К удалению',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6519,'public','Экспериментальные',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6520,'public','Измененные',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6521,'public','Выберите раздел',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6522,'public','Произошла ошибка при загрузке данных',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6523,'public','Карта (серия)',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6524,'public','Карта (номер)',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6525,'public','Импортировать',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6526,'public','Не удалось обработать файл. Повторите попытку позже.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6527,'public','выполнение',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6528,'public','Импорт из XLS, XLSX',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6529,'public','Не удалось загрузить файл',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6530,'public','Заполните все обязательные поля!',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6531,'public','Экспортировать данные',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6532,'public','Экспортировать',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6533,'public','Импорт данных',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6534,'public','Предварительный просмотр',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6535,'public','Вы действительно хотите удалить карту у данного сотрудника?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6536,'public','День {{day}}',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6537,'public','В текущем дне уже содержатся временные интервалы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6538,'public','Рабочее время: {{h}}ч {{m}}м',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6539,'public','копия',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6540,'public','Вы действительно хотите изменить тип графика? Все имеющиеся интервалы будут потеряны',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6541,'public','Изменить',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6542,'public','Некоторые интервалы заданы неправильно (отмечены красным). Наведите курсор на интервал для просмотра информации об ошибке',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6543,'public','Должно быть указано хотя бы одно помещение учитывающее рабочее время',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6544,'public','Некорректный график работы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6545,'public','В графике работы обязательно должны присутствовать временные интервалы.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6546,'public','День {{dayNumber}}',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6547,'public','В удаляемом дне содержатся временные интервалы. Всё равно удалить?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6548,'public','Добавить график работы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6549,'public','Выберите временную зону',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6550,'public','Выберите недельный график',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6551,'public','День {{day_number}}',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6552,'public','Выберите день',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6553,'public','Выберите праздничное расписание',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6554,'public','Не указано ни одного суточного графика',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6555,'public','Не указано ни одного недельного графика',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6556,'public','Не указано ни одного праздника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6557,'public','Параметры доступа контроллера',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6558,'public','Критерий',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6559,'public','Критерий доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6560,'public','Выберите график',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6561,'public','Сначала выберите тип критерия',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6562,'public','Для помещения "{{room}}" не выбран критерий',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6563,'public','Для помещения "{{room}}" не выбран тип доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6564,'public','Должны быть заданы параметры хотя бы для одного помещения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6565,'public','Добавить шаблон доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6566,'public','ключ карты отличается от ключа в конфигурации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6567,'public','Попытка подключения...',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6568,'public','Обнаружено {{CARD_NAME}} с номером: "{{CARD_NUMBER}}", что бы применить данный номер, нажмите "сохранить".',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6569,'public','Нажмите "Сохранить" и приложите карту',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6570,'public','Введите валидные данные. Серия не может быть больше 255 и номер не может быть больше 65535.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6571,'public','Серия и номер одновременно не могут быть нулем.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6572,'public','Введите валидные данные. Номер не может быть больше 9223372036854775807.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6573,'public','Идентификатор не может быть пустым или равным нулю',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6574,'public',replace(replace('Не удалось записать мастер-карту. \r\nПревышен лимит ожидания.','\r',char(13)),'\n',char(10)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6575,'public','Подождите пожалуйста...',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6576,'public','Получение информации о карте',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6577,'public','Слишком большое изображение',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6578,'public','Без изменений',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6579,'public','Распечатать',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6580,'public','Выберите пожалуйста сотрудника для того, чтобы воспользоваться данной функцией.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6581,'public','{{MESSAGE}}, хотите открыть данного посетителя?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6582,'public','Открыть',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6583,'public','Редактировать посетителя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6584,'public','Передача всех данных в устройство может занять длительное время.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6585,'public','Внимание! В следующих контроллерах возможны проблемы с доступом.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6586,'public','Выберите вариант восстановления сотрудника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6587,'public','Не удалось скопировать поле.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6588,'public','Обновление устройств...',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6589,'public','{{MESSAGE}}, хотите открыть данного сотрудника?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6590,'public','Редактировать сотрудника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6591,'public','Данный посетитель будет удален безвозвратно, его восстановление в дальнейшем будет невозможно.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6592,'public','Данный посетитель будет перемещен в архив.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6593,'public','Оправдательные документы - {{user_name}}',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6594,'public','Безусловные права на все помещения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6595,'public','Безусловные права на все подразделения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6596,'public','Безусловные права на все должности',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6597,'public','Безусловные права на все графики работы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6598,'public','Безусловные права на все шаблоны доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6599,'public','Безусловные права на все шаблоны пропусков',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6600,'public','Безусловные права на все устройства',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6601,'public','Безусловные права на все шаблоны верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6602,'public','Вы действительно хотите удалить данную роль?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6603,'public','оператору',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6604,'public','Включить запись видео',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6605,'public','Ограничение по времени',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6606,'public','Нельзя сохранить оператора без доступа к разделам системы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6607,'public','Редактировать оператора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6608,'public','Служебных операторов копировать нельзя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6609,'public','Вы действительно хотите удалить данного оператора?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6610,'public','Вы действительно хотите очистить весь список?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6611,'public','Удаление',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6612,'public','Вы действительно хотите удалить данный график работы?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6613,'public','Вы действительно хотите удалить данные графики работы?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6614,'public','Удаляем...',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6615,'public','Продолжить',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6616,'public','Присвоить',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6617,'public','Вы действительно хотите удалить этот шаблон доступа?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6618,'public','Вы действительно хотите удалить этот временной критерий?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6619,'public','Нажмите [url click=''onSearch'']сюда[/url] для того, чтобы найти все устройства.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6620,'public','Откройте [url click=''addCard'']инструкцию  по работе с приложением',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6621,'public','Всё в устройство',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6622,'public','Измененные в устройство',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6623,'public','Список NFC устройств',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6624,'public','Вы изменили настройки карт Mifare, но не произвели запись конфигурации в память. Настройки Mifare сохранены не будут.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6625,'public','Исправьте поля с ошибками (отмечены красным)',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6626,'public','Вы действительно хотите отключить данное устройство?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6627,'public','Отключить',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6628,'public','Вы действительно хотите включить данное устройство?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6629,'public','Подключить',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6630,'public','Вы действительно хотите удалить ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6631,'public','Вы действительно хотите удалить {{selected_device}}?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6632,'public','Вы действительно хотите удалить данный шаблон?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6633,'public','Добавить шаблон',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6634,'public','Внимание! Данная функция включает функции, которые еще находятся на стадии разработки, хотите продолжить?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6635,'public','{{name}} (Копия)',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6636,'public','Вы действительно хотите удалить данный дизайн пропуска?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6637,'public','Создать шаблона пропуска',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6638,'public','Вы действительно хотите перенести заказанный пропуск в архив?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6639,'public','Добавить посетителя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6640,'public','Посетитель будет удален безвозвратно, его восстановление в дальнейшем будет невозможно.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6641,'public','Для добавления точек верификации, сначала [url click=''SaveTemplate'']сохраните[/url] текущий шаблон.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6642,'public','Сначала укажите название конфигурации.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6643,'public','Вы действительно хотите удалить данную точку?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6644,'public','Выберите действие',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6645,'public','Точка верификации успешно создана, хотите её отредактировать?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6646,'public','Вы действительно хотите удалить данную конфигурацию?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6647,'public','Выберите помещение или устройство',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6648,'public','У этого устройства нет команд',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6649,'public','У устройств в этом помещении нет команд',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6650,'public','Данная операция приведет к сбросу лицензионных ключей у всех пакетов.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6651,'public','Вы действительно хотите удалить данный перевод?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6652,'public','Настройка отображения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6653,'public','Права для помещения {{ROOM_NAME}}',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6654,'public','Интерфейс переводчика',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6655,'public','Переводчик',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6656,'public','подтвердить',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6657,'public','предыдущее',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6658,'public','следующее',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6659,'public','подтвердить все',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6660,'public','Обрыв соединения с сокетом',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6661,'public','Инициализация',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6662,'public',replace(replace('Внимание, превышено максимальное количество событий системы! Пожалуйста, перейдите в раздел "События системы" и \r\nудалите устаревшие события или сообщите администратору об этой проблеме.','\r',char(13)),'\n',char(10)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6663,'public','Отсутствует соединение с сервером, обратитесь к администратору системы...',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6664,'public','Ошибка связи с сервером системы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6665,'public','Сервер системы отключен',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6666,'public','Изменить фотографию',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6667,'public','Вы действительно хотите закрыть без сохранения?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6668,'public','Превышено максимальное количество символов.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6669,'public','Ошибка запроса',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6670,'public','Не удалось подключиться к серверу БД, повторите попытку позже',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6671,'public','Это могло произойти из-за',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6672,'public','Отключение системы на сервере',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6673,'public','Отключение сервера или его перезагрузка',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6674,'public','Сбой работы в системе',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6675,'public','Подтвердить',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6676,'public','Клавиша Таб',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6677,'public','Стрелка вверх',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6678,'public','Стрелка вправо',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6679,'public','Стрелка влево',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6680,'public','Стрелка вниз',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6681,'public','Пробел',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6682,'public','Пароль должен содержать символ и число.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6683,'public','Пароль должен быть не менее 6 символов.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6684,'public','Логин должен быть больше двух символов.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6685,'public','Пароли не совпадают.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6686,'public','Отсутствует соединение с сервером, повторите попытку позже...',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6687,'public','Не показывать предупреждения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6688,'public','Поле должно быть заполнено',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6689,'public','Неправильный формат ввода',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6690,'public','Значение ниже минимального',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6691,'public','Значение больше максимального',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6692,'public','Значение слишком короткое',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6693,'public','Значения полей должны быть одинаковыми',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6694,'public','Всё понятно',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6695,'public','Удалить интервал',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6696,'public','Для тонкой настройки даты, кликните дважды',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6697,'public','Отобразить все фильтры',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6698,'public','Поставить на паузу',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6699,'public','Следующий кадр',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6700,'public','Не переданные ресурсы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6701,'public','Следующие ресурсы не записаны в устройство',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6702,'public','Добавить в корень',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6703,'public','Нет данных для отображения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6704,'public','Сделать эту карту основной',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6705,'public','Удалить карту',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6706,'public','Добавить карту',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6707,'public','Основная карта',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6708,'public','Дополнительные карты',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6709,'public','Изменить название',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6710,'public','Перенесите файл сюда, или нажмите для выбора файла загрузки..',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6711,'public','Отключить фон у элемента',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6712,'public','Активировать 1С интеграцию',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6713,'public','Проверить обновление',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6714,'public','Загрузка',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6715,'public','Выбрать файл с обновлениями',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6716,'public','или',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6717,'public','Конец',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6718,'public','Ой!',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6719,'public','403 - Доступ закрыт',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6720,'public','Выйти',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6721,'public','Подробно',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6722,'public','Вверх',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6723,'public','...Повторите',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6724,'public','Отобразить сообщение системы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6725,'public','Порядок байт в идентификаторе',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6726,'public','Режим Wiegand',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6727,'public','От старшего к младшему',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6728,'public','От младшему к старшему',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6729,'public','Использовать аутентификацию',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6730,'public','Доступ по карте или отпечатку',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6731,'public',replace(replace('Операция импорта/экспорта уже выполняется другим оператором. \r\nПожалуйста, попробуйте повторить через 5 минут','\r',char(13)),'\n',char(10)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6732,'public',replace(replace('ВНИМАНИЕ! В случае изменения данных параметров необходимо записать мастер-карту с \r\nновыми параметрами, после чего переконфигурировать этой картой все считыватели и \r\nизменить ключи на всех картах доступа этого типа','\r',char(13)),'\n',char(10)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6733,'public',replace(replace('Ошибка подключения к базе данных. Проверьте правильность ввода логина и пароля \r\nбазы данных в менеджере PERCo-Web','\r',char(13)),'\n',char(10)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6734,'public',replace(replace('Ошибка подключения к базе данных. Проверьте правильность указания хоста сервера \r\nбазы данных в менеджере PERCo-Web','\r',char(13)),'\n',char(10)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6735,'public',replace(replace('Операция импорта/экспорта уже выполняется другим оператором. Пожалуйста, попробуйте\r\n повторить через 5 минут.','\r',char(13)),'\n',char(10)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6736,'public',replace(replace('Об утверждении унифицированных форм первичной учетной документации по учету труда \r\nи его оплаты','\r',char(13)),'\n',char(10)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6737,'public',replace(replace('Данный сотрудник еще не имеет дополнительных карт, [url click=''addCard'']нажмите \r\nсюда[/url], что бы выдать её.','\r',char(13)),'\n',char(10)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6738,'public',replace(replace('Шаблон верификации не выбран. Нажмите [url click=''selectTemplate'']сюда[/url] чтобы \r\nвыбрать его','\r',char(13)),'\n',char(10)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6739,'public',replace(replace('Ошибка: Не удалось подключиться к службе. Для работы [url href=''download'']скачайте[/url]\r\n и запустите следующее приложение.','\r',char(13)),'\n',char(10)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6740,'public',replace(replace('Некоторые интервалы заданы неправильно (отмечены красным). Наведите курсор на \r\nинтервал для просмотра информации об ошибке','\r',char(13)),'\n',char(10)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6741,'public',replace(replace('Обнаружено {{CARD_NAME}} с номером: "{{CARD_NUMBER}}", что бы применить данный \r\nномер, нажмите "сохранить".','\r',char(13)),'\n',char(10)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6742,'public',replace(replace('Введите валидные данные. Серия не может быть больше 255 и номер не может быть \r\nбольше 65535.','\r',char(13)),'\n',char(10)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6743,'public','Откройте [url click=''addCard'']инструкцию[/url] по работе с приложением',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6744,'public',replace(replace('Вы изменили настройки карт Mifare, но не произвели запись конфигурации в память. \r\nНастройки Mifare сохранены не будут.','\r',char(13)),'\n',char(10)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6745,'public',replace(replace('Внимание! Данная функция включает функции, которые еще находятся на стадии \r\nразработки, хотите продолжить?','\r',char(13)),'\n',char(10)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6746,'public',replace(replace('Для добавления точек верификации, сначала [url click=''SaveTemplate'']сохраните[/url] \r\nтекущий шаблон.','\r',char(13)),'\n',char(10)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6747,'public',replace(replace('Внимание, превышено максимальное количество событий системы! Пожалуйста, перейдите в \r\nраздел "События системы" и удалите устаревшие события или сообщите администратору об \r\nэтой проблеме.','\r',char(13)),'\n',char(10)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6748,'public','Корпус извещателя закрыт:',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6749,'public','Запрет прохода по команде оператора:',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6750,'public','Запрет прохода по команде от ДУ:',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6751,'public','Запрет прохода:',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6752,'public','Предъявлена комиссионирующая карта:',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6753,'public','Проход с подтверждением от ДУ:',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6754,'public','Проход с подтверждением от верификации:',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6755,'public','Выбранный график не может быть удален, так как используется следующими людьми:',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6756,'public','Ночное время с',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6757,'public','Вечернее время с',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6758,'public','Основные поля:',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6759,'public','Индикация: проход сотрудника и разрешение прохода от ДУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6760,'public','Индикация: проход посетителя и разрешение прохода от ДУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6761,'public','Индикация: проход сотрудника и ожидание комиссионирования',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6762,'public','Индикация: проход посетителя и ожидание комиссионирования',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6763,'public','Индикация: проход сотрудника и снятие с «Охраны»',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6764,'public','Индикация: проход посетителя и снятие с «Охраны»',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6765,'public','Индикация: проход сотрудника и нарушение времени',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6766,'public','Индикация: проход посетителя и нарушение времени',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6767,'public','Индикация: проход сотрудника и нарушение местоположения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6768,'public','Индикация: проход посетителя и нарушение местоположения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6769,'public','Индикация: проход сотрудника и нарушение времени и нарушение местоположения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6770,'public','Индикация: проход посетителя и нарушение времени и нарушение местоположения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6771,'public','Индикация: проход посетителя и нарушение режима доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6772,'public','Индикация: проход сотрудника и запрос на проход от пульта ДУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6773,'public','Индикация: проход посетителя и запрос на проход от пульта ДУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6774,'public','Индикация: проход сотрудника и постановка на «Охрану»',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6775,'public','Индикация: проход посетителя и постановка на «Охрану»',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6776,'public','Индикация: проход сотрудника и карта не зарегистрирована',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6777,'public','Индикация: проход посетителя и карта не зарегистрирована',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6778,'public','Индикация: проход сотрудника и катра заблокирована',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6779,'public','Индикация: проход посетителя и катра заблокирована',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6780,'public','Индикация: проход сотрудника и карта в стоп-листе',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6781,'public','Индикация: проход посетителя и карта в стоп-листе',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6782,'public','Индикация: проход сотрудника и истёк срок действия карты',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6783,'public','Индикация: проход посетителя и истёк срок действия карты',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6784,'public','Индикация: проход сотрудника и взлом ИУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6785,'public','Индикация: проход посетителя и взлом ИУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6786,'public','Если Java установлен, необходимо включить его для браузера Chrome:',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6787,'public','не может быть удален(а), так как используется следующими людьми:',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6788,'public','установили:',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6789,'public','День:',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6790,'public','Наименование:',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6791,'public','Отсутствует лицензионный контроллер. Осталось',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6792,'public','В это помещение добавление устройств запрещено',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6793,'public','супер-карта',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6794,'public','неизвестный тип карты',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6795,'public','неизвестно (не подошли ключи: ключ по умолчанию, текущий ключ карты, старый ключ карты, мастер ключ, ключ супер-карты)',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6796,'public',replace(replace('При отключении модуля <b>"Стандартный пакет"</b> количество действующих карт будет ограничено 100 картами сотрудников. \r\n                Ранее введенные карты посетителей и карты сотрудников больше 100 (в порядке добавления) будут заблокированы. \r\n                Также будут отключены остальные модули, кроме <b>"Базовый пакет"</b>.','\r',char(13)),'\n',char(10)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6797,'public','Вы действительно хотите удалить',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6798,'public','Изымать только в последний день действия идентификатора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6799,'public','Получение таблицы c оправдательными документами у пользователя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6800,'public','Фильтр по дате',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6801,'public','Данные роли для coхранения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6802,'public','Метод для сборки схемы контроллера по ресурсам',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6803,'public','ID временной зоны',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6804,'public','ID недельного расписания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6805,'public','ID скользящего посуточного расписания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6806,'public','ID скользящего понедельного расписания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6807,'public','ID праздничного расписания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6808,'public','ID временного критерия доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6809,'public','Cекретный ключ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6810,'public','Параметры переноса отображения точки верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6811,'public','Метод для сборки схемы верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6812,'public','Данные графика работы для сохранения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6813,'public','Данные праздника для сохранения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6814,'public','Массив ID подразделений или массив с единственным элементом - ID сотрудника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6815,'public','Обновление состояния задания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6816,'public','Объект, с ID контроллера',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6817,'public','Активировать или деактивировать',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6818,'public','Название схемы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6819,'public','Логин и пароль администратора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6820,'public','В сменном суточном критерии доступа должно быть от 1 до 30 дней',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6821,'public','Нет ID сотрудника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6822,'public','Сотрудника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6823,'public','Посетителя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6824,'public','Заблокированы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6825,'public','Разблокированы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6826,'public','ВНИМАНИЕ! В случае изменения данных параметров необходимо записать мастер-карту с новыми параметрами, после чего переконфигурировать этой картой все считыватели и изменить ключи на всех картах доcтупа этого типа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6827,'public','При проходе СОТРУДНИКОВ c НАРУШЕНИЕМ ЗОНАЛЬНОСТИ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6828,'public','По ДУ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6829,'public','Действителен c',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6830,'public','Выполнил действие',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6831,'public','Не передан айди типа события, невозможно записать данные лога',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6832,'public','Событие c указанным идентификатором отсутствует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6833,'public','Родительский отдел',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6834,'public','Ключ user Id доступен только для чтения',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6835,'public','Пока не работает',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6836,'public','Новое устройство',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6837,'public','Деактивирована',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6838,'public','Такой фразы нет в переводчике',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6839,'public','Невозможно переместить точку верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6840,'public','Сервис импорт-экспорт остановлен',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6841,'public',replace(replace('При отключении модуля <b>"Стандартный пакет"</b> количество действующих карт будет ограничено 100 картами сотрудников.\r\nРанее введенные карты посетителей и карты сотрудников больше 100 (в порядке добавления) будут заблокированы. \r\nТакже будут отключены остальные модули, кроме <b>"Базовый пакет"</b>.','\r',char(13)),'\n',char(10)),NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6842,'public','Обязательный параметр',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6843,'public','Cначала выберите тип критерия',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6844,'public','Ключ карты отличается от ключа в конфигурации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6845,'public','Оператору',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6846,'public','Внимание, превышено максимальное количество событий системы! Пожалуйста, перейдите в раздел "События системы" и удалите устаревшие события или сообщите администратору об этой проблеме.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6847,'public','Выбрать файл c обновлениями',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6848,'public','Пауза..',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6849,'public','Изменить основную карту',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6850,'public','Найти по номеру карты',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6851,'public','Поиск по заданным условиям',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6852,'public','Перемещения сотрудника за {{DATE}} года.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6853,'public','Перемещения посетителя за {{DATE}} года.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6854,'public','Выбрать устройство',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6855,'public','Выбрать график работы',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6856,'public','Выбрать должность',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6857,'public','Выбрать шаблон доступа',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6858,'public','Выбрать сопровождающего',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6859,'public','Выбрать сотрудника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6860,'public','Выбрать оператора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6861,'public','Выбрать ответ на запрос',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6862,'public','Выбрать событие',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6863,'public','Выбрать время',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6864,'public','Выбрать точку верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6865,'public','Выбрать шаблон верификации',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6866,'public','Выбрать помещение',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6867,'public','Выбрать камеру',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6868,'public','Выбрать считыватель',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6869,'public','Выбрать команду',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6870,'public','Выбрать отчёт',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6871,'public','Выбрать ресурс',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6872,'public','Загрузка таблицы...',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6873,'public','Оправдательные документы: {{user_name}}',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6874,'public','Планировщик для сотрудника: {{user_name}}',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6875,'public','Привышен лимит ожидания',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6876,'public','Редактировать сотрудников',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6877,'public','Добавить сотрудника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6878,'public','Добавить дополнительное поле',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6879,'public','Редактировать дополнительное поле',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6880,'public','Добавить новое задание',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6881,'public','Добавить реакцию на событие',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6882,'public','Добавить новый документ',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6883,'public','Редактировать задание',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6884,'public','Редактировать реакцию на событие',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6885,'public','Блокировать сотрудника',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6886,'public','Добавить новое значение',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6887,'public','Вы действительно хотите удалить этот отпечаток?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6888,'public','Вы действительно хотите удалить эту фотографию?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6889,'public','Вы действительно хотите удалить это задание?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6890,'public','Вы действительно хотите удалить эту реакцию на событие?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6891,'public','Вы действительно хотите заблокировать оператора "{{operator_name}}"?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6892,'public','Вы действительно хотите разблокировать оператора "{{operator_name}}"?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6893,'public','Вы действительно хотите заблокировать данного сотрудника?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6894,'public','Вы действительно хотите разблокировать данного сотрудника?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6895,'public','Вы действительно хотите заблокировать данного посетителя?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6896,'public','Вы действительно хотите разблокировать данного посетителя?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6897,'public','Вы действительно хотите удалить это значение?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6898,'public','Вы действительно хотите удалить данную должность?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6899,'public','Вы действительно хотите удалить данное подразделение?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6900,'public','Вы действительно хотите удалить данное дополнительное поле?',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6901,'public','Права на комиссионирование устройств',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6902,'public','Выберите устройства для комиссионирования',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6903,'public','Просмотр учетной карточки пользователя',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6904,'public','В данном подразделении нельзя создать новое.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6905,'public','Нельзя добавлять сразу в несколько подразделений.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6906,'public','Уровень безопасности',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6907,'public','Текущий уровень мастер-карты',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6908,'public','Смартфон (SIM карта)',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6909,'public','Выбрать устройство',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6910,'public','Выбрать оператора',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6911,'public','Apple (в режиме эмуляции банковских карт), некоторые виды банковских карт',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6912,'public','Ошибка, невозможно подключиться к настольному считывателю.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6913,'public','Нет связи с сервером, проверьте подключение сети...',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6914,'public','Ошибка: Не удалось подключиться к службе. Для работы [url href=''download'']скачайте[/url] и запустите следующее приложение',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6915,'public','Введите номер и нажмите кнопку "сохранить"',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6916,'public','Не удалось подключиться к устройству.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6917,'public','Получение карты от {{NAME}} ({{IP}})',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6918,'public','Режим ручного ввода',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6919,'public','Ожидание...',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6920,'public','[url href=''download'']Обновите[/url] клиентский считыватель до версии {{VERSION}}',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6921,'public','Нет подключенных считывателей типа Mifare',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6922,'public','Нет подключенных считывателей',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6923,'public','Получение карты от контрольного считывателя.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6924,'public','Добавить перевод',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6925,'public','Редактировать перевод',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6926,'public','Ключ не должен быть идентичен ключу по умолчанию (FF FF FF FF FF FF) (старый)',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6927,'public','размер памяти для отпечатков меньше минимально допустимого (260)',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6928,'public','«телефон» во время работы UID должен быть всегда установлен (чтение UID без опции «телефон» - не допускается)',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6929,'public','Карта имеет ключ аутентификации идентичный параметру «старый ключ»<br />Добавлено новое приложение, возникает когда есть сторонние приложения на карте',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6930,'public','Ошибка записи',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6931,'public','Ошибка открытия порта',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6932,'public','Не передан обязательный параметр',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6933,'public','Ошибка записи',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6934,'public','Занят другим пользователем',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6935,'public','Ошибка ответа от сервера не было получено',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6936,'public','Не доступно в этой версии',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6937,'public','Чтобы распечатать информацию о проходе, выберите, пожалуйста, интересующий Вас проход.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6938,'public','Информация о проходе',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6939,'public','Информация о проходящем',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6940,'public','Видеокадры прохода',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6941,'public','Видеокадры не найдены',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6942,'public','Редактировать устройство',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6943,'public','Приложите палец для проверки',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6944,'public','Шаблон не соотвествует',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6945,'public','Устройстро отключено',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6946,'public','Устройство подключено',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6947,'public','Поднимите палец',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6948,'public','Латентный отпечаток',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6949,'public','Переместите палец вверх',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6950,'public','Переместите палец вниз',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6951,'public','Переместите палец влево',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6952,'public','Переместите палец вправо',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6953,'public','Прижмите палец посильнее',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6954,'public','Успешно получен',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6955,'public','Обнаружен фальшивый отпечаток',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6956,'public','Палец слишком влажный',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6957,'public','Неверное расположение пальца',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6958,'public','Палец обнаружен, обрабатывается...',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6959,'public','Приложите палец, сканирование 1/3',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6960,'public','Приложите палец, сканирование 2/3',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6961,'public','Приложите палец, сканирование 3/3',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6962,'public','Biometrics device performed an internal error',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6963,'public','Can not connect biometrics device',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6964,'public','Invalid parameter',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6965,'public','Class has been corrupted',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6966,'public','Unknown error',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6967,'public','Have found more than one device',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6968,'public','Invalid device',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6969,'public','Can''t encode picture',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6970,'public','Can''t encode template (отпечаток)',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6971,'public','Verify unknown error',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6972,'public','Closing device error',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6973,'public','Can''t open device',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6974,'public','Broken template string',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6975,'public','Проверяем...',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6976,'public','Поднесите палец к сканеру еще раз.',NULL,NULL,NULL);
INSERT INTO sourcemessage VALUES(6977,'public','Поднесите палец.',NULL,NULL,NULL);
CREATE TABLE `task` (
  `id` integer NOT NULL primary key autoincrement,
  `name` varchar(150)  DEFAULT NULL,
  `date` date DEFAULT NULL,
  `days` integer DEFAULT NULL,
  `time_start` time DEFAULT NULL,
  `time_end` time DEFAULT NULL,
  `task_state_id` integer DEFAULT NULL,
  `date_exec` datetime DEFAULT NULL
);
INSERT INTO task VALUES(1,'##Резервное копирование базы данных##',NULL,64,'00:00:00','01:00:00',NULL,NULL);
CREATE TABLE `task_action` (
  `id` integer NOT NULL primary key autoincrement,
  `task_id` integer DEFAULT NULL,
  `type_id` integer DEFAULT NULL,
  `object_id` integer DEFAULT NULL,
  `options` json DEFAULT NULL
);
INSERT INTO task_action VALUES(1,1,1,NULL,NULL);
CREATE TABLE `task_state` (
  `id` integer NOT NULL primary key autoincrement,
  `name` varchar(80)  NOT NULL
);
INSERT INTO task_state VALUES(1,'Выполнено');
INSERT INTO task_state VALUES(2,'Выполнено с ошибками');
INSERT INTO task_state VALUES(3,'##Выполняется##');
CREATE TABLE `user` (
  `id` integer NOT NULL primary key autoincrement,
  `last_name` varchar(150)  NOT NULL,
  `first_name` varchar(150)  NOT NULL,
  `middle_name` varchar(150)  DEFAULT NULL,
  `user_type_id` integer NOT NULL,
  `is_operator` integer NOT NULL DEFAULT '0',
  `division_id` integer DEFAULT NULL,
  `position_id` integer DEFAULT NULL,
  `access_template_id` integer DEFAULT NULL,
  `is_active` integer NOT NULL DEFAULT '1',
  `is_block` integer NOT NULL DEFAULT '0',
  `is_removed` integer NOT NULL DEFAULT '0',
  `create_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `begin_date` datetime DEFAULT CURRENT_TIMESTAMP,
  `end_date` datetime DEFAULT NULL,
 

  CONSTRAINT `user_access_template_id_fk` FOREIGN KEY (`access_template_id`) REFERENCES `access_template` (`id`) ,
  CONSTRAINT `user_division_id_fk` FOREIGN KEY (`division_id`) REFERENCES `division` (`id`) ,
  CONSTRAINT `user_position_id_fk` FOREIGN KEY (`position_id`) REFERENCES `position` (`id`) ,
  CONSTRAINT `user_user_type_id_fk` FOREIGN KEY (`user_type_id`) REFERENCES `user_type` (`id`)
);
INSERT INTO user VALUES(1,'Системный','Администратор',NULL,1,1,NULL,NULL,NULL,0,0,0,'2018-10-12 14:07:48','2018-10-12 14:00:34',NULL);
INSERT INTO user VALUES(2,'Сервер','Системы',NULL,0,1,NULL,NULL,NULL,0,0,0,'2018-11-26 13:48:21','2018-11-26 13:48:21',NULL);
INSERT INTO user VALUES(3,'Менеджер','Перко-веб',NULL,0,1,NULL,NULL,NULL,0,0,0,'2018-11-26 14:54:07','2018-11-26 14:54:07',NULL);
INSERT INTO user VALUES(4,'Мобильный','Терминал',NULL,0,1,NULL,NULL,NULL,0,0,0,'2018-12-10 16:39:23','2018-12-10 16:39:23',NULL);
INSERT INTO user VALUES(5,'Event','Action',NULL,0,1,NULL,NULL,NULL,0,0,0,'2019-01-22 14:54:47','2019-01-22 14:54:47',NULL);
INSERT INTO user VALUES(99,'1','С',NULL,1,1,NULL,NULL,NULL,1,0,0,'2019-02-11 13:54:18','2019-02-11 13:54:18',NULL);
CREATE TABLE `user_additional_field` (
  `id` integer NOT NULL primary key autoincrement,
  `type_id` integer NOT NULL,
  `name` varchar(150)  NOT NULL,
  `comment` varchar(150)  DEFAULT NULL,
  `user_type` integer NOT NULL,
  `is_const` integer NOT NULL DEFAULT '0'
);
INSERT INTO user_additional_field VALUES(-5,5,'Email','##Служебное поле##',1,1);
INSERT INTO user_additional_field VALUES(-4,4,'##Номер телефона##','##Служебное поле##',1,1);
INSERT INTO user_additional_field VALUES(-3,3,'Viber','##Служебное поле##',1,1);
INSERT INTO user_additional_field VALUES(-2,6,'##Пин-код##',NULL,1,1);
INSERT INTO user_additional_field VALUES(1,2,'Фотография','Служебное поле',1,1);
INSERT INTO user_additional_field VALUES(2,2,'Фотография','Служебное поле',2,1);
CREATE TABLE `user_additional_field_type` (
  `id` integer NOT NULL primary key autoincrement,
  `name` varchar(150)  NOT NULL
);
INSERT INTO user_additional_field_type VALUES(1,'Текстовый');
INSERT INTO user_additional_field_type VALUES(2,'Графический');
INSERT INTO user_additional_field_type VALUES(3,'Viber');
INSERT INTO user_additional_field_type VALUES(4,'##Телефон##');
INSERT INTO user_additional_field_type VALUES(5,'Email');
INSERT INTO user_additional_field_type VALUES(6,'##Пин-код##');
CREATE TABLE `user_card` (
  `id` integer NOT NULL primary key autoincrement,
  `user_id` integer NOT NULL,
  `identifier` bigint  NOT NULL,

  CONSTRAINT `user_card_user_id_fk` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
);
CREATE TABLE `user_change_type` (
  `id` integer NOT NULL primary key autoincrement,
  `description` varchar(150)  NOT NULL
);
INSERT INTO user_change_type VALUES(1,'Подразделение');
INSERT INTO user_change_type VALUES(2,'Должность');
INSERT INTO user_change_type VALUES(3,'Шаблон доступа');
INSERT INTO user_change_type VALUES(4,'График работы');
INSERT INTO user_change_type VALUES(5,'Блокировка');
CREATE TABLE `user_doc` (
  `id` integer NOT NULL primary key autoincrement,
  `user_id` integer NOT NULL,
  `doc_id` integer NOT NULL,
  `doc_creation_date` date NOT NULL,
  `duration` time DEFAULT NULL,
  `doc_begin_date` date DEFAULT NULL,
  `doc_end_date` date DEFAULT NULL,
  `doc_number` varchar(150)  DEFAULT NULL,
  `no_calculate` integer NOT NULL DEFAULT '0'
, is_complex integer default 0 not null);
CREATE TABLE `user_image` (
  `user_id` integer NOT NULL,
  `field_id` integer NOT NULL,
  `image` mediumtext  NOT NULL,
  `user_type` integer NOT NULL,
  CONSTRAINT `user_image_user_id_fk` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
);
CREATE TABLE `user_operator_type` (
  `id` integer NOT NULL primary key autoincrement,
  `name` varchar(50)  NOT NULL
);
INSERT INTO user_operator_type VALUES(1,'Системный');
INSERT INTO user_operator_type VALUES(2,'Предустановленный');
INSERT INTO user_operator_type VALUES(3,'Пользовательский');
CREATE TABLE `user_role` (
  `id` integer NOT NULL primary key autoincrement,
  `name` varchar(150)  NOT NULL,
  `description` varchar(150)  DEFAULT NULL,
  `rights` mediumtext,
  `is_const` integer NOT NULL DEFAULT '0'
);
INSERT INTO user_role VALUES(1,'admin',NULL,NULL,1);
CREATE TABLE `user_type` (
  `id` integer NOT NULL primary key autoincrement,
  `type` varchar(50)  NOT NULL,
  `description` varchar(150)  NOT NULL
);
INSERT INTO user_type VALUES(0,'service','Служба');
INSERT INTO user_type VALUES(1,'staff','Сотрудник');
INSERT INTO user_type VALUES(2,'visitor','Посетитель');
CREATE TABLE `verify_point` (
  `id` integer NOT NULL primary key autoincrement,
  `verify_template_id` integer NOT NULL,
  `name` varchar(150)  DEFAULT NULL,
  `reader_device_id` integer DEFAULT NULL,
  `reader_direction` integer DEFAULT NULL,
  `camera_device_id` integer DEFAULT NULL,
  `sort_id` integer DEFAULT NULL,
  `hot_key_allow` integer DEFAULT NULL,
  `hot_key_deny` integer DEFAULT NULL,
  `schema_data` json DEFAULT NULL,
  CONSTRAINT `verify_point_device_id_fk` FOREIGN KEY (`reader_device_id`) REFERENCES `device` (`id`)
);
CREATE TABLE `work_holiday_parameters` (
  `night_time_begin` time DEFAULT NULL,
  `night_time_end` time DEFAULT NULL,
  `evening_time_begin` time DEFAULT NULL,
  `evening_time_end` time DEFAULT NULL,
  `is_evening_time` integer NOT NULL
);
INSERT INTO work_holiday_parameters VALUES('01:00','00:00','01:00:00','05:00:00',0);
CREATE TABLE `work_holyday_type` (
  `id` integer NOT NULL primary key autoincrement,
  `name` varchar(150)  NOT NULL
);
INSERT INTO work_holyday_type VALUES(1,'Праздник');
INSERT INTO work_holyday_type VALUES(2,'Предпраздничный день');
INSERT INTO work_holyday_type VALUES(3,'Рабочий выходной');
INSERT INTO work_holyday_type VALUES(4,'Пометка');
CREATE TABLE `work_schedule_interval` (
  `work_schedule_id` integer DEFAULT NULL,
  `begin_time` integer DEFAULT NULL,
  `end_time` integer DEFAULT NULL,
  `schedule_interval_type` integer NOT NULL
);
CREATE TABLE `work_schedule_no_access_zone` (
  `work_schedule_id` integer DEFAULT NULL,
  `access_zone_id` integer DEFAULT NULL
);
CREATE TABLE `work_schedule_preset_holiday` (
  `id` integer NOT NULL primary key autoincrement,
  `day` integer NOT NULL,
  `month` integer NOT NULL,
  `name` varchar(150)  DEFAULT NULL
);
CREATE TABLE `work_schedule_type` (
  `id` integer NOT NULL primary key autoincrement,
  `name` varchar(150)  NOT NULL
);
INSERT INTO work_schedule_type VALUES(1,'Никогда');
INSERT INTO work_schedule_type VALUES(2,'Недельный');
INSERT INTO work_schedule_type VALUES(3,'Сменный');
INSERT INTO work_schedule_type VALUES(4,'По присутствию');
CREATE TABLE `event` (
  `id` integer NOT NULL primary key autoincrement,
  `time_label` datetime DEFAULT NULL,
  `event_type` integer DEFAULT NULL,
  `device_id` integer DEFAULT NULL,
  `resource_type` integer DEFAULT NULL,
  `resource_number` integer DEFAULT NULL,
  `data` integer DEFAULT NULL,
  `identifier` bigint  DEFAULT NULL,
  `user_id` integer DEFAULT NULL,
  `operator_id` integer DEFAULT NULL,
  `access_zone_id1` integer DEFAULT NULL,
  `access_zone_id2` integer DEFAULT NULL,
  `description` mediumtext,
  `db_time_label` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
, comment varchar(255) null);
CREATE TABLE `user_fingerprint` (
  `id` integer NOT NULL primary key autoincrement,
  `user_id` integer DEFAULT NULL,
  `template_type` integer DEFAULT '2',
  `template0` mediumtext,
  `template1` mediumtext,
  `image0` mediumtext,
  `image1` mediumtext,
  `number` integer DEFAULT NULL,
  `name` varchar(150)  DEFAULT NULL,
  CONSTRAINT `user_fingerprint_user_id_fk` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
);
CREATE TABLE IF NOT EXISTS "event_type"
(
	id integer not null
		constraint event_type_1_pk
			primary key autoincrement,
	name varchar not null,
	event_subcategory_id integer not null,
	event_resource_type_id integer,
	event_resource_table varchar,
	event_resource_field varchar
);
INSERT INTO event_type VALUES(-100,'Изменение учетных данных пользователя',10000,NULL,NULL,NULL);
INSERT INTO event_type VALUES(1,'Идентификатор не зарегистрирован',1,1,NULL,NULL);
INSERT INTO event_type VALUES(2,'Идентификатор запрещен',1,1,NULL,NULL);
INSERT INTO event_type VALUES(3,'Идентификатор из "стоп-листа"',1,1,NULL,NULL);
INSERT INTO event_type VALUES(4,'Идентификатор просрочен',1,1,NULL,NULL);
INSERT INTO event_type VALUES(8,'Запрет прохода',1,1,NULL,NULL);
INSERT INTO event_type VALUES(11,'Предъявление запрещенной карты: нарушение РКД',1,1,NULL,NULL);
INSERT INTO event_type VALUES(12,'Запрет прохода от ВВУ',1,1,NULL,NULL);
INSERT INTO event_type VALUES(14,'Запрет прохода по команде оператора: ',1,1,NULL,NULL);
INSERT INTO event_type VALUES(15,'Запрет прохода по команде от ДУ',1,1,NULL,NULL);
INSERT INTO event_type VALUES(16,'Отказ от прохода: ',1,1,NULL,NULL);
INSERT INTO event_type VALUES(17,'Проход по идентификатору',1,1,NULL,NULL);
INSERT INTO event_type VALUES(23,'Проход с подтверждением от ДУ',1,1,NULL,NULL);
INSERT INTO event_type VALUES(27,'Проход с подтверждением от верификации: ',1,1,NULL,NULL);
INSERT INTO event_type VALUES(31,'ИУ не закрыто после прохода по идентификатору: ',1,1,NULL,NULL);
INSERT INTO event_type VALUES(41,'Попытка взятия ОЗ (невозможно взять) по идентификатору: отказ от постановки',2,6,NULL,NULL);
INSERT INTO event_type VALUES(47,'Попытка снятия ОЗ (невозможно снять) по идентификатору: отказ от снятия',2,6,NULL,NULL);
INSERT INTO event_type VALUES(69,'Корпус извещателя вскрыт',3,7,NULL,NULL);
INSERT INTO event_type VALUES(70,'Корпус извещателя закрыт: ',3,7,NULL,NULL);
INSERT INTO event_type VALUES(96,'Активизация входа',4,4,NULL,NULL);
INSERT INTO event_type VALUES(97,'Нормализация входа',4,4,NULL,NULL);
INSERT INTO event_type VALUES(98,'Активизация выхода',4,5,NULL,NULL);
INSERT INTO event_type VALUES(99,'Нормализация выхода',4,5,NULL,NULL);
INSERT INTO event_type VALUES(100,'Запуск задержки активизации выхода',4,5,NULL,NULL);
INSERT INTO event_type VALUES(101,'КЗ на выходе: Только для выходов с контролем состояния',4,5,NULL,NULL);
INSERT INTO event_type VALUES(102,'Обрыв на выходе: Только для выходов с контролем состояния',4,5,NULL,NULL);
INSERT INTO event_type VALUES(103,'Активация выхода невозможна, причина - КЗ: Только для выходов с контролем состояния',4,5,NULL,NULL);
INSERT INTO event_type VALUES(104,'Восстановление выхода: Только для выходов с контролем состояния. Восстановление линии после КЗ или обрыва.',4,5,NULL,NULL);
INSERT INTO event_type VALUES(105,'FireAlarm on',4,4,NULL,NULL);
INSERT INTO event_type VALUES(106,'FireAlarm off',4,4,NULL,NULL);
INSERT INTO event_type VALUES(112,'Проход по команде от ДУ ',5,1,NULL,NULL);
INSERT INTO event_type VALUES(113,'Проход по команде от ПК',5,1,NULL,NULL);
INSERT INTO event_type VALUES(114,'Несанкционированный проход через ИУ (взлом ИУ)',5,1,NULL,NULL);
INSERT INTO event_type VALUES(117,'ИУ разблокировано',5,2,NULL,NULL);
INSERT INTO event_type VALUES(118,'ИУ заблокировано',5,2,NULL,NULL);
INSERT INTO event_type VALUES(119,'Проход по команде ИК-пульта',5,1,NULL,NULL);
INSERT INTO event_type VALUES(129,'Включение питания контроллера',6,8,NULL,NULL);
INSERT INTO event_type VALUES(130,'Выключение питания контроллера',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(131,'Нарушение связи',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(132,'Восстановление связи',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(133,'Переполнение журнала регистрации',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(134,'Очистка журнала регистрации',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(136,'Перезапуск контроллера: WatchDog',6,8,NULL,NULL);
INSERT INTO event_type VALUES(138,'Переполнение списка идентификаторов',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(145,'Изменение конфигурации физического контакта',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(149,'Корпус контроллера открыт',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(150,'Корпус контроллера закрыт',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(155,'Тревога по команде ИК-пульта',6,2,NULL,NULL);
INSERT INTO event_type VALUES(159,'Неисправность ИП: Формируется встроенным АЦП при выходе напряжения питания за рабочий диапазон',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(160,'Восстановление ИП: При условии, что напряжение питания в рабочем диапазоне.',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(161,'Тревога: От Генератора тревоги',6,2,NULL,NULL);
INSERT INTO event_type VALUES(162,'Сброс тревоги: По команде от ПО',6,2,NULL,NULL);
INSERT INTO event_type VALUES(163,'Автономный сброс тревоги: Кнопкой "Сброс"',6,2,NULL,NULL);
INSERT INTO event_type VALUES(245,'Тестирование прибора начато',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(246,'Тестирование ШС начато',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(248,'Неисправность ИП +18В: Формируется встроенным АЦП при выходе напряжения питания ШС за рабочий диапазон',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(249,'Пропадание связи с контроллером 2-го уровня',6,1,NULL,NULL);
INSERT INTO event_type VALUES(264,'Запрет прохода: несоответствие текущему местоположению',1,1,NULL,NULL);
INSERT INTO event_type VALUES(273,'Проход по идентификатору: с несоответствием текущему местоположению',1,1,NULL,NULL);
INSERT INTO event_type VALUES(279,'Проход с подтверждением от ДУ: с несоответствием текущему местоположению',1,1,NULL,NULL);
INSERT INTO event_type VALUES(283,'Проход с подтверждением от верификации: с несоответствием текущему местоположению',1,1,NULL,NULL);
INSERT INTO event_type VALUES(288,'ОЗ взята на охрану по идентификатору: ОЗ перешла в режим ОХРАНА',2,6,NULL,NULL);
INSERT INTO event_type VALUES(289,'ОЗ снята с охраны по идентификатору: ОЗ перешла в режим СНЯТА',2,6,NULL,NULL);
INSERT INTO event_type VALUES(290,'Попытка взятия ОЗ (невозможно взять) по идентификатору: несоответствие текущему местоположению',2,6,NULL,NULL);
INSERT INTO event_type VALUES(298,'Попытка снятия ОЗ (невозможно снять) по идентификатору: несоответствие текущему местоположению',2,6,NULL,NULL);
INSERT INTO event_type VALUES(305,'ОЗ взята на охрану по идентификатору с подтверждением: ОЗ перешла в режим ОХРАНА',2,6,NULL,NULL);
INSERT INTO event_type VALUES(306,'ОЗ снята с охраны по идентификатору с подтверждением: ОЗ перешла в режим СНЯТА',2,6,NULL,NULL);
INSERT INTO event_type VALUES(307,'ОЗ взята на охрану по команде оператора: ОЗ перешла в режим ОХРАНА',2,6,NULL,NULL);
INSERT INTO event_type VALUES(308,'ОЗ снята с охраны по команде оператора: ОЗ перешла в режим СНЯТА',2,6,NULL,NULL);
INSERT INTO event_type VALUES(312,'Тихая тревога по ОЗ: ОЗ перешла в режим ТРЕВОГА, в том числе и если стоит "тревога при невзятии"',2,6,NULL,NULL);
INSERT INTO event_type VALUES(313,'Тревога по ОЗ: ОЗ перешла в режим ТРЕВОГА, в том числе и если стоит "тревога при невзятии"',2,6,NULL,NULL);
INSERT INTO event_type VALUES(314,'Сброс тревоги по ОЗ',2,6,NULL,NULL);
INSERT INTO event_type VALUES(315,'Взятие ОЗ на охрану по идентификатору: ОЗ перешла в режим ВЗЯТИЕ',2,6,NULL,NULL);
INSERT INTO event_type VALUES(316,'Взятие ОЗ на охрану по команде оператора: ОЗ перешла в режим ВЗЯТИЕ',2,6,NULL,NULL);
INSERT INTO event_type VALUES(323,'ОШС отключен',3,7,NULL,NULL);
INSERT INTO event_type VALUES(395,'Неисправность контроллера: память FRAM',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(400,'Форматирование памяти: журнал событий',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(409,'Изменение режима работы по команде оператора: режим "Открыто"',6,1,NULL,NULL);
INSERT INTO event_type VALUES(410,'Изменение режима работы по команде ИК-пульта: режим "Открыто"',6,1,NULL,NULL);
INSERT INTO event_type VALUES(414,'Изменение режима работы с режима "Охрана" по идентификатору: режим "Открыто"',6,1,NULL,NULL);
INSERT INTO event_type VALUES(501,'Тестирование прибора завершено успешно',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(502,'Тестирование ШС завершено',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(504,'Восстановление ИП +18В: Формируется встроенным АЦП при возвращении напряжения питания ШС в рабочий диапазон',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(505,'Восстановление связи с контроллером 2-го уровня',6,1,NULL,NULL);
INSERT INTO event_type VALUES(520,'Запрет прохода: несоответствие режиму доступа',1,1,NULL,NULL);
INSERT INTO event_type VALUES(529,'Проход по идентификатору: с несоответствием временным критериям доступа',1,1,NULL,NULL);
INSERT INTO event_type VALUES(535,'Проход с подтверждением от ДУ: с несоответствием временным критериям доступа',1,1,NULL,NULL);
INSERT INTO event_type VALUES(539,'Проход с подтверждением от верификации: с несоответствием временным критериям доступа',1,1,NULL,NULL);
INSERT INTO event_type VALUES(546,'Попытка взятия ОЗ (невозможно взять) по идентификатору: несоответствие временных критериев доступа',2,6,NULL,NULL);
INSERT INTO event_type VALUES(554,'Попытка снятия ОЗ (невозможно снять) по идентификатору: несоответствие временных критериев доступа',2,6,NULL,NULL);
INSERT INTO event_type VALUES(577,'ИУ взят на охрану: ИУ перешел в режим ОХРАНА',3,2,NULL,NULL);
INSERT INTO event_type VALUES(578,'Взятие ИУ на охрану: ИУ перешел в режим ВЗЯТИЕ',3,2,NULL,NULL);
INSERT INTO event_type VALUES(580,'ИУ снят с охраны: ИУ перешел в режим СНЯТ, в том числе и если стоит "снять при невзятии"',3,2,NULL,NULL);
INSERT INTO event_type VALUES(585,'Нарушение ИУ, режим ТРЕВОГА: ИУ перешел в режим ТРЕВОГА',3,2,NULL,NULL);
INSERT INTO event_type VALUES(591,'Сброс тревоги ИУ',3,2,NULL,NULL);
INSERT INTO event_type VALUES(645,'Сбой физического уровня Ethernet',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(651,'Неисправность контроллера: память DataFlash',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(656,'Форматирование памяти: список карт',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(665,'Изменение режима работы по команде оператора: режим "Контроль"',6,1,NULL,NULL);
INSERT INTO event_type VALUES(666,'Изменение режима работы по команде ИК-пульта: режим "Контроль"',6,1,NULL,NULL);
INSERT INTO event_type VALUES(670,'Изменение режима работы с режима "Охрана" по идентификатору: режим "Контроль"',6,1,NULL,NULL);
INSERT INTO event_type VALUES(757,'Тестирование прибора выявило неисправности',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(761,'Неисправность контроллера 2-го уровня',6,1,NULL,NULL);
INSERT INTO event_type VALUES(776,'Запрет прохода: несоответствие временным критериям доступа и текущему местоположению',1,1,NULL,NULL);
INSERT INTO event_type VALUES(785,'Проход по идентификатору: несоответствие временным критериям доступа и текущему местоположению',1,1,NULL,NULL);
INSERT INTO event_type VALUES(791,'Проход с подтверждением от ДУ: несоответствие временным критериям доступа и текущему местоположению',1,1,NULL,NULL);
INSERT INTO event_type VALUES(795,'Проход с подтверждением от верификации: несоответствие временным критериям доступа и текущему местоположению',1,1,NULL,NULL);
INSERT INTO event_type VALUES(802,'Попытка взятия ОЗ (невозможно взять) по идентификатору: несоответствие временным критериям доступа и текущему местоположению',2,6,NULL,NULL);
INSERT INTO event_type VALUES(810,'Попытка снятия ОЗ (невозможно снять) по идентификатору: несоответствие временным критериям доступа и текущему местоположению',2,6,NULL,NULL);
INSERT INTO event_type VALUES(1029,'Предъявлена комиссионирующая карта: ',1,1,NULL,NULL);
INSERT INTO event_type VALUES(1032,'Запрет прохода: нарушение комиссионирования',1,1,NULL,NULL);
INSERT INTO event_type VALUES(1041,'Проход по идентификатору: с нарушением комиссионирования',1,1,NULL,NULL);
INSERT INTO event_type VALUES(1058,'Попытка взятия ОЗ (невозможно взять) по идентификатору: нарушение комиссионирования',2,6,NULL,NULL);
INSERT INTO event_type VALUES(1066,'Попытка снятия ОЗ (невозможно снять) по идентификатору: нарушение комиссионирования',2,6,NULL,NULL);
INSERT INTO event_type VALUES(1088,'ОШС не взят на охрану: ОШС перешел в режим АВТОПЕРЕВЗЯТИЕ',3,7,NULL,NULL);
INSERT INTO event_type VALUES(1089,'ОШС взят на охрану: ОШС перешел в режим ОХРАНА',3,7,NULL,NULL);
INSERT INTO event_type VALUES(1090,'Взятие ОШС на охрану: ОШС перешел в режим ВЗЯТИЕ',3,7,NULL,NULL);
INSERT INTO event_type VALUES(1092,'ОШС снят с охраны: ОШС перешел в режим СНЯТ, в том числе и если стоит "снять при невзятии"',3,7,NULL,NULL);
INSERT INTO event_type VALUES(1095,'Нарушение снятого ОШС',3,7,NULL,NULL);
INSERT INTO event_type VALUES(1096,'Нормализация снятого ОШС',3,7,NULL,NULL);
INSERT INTO event_type VALUES(1097,'Нарушение ОШС, режим ТРЕВОГА: ОШС перешел в режим ТРЕВОГА, в том числе и если стоит "тревога при невзятии"',3,7,NULL,NULL);
INSERT INTO event_type VALUES(1098,'Нарушение ОШС, режим ТРЕВОГА с опцией тихая: ОШС перешел в режим ТРЕВОГА, в том числе и если стоит "тревога при невзятии"',3,7,NULL,NULL);
INSERT INTO event_type VALUES(1099,'Нарушение ОШС в режиме ТРЕВОГА',3,7,NULL,NULL);
INSERT INTO event_type VALUES(1100,'Восстановление ОШС в режиме ТРЕВОГА',3,7,NULL,NULL);
INSERT INTO event_type VALUES(1103,'Сброс тревоги ОШС',3,7,NULL,NULL);
INSERT INTO event_type VALUES(1168,'Форматирование памяти: конфигурация',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(1177,'Изменение режима работы по команде оператора: режим "Совещание"',6,1,NULL,NULL);
INSERT INTO event_type VALUES(1178,'Изменение режима работы по команде ИК-пульта: режим "Совещание"',6,1,NULL,NULL);
INSERT INTO event_type VALUES(1182,'Изменение режима работы с режима "Охрана" по идентификатору: режим "Совещание"',6,1,NULL,NULL);
INSERT INTO event_type VALUES(1273,'Восстановление после неисправности контроллера 2-го уровня',6,1,NULL,NULL);
INSERT INTO event_type VALUES(1297,'Проход по идентификатору: с несоответствием текущему местоположению и с нарушением комиссионирования',1,1,NULL,NULL);
INSERT INTO event_type VALUES(1553,'Проход по идентификатору: с несоответствием временным критериям доступа и с нарушением комиссионирования',1,1,NULL,NULL);
INSERT INTO event_type VALUES(1809,'Проход по идентификатору: несоответствие временным критериям доступа и текущему местоположению и с нарушением комиссионирования',1,1,NULL,NULL);
INSERT INTO event_type VALUES(2056,'Запрет прохода: отказ в подтверждении прохода от верификации',1,1,NULL,NULL);
INSERT INTO event_type VALUES(2065,'Проход по идентификатору: при отказе в подтверждении прохода от верификации',1,1,NULL,NULL);
INSERT INTO event_type VALUES(2082,'Попытка взятия ОЗ (невозможно взять) по идентификатору: отказ в подтверждении взятия от верификации',2,6,NULL,NULL);
INSERT INTO event_type VALUES(2090,'Попытка снятия ОЗ (невозможно снять) по идентификатору: отказ в подтверждении снятия от верификации',2,6,NULL,NULL);
INSERT INTO event_type VALUES(2187,'Неисправность контроллера: часы RTC',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(2192,'Форматирование памяти: прошивка',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(2201,'Изменение режима работы по команде оператора: режим "Закрыто"',6,1,NULL,NULL);
INSERT INTO event_type VALUES(2202,'Изменение режима работы по команде ИК-пульта: режим "Закрыто"',6,1,NULL,NULL);
INSERT INTO event_type VALUES(2321,'Проход по идентификатору: с несоответствием текущему местоположению и при отказе в подтверждении прохода от верификации',1,1,NULL,NULL);
INSERT INTO event_type VALUES(2577,'Проход по идентификатору: с несоответствием временным критериям доступа и при отказе в подтверждении прохода от верификации',1,1,NULL,NULL);
INSERT INTO event_type VALUES(2833,'Проход по идентификатору: несоответствие временным критериям доступа и текущему местоположению и при отказе в подтверждении прохода от верификации',1,1,NULL,NULL);
INSERT INTO event_type VALUES(4113,'Проход с подтверждением от ВВУ',1,1,NULL,NULL);
INSERT INTO event_type VALUES(4130,'Попытка взятия ОЗ (невозможно взять) по идентификатору: нарушение состояния ресурса ИУ',2,6,NULL,NULL);
INSERT INTO event_type VALUES(4149,'Попытка взятия ОЗ (невозможно взять) по команде оператора: нарушение состояния ресурса ИУ',2,6,NULL,NULL);
INSERT INTO event_type VALUES(4235,'Неисправность контроллера: шина I2C',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(4240,'Форматирование памяти: текущие установки (режимы работы и т.д.)',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(4249,'Изменение режима работы по команде оператора: режим "Охрана"',6,1,NULL,NULL);
INSERT INTO event_type VALUES(4253,'Изменение режима работы на режим "Охрана" по идентификатору: режим "Охрана"',6,1,NULL,NULL);
INSERT INTO event_type VALUES(4369,'Проход с подтверждением от ВВУ: с несоответствием текущему местоположению',1,1,NULL,NULL);
INSERT INTO event_type VALUES(4625,'Проход с подтверждением от ВВУ: с несоответствием временным критериям доступа',1,1,NULL,NULL);
INSERT INTO event_type VALUES(4881,'Проход с подтверждением от ВВУ: с несоответствием временным критериям доступа и текущему местоположению',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5000,'Ошибка конфигурации - группа на охране или в тревоге',15,NULL,NULL,NULL);
INSERT INTO event_type VALUES(5001,'Ошибка конфигурации - ресурс на охране или в тревоге',15,7,NULL,NULL);
INSERT INTO event_type VALUES(5002,'Ошибка управления - ресурс на охране',15,7,NULL,NULL);
INSERT INTO event_type VALUES(5003,'Ошибка управления - ресурс ставится охрану',15,7,NULL,NULL);
INSERT INTO event_type VALUES(5004,'Ошибка управления - контроллер форматируется',15,NULL,NULL,NULL);
INSERT INTO event_type VALUES(5005,'Ошибка конфигурации - превышение максимального количества карт сотрудников',15,NULL,NULL,NULL);
INSERT INTO event_type VALUES(5006,'Изменение конфигурации устройства',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5007,'Запрет прохода: неисправны датчики ИУ',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5008,'Запрет прохода: смена РКД',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5009,'Запрет прохода: таймаут верификации',12,NULL,NULL,NULL);
INSERT INTO event_type VALUES(5010,'Очистка событий журнала регистрации',1,NULL,NULL,NULL);
INSERT INTO event_type VALUES(5011,'Ошибка записи отпечатка в контроллер',15,NULL,NULL,NULL);
INSERT INTO event_type VALUES(5012,'Ошибка записи в базу данных контроллера',15,NULL,NULL,NULL);
INSERT INTO event_type VALUES(5100,'Дверь открыта',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5101,'Дверь закрыта',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5102,'Дверь разблокирована по команде с ПК',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5103,'Дверь заблокирована  по команде с ПК',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5104,'Отпечаток не распознан',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5105,'Ошибка авторизации',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5106,'Дверь не закрыта после прохода',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5107,'ИУ разблокировано',5,13,NULL,NULL);
INSERT INTO event_type VALUES(5108,'ИУ заблокировано',5,13,NULL,NULL);
INSERT INTO event_type VALUES(5109,'Вход в шлюз',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5110,'Выход из шлюза',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5111,'Выход из шлюза запрещён: некорректный идентификатор',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5112,'Выход из шлюза запрещён по команде от ДУ',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5113,'Выход из шлюза запрещён по команде оператора ПК',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5114,'Доступ запрещён: направление прохода заблокировано другим считывателем',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5115,'Превышение времени пребывания в шлюзе',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5116,'Нарушение режима доступа в шлюз',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5117,'Вход в шлюз по команде от ДУ',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5118,'Вход в шлюз по команде оператора ПК',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5119,'Выход из шлюза по команде от ДУ',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5120,'Выход из шлюза по команде оператора ПК',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5121,'Выход из шлюза запрещён по команде от ДУ',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5122,'Выход из шлюза запрещён по команде оператора ПК',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5123,'Превышение времени пребывания в шлюзе',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5124,'Нарушение режима доступа в шлюз',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5200,'Проход через мобильный терминал',1,1,NULL,NULL);
INSERT INTO event_type VALUES(5201,'Запрет прохода через мобильный терминал: нарушение времени',1,1,NULL,NULL);
INSERT INTO event_type VALUES(8209,'Проход с подтверждением от ПДУ/верификации',1,1,NULL,NULL);
INSERT INTO event_type VALUES(8226,'Попытка взятия ОЗ (невозможно взять) по идентификатору: нарушение состояния ресурса ШС (если стоит "снять при невзятии")',2,6,NULL,NULL);
INSERT INTO event_type VALUES(8245,'Попытка взятия ОЗ (невозможно взять) по команде оператора: нарушение состояния ресурса ШС (если стоит "снять при невзятии")',2,6,NULL,NULL);
INSERT INTO event_type VALUES(8465,'Проход с подтверждением от ПДУ/верификации: с несоответствием текущему местоположению',1,1,NULL,NULL);
INSERT INTO event_type VALUES(8721,'Проход с подтверждением от ПДУ/верификации: с несоответствием временным критериям доступа',1,1,NULL,NULL);
INSERT INTO event_type VALUES(8977,'Проход с подтверждением от ПДУ/верификации: с несоответствием временным критериям доступа и текущему местоположению',1,1,NULL,NULL);
INSERT INTO event_type VALUES(12305,'Проход с подтверждением от ВВУ и далее ПДУ/верификации',1,1,NULL,NULL);
INSERT INTO event_type VALUES(12561,'Проход с подтверждением от ВВУ и далее ПДУ/верификации: с несоответствием текущему местоположению',1,1,NULL,NULL);
INSERT INTO event_type VALUES(12817,'Проход с подтверждением от ВВУ и далее ПДУ/верификации: с несоответствием временным критериям доступа',1,1,NULL,NULL);
INSERT INTO event_type VALUES(13073,'Проход с подтверждением от ВВУ и далее ПДУ/верификации: с несоответствием временным критериям доступа и текущему местоположению',1,1,NULL,NULL);
INSERT INTO event_type VALUES(14000,'Соединение с контроллером установлено',9,NULL,NULL,NULL);
INSERT INTO event_type VALUES(14001,'Соединение с контроллером разорвано',9,NULL,NULL,NULL);
INSERT INTO event_type VALUES(14002,'Сессия с контроллером открыта',9,NULL,NULL,NULL);
INSERT INTO event_type VALUES(14003,'Объект контроллер создан',9,NULL,NULL,NULL);
INSERT INTO event_type VALUES(14004,'Объект контроллер удалён',9,NULL,NULL,NULL);
INSERT INTO event_type VALUES(14005,'Сессия с контроллером не установлена и контроллер деактивирован: неверный пароль',9,NULL,NULL,NULL);
INSERT INTO event_type VALUES(14050,'Соединение с базой данных установлено',8,NULL,NULL,NULL);
INSERT INTO event_type VALUES(14051,'Соединение с базой данных разорвано',8,NULL,NULL,NULL);
INSERT INTO event_type VALUES(14100,'Соединение с web-сервером установлено',10,NULL,NULL,NULL);
INSERT INTO event_type VALUES(14101,'Соединение с web-сервером разорвано',10,NULL,NULL,NULL);
INSERT INTO event_type VALUES(14280,'Сервер оборудования запущен',12,NULL,NULL,NULL);
INSERT INTO event_type VALUES(14281,'Сервер оборудования остановлен',12,NULL,NULL,NULL);
INSERT INTO event_type VALUES(15000,'Попытка ввода лицензионного ключа',13,11,NULL,NULL);
INSERT INTO event_type VALUES(15001,'Попытка обновления лицензий',13,11,NULL,NULL);
INSERT INTO event_type VALUES(15002,'Установлен новый шаблон',6,NULL,NULL,NULL);
INSERT INTO event_type VALUES(15003,'Изменение конфигурации входа',6,4,NULL,NULL);
INSERT INTO event_type VALUES(15004,'Изменение конфигурации выхода',6,5,NULL,NULL);
INSERT INTO event_type VALUES(16000,'Установить РКД «Открыто»: Выполнено',14,1,NULL,NULL);
INSERT INTO event_type VALUES(16001,'Установить РКД «Контроль»: Выполнено',14,1,NULL,NULL);
INSERT INTO event_type VALUES(16002,'Установить РКД «Совещание»: Выполнено',14,1,NULL,NULL);
INSERT INTO event_type VALUES(16003,'Установить РКД «Закрыто»: Выполнено',14,1,NULL,NULL);
INSERT INTO event_type VALUES(16004,'Установить РКД «Открыто»: Не выполнено',14,1,NULL,NULL);
INSERT INTO event_type VALUES(16005,'Установить РКД «Контроль»: Не выполнено',14,1,NULL,NULL);
INSERT INTO event_type VALUES(16006,'Установить РКД «Совещание»: Не выполнено',14,1,NULL,NULL);
INSERT INTO event_type VALUES(16007,'Установить РКД «Закрыто»: Не выполнено',14,1,NULL,NULL);
INSERT INTO event_type VALUES(16010,'Открыть (разблокировать) ИУ: Выполнено',14,1,NULL,NULL);
INSERT INTO event_type VALUES(16011,'Закрыть (заблокировать) ИУ: Выполнено',14,1,NULL,NULL);
INSERT INTO event_type VALUES(16012,'Открыть (разблокировать) ИУ: Не выполнено',14,1,NULL,NULL);
INSERT INTO event_type VALUES(16013,'Закрыть (заблокировать) ИУ: Не выполнено',14,1,NULL,NULL);
INSERT INTO event_type VALUES(16020,'Нормализовать выход: Выполнено',14,5,NULL,NULL);
INSERT INTO event_type VALUES(16021,'Активизировать выход: Выполнено',14,5,NULL,NULL);
INSERT INTO event_type VALUES(16022,'Нормализовать выход: Не выполнено',14,5,NULL,NULL);
INSERT INTO event_type VALUES(16023,'Активизировать выход: Не выполнено',14,5,NULL,NULL);
INSERT INTO event_type VALUES(16030,'Сбросить тревогу: Выполнено',14,2,NULL,NULL);
INSERT INTO event_type VALUES(16031,'Поднять тревогу: Выполнено',14,2,NULL,NULL);
INSERT INTO event_type VALUES(16032,'Сбросить тревогу: Не выполнено',14,2,NULL,NULL);
INSERT INTO event_type VALUES(16033,'Поднять тревогу: Не выполнено',14,2,NULL,NULL);
INSERT INTO event_type VALUES(16040,'Снять тревогу с зоны: Выполнено',14,6,NULL,NULL);
INSERT INTO event_type VALUES(16041,'Снять тревогу с зоны: Не выполнено',14,6,NULL,NULL);
INSERT INTO event_type VALUES(16050,'Снять зону с охраны: Выполнено',14,6,NULL,NULL);
INSERT INTO event_type VALUES(16051,'Поставить зону на охрану: Выполнено',14,6,NULL,NULL);
INSERT INTO event_type VALUES(16052,'Снять зону с охраны: Не выполнено',14,6,NULL,NULL);
INSERT INTO event_type VALUES(16053,'Поставить зону на охрану: Не выполнено',14,6,NULL,NULL);
INSERT INTO event_type VALUES(16055,'Очистить пространственные зоны для идентификаторов: Выполнено',14,2,NULL,NULL);
INSERT INTO event_type VALUES(16056,'Очистить пространственные зоны для идентификаторов: Не выполнено',14,2,NULL,NULL);
INSERT INTO event_type VALUES(65536,'Верификация: проход посетителя',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65537,'Верификация: проход посетителя и нарушение времени',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65538,'Верификация: проход посетителя и нарушение местоположения',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65539,'Верификация: проход посетителя и нарушение местоположения и нарушение времени',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65540,'Верификация: снятие верификации в связи с несанкционированным проходом',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65541,'Верификация: снятие верификации в связи с несанкционированным проходом',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65542,'Верификация: снятие верификации в связи с несанкционированным проходом',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65543,'Верификация: снятие верификации в связи с несанкционированным проходом',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65544,'Верификация: проход сотрудника',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65545,'Верификация: проход сотрудника и нарушение времени',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65546,'Верификация: проход сотрудника и нарушение местоположения',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65547,'Верификация: проход сотрудника и нарушение местоположения и нарушение времени',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65548,'Верификация: снятие верификации в связи с несанкционированным проходом',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65549,'Верификация: снятие верификации в связи с несанкционированным проходом',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65550,'Верификация: снятие верификации в связи с несанкционированным проходом',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65551,'Верификация: снятие верификации в связи с несанкционированным проходом',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65552,'Верификация: постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65553,'Верификация: постановка на «Охрану» и нарушение времени',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65554,'Верификация: постановка на «Охрану» и нарушение местоположения',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65555,'Верификация: постановка на «Охрану» и нарушение местоположения и нарушение времени',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65556,'Верификация: снятие верификации в связи с несанкционированным проходом',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65557,'Верификация: снятие верификации в связи с несанкционированным проходом',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65558,'Верификация: снятие верификации в связи с несанкционированным проходом',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65559,'Верификация: снятие верификации в связи с несанкционированным проходом',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65560,'Верификация: снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65561,'Верификация: снятие с «Охраны» и нарушение времени',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65562,'Верификация: снятие с «Охраны» и нарушение местоположения',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65563,'Верификация: снятие с «Охраны» и нарушение местоположения и нарушение времени',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65564,'Верификация: снятие верификации в связи с несанкционированным проходом',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65565,'Верификация: снятие верификации в связи с несанкционированным проходом',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65566,'Верификация: снятие верификации в связи с несанкционированным проходом',11,1,NULL,NULL);
INSERT INTO event_type VALUES(65567,'Верификация: снятие верификации в связи с несанкционированным проходом',11,1,NULL,NULL);
INSERT INTO event_type VALUES(70000,'Регистрация верифицирующего устройства',12,NULL,NULL,NULL);
INSERT INTO event_type VALUES(131073,'Индикация: проход посетителя',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131074,'Индикация: проход сотрудника и нарушение времени',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131075,'Индикация: проход посетителя и нарушение времени',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131076,'Индикация: проход сотрудника и нарушение местоположения',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131077,'Индикация: проход посетителя и нарушение местоположения',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131078,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131079,'Индикация: проход посетителя и нарушение времени и нарушение местоположения',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131080,'Индикация: проход сотрудника и нарушение режима доступа',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131081,'Индикация: проход посетителя и нарушение режима доступа',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131082,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131083,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131084,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131085,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131086,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131087,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131088,'Индикация: проход сотрудника и разрешение прохода',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131089,'Индикация: проход посетителя и разрешение прохода',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131090,'Индикация: проход сотрудника и нарушение времени и разрешение прохода',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131091,'Индикация: проход посетителя и нарушение времени и разрешение прохода',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131092,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131093,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131094,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131095,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131096,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131097,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131098,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131099,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131100,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131101,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131102,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131103,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131104,'Индикация: проход сотрудника и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131105,'Индикация: проход посетителя и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131106,'Индикация: проход сотрудника и нарушение времени и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131107,'Индикация: проход посетителя и нарушение времени и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131108,'Индикация: проход сотрудника и нарушение местоположения и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131109,'Индикация: проход посетителя и нарушение местоположения и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131110,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131111,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131112,'Индикация: проход сотрудника и нарушение режима доступа и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131113,'Индикация: проход посетителя и нарушение режима доступа и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131114,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131115,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131116,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131117,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131118,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131119,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131120,'Индикация: проход сотрудника и разрешение прохода и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131121,'Индикация: проход посетителя и разрешение прохода и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131122,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131123,'Индикация: проход посетителя и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131124,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131125,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131126,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131127,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131128,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131129,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131130,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131131,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131132,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131133,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131134,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131135,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131136,'Индикация: проход сотрудника и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131137,'Индикация: проход посетителя и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131138,'Индикация: проход сотрудника и нарушение времени и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131139,'Индикация: проход посетителя и нарушение времени и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131140,'Индикация: проход сотрудника и нарушение местоположения и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131141,'Индикация: проход посетителя и нарушение местоположения и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131142,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131143,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131144,'Индикация: проход сотрудника и нарушение режима доступа и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131145,'Индикация: проход посетителя и нарушение режима доступа и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131146,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131147,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131148,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131149,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131150,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131151,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131152,'Индикация: проход сотрудника и разрешение прохода и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131153,'Индикация: проход посетителя и разрешение прохода и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131154,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131155,'Индикация: проход посетителя и нарушение времени и разрешение прохода и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131156,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131157,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131158,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131159,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131160,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131161,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131162,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131163,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131164,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131165,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131166,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131167,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131168,'Индикация: проход сотрудника и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131169,'Индикация: проход посетителя и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131170,'Индикация: проход сотрудника и нарушение времени и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131171,'Индикация: проход посетителя и нарушение времени и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131172,'Индикация: проход сотрудника и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131173,'Индикация: проход посетителя и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131174,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131175,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131176,'Индикация: проход сотрудника и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131177,'Индикация: проход посетителя и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131178,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131179,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131180,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131181,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131182,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131183,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131184,'Индикация: проход сотрудника и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131185,'Индикация: проход посетителя и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131186,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131187,'Индикация: проход посетителя и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131188,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131189,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131190,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131191,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131192,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131193,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131194,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131195,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131196,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131197,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131198,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131199,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131200,'Индикация: проход сотрудника и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131201,'Индикация: проход посетителя и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131202,'Индикация: проход сотрудника и нарушение времени и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131203,'Индикация: проход посетителя и нарушение времени и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131204,'Индикация: проход сотрудника и нарушение местоположения и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131205,'Индикация: проход посетителя и нарушение местоположения и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131206,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131207,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131208,'Индикация: проход сотрудника и нарушение режима доступа и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131209,'Индикация: проход посетителя и нарушение режима доступа и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131210,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131211,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131212,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131213,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131214,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131215,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131216,'Индикация: проход сотрудника и разрешение прохода и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131217,'Индикация: проход посетителя и разрешение прохода и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131218,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131219,'Индикация: проход посетителя и нарушение времени и разрешение прохода и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131220,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131221,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131222,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131223,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131224,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131225,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131226,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131227,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131228,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131229,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131230,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131231,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131232,'Индикация: проход сотрудника и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131233,'Индикация: проход посетителя и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131234,'Индикация: проход сотрудника и нарушение времени и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131235,'Индикация: проход посетителя и нарушение времени и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131236,'Индикация: проход сотрудника и нарушение местоположения и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131237,'Индикация: проход посетителя и нарушение местоположения и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131238,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131239,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131240,'Индикация: проход сотрудника и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131241,'Индикация: проход посетителя и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131242,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131243,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131244,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131245,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131246,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131247,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131248,'Индикация: проход сотрудника и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131249,'Индикация: проход посетителя и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131250,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131251,'Индикация: проход посетителя и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131252,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131253,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131254,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131255,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131256,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131257,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131258,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131259,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131260,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131261,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131262,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131263,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131264,'Индикация: проход сотрудника и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131265,'Индикация: проход посетителя и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131266,'Индикация: проход сотрудника и нарушение времени и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131267,'Индикация: проход посетителя и нарушение времени и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131268,'Индикация: проход сотрудника и нарушение местоположения и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131269,'Индикация: проход посетителя и нарушение местоположения и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131270,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131271,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131272,'Индикация: проход сотрудника и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131273,'Индикация: проход посетителя и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131274,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131275,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131276,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131277,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131278,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131279,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131280,'Индикация: проход сотрудника и разрешение прохода и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131281,'Индикация: проход посетителя и разрешение прохода и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131282,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131283,'Индикация: проход посетителя и нарушение времени и разрешение прохода и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131284,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131285,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131286,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131287,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131288,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131289,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131290,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131291,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131292,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131293,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131294,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131295,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131296,'Индикация: проход сотрудника и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131297,'Индикация: проход посетителя и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131298,'Индикация: проход сотрудника и нарушение времени и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131299,'Индикация: проход посетителя и нарушение времени и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131300,'Индикация: проход сотрудника и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131301,'Индикация: проход посетителя и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131302,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131303,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131304,'Индикация: проход сотрудника и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131305,'Индикация: проход посетителя и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131306,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131307,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131308,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131309,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131310,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131311,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131312,'Индикация: проход сотрудника и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131313,'Индикация: проход посетителя и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131314,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131315,'Индикация: проход посетителя и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131316,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131317,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131318,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131319,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131320,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131321,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131322,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131323,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131324,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131325,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131326,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131327,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны»',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131328,'Индикация: карта не зарегистрирована',11,1,NULL,NULL);
INSERT INTO event_type VALUES(131584,'Индикация: карта заблокирована',11,1,NULL,NULL);
INSERT INTO event_type VALUES(132096,'Индикация: карта в стоп-листе',11,1,NULL,NULL);
INSERT INTO event_type VALUES(133120,'Индикация: истек срок действия карты',11,1,NULL,NULL);
INSERT INTO event_type VALUES(135168,'Индикация: взлом ИУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(139264,'Индикация: разрешение прохода от ДУ',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147456,'Индикация: проход сотрудника и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147457,'Индикация: проход посетителя и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147458,'Индикация: проход сотрудника и нарушение времени и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147459,'Индикация: проход посетителя и нарушение времени и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147460,'Индикация: проход сотрудника и нарушение местоположения и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147461,'Индикация: проход посетителя и нарушение местоположения и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147462,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147463,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147464,'Индикация: проход сотрудника и нарушение режима доступа и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147465,'Индикация: проход посетителя и нарушение режима доступа и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147466,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147467,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147468,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147469,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147470,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147471,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147472,'Индикация: проход сотрудника и разрешение прохода и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147473,'Индикация: проход посетителя и разрешение прохода и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147474,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147475,'Индикация: проход посетителя и нарушение времени и разрешение прохода и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147476,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147477,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147478,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147479,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147480,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147481,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147482,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147483,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147484,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147485,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147486,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147487,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147488,'Индикация: проход сотрудника и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147489,'Индикация: проход посетителя и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147490,'Индикация: проход сотрудника и нарушение времени и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147491,'Индикация: проход посетителя и нарушение времени и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147492,'Индикация: проход сотрудника и нарушение местоположения и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147493,'Индикация: проход посетителя и нарушение местоположения и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147494,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147495,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147496,'Индикация: проход сотрудника и нарушение режима доступа и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147497,'Индикация: проход посетителя и нарушение режима доступа и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147498,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147499,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147500,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147501,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147502,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147503,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147504,'Индикация: проход сотрудника и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147505,'Индикация: проход посетителя и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147506,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147507,'Индикация: проход посетителя и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147508,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147509,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147510,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147511,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147512,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147513,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147514,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147515,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147516,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147517,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147518,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147519,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147520,'Индикация: проход сотрудника и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147521,'Индикация: проход посетителя и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147522,'Индикация: проход сотрудника и нарушение времени и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147523,'Индикация: проход посетителя и нарушение времени и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147524,'Индикация: проход сотрудника и нарушение местоположения и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147525,'Индикация: проход посетителя и нарушение местоположения и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147526,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147527,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147528,'Индикация: проход сотрудника и нарушение режима доступа и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147529,'Индикация: проход посетителя и нарушение режима доступа и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147530,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147531,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147532,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147533,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147534,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147535,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147536,'Индикация: проход сотрудника и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147537,'Индикация: проход посетителя и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147538,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147539,'Индикация: проход посетителя и нарушение времени и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147540,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147541,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147542,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147543,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147544,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147545,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147546,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147547,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147548,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147549,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147550,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147551,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147552,'Индикация: проход сотрудника и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147553,'Индикация: проход посетителя и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147554,'Индикация: проход сотрудника и нарушение времени и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147555,'Индикация: проход посетителя и нарушение времени и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147556,'Индикация: проход сотрудника и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147557,'Индикация: проход посетителя и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147558,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147559,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147560,'Индикация: проход сотрудника и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147561,'Индикация: проход посетителя и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147562,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147563,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147564,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147565,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147566,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147567,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147568,'Индикация: проход сотрудника и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147569,'Индикация: проход посетителя и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147570,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147571,'Индикация: проход посетителя и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147572,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147573,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147574,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147575,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147576,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147577,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147578,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147579,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147580,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147581,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147582,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147583,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147584,'Индикация: проход сотрудника и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147585,'Индикация: проход посетителя и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147586,'Индикация: проход сотрудника и нарушение времени и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147587,'Индикация: проход посетителя и нарушение времени и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147588,'Индикация: проход сотрудника и нарушение местоположения и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147589,'Индикация: проход посетителя и нарушение местоположения и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147590,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147591,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147592,'Индикация: проход сотрудника и нарушение режима доступа и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147593,'Индикация: проход посетителя и нарушение режима доступа и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147594,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147595,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147596,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147597,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147598,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147599,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147600,'Индикация: проход сотрудника и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147601,'Индикация: проход посетителя и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147602,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147603,'Индикация: проход посетителя и нарушение времени и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147604,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147605,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147606,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147607,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147608,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147609,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147610,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147611,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147612,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147613,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147614,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147615,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147616,'Индикация: проход сотрудника и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147617,'Индикация: проход посетителя и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147618,'Индикация: проход сотрудника и нарушение времени и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147619,'Индикация: проход посетителя и нарушение времени и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147620,'Индикация: проход сотрудника и нарушение местоположения и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147621,'Индикация: проход посетителя и нарушение местоположения и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147622,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147623,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147624,'Индикация: проход сотрудника и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147625,'Индикация: проход посетителя и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147626,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147627,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147628,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147629,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147630,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147631,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147632,'Индикация: проход сотрудника и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147633,'Индикация: проход посетителя и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147634,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147635,'Индикация: проход посетителя и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147636,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147637,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147638,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147639,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147640,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147641,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147642,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147643,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147644,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147645,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147646,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147647,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147648,'Индикация: проход сотрудника и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147649,'Индикация: проход посетителя и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147650,'Индикация: проход сотрудника и нарушение времени и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147651,'Индикация: проход посетителя и нарушение времени и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147652,'Индикация: проход сотрудника и нарушение местоположения и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147653,'Индикация: проход посетителя и нарушение местоположения и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147654,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147655,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147656,'Индикация: проход сотрудника и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147657,'Индикация: проход посетителя и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147658,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147659,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147660,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147661,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147662,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147663,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147664,'Индикация: проход сотрудника и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147665,'Индикация: проход посетителя и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147666,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147667,'Индикация: проход посетителя и нарушение времени и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147668,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147669,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147670,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147671,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147672,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147673,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147674,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147675,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147676,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147677,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147678,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147679,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147680,'Индикация: проход сотрудника и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147681,'Индикация: проход посетителя и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147682,'Индикация: проход сотрудника и нарушение времени и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147683,'Индикация: проход посетителя и нарушение времени и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147684,'Индикация: проход сотрудника и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147685,'Индикация: проход посетителя и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147686,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147687,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147688,'Индикация: проход сотрудника и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147689,'Индикация: проход посетителя и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147690,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147691,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147692,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147693,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147694,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147695,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147696,'Индикация: проход сотрудника и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147697,'Индикация: проход посетителя и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147698,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147699,'Индикация: проход посетителя и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147700,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147701,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147702,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147703,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147704,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147705,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147706,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147707,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147708,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147709,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147710,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(147711,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163840,'Индикация: проход сотрудника и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163841,'Индикация: проход посетителя и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163842,'Индикация: проход сотрудника и нарушение времени и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163843,'Индикация: проход посетителя и нарушение времени и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163844,'Индикация: проход сотрудника и нарушение местоположения и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163845,'Индикация: проход посетителя и нарушение местоположения и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163846,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163847,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163848,'Индикация: проход сотрудника и нарушение режима доступа и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163849,'Индикация: проход посетителя и нарушение режима доступа и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163850,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163851,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163852,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163853,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163854,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163855,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163856,'Индикация: проход сотрудника и разрешение прохода и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163857,'Индикация: проход посетителя и разрешение прохода и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163858,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163859,'Индикация: проход посетителя и нарушение времени и разрешение прохода и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163860,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163861,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163862,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163863,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163864,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163865,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163866,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163867,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163868,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163869,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163870,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163871,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163872,'Индикация: проход сотрудника и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163873,'Индикация: проход посетителя и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163874,'Индикация: проход сотрудника и нарушение времени и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163875,'Индикация: проход посетителя и нарушение времени и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163876,'Индикация: проход сотрудника и нарушение местоположения и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163877,'Индикация: проход посетителя и нарушение местоположения и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163878,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163879,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163880,'Индикация: проход сотрудника и нарушение режима доступа и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163881,'Индикация: проход посетителя и нарушение режима доступа и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163882,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163883,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163884,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163885,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163886,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163887,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163888,'Индикация: проход сотрудника и разрешение прохода и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163889,'Индикация: проход посетителя и разрешение прохода и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163890,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163891,'Индикация: проход посетителя и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163892,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163893,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163894,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163895,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163896,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163897,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163898,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163899,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163900,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163901,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163902,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163903,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163904,'Индикация: проход сотрудника и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163905,'Индикация: проход посетителя и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163906,'Индикация: проход сотрудника и нарушение времени и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163907,'Индикация: проход посетителя и нарушение времени и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163908,'Индикация: проход сотрудника и нарушение местоположения и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163909,'Индикация: проход посетителя и нарушение местоположения и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163910,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163911,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163912,'Индикация: проход сотрудника и нарушение режима доступа и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163913,'Индикация: проход посетителя и нарушение режима доступа и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163914,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163915,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163916,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163917,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163918,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163919,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163920,'Индикация: проход сотрудника и разрешение прохода и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163921,'Индикация: проход посетителя и разрешение прохода и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163922,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163923,'Индикация: проход посетителя и нарушение времени и разрешение прохода и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163924,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163925,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163926,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163927,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163928,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163929,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163930,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163931,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163932,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163933,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163934,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163935,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163936,'Индикация: проход сотрудника и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163937,'Индикация: проход посетителя и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163938,'Индикация: проход сотрудника и нарушение времени и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163939,'Индикация: проход посетителя и нарушение времени и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163940,'Индикация: проход сотрудника и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163941,'Индикация: проход посетителя и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163942,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163943,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163944,'Индикация: проход сотрудника и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163945,'Индикация: проход посетителя и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163946,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163947,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163948,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163949,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163950,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163951,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163952,'Индикация: проход сотрудника и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163953,'Индикация: проход посетителя и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163954,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163955,'Индикация: проход посетителя и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163956,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163957,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163958,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163959,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163960,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163961,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163962,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163963,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163964,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163965,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163966,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163967,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163968,'Индикация: проход сотрудника и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163969,'Индикация: проход посетителя и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163970,'Индикация: проход сотрудника и нарушение времени и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163971,'Индикация: проход посетителя и нарушение времени и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163972,'Индикация: проход сотрудника и нарушение местоположения и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163973,'Индикация: проход посетителя и нарушение местоположения и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163974,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163975,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163976,'Индикация: проход сотрудника и нарушение режима доступа и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163977,'Индикация: проход посетителя и нарушение режима доступа и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163978,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163979,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163980,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163981,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163982,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163983,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163984,'Индикация: проход сотрудника и разрешение прохода и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163985,'Индикация: проход посетителя и разрешение прохода и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163986,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163987,'Индикация: проход посетителя и нарушение времени и разрешение прохода и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163988,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163989,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163990,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163991,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163992,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163993,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163994,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163995,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163996,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163997,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163998,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(163999,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164000,'Индикация: проход сотрудника и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164001,'Индикация: проход посетителя и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164002,'Индикация: проход сотрудника и нарушение времени и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164003,'Индикация: проход посетителя и нарушение времени и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164004,'Индикация: проход сотрудника и нарушение местоположения и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164005,'Индикация: проход посетителя и нарушение местоположения и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164006,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164007,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164008,'Индикация: проход сотрудника и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164009,'Индикация: проход посетителя и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164010,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164011,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164012,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164013,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164014,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164015,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164016,'Индикация: проход сотрудника и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164017,'Индикация: проход посетителя и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164018,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164019,'Индикация: проход посетителя и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164020,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164021,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164022,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164023,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164024,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164025,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164026,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164027,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164028,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164029,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164030,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164031,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164032,'Индикация: проход сотрудника и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164033,'Индикация: проход посетителя и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164034,'Индикация: проход сотрудника и нарушение времени и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164035,'Индикация: проход посетителя и нарушение времени и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164036,'Индикация: проход сотрудника и нарушение местоположения и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164037,'Индикация: проход посетителя и нарушение местоположения и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164038,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164039,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164040,'Индикация: проход сотрудника и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164041,'Индикация: проход посетителя и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164042,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164043,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164044,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164045,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164046,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164047,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164048,'Индикация: проход сотрудника и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164049,'Индикация: проход посетителя и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164050,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164051,'Индикация: проход посетителя и нарушение времени и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164052,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164053,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164054,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164055,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164056,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164057,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164058,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164059,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164060,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164061,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164062,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164063,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164064,'Индикация: проход сотрудника и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164065,'Индикация: проход посетителя и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164066,'Индикация: проход сотрудника и нарушение времени и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164067,'Индикация: проход посетителя и нарушение времени и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164068,'Индикация: проход сотрудника и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164069,'Индикация: проход посетителя и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164070,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164071,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164072,'Индикация: проход сотрудника и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164073,'Индикация: проход посетителя и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164074,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164075,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164076,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164077,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164078,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164079,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164080,'Индикация: проход сотрудника и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164081,'Индикация: проход посетителя и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164082,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164083,'Индикация: проход посетителя и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164084,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164085,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164086,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164087,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164088,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164089,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164090,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164091,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164092,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164093,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164094,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(164095,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180224,'Индикация: проход сотрудника и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180225,'Индикация: проход посетителя и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180226,'Индикация: проход сотрудника и нарушение времени и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180227,'Индикация: проход посетителя и нарушение времени и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180228,'Индикация: проход сотрудника и нарушение местоположения и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180229,'Индикация: проход посетителя и нарушение местоположения и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180230,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180231,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180232,'Индикация: проход сотрудника и нарушение режима доступа и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180233,'Индикация: проход посетителя и нарушение режима доступа и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180234,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180235,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180236,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180237,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180238,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180239,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180240,'Индикация: проход сотрудника и разрешение прохода и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180241,'Индикация: проход посетителя и разрешение прохода и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180242,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180243,'Индикация: проход посетителя и нарушение времени и разрешение прохода и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180244,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180245,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180246,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180247,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180248,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180249,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180250,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180251,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180252,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180253,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180254,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180255,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180256,'Индикация: проход сотрудника и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180257,'Индикация: проход посетителя и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180258,'Индикация: проход сотрудника и нарушение времени и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180259,'Индикация: проход посетителя и нарушение времени и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180260,'Индикация: проход сотрудника и нарушение местоположения и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180261,'Индикация: проход посетителя и нарушение местоположения и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180262,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180263,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180264,'Индикация: проход сотрудника и нарушение режима доступа и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180265,'Индикация: проход посетителя и нарушение режима доступа и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180266,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180267,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180268,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180269,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180270,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180271,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180272,'Индикация: проход сотрудника и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180273,'Индикация: проход посетителя и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180274,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180275,'Индикация: проход посетителя и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180276,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180277,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180278,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180279,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180280,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180281,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180282,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180283,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180284,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180285,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180286,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180287,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180288,'Индикация: проход сотрудника и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180289,'Индикация: проход посетителя и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180290,'Индикация: проход сотрудника и нарушение времени и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180291,'Индикация: проход посетителя и нарушение времени и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180292,'Индикация: проход сотрудника и нарушение местоположения и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180293,'Индикация: проход посетителя и нарушение местоположения и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180294,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180295,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180296,'Индикация: проход сотрудника и нарушение режима доступа и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180297,'Индикация: проход посетителя и нарушение режима доступа и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180298,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180299,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180300,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180301,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180302,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180303,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180304,'Индикация: проход сотрудника и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180305,'Индикация: проход посетителя и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180306,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180307,'Индикация: проход посетителя и нарушение времени и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180308,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180309,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180310,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180311,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180312,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180313,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180314,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180315,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180316,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180317,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180318,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180319,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180320,'Индикация: проход сотрудника и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180321,'Индикация: проход посетителя и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180322,'Индикация: проход сотрудника и нарушение времени и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180323,'Индикация: проход посетителя и нарушение времени и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180324,'Индикация: проход сотрудника и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180325,'Индикация: проход посетителя и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180326,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180327,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180328,'Индикация: проход сотрудника и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180329,'Индикация: проход посетителя и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180330,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180331,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180332,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180333,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180334,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180335,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180336,'Индикация: проход сотрудника и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180337,'Индикация: проход посетителя и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180338,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180339,'Индикация: проход посетителя и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180340,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180341,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180342,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180343,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180344,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180345,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180346,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180347,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180348,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180349,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180350,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180351,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180352,'Индикация: проход сотрудника и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180353,'Индикация: проход посетителя и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180354,'Индикация: проход сотрудника и нарушение времени и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180355,'Индикация: проход посетителя и нарушение времени и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180356,'Индикация: проход сотрудника и нарушение местоположения и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180357,'Индикация: проход посетителя и нарушение местоположения и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180358,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180359,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180360,'Индикация: проход сотрудника и нарушение режима доступа и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180361,'Индикация: проход посетителя и нарушение режима доступа и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180362,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180363,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180364,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180365,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180366,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180367,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180368,'Индикация: проход сотрудника и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180369,'Индикация: проход посетителя и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180370,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180371,'Индикация: проход посетителя и нарушение времени и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180372,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180373,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180374,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180375,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180376,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180377,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180378,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180379,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180380,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180381,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180382,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180383,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180384,'Индикация: проход сотрудника и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180385,'Индикация: проход посетителя и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180386,'Индикация: проход сотрудника и нарушение времени и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180387,'Индикация: проход посетителя и нарушение времени и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180388,'Индикация: проход сотрудника и нарушение местоположения и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180389,'Индикация: проход посетителя и нарушение местоположения и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180390,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180391,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180392,'Индикация: проход сотрудника и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180393,'Индикация: проход посетителя и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180394,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180395,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180396,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180397,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180398,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180399,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180400,'Индикация: проход сотрудника и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180401,'Индикация: проход посетителя и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180402,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180403,'Индикация: проход посетителя и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180404,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180405,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180406,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180407,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180408,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180409,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180410,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180411,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180412,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180413,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180414,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180415,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180416,'Индикация: проход сотрудника и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180417,'Индикация: проход посетителя и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180418,'Индикация: проход сотрудника и нарушение времени и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180419,'Индикация: проход посетителя и нарушение времени и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180420,'Индикация: проход сотрудника и нарушение местоположения и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180421,'Индикация: проход посетителя и нарушение местоположения и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180422,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180423,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180424,'Индикация: проход сотрудника и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180425,'Индикация: проход посетителя и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180426,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180427,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180428,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180429,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180430,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180431,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180432,'Индикация: проход сотрудника и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180433,'Индикация: проход посетителя и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180434,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180435,'Индикация: проход посетителя и нарушение времени и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180436,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180437,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180438,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180439,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180440,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180441,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180442,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180443,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180444,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180445,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180446,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180447,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180448,'Индикация: проход сотрудника и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180449,'Индикация: проход посетителя и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180450,'Индикация: проход сотрудника и нарушение времени и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180451,'Индикация: проход посетителя и нарушение времени и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180452,'Индикация: проход сотрудника и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180453,'Индикация: проход посетителя и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180454,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180455,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180456,'Индикация: проход сотрудника и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180457,'Индикация: проход посетителя и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180458,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180459,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180460,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180461,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180462,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180463,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180464,'Индикация: проход сотрудника и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180465,'Индикация: проход посетителя и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180466,'Индикация: проход сотрудника и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180467,'Индикация: проход посетителя и нарушение времени и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180468,'Индикация: проход сотрудника и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180469,'Индикация: проход посетителя и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180470,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180471,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180472,'Индикация: проход сотрудника и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180473,'Индикация: проход посетителя и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180474,'Индикация: проход сотрудника и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180475,'Индикация: проход посетителя и нарушение времени и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования)',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180476,'Индикация: проход сотрудника и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180477,'Индикация: проход посетителя и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушение комиссионирования',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180478,'Индикация: проход сотрудника и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушен',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180479,'Индикация: проход посетителя и нарушение времени и нарушение местоположения и нарушение режима доступа и разрешение прохода и запрос на проход от пульта ДУ и постановка на «Охрану» и снятие с «Охраны» и ожидание комиссионирования и запрет прохода (нарушен',11,1,NULL,NULL);
INSERT INTO event_type VALUES(180480,'Индикация: проход посетителя и изъятие карты',11,1,NULL,NULL);
INSERT INTO event_type VALUES(196609,'Объект шаблон верификации загружен',12,9,'VERIFY_TEMPLATE','ID');
INSERT INTO event_type VALUES(196610,'Объект шаблон верификации выгружен',12,9,'VERIFY_TEMPLATE','ID');
INSERT INTO event_type VALUES(196619,'Верификация: разрешено оператором',11,1,NULL,NULL);
INSERT INTO event_type VALUES(196620,'Верификация: проход разрешён автоматически',11,1,NULL,NULL);
INSERT INTO event_type VALUES(196621,'Верификация: запрещено оператором',11,1,NULL,NULL);
INSERT INTO event_type VALUES(196622,'Начало выполнения задания',10061,15,NULL,NULL);
INSERT INTO event_type VALUES(196623,'Выполнение рассылки',10061,15,NULL,NULL);
INSERT INTO event_type VALUES(200000,'Регистрация Индицирующего устройства',12,NULL,NULL,NULL);
INSERT INTO event_type VALUES(300000,'Пользовательский запуск пересчета рабочего времени',12000,NULL,NULL,NULL);
INSERT INTO event_type VALUES(300001,'Окончание пересчета рабочего времени',12000,NULL,NULL,NULL);
INSERT INTO event_type VALUES(300050,'Запись идентификатора в карту',16,NULL,NULL,NULL);
INSERT INTO event_type VALUES(500000,'Вход оператора в систему',10000,NULL,NULL,NULL);
INSERT INTO event_type VALUES(500001,'Выход оператора из системы',10000,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501101,'Добавление графика работы',10011,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501102,'Редактирование графика работы',10011,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501103,'Удаление графика работы',10011,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501112,'Редактирование календаря',10011,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501122,'Редактирование опций календаря',10011,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501201,'Добавление подразделения',10012,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501202,'Редактирование подразделения',10012,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501203,'Удаление подразделения',10012,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501401,'Добавление сотрудника',10014,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501402,'Редактирование сотрудника',10014,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501403,'Удаление сотрудника',10014,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501404,'Блокировка сотрудника',10014,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501405,'Снятие блокировки сотрудника',10014,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501501,'Добавление посетителя',10015,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501502,'Редактирование посетителя',10015,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501503,'Удаление посетителя',10015,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501504,'Блокировка посетителя',10015,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501505,'Снятие блокировки посетителя',10015,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501601,'Добавление шаблона доступа',10016,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501602,'Редактирование шаблона доступа',10016,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501603,'Удаление шаблона доступа',10016,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501612,'Редактирование временной зоны',10017,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501622,'Редактирование недельного режима доступа',10017,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501632,'Редактирование сменного суточного режима доступа',10017,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501642,'Редактирование скользящего недельного режима доступа',10017,NULL,NULL,NULL);
INSERT INTO event_type VALUES(501652,'Редактирование календаря праздников для недельных графиков',10017,NULL,NULL,NULL);
INSERT INTO event_type VALUES(502502,'Редактирование события прохода',10025,NULL,NULL,NULL);
INSERT INTO event_type VALUES(503201,'Добавление роли',10032,NULL,NULL,NULL);
INSERT INTO event_type VALUES(503202,'Редактирование роли',10032,NULL,NULL,NULL);
INSERT INTO event_type VALUES(503203,'Удаление роли',10032,NULL,NULL,NULL);
INSERT INTO event_type VALUES(503204,'Изменение полномочий роли',10032,NULL,NULL,NULL);
INSERT INTO event_type VALUES(503601,'Добавление документа',10036,NULL,NULL,NULL);
INSERT INTO event_type VALUES(503602,'Редактирование документа',10036,NULL,NULL,NULL);
INSERT INTO event_type VALUES(503603,'Удаление документа',10036,NULL,NULL,NULL);
INSERT INTO event_type VALUES(503701,'Добавление поля',10037,NULL,NULL,NULL);
INSERT INTO event_type VALUES(503702,'Редактирование поля',10037,NULL,NULL,NULL);
INSERT INTO event_type VALUES(503703,'Удаление поля',10037,NULL,NULL,NULL);
INSERT INTO event_type VALUES(503801,'Добавление оператора',10038,NULL,NULL,NULL);
INSERT INTO event_type VALUES(503802,'Редактирование оператора',10038,NULL,NULL,NULL);
INSERT INTO event_type VALUES(503803,'Удаление оператора',10038,NULL,NULL,NULL);
INSERT INTO event_type VALUES(503804,'Блокировка оператора',10038,NULL,NULL,NULL);
INSERT INTO event_type VALUES(503805,'Снятие блокировки оператора',10038,NULL,NULL,NULL);
INSERT INTO event_type VALUES(503806,'Смена полномочий оператора',10038,NULL,NULL,NULL);
INSERT INTO event_type VALUES(503807,'Сообщение оператору',10038,15,NULL,NULL);
INSERT INTO event_type VALUES(505001,'Добавление дизайна пропуска',10050,NULL,NULL,NULL);
INSERT INTO event_type VALUES(505002,'Редактирование дизайна пропуска',10050,NULL,NULL,NULL);
INSERT INTO event_type VALUES(505003,'Удаление дизайна пропуска',10050,NULL,NULL,NULL);
INSERT INTO event_type VALUES(505401,'Добавление должности',10054,NULL,NULL,NULL);
INSERT INTO event_type VALUES(505402,'Редактирование должности',10054,NULL,NULL,NULL);
INSERT INTO event_type VALUES(505403,'Удаление должности',10054,NULL,NULL,NULL);
INSERT INTO event_type VALUES(505901,'Добавление помещения',10059,NULL,NULL,NULL);
INSERT INTO event_type VALUES(505902,'Редактирование помещения',10059,NULL,NULL,NULL);
INSERT INTO event_type VALUES(505903,'Удаление помещения',10059,NULL,NULL,NULL);
INSERT INTO event_type VALUES(505911,'Добавление устройства',11059,NULL,NULL,NULL);
INSERT INTO event_type VALUES(505912,'Редактирование устройства',11059,NULL,NULL,NULL);
INSERT INTO event_type VALUES(505913,'Удаление устройства',11059,NULL,NULL,NULL);
INSERT INTO event_type VALUES(505914,'Деактивация устройства',11059,NULL,NULL,NULL);
INSERT INTO event_type VALUES(505915,'Активация устройства',11059,NULL,NULL,NULL);
INSERT INTO event_type VALUES(505916,'Удаление устройства из помещения',11059,NULL,NULL,NULL);
INSERT INTO event_type VALUES(505917,'Установка устройства в помещение',11059,NULL,NULL,NULL);
INSERT INTO event_type VALUES(505918,'Редактирование общих параметров устройств',11059,NULL,NULL,NULL);
INSERT INTO event_type VALUES(506101,'Добавление задания',10061,NULL,NULL,NULL);
INSERT INTO event_type VALUES(506102,'Редактирование задания',10061,NULL,NULL,NULL);
INSERT INTO event_type VALUES(506103,'Удаление задания',10061,NULL,NULL,NULL);
INSERT INTO event_type VALUES(506401,'Добавление шаблона верификации',10064,NULL,NULL,NULL);
INSERT INTO event_type VALUES(506402,'Редактирование шаблона верификации',10064,NULL,NULL,NULL);
INSERT INTO event_type VALUES(506403,'Удаление шаблона верификации',10064,NULL,NULL,NULL);
INSERT INTO event_type VALUES(506404,'Добавление видеосервера',10064,NULL,NULL,NULL);
INSERT INTO event_type VALUES(506405,'Редактирование видеосервера',10064,NULL,NULL,NULL);
INSERT INTO event_type VALUES(506406,'Удаление видеосервера',10064,NULL,NULL,NULL);
INSERT INTO event_type VALUES(506407,'Добавление шаблона камеры',10064,NULL,NULL,NULL);
INSERT INTO event_type VALUES(506408,'Редактирование шаблона камеры',10064,NULL,NULL,NULL);
INSERT INTO event_type VALUES(506409,'Удаление шаблона камеры',10064,NULL,NULL,NULL);
INSERT INTO event_type VALUES(506901,'Включение лицензии',10069,NULL,NULL,NULL);
INSERT INTO event_type VALUES(506902,'Смена лицензионного контроллера',10069,NULL,NULL,NULL);
INSERT INTO event_type VALUES(506903,'Отключение лицензии',10069,NULL,NULL,NULL);
INSERT INTO event_type VALUES(506904,'Оператор записал идентификатор',10037,NULL,NULL,NULL);
CREATE TABLE IF NOT EXISTS "device_resource"
(
	id integer not null
		constraint device_resource_1_pk
			primary key autoincrement,
	resource_type_id smallint not null,
	type_id smallint not null,
	name varchar not null,
	short_name varchar,
	schema_title varchar
);
INSERT INTO device_resource VALUES(1,6,1,'Генератор тревоги (400 Контроллер турникета1-8 [Стойка турникета. Виртуальный контроллер второго уровня])','Генератор тревоги','alarm_gen_type_1');
INSERT INTO device_resource VALUES(2,6,3,'Генератор тревоги (1,2) (700 Контроллер замка2-8 [Контроллер второго уровня (Виртуальный или CL201)])','Генератор тревоги','alarm_gen_type_3');
INSERT INTO device_resource VALUES(3,6,2,'Генератор тревоги (401 Контроллер турникета1-8 [CL201. Контроллер второго уровня])','Генератор тревоги','alarm_gen_type_2');
INSERT INTO device_resource VALUES(4,6,4,'Генератор тревоги (3-10) (700 Контроллер замка2-8 [Контроллер второго уровня (Виртуальный или CL201)])','Генератор тревоги','alarm_gen_type_4');
INSERT INTO device_resource VALUES(5,6,5,'Генератор тревоги (1) (600 Контроллер замка1-8 [Контроллер второго уровня (Виртуальный или CL201)])','Генератор тревоги','alarm_gen_type_5');
INSERT INTO device_resource VALUES(6,6,6,'Генератор тревоги (3-10) (600 Контроллер замка1-8 [Контроллер второго уровня (Виртуальный или CL201)])','Генератор тревоги','alarm_gen_type_6');
INSERT INTO device_resource VALUES(7,6,7,'Генератор тревоги (Контроллер замка (CL05) 1)','Генератор тревоги','alarm_gen_type_7');
INSERT INTO device_resource VALUES(8,7,1,'Дополнительный вход №1 (4 Контроллер турникета1-8)','Дополнительный вход №1','input_type_1');
INSERT INTO device_resource VALUES(9,7,2,'Дополнительный вход №2 (4 Контроллер турникета1-8)','Дополнительный вход №2test',NULL);
INSERT INTO device_resource VALUES(10,7,5,'Дополнительный вход №1 (6 Контроллер замка1-8)','Дополнительный вход №1','input_type_5');
INSERT INTO device_resource VALUES(12,7,3,'Дополнительный вход №1 (7 Контроллер замка2-8)','Дополнительный вход №1',NULL);
INSERT INTO device_resource VALUES(14,8,1,'Дополнительный выход №3 (4  Контроллер турникета1-8)','Дополнительный выход №3','output_type_1');
INSERT INTO device_resource VALUES(15,8,2,'Дополнительный выход №4 (4  Контроллер турникета1-8)','Дополнительный выход №4',NULL);
INSERT INTO device_resource VALUES(16,8,7,'Дополнительный выход №1 (6  Контроллер замка1-8)','Дополнительный выход №1','output_type_7');
INSERT INTO device_resource VALUES(19,8,3,'Дополнительный выход №1 (7  Контроллер замка2-8)','Дополнительный выход №1',NULL);
INSERT INTO device_resource VALUES(24,8,11,'Дополнительный выход (1 Контроллер замка (CL05) 1)','Дополнительный выход','output_type_11');
INSERT INTO device_resource VALUES(25,8,12,'Дополнительный вывод (1 Контроллер замка (CL05.1) 1)','Дополнительный вывод','output_type_12');
INSERT INTO device_resource VALUES(26,9,1,'Турникет (400 Контроллер турникета1-8 [Стойка турникета. Виртуальный контроллер второго уровня])','Турникет','lock_type_1');
INSERT INTO device_resource VALUES(27,9,2,'Замок (401 Контроллер турникета1-8 [CL201. Контроллер второго уровня])','Замок','lock_type_2');
INSERT INTO device_resource VALUES(28,9,3,'Замок (700 Контроллер замка2-8 [Контроллер второго уровня (Виртуальный или CL201)])','Замок','lock_type_3');
INSERT INTO device_resource VALUES(29,9,4,'Замок (600 Контроллер замка1-8 [Контроллер второго уровня CL201])','Замок','lock_type_4');
INSERT INTO device_resource VALUES(30,9,5,'Замок (1 Контроллер замка (CL05) 1)','Замок','lock_type_5');
INSERT INTO device_resource VALUES(31,9,6,'Замок (600 Контроллер замка1-8 [Контроллер второго уровня Виртуальный])','Замок','lock_type_6');
INSERT INTO device_resource VALUES(32,9,7,'Замок (1 Контроллер замка (CL05.01) 1)','Замок','lock_type_7');
INSERT INTO device_resource VALUES(33,9,8,'Замок Suprema','Замок','lock_suprema');
INSERT INTO device_resource VALUES(34,10,1,'Считыватель (400 Контроллер турникета1-8 [Стойка турникета. Виртуальный контроллер второго уровня])','Считыватель','reader_type_1');
INSERT INTO device_resource VALUES(35,10,3,'Считыватель (700 Контроллер замка2-8 [Контроллер второго уровня (Виртуальный или CL201)])','Считыватель',NULL);
INSERT INTO device_resource VALUES(36,10,4,'Считыватель (600 Контроллер замка2-8 [Контроллер второго уровня (Виртуальный или CL201)])','Считыватель','reader_type_4');
INSERT INTO device_resource VALUES(37,10,6,'Считыватель (2 ЛИКОН)','Считыватель','reader_type_6');
INSERT INTO device_resource VALUES(38,10,5,'Считыватель (1 Контроллер замка (CL05) 1)','Считыватель','reader_type_5');
INSERT INTO device_resource VALUES(39,10,2,'Считыватель (402 [CL201. Контроллер второго уровня для CTL4.2])','Считыватель','reader_type_2');
INSERT INTO device_resource VALUES(40,10,7,'Считыватель Suprema','Считыватель','reader_suprema');
INSERT INTO device_resource VALUES(41,25,1,'Общие','Общие',NULL);
INSERT INTO device_resource VALUES(42,27,1,'Сеть','Сеть','network');
INSERT INTO device_resource VALUES(43,28,1,'Разное','Разное','settings');
INSERT INTO device_resource VALUES(44,29,1,'Состояние','Состояние','hw_state');
INSERT INTO device_resource VALUES(45,30,1,'Внешние подключения','Внешние подключения','connections');
INSERT INTO device_resource VALUES(46,14,1,'Свойства ЛИКОНа','Свойства ЛИКОНа','licon_config');
INSERT INTO device_resource VALUES(47,16,1,'Строки ЛИКОНа','Строки ЛИКОНа','licon_string_1');
INSERT INTO device_resource VALUES(48,31,1,'Общие параметры','Общие параметры','parameters');
INSERT INTO device_resource VALUES(49,31,3,'Настройка mifare','Настройка mifare','mifare_settings');
INSERT INTO device_resource VALUES(50,31,4,'Настройка Suprema','Настройка Suprema','suprema_settings');
INSERT INTO device_resource VALUES(51,31,2,'Настройка PERCo','Настройка PERCo','perco_settings');
INSERT INTO device_resource VALUES(52,26,1,'О камере ONVIF','О камере','camera_about_onvif');
INSERT INTO device_resource VALUES(53,28,2,'Разное','Разное','s30_settings');
INSERT INTO device_resource VALUES(54,26,2,'Камера ONVIF','Камера','camera_settings');
INSERT INTO device_resource VALUES(55,26,3,'Видео','Видео','camera_video');
INSERT INTO device_resource VALUES(56,7,6,'Вход s30','Вход s30','input_type_6');
INSERT INTO device_resource VALUES(57,8,13,'Выход s30','Выход s30','output_type_13');
INSERT INTO device_resource VALUES(58,9,9,'ИУ s30','ИУ s30','lock_type_9');
INSERT INTO device_resource VALUES(59,32,1,'Направление s30','Направление s30','direction_type_1');
INSERT INTO device_resource VALUES(60,33,1,'Cчитыватель или сканер s30','Cчитыватель или сканер s30','reader_type_8');
INSERT INTO device_resource VALUES(68,32,2,'Направление s30 (ЛИКОН)','Направление s30 (ЛИКОН)','direction_type_2');
INSERT INTO device_resource VALUES(70,9,10,'ЛИКОН s30','ЛИКОН s30','lock_type_10');
INSERT INTO device_resource VALUES(71,6,8,'Генератор тревоги s30','Генератор тревоги','alarm_gen_type_8');
INSERT INTO device_resource VALUES(72,34,1,'Шлюз CTL14','Шлюз CTL14','gateway_type_1');
INSERT INTO device_resource VALUES(73,34,2,'Шлюз CL15','Шлюз CL15','gateway_type_2');
INSERT INTO device_resource VALUES(76,10,10,'Считыватель 4.2 турникет','Считыватель 4.2 турникет','reader_type_10');
INSERT INTO device_resource VALUES(77,10,9,'Считыватель 4.2 замок','Считыватель 4.2 замок','reader_type_9');
INSERT INTO device_resource VALUES(78,7,7,'Дополнительный вход 4.2','Дополнительный вход 4.2','input_type_7');
INSERT INTO device_resource VALUES(79,35,1,'Параметры точки верификации','Точка верификации','verify_point_settings');
INSERT INTO device_resource VALUES(80,35,3,'Точка идентификации для Ликона','Точка верификации','verify_point_reaction_licon');
INSERT INTO device_resource VALUES(81,35,2,'Точка верификации','Точка верификации','verify_point_reaction');
INSERT INTO device_resource VALUES(82,26,4,'О камере MJPEG','О камере','camera_about_mjpeg');
INSERT INTO device_resource VALUES(83,26,5,'Камера MJPEG','Камера','camera_settings_mjpeg');
INSERT INTO device_resource VALUES(84,35,4,'Параметры точки верификации для S30','Точка верификации','verify_point_settings_s30');
INSERT INTO device_resource VALUES(85,9,11,'ИУ CL15 s30','ИУ CL15 s30','lock_type_11');
INSERT INTO device_resource VALUES(86,34,3,'Составной объект CL15','Составной объект CL15','gateway_type_3');
INSERT INTO device_resource VALUES(88,16,2,'Строки ЛИКОНа 4.2','Строки ЛИКОНа','licon_string_2');
INSERT INTO device_resource VALUES(89,33,2,'Cчитыватель morpho CT13','Cчитыватель morpho CT13','reader_type_11');
INSERT INTO device_resource VALUES(90,33,3,'Cчитыватель morpho','Cчитыватель morpho','reader_type_12');
INSERT INTO device_resource VALUES(91,9,12,'Замок ZKTeco','Замок','lock_zkteco');
INSERT INTO device_resource VALUES(92,10,11,'Считыватель ZKTeco','Считыватель','reader_zkteco');
INSERT INTO device_resource VALUES(93,10,12,'Считыватель Suprema Face','Считыватель','reader_suprema_face');
INSERT INTO device_resource VALUES(94,28,3,'Разное','Разное','zkt_settings');
INSERT INTO device_resource VALUES(95,31,5,'Настройка ZKTeco','Настройка ZKTeco','zkt_common_settings');
INSERT INTO device_resource VALUES(96,35,5,'Точка идентификации для Suprema','Точка верификации','verify_point_reaction_suprema');
INSERT INTO device_resource VALUES(97,35,6,'Точка идентификации для ZKTeco','Точка верификации','verify_point_reaction_zkteco');
CREATE TABLE IF NOT EXISTS "access_template_type"
(
	id integer not null
		constraint access_template_type_pk
			primary key autoincrement,
	name varchar(32) default NULL not null
);
INSERT INTO access_template_type VALUES(0,'PERCo');
INSERT INTO access_template_type VALUES(1,'Suprema');
INSERT INTO access_template_type VALUES(2,'s30');
INSERT INTO access_template_type VALUES(3,'ZKTeco');
CREATE TABLE IF NOT EXISTS "access_type"
(
	id integer not null
		constraint access_type_pk
			primary key,
	name varchar(150) not null
);
INSERT INTO access_type VALUES(1,'Карта');
INSERT INTO access_type VALUES(2,'Отпечаток');
INSERT INTO access_type VALUES(3,'Карта и отпечаток');
INSERT INTO access_type VALUES(4,'Карта или отпечаток');
INSERT INTO access_type VALUES(5,'##Карта и отпечаток на карте##');
INSERT INTO access_type VALUES(6,'##Лицо##');
INSERT INTO access_type VALUES(7,'##Лицо или карта##');
INSERT INTO access_type VALUES(8,'##Лицо и карта##');
INSERT INTO access_type VALUES(9,'##Лицо и пин-код##');
INSERT INTO access_type VALUES(10,'##Лицо и карта и пин-код##');
INSERT INTO access_type VALUES(11,'##Карта и пин-код##');
CREATE TABLE IF NOT EXISTS "device_type"
(
	id integer not null
		constraint device_type_pk
			primary key,
	device_type integer not null,
	name varchar(150) not null,
	is_off integer default NULL,
	device_vendor integer default NULL,
	schema_title varchar(50) default NULL
);
INSERT INTO device_type VALUES(0,0,'Общие настройки',NULL,0,'common_settings');
INSERT INTO device_type VALUES(1,16,'Контроллер замка CL05',NULL,0,'device_type_cl05_0');
INSERT INTO device_type VALUES(2,17,'ЛИКОН',NULL,0,'device_type_17');
INSERT INTO device_type VALUES(3,18,'Контроллер турникета CT/L04 [1]',NULL,0,'device_type_18');
INSERT INTO device_type VALUES(4,19,'Контроллер турникета CT/L04 [1+8]',NULL,0,'device_type_19');
INSERT INTO device_type VALUES(5,20,'Контроллер замка CT/L04 [1]',NULL,0,'device_type_20');
INSERT INTO device_type VALUES(6,21,'Контроллер замка CT/L04 [1+8]',NULL,0,'device_type_21');
INSERT INTO device_type VALUES(7,22,'Контроллер замка CT/L04 [2+8]',NULL,0,'device_type_22');
INSERT INTO device_type VALUES(8,23,'Электронная проходная KT02.3 [1]',NULL,0,'device_type_18');
INSERT INTO device_type VALUES(9,24,'Электронная проходная KT02.3 [1+8]',NULL,0,'device_type_19');
INSERT INTO device_type VALUES(10,25,'Электронная проходная KR05 [1]',1,0,NULL);
INSERT INTO device_type VALUES(11,26,'Электронная проходная KR05 [1+8]',1,0,NULL);
INSERT INTO device_type VALUES(12,27,'Электронная проходная с картоприёмником КТС01.3 [1]',1,0,'device_type_18');
INSERT INTO device_type VALUES(13,28,'Электронная проходная с картоприёмником КТС01.3 [1+8]',1,0,'device_type_19');
INSERT INTO device_type VALUES(14,29,'Неподдерживаемый контроллер',1,0,NULL);
INSERT INTO device_type VALUES(15,30,'Неподдерживаемый контроллер',1,0,NULL);
INSERT INTO device_type VALUES(32,32,'Электронная проходная KT05.3A [1]',NULL,0,'device_type_18');
INSERT INTO device_type VALUES(33,33,'Электронная проходная KT05.3A [1+8]',NULL,0,'device_type_19');
INSERT INTO device_type VALUES(34,34,'Электронная проходная с картоприемником KTC01.3A [1]',NULL,0,'device_type_18');
INSERT INTO device_type VALUES(35,35,'Электронная проходная с картоприемником KTC01.3A [1+8]',NULL,0,'device_type_19');
INSERT INTO device_type VALUES(36,36,'Контроллер замка CL05.1',NULL,0,'device_type_cl05');
INSERT INTO device_type VALUES(64,64,'Контроллер замка CL05.2',NULL,0,'device_type_cl05');
INSERT INTO device_type VALUES(65,65,'ЛИКОН 2',NULL,0,'device_type_65');
INSERT INTO device_type VALUES(67,67,'Контроллер турникета CT/L04.2',NULL,0,'device_type_67');
INSERT INTO device_type VALUES(68,68,'Контроллер турникета CT/L04.2',NULL,0,'device_type_68');
INSERT INTO device_type VALUES(69,69,'Контроллер турникета CT/L04.2',NULL,0,'device_type_69');
INSERT INTO device_type VALUES(70,70,'Контроллер турникета CT/L04.2',NULL,0,'device_type_70');
INSERT INTO device_type VALUES(71,71,'Электронная проходная KR05',NULL,0,'device_type_67');
INSERT INTO device_type VALUES(72,72,'Неподдерживаемый контроллер',1,0,NULL);
INSERT INTO device_type VALUES(73,73,'Неподдерживаемый контроллер',1,0,NULL);
INSERT INTO device_type VALUES(74,74,'Неподдерживаемый контроллер',1,0,NULL);
INSERT INTO device_type VALUES(75,75,'Неподдерживаемый контроллер',1,0,NULL);
INSERT INTO device_type VALUES(76,76,'Контроллер замка CT/L04.2',NULL,0,'device_type_76');
INSERT INTO device_type VALUES(77,77,'Контроллер замка CT/L04.2',NULL,0,'device_type_77');
INSERT INTO device_type VALUES(78,78,'Контроллер замка CT/L04.2',NULL,0,'device_type_78');
INSERT INTO device_type VALUES(79,79,'Контроллер замка CT/L04.2',NULL,0,'device_type_79');
INSERT INTO device_type VALUES(80,80,'Контроллер замка CT/L04.2',NULL,0,'device_type_80');
INSERT INTO device_type VALUES(81,81,'Контроллер замка CT/L04.2',NULL,0,'device_type_81');
INSERT INTO device_type VALUES(82,82,'Контроллер замка CT/L04.2',NULL,0,'device_type_82');
INSERT INTO device_type VALUES(83,83,'Контроллер замка CT/L04.2',NULL,0,'device_type_83');
INSERT INTO device_type VALUES(84,84,'Контроллер замка CT/L04.2',NULL,0,'device_type_84');
INSERT INTO device_type VALUES(85,85,'Контроллер замка CT/L04.2',NULL,0,'device_type_85');
INSERT INTO device_type VALUES(86,86,'Контроллер замка CT/L04.2',NULL,0,'device_type_86');
INSERT INTO device_type VALUES(87,87,'Контроллер замка CT/L04.2',NULL,0,'device_type_87');
INSERT INTO device_type VALUES(88,88,'Контроллер замка CT/L04.2',NULL,0,'device_type_88');
INSERT INTO device_type VALUES(89,89,'Контроллер замка CT/L04.2',NULL,0,'device_type_89');
INSERT INTO device_type VALUES(90,90,'Контроллер замка CT/L04.2',NULL,0,'device_type_90');
INSERT INTO device_type VALUES(91,91,'Контроллер замка CT/L04.2',NULL,0,'device_type_91');
INSERT INTO device_type VALUES(92,92,'Контроллер замка CT/L04.2',NULL,0,'device_type_92');
INSERT INTO device_type VALUES(93,93,'Электронная проходная КТ02.x/КТ05.x',NULL,0,'device_type_93');
INSERT INTO device_type VALUES(94,94,'Электронная проходная KTC01.x с картоприёмником',NULL,0,'device_type_94');
INSERT INTO device_type VALUES(95,95,'Электронная проходная КТ0х.A с антипаникой',NULL,0,'device_type_95');
INSERT INTO device_type VALUES(96,96,'Электронная проходная КТС0х.A с картоприемником и антипаникой',NULL,0,'device_type_96');
INSERT INTO device_type VALUES(97,97,'Электронная проходная КТ02.x/КТ05.x',NULL,0,'device_type_93');
INSERT INTO device_type VALUES(98,98,'Электронная проходная KTC01.x с картоприёмником',NULL,0,'device_type_94');
INSERT INTO device_type VALUES(99,99,'Электронная проходная КТ0х.A с антипаникой',NULL,0,'device_type_95');
INSERT INTO device_type VALUES(100,100,'Электронная проходная КТС0х.A с картоприемником и антипаникой',NULL,0,'device_type_96');
INSERT INTO device_type VALUES(256,256,'Контроллер замка',NULL,0,NULL);
INSERT INTO device_type VALUES(400,400,'Стойка турникета',NULL,0,'device_type_400');
INSERT INTO device_type VALUES(401,401,'Контроллер замка CL201',NULL,0,'device_type_401');
INSERT INTO device_type VALUES(402,402,'Контроллер замка CL201',NULL,0,'device_type_402');
INSERT INTO device_type VALUES(600,600,'Контроллер замка',NULL,0,'device_type_600');
INSERT INTO device_type VALUES(601,601,'Двусторонний замок',NULL,0,'device_type_601');
INSERT INTO device_type VALUES(602,602,'Односторонний замок',NULL,0,'device_type_602');
INSERT INTO device_type VALUES(603,603,'Контроллер турникета',NULL,0,'device_type_603');
INSERT INTO device_type VALUES(604,604,'Двусторонний замок',NULL,0,'device_type_604');
INSERT INTO device_type VALUES(700,700,'Контроллер замка',NULL,0,'device_type_700');
INSERT INTO device_type VALUES(901,901,'Контроллер СТL14',NULL,0,'s30_ctl14');
INSERT INTO device_type VALUES(902,902,'Контроллер СL15',NULL,0,'s30_cl15');
INSERT INTO device_type VALUES(903,903,'Контроллер СR11',NULL,0,'s30_cr11');
INSERT INTO device_type VALUES(904,904,'Контроллер СT13',NULL,0,'s30_ct13');
INSERT INTO device_type VALUES(950,950,'ЛИКОН',NULL,0,'s30_child_device');
INSERT INTO device_type VALUES(951,951,'Односторонний замок',NULL,0,'s30_child_device');
INSERT INTO device_type VALUES(952,952,'Двусторонний замок',NULL,0,'s30_child_device');
INSERT INTO device_type VALUES(953,953,'Электронная проходная',NULL,0,'s30_child_device');
INSERT INTO device_type VALUES(954,954,'Турникет',NULL,0,'s30_child_device');
INSERT INTO device_type VALUES(955,955,'Шлагбаум',NULL,0,'s30_child_device');
INSERT INTO device_type VALUES(999,999,'Контроллер системы S20 (импорт)',NULL,0,NULL);
INSERT INTO device_type VALUES(1001,1001,'Контроллер Suprema BioEntry Plus',NULL,1,'suprema');
INSERT INTO device_type VALUES(1010,1010,'##Контроллер## Suprema FaceStation2',NULL,1,'suprema_face');
INSERT INTO device_type VALUES(1013,1013,'Контроллер Suprema BioEntry W2',NULL,1,'suprema');
INSERT INTO device_type VALUES(1017,1017,'Контроллер Suprema BioEntry P2',NULL,1,'suprema');
INSERT INTO device_type VALUES(1025,1025,'##Контроллер## Suprema FaceLite',NULL,1,'suprema_face');
INSERT INTO device_type VALUES(2000,2000,'Видеокамера',NULL,2,'camera_onvif');
INSERT INTO device_type VALUES(2001,2001,'Видеокамера',NULL,2,'camera_mjpeg');
INSERT INTO device_type VALUES(3000,3000,'Шлюз СТL14',NULL,0,'gate_ctl14');
INSERT INTO device_type VALUES(3001,3001,'Шлюз СL15',NULL,0,'gate_cl15');
INSERT INTO device_type VALUES(3002,3002,'Составной объект CL15',NULL,0,'object_cl15');
INSERT INTO device_type VALUES(4000,4000,'##Контроллер## ZKTeco',NULL,3,'zkt_device');
CREATE TABLE IF NOT EXISTS "device_user_change"
(
	device_id integer not null
		constraint device_user_change_device_id_fk
			references device
				on update cascade on delete cascade,
	user_id integer not null
		constraint device_user_change_user_id_fk
			references user
				on update cascade on delete cascade,
	identifier bigint default NULL,
	change_type integer default NULL
);
CREATE TABLE IF NOT EXISTS "device_vendor"
(
	id integer not null
		constraint device_vendor_pk
			primary key autoincrement,
	name varchar(32) not null
);
INSERT INTO device_vendor VALUES(0,'PERCo');
INSERT INTO device_vendor VALUES(1,'Suprema');
INSERT INTO device_vendor VALUES(2,'Video');
INSERT INTO device_vendor VALUES(3,'ZKTeco');
CREATE TABLE IF NOT EXISTS "license_state"
(
	id integer not null
		constraint license_state_pk
			primary key,
	name varchar(150) not null
);
INSERT INTO license_state VALUES(0,'Не проверена');
INSERT INTO license_state VALUES(1,'Ключ не проверен');
INSERT INTO license_state VALUES(2,'Повреждена');
INSERT INTO license_state VALUES(3,'Проверена');
INSERT INTO license_state VALUES(4,'Не действительна');
INSERT INTO license_state VALUES(5,'Новый ключ установлен');
INSERT INTO license_state VALUES(6,'Новый ключ некорректен');
INSERT INTO license_state VALUES(7,'Отстутствует лицензионный контроллер');
INSERT INTO license_state VALUES(8,'Приостановлена');
INSERT INTO license_state VALUES(9,'Не включена');
INSERT INTO license_state VALUES(10,'Лицензионный контроллер не включен');
INSERT INTO license_state VALUES(11,'Ошибка лицензионного контроллера');
CREATE TABLE IF NOT EXISTS "user_change"
(
	id integer not null
		primary key autoincrement,
	user_id integer not null
		constraint user_change_user_id_fk
			references user
				on update cascade on delete cascade,
	change_type_id integer not null,
	begin_date date default NULL,
	end_date date default NULL,
	old_value integer default NULL,
	value integer default NULL,
	is_execute integer default '0' not null,
	timestamp datetime default CURRENT_TIMESTAMP not null
);
CREATE TABLE IF NOT EXISTS "user_staff"
(
	user_id integer not null
		constraint user_staff_pk
			primary key
		constraint user_staff_user_id_fk
			references user,
	hiring_date date not null,
	tabel_number varchar(100) default NULL,
	is_dismissed integer default '0' not null,
	dismissed_date date default NULL,
	work_schedule_id integer default NULL
		constraint user_staff_work_schedule_id_fk
			references work_schedule
, viber_id varchar(50));
INSERT INTO user_staff VALUES(1,'now','0001',0,NULL,NULL,NULL);
CREATE TABLE IF NOT EXISTS "user_visitor"
(
	user_id integer not null
		constraint user_visitor_pk
			primary key,
	accompanying_id integer default NULL,
	supporting_document varchar(150) default NULL,
	supporting_document_number varchar(150) default NULL,
	is_archived integer default '0' not null,
	archive_datetime datetime default NULL
);
CREATE TABLE IF NOT EXISTS "verify_template"
(
	id integer not null
		constraint verify_template_1_pk
			primary key autoincrement,
	is_const tinyint(1) default 0 not null,
	name varchar(150) not null,
	comment varchar(150),
	field_visibility_staff mediumtext,
	field_visibility_visitor mediumtext
);
CREATE TABLE IF NOT EXISTS "work_event_type"
(
	id integer not null
		constraint work_event_type_1_pk
			primary key autoincrement,
	event_type_id integer not null,
	description varchar(150)
);
INSERT INTO work_event_type VALUES(1,17,'Проход по идентификатору');
INSERT INTO work_event_type VALUES(2,529,'Проход по идентификатору с несоответствием временным критериям доступа');
INSERT INTO work_event_type VALUES(3,273,'Проход по идентификатору с несоответствием текущему местоположению');
INSERT INTO work_event_type VALUES(4,785,'Проход по идентификатору несоответствие временным критериям доступа и текущему местоположению');
INSERT INTO work_event_type VALUES(5,1041,'Проход по идентификатору с нарушением комиссионирования');
INSERT INTO work_event_type VALUES(6,1553,'Проход по идентификатору с несоответствием временным критериям доступа и с нарушением комиссионирования');
INSERT INTO work_event_type VALUES(7,1297,'Проход по идентификатору с несоответствием текущему местоположению и с нарушением комиссионирования');
INSERT INTO work_event_type VALUES(8,1809,'Проход по идентификатору несоответствие временным критериям доступа и текущему местоположению и с нарушением комиссионирования');
INSERT INTO work_event_type VALUES(9,2065,'Проход по идентификаторупри отказе в подтверждении прохода от верификации');
INSERT INTO work_event_type VALUES(10,2577,'Проход по идентификатору с несоответствием временным критериям доступа и при отказе в подтверждении прохода от верификации');
INSERT INTO work_event_type VALUES(11,2321,'Проход по идентификатору с несоответствием текущему местоположению и при отказе в подтверждении прохода от верификации');
INSERT INTO work_event_type VALUES(12,2833,'Проход по идентификатору несоответствие временным критериям доступа и текущему местоположению и при отказе в подтверждении прохода от верификации');
INSERT INTO work_event_type VALUES(13,23,'Проход с подтверждением от ДУ');
INSERT INTO work_event_type VALUES(14,535,'Проход с подтверждением от ДУ с несоответствием временным критериям доступа');
INSERT INTO work_event_type VALUES(15,279,'Проход с подтверждением от ДУ с несоответствием текущему местоположению');
INSERT INTO work_event_type VALUES(16,791,'Проход с подтверждением от ДУ несоответствие временным критериям доступа и текущему местоположению');
INSERT INTO work_event_type VALUES(17,27,'Проход с подтверждением от верификации');
INSERT INTO work_event_type VALUES(18,539,'Проход с подтверждением от верификации с несоответствием временным критериям доступа');
INSERT INTO work_event_type VALUES(19,283,'Проход с подтверждением от верификации с несоответствием текущему местоположению');
INSERT INTO work_event_type VALUES(20,795,'Проход с подтверждением от верификации несоответствие временным критериям доступа и текущему местоположению');
INSERT INTO work_event_type VALUES(21,5200,'Проход через мобильный терминал');
INSERT INTO work_event_type VALUES(22,5109,'Вход в шлюз');
INSERT INTO work_event_type VALUES(23,5110,'Выход из шлюза');
INSERT INTO work_event_type VALUES(24,8209,'Проход с подтверждением от ПДУ/верификации');
INSERT INTO work_event_type VALUES(25,8465,'Проход с подтверждением от ПДУ/верификации: с несоответствием текущему местоположению ');
INSERT INTO work_event_type VALUES(26,8721,'Проход с подтверждением от ПДУ/верификации: с несоответствием временным критериям доступа');
INSERT INTO work_event_type VALUES(27,8977,'Проход с подтверждением от ПДУ/верификации: с несоответствием временным критериям доступа и текущему местоположению');
INSERT INTO work_event_type VALUES(28,12305,'Проход с подтверждением от ВВУ и далее ПДУ/верификации');
INSERT INTO work_event_type VALUES(29,12561,'Проход с подтверждением от ВВУ и далее ПДУ/верификации: с несоответствием текущему местоположению');
INSERT INTO work_event_type VALUES(30,12817,'Проход с подтверждением от ВВУ и далее ПДУ/верификации: с несоответствием временным критериям доступа');
INSERT INTO work_event_type VALUES(31,13073,'Проход с подтверждением от ВВУ и далее ПДУ/верификации: с несоответствием временным критериям доступа и текущему местоположению');
INSERT INTO work_event_type VALUES(32,4113,'Проход с подтверждением от ВВУ');
INSERT INTO work_event_type VALUES(33,4369,'Проход с подтверждением от ВВУ: с несоответствием текущему местоположению');
INSERT INTO work_event_type VALUES(34,4625,'Проход с подтверждением от ВВУ: с несоответствием временным критериям доступа');
INSERT INTO work_event_type VALUES(35,4881,'Проход с подтверждением от ВВУ: с несоответствием временным критериям доступа и текущему местоположению');
CREATE TABLE IF NOT EXISTS "work_schedule"
(
	id integer not null
		primary key autoincrement,
	is_const integer default 0 not null,
	name varchar(150) not null,
	comment varchar(150) default NULL,
	is_not_holiday integer default 0 not null,
	is_first_input_last_output integer default 0 not null,
	work_schedule_type_id integer default NULL,
	begin_date date default NULL,
	control_coming_before time default NULL,
	control_leaving_later time default NULL,
	allow_coming_later time default NULL,
	allow_leaving_before time default NULL,
	allow_slide_coming_later time default NULL,
	allow_slide_leaving_before time default NULL,
	is_removed integer default 0 not null,
	overtime time default NULL,
	undertime time default NULL
, allow_breaks time default null, worktime_begin time default null, worktime_end time default null, balance_stored time default null, workday_list mediumtext default null);
CREATE TABLE IF NOT EXISTS "access_zone_commission"
(
	access_zone_id integer not null
		constraint access_zone_commission_access_zone_id_fk
			references access_zone,
	user_id integer not null
		constraint access_zone_commission_user_id_fk
			references user,
	commission_group integer not null,
	constraint access_zone_commission_pk
		primary key (access_zone_id, user_id)
);
CREATE TABLE IF NOT EXISTS "available_category_tab"
(
	user_id integer not null
		constraint available_category_tab_user_operator_user_id_fk
			references user_operator (user_id)
				on update cascade on delete cascade,
	cat_id integer not null
		references category_tab
			on update cascade on delete cascade,
	is_const integer default '0' not null,
	constraint available_category_tab_pk
		primary key (user_id, cat_id)
);
CREATE TABLE IF NOT EXISTS "device_resource_change"
(
	device_id integer not null
		references device
			on update cascade on delete cascade,
	resource_type integer not null,
	resource_number integer not null,
	constraint device_resource_change_pk
		primary key (device_id, resource_type, resource_number)
);
CREATE TABLE IF NOT EXISTS "message"
(
	id integer not null,
	language varchar(16) not null,
	translation mediumtext,
	time_label datetime default NULL,
	constraint message_pk
		primary key (id, language)
);
INSERT INTO message VALUES(1269,'en','Current',NULL);
INSERT INTO message VALUES(1270,'en','Dismissed',NULL);
INSERT INTO message VALUES(1271,'en','Add',NULL);
INSERT INTO message VALUES(1272,'en','Restore',NULL);
INSERT INTO message VALUES(1273,'cn','#123','2018-07-04 12:43:06');
INSERT INTO message VALUES(1273,'en','Edit',NULL);
INSERT INTO message VALUES(1274,'en','Dismiss',NULL);
INSERT INTO message VALUES(1275,'en','Delete',NULL);
INSERT INTO message VALUES(1276,'en','Block',NULL);
INSERT INTO message VALUES(1277,'en','Unblock',NULL);
INSERT INTO message VALUES(1278,'en','Withdraw card ',NULL);
INSERT INTO message VALUES(1279,'en','More',NULL);
INSERT INTO message VALUES(1280,'en','Cards printing',NULL);
INSERT INTO message VALUES(1281,'en','Table print',NULL);
INSERT INTO message VALUES(1282,'en','Export into XLS',NULL);
INSERT INTO message VALUES(1283,'en','Export into CSV',NULL);
INSERT INTO message VALUES(1284,'en','Search by the credentials history ',NULL);
INSERT INTO message VALUES(1285,'en','Reset filters',NULL);
INSERT INTO message VALUES(1286,'en','Table display parameters',NULL);
INSERT INTO message VALUES(1287,'en','Search',NULL);
INSERT INTO message VALUES(1288,'en','Find',NULL);
INSERT INTO message VALUES(1289,'en','Department',NULL);
INSERT INTO message VALUES(1290,'en','Show all',NULL);
INSERT INTO message VALUES(1291,'en','Select from list',NULL);
INSERT INTO message VALUES(1292,'en','Reset',NULL);
INSERT INTO message VALUES(1293,'en','Employee''s registration card',NULL);
INSERT INTO message VALUES(1294,'en','Last name',NULL);
INSERT INTO message VALUES(1295,'en','First Name',NULL);
INSERT INTO message VALUES(1296,'en','Middle name',NULL);
INSERT INTO message VALUES(1297,'en','Employee ID',NULL);
INSERT INTO message VALUES(1298,'en','Date of hiring',NULL);
INSERT INTO message VALUES(1299,'en','Credentials',NULL);
INSERT INTO message VALUES(1300,'en','Undefined',NULL);
INSERT INTO message VALUES(1301,'en','Position',NULL);
INSERT INTO message VALUES(1302,'en','Work schedule',NULL);
INSERT INTO message VALUES(1303,'en','Access template',NULL);
INSERT INTO message VALUES(1304,'en','Valid from',NULL);
INSERT INTO message VALUES(1305,'en','Planner',NULL);
INSERT INTO message VALUES(1306,'en','Images:',NULL);
INSERT INTO message VALUES(1307,'en','Upload from PC',NULL);
INSERT INTO message VALUES(1308,'en','Upload from the web-camera',NULL);
INSERT INTO message VALUES(1309,'en','Delete image',NULL);
INSERT INTO message VALUES(1310,'en','Additional fields',NULL);
INSERT INTO message VALUES(1311,'en','Documents',NULL);
INSERT INTO message VALUES(1312,'en','Access Identifier ',NULL);
INSERT INTO message VALUES(1313,'en','№',NULL);
INSERT INTO message VALUES(1314,'en','Document date',NULL);
INSERT INTO message VALUES(1315,'en','Type',NULL);
INSERT INTO message VALUES(1316,'en','Code',NULL);
INSERT INTO message VALUES(1317,'en','Start date',NULL);
INSERT INTO message VALUES(1318,'en','Expiry date',NULL);
INSERT INTO message VALUES(1318,'it','Data di scadenza',NULL);
INSERT INTO message VALUES(1319,'en','Duration',NULL);
INSERT INTO message VALUES(1320,'en','Card / identifier',NULL);
INSERT INTO message VALUES(1321,'en','Issue card',NULL);
INSERT INTO message VALUES(1322,'en','Valid until',NULL);
INSERT INTO message VALUES(1323,'en','Save',NULL);
INSERT INTO message VALUES(1325,'en','Template',NULL);
INSERT INTO message VALUES(1326,'en','Blocking',NULL);
INSERT INTO message VALUES(1327,'en','Card',NULL);
INSERT INTO message VALUES(1328,'en','Photo',NULL);
INSERT INTO message VALUES(1329,'en','Display columns according to the width of the table',NULL);
INSERT INTO message VALUES(1330,'en','Search by name',NULL);
INSERT INTO message VALUES(1331,'en','Ok',NULL);
INSERT INTO message VALUES(1332,'en','New document adding',NULL);
INSERT INTO message VALUES(1333,'en','Document number',NULL);
INSERT INTO message VALUES(1334,'en','Creation date',NULL);
INSERT INTO message VALUES(1335,'en','Document type',NULL);
INSERT INTO message VALUES(1336,'en','Supporting',NULL);
INSERT INTO message VALUES(1336,'it','Giustificativo',NULL);
INSERT INTO message VALUES(1337,'en','Paid overtime',NULL);
INSERT INTO message VALUES(1338,'en','First name / name',NULL);
INSERT INTO message VALUES(1339,'en','Start and end date',NULL);
INSERT INTO message VALUES(1340,'en','Card identifier',NULL);
INSERT INTO message VALUES(1341,'en','Receive from the controller',NULL);
INSERT INTO message VALUES(1342,'en','Employee dismissal',NULL);
INSERT INTO message VALUES(1343,'en','Dismiss an employee from',NULL);
INSERT INTO message VALUES(1344,'en','Attention!',NULL);
INSERT INTO message VALUES(1345,'en','Employee will be moved to the "dismissed" section, card will be withdrawn.',NULL);
INSERT INTO message VALUES(1346,'en','Employee recovery',NULL);
INSERT INTO message VALUES(1347,'en','Are you sure that you want to restore the employee?',NULL);
INSERT INTO message VALUES(1348,'en','Employee removal',NULL);
INSERT INTO message VALUES(1349,'en','Are you sure that you want to delete the employee?',NULL);
INSERT INTO message VALUES(1350,'en','Employee will be removed permanently, his recovery will be impossible in the future.',NULL);
INSERT INTO message VALUES(1351,'en','Employee blocking ',NULL);
INSERT INTO message VALUES(1352,'en','Are you sure that you want to block the employee?',NULL);
INSERT INTO message VALUES(1353,'en','Employee unblocking',NULL);
INSERT INTO message VALUES(1354,'en','Are you sure that you want to unblock the employee?',NULL);
INSERT INTO message VALUES(1355,'en','Card withdrawal ',NULL);
INSERT INTO message VALUES(1356,'en','Are you sure that you want to withdraw cards from employees?',NULL);
INSERT INTO message VALUES(1357,'en','Withdraw ',NULL);
INSERT INTO message VALUES(1358,'en','Schedules',NULL);
INSERT INTO message VALUES(1359,'en','Table',NULL);
INSERT INTO message VALUES(1360,'en','Add replacement schedule',NULL);
INSERT INTO message VALUES(1361,'en','Clear',NULL);
INSERT INTO message VALUES(1362,'en','Card template',NULL);
INSERT INTO message VALUES(1363,'en','Card frame / limit',NULL);
INSERT INTO message VALUES(1364,'en','Standard',NULL);
INSERT INTO message VALUES(1365,'en','Dotted line',NULL);
INSERT INTO message VALUES(1366,'en','Without the frame ',NULL);
INSERT INTO message VALUES(1367,'en','Printing',NULL);
INSERT INTO message VALUES(1369,'en','Ordered',NULL);
INSERT INTO message VALUES(1370,'en','Archive',NULL);
INSERT INTO message VALUES(1371,'en','Delete to archive',NULL);
INSERT INTO message VALUES(1372,'en','Delete permanently',NULL);
INSERT INTO message VALUES(1373,'en','Visitor to the archive removal ',NULL);
INSERT INTO message VALUES(1374,'en','Are you sure that you want to delete the visitor to archive?',NULL);
INSERT INTO message VALUES(1375,'en','Card will be unlinked.    ',NULL);
INSERT INTO message VALUES(1376,'en','Visitor removal',NULL);
INSERT INTO message VALUES(1377,'en','Are you sure that you want to delete the visitor?',NULL);
INSERT INTO message VALUES(1378,'en','Visitor will be removed permanently, his recovery will be impossible in the future.',NULL);
INSERT INTO message VALUES(1379,'en','Visitor blocking ',NULL);
INSERT INTO message VALUES(1380,'en','Are you sure that you want to block the visitor?',NULL);
INSERT INTO message VALUES(1381,'en','Visitor unblocking',NULL);
INSERT INTO message VALUES(1382,'en','Are you sure that you want to unblock the visitor?',NULL);
INSERT INTO message VALUES(1384,'en','Document',NULL);
INSERT INTO message VALUES(1385,'en','Accompanying',NULL);
INSERT INTO message VALUES(1386,'en','Valid from',NULL);
INSERT INTO message VALUES(1387,'en','Valid until',NULL);
INSERT INTO message VALUES(1388,'en','Visitor credentials ',NULL);
INSERT INTO message VALUES(1389,'en','Accompanying document',NULL);
INSERT INTO message VALUES(1390,'en','Photo',NULL);
INSERT INTO message VALUES(1391,'en','Event date',NULL);
INSERT INTO message VALUES(1392,'en','Event',NULL);
INSERT INTO message VALUES(1393,'en','Device',NULL);
INSERT INTO message VALUES(1394,'en','IP-address',NULL);
INSERT INTO message VALUES(1395,'en','Device resource',NULL);
INSERT INTO message VALUES(1396,'en','Card №',NULL);
INSERT INTO message VALUES(1397,'en','PersNo',NULL);
INSERT INTO message VALUES(1398,'en','Employee/Visitor',NULL);
INSERT INTO message VALUES(1399,'en','Room',NULL);
INSERT INTO message VALUES(1400,'en','Category',NULL);
INSERT INTO message VALUES(1401,'en','Subcategory',NULL);
INSERT INTO message VALUES(1402,'en','Adding date',NULL);
INSERT INTO message VALUES(1403,'en','Loading, please wait.',NULL);
INSERT INTO message VALUES(1405,'en','Refresh the data',NULL);
INSERT INTO message VALUES(1406,'en','Event Log',NULL);
INSERT INTO message VALUES(1407,'en','Card expiry period, access template and all the parameters of access rights temporary replacement will be deleted.',NULL);
INSERT INTO message VALUES(1408,'en','Employee card editing',NULL);
INSERT INTO message VALUES(1409,'en','Pass order',NULL);
INSERT INTO message VALUES(1410,'en','Card removal to archive',NULL);
INSERT INTO message VALUES(1411,'en','Are you sure that you want to delete the ordered pass to archive?',NULL);
INSERT INTO message VALUES(1412,'en','No available departments. ',NULL);
INSERT INTO message VALUES(1413,'en','No elements selected ',NULL);
INSERT INTO message VALUES(1414,'en','Departments are reset',NULL);
INSERT INTO message VALUES(1415,'en','Visitor deleted to archive',NULL);
INSERT INTO message VALUES(1415,'it','Visitatore eliminato e rimosso in archivio',NULL);
INSERT INTO message VALUES(1416,'en','Visitor deleted',NULL);
INSERT INTO message VALUES(1417,'en','Visitor blocked',NULL);
INSERT INTO message VALUES(1418,'en','Visitor unblocked',NULL);
INSERT INTO message VALUES(1419,'en','Sorting filters are reset',NULL);
INSERT INTO message VALUES(1420,'en','Incorrectly filled fields',NULL);
INSERT INTO message VALUES(1421,'en','Saved',NULL);
INSERT INTO message VALUES(1422,'en','Visitor was not saved! Incorrectly filled fields.',NULL);
INSERT INTO message VALUES(1423,'en','No available departments',NULL);
INSERT INTO message VALUES(1424,'en','No access templates available ',NULL);
INSERT INTO message VALUES(1425,'en','No employees from available departments.',NULL);
INSERT INTO message VALUES(1426,'en','Loading ...',NULL);
INSERT INTO message VALUES(1427,'en','Error',NULL);
INSERT INTO message VALUES(1428,'en','Employee blocked',NULL);
INSERT INTO message VALUES(1429,'en','Employee unblocked',NULL);
INSERT INTO message VALUES(1430,'en','Card is withdrawn',NULL);
INSERT INTO message VALUES(1431,'en','Enter the identifier',NULL);
INSERT INTO message VALUES(1432,'en','Invalid identifier',NULL);
INSERT INTO message VALUES(1433,'en','Card is already assigned to another visitor ',NULL);
INSERT INTO message VALUES(1434,'en','Scanning ...',NULL);
INSERT INTO message VALUES(1435,'en','Employee''s card has not been saved! Incorrectly filled fields. ',NULL);
INSERT INTO message VALUES(1436,'en','Credentials change has been made. When opening planner the parameters won''t be saved. Do you want to continue?',NULL);
INSERT INTO message VALUES(1437,'en','Employee dismissed',NULL);
INSERT INTO message VALUES(1438,'en','Employee restored',NULL);
INSERT INTO message VALUES(1439,'en','Employee removed',NULL);
INSERT INTO message VALUES(1440,'en','Do not save',NULL);
INSERT INTO message VALUES(1441,'en','Fill in all the mandatory fields',NULL);
INSERT INTO message VALUES(1442,'en','Employee was not saved! Incorrectly filled fields.',NULL);
INSERT INTO message VALUES(1443,'en','Schedule',NULL);
INSERT INTO message VALUES(1444,'en','No available document names name for adding ',NULL);
INSERT INTO message VALUES(1445,'en','Start date shall not be later than end date.',NULL);
INSERT INTO message VALUES(1446,'en','Document creation date can not be earlier than the date of employment.',NULL);
INSERT INTO message VALUES(1447,'en','Document name can not be empty. ',NULL);
INSERT INTO message VALUES(1448,'en','No positions available ',NULL);
INSERT INTO message VALUES(1449,'en','No schedules available',NULL);
INSERT INTO message VALUES(1450,'en','Select type',NULL);
INSERT INTO message VALUES(1451,'en','Select name',NULL);
INSERT INTO message VALUES(1452,'en','Access',NULL);
INSERT INTO message VALUES(1453,'en','Do you want to save the changes?',NULL);
INSERT INTO message VALUES(1454,'en','Add data change event / temporary replacement interval',NULL);
INSERT INTO message VALUES(1455,'en','Are you sure?',NULL);
INSERT INTO message VALUES(1456,'en','Interval start date shall be earlier than interval end date.',NULL);
INSERT INTO message VALUES(1457,'en','Department is to be stated.',NULL);
INSERT INTO message VALUES(1458,'en','Only one event of data change can be in the future.',NULL);
INSERT INTO message VALUES(1459,'en','Credentials change event with the same starting date already exists.',NULL);
INSERT INTO message VALUES(1460,'en','Time replacements should not cross.',NULL);
INSERT INTO message VALUES(1461,'en','Temporary replacement interval can not be made without credential change event ',NULL);
INSERT INTO message VALUES(1462,'en','Temporary replacement interval can not begin earlier than the credential events change.',NULL);
INSERT INTO message VALUES(1463,'en','There must be at least one interval of the "department"',NULL);
INSERT INTO message VALUES(1464,'en','There must be at least one interval "blocking".',NULL);
INSERT INTO message VALUES(1465,'en','Credentials and substitute parameters are updated',NULL);
INSERT INTO message VALUES(1466,'en','Error saving',NULL);
INSERT INTO message VALUES(1467,'en','Task',NULL);
INSERT INTO message VALUES(1468,'en','End date',NULL);
INSERT INTO message VALUES(1469,'en','Value',NULL);
INSERT INTO message VALUES(1470,'en','ID',NULL);
INSERT INTO message VALUES(1471,'en','No value selected',NULL);
INSERT INTO message VALUES(1472,'en','Edit the сredential change event ',NULL);
INSERT INTO message VALUES(1473,'en','Edit the interval of time replacement',NULL);
INSERT INTO message VALUES(1474,'en','Full Name',NULL);
INSERT INTO message VALUES(1475,'en','Date',NULL);
INSERT INTO message VALUES(1476,'en','From / To',NULL);
INSERT INTO message VALUES(1477,'en','Supporting document',NULL);
INSERT INTO message VALUES(1478,'en','Select room',NULL);
INSERT INTO message VALUES(1479,'en','Time interval is not correct',NULL);
INSERT INTO message VALUES(1480,'en','Su',NULL);
INSERT INTO message VALUES(1481,'en','Mon',NULL);
INSERT INTO message VALUES(1482,'en','Tu',NULL);
INSERT INTO message VALUES(1483,'en','Wed',NULL);
INSERT INTO message VALUES(1484,'en','Th',NULL);
INSERT INTO message VALUES(1485,'en','Fr',NULL);
INSERT INTO message VALUES(1486,'en','Sat',NULL);
INSERT INTO message VALUES(1487,'en','January',NULL);
INSERT INTO message VALUES(1488,'en','February',NULL);
INSERT INTO message VALUES(1489,'en','March',NULL);
INSERT INTO message VALUES(1490,'en','April',NULL);
INSERT INTO message VALUES(1491,'en','May',NULL);
INSERT INTO message VALUES(1491,'it','Maggio',NULL);
INSERT INTO message VALUES(1492,'en','June',NULL);
INSERT INTO message VALUES(1493,'en','July',NULL);
INSERT INTO message VALUES(1494,'en','August',NULL);
INSERT INTO message VALUES(1495,'en','September',NULL);
INSERT INTO message VALUES(1496,'en','October',NULL);
INSERT INTO message VALUES(1497,'en','November',NULL);
INSERT INTO message VALUES(1498,'en','December',NULL);
INSERT INTO message VALUES(1500,'en','Rooms',NULL);
INSERT INTO message VALUES(1501,'en','All',NULL);
INSERT INTO message VALUES(1503,'en','Staff',NULL);
INSERT INTO message VALUES(1504,'en','Apply',NULL);
INSERT INTO message VALUES(1505,'en','Rooms access ',NULL);
INSERT INTO message VALUES(1506,'en','Monday',NULL);
INSERT INTO message VALUES(1507,'en','Tuesday',NULL);
INSERT INTO message VALUES(1508,'en','Wednesday',NULL);
INSERT INTO message VALUES(1509,'en','Thursday',NULL);
INSERT INTO message VALUES(1510,'en','Friday',NULL);
INSERT INTO message VALUES(1511,'en','Saturday',NULL);
INSERT INTO message VALUES(1512,'en','Sunday',NULL);
INSERT INTO message VALUES(1513,'en','Title',NULL);
INSERT INTO message VALUES(1514,'en','Schedule type',NULL);
INSERT INTO message VALUES(1515,'en','Description',NULL);
INSERT INTO message VALUES(1516,'en','Hide',NULL);
INSERT INTO message VALUES(1517,'en','Work schedule not selected',NULL);
INSERT INTO message VALUES(1518,'en','One must not edit the official schedule ',NULL);
INSERT INTO message VALUES(1519,'en','One must not copy the official schedule ',NULL);
INSERT INTO message VALUES(1520,'en','One must not delete the official schedule ',NULL);
INSERT INTO message VALUES(1521,'en',' Entrance',NULL);
INSERT INTO message VALUES(1521,'it','Ingresso',NULL);
INSERT INTO message VALUES(1522,'en','Exit',NULL);
INSERT INTO message VALUES(1522,'it','Uscita',NULL);
INSERT INTO message VALUES(1523,'en','User',NULL);
INSERT INTO message VALUES(1524,'en','Activity',NULL);
INSERT INTO message VALUES(1525,'en','Select month',NULL);
INSERT INTO message VALUES(1526,'en','Form T12',NULL);
INSERT INTO message VALUES(1527,'en','Card number',NULL);
INSERT INTO message VALUES(1528,'en','Are you sure that you want to delete this (these) schedule (s)?',NULL);
INSERT INTO message VALUES(1529,'en','Selected schedule can not be deleted because it is used by following people:',NULL);
INSERT INTO message VALUES(1530,'en','Change of the schedule type will reset all time intervals. Do you really want to continue?',NULL);
INSERT INTO message VALUES(1531,'en','Are you sure that you want to exit without saving?',NULL);
INSERT INTO message VALUES(1532,'en','Empty name',NULL);
INSERT INTO message VALUES(1533,'en','Hours are to be set in the range from 0 to 23',NULL);
INSERT INTO message VALUES(1534,'en','Schedule contains incorrect intervals',NULL);
INSERT INTO message VALUES(1535,'en','Minutes are to be set in range from 0 to 59',NULL);
INSERT INTO message VALUES(1536,'en','Flexible intervals can not be used with variable intervals ',NULL);
INSERT INTO message VALUES(1537,'en','Constant value can not be more than the working time',NULL);
INSERT INTO message VALUES(1538,'en','Constant value can not be 0 value',NULL);
INSERT INTO message VALUES(1539,'en','This name is already in use',NULL);
INSERT INTO message VALUES(1540,'en','Shift start is not specified ',NULL);
INSERT INTO message VALUES(1541,'en','Selected day contains variable interval. Delete it',NULL);
INSERT INTO message VALUES(1542,'en','Number of days shall not be more than 30',NULL);
INSERT INTO message VALUES(1543,'en','Day is to be selected ',NULL);
INSERT INTO message VALUES(1544,'en','Number of days shall not be less than 1',NULL);
INSERT INTO message VALUES(1545,'en','Working hours',NULL);
INSERT INTO message VALUES(1546,'en','h',NULL);
INSERT INTO message VALUES(1547,'en','m',NULL);
INSERT INTO message VALUES(1548,'en','Constant value',NULL);
INSERT INTO message VALUES(1549,'en','Day',NULL);
INSERT INTO message VALUES(1550,'en','Work schedule adding ',NULL);
INSERT INTO message VALUES(1551,'en','Schedule editing',NULL);
INSERT INTO message VALUES(1552,'en','Working schedule copying ',NULL);
INSERT INTO message VALUES(1553,'en','January',NULL);
INSERT INTO message VALUES(1554,'en','February',NULL);
INSERT INTO message VALUES(1555,'en','March ',NULL);
INSERT INTO message VALUES(1556,'en','April',NULL);
INSERT INTO message VALUES(1557,'en','May',NULL);
INSERT INTO message VALUES(1558,'en','June',NULL);
INSERT INTO message VALUES(1559,'en','July',NULL);
INSERT INTO message VALUES(1560,'en','August',NULL);
INSERT INTO message VALUES(1561,'en','September',NULL);
INSERT INTO message VALUES(1562,'en','October',NULL);
INSERT INTO message VALUES(1563,'en','November',NULL);
INSERT INTO message VALUES(1564,'en','December',NULL);
INSERT INTO message VALUES(1565,'en','Regular day ',NULL);
INSERT INTO message VALUES(1566,'en','Holiday',NULL);
INSERT INTO message VALUES(1567,'en','Pre-holiday day',NULL);
INSERT INTO message VALUES(1568,'en','Working holiday',NULL);
INSERT INTO message VALUES(1569,'en','Note',NULL);
INSERT INTO message VALUES(1570,'en','Name can not be empty ',NULL);
INSERT INTO message VALUES(1571,'en','Transfer date shall be specified',NULL);
INSERT INTO message VALUES(1573,'en','Presence',NULL);
INSERT INTO message VALUES(1574,'en','Absence',NULL);
INSERT INTO message VALUES(1575,'en','Night work',NULL);
INSERT INTO message VALUES(1576,'en','Overtime',NULL);
INSERT INTO message VALUES(1577,'en','Balance of worked time',NULL);
INSERT INTO message VALUES(1578,'en','Supporting documents',NULL);
INSERT INTO message VALUES(1579,'en','Errors',NULL);
INSERT INTO message VALUES(1580,'en','Details',NULL);
INSERT INTO message VALUES(1581,'en','Exists',NULL);
INSERT INTO message VALUES(1582,'en','into the room',NULL);
INSERT INTO message VALUES(1583,'en','from the room',NULL);
INSERT INTO message VALUES(1584,'en','Presence time',NULL);
INSERT INTO message VALUES(1585,'en','Passage time',NULL);
INSERT INTO message VALUES(1586,'en','Passage type',NULL);
INSERT INTO message VALUES(1587,'en','Considered for calculations',NULL);
INSERT INTO message VALUES(1588,'en','document №',NULL);
INSERT INTO message VALUES(1589,'en','Document name',NULL);
INSERT INTO message VALUES(1590,'en','Duration',NULL);
INSERT INTO message VALUES(1591,'en','Start of the document',NULL);
INSERT INTO message VALUES(1592,'en','Document validity period end',NULL);
INSERT INTO message VALUES(1593,'en','Department ...',NULL);
INSERT INTO message VALUES(1594,'en','Passages location',NULL);
INSERT INTO message VALUES(1595,'en','Close',NULL);
INSERT INTO message VALUES(1596,'en','Close and recalculate',NULL);
INSERT INTO message VALUES(1597,'en','Holidays',NULL);
INSERT INTO message VALUES(1598,'en','Copy',NULL);
INSERT INTO message VALUES(1599,'en','Fill with predefined values',NULL);
INSERT INTO message VALUES(1600,'en','Night time from',NULL);
INSERT INTO message VALUES(1602,'en','Evening from',NULL);
INSERT INTO message VALUES(1603,'en','Evening',NULL);
INSERT INTO message VALUES(1605,'en','Schedule name ',NULL);
INSERT INTO message VALUES(1606,'en','Weekly',NULL);
INSERT INTO message VALUES(1607,'en','Daily',NULL);
INSERT INTO message VALUES(1609,'en','Schedule description',NULL);
INSERT INTO message VALUES(1610,'en','Not to consider holidays (only for weekly schedules)',NULL);
INSERT INTO message VALUES(1611,'en','Consider only the first and the last exit',NULL);
INSERT INTO message VALUES(1612,'en','Intervals',NULL);
INSERT INTO message VALUES(1613,'en','Recording rooms',NULL);
INSERT INTO message VALUES(1614,'en','Report settings ',NULL);
INSERT INTO message VALUES(1615,'en','Shift start date',NULL);
INSERT INTO message VALUES(1616,'en','Add day',NULL);
INSERT INTO message VALUES(1618,'en','Delete day',NULL);
INSERT INTO message VALUES(1619,'en','Registration',NULL);
INSERT INTO message VALUES(1620,'en','Discipline control ',NULL);
INSERT INTO message VALUES(1621,'en','Control',NULL);
INSERT INTO message VALUES(1621,'it','Controllo',NULL);
INSERT INTO message VALUES(1622,'en','early-in for more than',NULL);
INSERT INTO message VALUES(1623,'en','delay by more than',NULL);
INSERT INTO message VALUES(1624,'en','Not consider as a violation, allow ',NULL);
INSERT INTO message VALUES(1625,'en','late-in for no more than',NULL);
INSERT INTO message VALUES(1626,'en','early-out for no more than',NULL);
INSERT INTO message VALUES(1627,'en','Not consider as a violation,  allow (for flexible days of the shift) ',NULL);
INSERT INTO message VALUES(1628,'en','Name',NULL);
INSERT INTO message VALUES(1629,'en','Reduction',NULL);
INSERT INTO message VALUES(1630,'en','Transfer date',NULL);
INSERT INTO message VALUES(1631,'en','Predefined values calendar',NULL);
INSERT INTO message VALUES(1632,'en','Main fields:',NULL);
INSERT INTO message VALUES(1633,'en','Add department',NULL);
INSERT INTO message VALUES(1634,'en','Edit department',NULL);
INSERT INTO message VALUES(1635,'en','Delete department',NULL);
INSERT INTO message VALUES(1636,'en','Default settings',NULL);
INSERT INTO message VALUES(1637,'en','Employees access template',NULL);
INSERT INTO message VALUES(1638,'en','Visitors access template',NULL);
INSERT INTO message VALUES(1639,'en','Access templates',NULL);
INSERT INTO message VALUES(1640,'en','Work schedules',NULL);
INSERT INTO message VALUES(1641,'en','Department name',NULL);
INSERT INTO message VALUES(1645,'en','Positions',NULL);
INSERT INTO message VALUES(1647,'en','Position is not selected',NULL);
INSERT INTO message VALUES(1648,'en','One must not edit the official record',NULL);
INSERT INTO message VALUES(1649,'en','Are you sure that you want to delete the position?',NULL);
INSERT INTO message VALUES(1650,'en','Add position',NULL);
INSERT INTO message VALUES(1651,'en','Edit position',NULL);
INSERT INTO message VALUES(1652,'en','Position can not be empty ',NULL);
INSERT INTO message VALUES(1653,'en','Position with such name already exists',NULL);
INSERT INTO message VALUES(1654,'en','to',NULL);
INSERT INTO message VALUES(1657,'en','Delete position ',NULL);
INSERT INTO message VALUES(1658,'en','Text',NULL);
INSERT INTO message VALUES(1659,'en','Graphic',NULL);
INSERT INTO message VALUES(1660,'en','Name of the field',NULL);
INSERT INTO message VALUES(1661,'en','Type of filed',NULL);
INSERT INTO message VALUES(1662,'en','Unspecified field',NULL);
INSERT INTO message VALUES(1663,'en','Are you sure that you want to delete this field?',NULL);
INSERT INTO message VALUES(1664,'en','Add field',NULL);
INSERT INTO message VALUES(1665,'en','Edit field',NULL);
INSERT INTO message VALUES(1666,'en','Delete field',NULL);
INSERT INTO message VALUES(1670,'en','Restore value',NULL);
INSERT INTO message VALUES(1671,'en','Change year. Do you really want to continue?',NULL);
INSERT INTO message VALUES(1673,'en','Sat',NULL);
INSERT INTO message VALUES(1674,'en','Sun',NULL);
INSERT INTO message VALUES(1675,'en','Deny access',NULL);
INSERT INTO message VALUES(1676,'en','Grant access',NULL);
INSERT INTO message VALUES(1677,'en','Time zones',NULL);
INSERT INTO message VALUES(1678,'en','Shift-day',NULL);
INSERT INTO message VALUES(1679,'en','Flexible weekly',NULL);
INSERT INTO message VALUES(1680,'en','Access and arming/disarming ',NULL);
INSERT INTO message VALUES(1681,'en','Access and arming/disarming with double-check access ',NULL);
INSERT INTO message VALUES(1682,'en','Double-check access ',NULL);
INSERT INTO message VALUES(1683,'en','Double-check access and arming/disarmig with double-check access  ',NULL);
INSERT INTO message VALUES(1684,'en','Previous',NULL);
INSERT INTO message VALUES(1685,'en','Next',NULL);
INSERT INTO message VALUES(1712,'en','Not',NULL);
INSERT INTO message VALUES(1713,'en','One must not delete the official template ',NULL);
INSERT INTO message VALUES(1714,'en','Template not chosen',NULL);
INSERT INTO message VALUES(1715,'en','Are you sure that you want to delete this template?',NULL);
INSERT INTO message VALUES(1716,'en','Only one template can be copied ',NULL);
INSERT INTO message VALUES(1717,'en','One must not copy the official template',NULL);
INSERT INTO message VALUES(1719,'en','Template adding',NULL);
INSERT INTO message VALUES(1720,'en','Template editing',NULL);
INSERT INTO message VALUES(1721,'en','Template copying ',NULL);
INSERT INTO message VALUES(1722,'en','Templates editing',NULL);
INSERT INTO message VALUES(1723,'en','New template',NULL);
INSERT INTO message VALUES(1724,'en','One must not edit the official template',NULL);
INSERT INTO message VALUES(1725,'en','At least one accessing is to be added ',NULL);
INSERT INTO message VALUES(1726,'en','Schedule name is obligatory for filling ',NULL);
INSERT INTO message VALUES(1727,'en','Template name is obligatory for filling ',NULL);
INSERT INTO message VALUES(1728,'en','Template with such name already exists',NULL);
INSERT INTO message VALUES(1729,'en','Special days',NULL);
INSERT INTO message VALUES(1730,'en','One must not edit the official time intervals ',NULL);
INSERT INTO message VALUES(1733,'en','Time zone is to be selected!',NULL);
INSERT INTO message VALUES(1734,'en','One must not edit the official weekly schedules ',NULL);
INSERT INTO message VALUES(1735,'en','Weekly schedule is to be selected ',NULL);
INSERT INTO message VALUES(1736,'en','One must not edit the official shift-day schedules',NULL);
INSERT INTO message VALUES(1737,'en','Number of days in schedule shall not be more than 30',NULL);
INSERT INTO message VALUES(1738,'en','Never',NULL);
INSERT INTO message VALUES(1739,'en','Schedule is to be selected! ',NULL);
INSERT INTO message VALUES(1740,'en','There can not be more than 30 weeks in the schedule',NULL);
INSERT INTO message VALUES(1741,'en','Access denied',NULL);
INSERT INTO message VALUES(1742,'en','Templates',NULL);
INSERT INTO message VALUES(1743,'en','Holiday calendar for weekly schedules ',NULL);
INSERT INTO message VALUES(1744,'en','Template name',NULL);
INSERT INTO message VALUES(1745,'en','Template description',NULL);
INSERT INTO message VALUES(1746,'en','Access type',NULL);
INSERT INTO message VALUES(1747,'en','Antipass',NULL);
INSERT INTO message VALUES(1748,'en','Protection against cards handover ',NULL);
INSERT INTO message VALUES(1749,'en','No',NULL);
INSERT INTO message VALUES(1749,'it','No',NULL);
INSERT INTO message VALUES(1750,'en','Weekly schedules',NULL);
INSERT INTO message VALUES(1751,'en','Edit weekly schedule',NULL);
INSERT INTO message VALUES(1752,'en','Edit time interval',NULL);
INSERT INTO message VALUES(1753,'en','Shift-day access modes',NULL);
INSERT INTO message VALUES(1754,'en','Edit shift-day access mode',NULL);
INSERT INTO message VALUES(1755,'en','Add time interval',NULL);
INSERT INTO message VALUES(1756,'en','Delete time interval',NULL);
INSERT INTO message VALUES(1757,'en','Add shift-day work schedule',NULL);
INSERT INTO message VALUES(1758,'en','Delete shift-day work schedule',NULL);
INSERT INTO message VALUES(1759,'en','Shift start ',NULL);
INSERT INTO message VALUES(1760,'en','Flexible weekly access modes',NULL);
INSERT INTO message VALUES(1761,'en','Edit shift-week access mode',NULL);
INSERT INTO message VALUES(1762,'en','Add weekly schedule',NULL);
INSERT INTO message VALUES(1763,'en','Delete weekly schedule',NULL);
INSERT INTO message VALUES(1788,'en','Change of the template type will clear the card. Do you really want to continue?',NULL);
INSERT INTO message VALUES(1789,'en','Pass template adding',NULL);
INSERT INTO message VALUES(1790,'en','Card template editing',NULL);
INSERT INTO message VALUES(1791,'en','Card template copying  ',NULL);
INSERT INTO message VALUES(1792,'en','The element falls outside the limits of the pattern,',NULL);
INSERT INTO message VALUES(1793,'en','Invalid sizes',NULL);
INSERT INTO message VALUES(1794,'en','Only free text can be edited',NULL);
INSERT INTO message VALUES(1795,'en','For employees',NULL);
INSERT INTO message VALUES(1796,'en','For visitors',NULL);
INSERT INTO message VALUES(1797,'en','Position and size',NULL);
INSERT INTO message VALUES(1798,'en','Up',NULL);
INSERT INTO message VALUES(1799,'en','Down',NULL);
INSERT INTO message VALUES(1800,'en','The position of the upper left corner X-direction',NULL);
INSERT INTO message VALUES(1801,'en','The position of the upper left corner Y-direction',NULL);
INSERT INTO message VALUES(1802,'en','Length',NULL);
INSERT INTO message VALUES(1803,'en','Width',NULL);
INSERT INTO message VALUES(1804,'en','Place on the card',NULL);
INSERT INTO message VALUES(1805,'en','Field parameters',NULL);
INSERT INTO message VALUES(1806,'en','Background Color',NULL);
INSERT INTO message VALUES(1807,'en','Line style',NULL);
INSERT INTO message VALUES(1808,'en','Line colour',NULL);
INSERT INTO message VALUES(1809,'en','Line thickness',NULL);
INSERT INTO message VALUES(1810,'en','Text parameters',NULL);
INSERT INTO message VALUES(1811,'en','Semibold',NULL);
INSERT INTO message VALUES(1812,'en','Italics',NULL);
INSERT INTO message VALUES(1813,'en','Underlining',NULL);
INSERT INTO message VALUES(1814,'en','Text Colour',NULL);
INSERT INTO message VALUES(1815,'en','Change text',NULL);
INSERT INTO message VALUES(1816,'en','Font',NULL);
INSERT INTO message VALUES(1817,'en','Point size ',NULL);
INSERT INTO message VALUES(1818,'en','Drag the required fields to the card',NULL);
INSERT INTO message VALUES(1819,'en','Text fields',NULL);
INSERT INTO message VALUES(1820,'en','For card',NULL);
INSERT INTO message VALUES(1821,'en','Graphic fields',NULL);
INSERT INTO message VALUES(1822,'en','Additional',NULL);
INSERT INTO message VALUES(1823,'en','Free text',NULL);
INSERT INTO message VALUES(1824,'en','Name of the document type',NULL);
INSERT INTO message VALUES(1825,'en','Document code is alphabetic',NULL);
INSERT INTO message VALUES(1826,'en','Document code is numerical',NULL);
INSERT INTO message VALUES(1827,'en','Added to working time',NULL);
INSERT INTO message VALUES(1828,'en','Calculation method',NULL);
INSERT INTO message VALUES(1829,'en','Add to working time',NULL);
INSERT INTO message VALUES(1830,'en','Paid overtime on holidays and at the weekends',NULL);
INSERT INTO message VALUES(1831,'en','In working days',NULL);
INSERT INTO message VALUES(1832,'en','In calendar days including holidays',NULL);
INSERT INTO message VALUES(1833,'en','In calendar days excluding holidays',NULL);
INSERT INTO message VALUES(1834,'en','Add',NULL);
INSERT INTO message VALUES(1835,'en','Paid overtime',NULL);
INSERT INTO message VALUES(1836,'en','Document not selected',NULL);
INSERT INTO message VALUES(1837,'en','Add document type',NULL);
INSERT INTO message VALUES(1838,'en','Edit document type',NULL);
INSERT INTO message VALUES(1839,'en','Name of the document type can not be empty  ',NULL);
INSERT INTO message VALUES(1840,'en','Document code is to be filled',NULL);
INSERT INTO message VALUES(1841,'en','Letter code of the document can not сontain more than 2 characters',NULL);
INSERT INTO message VALUES(1842,'en','Type of document with this letter code already exists',NULL);
INSERT INTO message VALUES(1843,'en','Type of document with this digital code already exists',NULL);
INSERT INTO message VALUES(1844,'en','Digital code is to be from 0 to 99',NULL);
INSERT INTO message VALUES(1845,'en','Document digital code can not exceed 2 symbols ',NULL);
INSERT INTO message VALUES(1846,'en','Document with the same name already exists',NULL);
INSERT INTO message VALUES(1847,'en','Supporting',NULL);
INSERT INTO message VALUES(1848,'en','Add document',NULL);
INSERT INTO message VALUES(1849,'en','Edit document',NULL);
INSERT INTO message VALUES(1850,'en','Delete document',NULL);
INSERT INTO message VALUES(1851,'en','Document name',NULL);
INSERT INTO message VALUES(1852,'en','Login',NULL);
INSERT INTO message VALUES(1853,'en','Role',NULL);
INSERT INTO message VALUES(1854,'en','Controller',NULL);
INSERT INTO message VALUES(1855,'en','Blocked',NULL);
INSERT INTO message VALUES(1856,'en','Operator not selected',NULL);
INSERT INTO message VALUES(1857,'en','One must not delete the official operator',NULL);
INSERT INTO message VALUES(1858,'en','One must not block the official user ',NULL);
INSERT INTO message VALUES(1859,'en','Roles have not been created yet. Add role to continue adding users.',NULL);
INSERT INTO message VALUES(1860,'en','Password and confirmations do not match',NULL);
INSERT INTO message VALUES(1861,'en','Username is to be filled',NULL);
INSERT INTO message VALUES(1862,'en','Password is to be stated ',NULL);
INSERT INTO message VALUES(1863,'en','Username is already in use',NULL);
INSERT INTO message VALUES(1864,'en','The password should be longer than 6 symbols and contain at least one letter from the Latin alphabet or a number',NULL);
INSERT INTO message VALUES(1865,'en','Operator adding',NULL);
INSERT INTO message VALUES(1866,'en','Operator editing',NULL);
INSERT INTO message VALUES(1867,'en','Attention: This is a critical user, in case of password loss access to the system will not be available',NULL);
INSERT INTO message VALUES(1868,'en','Operator is to be selected  ',NULL);
INSERT INTO message VALUES(1869,'en','Select operator',NULL);
INSERT INTO message VALUES(1870,'en','You have no selected menu entries',NULL);
INSERT INTO message VALUES(1871,'en','Sections',NULL);
INSERT INTO message VALUES(1873,'en','Authority',NULL);
INSERT INTO message VALUES(1874,'en','Add operator',NULL);
INSERT INTO message VALUES(1875,'en','Password',NULL);
INSERT INTO message VALUES(1876,'en','Confirmation',NULL);
INSERT INTO message VALUES(1877,'en','Activity',NULL);
INSERT INTO message VALUES(1878,'en','Role not selected',NULL);
INSERT INTO message VALUES(1879,'en','Role name is to be filled',NULL);
INSERT INTO message VALUES(1880,'en','Role name is already in use',NULL);
INSERT INTO message VALUES(1881,'en','Role adding',NULL);
INSERT INTO message VALUES(1882,'en','Role editing',NULL);
INSERT INTO message VALUES(1883,'en','Departments',NULL);
INSERT INTO message VALUES(1884,'en','Cards templates ',NULL);
INSERT INTO message VALUES(1885,'en','Controllers',NULL);
INSERT INTO message VALUES(1886,'en','Add Role',NULL);
INSERT INTO message VALUES(1887,'en','This name is already in use. Choose another one.',NULL);
INSERT INTO message VALUES(1888,'en','New name',NULL);
INSERT INTO message VALUES(1890,'en','This controller is added to',NULL);
INSERT INTO message VALUES(1891,'en','Two root nodes can not be created ',NULL);
INSERT INTO message VALUES(1892,'en','Double-check access cards list',NULL);
INSERT INTO message VALUES(1893,'en','Can not be empty',NULL);
INSERT INTO message VALUES(1894,'en','The value must be from 0 to 251',NULL);
INSERT INTO message VALUES(1895,'en','Both rooms are to be listed',NULL);
INSERT INTO message VALUES(1897,'en','You are trying to select the territory that is not available for you.',NULL);
INSERT INTO message VALUES(1898,'en','One room is to be selected ',NULL);
INSERT INTO message VALUES(1899,'en','Rooms must differ',NULL);
INSERT INTO message VALUES(1900,'en','You are unable to access this room',NULL);
INSERT INTO message VALUES(1901,'en','Are you sure that you want to unbind the selected controller?',NULL);
INSERT INTO message VALUES(1902,'en','Are you sure that you want to delete this room?',NULL);
INSERT INTO message VALUES(1903,'en','Select room / controller',NULL);
INSERT INTO message VALUES(1904,'en','Controller is to be restored ',NULL);
INSERT INTO message VALUES(1905,'en','Controller is attached to the room. Detach it ',NULL);
INSERT INTO message VALUES(1906,'en','Select controller',NULL);
INSERT INTO message VALUES(1907,'en','Controller with child controllers can not be deleted ',NULL);
INSERT INTO message VALUES(1908,'en','Are you sure that you want to delete this controller?',NULL);
INSERT INTO message VALUES(1909,'en','Are you sure that you want to delete the selected controller? All its events will also be deleted',NULL);
INSERT INTO message VALUES(1910,'en','Child controllers can not be activated ',NULL);
INSERT INTO message VALUES(1911,'en','Child controllers must not be deactivated ',NULL);
INSERT INTO message VALUES(1912,'en','Select room or controller',NULL);
INSERT INTO message VALUES(1913,'en','Controllers can only be added to the room',NULL);
INSERT INTO message VALUES(1914,'en','Controller shall not be located in uncontrolled room',NULL);
INSERT INTO message VALUES(1915,'en','Room not selected',NULL);
INSERT INTO message VALUES(1916,'en','Device is not selected ',NULL);
INSERT INTO message VALUES(1917,'en','One controller is to be selected',NULL);
INSERT INTO message VALUES(1919,'en','Number of cards is over the limit!',NULL);
INSERT INTO message VALUES(1920,'en','Are you sure that you want to delete these persons?',NULL);
INSERT INTO message VALUES(1921,'en','Alarm generator',NULL);
INSERT INTO message VALUES(1923,'en','Execution unit',NULL);
INSERT INTO message VALUES(1924,'en','Protection zone',NULL);
INSERT INTO message VALUES(1925,'en','Resource',NULL);
INSERT INTO message VALUES(1926,'en','Reason for reset',NULL);
INSERT INTO message VALUES(1927,'en','Not specified',NULL);
INSERT INTO message VALUES(1928,'en','Additional input № 1',NULL);
INSERT INTO message VALUES(1929,'en','Additional input № 2',NULL);
INSERT INTO message VALUES(1930,'en','Turnstile',NULL);
INSERT INTO message VALUES(1931,'en','Lock',NULL);
INSERT INTO message VALUES(1932,'en','Additional output',NULL);
INSERT INTO message VALUES(1933,'en','Additional output № 1',NULL);
INSERT INTO message VALUES(1934,'en','Additional output № 2',NULL);
INSERT INTO message VALUES(1935,'en','Additional output № 3',NULL);
INSERT INTO message VALUES(1936,'en','Additional output № 4',NULL);
INSERT INTO message VALUES(1937,'en','Lock controller (CL05) 1',NULL);
INSERT INTO message VALUES(1938,'en','T&A 1',NULL);
INSERT INTO message VALUES(1939,'en','Turnstile controller 1 ',NULL);
INSERT INTO message VALUES(1940,'en','Turnstile controller 1-8',NULL);
INSERT INTO message VALUES(1941,'en','Lock1 controller ',NULL);
INSERT INTO message VALUES(1942,'en','Lock1-8 controller ',NULL);
INSERT INTO message VALUES(1943,'en','Lock2-8 controller ',NULL);
INSERT INTO message VALUES(1944,'en','KT2.3 IP-Stile 1',NULL);
INSERT INTO message VALUES(1945,'en','KT2.3 IP-Stile 1-8',NULL);
INSERT INTO message VALUES(1946,'en','KR05 IP-Stile 1',NULL);
INSERT INTO message VALUES(1947,'en','KR05 IP-Stile 1-8',NULL);
INSERT INTO message VALUES(1948,'en','IP-Stile with card capture 1',NULL);
INSERT INTO message VALUES(1949,'en','IP-Stile with card capture 1-8',NULL);
INSERT INTO message VALUES(1950,'en','ATP1 controller ',NULL);
INSERT INTO message VALUES(1951,'en','ATP1-8 controller ',NULL);
INSERT INTO message VALUES(1952,'en','Second level lock controller 1',NULL);
INSERT INTO message VALUES(1953,'en','Second-level controller',NULL);
INSERT INTO message VALUES(1954,'en','Turnstile post',NULL);
INSERT INTO message VALUES(1955,'en','Lock controller',NULL);
INSERT INTO message VALUES(1956,'en','1 CL05 Controller of the lock1',NULL);
INSERT INTO message VALUES(1957,'en','4-5 Controller of the turnstile 1-8 ',NULL);
INSERT INTO message VALUES(1958,'en','400 Controller of the 1-8 turnstile [Turnstile housing. Second level virtual controller] ',NULL);
INSERT INTO message VALUES(1959,'en','401 Controller of the turnstile 1-8  [CL201. Second level controller]',NULL);
INSERT INTO message VALUES(1960,'en','6-2 Controller of the 1-8 lock',NULL);
INSERT INTO message VALUES(1961,'en','600 Controller of the 1-8 lock [second level controller (Virtual or CL201)]',NULL);
INSERT INTO message VALUES(1962,'en','7-3 Controller of the 2-8 lock',NULL);
INSERT INTO message VALUES(1963,'en','700 Controller of the 2-8 lock [second level controller (Virtual or CL201)]',NULL);
INSERT INTO message VALUES(1964,'en','Activate',NULL);
INSERT INTO message VALUES(1965,'en','In "Closed" mode',NULL);
INSERT INTO message VALUES(1966,'en','In "Control" mode',NULL);
INSERT INTO message VALUES(1967,'en','In "Security" mode',NULL);
INSERT INTO message VALUES(1968,'en','In "Conference" mode',NULL);
INSERT INTO message VALUES(1969,'en','Verify identifiers of VISITORS',NULL);
INSERT INTO message VALUES(1970,'en','Verify identifiers of EMPLOYEES',NULL);
INSERT INTO message VALUES(1971,'en','Internal protection against transmission of identifiers (Local Antipass)',NULL);
INSERT INTO message VALUES(1972,'en','Time',NULL);
INSERT INTO message VALUES(1973,'en','Activation time',NULL);
INSERT INTO message VALUES(1974,'en','Waiting period for double-check',NULL);
INSERT INTO message VALUES(1975,'en','Waiting period for verification confirmation',NULL);
INSERT INTO message VALUES(1976,'en','Unlocked state holding time (identifier analysis time)',NULL);
INSERT INTO message VALUES(1977,'en','Alarm generator (1)',NULL);
INSERT INTO message VALUES(1978,'en','Alarm generator (1,2)',NULL);
INSERT INTO message VALUES(1979,'en','Alarm generator (3-10)',NULL);
INSERT INTO message VALUES(1980,'en','Alarm on housing tamper sensor',NULL);
INSERT INTO message VALUES(1981,'en','Alarm on unacceptably long opening of the device',NULL);
INSERT INTO message VALUES(1982,'en','Alarm on unauthorized unblocking of the device',NULL);
INSERT INTO message VALUES(1983,'en','Alarm on identifier presentation',NULL);
INSERT INTO message VALUES(1984,'en','Loud',NULL);
INSERT INTO message VALUES(1985,'en','Yes',NULL);
INSERT INTO message VALUES(1985,'it','Sì',NULL);
INSERT INTO message VALUES(1986,'en','Additional inputs',NULL);
INSERT INTO message VALUES(1987,'en','Additional inputs, masked on OD activation',NULL);
INSERT INTO message VALUES(1988,'en','Additional inputs, masked on OD unblocking ',NULL);
INSERT INTO message VALUES(1989,'en','Additional outputs',NULL);
INSERT INTO message VALUES(1990,'en','Additional outputs activated on activation ',NULL);
INSERT INTO message VALUES(1991,'en','Additional outputs activated on VISITORS valid identifiers presentation  ',NULL);
INSERT INTO message VALUES(1992,'en','Additional outputs activated on EMPLOYEES valid identifiers presentation ',NULL);
INSERT INTO message VALUES(1993,'en','Additional outputs, activated during OD unblocking',NULL);
INSERT INTO message VALUES(1994,'en','Additional outputs, normalized during OD unblocking',NULL);
INSERT INTO message VALUES(1995,'en','Additional outputs normalized when activated ',NULL);
INSERT INTO message VALUES(1996,'en','If the IDENTIFIER IS BANNED ',NULL);
INSERT INTO message VALUES(1997,'en','If the IDENTIFIER IS FROM THE STOP LIST ',NULL);
INSERT INTO message VALUES(1998,'en','If the IDENTIFIER IS NOT REGISTERED ',NULL);
INSERT INTO message VALUES(1999,'en','If EXPIRED ',NULL);
INSERT INTO message VALUES(2000,'en','If the WORKING HOURS ARE VIOLATED ',NULL);
INSERT INTO message VALUES(2001,'en','If ZONALITY IS VIOLATED',NULL);
INSERT INTO message VALUES(2002,'en','If the TIME IS VIOLATED',NULL);
INSERT INTO message VALUES(2003,'en','If the DOUBLE-CHECk ACCESS IS VIOLATED',NULL);
INSERT INTO message VALUES(2004,'en','Hard',NULL);
INSERT INTO message VALUES(2005,'en','Hard',NULL);
INSERT INTO message VALUES(2006,'en','Close (block) the device ',NULL);
INSERT INTO message VALUES(2007,'en','Closed',NULL);
INSERT INTO message VALUES(2008,'en','Energized ',NULL);
INSERT INTO message VALUES(2009,'en','Prohibition of the remote control',NULL);
INSERT INTO message VALUES(2010,'en','Protection against VISITORS identifiers handover (Antipass)  ',NULL);
INSERT INTO message VALUES(2011,'en','Protection against EMPLOYEES identifiers handover (Antipass) ',NULL);
INSERT INTO message VALUES(2012,'en','Pulse',NULL);
INSERT INTO message VALUES(2013,'en','Reader commands  ',NULL);
INSERT INTO message VALUES(2014,'en','Output operation instructions ',NULL);
INSERT INTO message VALUES(2015,'en','Access control alarm operation instructions ',NULL);
INSERT INTO message VALUES(2017,'en','Time control for the VISITORS identifiers (Antipass)',NULL);
INSERT INTO message VALUES(2019,'en','Time control for the EMPLOYEES identifiers (Antipass)',NULL);
INSERT INTO message VALUES(2020,'en','Activation criterion',NULL);
INSERT INTO message VALUES(2021,'en','Masking out criterion',NULL);
INSERT INTO message VALUES(2022,'en','Normalization criterion  ',NULL);
INSERT INTO message VALUES(2023,'en','Soft',NULL);
INSERT INTO message VALUES(2024,'en','Soft',NULL);
INSERT INTO message VALUES(2025,'en','For the operation time ',NULL);
INSERT INTO message VALUES(2026,'en','For the operation time and after operation ',NULL);
INSERT INTO message VALUES(2027,'en','For the specified time ',NULL);
INSERT INTO message VALUES(2028,'en','Not energized',NULL);
INSERT INTO message VALUES(2029,'en','New item',NULL);
INSERT INTO message VALUES(2030,'en','Device output normalization',NULL);
INSERT INTO message VALUES(2031,'en','Normalize',NULL);
INSERT INTO message VALUES(2032,'en','Normally closed',NULL);
INSERT INTO message VALUES(2033,'en','Normally open',NULL);
INSERT INTO message VALUES(2034,'en','Normal (ie Blocked) contact condition (device input)',NULL);
INSERT INTO message VALUES(2034,'it','Stato normale (bloccato)  del contatto (ingresso del dispositivo attuatore)',NULL);
INSERT INTO message VALUES(2035,'en','Normal state',NULL);
INSERT INTO message VALUES(2036,'en','Normal "Closed" state of the device output',NULL);
INSERT INTO message VALUES(2037,'en','Normal condition of the contact',NULL);
INSERT INTO message VALUES(2038,'en','Standard',NULL);
INSERT INTO message VALUES(2039,'en','Open (unblock) device',NULL);
INSERT INTO message VALUES(2040,'en','Raise the alarm',NULL);
INSERT INTO message VALUES(2041,'en','Confirmation from the remote control',NULL);
INSERT INTO message VALUES(2042,'en','After "Closing"',NULL);
INSERT INTO message VALUES(2043,'en','After "Opening"',NULL);
INSERT INTO message VALUES(2044,'en','Potential',NULL);
INSERT INTO message VALUES(2045,'en','Unlocking limit',NULL);
INSERT INTO message VALUES(2046,'en','When passing',NULL);
INSERT INTO message VALUES(2047,'en','When passing with VIOLATED TIMING',NULL);
INSERT INTO message VALUES(2048,'en','When passing with ZONALITY VIOLATION',NULL);
INSERT INTO message VALUES(2049,'en','Forward direction passage ',NULL);
INSERT INTO message VALUES(2050,'en','Disconnected',NULL);
INSERT INTO message VALUES(2051,'en','Registration of the passage with ID presentation',NULL);
INSERT INTO message VALUES(2052,'en','Output device control operation mode',NULL);
INSERT INTO message VALUES(2053,'en','Siren reset (Output "C" fire and security alarm)',NULL);
INSERT INTO message VALUES(2054,'en','Alarm reset (Alarm generator)',NULL);
INSERT INTO message VALUES(2055,'en','Reset the alarm',NULL);
INSERT INTO message VALUES(2056,'en','Special',NULL);
INSERT INTO message VALUES(2057,'en','Silent',NULL);
INSERT INTO message VALUES(2058,'en','Set the "Closed" operating mode ',NULL);
INSERT INTO message VALUES(2059,'en','Set the "Control" operating mode ',NULL);
INSERT INTO message VALUES(2060,'en','Set the "Open" operating mode ',NULL);
INSERT INTO message VALUES(2061,'en','Set the "Meeting" operating mode ',NULL);
INSERT INTO message VALUES(2062,'en','Activate',NULL);
INSERT INTO message VALUES(2063,'en','Deactivate',NULL);
INSERT INTO message VALUES(2064,'en','Submit configuration changes to controllers',NULL);
INSERT INTO message VALUES(2065,'en','Submit the entire configuration to the controllers',NULL);
INSERT INTO message VALUES(2066,'en','Command ',NULL);
INSERT INTO message VALUES(2067,'en','Drag',NULL);
INSERT INTO message VALUES(2068,'en','Search devices',NULL);
INSERT INTO message VALUES(2069,'en','Search devices by IP',NULL);
INSERT INTO message VALUES(2070,'en','Add controller',NULL);
INSERT INTO message VALUES(2071,'en','Find devices by IP-address',NULL);
INSERT INTO message VALUES(2073,'en','day corresponds to the 1st type;',NULL);
INSERT INTO message VALUES(2074,'en','day corresponds to the 2nd type;',NULL);
INSERT INTO message VALUES(2075,'en','day corresponds to the 3rd type;',NULL);
INSERT INTO message VALUES(2076,'en','day corresponds to the 4th type;',NULL);
INSERT INTO message VALUES(2077,'en','day corresponds to the 5th type;',NULL);
INSERT INTO message VALUES(2078,'en','day corresponds to the 6th type;',NULL);
INSERT INTO message VALUES(2079,'en','day corresponds to the 7th type;',NULL);
INSERT INTO message VALUES(2080,'en','day corresponds to the 8th type;',NULL);
INSERT INTO message VALUES(2081,'en','Security system controllers events',NULL);
INSERT INTO message VALUES(2081,'it','Eventi dei controller del sistema di sicurezza',NULL);
INSERT INTO message VALUES(2082,'en','Credentials change',NULL);
INSERT INTO message VALUES(2082,'it','Modifica delle credenziali',NULL);
INSERT INTO message VALUES(2083,'en','Server equipment events',NULL);
INSERT INTO message VALUES(2083,'it','Eventi del server di apparecchiature',NULL);
INSERT INTO message VALUES(2084,'en','13.2 Events related to the identifier code access (category 1)',NULL);
INSERT INTO message VALUES(2084,'it','13.2 Eventi legati all''accesso con codice di identificatore (categoria 1)',NULL);
INSERT INTO message VALUES(2085,'en','13.3 Events associated with changes of the protected zone state (category 2)',NULL);
INSERT INTO message VALUES(2085,'it','13.3 Eventi associati con i cambiamenti di stato della Zona di protezione (categoria 2)',NULL);
INSERT INTO message VALUES(2086,'en','13.4 events associated with changes of the current state of alarm line, included into the protected zone (category 3)',NULL);
INSERT INTO message VALUES(2086,'it','13.4 Eventi associati con le modifiche nello stato attuale di sistemi di cavi allarme inclusi nella Zona di protezione (categoria 3)',NULL);
INSERT INTO message VALUES(2087,'en','13.5 Events related to the input / output status (category 4)',NULL);
INSERT INTO message VALUES(2087,'it','13.5.Eventi legati allo stato di ingressi/uscite (categoria 4)',NULL);
INSERT INTO message VALUES(2088,'en','13.6 Events related to the  passages through the device without identifiers (category 5)',NULL);
INSERT INTO message VALUES(2088,'it','13.6 Eventi connessi con passaggi attraverso il dispositivo attuatore senza identificatori (categoria 5)',NULL);
INSERT INTO message VALUES(2089,'en','13.7 Events related to the functioning (category 6)',NULL);
INSERT INTO message VALUES(2089,'it','13.7 Eventi legati al funzionamento (categoria 6)',NULL);
INSERT INTO message VALUES(2090,'en','User activity',NULL);
INSERT INTO message VALUES(2090,'it','Attivita'' dell''utente',NULL);
INSERT INTO message VALUES(2091,'en','Interaction with database',NULL);
INSERT INTO message VALUES(2092,'en','Connection with the controller',NULL);
INSERT INTO message VALUES(2092,'it','Il collegamento con il controller',NULL);
INSERT INTO message VALUES(2093,'en','Interaction with web-server',NULL);
INSERT INTO message VALUES(2095,'en','Device arming: the device switched to the ARMING mode',NULL);
INSERT INTO message VALUES(2096,'en','Protected zone arming by the identifier: protected zone switched to the ARMING mode  ',NULL);
INSERT INTO message VALUES(2097,'en','Protected zone arming by the operator command: protected zone switched to the ARMING mode ',NULL);
INSERT INTO message VALUES(2098,'en','Security alarm line arming: security alarm line switched to the ARMING mode',NULL);
INSERT INTO message VALUES(2099,'en','Security alarm line recovery in ALARM mode',NULL);
INSERT INTO message VALUES(2100,'en','Device is armed: device switched to the SECURITY mode',NULL);
INSERT INTO message VALUES(2101,'en','Device is disarmed: device switched to the DISARMED mode, including "disarming" mode',NULL);
INSERT INTO message VALUES(2102,'en','Housing of the sending box is tampered',NULL);
INSERT INTO message VALUES(2103,'en','Housing of the sending box is closed:',NULL);
INSERT INTO message VALUES(2104,'en','Device violation, ALARM mode: device switched to the ALARM mode  ',NULL);
INSERT INTO message VALUES(2105,'en','Security alarm line violation in the ALARM mode ',NULL);
INSERT INTO message VALUES(2106,'en','Security alarm line violation, ALARM mode with "silent" option: security alarm line switched to the ALARM mode, including "alarm in disarming" mode  ',NULL);
INSERT INTO message VALUES(2107,'en','Security alarm line violation, ALARM mode: security alarm line switched to the ALARM mode, including "alarm in disarming" mode ',NULL);
INSERT INTO message VALUES(2108,'en','Disarmed security alarm line violation ',NULL);
INSERT INTO message VALUES(2109,'en','Normalization of the disarmed security alarm line',NULL);
INSERT INTO message VALUES(2110,'en','Protected zone is armed by the identifier with the confirmation: protected zone switched to the SECURITY mode',NULL);
INSERT INTO message VALUES(2111,'en','Protected zone is armed by the identifier: protected zone switched to the SECURITY mode ',NULL);
INSERT INTO message VALUES(2112,'en','Protected zone is armed by the operator command: protected zone switched to the SECURITY mode ',NULL);
INSERT INTO message VALUES(2113,'en','Protected zone is disarmed by the identifier with the confirmation: protected zone switched to the DISARMED mode ',NULL);
INSERT INTO message VALUES(2114,'en','Protected zone is disarmed by the identifier: protected zone switched to the DISARMED mode',NULL);
INSERT INTO message VALUES(2115,'en','Protected zone is disarmed by the operator command: protected zone siwtched to the "DISARMED" mode',NULL);
INSERT INTO message VALUES(2116,'en','Security alarm line is armed: Security alarm line switched to SECURITY mode',NULL);
INSERT INTO message VALUES(2117,'en','Security alarm line is disarmed: Security alarm line switched to the AUTOREARMING mode',NULL);
INSERT INTO message VALUES(2118,'en','Security alarm line is turned off ',NULL);
INSERT INTO message VALUES(2119,'en','Security alarm line is disarmed: Security alarm line switched to DISARMED mode, including "disarming" mode',NULL);
INSERT INTO message VALUES(2120,'en','Attempt to arm the protected zone (can not be armed) by the identifier: double-check access violation ',NULL);
INSERT INTO message VALUES(2121,'en','Attempt to arm the protected zone (can not be armed) by the identifier: violation of the device resource state ',NULL);
INSERT INTO message VALUES(2122,'en','Attempt to arm the protected zone (can not be armed) by the identifier: violation of the alarm line resource state (in "disarming" mode)',NULL);
INSERT INTO message VALUES(2123,'en','Attempt to arm the protected zone (can not be armed) by the identifier: mismatch to the time access criteria and to the current location',NULL);
INSERT INTO message VALUES(2124,'en','Attempt to arm the protected zone (can not be armed) by the identifier: mismatch of the time access criteria ',NULL);
INSERT INTO message VALUES(2125,'en','Attempt to arm the protected zone (can not be armed) by the identifier: mismatch to the current location ',NULL);
INSERT INTO message VALUES(2126,'en','Attempt to arm the protected zone (can not be armed) by the identifier: refusal of arming confirmation from the verification ',NULL);
INSERT INTO message VALUES(2127,'en','Attempt to arm the protected zone (can not be armed) by the identifier: arming denial ',NULL);
INSERT INTO message VALUES(2128,'en','Attempt to arm the protected zone (can not be armed) by the operator command: violation of the device resource state ',NULL);
INSERT INTO message VALUES(2129,'en','Attempt to arm the protected zone (can not be armed) by the operator command: violation of the alarm line resource state (in "disarming" mode) ',NULL);
INSERT INTO message VALUES(2130,'en','Attempt to disarm the protected zone (can not be disarmed) by the identifier: double-check access violation',NULL);
INSERT INTO message VALUES(2131,'en','Attempt to disarm the protected zone (can not be disarmed) by the identifier: mismatch to the time access criteria and to the current location ',NULL);
INSERT INTO message VALUES(2132,'en','Attempt to disarm the protected zone (can not be disarmed) by the identifier: mismatch of the time access criteria',NULL);
INSERT INTO message VALUES(2133,'en','Attempt to disarm the protected zone (can not be disarmed) by the identifier: mismatch to the current location',NULL);
INSERT INTO message VALUES(2134,'en','Attempt to disarm the protected zone (can not be disarmed) by the identifier: denial of disarmour confirmation from the verification  ',NULL);
INSERT INTO message VALUES(2135,'en','Attempt to disarm the protected zone (can not be disarmed) by the identifier: denial of disarmour',NULL);
INSERT INTO message VALUES(2136,'en','Reset alarm of the device ',NULL);
INSERT INTO message VALUES(2137,'en','Reset alarm of the security alarm line ',NULL);
INSERT INTO message VALUES(2138,'en','Reset alarm on the protected zone ',NULL);
INSERT INTO message VALUES(2139,'en','Silent alarm on the protected zone: protected zone switched into ALARM mode, including "alarm in disarming" mode',NULL);
INSERT INTO message VALUES(2140,'en','Alarm on the protected zone: protected zone switched into ALARM mode, including "alarm in disarming" mode',NULL);
INSERT INTO message VALUES(2141,'en','Autonomous alarm reset: Press the "Reset" button',NULL);
INSERT INTO message VALUES(2142,'en','Activation of exit is not possible, due to short circuit: Only for exits with status monitoring',NULL);
INSERT INTO message VALUES(2143,'en','Input activation',NULL);
INSERT INTO message VALUES(2144,'en','Output activation',NULL);
INSERT INTO message VALUES(2145,'en','Controller power-on',NULL);
INSERT INTO message VALUES(2146,'en','+18 Power supply recovery: Formed with integrated ADC when power voltage of alarm line returns in the operating range',NULL);
INSERT INTO message VALUES(2147,'en','Power supply recovery: Provided that the power voltage is in the operating range.',NULL);
INSERT INTO message VALUES(2148,'en','Output recovery: only for outputs with status control. Recovery of line after short circuit or line break.',NULL);
INSERT INTO message VALUES(2149,'en','Recovery after a failure of controller of level 2',NULL);
INSERT INTO message VALUES(2150,'en','Connection recovery',NULL);
INSERT INTO message VALUES(2151,'en','Connection recovery with the controller of level 2',NULL);
INSERT INTO message VALUES(2152,'en','Controller power-off',NULL);
INSERT INTO message VALUES(2153,'en','Passage denial by the operator command:',NULL);
INSERT INTO message VALUES(2154,'en','Passage denial by the remote control command:',NULL);
INSERT INTO message VALUES(2155,'en','Passage denial:',NULL);
INSERT INTO message VALUES(2156,'en','Passage denial: double-check access violation ',NULL);
INSERT INTO message VALUES(2157,'en','Passage denial: mismatch to the time access criteria',NULL);
INSERT INTO message VALUES(2158,'en','Passage denial: mismatch to the time access criteria and to the current location ',NULL);
INSERT INTO message VALUES(2159,'en','Passage denial: mismatch to the current location ',NULL);
INSERT INTO message VALUES(2160,'en','Passage denial: passage disaffirmance from the verification',NULL);
INSERT INTO message VALUES(2161,'en','Starting the output activation detention ',NULL);
INSERT INTO message VALUES(2162,'en','The device was not closed after passage with identifier:',NULL);
INSERT INTO message VALUES(2163,'en','Changing the operating mode to the "Security" mode by the identifier: "Security" mode',NULL);
INSERT INTO message VALUES(2164,'en','Changing the operating mode by the IR-remote command: "Closed" mode ',NULL);
INSERT INTO message VALUES(2165,'en','Changing the operating mode by the IR-remote command: "Control" mode ',NULL);
INSERT INTO message VALUES(2166,'en','Changing the operating mode by the IR-remote command: "Open" mode ',NULL);
INSERT INTO message VALUES(2167,'en','Changing the operating mode by the IR-remote command: "Conference" mode ',NULL);
INSERT INTO message VALUES(2168,'en','Changing the operating mode by the operator command: "Closed" mode ',NULL);
INSERT INTO message VALUES(2169,'en','Changing the operating mode by the operator command: "Control" mode ',NULL);
INSERT INTO message VALUES(2170,'en','Changing the operating mode by the operator command: "Open" mode ',NULL);
INSERT INTO message VALUES(2171,'en','Changing the operating mode by the operator command: "Security" mode ',NULL);
INSERT INTO message VALUES(2172,'en','Changing the operating mode by the operator command: "Conference" mode ',NULL);
INSERT INTO message VALUES(2173,'en','Changing the operating mode from the "Security" mode by the identifier: "Control" mode',NULL);
INSERT INTO message VALUES(2174,'en','Changing the operating mode from the "Security" mode by the identifier: "Open" mode',NULL);
INSERT INTO message VALUES(2175,'en','Changing the operating mode from the "Security" mode by the identifier: "Conference" mode',NULL);
INSERT INTO message VALUES(2176,'en','User credentials change ',NULL);
INSERT INTO message VALUES(2177,'en','Short circuit at the output: for outputs with status check only ',NULL);
INSERT INTO message VALUES(2178,'en','Controller housing is closed',NULL);
INSERT INTO message VALUES(2179,'en','Controller housing is opened ',NULL);
INSERT INTO message VALUES(2180,'en','Connection failure ',NULL);
INSERT INTO message VALUES(2181,'en','+18 V power supply fault: Formed with the integrated ADC on alarm line power voltage overrange1',NULL);
INSERT INTO message VALUES(2182,'en','Fault of the power supply: Formed with the integrated ADC on power voltage overrange',NULL);
INSERT INTO message VALUES(2183,'en','Fault of the 2nd level controller',NULL);
INSERT INTO message VALUES(2184,'en','Fault of controller: DataFlash memory',NULL);
INSERT INTO message VALUES(2185,'en','Fault of controller: FRAM memory',NULL);
INSERT INTO message VALUES(2186,'en','Fault of controller: RTC clock',NULL);
INSERT INTO message VALUES(2187,'en','Fault of controller: I2C wire ',NULL);
INSERT INTO message VALUES(2188,'en','Unauthorized passage through device (OD break in)',NULL);
INSERT INTO message VALUES(2189,'en','Input normalization ',NULL);
INSERT INTO message VALUES(2190,'en','Output normalization ',NULL);
INSERT INTO message VALUES(2191,'en','Output disconnection: For outputs with status check only ',NULL);
INSERT INTO message VALUES(2192,'en','Object controller is created ',NULL);
INSERT INTO message VALUES(2193,'en','Object controller is deleted ',NULL);
INSERT INTO message VALUES(2194,'en','Passing denial: ',NULL);
INSERT INTO message VALUES(2195,'en','Cleaning log',NULL);
INSERT INTO message VALUES(2196,'en','Restart controller: WatchDog',NULL);
INSERT INTO message VALUES(2197,'en','Log file trashing',NULL);
INSERT INTO message VALUES(2198,'en','Identifier list trashing',NULL);
INSERT INTO message VALUES(2199,'en','Commissioning card presented',NULL);
INSERT INTO message VALUES(2200,'en','Presentation of a banned card: ACM violation',NULL);
INSERT INTO message VALUES(2201,'en','Presentation of an invalid card: ID banned',NULL);
INSERT INTO message VALUES(2202,'en','Presentation of an invalid card: ID from "stop list"',NULL);
INSERT INTO message VALUES(2203,'en','Presentation of an invalid card: ID is not registered',NULL);
INSERT INTO message VALUES(2204,'en','Presentation of an invalid card: ID expired',NULL);
INSERT INTO message VALUES(2205,'en','Connection loss with the 2nd level controller',NULL);
INSERT INTO message VALUES(2206,'en','Passage with the ID:',NULL);
INSERT INTO message VALUES(2207,'en','Passage with the ID: mismatch to the time access criteria and to the current location',NULL);
INSERT INTO message VALUES(2208,'en','Passage with the ID: mismatch to the time access criteria and to the current location and with the failure to confirm the passage by verification',NULL);
INSERT INTO message VALUES(2209,'en','Passage with the ID: mismatch to the time access criteria and to the current location and with the double-check access violation',NULL);
INSERT INTO message VALUES(2210,'en','Passage with the ID: in case of failure to confirm the passage by verification',NULL);
INSERT INTO message VALUES(2211,'en','Passage with the ID: with double-check access violation',NULL);
INSERT INTO message VALUES(2212,'en','Passage with the ID: with the mismatch to the time access criteria',NULL);
INSERT INTO message VALUES(2213,'en','Passage with the ID: with the mismatch to the time access criteria and in case of failure to confirm the passage by verification',NULL);
INSERT INTO message VALUES(2214,'en','Passage with the ID: with the mismatch to the time access criteria and with double-check access violation',NULL);
INSERT INTO message VALUES(2215,'en','Passage with the ID: with the mismatch to the current location',NULL);
INSERT INTO message VALUES(2216,'en','Passage with the ID: with the mismatch to the current location and in case of failure to confirm the passage by verification',NULL);
INSERT INTO message VALUES(2217,'en','Passage with the ID: with the mismatch to the current location and with double-check access violation ',NULL);
INSERT INTO message VALUES(2218,'en','Passage by the IR-remote command',NULL);
INSERT INTO message VALUES(2219,'en','Passage by the remote control command',NULL);
INSERT INTO message VALUES(2220,'en','Passage by the PC command',NULL);
INSERT INTO message VALUES(2221,'en','Passage with the confirmation from the remote control:',NULL);
INSERT INTO message VALUES(2222,'en','Passage with the confirmation from the remote control: mismatch to the time criteria and to the current location',NULL);
INSERT INTO message VALUES(2223,'en','Passage with the confirmation from the remote control: with the mismatch to the time access criteria',NULL);
INSERT INTO message VALUES(2224,'en','Passage with the confirmation from the remote control: with the mismatch to the current location',NULL);
INSERT INTO message VALUES(2225,'en','Passage with the confirmation from verification:',NULL);
INSERT INTO message VALUES(2226,'en','Passage with the confirmation from verification: with the mismatch of the access criteria to the current location',NULL);
INSERT INTO message VALUES(2227,'en','Passage with the confirmation from verification: with the mismatch to the time access criteria',NULL);
INSERT INTO message VALUES(2228,'en','Passage with the confirmation from verification: with the mismatch to the current location',NULL);
INSERT INTO message VALUES(2229,'en','Ethernet physical level failure',NULL);
INSERT INTO message VALUES(2230,'en','Alarm reset: From the software',NULL);
INSERT INTO message VALUES(2231,'en','Session with the controller is open',NULL);
INSERT INTO message VALUES(2232,'en','Connection with the web-server is broken',NULL);
INSERT INTO message VALUES(2233,'en','Connection with the web-server is made',NULL);
INSERT INTO message VALUES(2234,'en','Connection with the database is broken',NULL);
INSERT INTO message VALUES(2235,'en','Connection with the database is made',NULL);
INSERT INTO message VALUES(2236,'en','Connection with the controller is broken',NULL);
INSERT INTO message VALUES(2237,'en','Connection with the controller is made',NULL);
INSERT INTO message VALUES(2238,'en','Alarm line testing is completed',NULL);
INSERT INTO message VALUES(2239,'en','Alarm line testing has begun',NULL);
INSERT INTO message VALUES(2240,'en','Device testing has detected failures',NULL);
INSERT INTO message VALUES(2241,'en','Device testing is successfully completed    ',NULL);
INSERT INTO message VALUES(2242,'en','Device testing has begun',NULL);
INSERT INTO message VALUES(2243,'en','Alarm on an IR-remote signal ',NULL);
INSERT INTO message VALUES(2244,'en','Alarm: From the Alarm Generator',NULL);
INSERT INTO message VALUES(2245,'en','Memory formating: event log',NULL);
INSERT INTO message VALUES(2246,'en','Memory formating: configuration',NULL);
INSERT INTO message VALUES(2247,'en','Memory formating: firmware',NULL);
INSERT INTO message VALUES(2248,'en','Memory formating: card list ',NULL);
INSERT INTO message VALUES(2249,'en','Memory formating: the current settings (operating modes, etc.)',NULL);
INSERT INTO message VALUES(2250,'en','To the database only',NULL);
INSERT INTO message VALUES(2251,'en','All to controller',NULL);
INSERT INTO message VALUES(2252,'en','Changed into the controller',NULL);
INSERT INTO message VALUES(2253,'en','Milliseconds',NULL);
INSERT INTO message VALUES(2254,'en','Seconds',NULL);
INSERT INTO message VALUES(2255,'en','Infinity',NULL);
INSERT INTO message VALUES(2435,'en','Verification timeout (the time during which the controller, which sent the request for verification, will wait for a reply from the operator)',NULL);
INSERT INTO message VALUES(2981,'en','Pass office',NULL);
INSERT INTO message VALUES(2982,'en','Time & Attendance',NULL);
INSERT INTO message VALUES(2983,'en','Verification',NULL);
INSERT INTO message VALUES(2984,'en','Administration',NULL);
INSERT INTO message VALUES(2985,'en','Card design',NULL);
INSERT INTO message VALUES(2986,'en','Worked time log',NULL);
INSERT INTO message VALUES(2987,'en','Job card formation',NULL);
INSERT INTO message VALUES(2988,'en','Access control',NULL);
INSERT INTO message VALUES(2989,'en','List of events',NULL);
INSERT INTO message VALUES(2990,'en','Discipline reports',NULL);
INSERT INTO message VALUES(2991,'en','Location',NULL);
INSERT INTO message VALUES(2992,'en','Verification log ',NULL);
INSERT INTO message VALUES(2993,'en','Visitors report ',NULL);
INSERT INTO message VALUES(2994,'en','Room access events',NULL);
INSERT INTO message VALUES(2995,'en','Verification configuration ',NULL);
INSERT INTO message VALUES(2996,'en','Roles and permissions',NULL);
INSERT INTO message VALUES(2997,'en','System events',NULL);
INSERT INTO message VALUES(2998,'en','Operators',NULL);
INSERT INTO message VALUES(2999,'en','Additional data ',NULL);
INSERT INTO message VALUES(3000,'en','Task planner',NULL);
INSERT INTO message VALUES(3001,'en','Device management',NULL);
INSERT INTO message VALUES(3002,'en','Configuration ',NULL);
INSERT INTO message VALUES(3004,'en','Hide the menu',NULL);
INSERT INTO message VALUES(3005,'en','Expand the menu',NULL);
INSERT INTO message VALUES(3006,'en','Enter',NULL);
INSERT INTO message VALUES(3008,'en','All rooms',NULL);
INSERT INTO message VALUES(3009,'en','All departments',NULL);
INSERT INTO message VALUES(3010,'en','Minimize',NULL);
INSERT INTO message VALUES(3011,'en','Page',NULL);
INSERT INTO message VALUES(3012,'en','from',NULL);
INSERT INTO message VALUES(3013,'en','Search...',NULL);
INSERT INTO message VALUES(3014,'en','Record',NULL);
INSERT INTO message VALUES(3015,'en','Displaying',NULL);
INSERT INTO message VALUES(3016,'en','Auto update',NULL);
INSERT INTO message VALUES(3017,'en','Violators',NULL);
INSERT INTO message VALUES(3018,'en','Undertime hours',NULL);
INSERT INTO message VALUES(3019,'en','Information on the passages ',NULL);
INSERT INTO message VALUES(3020,'en','Are you sure that you want to delete this schedule?',NULL);
INSERT INTO message VALUES(3021,'en','Copy the day ',NULL);
INSERT INTO message VALUES(3022,'en','Insert day',NULL);
INSERT INTO message VALUES(3023,'en','Day contains switching intervals, do not copy',NULL);
INSERT INTO message VALUES(3024,'en','Day contains switching intervals, do not insert',NULL);
INSERT INTO message VALUES(3025,'en','year',NULL);
INSERT INTO message VALUES(3026,'en','This department is already created',NULL);
INSERT INTO message VALUES(3027,'en','Department is not selected',NULL);
INSERT INTO message VALUES(3028,'en','Are you sure that you want to delete',NULL);
INSERT INTO message VALUES(3029,'en','Too long name',NULL);
INSERT INTO message VALUES(3030,'en','Department adding',NULL);
INSERT INTO message VALUES(3032,'en','Text data',NULL);
INSERT INTO message VALUES(3033,'en','Telephone',NULL);
INSERT INTO message VALUES(3034,'en','Begin',NULL);
INSERT INTO message VALUES(3035,'en','Recalculate',NULL);
INSERT INTO message VALUES(3036,'en','Form a T12 (Excel)',NULL);
INSERT INTO message VALUES(3037,'en','T12',NULL);
INSERT INTO message VALUES(3038,'en','Resettlement',NULL);
INSERT INTO message VALUES(3039,'en','Recalculate',NULL);
INSERT INTO message VALUES(3040,'en','Access and arming/disarming ',NULL);
INSERT INTO message VALUES(3041,'en','Access and arming/disarming with double-check access ',NULL);
INSERT INTO message VALUES(3042,'en','Double-check access and arming/disarmig with double-check access ',NULL);
INSERT INTO message VALUES(3044,'en','Always',NULL);
INSERT INTO message VALUES(3045,'en','Pass parameters',NULL);
INSERT INTO message VALUES(3046,'en','Card colour',NULL);
INSERT INTO message VALUES(3047,'en','Add image',NULL);
INSERT INTO message VALUES(3049,'en','Readers',NULL);
INSERT INTO message VALUES(3050,'en','Alarm generators',NULL);
INSERT INTO message VALUES(3051,'en','Locks ',NULL);
INSERT INTO message VALUES(3052,'en','This controller is not active. Contact your system administrator for help',NULL);
INSERT INTO message VALUES(3053,'en','Do you want to reset the default settings for the selected department?',NULL);
INSERT INTO message VALUES(3054,'en','Order date',NULL);
INSERT INTO message VALUES(3055,'en','Archiving date',NULL);
INSERT INTO message VALUES(3056,'en','Send identifiers to the controllers...',NULL);
INSERT INTO message VALUES(3057,'en','Card validity',NULL);
INSERT INTO message VALUES(3058,'en','Following controllers might face access problems. ',NULL);
INSERT INTO message VALUES(3059,'en','Validity',NULL);
INSERT INTO message VALUES(3060,'en','Identifier is invalid',NULL);
INSERT INTO message VALUES(3061,'en','Identifier is invalid in',NULL);
INSERT INTO message VALUES(3062,'en','controllers',NULL);
INSERT INTO message VALUES(3063,'en','Not selected',NULL);
INSERT INTO message VALUES(3064,'en','Verification template',NULL);
INSERT INTO message VALUES(3065,'en','Refresh the table',NULL);
INSERT INTO message VALUES(3066,'en','Submit changed identifiers to controllers',NULL);
INSERT INTO message VALUES(3067,'en','Pass order date',NULL);
INSERT INTO message VALUES(3068,'en','Card archiving date',NULL);
INSERT INTO message VALUES(3069,'en','Submit the changes to device',NULL);
INSERT INTO message VALUES(3070,'en','Information on the passage printing',NULL);
INSERT INTO message VALUES(3071,'en','Verification point ',NULL);
INSERT INTO message VALUES(3072,'en','All points',NULL);
INSERT INTO message VALUES(3073,'en','Event',NULL);
INSERT INTO message VALUES(3074,'en','Response',NULL);
INSERT INTO message VALUES(3075,'en','All readers',NULL);
INSERT INTO message VALUES(3076,'en','All users',NULL);
INSERT INTO message VALUES(3077,'en','Passage picture ',NULL);
INSERT INTO message VALUES(3078,'en','Storyboards',NULL);
INSERT INTO message VALUES(3079,'en','Video',NULL);
INSERT INTO message VALUES(3080,'en','Users',NULL);
INSERT INTO message VALUES(3081,'en','Verification points',NULL);
INSERT INTO message VALUES(3082,'en','Event type',NULL);
INSERT INTO message VALUES(3083,'en','Identifier ',NULL);
INSERT INTO message VALUES(3084,'en','Card',NULL);
INSERT INTO message VALUES(3085,'en','Card?',NULL);
INSERT INTO message VALUES(3090,'en','No picture ',NULL);
INSERT INTO message VALUES(3091,'en','No pictures ',NULL);
INSERT INTO message VALUES(3092,'en','All events',NULL);
INSERT INTO message VALUES(3093,'en','Event has not been selected',NULL);
INSERT INTO message VALUES(3094,'en','Generate report',NULL);
INSERT INTO message VALUES(3095,'en','Templates not selected',NULL);
INSERT INTO message VALUES(3096,'en','Are you sure that you want to delete this [these] template[s]?',NULL);
INSERT INTO message VALUES(3097,'en','Verification points are to be added ',NULL);
INSERT INTO message VALUES(3098,'en','The name is already in use',NULL);
INSERT INTO message VALUES(3099,'en','Verification template adding',NULL);
INSERT INTO message VALUES(3100,'en','Verification template editing',NULL);
INSERT INTO message VALUES(3101,'en','Selected reader is already used in the current template',NULL);
INSERT INTO message VALUES(3102,'en','Reader is to be selected ',NULL);
INSERT INTO message VALUES(3103,'en','Verification point not chosen ',NULL);
INSERT INTO message VALUES(3104,'en','Are you sure that you want to delete this verification point?',NULL);
INSERT INTO message VALUES(3105,'en','Reader post ',NULL);
INSERT INTO message VALUES(3106,'en','Camera ',NULL);
INSERT INTO message VALUES(3107,'en','Control point adding',NULL);
INSERT INTO message VALUES(3108,'en','Milestone editing',NULL);
INSERT INTO message VALUES(3109,'en','Milestone copying ',NULL);
INSERT INTO message VALUES(3110,'en','New verification point   ',NULL);
INSERT INTO message VALUES(3111,'en','Information display time can not be more than 120 seconds',NULL);
INSERT INTO message VALUES(3112,'en','Selected hot keys are already used in the current template',NULL);
INSERT INTO message VALUES(3113,'en','One template shall not contain cameras from different servers',NULL);
INSERT INTO message VALUES(3114,'en','Reader was not selected',NULL);
INSERT INTO message VALUES(3115,'en','Video server not chosen ',NULL);
INSERT INTO message VALUES(3116,'en','Camera not selected',NULL);
INSERT INTO message VALUES(3117,'en','Video servers not selected',NULL);
INSERT INTO message VALUES(3118,'en','Are you sure that you want to delete this [these] video server[s]?',NULL);
INSERT INTO message VALUES(3119,'en','Selected camera is already in use',NULL);
INSERT INTO message VALUES(3120,'en','Cameras not selected',NULL);
INSERT INTO message VALUES(3121,'en','Are you sure that you want to delete this [these] camera[s]?',NULL);
INSERT INTO message VALUES(3122,'en','Video server adding',NULL);
INSERT INTO message VALUES(3123,'en','Video server editing',NULL);
INSERT INTO message VALUES(3124,'en','Select the video server that the camera will be added to',NULL);
INSERT INTO message VALUES(3125,'en','Camera adding',NULL);
INSERT INTO message VALUES(3126,'en','Camera editing',NULL);
INSERT INTO message VALUES(3127,'en','Name is not specified ',NULL);
INSERT INTO message VALUES(3128,'en','Host is not specified ',NULL);
INSERT INTO message VALUES(3129,'en','Camera template is not specified ',NULL);
INSERT INTO message VALUES(3130,'en','This name already exists ',NULL);
INSERT INTO message VALUES(3131,'en','Manufacturers',NULL);
INSERT INTO message VALUES(3132,'en','Patterns',NULL);
INSERT INTO message VALUES(3133,'en','Manufacturer',NULL);
INSERT INTO message VALUES(3134,'en','Model',NULL);
INSERT INTO message VALUES(3135,'en','Stream type',NULL);
INSERT INTO message VALUES(3136,'en','Fixed',NULL);
INSERT INTO message VALUES(3137,'en','Number of channels ',NULL);
INSERT INTO message VALUES(3138,'en','Path name',NULL);
INSERT INTO message VALUES(3139,'en','Camera template not selected',NULL);
INSERT INTO message VALUES(3140,'en','Are you sure that you want to delete this [these] template[s]?',NULL);
INSERT INTO message VALUES(3141,'en','Select from existing',NULL);
INSERT INTO message VALUES(3142,'en','Camera template adding',NULL);
INSERT INTO message VALUES(3143,'en','Camera template editing',NULL);
INSERT INTO message VALUES(3144,'en','Camera template copying ',NULL);
INSERT INTO message VALUES(3145,'en','One must not edit the fixed templates ',NULL);
INSERT INTO message VALUES(3146,'en','Manufacturer is not specified ',NULL);
INSERT INTO message VALUES(3147,'en','Model is not specified',NULL);
INSERT INTO message VALUES(3148,'en','Number of channels can be from 0 to 25',NULL);
INSERT INTO message VALUES(3149,'en','Template with such parameters already exists',NULL);
INSERT INTO message VALUES(3150,'en','Read. 1',NULL);
INSERT INTO message VALUES(3151,'en','Read. 2',NULL);
INSERT INTO message VALUES(3152,'en','Main parameters',NULL);
INSERT INTO message VALUES(3153,'en','Lines',NULL);
INSERT INTO message VALUES(3154,'en','Ok',NULL);
INSERT INTO message VALUES(3155,'en','System error',NULL);
INSERT INTO message VALUES(3156,'en','One controller/room is to be selected ',NULL);
INSERT INTO message VALUES(3157,'en','Edit room',NULL);
INSERT INTO message VALUES(3158,'en','This room must not be renaimed',NULL);
INSERT INTO message VALUES(3159,'en','Add room',NULL);
INSERT INTO message VALUES(3160,'en','Device is inactive  ',NULL);
INSERT INTO message VALUES(3161,'en','Line',NULL);
INSERT INTO message VALUES(3163,'en','Access to sections',NULL);
INSERT INTO message VALUES(3164,'en','Roles authorities',NULL);
INSERT INTO message VALUES(3165,'en','Cameras',NULL);
INSERT INTO message VALUES(3166,'en','Video servers',NULL);
INSERT INTO message VALUES(3167,'en','T&A 2 ',NULL);
INSERT INTO message VALUES(3168,'en','IP-address of gateway',NULL);
INSERT INTO message VALUES(3169,'en','MAC address',NULL);
INSERT INTO message VALUES(3170,'en','Wiegand 26',NULL);
INSERT INTO message VALUES(3171,'en','Vertical',NULL);
INSERT INTO message VALUES(3172,'en','OD break in',NULL);
INSERT INTO message VALUES(3172,'it','Hacking del dispositivo attuatore',NULL);
INSERT INTO message VALUES(3173,'en','Duration of recording (seconds)',NULL);
INSERT INTO message VALUES(3174,'en','Response period to system server request (maximum 12 sec; on default - 5 sec)',NULL);
INSERT INTO message VALUES(3175,'en','Information display time about employee (by default - 2 sec)',NULL);
INSERT INTO message VALUES(3176,'en','Pre-recording period (seconds)',NULL);
INSERT INTO message VALUES(3177,'en','Horizontal',NULL);
INSERT INTO message VALUES(3178,'en','Web-interface access',NULL);
INSERT INTO message VALUES(3179,'en','Framerate recording ',NULL);
INSERT INTO message VALUES(3180,'en','Protection against identifiers handover (Antipass)',NULL);
INSERT INTO message VALUES(3181,'en','Identifier is BLOCKED ',NULL);
INSERT INTO message VALUES(3182,'en','Identifier is NOT REGISTERED ',NULL);
INSERT INTO message VALUES(3183,'en','Identifier EXPIRED ',NULL);
INSERT INTO message VALUES(3184,'en','Working time balance indication ',NULL);
INSERT INTO message VALUES(3185,'en','Localization ',NULL);
INSERT INTO message VALUES(3186,'en','Subnet mask ',NULL);
INSERT INTO message VALUES(3187,'en','Access mode violation ',NULL);
INSERT INTO message VALUES(3187,'it','Violazione di modlita'' di accesso',NULL);
INSERT INTO message VALUES(3188,'en','Not more than ',NULL);
INSERT INTO message VALUES(3189,'en','Not to consider ',NULL);
INSERT INTO message VALUES(3190,'en','Normal (ie Blocked) contact condition(device input)',NULL);
INSERT INTO message VALUES(3191,'en','General',NULL);
INSERT INTO message VALUES(3192,'en','Orientation ',NULL);
INSERT INTO message VALUES(3193,'en','Information display ',NULL);
INSERT INTO message VALUES(3194,'en','Consider',NULL);
INSERT INTO message VALUES(3195,'en','Video record parameters',NULL);
INSERT INTO message VALUES(3196,'en','Video spot parameters',NULL);
INSERT INTO message VALUES(3197,'en','Verification point parameters',NULL);
INSERT INTO message VALUES(3198,'en','Verification point parameters for LICON',NULL);
INSERT INTO message VALUES(3199,'en','To arm',NULL);
INSERT INTO message VALUES(3200,'en','Arming',NULL);
INSERT INTO message VALUES(3200,'it','Mettere sotto protezione',NULL);
INSERT INTO message VALUES(3201,'en','Always',NULL);
INSERT INTO message VALUES(3202,'en','Passage',NULL);
INSERT INTO message VALUES(3203,'en','Passage by RC',NULL);
INSERT INTO message VALUES(3204,'en','Passage with the TIME violation \r\n',NULL);
INSERT INTO message VALUES(3205,'en','Passage with ZONALITY violation',NULL);
INSERT INTO message VALUES(3206,'en','More',NULL);
INSERT INTO message VALUES(3207,'en','Remote control permission',NULL);
INSERT INTO message VALUES(3208,'en','Allow',NULL);
INSERT INTO message VALUES(3209,'en','Reacting to events',NULL);
INSERT INTO message VALUES(3210,'en','Information display mode',NULL);
INSERT INTO message VALUES(3211,'en','Readers operation mode',NULL);
INSERT INTO message VALUES(3212,'en','LICON properties',NULL);
INSERT INTO message VALUES(3213,'en','Network',NULL);
INSERT INTO message VALUES(3214,'en','Disarming',NULL);
INSERT INTO message VALUES(3214,'it','Revoca dalla protezione',NULL);
INSERT INTO message VALUES(3215,'en','Disarm',NULL);
INSERT INTO message VALUES(3216,'en','To turn off the alarm',NULL);
INSERT INTO message VALUES(3217,'en','Visitors passage events',NULL);
INSERT INTO message VALUES(3218,'en','Employees passage events',NULL);
INSERT INTO message VALUES(3219,'en','Verification time-out (ref. section Managing/Properties of the controller)',NULL);
INSERT INTO message VALUES(3220,'en','Notifying events',NULL);
INSERT INTO message VALUES(3221,'en','Common node for all the controllers of the first level',NULL);
INSERT INTO message VALUES(3222,'en','Universal (8 bytes)',NULL);
INSERT INTO message VALUES(3223,'en','Protected zones management ',NULL);
INSERT INTO message VALUES(3224,'en','Video picture recording frequency',NULL);
INSERT INTO message VALUES(3225,'en','Rooms access ',NULL);
INSERT INTO message VALUES(3226,'en','Passages report ',NULL);
INSERT INTO message VALUES(3227,'en','Consider',NULL);
INSERT INTO message VALUES(3228,'en','Not to consider',NULL);
INSERT INTO message VALUES(3229,'en','Total',NULL);
INSERT INTO message VALUES(3230,'en','Late-in',NULL);
INSERT INTO message VALUES(3231,'en','Early-out',NULL);
INSERT INTO message VALUES(3232,'en','Late arrivals',NULL);
INSERT INTO message VALUES(3233,'en','Number of early-out events',NULL);
INSERT INTO message VALUES(3234,'en','Number of absences',NULL);
INSERT INTO message VALUES(3235,'en','Absence time',NULL);
INSERT INTO message VALUES(3236,'en','Overtime before the beginning of the working day',NULL);
INSERT INTO message VALUES(3237,'en','Overtime after the end of the working day',NULL);
INSERT INTO message VALUES(3238,'en','General overtime',NULL);
INSERT INTO message VALUES(3239,'en','Number of overtimes before the beginning of the working day',NULL);
INSERT INTO message VALUES(3240,'en','Number of overtimes after the end of the working day',NULL);
INSERT INTO message VALUES(3241,'en','Total overtime',NULL);
INSERT INTO message VALUES(3242,'en','Current day',NULL);
INSERT INTO message VALUES(3243,'en','Previous day',NULL);
INSERT INTO message VALUES(3244,'en','Current week',NULL);
INSERT INTO message VALUES(3245,'en','Current month',NULL);
INSERT INTO message VALUES(3246,'en','Stated period',NULL);
INSERT INTO message VALUES(3247,'en','Subnet',NULL);
INSERT INTO message VALUES(3248,'en','Devices are not found or are already added',NULL);
INSERT INTO message VALUES(3249,'en','Undertime hours fewer than',NULL);
INSERT INTO message VALUES(3250,'en','overtime more than',NULL);
INSERT INTO message VALUES(3251,'en','Access is granted',NULL);
INSERT INTO message VALUES(3252,'en','Deny',NULL);
INSERT INTO message VALUES(3253,'en','Verification templates',NULL);
INSERT INTO message VALUES(3254,'en','Video server',NULL);
INSERT INTO message VALUES(3255,'en','Cameras templates',NULL);
INSERT INTO message VALUES(3256,'en','Displayed data of employees',NULL);
INSERT INTO message VALUES(3257,'en','Displayed data of visitors',NULL);
INSERT INTO message VALUES(3258,'en','Point name',NULL);
INSERT INTO message VALUES(3259,'en','"Allow" hot key',NULL);
INSERT INTO message VALUES(3260,'en','"Deny" hot key',NULL);
INSERT INTO message VALUES(3261,'en','Automatic confirmation',NULL);
INSERT INTO message VALUES(3262,'en','Video server name',NULL);
INSERT INTO message VALUES(3263,'en','Video server host',NULL);
INSERT INTO message VALUES(3264,'en','Port',NULL);
INSERT INTO message VALUES(3265,'en','Camera name',NULL);
INSERT INTO message VALUES(3266,'en','Camera template',NULL);
INSERT INTO message VALUES(3267,'en','Camera host',NULL);
INSERT INTO message VALUES(3268,'en','Channel',NULL);
INSERT INTO message VALUES(3269,'en','Resources validity',NULL);
INSERT INTO message VALUES(3270,'en','Attention',NULL);
INSERT INTO message VALUES(3271,'en','Following resources of controller are invalid',NULL);
INSERT INTO message VALUES(3272,'en','Device properties',NULL);
INSERT INTO message VALUES(3273,'en','Device name',NULL);
INSERT INTO message VALUES(3274,'en','Controller type',NULL);
INSERT INTO message VALUES(3275,'en','Input [Rd. 1]',NULL);
INSERT INTO message VALUES(3276,'en','Output [Rd. 2]',NULL);
INSERT INTO message VALUES(3277,'en','Line original',NULL);
INSERT INTO message VALUES(3278,'en','Tree',NULL);
INSERT INTO message VALUES(3279,'en','List',NULL);
INSERT INTO message VALUES(3280,'en','Identification',NULL);
INSERT INTO message VALUES(3281,'en','Readers in controller',NULL);
INSERT INTO message VALUES(3282,'en','Room name',NULL);
INSERT INTO message VALUES(3283,'en','entrances to',NULL);
INSERT INTO message VALUES(3284,'en','exits from',NULL);
INSERT INTO message VALUES(3285,'en','Are you sure that you want to delete this document?',NULL);
INSERT INTO message VALUES(3286,'en','Are you sure that you want to delete this operator?',NULL);
INSERT INTO message VALUES(3287,'en','Hide zero values',NULL);
INSERT INTO message VALUES(3288,'en','Alarm reset: By signal from software',NULL);
INSERT INTO message VALUES(3289,'en','Verification template object is created',NULL);
INSERT INTO message VALUES(3291,'en','Verification: the passage is allowed by the user',NULL);
INSERT INTO message VALUES(3292,'en','Verification: the passage is allowed automatically',NULL);
INSERT INTO message VALUES(3293,'en','Equipment server is started',NULL);
INSERT INTO message VALUES(3294,'en','Registration of indicating device',NULL);
INSERT INTO message VALUES(3295,'en','Field adding',NULL);
INSERT INTO message VALUES(3296,'en','Equipment server is stopped',NULL);
INSERT INTO message VALUES(3297,'en','Registration of verification device',NULL);
INSERT INTO message VALUES(3298,'en','Verification: visitor''s passage ',NULL);
INSERT INTO message VALUES(3299,'en','Verification: the passage of the visitor and the violation of time',NULL);
INSERT INTO message VALUES(3300,'en','Verification: the passage of the visitor and the violation of location',NULL);
INSERT INTO message VALUES(3301,'en','Verification: the passage of the visitor and the violation of location and the violation of time',NULL);
INSERT INTO message VALUES(3302,'en','Verification: pass of the visitor and removal of verification due to unauthorized passage ',NULL);
INSERT INTO message VALUES(3303,'en','Verification: pass of the visitor and removal of verification due to unauthorized passage and a violation  of the time \r\n',NULL);
INSERT INTO message VALUES(3304,'en','Verification: pass of the visitor and removal of verification due to unauthorized passage and a violation of the location ',NULL);
INSERT INTO message VALUES(3305,'en','Verification: pass of the visitor and removal of verification due to unauthorized passage and a violation of the location and violation of the time \r\n\r\n',NULL);
INSERT INTO message VALUES(3306,'en','Verification: the passage of the employee',NULL);
INSERT INTO message VALUES(3307,'en','Verification: the passage of the employee and the violation of time',NULL);
INSERT INTO message VALUES(3308,'en','Verification: the passage of the employee and the violation of location',NULL);
INSERT INTO message VALUES(3309,'en','Verification: the passage of the employee and the violation of location and the violation of time',NULL);
INSERT INTO message VALUES(3310,'en','Verification: the passage of the employee and removal of verification due to the unauthorized access ',NULL);
INSERT INTO message VALUES(3311,'en','Verification: the passage of the employee and removal of verification due to the unauthorized access and the violation of time',NULL);
INSERT INTO message VALUES(3312,'en','Verification: the passage of the employee and removal of verification due to the unauthorized access and the violation of location ',NULL);
INSERT INTO message VALUES(3313,'en','Verification: the passage of the employee and removal of verification due to the unauthorized access and the violation of location and the violation of time',NULL);
INSERT INTO message VALUES(3314,'en','Verification: arming ',NULL);
INSERT INTO message VALUES(3315,'en','Verification: arming and a violation of time',NULL);
INSERT INTO message VALUES(3316,'en','Verification: arming and violation of location',NULL);
INSERT INTO message VALUES(3317,'en','Verification: arming and  violation of location and violation of time  ',NULL);
INSERT INTO message VALUES(3318,'en','Verification: arming and removal from verification due to the unauthorized passage',NULL);
INSERT INTO message VALUES(3319,'en','Verification: arming  and removal of verification due to the unauthorized access and the violation of time',NULL);
INSERT INTO message VALUES(3320,'en','Verification: arming  and removal of verification due to the unauthorized access and the violation of location',NULL);
INSERT INTO message VALUES(3321,'en','Verification: arming  and removal of verification due to the unauthorized access and the violation of location and violation of time  ',NULL);
INSERT INTO message VALUES(3322,'en','Verification: disarming',NULL);
INSERT INTO message VALUES(3323,'en','Verification: disarming and violation of time',NULL);
INSERT INTO message VALUES(3324,'en','Verification: disarming  and violation of location ',NULL);
INSERT INTO message VALUES(3325,'en','Verification: disarming  and violation of location and violation of time',NULL);
INSERT INTO message VALUES(3326,'en','Verification: disarming  and removal of verification due to the unauthorized access\r\n',NULL);
INSERT INTO message VALUES(3327,'en','Verification: disarming  and removal of verification due to the unauthorized access and the violation of time',NULL);
INSERT INTO message VALUES(3328,'en','Verification: disarming  and removal of verification due to the unauthorized access and the violation of location',NULL);
INSERT INTO message VALUES(3329,'en','Verification: disarming  and removal of verification due to the unauthorized access and the violation of location and the violation of time',NULL);
INSERT INTO message VALUES(3330,'en','Verification: passage is disallowed by user',NULL);
INSERT INTO message VALUES(3331,'en','Field editing',NULL);
INSERT INTO message VALUES(3332,'en','Field removal',NULL);
INSERT INTO message VALUES(3333,'en','Position adding',NULL);
INSERT INTO message VALUES(3335,'en','Position removal',NULL);
INSERT INTO message VALUES(3336,'en','Pass design adding',NULL);
INSERT INTO message VALUES(3337,'en','Card design editing',NULL);
INSERT INTO message VALUES(3338,'en','Department removal',NULL);
INSERT INTO message VALUES(3339,'en','Card design removal',NULL);
INSERT INTO message VALUES(3340,'en','Document type adding',NULL);
INSERT INTO message VALUES(3341,'en','Document type editing',NULL);
INSERT INTO message VALUES(3342,'en','Document type removal',NULL);
INSERT INTO message VALUES(3343,'en','Operator removal',NULL);
INSERT INTO message VALUES(3344,'en','User authority changing',NULL);
INSERT INTO message VALUES(3345,'en','User blocking',NULL);
INSERT INTO message VALUES(3346,'en','User unblocking',NULL);
INSERT INTO message VALUES(3347,'en','Role removal',NULL);
INSERT INTO message VALUES(3348,'en','Role authorities changing',NULL);
INSERT INTO message VALUES(3349,'en','Working schedule removal',NULL);
INSERT INTO message VALUES(3350,'en','Calendar editing',NULL);
INSERT INTO message VALUES(3351,'en','Calendar options editing',NULL);
INSERT INTO message VALUES(3352,'en','Access template adding',NULL);
INSERT INTO message VALUES(3353,'en','Access template editing',NULL);
INSERT INTO message VALUES(3354,'en','Access template removal',NULL);
INSERT INTO message VALUES(3355,'en','Time zone editing',NULL);
INSERT INTO message VALUES(3356,'en','Weekly access mode editing',NULL);
INSERT INTO message VALUES(3357,'en','Shift-day schedule editing',NULL);
INSERT INTO message VALUES(3358,'en','Editing of the flexible weekly access mode',NULL);
INSERT INTO message VALUES(3359,'en','Room adding',NULL);
INSERT INTO message VALUES(3360,'en','Editing holiday calendar for weekly schedule ',NULL);
INSERT INTO message VALUES(3361,'en','Room editing',NULL);
INSERT INTO message VALUES(3362,'en','Room removal',NULL);
INSERT INTO message VALUES(3363,'en','Controller adding',NULL);
INSERT INTO message VALUES(3364,'en','Controller editing',NULL);
INSERT INTO message VALUES(3365,'en','Controller removal',NULL);
INSERT INTO message VALUES(3366,'en','Controller blocking',NULL);
INSERT INTO message VALUES(3367,'en','Controller unblocking',NULL);
INSERT INTO message VALUES(3368,'en','Session with controller is not installed and controller is deactivated: invalid password',NULL);
INSERT INTO message VALUES(3369,'en','User activity',NULL);
INSERT INTO message VALUES(3370,'en','Events of security system controlers',NULL);
INSERT INTO message VALUES(3371,'en','Events of equipment server',NULL);
INSERT INTO message VALUES(3372,'en','13.2 Event associated with identifier code access (category 1)',NULL);
INSERT INTO message VALUES(3373,'en','13.3 Events associated with protected zone status changes (category 2)',NULL);
INSERT INTO message VALUES(3374,'en','13.4 Events associated with changing the current status of alarm lines included in protected zone (category 3)',NULL);
INSERT INTO message VALUES(3375,'en','13.5 Events associated with inputs/outputs statuses (category 4)',NULL);
INSERT INTO message VALUES(3376,'en','13.6 Events associated with the passages through operating devices without identifiers (category 5)',NULL);
INSERT INTO message VALUES(3377,'en','13.7 Events associated with functioning (category 6)',NULL);
INSERT INTO message VALUES(3378,'en','Change of credentials',NULL);
INSERT INTO message VALUES(3379,'en','Working with schedules',NULL);
INSERT INTO message VALUES(3380,'en','Working with card designs',NULL);
INSERT INTO message VALUES(3381,'en','Working with positions',NULL);
INSERT INTO message VALUES(3382,'en','Working with additional data',NULL);
INSERT INTO message VALUES(3383,'en','Working with controllers',NULL);
INSERT INTO message VALUES(3384,'en','Working with verification configuration',NULL);
INSERT INTO message VALUES(3385,'en','Working with operators',NULL);
INSERT INTO message VALUES(3386,'en','Working with supporting documents',NULL);
INSERT INTO message VALUES(3387,'en','Working with departments',NULL);
INSERT INTO message VALUES(3388,'en','Working with rooms',NULL);
INSERT INTO message VALUES(3389,'en','Working with operator roles',NULL);
INSERT INTO message VALUES(3390,'en','Working with access templates',NULL);
INSERT INTO message VALUES(3391,'en','Events associated with verification',NULL);
INSERT INTO message VALUES(3392,'en','Connection with controller',NULL);
INSERT INTO message VALUES(3393,'en','Functioning of equipment server',NULL);
INSERT INTO message VALUES(3394,'en','Uncontrolled territory',NULL);
INSERT INTO message VALUES(3395,'en','No confirmation',NULL);
INSERT INTO message VALUES(3396,'en','Passage is allowed by the user',NULL);
INSERT INTO message VALUES(3397,'en','Passage is allowed automatically',NULL);
INSERT INTO message VALUES(3398,'en','Passage is disallowed by the user',NULL);
INSERT INTO message VALUES(3399,'en','Indication: passage of employee',NULL);
INSERT INTO message VALUES(3400,'en','Indication: passage of visitor',NULL);
INSERT INTO message VALUES(3401,'en','Indication:passage of employee and violation of time ',NULL);
INSERT INTO message VALUES(3402,'en','Indication: passage of visitor and violation of time',NULL);
INSERT INTO message VALUES(3403,'en','Indication:passage of employee and location violation ',NULL);
INSERT INTO message VALUES(3404,'en','Indication: passage of visitor and location violation',NULL);
INSERT INTO message VALUES(3405,'en','Indication: passage of employee and time violation and location violation',NULL);
INSERT INTO message VALUES(3406,'en','Indication: passage of visitor and time violation and location violation',NULL);
INSERT INTO message VALUES(3407,'en','Indication: passage of employee and access mode violation',NULL);
INSERT INTO message VALUES(3407,'it','Indicazione: passaggio dell''impiegato e la violazione della modalita'' di accesso',NULL);
INSERT INTO message VALUES(3408,'en','Indication: passage of visitor and access mode violation',NULL);
INSERT INTO message VALUES(3409,'en','Indication: passage of employee and passage authorization',NULL);
INSERT INTO message VALUES(3409,'it','Indicazione: il passaggio dell''impiegato e il permesso del passaggio ',NULL);
INSERT INTO message VALUES(3410,'en','Indication: passage of visitor and passage authorization',NULL);
INSERT INTO message VALUES(3410,'it','Indicazione: il passaggio del visitatore e il permesso del passaggio ',NULL);
INSERT INTO message VALUES(3411,'en','Indication: passage of employee and request for passage from RCP',NULL);
INSERT INTO message VALUES(3412,'en','Indication: passage of visitor and request for passage from RCP',NULL);
INSERT INTO message VALUES(3413,'en','Indication: passage of the employee and arming',NULL);
INSERT INTO message VALUES(3414,'en','Indication: passage of a visitor and arming',NULL);
INSERT INTO message VALUES(3415,'en','Indication: passage of employee and card is not registered ',NULL);
INSERT INTO message VALUES(3416,'en','Indication: passage of visitor and card is not registered',NULL);
INSERT INTO message VALUES(3417,'en','Indication: passage of employee and card is blocked',NULL);
INSERT INTO message VALUES(3418,'en','Indication: passage of visitor and card is blocked',NULL);
INSERT INTO message VALUES(3419,'en','Indication: passage of employee and card is in stop list',NULL);
INSERT INTO message VALUES(3420,'en','Indication: passage of visitor and card is in stop list',NULL);
INSERT INTO message VALUES(3421,'en','Indication: passage of employee and card is expired',NULL);
INSERT INTO message VALUES(3422,'en','Indication: passage of visitor and card is expired',NULL);
INSERT INTO message VALUES(3423,'en','Indication: employee passage and OD break in',NULL);
INSERT INTO message VALUES(3424,'en','Indication: visitor passage and OD break in',NULL);
INSERT INTO message VALUES(3425,'en','Indication: passage of employee and passage authorization from remote control device',NULL);
INSERT INTO message VALUES(3426,'en','Indication: passage of visitor and passage authorization from remote control device',NULL);
INSERT INTO message VALUES(3427,'en','Indication: passage of employee and waiting for double-check',NULL);
INSERT INTO message VALUES(3428,'en','Indication: passage of visitor and waiting for double-check',NULL);
INSERT INTO message VALUES(3429,'en','Indication: passage of employee and passage restriction (double-check violation)',NULL);
INSERT INTO message VALUES(3430,'en','Indication: passage of visitor and passage restriction (double-check violation)',NULL);
INSERT INTO message VALUES(3431,'en','Indication:passage of employee and "Security" mode turn-off ',NULL);
INSERT INTO message VALUES(3432,'en','Indication:passage of visitor and "Security" mode turn-off',NULL);
INSERT INTO message VALUES(3433,'en','Antipass',NULL);
INSERT INTO message VALUES(3435,'en','Passage direction',NULL);
INSERT INTO message VALUES(3436,'en','Entry to',NULL);
INSERT INTO message VALUES(3437,'en','Exit from',NULL);
INSERT INTO message VALUES(3438,'en','Input: Reader',NULL);
INSERT INTO message VALUES(3439,'en','Entrance: Reader 1 Exit: Reader 2',NULL);
INSERT INTO message VALUES(3440,'en','Not verifying',NULL);
INSERT INTO message VALUES(3441,'en','Off',NULL);
INSERT INTO message VALUES(3442,'en','Verifying',NULL);
INSERT INTO message VALUES(3443,'en','On',NULL);
INSERT INTO message VALUES(3444,'en','Time violation',NULL);
INSERT INTO message VALUES(3445,'en','Location violation',NULL);
INSERT INTO message VALUES(3446,'en','The removal of verification due to unauthorized passage',NULL);
INSERT INTO message VALUES(3447,'en','Arming',NULL);
INSERT INTO message VALUES(3448,'en','Disarming',NULL);
INSERT INTO message VALUES(3449,'en','Access mode violation ',NULL);
INSERT INTO message VALUES(3450,'en','Passage authorization',NULL);
INSERT INTO message VALUES(3451,'en','Passage request from RCP',NULL);
INSERT INTO message VALUES(3452,'en','Not in the list',NULL);
INSERT INTO message VALUES(3453,'en','Identifier expiry',NULL);
INSERT INTO message VALUES(3454,'en','OD break in',NULL);
INSERT INTO message VALUES(3455,'en','Passage authorization from remote control device',NULL);
INSERT INTO message VALUES(3456,'en','Waiting for double-check according to double-check cards list',NULL);
INSERT INTO message VALUES(3457,'en','Passage restriction',NULL);
INSERT INTO message VALUES(3459,'en','Roles of operators',NULL);
INSERT INTO message VALUES(3460,'en','Flexible daily schedules',NULL);
INSERT INTO message VALUES(3461,'en','Flexible weekly schedules',NULL);
INSERT INTO message VALUES(3462,'en','Public holidays calendar',NULL);
INSERT INTO message VALUES(3463,'en','Double check cards',NULL);
INSERT INTO message VALUES(3464,'en','T&A configuration ',NULL);
INSERT INTO message VALUES(3465,'en','Configuration masks for verification of the remote control (card reader)',NULL);
INSERT INTO message VALUES(3466,'en','Configuration of T&A -line',NULL);
INSERT INTO message VALUES(3467,'en','Clearing the list of identifiers',NULL);
INSERT INTO message VALUES(3468,'en','List of identifiers',NULL);
INSERT INTO message VALUES(3469,'en','Take a picture',NULL);
INSERT INTO message VALUES(3470,'en','Confirm the action in the top of the browser',NULL);
INSERT INTO message VALUES(3471,'en','The camera is turned off or locked by the user',NULL);
INSERT INTO message VALUES(3472,'en','Verification event ',NULL);
INSERT INTO message VALUES(3475,'en','No image',NULL);
INSERT INTO message VALUES(3476,'en','Local controller PERCo-IR05',NULL);
INSERT INTO message VALUES(3478,'en','install Java',NULL);
INSERT INTO message VALUES(3479,'en','Error! Controller is not connected.',NULL);
INSERT INTO message VALUES(3480,'en','Get from',NULL);
INSERT INTO message VALUES(3481,'en','Connection to the controller',NULL);
INSERT INTO message VALUES(3482,'en','Waiting for connection...',NULL);
INSERT INTO message VALUES(3483,'en','Java is not defined. Try',NULL);
INSERT INTO message VALUES(3484,'en','Verification points are not installed in the template ',NULL);
INSERT INTO message VALUES(3485,'en','No connection to the video server (no response)',NULL);
INSERT INTO message VALUES(3487,'en','Control reader',NULL);
INSERT INTO message VALUES(3488,'en','Error! Reader is not connected.',NULL);
INSERT INTO message VALUES(3489,'en','Impossible to get video. Close all other programs using the webcam and refresh the page.',NULL);
INSERT INTO message VALUES(3490,'en','In this version of browser this function is not available',NULL);
INSERT INTO message VALUES(3491,'en','Select all',NULL);
INSERT INTO message VALUES(3492,'en','Deselect',NULL);
INSERT INTO message VALUES(3493,'en','Refresh the areas and controllers',NULL);
INSERT INTO message VALUES(3494,'en','You can copy only one role',NULL);
INSERT INTO message VALUES(3495,'en','System',NULL);
INSERT INTO message VALUES(3496,'en','Restart of t