--
-- PostgreSQL database dump
--

-- Dumped from database version 13.4
-- Dumped by pg_dump version 13.4

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: access_template; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.access_template (
    id bigint NOT NULL,
    name text NOT NULL,
    comment text,
    is_const integer DEFAULT 0 NOT NULL,
    is_removed integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.access_template OWNER TO postgres;

--
-- Name: access_template_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.access_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.access_template_id_seq OWNER TO postgres;

--
-- Name: access_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.access_template_id_seq OWNED BY public.access_template.id;


--
-- Name: access_template_params; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.access_template_params (
    access_template_id bigint NOT NULL,
    access_zone_id bigint NOT NULL,
    schedule_type_id bigint DEFAULT '1'::bigint NOT NULL,
    schedule_id bigint DEFAULT '1'::bigint NOT NULL,
    access_type_id smallint DEFAULT '0'::smallint NOT NULL,
    commission_type smallint,
    commission_group_1 smallint,
    commission_group_2 smallint,
    is_guard integer DEFAULT 0 NOT NULL,
    is_antipass integer DEFAULT 0 NOT NULL,
    is_verify integer DEFAULT 0 NOT NULL,
    verify_pdu_schedule_id bigint,
    verify_vvu_schedule_id bigint,
    verify_po_schedule_id bigint,
    template_type bigint DEFAULT '0'::bigint NOT NULL
);


ALTER TABLE public.access_template_params OWNER TO postgres;

--
-- Name: access_template_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.access_template_type (
    id smallint NOT NULL,
    name text
);


ALTER TABLE public.access_template_type OWNER TO postgres;

--
-- Name: access_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.access_type (
    id smallint NOT NULL,
    name text NOT NULL
);


ALTER TABLE public.access_type OWNER TO postgres;

--
-- Name: access_zone; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.access_zone (
    id bigint NOT NULL,
    is_const integer DEFAULT 0 NOT NULL,
    name text NOT NULL,
    parent_id bigint,
    is_removed integer DEFAULT 0 NOT NULL,
    segment_id bigint
);


ALTER TABLE public.access_zone OWNER TO postgres;

--
-- Name: access_zone_commission; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.access_zone_commission (
    access_zone_id bigint NOT NULL,
    user_id bigint NOT NULL,
    commission_group bigint NOT NULL
);


ALTER TABLE public.access_zone_commission OWNER TO postgres;

--
-- Name: access_zone_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.access_zone_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.access_zone_id_seq OWNER TO postgres;

--
-- Name: access_zone_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.access_zone_id_seq OWNED BY public.access_zone.id;


--
-- Name: available_category_tab; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.available_category_tab (
    user_id bigint NOT NULL,
    cat_id smallint NOT NULL,
    is_const integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.available_category_tab OWNER TO postgres;

--
-- Name: available_right; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.available_right (
    id bigint NOT NULL,
    type_id bigint NOT NULL,
    object_id bigint NOT NULL,
    user_role_id bigint NOT NULL
);


ALTER TABLE public.available_right OWNER TO postgres;

--
-- Name: available_right_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.available_right_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.available_right_id_seq OWNER TO postgres;

--
-- Name: available_right_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.available_right_id_seq OWNED BY public.available_right.id;


--
-- Name: available_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.available_type (
    id bigint NOT NULL,
    type text NOT NULL,
    license_id smallint NOT NULL,
    source text NOT NULL
);


ALTER TABLE public.available_type OWNER TO postgres;

--
-- Name: available_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.available_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.available_type_id_seq OWNER TO postgres;

--
-- Name: available_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.available_type_id_seq OWNED BY public.available_type.id;


--
-- Name: barcode_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.barcode_type (
    id bigint NOT NULL,
    name text NOT NULL
);


ALTER TABLE public.barcode_type OWNER TO postgres;

--
-- Name: barcode_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.barcode_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.barcode_type_id_seq OWNER TO postgres;

--
-- Name: barcode_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.barcode_type_id_seq OWNED BY public.barcode_type.id;


--
-- Name: category_tab; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.category_tab (
    id bigint NOT NULL,
    parent_id bigint,
    sort_id bigint,
    name text NOT NULL,
    title text,
    description text,
    is_active integer DEFAULT 0 NOT NULL,
    help_link text,
    icon_name text,
    license_id smallint NOT NULL,
    schema_id bigint,
    api_methods text
);


ALTER TABLE public.category_tab OWNER TO postgres;

--
-- Name: category_tab_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.category_tab_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.category_tab_id_seq OWNER TO postgres;

--
-- Name: category_tab_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.category_tab_id_seq OWNED BY public.category_tab.id;


--
-- Name: device; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.device (
    id bigint NOT NULL,
    parent_id bigint,
    device_type_id bigint NOT NULL,
    hard_number smallint,
    ip_addr text,
    name text NOT NULL,
    port bigint,
    login text,
    password text,
    access_zone_id1 bigint,
    access_zone_id2 bigint,
    is_removed integer DEFAULT 0 NOT NULL,
    net_mask text,
    ip_router text,
    mac_address text,
    resource_data text,
    schema_data text,
    sub_type bigint,
    firmware_version text,
    protocol_id bigint,
    link_id bigint,
    part_number bigint,
    segment_id bigint
);


ALTER TABLE public.device OWNER TO postgres;

--
-- Name: device_camera_stream; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.device_camera_stream (
    id integer NOT NULL,
    name text NOT NULL,
    comment text
);


ALTER TABLE public.device_camera_stream OWNER TO postgres;

--
-- Name: device_camera_stream_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.device_camera_stream_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.device_camera_stream_id_seq OWNER TO postgres;

--
-- Name: device_camera_stream_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.device_camera_stream_id_seq OWNED BY public.device_camera_stream.id;


--
-- Name: device_camera_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.device_camera_type (
    id integer NOT NULL,
    is_const integer DEFAULT 0 NOT NULL,
    manufacturer text NOT NULL,
    model text NOT NULL,
    camera_stream_type_id smallint NOT NULL,
    path text
);


ALTER TABLE public.device_camera_type OWNER TO postgres;

--
-- Name: device_camera_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.device_camera_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.device_camera_type_id_seq OWNER TO postgres;

--
-- Name: device_camera_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.device_camera_type_id_seq OWNED BY public.device_camera_type.id;


--
-- Name: device_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.device_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.device_id_seq OWNER TO postgres;

--
-- Name: device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.device_id_seq OWNED BY public.device.id;


--
-- Name: device_resource; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.device_resource (
    id bigint NOT NULL,
    resource_type_id smallint NOT NULL,
    type_id smallint NOT NULL,
    name text NOT NULL,
    short_name text,
    schema_title text
);


ALTER TABLE public.device_resource OWNER TO postgres;

--
-- Name: device_resource_change; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.device_resource_change (
    device_id bigint NOT NULL,
    resource_type bigint NOT NULL,
    resource_number bigint NOT NULL
);


ALTER TABLE public.device_resource_change OWNER TO postgres;

--
-- Name: device_resource_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.device_resource_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.device_resource_id_seq OWNER TO postgres;

--
-- Name: device_resource_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.device_resource_id_seq OWNED BY public.device_resource.id;


--
-- Name: device_resource_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.device_resource_type (
    id integer NOT NULL,
    name text NOT NULL,
    title text NOT NULL
);


ALTER TABLE public.device_resource_type OWNER TO postgres;

--
-- Name: device_resource_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.device_resource_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.device_resource_type_id_seq OWNER TO postgres;

--
-- Name: device_resource_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.device_resource_type_id_seq OWNED BY public.device_resource_type.id;


--
-- Name: device_schema; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.device_schema (
    id bigint NOT NULL,
    title text,
    description text,
    json text NOT NULL
);


ALTER TABLE public.device_schema OWNER TO postgres;

--
-- Name: device_schema_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.device_schema_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.device_schema_id_seq OWNER TO postgres;

--
-- Name: device_schema_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.device_schema_id_seq OWNED BY public.device_schema.id;


--
-- Name: device_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.device_type (
    id bigint NOT NULL,
    device_type bigint NOT NULL,
    name text NOT NULL,
    is_off integer DEFAULT 0,
    device_vendor smallint,
    schema_title text
);


ALTER TABLE public.device_type OWNER TO postgres;

--
-- Name: device_user_change; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.device_user_change (
    device_id bigint NOT NULL,
    user_id bigint NOT NULL,
    identifier numeric,
    change_type smallint
);


ALTER TABLE public.device_user_change OWNER TO postgres;

--
-- Name: device_vendor; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.device_vendor (
    id smallint NOT NULL,
    name text NOT NULL
);


ALTER TABLE public.device_vendor OWNER TO postgres;

--
-- Name: division; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.division (
    id bigint NOT NULL,
    is_const integer DEFAULT 0 NOT NULL,
    parent_id bigint,
    name text NOT NULL,
    comment text,
    accompanying_id bigint,
    staff_access_template_id bigint,
    visitor_access_template_id bigint,
    work_schedule_id bigint,
    is_removed integer DEFAULT 0 NOT NULL,
    tel text
);


ALTER TABLE public.division OWNER TO postgres;

--
-- Name: division_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.division_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.division_id_seq OWNER TO postgres;

--
-- Name: division_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.division_id_seq OWNED BY public.division.id;


--
-- Name: doc; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.doc (
    id bigint NOT NULL,
    type_id smallint NOT NULL,
    sort_id smallint,
    name text NOT NULL,
    char_code text,
    digit_code smallint,
    is_work_time integer DEFAULT 0 NOT NULL,
    calc_method_id smallint DEFAULT '1'::smallint NOT NULL,
    is_holiday_overtime integer DEFAULT 0 NOT NULL,
    is_removed integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.doc OWNER TO postgres;

--
-- Name: doc_calc_method; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.doc_calc_method (
    id integer NOT NULL,
    name text NOT NULL
);


ALTER TABLE public.doc_calc_method OWNER TO postgres;

--
-- Name: doc_calc_method_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.doc_calc_method_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.doc_calc_method_id_seq OWNER TO postgres;

--
-- Name: doc_calc_method_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.doc_calc_method_id_seq OWNED BY public.doc_calc_method.id;


--
-- Name: doc_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.doc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.doc_id_seq OWNER TO postgres;

--
-- Name: doc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.doc_id_seq OWNED BY public.doc.id;


--
-- Name: doc_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.doc_type (
    id integer NOT NULL,
    name text NOT NULL
);


ALTER TABLE public.doc_type OWNER TO postgres;

--
-- Name: doc_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.doc_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.doc_type_id_seq OWNER TO postgres;

--
-- Name: doc_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.doc_type_id_seq OWNED BY public.doc_type.id;


--
-- Name: event; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.event (
    id bigint NOT NULL,
    time_label timestamp with time zone,
    event_type bigint,
    device_id bigint,
    resource_type smallint,
    resource_number smallint,
    data bigint,
    identifier numeric,
    user_id bigint,
    operator_id bigint,
    access_zone_id1 bigint,
    access_zone_id2 bigint,
    description text,
    db_time_label timestamp with time zone DEFAULT now() NOT NULL,
    comment text,
    segment_id bigint,
    time_label_utc timestamp with time zone
);


ALTER TABLE public.event OWNER TO postgres;

--
-- Name: event_action; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.event_action (
    id bigint NOT NULL,
    name text NOT NULL
);


ALTER TABLE public.event_action OWNER TO postgres;

--
-- Name: event_action_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.event_action_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.event_action_id_seq OWNER TO postgres;

--
-- Name: event_action_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.event_action_id_seq OWNED BY public.event_action.id;


--
-- Name: event_action_object; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.event_action_object (
    id bigint NOT NULL,
    action_id bigint,
    type_id bigint,
    object_id bigint,
    options text
);


ALTER TABLE public.event_action_object OWNER TO postgres;

--
-- Name: event_action_object_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.event_action_object_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.event_action_object_id_seq OWNER TO postgres;

--
-- Name: event_action_object_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.event_action_object_id_seq OWNED BY public.event_action_object.id;


--
-- Name: event_action_object_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.event_action_object_type (
    id bigint,
    name text
);


ALTER TABLE public.event_action_object_type OWNER TO postgres;

--
-- Name: event_action_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.event_action_type (
    id bigint NOT NULL,
    name text NOT NULL
);


ALTER TABLE public.event_action_type OWNER TO postgres;

--
-- Name: event_action_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.event_action_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.event_action_type_id_seq OWNER TO postgres;

--
-- Name: event_action_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.event_action_type_id_seq OWNED BY public.event_action_type.id;


--
-- Name: event_category; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.event_category (
    id bigint NOT NULL,
    name text NOT NULL,
    en_name text NOT NULL,
    es_name text NOT NULL,
    it_name text NOT NULL,
    fr_name text NOT NULL
);


ALTER TABLE public.event_category OWNER TO postgres;

--
-- Name: event_category_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.event_category_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.event_category_id_seq OWNER TO postgres;

--
-- Name: event_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.event_category_id_seq OWNED BY public.event_category.id;


--
-- Name: event_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.event_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.event_id_seq OWNER TO postgres;

--
-- Name: event_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.event_id_seq OWNED BY public.event.id;


--
-- Name: event_resource_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.event_resource_type (
    id bigint NOT NULL,
    name text NOT NULL
);


ALTER TABLE public.event_resource_type OWNER TO postgres;

--
-- Name: event_resource_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.event_resource_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.event_resource_type_id_seq OWNER TO postgres;

--
-- Name: event_resource_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.event_resource_type_id_seq OWNED BY public.event_resource_type.id;


--
-- Name: event_subcategory; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.event_subcategory (
    id bigint NOT NULL,
    event_category_id bigint NOT NULL,
    name text NOT NULL,
    en_name text NOT NULL,
    fr_name text NOT NULL,
    es_name text NOT NULL,
    it_name text NOT NULL
);


ALTER TABLE public.event_subcategory OWNER TO postgres;

--
-- Name: event_subcategory_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.event_subcategory_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.event_subcategory_id_seq OWNER TO postgres;

--
-- Name: event_subcategory_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.event_subcategory_id_seq OWNED BY public.event_subcategory.id;


--
-- Name: event_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.event_type (
    id bigint NOT NULL,
    name text NOT NULL,
    event_subcategory_id bigint NOT NULL,
    event_resource_type_id bigint,
    event_resource_table text,
    event_resource_field text,
    en_name text NOT NULL,
    fr_name text NOT NULL,
    it_name text NOT NULL,
    es_name text
);


ALTER TABLE public.event_type OWNER TO postgres;

--
-- Name: event_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.event_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.event_type_id_seq OWNER TO postgres;

--
-- Name: event_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.event_type_id_seq OWNED BY public.event_type.id;


--
-- Name: event_verify_result; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.event_verify_result (
    id bigint NOT NULL,
    name text
);


ALTER TABLE public.event_verify_result OWNER TO postgres;

--
-- Name: event_verify_result_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.event_verify_result_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.event_verify_result_id_seq OWNER TO postgres;

--
-- Name: event_verify_result_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.event_verify_result_id_seq OWNED BY public.event_verify_result.id;


--
-- Name: language; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.language (
    id integer NOT NULL,
    name text NOT NULL,
    code text NOT NULL,
    is_active integer DEFAULT 1 NOT NULL
);


ALTER TABLE public.language OWNER TO postgres;

--
-- Name: language_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.language_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.language_id_seq OWNER TO postgres;

--
-- Name: language_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.language_id_seq OWNED BY public.language.id;


--
-- Name: license; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.license (
    id integer NOT NULL,
    module_number smallint NOT NULL,
    name text NOT NULL,
    license_key text,
    demo_begin_date timestamp with time zone,
    demo_day_count smallint,
    last_verify timestamp with time zone,
    connection_count smallint,
    short_name text NOT NULL,
    bad_verify_day_count bigint,
    data text,
    license_state_id smallint DEFAULT '0'::smallint NOT NULL,
    is_active integer NOT NULL,
    description text,
    string_constant text
);


ALTER TABLE public.license OWNER TO postgres;

--
-- Name: license_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.license_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.license_id_seq OWNER TO postgres;

--
-- Name: license_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.license_id_seq OWNED BY public.license.id;


--
-- Name: license_state; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.license_state (
    id smallint NOT NULL,
    name text NOT NULL
);


ALTER TABLE public.license_state OWNER TO postgres;

--
-- Name: mobile_terminal_device; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mobile_terminal_device (
    id bigint NOT NULL,
    uid text NOT NULL,
    name text,
    model text DEFAULT ''::text NOT NULL,
    is_active integer DEFAULT 0 NOT NULL,
    device_id bigint,
    sync_date timestamp with time zone,
    sync_token text
);


ALTER TABLE public.mobile_terminal_device OWNER TO postgres;

--
-- Name: mobile_terminal_device_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mobile_terminal_device_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mobile_terminal_device_id_seq OWNER TO postgres;

--
-- Name: mobile_terminal_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mobile_terminal_device_id_seq OWNED BY public.mobile_terminal_device.id;


--
-- Name: pass_template_design; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pass_template_design (
    id bigint NOT NULL,
    name text NOT NULL,
    data text,
    user_type smallint NOT NULL
);


ALTER TABLE public.pass_template_design OWNER TO postgres;

--
-- Name: pass_template_design_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.pass_template_design_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pass_template_design_id_seq OWNER TO postgres;

--
-- Name: pass_template_design_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.pass_template_design_id_seq OWNED BY public.pass_template_design.id;


--
-- Name: plan; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.plan (
    id bigint NOT NULL,
    name text NOT NULL,
    building smallint,
    floor smallint,
    property text,
    event_filter text
);


ALTER TABLE public.plan OWNER TO postgres;

--
-- Name: plan_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.plan_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.plan_id_seq OWNER TO postgres;

--
-- Name: plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.plan_id_seq OWNED BY public.plan.id;


--
-- Name: position; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."position" (
    id bigint NOT NULL,
    is_const integer DEFAULT 0 NOT NULL,
    name text NOT NULL,
    comment text,
    is_removed integer DEFAULT 0 NOT NULL
);


ALTER TABLE public."position" OWNER TO postgres;

--
-- Name: position_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.position_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.position_id_seq OWNER TO postgres;

--
-- Name: position_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.position_id_seq OWNED BY public."position".id;


--
-- Name: property_table; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.property_table (
    id bigint NOT NULL,
    default_language text,
    first_enter smallint DEFAULT '0'::smallint,
    license_device_mac_address text,
    date_format text,
    languages text,
    version_db text,
    region_id smallint,
    is_migrate integer DEFAULT 0,
    multi_server smallint DEFAULT '0'::smallint NOT NULL
);


ALTER TABLE public.property_table OWNER TO postgres;

--
-- Name: region; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.region (
    id bigint NOT NULL,
    name text NOT NULL,
    settings text
);


ALTER TABLE public.region OWNER TO postgres;

--
-- Name: region_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.region_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.region_id_seq OWNER TO postgres;

--
-- Name: region_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.region_id_seq OWNED BY public.region.id;


--
-- Name: schedule; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.schedule (
    id bigint NOT NULL,
    is_const smallint DEFAULT '0'::smallint NOT NULL,
    name text NOT NULL,
    comment text,
    schedule_type_id smallint NOT NULL,
    date date
);


ALTER TABLE public.schedule OWNER TO postgres;

--
-- Name: schedule_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.schedule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.schedule_id_seq OWNER TO postgres;

--
-- Name: schedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.schedule_id_seq OWNED BY public.schedule.id;


--
-- Name: schedule_item; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.schedule_item (
    id bigint NOT NULL,
    type smallint NOT NULL,
    number smallint NOT NULL,
    schedule_id bigint,
    parent_id bigint,
    data text
);


ALTER TABLE public.schedule_item OWNER TO postgres;

--
-- Name: TABLE schedule_item; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.schedule_item IS '0 - день
1 - неделя';


--
-- Name: schedule_item_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.schedule_item_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.schedule_item_id_seq OWNER TO postgres;

--
-- Name: schedule_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.schedule_item_id_seq OWNED BY public.schedule_item.id;


--
-- Name: schedule_item_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.schedule_item_type (
    id integer NOT NULL,
    item text NOT NULL,
    description text
);


ALTER TABLE public.schedule_item_type OWNER TO postgres;

--
-- Name: schedule_item_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.schedule_item_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.schedule_item_type_id_seq OWNER TO postgres;

--
-- Name: schedule_item_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.schedule_item_type_id_seq OWNED BY public.schedule_item_type.id;


--
-- Name: schedule_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.schedule_type (
    id integer NOT NULL,
    name text NOT NULL,
    schema_title text NOT NULL
);


ALTER TABLE public.schedule_type OWNER TO postgres;

--
-- Name: schedule_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.schedule_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.schedule_type_id_seq OWNER TO postgres;

--
-- Name: schedule_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.schedule_type_id_seq OWNED BY public.schedule_type.id;


--
-- Name: screenshot; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.screenshot (
    id bigint NOT NULL,
    name text,
    image bytea NOT NULL
);


ALTER TABLE public.screenshot OWNER TO postgres;

--
-- Name: segment; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.segment (
    id bigint NOT NULL,
    name text NOT NULL,
    is_lock integer DEFAULT 0 NOT NULL,
    is_main integer DEFAULT 0 NOT NULL,
    host text,
    port bigint,
    protocol text,
    token text
);


ALTER TABLE public.segment OWNER TO postgres;

--
-- Name: segment_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.segment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.segment_id_seq OWNER TO postgres;

--
-- Name: segment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.segment_id_seq OWNED BY public.segment.id;


--
-- Name: settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.settings (
    id bigint NOT NULL,
    title text,
    json text
);


ALTER TABLE public.settings OWNER TO postgres;

--
-- Name: settings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.settings_id_seq OWNER TO postgres;

--
-- Name: settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.settings_id_seq OWNED BY public.settings.id;


--
-- Name: task; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.task (
    id bigint NOT NULL,
    name text,
    date date,
    days smallint,
    time_start time without time zone,
    time_end time without time zone,
    task_state_id bigint,
    date_exec timestamp with time zone,
    segments text
);


ALTER TABLE public.task OWNER TO postgres;

--
-- Name: task_action; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.task_action (
    id bigint NOT NULL,
    task_id bigint,
    type_id bigint,
    object_id bigint,
    options text
);


ALTER TABLE public.task_action OWNER TO postgres;

--
-- Name: task_action_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.task_action_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.task_action_id_seq OWNER TO postgres;

--
-- Name: task_action_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.task_action_id_seq OWNED BY public.task_action.id;


--
-- Name: task_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.task_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.task_id_seq OWNER TO postgres;

--
-- Name: task_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.task_id_seq OWNED BY public.task.id;


--
-- Name: task_state; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.task_state (
    id integer NOT NULL,
    name text NOT NULL
);


ALTER TABLE public.task_state OWNER TO postgres;

--
-- Name: task_state_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.task_state_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.task_state_id_seq OWNER TO postgres;

--
-- Name: task_state_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.task_state_id_seq OWNED BY public.task_state.id;


--
-- Name: task_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.task_type (
    id integer NOT NULL,
    name text NOT NULL
);


ALTER TABLE public.task_type OWNER TO postgres;

--
-- Name: task_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.task_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.task_type_id_seq OWNER TO postgres;

--
-- Name: task_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.task_type_id_seq OWNED BY public.task_type.id;


--
-- Name: user; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."user" (
    id bigint NOT NULL,
    last_name text NOT NULL,
    first_name text NOT NULL,
    middle_name text,
    user_type_id smallint NOT NULL,
    is_operator integer DEFAULT 0 NOT NULL,
    division_id bigint,
    position_id bigint,
    access_template_id bigint,
    is_active integer DEFAULT 1 NOT NULL,
    is_block integer DEFAULT 0 NOT NULL,
    is_removed integer DEFAULT 0 NOT NULL,
    create_date timestamp with time zone DEFAULT now() NOT NULL,
    begin_date timestamp with time zone DEFAULT now(),
    end_date timestamp with time zone
);


ALTER TABLE public."user" OWNER TO postgres;

--
-- Name: user_additional_field; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_additional_field (
    id integer NOT NULL,
    type_id smallint NOT NULL,
    name text NOT NULL,
    comment text,
    user_type smallint NOT NULL,
    is_const integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.user_additional_field OWNER TO postgres;

--
-- Name: user_additional_field_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_additional_field_data (
    user_id bigint NOT NULL,
    field_id smallint NOT NULL,
    data text
);


ALTER TABLE public.user_additional_field_data OWNER TO postgres;

--
-- Name: user_additional_field_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_additional_field_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_additional_field_id_seq OWNER TO postgres;

--
-- Name: user_additional_field_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.user_additional_field_id_seq OWNED BY public.user_additional_field.id;


--
-- Name: user_additional_field_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_additional_field_type (
    id integer NOT NULL,
    name text NOT NULL
);


ALTER TABLE public.user_additional_field_type OWNER TO postgres;

--
-- Name: user_additional_field_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_additional_field_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_additional_field_type_id_seq OWNER TO postgres;

--
-- Name: user_additional_field_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.user_additional_field_type_id_seq OWNED BY public.user_additional_field_type.id;


--
-- Name: user_barcode; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_barcode (
    identifier_id bigint NOT NULL,
    barcode_type_id bigint NOT NULL
);


ALTER TABLE public.user_barcode OWNER TO postgres;

--
-- Name: user_bio; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_bio (
    id bigint NOT NULL,
    user_id bigint,
    bio_type smallint,
    template_type smallint DEFAULT '2'::smallint,
    template text,
    template2 text,
    image text,
    number smallint,
    name text,
    operator_id bigint,
    create_date timestamp with time zone
);


ALTER TABLE public.user_bio OWNER TO postgres;

--
-- Name: user_bio_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_bio_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_bio_id_seq OWNER TO postgres;

--
-- Name: user_bio_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.user_bio_id_seq OWNED BY public.user_bio.id;


--
-- Name: user_car; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_car (
    id bigint NOT NULL,
    user_id bigint NOT NULL,
    number text,
    model text,
    photo text,
    operator_id bigint,
    create_date timestamp with time zone
);


ALTER TABLE public.user_car OWNER TO postgres;

--
-- Name: user_car_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_car_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_car_id_seq OWNER TO postgres;

--
-- Name: user_car_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.user_car_id_seq OWNED BY public.user_car.id;


--
-- Name: user_card; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_card (
    id bigint NOT NULL,
    user_id bigint NOT NULL,
    identifier numeric NOT NULL,
    operator_id bigint,
    create_date timestamp with time zone
);


ALTER TABLE public.user_card OWNER TO postgres;

--
-- Name: user_card_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_card_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_card_id_seq OWNER TO postgres;

--
-- Name: user_card_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.user_card_id_seq OWNED BY public.user_card.id;


--
-- Name: user_change; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_change (
    id bigint NOT NULL,
    user_id bigint NOT NULL,
    change_type_id smallint NOT NULL,
    begin_date date,
    end_date date,
    old_value bigint,
    value bigint,
    is_execute integer DEFAULT 0 NOT NULL,
    "timestamp" timestamp with time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.user_change OWNER TO postgres;

--
-- Name: user_change_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_change_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_change_id_seq OWNER TO postgres;

--
-- Name: user_change_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.user_change_id_seq OWNED BY public.user_change.id;


--
-- Name: user_change_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_change_type (
    id integer NOT NULL,
    description text NOT NULL
);


ALTER TABLE public.user_change_type OWNER TO postgres;

--
-- Name: user_change_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_change_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_change_type_id_seq OWNER TO postgres;

--
-- Name: user_change_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.user_change_type_id_seq OWNED BY public.user_change_type.id;


--
-- Name: user_doc; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_doc (
    id bigint NOT NULL,
    user_id bigint NOT NULL,
    doc_id bigint NOT NULL,
    doc_creation_date date NOT NULL,
    duration time without time zone,
    doc_begin_date date,
    doc_end_date date,
    doc_number text,
    no_calculate integer DEFAULT 0 NOT NULL,
    is_complex integer DEFAULT 0 NOT NULL,
    operator_id bigint
);


ALTER TABLE public.user_doc OWNER TO postgres;

--
-- Name: user_doc_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_doc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_doc_id_seq OWNER TO postgres;

--
-- Name: user_doc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.user_doc_id_seq OWNED BY public.user_doc.id;


--
-- Name: user_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_id_seq OWNER TO postgres;

--
-- Name: user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.user_id_seq OWNED BY public."user".id;


--
-- Name: user_image; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_image (
    user_id bigint NOT NULL,
    field_id bigint NOT NULL,
    image text NOT NULL,
    user_type smallint NOT NULL
);


ALTER TABLE public.user_image OWNER TO postgres;

--
-- Name: user_operator; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_operator (
    user_id bigint NOT NULL,
    type_id smallint DEFAULT '3'::smallint NOT NULL,
    login text NOT NULL,
    password text NOT NULL,
    description text,
    user_role_id bigint NOT NULL,
    language text,
    is_const integer DEFAULT 0 NOT NULL,
    is_block integer DEFAULT 0 NOT NULL,
    api_permissions text,
    open_key text,
    is_migrate integer DEFAULT 0 NOT NULL,
    time_zone smallint
);


ALTER TABLE public.user_operator OWNER TO postgres;

--
-- Name: user_operator_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_operator_type (
    id integer NOT NULL,
    name text NOT NULL
);


ALTER TABLE public.user_operator_type OWNER TO postgres;

--
-- Name: user_operator_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_operator_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_operator_type_id_seq OWNER TO postgres;

--
-- Name: user_operator_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.user_operator_type_id_seq OWNED BY public.user_operator_type.id;


--
-- Name: user_role; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_role (
    id bigint NOT NULL,
    name text NOT NULL,
    description text,
    rights text,
    is_const integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.user_role OWNER TO postgres;

--
-- Name: user_role_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_role_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_role_id_seq OWNER TO postgres;

--
-- Name: user_role_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.user_role_id_seq OWNED BY public.user_role.id;


--
-- Name: user_staff; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_staff (
    user_id bigint NOT NULL,
    hiring_date date NOT NULL,
    tabel_number text,
    is_dismissed integer DEFAULT 0 NOT NULL,
    dismissed_date date,
    work_schedule_id bigint,
    viber_id text
);


ALTER TABLE public.user_staff OWNER TO postgres;

--
-- Name: user_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_type (
    id integer NOT NULL,
    type text NOT NULL,
    description text NOT NULL
);


ALTER TABLE public.user_type OWNER TO postgres;

--
-- Name: user_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_type_id_seq OWNER TO postgres;

--
-- Name: user_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.user_type_id_seq OWNED BY public.user_type.id;


--
-- Name: user_visitor; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_visitor (
    user_id bigint NOT NULL,
    accompanying_id bigint,
    supporting_document text,
    supporting_document_number text,
    is_archived integer DEFAULT 0 NOT NULL,
    archive_datetime timestamp with time zone
);


ALTER TABLE public.user_visitor OWNER TO postgres;

--
-- Name: verify_point; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.verify_point (
    id bigint NOT NULL,
    verify_template_id bigint NOT NULL,
    name text,
    reader_device_id bigint,
    reader_direction bigint,
    camera_device_id bigint,
    sort_id bigint,
    hot_key_allow bigint,
    hot_key_deny bigint,
    schema_data text,
    options text
);


ALTER TABLE public.verify_point OWNER TO postgres;

--
-- Name: verify_point_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.verify_point_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.verify_point_id_seq OWNER TO postgres;

--
-- Name: verify_point_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.verify_point_id_seq OWNED BY public.verify_point.id;


--
-- Name: verify_template; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.verify_template (
    id bigint NOT NULL,
    is_const integer NOT NULL,
    name text,
    comment text,
    field_visibility_staff text,
    field_visibility_visitor text
);


ALTER TABLE public.verify_template OWNER TO postgres;

--
-- Name: verify_template_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.verify_template_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.verify_template_id_seq OWNER TO postgres;

--
-- Name: verify_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.verify_template_id_seq OWNED BY public.verify_template.id;


--
-- Name: work_event_ignore; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.work_event_ignore (
    event_access_id numeric NOT NULL
);


ALTER TABLE public.work_event_ignore OWNER TO postgres;

--
-- Name: work_event_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.work_event_type (
    id bigint NOT NULL,
    event_type_id bigint NOT NULL,
    description text
);


ALTER TABLE public.work_event_type OWNER TO postgres;

--
-- Name: work_event_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.work_event_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.work_event_type_id_seq OWNER TO postgres;

--
-- Name: work_event_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.work_event_type_id_seq OWNED BY public.work_event_type.id;


--
-- Name: work_holiday; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.work_holiday (
    day date NOT NULL,
    name text,
    work_holiday_type_id bigint DEFAULT '1'::bigint,
    reduction time without time zone,
    transfer_date date
);


ALTER TABLE public.work_holiday OWNER TO postgres;

--
-- Name: work_holiday_parameters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.work_holiday_parameters (
    night_time_begin time without time zone,
    night_time_end time without time zone,
    evening_time_begin time without time zone,
    evening_time_end time without time zone,
    is_evening_time integer NOT NULL
);


ALTER TABLE public.work_holiday_parameters OWNER TO postgres;

--
-- Name: work_holyday_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.work_holyday_type (
    id integer NOT NULL,
    name text NOT NULL
);


ALTER TABLE public.work_holyday_type OWNER TO postgres;

--
-- Name: work_holyday_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.work_holyday_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.work_holyday_type_id_seq OWNER TO postgres;

--
-- Name: work_holyday_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.work_holyday_type_id_seq OWNED BY public.work_holyday_type.id;


--
-- Name: work_schedule; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.work_schedule (
    id bigint NOT NULL,
    is_const smallint,
    name text NOT NULL,
    comment text,
    is_not_holiday integer NOT NULL,
    is_first_input_last_output integer NOT NULL,
    work_schedule_type_id bigint,
    begin_date date,
    control_coming_before time without time zone,
    control_leaving_later time without time zone,
    allow_coming_later time without time zone,
    allow_leaving_before time without time zone,
    allow_slide_coming_later time without time zone,
    allow_slide_leaving_before time without time zone,
    is_removed integer NOT NULL,
    overtime time without time zone,
    undertime time without time zone,
    allow_breaks time without time zone,
    worktime_begin time without time zone,
    worktime_end time without time zone,
    balance_stored time without time zone,
    workday_list text
);


ALTER TABLE public.work_schedule OWNER TO postgres;

--
-- Name: work_schedule_access_zone; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.work_schedule_access_zone (
    work_schedule_id bigint NOT NULL,
    access_zone_id bigint NOT NULL,
    is_discipline_control integer NOT NULL
);


ALTER TABLE public.work_schedule_access_zone OWNER TO postgres;

--
-- Name: work_schedule_day; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.work_schedule_day (
    id bigint NOT NULL,
    work_schedule_id bigint NOT NULL,
    constant_component time without time zone
);


ALTER TABLE public.work_schedule_day OWNER TO postgres;

--
-- Name: work_schedule_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.work_schedule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.work_schedule_id_seq OWNER TO postgres;

--
-- Name: work_schedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.work_schedule_id_seq OWNED BY public.work_schedule.id;


--
-- Name: work_schedule_interval; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.work_schedule_interval (
    work_schedule_id bigint,
    begin_time bigint,
    end_time bigint,
    schedule_interval_type smallint NOT NULL
);


ALTER TABLE public.work_schedule_interval OWNER TO postgres;

--
-- Name: work_schedule_no_access_device; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.work_schedule_no_access_device (
    work_schedule_id bigint NOT NULL,
    device_id bigint NOT NULL
);


ALTER TABLE public.work_schedule_no_access_device OWNER TO postgres;

--
-- Name: work_schedule_no_access_zone; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.work_schedule_no_access_zone (
    work_schedule_id bigint,
    access_zone_id bigint
);


ALTER TABLE public.work_schedule_no_access_zone OWNER TO postgres;

--
-- Name: work_schedule_preset_holiday; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.work_schedule_preset_holiday (
    id bigint NOT NULL,
    day smallint NOT NULL,
    month smallint NOT NULL,
    name text
);


ALTER TABLE public.work_schedule_preset_holiday OWNER TO postgres;

--
-- Name: work_schedule_preset_holiday_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.work_schedule_preset_holiday_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.work_schedule_preset_holiday_id_seq OWNER TO postgres;

--
-- Name: work_schedule_preset_holiday_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.work_schedule_preset_holiday_id_seq OWNED BY public.work_schedule_preset_holiday.id;


--
-- Name: work_schedule_type; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.work_schedule_type (
    id integer NOT NULL,
    name text NOT NULL
);


ALTER TABLE public.work_schedule_type OWNER TO postgres;

--
-- Name: work_schedule_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.work_schedule_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.work_schedule_type_id_seq OWNER TO postgres;

--
-- Name: work_schedule_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.work_schedule_type_id_seq OWNED BY public.work_schedule_type.id;


--
-- Name: access_template id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.access_template ALTER COLUMN id SET DEFAULT nextval('public.access_template_id_seq'::regclass);


--
-- Name: access_zone id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.access_zone ALTER COLUMN id SET DEFAULT nextval('public.access_zone_id_seq'::regclass);


--
-- Name: available_right id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.available_right ALTER COLUMN id SET DEFAULT nextval('public.available_right_id_seq'::regclass);


--
-- Name: available_type id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.available_type ALTER COLUMN id SET DEFAULT nextval('public.available_type_id_seq'::regclass);


--
-- Name: barcode_type id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.barcode_type ALTER COLUMN id SET DEFAULT nextval('public.barcode_type_id_seq'::regclass);


--
-- Name: category_tab id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.category_tab ALTER COLUMN id SET DEFAULT nextval('public.category_tab_id_seq'::regclass);


--
-- Name: device id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device ALTER COLUMN id SET DEFAULT nextval('public.device_id_seq'::regclass);


--
-- Name: device_camera_stream id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_camera_stream ALTER COLUMN id SET DEFAULT nextval('public.device_camera_stream_id_seq'::regclass);


--
-- Name: device_camera_type id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_camera_type ALTER COLUMN id SET DEFAULT nextval('public.device_camera_type_id_seq'::regclass);


--
-- Name: device_resource id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_resource ALTER COLUMN id SET DEFAULT nextval('public.device_resource_id_seq'::regclass);


--
-- Name: device_resource_type id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_resource_type ALTER COLUMN id SET DEFAULT nextval('public.device_resource_type_id_seq'::regclass);


--
-- Name: device_schema id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_schema ALTER COLUMN id SET DEFAULT nextval('public.device_schema_id_seq'::regclass);


--
-- Name: division id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.division ALTER COLUMN id SET DEFAULT nextval('public.division_id_seq'::regclass);


--
-- Name: doc id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.doc ALTER COLUMN id SET DEFAULT nextval('public.doc_id_seq'::regclass);


--
-- Name: doc_calc_method id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.doc_calc_method ALTER COLUMN id SET DEFAULT nextval('public.doc_calc_method_id_seq'::regclass);


--
-- Name: doc_type id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.doc_type ALTER COLUMN id SET DEFAULT nextval('public.doc_type_id_seq'::regclass);


--
-- Name: event id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.event ALTER COLUMN id SET DEFAULT nextval('public.event_id_seq'::regclass);


--
-- Name: event_action id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.event_action ALTER COLUMN id SET DEFAULT nextval('public.event_action_id_seq'::regclass);


--
-- Name: event_action_object id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.event_action_object ALTER COLUMN id SET DEFAULT nextval('public.event_action_object_id_seq'::regclass);


--
-- Name: event_action_type id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.event_action_type ALTER COLUMN id SET DEFAULT nextval('public.event_action_type_id_seq'::regclass);


--
-- Name: event_category id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.event_category ALTER COLUMN id SET DEFAULT nextval('public.event_category_id_seq'::regclass);


--
-- Name: event_resource_type id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.event_resource_type ALTER COLUMN id SET DEFAULT nextval('public.event_resource_type_id_seq'::regclass);


--
-- Name: event_subcategory id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.event_subcategory ALTER COLUMN id SET DEFAULT nextval('public.event_subcategory_id_seq'::regclass);


--
-- Name: event_type id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.event_type ALTER COLUMN id SET DEFAULT nextval('public.event_type_id_seq'::regclass);


--
-- Name: event_verify_result id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.event_verify_result ALTER COLUMN id SET DEFAULT nextval('public.event_verify_result_id_seq'::regclass);


--
-- Name: language id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.language ALTER COLUMN id SET DEFAULT nextval('public.language_id_seq'::regclass);


--
-- Name: license id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.license ALTER COLUMN id SET DEFAULT nextval('public.license_id_seq'::regclass);


--
-- Name: mobile_terminal_device id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mobile_terminal_device ALTER COLUMN id SET DEFAULT nextval('public.mobile_terminal_device_id_seq'::regclass);


--
-- Name: pass_template_design id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.pass_template_design ALTER COLUMN id SET DEFAULT nextval('public.pass_template_design_id_seq'::regclass);


--
-- Name: plan id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.plan ALTER COLUMN id SET DEFAULT nextval('public.plan_id_seq'::regclass);


--
-- Name: position id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."position" ALTER COLUMN id SET DEFAULT nextval('public.position_id_seq'::regclass);


--
-- Name: region id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.region ALTER COLUMN id SET DEFAULT nextval('public.region_id_seq'::regclass);


--
-- Name: schedule id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.schedule ALTER COLUMN id SET DEFAULT nextval('public.schedule_id_seq'::regclass);


--
-- Name: schedule_item id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.schedule_item ALTER COLUMN id SET DEFAULT nextval('public.schedule_item_id_seq'::regclass);


--
-- Name: schedule_item_type id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.schedule_item_type ALTER COLUMN id SET DEFAULT nextval('public.schedule_item_type_id_seq'::regclass);


--
-- Name: schedule_type id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.schedule_type ALTER COLUMN id SET DEFAULT nextval('public.schedule_type_id_seq'::regclass);


--
-- Name: segment id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.segment ALTER COLUMN id SET DEFAULT nextval('public.segment_id_seq'::regclass);


--
-- Name: settings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.settings ALTER COLUMN id SET DEFAULT nextval('public.settings_id_seq'::regclass);


--
-- Name: task id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.task ALTER COLUMN id SET DEFAULT nextval('public.task_id_seq'::regclass);


--
-- Name: task_action id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.task_action ALTER COLUMN id SET DEFAULT nextval('public.task_action_id_seq'::regclass);


--
-- Name: task_state id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.task_state ALTER COLUMN id SET DEFAULT nextval('public.task_state_id_seq'::regclass);


--
-- Name: task_type id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.task_type ALTER COLUMN id SET DEFAULT nextval('public.task_type_id_seq'::regclass);


--
-- Name: user id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."user" ALTER COLUMN id SET DEFAULT nextval('public.user_id_seq'::regclass);


--
-- Name: user_additional_field id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_additional_field ALTER COLUMN id SET DEFAULT nextval('public.user_additional_field_id_seq'::regclass);


--
-- Name: user_additional_field_type id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_additional_field_type ALTER COLUMN id SET DEFAULT nextval('public.user_additional_field_type_id_seq'::regclass);


--
-- Name: user_bio id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_bio ALTER COLUMN id SET DEFAULT nextval('public.user_bio_id_seq'::regclass);


--
-- Name: user_car id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_car ALTER COLUMN id SET DEFAULT nextval('public.user_car_id_seq'::regclass);


--
-- Name: user_card id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_card ALTER COLUMN id SET DEFAULT nextval('public.user_card_id_seq'::regclass);


--
-- Name: user_change id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_change ALTER COLUMN id SET DEFAULT nextval('public.user_change_id_seq'::regclass);


--
-- Name: user_change_type id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_change_type ALTER COLUMN id SET DEFAULT nextval('public.user_change_type_id_seq'::regclass);


--
-- Name: user_doc id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_doc ALTER COLUMN id SET DEFAULT nextval('public.user_doc_id_seq'::regclass);


--
-- Name: user_operator_type id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_operator_type ALTER COLUMN id SET DEFAULT nextval('public.user_operator_type_id_seq'::regclass);


--
-- Name: user_role id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_role ALTER COLUMN id SET DEFAULT nextval('public.user_role_id_seq'::regclass);


--
-- Name: user_type id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_type ALTER COLUMN id SET DEFAULT nextval('public.user_type_id_seq'::regclass);


--
-- Name: verify_point id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.verify_point ALTER COLUMN id SET DEFAULT nextval('public.verify_point_id_seq'::regclass);


--
-- Name: verify_template id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.verify_template ALTER COLUMN id SET DEFAULT nextval('public.verify_template_id_seq'::regclass);


--
-- Name: work_event_type id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.work_event_type ALTER COLUMN id SET DEFAULT nextval('public.work_event_type_id_seq'::regclass);


--
-- Name: work_holyday_type id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.work_holyday_type ALTER COLUMN id SET DEFAULT nextval('public.work_holyday_type_id_seq'::regclass);


--
-- Name: work_schedule id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.work_schedule ALTER COLUMN id SET DEFAULT nextval('public.work_schedule_id_seq'::regclass);


--
-- Name: work_schedule_preset_holiday id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.work_schedule_preset_holiday ALTER COLUMN id SET DEFAULT nextval('public.work_schedule_preset_holiday_id_seq'::regclass);


--
-- Name: work_schedule_type id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.work_schedule_type ALTER COLUMN id SET DEFAULT nextval('public.work_schedule_type_id_seq'::regclass);


--
-- Data for Name: access_template; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.access_template (id, name, comment, is_const, is_removed) FROM stdin;
\.


--
-- Data for Name: access_template_params; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.access_template_params (access_template_id, access_zone_id, schedule_type_id, schedule_id, access_type_id, commission_type, commission_group_1, commission_group_2, is_guard, is_antipass, is_verify, verify_pdu_schedule_id, verify_vvu_schedule_id, verify_po_schedule_id, template_type) FROM stdin;
\.


--
-- Data for Name: access_template_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.access_template_type (id, name) FROM stdin;
0	PERCo
2	s30
1	Suprema
4	TRASSIR
3	ZKTeco
\.


--
-- Data for Name: access_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.access_type (id, name) FROM stdin;
12	##Задается в контроллере##
5	##Карта и отпечаток на карте##
3	##Карта и отпечаток##
11	##Карта и пин-код##
4	##Карта или отпечаток##
1	##Карта##
10	##Лицо и карта и пин-код##
8	##Лицо и карта##
9	##Лицо и пин-код##
7	##Лицо или карта##
14	##Лицо или номер ТС##
6	##Лицо##
13	##Номер ТС##
2	##Отпечаток##
\.


--
-- Data for Name: access_zone; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.access_zone (id, is_const, name, parent_id, is_removed, segment_id) FROM stdin;
1	1	##Неконтролируемая территория##	\N	0	\N
\.


--
-- Data for Name: access_zone_commission; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.access_zone_commission (access_zone_id, user_id, commission_group) FROM stdin;
\.


--
-- Data for Name: available_category_tab; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.available_category_tab (user_id, cat_id, is_const) FROM stdin;
\.


--
-- Data for Name: available_right; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.available_right (id, type_id, object_id, user_role_id) FROM stdin;
\.


--
-- Data for Name: available_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.available_type (id, type, license_id, source) FROM stdin;
1	Помещения	4	access_zone
2	Подразделения	4	division
3	Должности	4	position
4	Графики работы	6	work_schedule
5	Шаблоны доступа	4	access_template
6	Шаблоны пропусков	5	pass_template_design
7	Устройства	4	device
10	Шаблоны верификации	7	verify_template
11	Планы помещений	10	plan
\.


--
-- Data for Name: barcode_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.barcode_type (id, name) FROM stdin;
1	EAN-13
\.


--
-- Data for Name: category_tab; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.category_tab (id, parent_id, sort_id, name, title, description, is_active, help_link, icon_name, license_id, schema_id, api_methods) FROM stdin;
1	\N	0	##Разделы##	\N	\N	1	\N	\N	0	\N	\N
2	1	10	##Персонал##	personal	\N	1	\N	icon-personal	4	\N	{"devicesChangePOST":{},"timeAttendanceScheduleHolidaysListGET":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"segmentsGET":{}}
3	1	20	##Бюро пропусков##	passoffice	\N	1	\N	icon-passOffice	4	\N	{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"segmentsGET":{}}
4	1	30	##Учёт рабочего времени##	timetracking	\N	1	\N	icon-timetracking	6	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"timeAttendanceReportsDebtsTableGET":{},"timeAttendanceReportsDebtsCalculatePOST":{},"segmentsGET":{}}
5	1	40	##Контроль доступа##	controlaccess	\N	1	\N	icon-dostup	4	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"roomsTreeGET":{},"roomsListGET":{},"deviceStateGET":{},"segmentsGET":{}}
6	1	60	##Заказ пропуска##	orderpass	\N	1	\N	icon-orderpass	5	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"usersIdGET":{},"usersVisitorTableGET":{},"usersVisitorTableHtmlGET":{},"usersStaffListGET":{},"usersVisitorListGET":{},"usersStaffFullListGET":{},"usersStaffCommissionListGET":{},"usersStaffPUT":{},"usersStaffPOST":{},"usersVisitorPUT":{},"usersVisitorPOST":{},"usersStaffIdGET":{},"usersVisitorIdGET":{},"usersVisitorIdPOST":{},"usersVisitorCardExtractPOST":{},"usersAdditionalFieldListGET":{},"usersGetBio":{},"usersAddBio":{},"usersDeleteBio":{},"usersGetCars":{},"usersAddCar":{},"usersDeleteCar":{},"exportPOST":{},"divisionsIdGET":{},"devicesGET":{},"segmentsGET":{}}
8	1	50	##Верификация##	verification	\N	1	\N	icon-verification	7	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"deviceStateGET":{},"roomWithDevicesGET":{},"segmentsGET":{}}
9	1	70	##Администрирование##	administration	\N	1	\N	icon-administration	4	\N	{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"deviceStateGET":{},"exportPOST":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"segmentsGET":{}}
10	2	10	##Сотрудники##	staff	\N	1	sn01ar_operator_add.htm	\N	4	\N	{"devicesChangePOST":{},"timeAttendanceScheduleHolidaysListGET":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"usersIdGET":{},"usersStaffListGET":{},"usersStaffFullListGET":{},"usersStaffPUT":{},"usersStaffPOST":{},"usersStaffIdGET":{},"usersAdditionalFieldListGET":{},"usersGetBio":{},"usersAddBio":{},"usersDeleteBio":{},"usersGetCars":{},"usersAddCar":{},"usersDeleteCar":{},"exportPOST":{},"divisionsIdGET":{},"devicesGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdImageGET":{},"usersStaffTableGET":{},"usersStaffTableHtmlGET":{},"usersStaffIdPOST":{},"usersIdDocsTableGET":{},"usersIdDocsPUT":{},"usersIdDocsReasonPUT":{},"usersIdPlannerGET":{},"usersIdPlannerPUT":{},"usersIdErrorsGET":{},"usersPlannerIdGET":{},"usersPlannerIdPOST":{},"usersPlannerIdDELETE":{},"usersIdDocsIdGET":{},"userDocsIdPOST":{},"usersDocsIdDELETE":{},"positionsListGET":{},"passDesignTemplatesListGET":{},"passDesignTemplateUserData":{},"devicesIdReaderGET":{},"roomsWithDeviceTypeGET":{},"accessTemplatesListGET":{},"accessTemplatesIdGET":{},"accessSchedulesTypesGET":{},"accessSchedulesListGET":{},"accessSchedulesPUT":{},"accessSchedulesIdGET":{},"accessSchedulesIdPOST":{},"accessTemplatesAccessRightsGET":{},"accessTemplatesCommissionTypesGET":{},"timeAttendanceScheduleListGET":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"systemCardAutoincrementGET":{},"systemCardRandomGET":{},"parseFilePOST":{},"associatePOST":{},"importPOST":{},"getStatusImportGET":{},"exportUnimportedPOST":{},"eventActionMessengerUsersGET":{},"eventActionMessengerSendPOST":{},"tasksMailSendPOST":{},"devicesIdGET":{},"timeAttendanceDocsTypesGET":{},"deviceIdImportGET":{},"deviceIdImportPUT":{},"usersBarcodeGET":{},"usersSendBarcodeStaffPOST":{},"systemBarcodeRandomGET":{},"usersSearchCardGET":{},"userIdMainCardPOST":{},"userIdMainCardDELETE":{},"devicesIdResourceGET":{},"segmentsGET":{}}
12	2	30	##Подразделения##	divisions	\N	1	\N	\N	4	\N	{"devicesChangePOST":{},"timeAttendanceScheduleHolidaysListGET":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"usersStaffListGET":{},"exportPOST":{},"divisionsIdGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"roomsWithDeviceTypeGET":{},"accessTemplatesListGET":{},"accessTemplatesIdGET":{},"accessSchedulesTypesGET":{},"accessSchedulesListGET":{},"accessSchedulesPUT":{},"accessSchedulesIdGET":{},"accessSchedulesIdPOST":{},"accessTemplatesAccessRightsGET":{},"accessTemplatesCommissionTypesGET":{},"timeAttendanceScheduleListGET":{},"parseFilePOST":{},"associatePOST":{},"importPOST":{},"getStatusImportGET":{},"exportUnimportedPOST":{},"divisionsPUT":{},"divisionsTreeHtmlGET":{},"divisionsListHtmlGET":{},"divisionsIdPOST":{},"divisionsIdDELETE":{},"segmentsGET":{}}
14	3	20	##Сотрудники##	staff	\N	1	\N	\N	4	\N	{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"usersIdGET":{},"usersStaffListGET":{},"usersStaffFullListGET":{},"usersStaffPOST":{},"usersStaffIdGET":{},"usersAdditionalFieldListGET":{},"usersGetBio":{},"usersAddBio":{},"usersDeleteBio":{},"usersGetCars":{},"usersAddCar":{},"usersDeleteCar":{},"exportPOST":{},"divisionsIdGET":{},"devicesGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdImageGET":{},"usersStaffTableGET":{},"usersStaffTableHtmlGET":{},"usersStaffIdPOST":{},"usersIdErrorsGET":{},"passDesignTemplatesListGET":{},"passDesignTemplateUserData":{},"devicesIdReaderGET":{},"roomsWithDeviceTypeGET":{},"accessTemplatesListGET":{},"accessTemplatesIdGET":{},"accessSchedulesTypesGET":{},"accessSchedulesListGET":{},"accessSchedulesPUT":{},"accessSchedulesIdGET":{},"accessSchedulesIdPOST":{},"accessTemplatesAccessRightsGET":{},"accessTemplatesCommissionTypesGET":{},"systemCardAutoincrementGET":{},"systemCardRandomGET":{},"parseFilePOST":{},"associatePOST":{},"importPOST":{},"getStatusImportGET":{},"devicesIdGET":{},"usersBarcodeGET":{},"usersSendBarcodeStaffPOST":{},"systemBarcodeRandomGET":{},"usersSearchCardGET":{},"userIdMainCardPOST":{},"userIdMainCardDELETE":{},"devicesIdResourceGET":{},"segmentsGET":{}}
15	3	10	##Посетители##	visitors	\N	1	\N	\N	5	\N	{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"usersIdGET":{},"usersVisitorTableGET":{},"usersVisitorTableHtmlGET":{},"usersStaffListGET":{},"usersVisitorListGET":{},"usersVisitorPUT":{},"usersVisitorPOST":{},"usersVisitorIdGET":{},"usersVisitorIdPOST":{},"usersVisitorCardExtractPOST":{},"usersAdditionalFieldListGET":{},"usersGetBio":{},"usersAddBio":{},"usersDeleteBio":{},"usersGetCars":{},"usersAddCar":{},"usersDeleteCar":{},"exportPOST":{},"divisionsIdGET":{},"devicesGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdImageGET":{},"usersIdErrorsGET":{},"passDesignTemplatesListGET":{},"passDesignTemplateUserData":{},"devicesIdReaderGET":{},"roomsWithDeviceTypeGET":{},"accessTemplatesListGET":{},"accessTemplatesIdGET":{},"accessSchedulesTypesGET":{},"accessSchedulesListGET":{},"accessSchedulesPUT":{},"accessSchedulesIdGET":{},"accessSchedulesIdPOST":{},"accessTemplatesAccessRightsGET":{},"accessTemplatesCommissionTypesGET":{},"systemCardAutoincrementGET":{},"systemCardRandomGET":{},"parseFilePOST":{},"associatePOST":{},"importPOST":{},"getStatusImportGET":{},"exportUnimportedPOST":{},"devicesIdGET":{},"systemBarcodeRandomGET":{},"usersSearchCardGET":{},"userIdMainCardPOST":{},"userIdMainCardDELETE":{},"devicesIdResourceGET":{},"usersSendBarcodeVisitorPOST":{},"segmentsGET":{}}
94	1	100	##Интеграция с TRASSIR##	trassir	\N	1	\N	\N	11	\N	{"operatorsCurrentGET":{},"operatorsCurrentPOST":{}}
93	66	90	##Редактирование плана##	plan	\N	1	\N	\N	10	\N	{"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"deviceStateGET":{},"eventsystemSubcategoryListGET":{},"eventsystemGET":{},"deviceIdCommandSchemaGET":{},"roomIdCommandSchemaGET":{},"planListGET":{},"planIdGET":{},"planRoomsGET":{},"accessReportsIndoorGET":{},"eventsystemMonitoringGET":{},"planPUT":{},"planIdPOST":{},"planIdDELETE":{},"segmentsGET":{}}
16	3	30	##Шаблоны доступа##	access	\N	1	sn01ea_template_new.htm	\N	4	\N	{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"roomsTreeGET":{},"roomsListGET":{},"deviceStateGET":{},"usersStaffCommissionListGET":{},"roomWithDevicesGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"roomsWithDeviceTypeGET":{},"accessTemplatesIdGET":{},"accessSchedulesTypesGET":{},"accessSchedulesListGET":{},"accessSchedulesPUT":{},"accessSchedulesIdGET":{},"accessSchedulesIdPOST":{},"accessTemplatesAccessRightsGET":{},"accessTemplatesCommissionTypesGET":{},"accessTemplatesPUT":{},"accessTemplatesTableGET":{},"accessTemplatesIdPOST":{},"accessTemplatesIdDELETE":{},"accessSchedulesTableGET":{},"accessSchedulesTimeZonePUT":{},"accessSchedulesTimeZoneIdPOST":{},"accessSchedulesWeeklyPUT":{},"accessSchedulesWeeklyIdPOST":{},"accessSchedulesFlexDayPUT":{},"accessSchedulesFlexDayPOST":{},"accessSchedulesFlexWeeklyPUT":{},"accessSchedulesFlexWeeklyIdPOST":{},"accessCommissionRoomIdPOST":{},"accessSchedulesIdDELETE":{},"accessSchedulesHolidaysGroupIdPOST":{},"roomIdCommissionTypesGET":{},"segmentsGET":{}}
17	4	10	##Журнал отработанного времени##	workedjournal	\N	1	\N	\N	6	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"timeAttendanceReportsDebtsTableGET":{},"timeAttendanceReportsDebtsCalculatePOST":{},"usersIdGET":{},"usersStaffListGET":{},"usersStaffIdGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdImageGET":{},"usersIdDocsTableGET":{},"usersIdDocsPUT":{},"usersIdDocsReasonPUT":{},"usersIdDocsIdGET":{},"userDocsIdPOST":{},"usersDocsIdDELETE":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"timeAttendanceScheduleIdGET":{},"timeAttendanceReportsTimeTrackingGET":{},"timeAttendanceReportsTimeTrackingHtmlGET":{},"segmentsGET":{}}
18	4	30	##Формирование табеля##	timesheetsformation	\N	1	\N	\N	6	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"timeAttendanceReportsDebtsTableGET":{},"timeAttendanceReportsDebtsCalculatePOST":{},"usersStaffListGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"timeAttendanceReportsTimesheetHtmlGET":{},"timeAttendanceReportsTimesheetGET":{},"segmentsGET":{}}
21	4	50	##Отчеты по дисциплине##	disciplinereports	\N	1	\N	\N	6	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"timeAttendanceReportsDebtsTableGET":{},"timeAttendanceReportsDebtsCalculatePOST":{},"usersIdGET":{},"usersStaffIdGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdDocsReasonPUT":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"timeAttendanceReportsViolatorsGET":{},"timeAttendanceReportsViolatorsHtmlGET":{},"timeAttendanceReportsPresenceGET":{},"timeAttendanceReportsPresenceHtmlGET":{},"timeAttendanceReportsAbsenceGET":{},"timeAttendanceReportsAbsenceHtmlGET":{},"timeAttendanceReportsLateGET":{},"timeAttendanceReportsLateHtmlGET":{},"timeAttendanceReportsEarlyGET":{},"timeAttendanceReportsEarlyHtmlGET":{},"timeAttendanceReportsOverworkGET":{},"timeAttendanceReportsOverworkHtmlGET":{},"segmentsGET":{}}
22	5	60	##Местонахождение##	whereabouts	\N	1	\N	\N	6	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"roomsTreeGET":{},"roomsListGET":{},"deviceStateGET":{},"usersStaffListGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"accessReportsWhereaboutsGET":{},"accessReportsWhereaboutsHtmlGET":{},"segmentsGET":{}}
23	5	40	##Журнал верификации##	verificationjournal	\N	1	\N	\N	7	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"roomsTreeGET":{},"roomsListGET":{},"deviceStateGET":{},"usersIdGET":{},"usersStaffListGET":{},"usersStaffIdGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"verifyGetEvent":{},"verifyGetEventHtml":{},"verifyGetLastEvent":{},"verifyFilterPoints":{},"verifyFilterEvents":{},"verifyFilterResponses":{},"verifyFilterOperators":{},"segmentsGET":{}}
24	3	50	##Отчет по посетителям##	visitorsreport	\N	1	\N	\N	5	\N	{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"usersStaffListGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"accessReportsVisitorsGET":{},"accessReportsVisitorsHtmlGET":{},"segmentsGET":{}}
25	5	10	##Отчет о проходах##	premisesaccess	\N	1	sn01ev_wind_main.htm	\N	5	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"roomsTreeGET":{},"roomsListGET":{},"deviceStateGET":{},"usersStaffListGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"accessReportsEventsGET":{},"accessReportsEventsHtmlGET":{},"segmentsGET":{}}
32	9	60	##Роли и права операторов##	roles	\N	1	sn01ar_wind_main.htm	\N	4	\N	{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"roomsTreeGET":{},"deviceStateGET":{},"usersStaffListGET":{},"exportPOST":{},"devicesGET":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"positionsListGET":{},"passDesignTemplatesListGET":{},"accessTemplatesListGET":{},"timeAttendanceScheduleListGET":{},"rolesTableGET":{},"rolesPUT":{},"rolesIdGET":{},"rolesIdPOST":{},"rolesIdDELETE":{},"verifyTemplatesLIST":{},"segmentsGET":{}}
33	9	20	##События системы##	eventssystem	\N	1	sn01ev_wind_main.htm	\N	4	\N	{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"roomsTreeGET":{},"roomsListGET":{},"deviceStateGET":{},"exportPOST":{},"devicesGET":{},"roomWithDevicesGET":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"positionsListGET":{},"verifyGetEvent":{},"eventsystemGET":{},"eventsystemHtmlGET":{},"eventTypesGET":{},"eventActionListGET":{},"eventActionItemGET":{},"operatorChangeLogGET":{},"segmentsGET":{}}
34	9	30	##Реакции на события##	eventaction	\N	1	\N	\N	4	\N	{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"deviceStateGET":{},"exportPOST":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"eventActionListGET":{},"eventActionItemGET":{},"eventActionTableGET":{},"eventActionItemPOST":{},"eventActionItemDELETE":{},"eventActionItemPUT":{},"eventActionHardwareEventsGET":{},"devicesIdEventResourceGET":{},"segmentsGET":{}}
36	4	20	##Оправдательные документы##	documenttype	\N	1	\N	\N	6	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"timeAttendanceReportsDebtsTableGET":{},"timeAttendanceReportsDebtsCalculatePOST":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"timeAttendanceDocsTypesGET":{},"timeAttendanceDocsTableGET":{},"timeAttendanceDocsIdPOST":{},"timeAttendanceDocsIdDELETE":{},"timeAttendanceDocsPUT":{},"timeAttendanceDocsCalcMethodsGET":{},"extraReportsDocumentsGET":{},"extraReportsDocumentsHtmlGET":{},"extraReportsDocumentsXlsxGET":{},"segmentsGET":{}}
37	2	60	##Дополнительные данные##	additionaldata	\N	1	\N	\N	5	\N	{"devicesChangePOST":{},"timeAttendanceScheduleHolidaysListGET":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"usersAdditionalFieldsTableGET":{},"usersAdditionalFieldsPUT":{},"usersAdditionalFieldsIdGET":{},"usersAdditionalFieldsIdPOST":{},"usersAdditionalFieldsIdDELETE":{},"segmentsGET":{}}
38	9	50	##Операторы##	operators	\N	1	sn01ar_operator_add.htm	\N	4	\N	{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"deviceStateGET":{},"usersStaffListGET":{},"exportPOST":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"operatorsGET":{},"operatorsPUT":{},"operatorsIdGET":{},"operatorsIdPOST":{},"operatorsIdDELETE":{},"operatorsIdLockPOST":{},"operatorsIdUnlockPOST":{},"rolesListGET":{},"segmentsGET":{}}
50	3	40	##Дизайн пропуска##	design	\N	1	\N	\N	5	\N	{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"usersAdditionalFieldListGET":{},"passDesignTemplatesListGET":{},"passDesignTemplateUserData":{},"passDesignTemplatesTableGET":{},"passDesignTemplatesItemGET":{},"passDesignTemplatesItemPOST":{},"passDesignTemplatesItemDELETE":{},"passDesignTemplatesItemPUT":{},"segmentsGET":{}}
54	2	40	##Должности##	positions	\N	1	\N	\N	4	\N	{"devicesChangePOST":{},"timeAttendanceScheduleHolidaysListGET":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"exportPOST":{},"parseFilePOST":{},"associatePOST":{},"importPOST":{},"getStatusImportGET":{},"exportUnimportedPOST":{},"positionsPUT":{},"positionsTableGET":{},"positionsTableHtmlGET":{},"positionsIdGET":{},"positionsIdPOST":{},"positionsIdDELETE":{},"segmentsGET":{}}
56	5	20	##Управление устройствами##	devicemanagement	\N	1	\N	\N	4	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"roomsTreeGET":{},"roomsListGET":{},"deviceStateGET":{},"devicesGET":{},"roomWithDevicesGET":{},"devicesIdReaderGET":{},"devicesIdGET":{},"devicesIdCommandPOST":{},"deviceIdCommandSchemaGET":{},"roomIdCommandSchemaGET":{},"deviceIdErrorsGET":{},"segmentsGET":{}}
58	8	10	##Верификация##	verification	\N	1	\N	\N	7	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"deviceStateGET":{},"usersIdGET":{},"usersStaffIdGET":{},"roomWithDevicesGET":{},"verifyTemplatesLIST":{},"verifyGetTemplate":{},"segmentsGET":{}}
59	9	10	##Конфигурация##	premisesconfiguration	\N	1	\N	\N	4	\N	{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"roomsTreeGET":{},"roomsListGET":{},"deviceStateGET":{},"exportPOST":{},"devicesGET":{},"roomWithDevicesGET":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"eventActionMessengerUsersGET":{},"eventActionMessengerSendPOST":{},"tasksMailSendPOST":{},"devicesIdGET":{},"devicesIdResourceGET":{},"devicesIdCommandPOST":{},"deviceIdErrorsGET":{},"eventSystemClearDELETE":{},"devicesPUT":{},"devicesIdPOST":{},"devicesIdDELETE":{},"devicesIdActivatePOST":{},"devicesIdDeactivatePOST":{},"devicesIdAttachPOST":{},"devicesIdDetachPOST":{},"devicesSchemaGET":{},"devicesSearchGET":{},"devicesCameraTemplateTableGET":{},"devicesCameraTemplateListGET":{},"devicesCameraTemplateManufacturerListGET":{},"devicesCameraTemplatePUT":{},"devicesCameraTemplateIdGET":{},"devicesCameraTemplateIdPOST":{},"devicesCameraTemplateIdDELETE":{},"devicesCameraPUT":{},"devicesGatewayPUT":{},"roomsPUT":{},"roomsIdPOST":{},"roomsIdDELETE":{},"systemDatabaseBackup":{},"systemUploadUpdatePackageGET":{},"eventActionSmppProvidersGET":{},"eventActionSmppSendPOST":{},"mobileTerminalDevicePOST":{},"mobileTerminalDeviceDELETE":{},"mobileTerminalDeviceListGET":{},"segmentsGET":{}}
61	9	40	##Задания##	task	\N	1	\N	\N	4	\N	{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"deviceStateGET":{},"exportPOST":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"eventActionListGET":{},"eventActionItemGET":{},"systemDatabaseBackup":{},"tasksGET":{},"tasksPUT":{},"tasksIdGET":{},"tasksIdPOST":{},"tasksIdDELETE":{},"tasksIdStatusPOST":{},"tasksTypesGET":{},"segmentsGET":{}}
62	6	10	##Заказ пропуска##	index	\N	1	\N	\N	5	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"usersIdGET":{},"usersVisitorTableGET":{},"usersVisitorTableHtmlGET":{},"usersStaffListGET":{},"usersVisitorListGET":{},"usersStaffFullListGET":{},"usersStaffCommissionListGET":{},"usersStaffPUT":{},"usersStaffPOST":{},"usersVisitorPUT":{},"usersVisitorPOST":{},"usersStaffIdGET":{},"usersVisitorIdGET":{},"usersVisitorIdPOST":{},"usersVisitorCardExtractPOST":{},"usersAdditionalFieldListGET":{},"usersGetBio":{},"usersAddBio":{},"usersDeleteBio":{},"usersGetCars":{},"usersAddCar":{},"usersDeleteCar":{},"exportPOST":{},"divisionsIdGET":{},"devicesGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"systemCardAutoincrementGET":{},"systemCardRandomGET":{},"parseFilePOST":{},"associatePOST":{},"importPOST":{},"getStatusImportGET":{},"exportUnimportedPOST":{},"segmentsGET":{}}
64	8	20	##Конфигурация верификации##	verificationconfig	\N	1	\N	\N	7	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"deviceStateGET":{},"devicesGET":{},"roomWithDevicesGET":{},"devicesIdReaderGET":{},"verifyTemplatesLIST":{},"verifyGetTemplate":{},"verifyTemplateTABLE":{},"verifyTemplatePUT":{},"verifyTemplateGET":{},"verifyTemplatePOST":{},"verifyTemplateDELETE":{},"verifyGetPoint":{},"verifyPointPUT":{},"verifyPointIdGET":{},"verifyPointPOST":{},"verifyPointDELETE":{},"verifyPointMove":{},"verifyPointLIST":{},"verifyPointTABLE":{},"verifyPointIdSchemaGET":{},"segmentsGET":{}}
65	5	50	##Отчет по доступу в помещения##	premisesaccessreport	\N	1	\N	\N	5	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"roomsTreeGET":{},"roomsListGET":{},"deviceStateGET":{},"usersStaffListGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"accessReportsAccessZoneGET":{},"accessReportsAccessZoneHtmlGET":{},"segmentsGET":{}}
66	1	60	##Мониторинг##	centralpost	\N	1	\N	icon-shield	10	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"deviceStateGET":{},"eventsystemSubcategoryListGET":{},"eventsystemGET":{},"deviceIdCommandSchemaGET":{},"roomIdCommandSchemaGET":{},"planListGET":{},"planIdGET":{},"planRoomsGET":{},"accessReportsIndoorGET":{},"eventsystemMonitoringGET":{},"segmentsGET":{}}
67	66	81	##Интерактивный план##	plan	\N	1	\N	\N	10	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"deviceStateGET":{},"eventsystemSubcategoryListGET":{},"eventsystemGET":{},"deviceIdCommandSchemaGET":{},"roomIdCommandSchemaGET":{},"planListGET":{},"planIdGET":{},"planRoomsGET":{},"accessReportsIndoorGET":{},"eventsystemMonitoringGET":{},"segmentsGET":{}}
69	9	70	##Лицензии##	license	\N	1	\N	\N	4	\N	{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"deviceStateGET":{},"exportPOST":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"licensesGET":{},"licensesLicenseControllersGET":{},"licensesSetLicenseKeyPOST":{},"licensesCurrentLicenseControllerGET":{},"licensesSetLicenseControllerPOST":{},"licensesLicenseActivatePOST":{},"licensesLicenseDeactivatePOST":{},"segmentsGET":{}}
70	2	20	##Графики работы##	schedules	\N	1	\N	\N	6	\N	{"devicesChangePOST":{},"timeAttendanceScheduleHolidaysListGET":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"roomsTreeGET":{},"timeAttendanceScheduleListGET":{},"timeAttendanceScheduleIdGET":{},"timeAttendanceSchedulePUT":{},"timeAttendanceScheduleTableGET":{},"timeAttendanceScheduleIdPOST":{},"timeAttendanceScheduleIdDELETE":{},"timeAttendanceScheduleNightTimeGET":{},"timeAttendanceScheduleNightTimePOST":{},"segmentsGET":{}}
71	2	50	##Праздничные дни##	holidays	\N	1	\N	\N	4	\N	{"devicesChangePOST":{},"timeAttendanceScheduleHolidaysListGET":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"timeAttendanceScheduleHolidaysPUT":{},"timeAttendanceScheduleHolidaysFillPOST":{},"timeAttendanceScheduleHolidaysClearPOST":{},"timeAttendanceScheduleHolidaysIdGET":{},"timeAttendanceScheduleHolidaysIdPOST":{},"timeAttendanceScheduleHolidaysIdDELETE":{},"timeAttendancePresetHolidaysGET":{},"timeAttendancePresetHolidaysPUT":{},"timeAttendancePresetHolidaysIdDELETE":{},"segmentsGET":{}}
72	16	31	##Шаблоны##	accesstemplates	\N	1	\N	\N	4	\N	{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"roomsTreeGET":{},"roomsListGET":{},"deviceStateGET":{},"usersStaffCommissionListGET":{},"roomWithDevicesGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"roomsWithDeviceTypeGET":{},"accessTemplatesIdGET":{},"accessSchedulesTypesGET":{},"accessSchedulesListGET":{},"accessSchedulesPUT":{},"accessSchedulesIdGET":{},"accessSchedulesIdPOST":{},"accessTemplatesAccessRightsGET":{},"accessTemplatesCommissionTypesGET":{},"accessTemplatesPUT":{},"accessTemplatesTableGET":{},"accessTemplatesIdPOST":{},"accessTemplatesIdDELETE":{},"accessSchedulesTableGET":{},"accessSchedulesTimeZonePUT":{},"accessSchedulesTimeZoneIdPOST":{},"accessSchedulesWeeklyPUT":{},"accessSchedulesWeeklyIdPOST":{},"accessSchedulesFlexDayPUT":{},"accessSchedulesFlexDayPOST":{},"accessSchedulesFlexWeeklyPUT":{},"accessSchedulesFlexWeeklyIdPOST":{},"accessCommissionRoomIdPOST":{},"accessSchedulesIdDELETE":{},"accessSchedulesHolidaysGroupIdPOST":{},"roomIdCommissionTypesGET":{},"segmentsGET":{}}
73	16	32	##Временные критерии доступа##	accessschedules	\N	1	\N	\N	4	\N	{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"roomsTreeGET":{},"roomsListGET":{},"deviceStateGET":{},"usersStaffCommissionListGET":{},"roomWithDevicesGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"roomsWithDeviceTypeGET":{},"accessTemplatesIdGET":{},"accessSchedulesTypesGET":{},"accessSchedulesListGET":{},"accessSchedulesPUT":{},"accessSchedulesIdGET":{},"accessSchedulesIdPOST":{},"accessTemplatesAccessRightsGET":{},"accessTemplatesCommissionTypesGET":{},"accessTemplatesPUT":{},"accessTemplatesTableGET":{},"accessTemplatesIdPOST":{},"accessTemplatesIdDELETE":{},"accessSchedulesTableGET":{},"accessSchedulesTimeZonePUT":{},"accessSchedulesTimeZoneIdPOST":{},"accessSchedulesWeeklyPUT":{},"accessSchedulesWeeklyIdPOST":{},"accessSchedulesFlexDayPUT":{},"accessSchedulesFlexDayPOST":{},"accessSchedulesFlexWeeklyPUT":{},"accessSchedulesFlexWeeklyIdPOST":{},"accessCommissionRoomIdPOST":{},"accessSchedulesIdDELETE":{},"accessSchedulesHolidaysGroupIdPOST":{},"roomIdCommissionTypesGET":{},"segmentsGET":{}}
78	56	21	##Помещения##	rooms	\N	1	\N	\N	4	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"roomsTreeGET":{},"roomsListGET":{},"deviceStateGET":{},"devicesGET":{},"roomWithDevicesGET":{},"devicesIdReaderGET":{},"devicesIdGET":{},"devicesIdCommandPOST":{},"deviceIdCommandSchemaGET":{},"roomIdCommandSchemaGET":{},"deviceIdErrorsGET":{},"segmentsGET":{}}
79	56	22	##Устройства##	controllers	\N	1	\N	\N	4	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"roomsTreeGET":{},"roomsListGET":{},"deviceStateGET":{},"devicesGET":{},"roomWithDevicesGET":{},"devicesIdReaderGET":{},"devicesIdGET":{},"devicesIdCommandPOST":{},"deviceIdCommandSchemaGET":{},"roomIdCommandSchemaGET":{},"deviceIdErrorsGET":{},"segmentsGET":{}}
82	59	13	##Шаблоны камер##	cameratemplates	\N	1	\N	\N	4	\N	{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"roomsTreeGET":{},"roomsListGET":{},"deviceStateGET":{},"exportPOST":{},"devicesGET":{},"roomWithDevicesGET":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"eventActionMessengerUsersGET":{},"eventActionMessengerSendPOST":{},"tasksMailSendPOST":{},"devicesIdGET":{},"devicesIdResourceGET":{},"devicesIdCommandPOST":{},"deviceIdErrorsGET":{},"eventSystemClearDELETE":{},"devicesPUT":{},"devicesIdPOST":{},"devicesIdDELETE":{},"devicesIdActivatePOST":{},"devicesIdDeactivatePOST":{},"devicesIdAttachPOST":{},"devicesIdDetachPOST":{},"devicesSchemaGET":{},"devicesSearchGET":{},"devicesCameraTemplateTableGET":{},"devicesCameraTemplateListGET":{},"devicesCameraTemplateManufacturerListGET":{},"devicesCameraTemplatePUT":{},"devicesCameraTemplateIdGET":{},"devicesCameraTemplateIdPOST":{},"devicesCameraTemplateIdDELETE":{},"devicesCameraPUT":{},"devicesGatewayPUT":{},"roomsPUT":{},"roomsIdPOST":{},"roomsIdDELETE":{},"systemDatabaseBackup":{},"systemUploadUpdatePackageGET":{},"eventActionSmppProvidersGET":{},"eventActionSmppSendPOST":{},"mobileTerminalDevicePOST":{},"mobileTerminalDeviceDELETE":{},"mobileTerminalDeviceListGET":{},"segmentsGET":{}}
83	59	11	##Помещения##	rooms	\N	1	\N	\N	4	\N	{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"roomsTreeGET":{},"roomsListGET":{},"deviceStateGET":{},"exportPOST":{},"devicesGET":{},"roomWithDevicesGET":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"eventActionMessengerUsersGET":{},"eventActionMessengerSendPOST":{},"tasksMailSendPOST":{},"devicesIdGET":{},"devicesIdResourceGET":{},"devicesIdCommandPOST":{},"deviceIdErrorsGET":{},"eventSystemClearDELETE":{},"devicesPUT":{},"devicesIdPOST":{},"devicesIdDELETE":{},"devicesIdActivatePOST":{},"devicesIdDeactivatePOST":{},"devicesIdAttachPOST":{},"devicesIdDetachPOST":{},"devicesSchemaGET":{},"devicesSearchGET":{},"devicesCameraTemplateTableGET":{},"devicesCameraTemplateListGET":{},"devicesCameraTemplateManufacturerListGET":{},"devicesCameraTemplatePUT":{},"devicesCameraTemplateIdGET":{},"devicesCameraTemplateIdPOST":{},"devicesCameraTemplateIdDELETE":{},"devicesCameraPUT":{},"devicesGatewayPUT":{},"roomsPUT":{},"roomsIdPOST":{},"roomsIdDELETE":{},"systemDatabaseBackup":{},"systemUploadUpdatePackageGET":{},"eventActionSmppProvidersGET":{},"eventActionSmppSendPOST":{},"mobileTerminalDevicePOST":{},"mobileTerminalDeviceDELETE":{},"mobileTerminalDeviceListGET":{},"segmentsGET":{}}
84	59	12	##Устройства##	controllers	\N	1	\N	\N	4	\N	{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"roomsTreeGET":{},"roomsListGET":{},"deviceStateGET":{},"usersStaffListGET":{},"exportPOST":{},"devicesGET":{},"roomWithDevicesGET":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"eventActionMessengerUsersGET":{},"eventActionMessengerSendPOST":{},"tasksMailSendPOST":{},"devicesIdGET":{},"devicesIdResourceGET":{},"devicesIdCommandPOST":{},"deviceIdErrorsGET":{},"eventSystemClearDELETE":{},"devicesPUT":{},"devicesIdPOST":{},"devicesIdDELETE":{},"devicesIdActivatePOST":{},"devicesIdDeactivatePOST":{},"devicesIdAttachPOST":{},"devicesIdDetachPOST":{},"devicesSchemaGET":{},"devicesSearchGET":{},"devicesCameraTemplateTableGET":{},"devicesCameraTemplateListGET":{},"devicesCameraTemplateManufacturerListGET":{},"devicesCameraTemplatePUT":{},"devicesCameraTemplateIdGET":{},"devicesCameraTemplateIdPOST":{},"devicesCameraTemplateIdDELETE":{},"devicesCameraPUT":{},"devicesGatewayPUT":{},"roomsPUT":{},"roomsIdPOST":{},"roomsIdDELETE":{},"systemDatabaseBackup":{},"systemUploadUpdatePackageGET":{},"eventActionSmppProvidersGET":{},"eventActionSmppSendPOST":{},"mobileTerminalDevicePOST":{},"mobileTerminalDeviceDELETE":{},"mobileTerminalDeviceListGET":{},"segmentsGET":{}}
85	59	14	##Система##	system	\N	1	\N	\N	4	\N	{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"roomsTreeGET":{},"roomsListGET":{},"deviceStateGET":{},"exportPOST":{},"devicesGET":{},"roomWithDevicesGET":{},"operatorsListGET":{},"eventsystemEventsListGET":{},"eventsystemCategoryListGET":{},"eventsystemSubcategoryListGET":{},"systemConfigPOST":{},"settingsGET":{},"settingsPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"eventActionMessengerUsersGET":{},"eventActionMessengerSendPOST":{},"tasksMailSendPOST":{},"devicesIdGET":{},"devicesIdResourceGET":{},"devicesIdCommandPOST":{},"deviceIdErrorsGET":{},"eventSystemClearDELETE":{},"devicesPUT":{},"devicesIdPOST":{},"devicesIdDELETE":{},"devicesIdActivatePOST":{},"devicesIdDeactivatePOST":{},"devicesIdAttachPOST":{},"devicesIdDetachPOST":{},"devicesSchemaGET":{},"devicesSearchGET":{},"devicesCameraTemplateTableGET":{},"devicesCameraTemplateListGET":{},"devicesCameraTemplateManufacturerListGET":{},"devicesCameraTemplatePUT":{},"devicesCameraTemplateIdGET":{},"devicesCameraTemplateIdPOST":{},"devicesCameraTemplateIdDELETE":{},"devicesCameraPUT":{},"devicesGatewayPUT":{},"roomsPUT":{},"roomsIdPOST":{},"roomsIdDELETE":{},"systemDatabaseBackup":{},"systemUploadUpdatePackageGET":{},"eventActionSmppProvidersGET":{},"eventActionSmppSendPOST":{},"mobileTerminalDevicePOST":{},"mobileTerminalDeviceDELETE":{},"mobileTerminalDeviceListGET":{},"segmentsGET":{}}
86	21	51	##Нарушители##	violators	\N	1	\N	\N	6	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"timeAttendanceReportsDebtsTableGET":{},"timeAttendanceReportsDebtsCalculatePOST":{},"usersIdGET":{},"usersStaffListGET":{},"usersStaffIdGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdDocsTableGET":{},"usersIdDocsPUT":{},"usersIdDocsReasonPUT":{},"usersIdDocsIdGET":{},"userDocsIdPOST":{},"usersDocsIdDELETE":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"timeAttendanceReportsViolatorsGET":{},"timeAttendanceReportsViolatorsHtmlGET":{},"timeAttendanceReportsPresenceGET":{},"timeAttendanceReportsPresenceHtmlGET":{},"timeAttendanceReportsAbsenceGET":{},"timeAttendanceReportsAbsenceHtmlGET":{},"timeAttendanceReportsLateGET":{},"timeAttendanceReportsLateHtmlGET":{},"timeAttendanceReportsEarlyGET":{},"timeAttendanceReportsEarlyHtmlGET":{},"timeAttendanceReportsOverworkGET":{},"timeAttendanceReportsOverworkHtmlGET":{},"segmentsGET":{}}
87	21	52	##Присутствующие на данный момент##	presences	\N	1	\N	\N	6	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"timeAttendanceReportsDebtsTableGET":{},"timeAttendanceReportsDebtsCalculatePOST":{},"usersIdGET":{},"usersStaffListGET":{},"usersStaffIdGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdDocsTableGET":{},"usersIdDocsPUT":{},"usersIdDocsReasonPUT":{},"usersIdDocsIdGET":{},"userDocsIdPOST":{},"usersDocsIdDELETE":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"timeAttendanceReportsViolatorsGET":{},"timeAttendanceReportsViolatorsHtmlGET":{},"timeAttendanceReportsPresenceGET":{},"timeAttendanceReportsPresenceHtmlGET":{},"timeAttendanceReportsAbsenceGET":{},"timeAttendanceReportsAbsenceHtmlGET":{},"timeAttendanceReportsLateGET":{},"timeAttendanceReportsLateHtmlGET":{},"timeAttendanceReportsEarlyGET":{},"timeAttendanceReportsEarlyHtmlGET":{},"timeAttendanceReportsOverworkGET":{},"timeAttendanceReportsOverworkHtmlGET":{},"segmentsGET":{}}
88	21	53	##Отсутствующие сегодня##	absents	\N	1	\N	\N	6	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"timeAttendanceReportsDebtsTableGET":{},"timeAttendanceReportsDebtsCalculatePOST":{},"usersIdGET":{},"usersStaffListGET":{},"usersStaffIdGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdDocsTableGET":{},"usersIdDocsPUT":{},"usersIdDocsReasonPUT":{},"usersIdDocsIdGET":{},"userDocsIdPOST":{},"usersDocsIdDELETE":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"timeAttendanceReportsViolatorsGET":{},"timeAttendanceReportsViolatorsHtmlGET":{},"timeAttendanceReportsPresenceGET":{},"timeAttendanceReportsPresenceHtmlGET":{},"timeAttendanceReportsAbsenceGET":{},"timeAttendanceReportsAbsenceHtmlGET":{},"timeAttendanceReportsLateGET":{},"timeAttendanceReportsLateHtmlGET":{},"timeAttendanceReportsEarlyGET":{},"timeAttendanceReportsEarlyHtmlGET":{},"timeAttendanceReportsOverworkGET":{},"timeAttendanceReportsOverworkHtmlGET":{},"segmentsGET":{}}
89	21	54	##Опоздавшие сегодня##	lates	\N	1	\N	\N	6	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"timeAttendanceReportsDebtsTableGET":{},"timeAttendanceReportsDebtsCalculatePOST":{},"usersIdGET":{},"usersStaffListGET":{},"usersStaffIdGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdDocsTableGET":{},"usersIdDocsPUT":{},"usersIdDocsReasonPUT":{},"usersIdDocsIdGET":{},"userDocsIdPOST":{},"usersDocsIdDELETE":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"timeAttendanceReportsViolatorsGET":{},"timeAttendanceReportsViolatorsHtmlGET":{},"timeAttendanceReportsPresenceGET":{},"timeAttendanceReportsPresenceHtmlGET":{},"timeAttendanceReportsAbsenceGET":{},"timeAttendanceReportsAbsenceHtmlGET":{},"timeAttendanceReportsLateGET":{},"timeAttendanceReportsLateHtmlGET":{},"timeAttendanceReportsEarlyGET":{},"timeAttendanceReportsEarlyHtmlGET":{},"timeAttendanceReportsOverworkGET":{},"timeAttendanceReportsOverworkHtmlGET":{},"segmentsGET":{}}
90	21	55	##Ушедшие раньше сегодня##	earlys	\N	1	\N	\N	6	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"timeAttendanceReportsDebtsTableGET":{},"timeAttendanceReportsDebtsCalculatePOST":{},"usersIdGET":{},"usersStaffListGET":{},"usersStaffIdGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdDocsTableGET":{},"usersIdDocsPUT":{},"usersIdDocsReasonPUT":{},"usersIdDocsIdGET":{},"userDocsIdPOST":{},"usersDocsIdDELETE":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"timeAttendanceReportsViolatorsGET":{},"timeAttendanceReportsViolatorsHtmlGET":{},"timeAttendanceReportsPresenceGET":{},"timeAttendanceReportsPresenceHtmlGET":{},"timeAttendanceReportsAbsenceGET":{},"timeAttendanceReportsAbsenceHtmlGET":{},"timeAttendanceReportsLateGET":{},"timeAttendanceReportsLateHtmlGET":{},"timeAttendanceReportsEarlyGET":{},"timeAttendanceReportsEarlyHtmlGET":{},"timeAttendanceReportsOverworkGET":{},"timeAttendanceReportsOverworkHtmlGET":{},"segmentsGET":{}}
91	21	56	##Переработка##	overworks	\N	1	\N	\N	6	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"timeAttendanceReportsDebtsTableGET":{},"timeAttendanceReportsDebtsCalculatePOST":{},"usersIdGET":{},"usersStaffListGET":{},"usersStaffIdGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdDocsTableGET":{},"usersIdDocsPUT":{},"usersIdDocsReasonPUT":{},"usersIdDocsIdGET":{},"userDocsIdPOST":{},"usersDocsIdDELETE":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"timeAttendanceReportsViolatorsGET":{},"timeAttendanceReportsViolatorsHtmlGET":{},"timeAttendanceReportsPresenceGET":{},"timeAttendanceReportsPresenceHtmlGET":{},"timeAttendanceReportsAbsenceGET":{},"timeAttendanceReportsAbsenceHtmlGET":{},"timeAttendanceReportsLateGET":{},"timeAttendanceReportsLateHtmlGET":{},"timeAttendanceReportsEarlyGET":{},"timeAttendanceReportsEarlyHtmlGET":{},"timeAttendanceReportsOverworkGET":{},"timeAttendanceReportsOverworkHtmlGET":{},"segmentsGET":{}}
92	16	33	##Комиссионирование##	accesscommission	\N	1	\N	\N	4	\N	{"devicesChangePOST":{},"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"roomsTreeGET":{},"roomsListGET":{},"deviceStateGET":{},"usersStaffCommissionListGET":{},"roomWithDevicesGET":{},"divisionsTreeGET":{},"divisionsListGET":{},"roomsWithDeviceTypeGET":{},"accessTemplatesIdGET":{},"accessSchedulesTypesGET":{},"accessSchedulesListGET":{},"accessSchedulesPUT":{},"accessSchedulesIdGET":{},"accessSchedulesIdPOST":{},"accessTemplatesAccessRightsGET":{},"accessTemplatesCommissionTypesGET":{},"accessTemplatesPUT":{},"accessTemplatesTableGET":{},"accessTemplatesIdPOST":{},"accessTemplatesIdDELETE":{},"accessSchedulesTableGET":{},"accessSchedulesTimeZonePUT":{},"accessSchedulesTimeZoneIdPOST":{},"accessSchedulesWeeklyPUT":{},"accessSchedulesWeeklyIdPOST":{},"accessSchedulesFlexDayPUT":{},"accessSchedulesFlexDayPOST":{},"accessSchedulesFlexWeeklyPUT":{},"accessSchedulesFlexWeeklyIdPOST":{},"accessCommissionRoomIdPOST":{},"accessSchedulesIdDELETE":{},"accessSchedulesHolidaysGroupIdPOST":{},"roomIdCommissionTypesGET":{},"segmentsGET":{}}
95	4	51	##Отчёт УРВ##	reports	\N	1	\N	\N	6	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"timeAttendanceReportsDebtsTableGET":{},"timeAttendanceReportsDebtsCalculatePOST":{},"usersIdGET":{},"usersStaffIdGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdDocsReasonPUT":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"timeAttendanceReportsViolatorsGET":{},"timeAttendanceReportsViolatorsHtmlGET":{},"timeAttendanceReportsPresenceGET":{},"timeAttendanceReportsPresenceHtmlGET":{},"timeAttendanceReportsAbsenceGET":{},"timeAttendanceReportsAbsenceHtmlGET":{},"timeAttendanceReportsLateGET":{},"timeAttendanceReportsLateHtmlGET":{},"timeAttendanceReportsEarlyGET":{},"timeAttendanceReportsEarlyHtmlGET":{},"timeAttendanceReportsOverworkGET":{},"timeAttendanceReportsOverworkHtmlGET":{},"timeAttendanceReportsReportsGET":{},"timeAttendanceReportsReportsHtmlGET":{},"timeAttendanceReportsReportsXlsxGET":{},"segmentsGET":{}}
96	4	57	##Время присутствия##	timepresence	\N	1	\N	\N	6	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"timeAttendanceReportsDebtsTableGET":{},"timeAttendanceReportsDebtsCalculatePOST":{},"usersIdGET":{},"usersStaffIdGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdDocsReasonPUT":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"timeAttendanceReportsViolatorsGET":{},"timeAttendanceReportsViolatorsHtmlGET":{},"timeAttendanceReportsPresenceGET":{},"timeAttendanceReportsPresenceHtmlGET":{},"timeAttendanceReportsAbsenceGET":{},"timeAttendanceReportsAbsenceHtmlGET":{},"timeAttendanceReportsLateGET":{},"timeAttendanceReportsLateHtmlGET":{},"timeAttendanceReportsEarlyGET":{},"timeAttendanceReportsEarlyHtmlGET":{},"timeAttendanceReportsOverworkGET":{},"timeAttendanceReportsOverworkHtmlGET":{},"extraReportsPresenceTimeGET":{},"extraReportsPresenceHtmlGET":{},"extraReportsPresenceXlsxGET":{},"segmentsGET":{}}
97	4	58	##Выданные документы##	userdocs	\N	1	\N	\N	6	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"timeAttendanceReportsDebtsTableGET":{},"timeAttendanceReportsDebtsCalculatePOST":{},"usersIdGET":{},"usersStaffIdGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdDocsReasonPUT":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"timeAttendanceReportsViolatorsGET":{},"timeAttendanceReportsViolatorsHtmlGET":{},"timeAttendanceReportsPresenceGET":{},"timeAttendanceReportsPresenceHtmlGET":{},"timeAttendanceReportsAbsenceGET":{},"timeAttendanceReportsAbsenceHtmlGET":{},"timeAttendanceReportsLateGET":{},"timeAttendanceReportsLateHtmlGET":{},"timeAttendanceReportsEarlyGET":{},"timeAttendanceReportsEarlyHtmlGET":{},"timeAttendanceReportsOverworkGET":{},"timeAttendanceReportsOverworkHtmlGET":{},"extraReportsDocumentsGET":{},"extraReportsDocumentsHtmlGET":{},"extraReportsDocumentsXlsxGET":{},"segmentsGET":{}}
98	5	70	##Выданные идентификаторы##	identifiers	\N	1	\N	\N	5	\N	{"systemChangeLanguagePOST":{},"operatorsCurrentGET":{},"operatorsCurrentPOST":{},"timeAttendanceReportsBalanceGET":{},"timeAttendanceReportsEventsListGET":{},"timeAttendanceReportsEventsTableGET":{},"timeAttendanceReportsEventToggle":{},"timeAttendanceProgressGet":{},"timeAttendanceTimeTrackingPOST":{},"usersIdGET":{},"usersStaffIdGET":{},"exportPOST":{},"divisionsTreeGET":{},"divisionsListGET":{},"usersIdDocsReasonPUT":{},"timeAttendanceDocsListGET":{},"timeAttendanceDocsIdGET":{},"timeAttendanceReportsViolatorsGET":{},"timeAttendanceReportsViolatorsHtmlGET":{},"timeAttendanceReportsPresenceGET":{},"timeAttendanceReportsPresenceHtmlGET":{},"timeAttendanceReportsAbsenceGET":{},"timeAttendanceReportsAbsenceHtmlGET":{},"timeAttendanceReportsLateGET":{},"timeAttendanceReportsLateHtmlGET":{},"timeAttendanceReportsEarlyGET":{},"timeAttendanceReportsEarlyHtmlGET":{},"timeAttendanceReportsOverworkGET":{},"timeAttendanceReportsOverworkHtmlGET":{},"extraReportsIDsGET":{},"extraReportsIDsHtmlGET":{},"extraReportsIDsXlsxGET":{},"extraReportsIDsListGET":{},"segmentsGET":{}}
99	1	101	##Интеграция с ИСО "ОРИОН" (НВП "Болид")##	bolid	\N	1	\N	\N	12	\N	{"operatorsCurrentGET":{},"operatorsCurrentPOST":{}}
\.


--
-- Data for Name: device; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.device (id, parent_id, device_type_id, hard_number, ip_addr, name, port, login, password, access_zone_id1, access_zone_id2, is_removed, net_mask, ip_router, mac_address, resource_data, schema_data, sub_type, firmware_version, protocol_id, link_id, part_number, segment_id) FROM stdin;
0	\N	0	\N	\N	##Общие настройки##	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
\.


--
-- Data for Name: device_camera_stream; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.device_camera_stream (id, name, comment) FROM stdin;
1	mjpeg_over_http	\N
2	webcam	\N
3	ONVIF	\N
4	TRASSIR	\N
\.


--
-- Data for Name: device_camera_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.device_camera_type (id, is_const, manufacturer, model, camera_stream_type_id, "path") FROM stdin;
2	1	AXIS	All	1	/mjpg/video.mjpg
7	1	ACTi	ACM-4000	1	/cgi-bin/cmd/encoder?GET_STREAM=VIDEO
8	1	TP-LINK	All	1	/video.mjpg
9	1	ONVIF	All	3	/
10	1	TRASSIR	All	4
\.


--
-- Data for Name: device_resource; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.device_resource (id, resource_type_id, type_id, name, short_name, schema_title) FROM stdin;
1	6	1	Генератор тревоги (400 Контроллер турникета1-8 [Стойка турникета. Виртуальный контроллер второго уровня])	Генератор тревоги	alarm_gen_type_1
2	6	3	Генератор тревоги (1,2) (700 Контроллер замка2-8 [Контроллер второго уровня (Виртуальный или CL201)])	Генератор тревоги	alarm_gen_type_3
3	6	2	Генератор тревоги (401 Контроллер турникета1-8 [CL201. Контроллер второго уровня])	Генератор тревоги	alarm_gen_type_2
4	6	4	Генератор тревоги (3-10) (700 Контроллер замка2-8 [Контроллер второго уровня (Виртуальный или CL201)])	Генератор тревоги	alarm_gen_type_4
5	6	5	Генератор тревоги (1) (600 Контроллер замка1-8 [Контроллер второго уровня (Виртуальный или CL201)])	Генератор тревоги	alarm_gen_type_5
6	6	6	Генератор тревоги (3-10) (600 Контроллер замка1-8 [Контроллер второго уровня (Виртуальный или CL201)])	Генератор тревоги	alarm_gen_type_6
7	6	7	Генератор тревоги (Контроллер замка (CL05) 1)	Генератор тревоги	alarm_gen_type_7
8	7	1	Дополнительный вход №1 (4 Контроллер турникета1-8)	Дополнительный вход №1	input_type_1
9	7	2	Дополнительный вход №2 (4 Контроллер турникета1-8)	Дополнительный вход №2test	\N
10	7	5	Дополнительный вход №1 (6 Контроллер замка1-8)	Дополнительный вход №1	input_type_5
12	7	3	Дополнительный вход №1 (7 Контроллер замка2-8)	Дополнительный вход №1	\N
14	8	1	Дополнительный выход №3 (4  Контроллер турникета1-8)	Дополнительный выход №3	output_type_1
15	8	2	Дополнительный выход №4 (4  Контроллер турникета1-8)	Дополнительный выход №4	\N
16	8	7	Дополнительный выход №1 (6  Контроллер замка1-8)	Дополнительный выход №1	output_type_7
19	8	3	Дополнительный выход №1 (7  Контроллер замка2-8)	Дополнительный выход №1	\N
24	8	11	Дополнительный выход (1 Контроллер замка (CL05) 1)	Дополнительный выход	output_type_11
25	8	12	Дополнительный вывод (1 Контроллер замка (CL05.1) 1)	Дополнительный вывод	output_type_12
26	9	1	Турникет (400 Контроллер турникета1-8 [Стойка турникета. Виртуальный контроллер второго уровня])	Турникет	lock_type_1
27	9	2	Замок (401 Контроллер турникета1-8 [CL201. Контроллер второго уровня])	Замок	lock_type_2
28	9	3	Замок (700 Контроллер замка2-8 [Контроллер второго уровня (Виртуальный или CL201)])	Замок	lock_type_3
29	9	4	Замок (600 Контроллер замка1-8 [Контроллер второго уровня CL201])	Замок	lock_type_4
30	9	5	Замок (1 Контроллер замка (CL05) 1)	Замок	lock_type_5
31	9	6	Замок (600 Контроллер замка1-8 [Контроллер второго уровня Виртуальный])	Замок	lock_type_6
32	9	7	Замок (1 Контроллер замка (CL05.01) 1)	Замок	lock_type_7
33	9	8	Замок Suprema	Замок	lock_suprema
34	10	1	Считыватель (400 Контроллер турникета1-8 [Стойка турникета. Виртуальный контроллер второго уровня])	Считыватель	reader_type_1
35	10	3	Считыватель (700 Контроллер замка2-8 [Контроллер второго уровня (Виртуальный или CL201)])	Считыватель	\N
36	10	4	Считыватель (600 Контроллер замка2-8 [Контроллер второго уровня (Виртуальный или CL201)])	Считыватель	reader_type_4
37	10	6	Считыватель (2 ЛИКОН)	Считыватель	reader_type_6
38	10	5	Считыватель (1 Контроллер замка (CL05) 1)	Считыватель	reader_type_5
39	10	2	Считыватель (402 [CL201. Контроллер второго уровня для CTL4.2])	Считыватель	reader_type_2
40	10	7	Считыватель Suprema	Считыватель	reader_suprema
41	25	1	Общие	Общие	\N
42	27	1	Сеть	Сеть	network
43	28	1	Разное	Разное	settings
44	29	1	Состояние	Состояние	hw_state
45	30	1	Внешние подключения	Внешние подключения	connections
46	14	1	Свойства ЛИКОНа	Свойства ЛИКОНа	licon_config
47	16	1	Строки ЛИКОНа	Строки ЛИКОНа	licon_string_1
48	31	1	Общие параметры	Общие параметры	parameters
49	31	3	Настройка mifare	Настройка mifare	mifare_settings
50	31	4	Настройка Suprema	Настройка Suprema	suprema_settings
51	31	2	Настройка PERCo	Настройка PERCo	perco_settings
52	26	1	О камере ONVIF	О камере	camera_about_onvif
53	28	2	Разное	Разное	s30_settings
54	26	2	Камера ONVIF	Камера	camera_settings
55	26	3	Видео	Видео	camera_video
56	7	6	Вход s30	Вход s30	input_type_6
57	8	13	Выход s30	Выход s30	output_type_13
58	9	9	ИУ s30	ИУ s30	lock_type_9
59	32	1	Направление s30	Направление s30	direction_type_1
60	33	1	Cчитыватель или сканер s30	Cчитыватель или сканер s30	reader_type_8
68	32	2	Направление s30 (ЛИКОН)	Направление s30 (ЛИКОН)	direction_type_2
70	9	10	ЛИКОН s30	ЛИКОН s30	lock_type_10
71	6	8	Генератор тревоги s30	Генератор тревоги	alarm_gen_type_8
72	34	1	Шлюз CTL14	Шлюз CTL14	gateway_type_1
73	34	2	Шлюз CL15	Шлюз CL15	gateway_type_2
76	10	10	Считыватель 4.2 турникет	Считыватель 4.2 турникет	reader_type_10
77	10	9	Считыватель 4.2 замок	Считыватель 4.2 замок	reader_type_9
78	7	7	Дополнительный вход 4.2	Дополнительный вход 4.2	input_type_7
79	35	1	Параметры точки верификации	Точка верификации	verify_point_settings
80	35	3	Точка идентификации для Ликона	Точка верификации	verify_point_reaction_licon
81	35	2	Точка верификации	Точка верификации	verify_point_reaction
82	26	4	О камере MJPEG	О камере	camera_about_mjpeg
83	26	5	Камера MJPEG	Камера	camera_settings_mjpeg
84	35	4	Параметры точки верификации для S30	Точка верификации	verify_point_settings_s30
85	9	11	ИУ CL15 s30	ИУ CL15 s30	lock_type_11
86	34	3	Составной объект CL15	Составной объект CL15	gateway_type_3
88	16	2	Строки ЛИКОНа 4.2	Строки ЛИКОНа	licon_string_2
89	33	2	Cчитыватель morpho CT13	Cчитыватель morpho CT13	reader_type_11
90	33	3	Cчитыватель morpho	Cчитыватель morpho	reader_type_12
91	9	12	Замок ZKTeco	Замок	lock_zkteco
92	10	11	Считыватель ZKTeco	Считыватель	reader_zkteco
93	10	12	Считыватель Suprema Face	Считыватель	reader_suprema_face
94	28	3	Разное	Разное	zkt_settings
95	31	5	Настройка ZKTeco	Настройка ZKTeco	zkt_common_settings
96	35	5	Точка идентификации для Suprema	Точка верификации	verify_point_reaction_suprema
97	35	6	Точка идентификации для ZKTeco	Точка верификации	verify_point_reaction_zkteco
98	27	2	Сеть	Сеть	network_trassir
99	26	6	О камере TRASSIR	О камере	camera_about_trassir
100	26	7	Видео TRASSIR	Видео	camera_video_trassir
101	10	13	Считыватель TRASSIR	Считыватель	reader_trassir
102	35	7	Точка верификации TRASSIR	Точка верификации	verify_point_reaction_trassir
103	35	8	Параметры точки верификации для TRASSIR	Точка верификации	verify_point_settings_trassir
104	9	13	ИУ CL201 s30	ИУ CL201 s30	lock_cl201
105	9	14	Зона Bolid	Зона Bolid	lock_bolid_zone
106	9	15	Реле Bolid	Реле Bolid	lock_bolid_relay
107	27	3	Настройка Bolid	Настройка Bolid	network_bolid
108	9	16	Шлагбаум CT/L04	Шлагбаум CT/L04	lock_barrier
109	33	4	Считыватель TRASSIR s30	Считыватель TRASSIR s30	reader_trassir_s30
\.


--
-- Data for Name: device_resource_change; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.device_resource_change (device_id, resource_type, resource_number) FROM stdin;
\.


--
-- Data for Name: device_resource_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.device_resource_type (id, name, title) FROM stdin;
1	Временные зоны	time_zone
2	Недельные графики	weekly_schedule
3	Скользящие подневные графики	shift_day_schedule
4	Скользящие понедельные графики	shift_weekly_schedule
5	Календарь праздничных дней	holidays
6	Генератор тревоги	alarm_gen
7	Вход	input
8	Выход	output
9	Замок	lock
10	Считыватель	reader
11	Карты комиссионирования	comission_card
14	Свойства ЛИКОНа	licon_config
16	строки ЛИКОНа	licon_string
20	Пространственные зоны	spatial_zone
25	Общие настройки	general
26	Камера	camera
27	Сеть	network
28	Разное	settings
29	Состояние	hw_state
30	Внешние подключения	connection
31	Общие параметры	parameters
32	Направление	direction
33	Считыватель	reader_ext
34	Шлюз или составной объект	gateway
35	Точка верификации	verify_point
\.


--
-- Data for Name: device_schema; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.device_schema (id, title, description, json) FROM stdin;
1	common_settings	\N	{"0":{"is_hub":0,"resources":{"parameters":{"is_tab":true,"_common":{"type":1},"_perco_settings":{"type":2},"_mifare_settings":{"type":3},"_suprema_settings":{"type":4},"_zkt_common_settings":{"type":5}}}}}
2	parameters	\N	{"type":"object","widget":"section","expandable":true,"title":"##Общие настройки##","properties":{"reader_format":{"type":"string","widget":"select","title":"##Режим работы считывателей##","enum":[0,1],"enumNames":["##Wiegand 26##","##Универсальный (8 байт)##"],"default":1},"global_antipass":{"type":"string","widget":"select","title":"##Глобальный антипасс##","enum":[0,1],"enumNames":["##Отключен##","##Включен##"],"default":0}}}
3	perco_settings	\N	{"type":"object","title":"##Контроллеры PERCo##","widget":"section","properties":{"password":{"type":"password","title":"##Изменить пароль##","default":"","validator":{"isEqual":"parameters_perco_settings.confirm_password","maxLength":10}},"confirm_password":{"type":"password","title":"##Подтверждение пароля##","collect":false,"default":"","validator":{"isEqual":"parameters_perco_settings.password","maxLength":10}}}}
4	mifare_settings	\N	{"type": "object", "title": "##Карты Mifare##", "widget": "section", "properties": {"general": {"type": "object", "title": "##Общие настройки карт Mifare##", "widget": "section", "dependencies": {"true": [{"item": "parameters_mifare_settings.command.write_key", "props": {"visible": false}}]}, "properties": {"safe_identifier": {"enum": [0, 1], "type": "string", "title": "##Чтение из защищенной области##", "widget": "select", "default": 0, "enumNames": ["##Простое чтение##", "##С записью карты##"], "dependencies": {"1": [{"item": "parameters_mifare_settings.general.id_generation", "props": {"visible": true}}]}}, "id_generation": {"enum": [0, 1, 2], "type": "string", "title": "##Генерация номера##", "widget": "select", "default": 0, "enumNames": ["##Ручной ввод##", "##Случайный номер##", "##Автоинкремент##"]}, "lock_key_mstr": {"readonly": true, "clientReader": true, "type": "string", "title": "##Ключ закрытия мастер-карты##", "default": "00000000000000000000000000000000"}, "next_lock_key_mstr": {"type": "string", "clientReader": true, "title": "##Новый ключ закрытия мастер-карты##", "default": "ffffffffffffffffffffffffffffffff", "validator": {"minLength": 1, "maxLength": 32, "pattern": "hex"}}, "mstr_level": {"type": "string", "clientReader": true, "title": "##Уровень мастер-карты##", "default": 2, "visible": "$$developerVisible$$", "validator": {"min": 1, "max": 65535, "pattern": "number"}}, "id_order": {"enum": [0, 1], "type": "string", "clientReader": true, "title": "##Порядок байт в идентификаторе##", "widget": "select", "default": 1, "enumNames": ["##От старшего к младшему##", "##От младшего к старшему##"]}, "lock_general": {"type": "boolean", "visible": false, "default": false, "dependencies": {"true": [{"item": "parameters_mifare_settings.general.next_lock_key_mstr", "props": {"disabled": true}}]}}, "label": {"type": "string", "widget": "simple-text", "content": "##Поля HID и EM-marine только для считывателя IR19 и контроллера замка CL211.9##", "htmlClass": "message-device-settings"}, "HID": {"type": "string", "title": "HID", "widget": "select", "default": 1, "enum": [0, 1], "enumNames": ["##Отключено##", "##Включено##"], "clientReader": true}, "Emm": {"type": "string", "title": "EM-marine", "widget": "select", "default": 1, "enum": [0, 1], "enumNames": ["##Отключено##", "##Включено##"], "clientReader": true}, "block_read_uid": {"type": "string", "title": "##Запрет работы с UID нераспознанных карт##", "widget": "select", "default": 0, "enum": [0, 1], "enumNames": ["##Нет (небезопасно)##", "##Да##"], "clientReader": true}}}, "card_in_use": {"type": "object", "title": "##Выбрать типы карт##", "widget": "section", "dependencies": {"true": [{"item": "parameters_mifare_settings.command", "props": {"visible": false}}]}, "properties": {"Ultralight_EV1_48_byte": {"type": "boolean", "title": "Ultralight EV1 48 byte", "default": false, "clientReader": true, "dependencies": {"true": [{"item": "parameters_mifare_settings.Ultralight_EV1_48_byte", "props": {"visible": true}}, {"item": "parameters_mifare_settings.card_in_use.SIM", "props": {"disabled": false}}]}}, "Ultralight_EV1_128_byte": {"type": "boolean", "title": "Ultralight EV1 128 byte", "default": false, "clientReader": true, "dependencies": {"true": [{"item": "parameters_mifare_settings.Ultralight_EV1_128_byte", "props": {"visible": true}}, {"item": "parameters_mifare_settings.card_in_use.SIM", "props": {"disabled": false}}]}}, "Ultralight_C_144_byte": {"type": "boolean", "title": "Ultralight C 144 byte", "default": false, "clientReader": true, "dependencies": {"true": [{"item": "parameters_mifare_settings.Ultralight_C_144_byte", "props": {"visible": true}}, {"item": "parameters_mifare_settings.card_in_use.SIM", "props": {"disabled": false}}]}}, "Classic_ID_64": {"type": "boolean", "title": "Classic ID 64", "default": false, "clientReader": true, "dependencies": {"true": [{"item": "parameters_mifare_settings.Classic_ID_64", "props": {"visible": true}}, {"item": "parameters_mifare_settings.Classic_common", "props": {"visible": true}}, {"item": "parameters_mifare_settings.card_in_use.SIM", "props": {"disabled": false}}]}}, "Classic_1_KB": {"type": "boolean", "title": "Classic 1 KB", "default": false, "clientReader": true, "dependencies": {"true": [{"item": "parameters_mifare_settings.Classic_1_KB", "props": {"visible": true}}, {"item": "parameters_mifare_settings.Classic_common", "props": {"visible": true}}, {"item": "parameters_mifare_settings.card_in_use.SIM", "props": {"disabled": false}}]}}, "Classic_4_KB": {"type": "boolean", "title": "Classic 4 KB", "default": false, "clientReader": true, "dependencies": {"true": [{"item": "parameters_mifare_settings.Classic_4_KB", "props": {"visible": true}}, {"item": "parameters_mifare_settings.Classic_common", "props": {"visible": true}}, {"item": "parameters_mifare_settings.card_in_use.SIM", "props": {"disabled": false}}]}}, "Plus_2_KB": {"type": "boolean", "title": "Plus 2 KB", "default": false, "clientReader": true, "dependencies": {"true": [{"item": "parameters_mifare_settings.Plus_2_KB", "props": {"visible": true}}, {"item": "parameters_mifare_settings.Plus_common", "props": {"visible": true}}, {"item": "parameters_mifare_settings.card_in_use.SIM", "props": {"disabled": false}}]}}, "Plus_4_KB": {"type": "boolean", "title": "Plus 4 KB", "default": false, "clientReader": true, "dependencies": {"true": [{"item": "parameters_mifare_settings.Plus_4_KB", "props": {"visible": true}}, {"item": "parameters_mifare_settings.Plus_common", "props": {"visible": true}}, {"item": "parameters_mifare_settings.card_in_use.SIM", "props": {"disabled": false}}]}}, "Plus_SE_1_KB": {"type": "boolean", "title": "Plus SE 1 KB", "default": false, "clientReader": true, "dependencies": {"true": [{"item": "parameters_mifare_settings.Plus_SE_1_KB", "props": {"visible": true}}, {"item": "parameters_mifare_settings.Plus_common", "props": {"visible": true}}, {"item": "parameters_mifare_settings.card_in_use.SIM", "props": {"disabled": false}}]}}, "DESFire": {"type": "boolean", "title": "DESFire", "default": false, "clientReader": true, "dependencies": {"true": [{"item": "parameters_mifare_settings.DESFire", "props": {"visible": true}}, {"item": "parameters_mifare_settings.card_in_use.SIM", "props": {"readonly": false}}, {"item": "parameters_mifare_settings.card_in_use.SIM", "props": {"disabled": false}}]}}, "MIR": {"type": "boolean", "title": "##МИР##", "default": false, "clientReader": true, "dependencies": {"true": [{"item": "parameters_mifare_settings.MIR", "props": {"visible": true}}, {"item": "parameters_mifare_settings.card_in_use.SIM", "props": {"disabled": false}}]}}, "SIM": {"type": "boolean", "title": "##Смартфон (SIM-карта)##", "default": true, "clientReader": true, "dependencies": {"true": [{"item": "parameters_mifare_settings.SIM", "props": {"visible": true}}]}}, "bank_cards": {"type": "boolean", "title": "##Банковские карты##", "default": true, "clientReader": true, "dependencies": {"true": [{"item": "parameters_mifare_settings.bank_cards", "props": {"visible": true}}]}}}}, "Ultralight_EV1_48_byte": {"type": "object", "title": "Ultralight EV1 48 byte", "widget": "section", "properties": {"page": {"enum": [4, 6, 8, 10, 12, 14], "clientReader": true, "type": "string", "title": "##Страница##", "widget": "select", "default": 4, "enumNames": ["4-5", "6-7", "8-9", "10-11", "12-13", "14-15"]}}}, "Ultralight_EV1_128_byte": {"type": "object", "title": "Ultralight EV1 128 byte", "widget": "section", "properties": {"page": {"enum": [4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34], "clientReader": true, "type": "string", "title": "##Страница##", "widget": "select", "default": 4, "enumNames": ["4-5", "6-7", "8-9", "10-11", "12-13", "14-15", "16-17", "18-19", "20-21", "22-23", "24-25", "26-27", "28-29", "30-31", "32-33", "34-35"]}}}, "Ultralight_C_144_byte": {"type": "object", "title": "Ultralight C 144 byte", "widget": "section", "properties": {"page": {"enum": [4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38], "clientReader": true, "type": "string", "title": "##Страница##", "widget": "select", "default": 4, "enumNames": ["4-5", "6-7", "8-9", "10-11", "12-13", "14-15", "16-17", "18-19", "20-21", "22-23", "24-25", "26-27", "28-29", "30-31", "32-33", "34-35", "36-37", "38-39"]}, "access_key_old": {"type": "string", "readonly": true, "clientReader": true, "title": "##Старый ключ аутентификации##", "default": "00000000000000000000000000000000"}, "access_key": {"type": "string", "clientReader": true, "title": "##Ключ аутентификации##", "default": "ffffffffffffffffffffffffffffffff", "widgetConfig": {"onActivateMessage": {"type": "warning", "message": "##ВНИМАНИЕ! В случае изменения данных параметров необходимо записать мастер-карту с новыми параметрами, после чего переконфигурировать этой картой все считыватели и изменить ключи на всех картах доcтупа этого типа##"}}, "validator": {"pattern": "hex", "maxLength": 32}}, "lock_ultralight": {"type": "boolean", "visible": false, "default": false, "dependencies": {"true": [{"item": "parameters_mifare_settings.Ultralight_C_144_byte.access_key", "props": {"disabled": true}}]}}}}, "Classic_common": {"type": "object", "widget": "section", "title": "##Общие настройки карт Classic##", "properties": {"access_type_old": {"enum": [10, 11], "type": "string", "clientReader": true, "title": "##Старый тип ключа для аутентификации##", "widget": "select", "readonly": true, "default": 10, "enumNames": ["A", "B"]}, "key_old": {"type": "string", "readonly": true, "clientReader": true, "title": "##Старый ключ аутентификации##", "default": "000000000000"}, "access_type": {"enum": [10, 11], "type": "string", "clientReader": true, "title": "##Тип ключа аутентификации##", "widget": "select", "default": 10, "enumNames": ["A", "B"], "widgetConfig": {"onActivateMessage": {"type": "warning", "message": "##ВНИМАНИЕ! В случае изменения данных параметров необходимо записать мастер-карту с новыми параметрами, после чего переконфигурировать этой картой все считыватели и изменить ключи на всех картах доcтупа этого типа##"}}, "dependencies": {"isChange": [{"item": "parameters_mifare_settings.Classic_common.key", "props": {"mark_as_change": true}}]}}, "key": {"type": "string", "clientReader": true, "title": "##Ключ аутентификации##", "default": "fffffffffff0", "validator": {"pattern": "hex", "maxLength": 12}, "widgetConfig": {"onActivateMessage": {"type": "warning", "message": "##ВНИМАНИЕ! В случае изменения данных параметров необходимо записать мастер-карту с новыми параметрами, после чего переконфигурировать этой картой все считыватели и изменить ключи на всех картах доcтупа этого типа##"}}, "dependencies": {"isChange": [{"item": "parameters_mifare_settings.Classic_common.access_type", "props": {"mark_as_change": true}}]}}, "lock_classic": {"type": "boolean", "visible": false, "default": false, "dependencies": {"true": [{"item": "parameters_mifare_settings.Classic_common.access_type", "props": {"disabled": true}}, {"item": "parameters_mifare_settings.Classic_common.key", "props": {"disabled": true}}]}}}}, "Classic_ID_64": {"type": "object", "title": "Classic ID 64", "widget": "section", "htmlClass": "sub-item", "properties": {"block": {"enum": [1, 2], "type": "string", "clientReader": true, "title": "##Номер блока##", "widget": "select", "default": 1, "enumNames": ["1", "2"]}}}, "Classic_1_KB": {"type": "object", "title": "Classic 1 KB", "widget": "section", "htmlClass": "sub-item", "properties": {"sector": {"enum": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15], "type": "string", "title": "##Номер сектора##", "widget": "select", "default": 0, "clientReader": true, "enumNames": ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"], "dependencies": {"0": [{"item": "parameters_mifare_settings.Classic_1_KB.block", "props": {"enum": [1, 2], "enumNames": ["1", "2"], "default": 1}}]}}, "block": {"enum": [0, 1, 2], "type": "string", "clientReader": true, "title": "##Номер блока##", "widget": "select", "default": 1, "enumNames": ["0", "1", "2"]}, "fingerprint_range": {"type": "string", "title": "##Размер области отпечатков##", "clientReader": true, "visible": false, "default": 520, "validator": {"pattern": "number", "min": 260, "max": 520}}}}, "Classic_4_KB": {"type": "object", "title": "Classic 4 KB", "widget": "section", "htmlClass": "sub-item", "properties": {"sector": {"enum": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39], "type": "string", "clientReader": true, "title": "##Номер сектора##", "widget": "select", "default": 0, "enumNames": ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39"], "dependencies": {"0": [{"item": "parameters_mifare_settings.Classic_4_KB.block", "props": {"enum": [1, 2], "enumNames": ["1", "2"], "default": 1}}], "1": [{"item": "parameters_mifare_settings.Classic_4_KB.block", "props": {"enum": [0, 1, 2], "enumNames": ["0", "1", "2"], "default": 0}}], "2": "use 1", "3": "use 1", "4": "use 1", "5": "use 1", "6": "use 1", "7": "use 1", "8": "use 1", "9": "use 1", "10": "use 1", "11": "use 1", "12": "use 1", "13": "use 1", "14": "use 1", "15": "use 1", "16": "use 1", "17": "use 1", "18": "use 1", "19": "use 1", "20": "use 1", "21": "use 1", "22": "use 1", "23": "use 1", "24": "use 1", "25": "use 1", "26": "use 1", "27": "use 1", "28": "use 1", "29": "use 1", "30": "use 1", "31": "use 1"}}, "block": {"enum": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14], "type": "string", "clientReader": true, "title": "##Номер блока##", "widget": "select", "default": 1, "enumNames": ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14"]}, "fingerprint_range": {"type": "string", "title": "##Размер области отпечатков##", "clientReader": true, "visible": false, "default": 1300, "validator": {"pattern": "number", "min": 260, "max": 1300}}}}, "Plus_common": {"type": "object", "widget": "section", "title": "##Общие настройки карт Plus##", "dependencies": {"true": [{"item": "parameters_mifare_settings.command.up_security_level_SL", "props": {"visible": true}}]}, "properties": {"access_type_old": {"enum": [10, 11], "type": "string", "clientReader": true, "readonly": true, "title": "##Старый тип ключа аутентификации##", "widget": "select", "default": 10, "enumNames": ["A", "B"]}, "key_old": {"type": "string", "readonly": true, "clientReader": true, "title": "##Старый ключ аутентификации##", "default": "000000000000"}, "aes_a_key_old": {"type": "string", "readonly": true, "clientReader": true, "title": "##Старый ключ для уровня безопасности SL3 при типе ключа A##", "default": "00000000000000000000000000000000"}, "aes_b_key_old": {"type": "string", "readonly": true, "clientReader": true, "title": "##Старый ключ для уровня безопасности SL3 при типе ключа B##", "default": "00000000000000000000000000000000"}, "access_type": {"enum": [10, 11], "type": "string", "clientReader": true, "title": "##Тип ключа аутентификации##", "widget": "select", "default": 10, "enumNames": ["A", "B"], "widgetConfig": {"onActivateMessage": {"type": "warning", "message": "##ВНИМАНИЕ! В случае изменения данных параметров необходимо записать мастер-карту с новыми параметрами, после чего переконфигурировать этой картой все считыватели и изменить ключи на всех картах доcтупа этого типа##"}}, "dependencies": {"isChange": [{"item": "parameters_mifare_settings.Plus_common.key", "props": {"mark_as_change": true}}]}}, "key": {"type": "string", "title": "##Ключ аутентификации##", "default": "ffffffffffff", "clientReader": true, "validator": {"pattern": "hex", "maxLength": 12}, "widgetConfig": {"onActivateMessage": {"type": "warning", "message": "##ВНИМАНИЕ! В случае изменения данных параметров необходимо записать мастер-карту с новыми параметрами, после чего переконфигурировать этой картой все считыватели и изменить ключи на всех картах доcтупа этого типа##"}}, "dependencies": {"isChange": [{"item": "parameters_mifare_settings.Plus_common.access_type", "props": {"mark_as_change": true}}]}}, "lock_access_key": {"type": "boolean", "visible": false, "default": false, "dependencies": {"true": [{"item": "parameters_mifare_settings.Plus_common.access_type", "props": {"disabled": true}}, {"item": "parameters_mifare_settings.Plus_common.key", "props": {"disabled": true}}]}}, "aes_a_key": {"type": "string", "title": "##Ключ для уровня безопасности SL3 при типе ключа A##", "clientReader": true, "default": "ffffffffffffffffffffffffffffffff", "widgetConfig": {"onActivateMessage": {"type": "warning", "message": "##ВНИМАНИЕ! В случае изменения данных параметров необходимо записать мастер-карту с новыми параметрами, после чего переконфигурировать этой картой все считыватели и изменить ключи на всех картах доcтупа этого типа##"}}, "validator": {"pattern": "hex", "maxLength": 32}}, "lock_aes_a_key": {"type": "boolean", "visible": false, "default": false, "dependencies": {"true": [{"item": "parameters_mifare_settings.Plus_common.aes_a_key", "props": {"disabled": true}}]}}, "aes_b_key": {"type": "string", "clientReader": true, "title": "##Ключ для уровня безопасности SL3 при типе ключа B##", "default": "ffffffffffffffffffffffffffffffff", "widgetConfig": {"onActivateMessage": {"type": "warning", "message": "##ВНИМАНИЕ! В случае изменения данных параметров необходимо записать мастер-карту с новыми параметрами, после чего переконфигурировать этой картой все считыватели и изменить ключи на всех картах доcтупа этого типа##"}}, "validator": {"pattern": "hex", "maxLength": 32}}, "lock_aes_b_key": {"type": "boolean", "visible": false, "default": false, "dependencies": {"true": [{"item": "parameters_mifare_settings.Plus_common.aes_b_key", "props": {"disabled": true}}]}}, "sl": {"enum": [1, 3], "type": "string", "clientReader": true, "title": "##Уровень безопасности SL##", "widget": "select", "default": 1, "enumNames": ["1", "3"]}, "mstr_key": {"type": "string", "title": "##Мастер ключ##", "clientReader": true, "default": "ffffffffffffffffffffffffffffffff", "widgetConfig": {"onActivateMessage": {"type": "warning", "message": "##ВНИМАНИЕ! В случае изменения данных параметров Вы не сможете поднять уровень безопасности у уже используемых карт данного типа. Рекомендуем или поднять его до максимально желаемого уровня до изменения данных параметров, или сохранить где-либо значения данных параметров, чтобы их можно было ввести повторно при необходимости поднятия уровня у используемых сейчас карт данного типа##"}}, "validator": {"pattern": "hex", "maxLength": 32}}, "lock_mstr_key": {"type": "boolean", "visible": false, "default": false, "dependencies": {"true": [{"item": "parameters_mifare_settings.Plus_common.mstr_key", "props": {"disabled": true}}]}}, "config_key": {"type": "string", "clientReader": true, "title": "##Конфигурационный ключ##", "default": "ffffffffffffffffffffffffffffffff", "widgetConfig": {"onActivateMessage": {"type": "warning", "message": "##ВНИМАНИЕ! В случае изменения данных параметров Вы не сможете поднять уровень безопасности у уже используемых карт данного типа. Рекомендуем или поднять его до максимально желаемого уровня до изменения данных параметров, или сохранить где-либо значения данных параметров, чтобы их можно было ввести повторно при необходимости поднятия уровня у используемых сейчас карт данного типа##"}}, "validator": {"pattern": "hex", "maxLength": 32}}, "lock_config_key": {"type": "boolean", "visible": false, "default": false, "dependencies": {"true": [{"item": "parameters_mifare_settings.Plus_common.config_key", "props": {"disabled": true}}]}}, "keysl1_aes": {"type": "string", "clientReader": true, "title": "##Ключ аутентификации для уровня безопасности SL1##", "default": "ffffffffffffffffffffffffffffffff", "widgetConfig": {"onActivateMessage": {"type": "warning", "message": "##ВНИМАНИЕ! В случае изменения данных параметров Вы не сможете поднять уровень безопасности у уже используемых карт данного типа. Рекомендуем или поднять его до максимально желаемого уровня до изменения данных параметров, или сохранить где-либо значения данных параметров, чтобы их можно было ввести повторно при необходимости поднятия уровня у используемых сейчас карт данного типа##"}}, "validator": {"pattern": "hex", "maxLength": 32}}, "lock_keysl1_aes": {"type": "boolean", "visible": false, "default": false, "dependencies": {"true": [{"item": "parameters_mifare_settings.Plus_common.keysl1_aes", "props": {"disabled": true}}]}}, "switch_key3": {"type": "string", "clientReader": true, "title": "##Ключ переключения на уровень безопасности SL3##", "default": "ffffffffffffffffffffffffffffffff", "widgetConfig": {"onActivateMessage": {"type": "warning", "message": "##ВНИМАНИЕ! В случае изменения данных параметров Вы не сможете поднять уровень безопасности у уже используемых карт данного типа. Рекомендуем или поднять его до максимально желаемого уровня до изменения данных параметров, или сохранить где-либо значения данных параметров, чтобы их можно было ввести повторно при необходимости поднятия уровня у используемых сейчас карт данного типа##"}}, "validator": {"pattern": "hex", "maxLength": 32}}, "lock_switch_key3": {"type": "boolean", "visible": false, "default": false, "dependencies": {"true": [{"item": "parameters_mifare_settings.Plus_common.switch_key3", "props": {"disabled": true}}]}}}}, "Plus_2_KB": {"type": "object", "title": "Plus 2 KB", "widget": "section", "htmlClass": "sub-item", "dependencies": {"true": [{"item": "parameters_mifare_settings.command.up_security_level_SL", "props": {"visible": true}}]}, "properties": {"sector": {"enum": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31], "clientReader": true, "type": "string", "title": "##Номер сектора##", "widget": "select", "default": 0, "enumNames": ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"], "dependencies": {"0": [{"item": "parameters_mifare_settings.Plus_2_KB.block", "props": {"enum": [1, 2], "enumNames": ["1", "2"], "default": 1}}]}}, "block": {"enum": [0, 1, 2], "type": "string", "clientReader": true, "title": "##Номер блока##", "widget": "select", "default": 1, "enumNames": ["0", "1", "2"]}, "fingerprint_range": {"type": "string", "title": "##Размер области отпечатков##", "clientReader": true, "default": 1300, "visible": false, "validator": {"pattern": "number", "min": 260, "max": 1300}}}}, "Plus_4_KB": {"type": "object", "title": "Plus 4 KB", "widget": "section", "htmlClass": "sub-item", "dependencies": {"true": [{"item": "parameters_mifare_settings.command.up_security_level_SL", "props": {"visible": true}}]}, "properties": {"sector": {"enum": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39], "type": "string", "clientReader": true, "title": "##Номер сектора##", "widget": "select", "default": 0, "enumNames": ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39"], "dependencies": {"0": [{"item": "parameters_mifare_settings.Plus_4_KB.block", "props": {"enum": [1, 2], "enumNames": ["1", "2"], "default": 1}}], "1": [{"item": "parameters_mifare_settings.Plus_4_KB.block", "props": {"enum": [0, 1, 2], "enumNames": ["0", "1", "2"], "default": 0}}], "2": "use 1", "3": "use 1", "4": "use 1", "5": "use 1", "6": "use 1", "7": "use 1", "8": "use 1", "9": "use 1", "10": "use 1", "11": "use 1", "12": "use 1", "13": "use 1", "14": "use 1", "15": "use 1", "16": "use 1", "17": "use 1", "18": "use 1", "19": "use 1", "20": "use 1", "21": "use 1", "22": "use 1", "23": "use 1", "24": "use 1", "25": "use 1", "26": "use 1", "27": "use 1", "28": "use 1", "29": "use 1", "30": "use 1", "31": "use 1"}}, "block": {"enum": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14], "clientReader": true, "type": "string", "title": "##Номер блока##", "widget": "select", "default": 1, "enumNames": ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14"]}, "fingerprint_range": {"type": "string", "title": "##Размер области отпечатков##", "clientReader": true, "visible": false, "default": 1300, "validator": {"pattern": "number", "min": 260, "max": 1300}}}}, "Plus_SE_1_KB": {"type": "object", "title": "Plus SE 1 KB", "widget": "section", "htmlClass": "sub-item", "dependencies": {"true": [{"item": "parameters_mifare_settings.command.up_security_level_SL", "props": {"visible": true}}]}, "properties": {"sector": {"enum": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15], "clientReader": true, "type": "string", "title": "##Номер сектора##", "widget": "select", "default": 0, "enumNames": ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"], "dependencies": {"0": [{"item": "parameters_mifare_settings.Plus_SE_1_KB.block", "props": {"enum": [1, 2], "enumNames": ["1", "2"], "default": 1}}]}}, "block": {"enum": [0, 1, 2], "clientReader": true, "type": "string", "title": "##Номер блока##", "widget": "select", "default": 1, "enumNames": ["0", "1", "2"]}, "fingerprint_range": {"type": "string", "title": "##Размер области отпечатков##", "clientReader": true, "visible": false, "default": 520, "validator": {"pattern": "number", "min": 260, "max": 520}}}}, "DESFire": {"type": "object", "title": "DESFire", "widget": "section", "dependencies": {"true": [{"item": "parameters_mifare_settings.command.formatting", "props": {"visible": true}}]}, "properties": {"app_id_old": {"type": "string", "readonly": true, "clientReader": true, "title": "##Старый номер приложения##", "default": "f00000"}, "type_key_mstr_old": {"enum": [0, 4, 5], "type": "string", "readonly": true, "clientReader": true, "title": "##Старый тип ключа карты##", "widget": "select", "default": 0, "enumNames": ["AES (AES 128 Key [16 Bytes])", "2K3DES (2 Key Triple Des [16 Bytes])", "3K3DES (3 Key Triple Des [24 Bytes])"]}, "key_mstr_old": {"type": "string", "readonly": true, "clientReader": true, "title": "##Старый ключ карты##", "default": "00000000000000000000000000000000"}, "type_key_app_old": {"enum": [0, 4, 5], "type": "string", "readonly": true, "clientReader": true, "title": "##Старый тип ключа приложения##", "widget": "select", "default": 0, "enumNames": ["AES (AES 128 Key [16 Bytes])", "2K3DES (2 Key Triple Des [16 Bytes])", "3K3DES (3 Key Triple Des [24 Bytes])"]}, "key_app_old": {"type": "string", "readonly": true, "clientReader": true, "title": "##Старый ключ приложения##", "default": "00000000000000000000000000000000"}, "app_id": {"type": "string", "clientReader": true, "title": "##Номер приложения##", "default": "ffffff", "widgetConfig": {"onActivateMessage": {"type": "warning", "message": "##ВНИМАНИЕ! В случае изменения данных параметров необходимо записать мастер-карту с новыми параметрами, после чего переконфигурировать этой картой все считыватели и изменить ключи на всех картах доcтупа этого типа##"}}, "validator": {"pattern": "hex", "maxLength": 6}, "dependencies": {"isChange": [{"item": "parameters_mifare_settings.DESFire.type_key_mstr", "props": {"mark_as_change": true}}, {"item": "parameters_mifare_settings.DESFire.key_mstr", "props": {"mark_as_change": true}}, {"item": "parameters_mifare_settings.DESFire.type_key_app", "props": {"mark_as_change": true}}, {"item": "parameters_mifare_settings.DESFire.key_app", "props": {"mark_as_change": true}}]}}, "type_key_mstr": {"enum": [0, 4, 5], "type": "string", "clientReader": true, "title": "##Тип ключа карты##", "widget": "select", "default": 0, "widgetConfig": {"onActivateMessage": {"type": "warning", "message": "##ВНИМАНИЕ! В случае изменения данных параметров необходимо записать мастер-карту с новыми параметрами, после чего переконфигурировать этой картой все считыватели и изменить ключи на всех картах доcтупа этого типа##"}}, "enumNames": ["AES (AES 128 Key [16 Bytes])", "2K3DES (2 Key Triple Des [16 Bytes])", "3K3DES (3 Key Triple Des [24 Bytes])"], "dependencies": {"0": [{"item": "parameters_mifare_settings.DESFire.key_mstr", "props": {"validator": {"maxLength": 32}}}], "4": [{"item": "parameters_mifare_settings.DESFire.key_mstr", "props": {"validator": {"maxLength": 32}}}], "5": [{"item": "parameters_mifare_settings.DESFire.key_mstr", "props": {"validator": {"maxLength": 48}}}], "isChange": [{"item": "parameters_mifare_settings.DESFire.app_id", "props": {"mark_as_change": true}}, {"item": "parameters_mifare_settings.DESFire.key_mstr", "props": {"mark_as_change": true}}, {"item": "parameters_mifare_settings.DESFire.type_key_app", "props": {"mark_as_change": true}}, {"item": "parameters_mifare_settings.DESFire.key_app", "props": {"mark_as_change": true}}]}}, "key_mstr": {"type": "string", "title": "##Ключ карты##", "clientReader": true, "default": "ffffffffffffffffffffffffffffffff", "widgetConfig": {"onActivateMessage": {"type": "warning", "message": "##ВНИМАНИЕ! В случае изменения данных параметров необходимо записать мастер-карту с новыми параметрами, после чего переконфигурировать этой картой все считыватели и изменить ключи на всех картах доcтупа этого типа##"}}, "validator": {"pattern": "hex", "maxLength": 32}, "dependencies": {"isChange": [{"item": "parameters_mifare_settings.DESFire.app_id", "props": {"mark_as_change": true}}, {"item": "parameters_mifare_settings.DESFire.type_key_mstr", "props": {"mark_as_change": true}}, {"item": "parameters_mifare_settings.DESFire.type_key_app", "props": {"mark_as_change": true}}, {"item": "parameters_mifare_settings.DESFire.key_app", "props": {"mark_as_change": true}}]}}, "type_key_app": {"enum": [0, 4, 5], "type": "string", "title": "##Тип ключа приложения##", "widget": "select", "clientReader": true, "default": 0, "widgetConfig": {"onActivateMessage": {"type": "warning", "message": "##ВНИМАНИЕ! В случае изменения данных параметров необходимо записать мастер-карту с новыми параметрами, после чего переконфигурировать этой картой все считыватели и изменить ключи на всех картах доcтупа этого типа##"}}, "enumNames": ["AES (AES 128 Key [16 Bytes])", "2K3DES (2 Key Triple Des [16 Bytes])", "3K3DES (3 Key Triple Des [24 Bytes])"], "dependencies": {"0": [{"item": "parameters_mifare_settings.DESFire.key_app", "props": {"validator": {"maxLength": 32}}}], "4": [{"item": "parameters_mifare_settings.DESFire.key_app", "props": {"validator": {"maxLength": 32}}}], "5": [{"item": "parameters_mifare_settings.DESFire.key_app", "props": {"validator": {"maxLength": 48}}}], "isChange": [{"item": "parameters_mifare_settings.DESFire.app_id", "props": {"mark_as_change": true}}, {"item": "parameters_mifare_settings.DESFire.type_key_mstr", "props": {"mark_as_change": true}}, {"item": "parameters_mifare_settings.DESFire.key_mstr", "props": {"mark_as_change": true}}, {"item": "parameters_mifare_settings.DESFire.key_app", "props": {"mark_as_change": true}}]}}, "key_app": {"type": "string", "title": "##Ключ приложения##", "clientReader": true, "default": "ffffffffffffffffffffffffffffffff", "widgetConfig": {"onActivateMessage": {"type": "warning", "message": "##ВНИМАНИЕ! В случае изменения данных параметров необходимо записать мастер-карту с новыми параметрами, после чего переконфигурировать этой картой все считыватели и изменить ключи на всех картах доcтупа этого типа##"}}, "validator": {"pattern": "hex", "maxLength": 32}, "dependencies": {"isChange": [{"item": "parameters_mifare_settings.DESFire.app_id", "props": {"mark_as_change": true}}, {"item": "parameters_mifare_settings.DESFire.type_key_mstr", "props": {"mark_as_change": true}}, {"item": "parameters_mifare_settings.DESFire.key_mstr", "props": {"mark_as_change": true}}, {"item": "parameters_mifare_settings.DESFire.type_key_app", "props": {"mark_as_change": true}}]}}, "fingerprint_range": {"type": "string", "title": "##Размер области отпечатков##", "clientReader": true, "default": 1300, "visible": false, "validator": {"pattern": "number", "min": 260, "max": 1300}}, "fingerprint_app_id": {"type": "string", "clientReader": true, "title": "##Номер приложения отпечатка##", "default": "ff1", "visible": false, "validator": {"pattern": "hex", "maxLength": 3}}, "lock_desfire": {"type": "boolean", "visible": false, "default": false, "dependencies": {"true": [{"item": "parameters_mifare_settings.DESFire.app_id", "props": {"disabled": true}}, {"item": "parameters_mifare_settings.DESFire.type_key_mstr", "props": {"disabled": true}}, {"item": "parameters_mifare_settings.DESFire.key_mstr", "props": {"disabled": true}}, {"item": "parameters_mifare_settings.DESFire.type_key_app", "props": {"disabled": true}}, {"item": "parameters_mifare_settings.DESFire.key_app", "props": {"disabled": true}}]}}}}, "MIR": {"type": "object", "title": "##МИР##", "widget": "section", "properties": {"scudAID": {"type": "string", "title": "##Номер приложения##", "clientReader": true, "default": "ffffffffffffffffffffffffffffffff", "widgetConfig": {"onActivateMessage": {"type": "warning", "message": "##ВНИМАНИЕ! В случае изменения данных параметров необходимо записать мастер-карту с новыми параметрами, после чего переконфигурировать этой картой все считыватели и изменить ключи на всех картах доcтупа этого типа##"}}, "validator": {"pattern": "hex", "maxLength": 32}, "dependencies": {"isChange": [{"item": "parameters_mifare_settings.MIR.scudAID", "props": {"mark_as_change": true}}, {"item": "parameters_mifare_settings.MIR.masterKey", "props": {"mark_as_change": true}}]}}, "masterKey": {"type": "string", "title": "##Ключ приложения##", "clientReader": true, "default": "ffffffffffffffffffffffffffffffff", "widgetConfig": {"onActivateMessage": {"type": "warning", "message": "##ВНИМАНИЕ! В случае изменения данных параметров необходимо записать мастер-карту с новыми параметрами, после чего переконфигурировать этой картой все считыватели и изменить ключи на всех картах доcтупа этого типа##"}}, "validator": {"pattern": "hex", "maxLength": 32}, "dependencies": {"isChange": [{"item": "parameters_mifare_settings.DESFire.app_id", "props": {"mark_as_change": true}}, {"item": "parameters_mifare_settings.DESFire.type_key_mstr", "props": {"mark_as_change": true}}, {"item": "parameters_mifare_settings.DESFire.key_mstr", "props": {"mark_as_change": true}}, {"item": "parameters_mifare_settings.DESFire.type_key_app", "props": {"mark_as_change": true}}]}}, "lock_mir": {"type": "boolean", "visible": false, "default": false, "dependencies": {"true": [{"item": "parameters_mifare_settings.MIR.scudAID", "props": {"disabled": true}}, {"item": "parameters_mifare_settings.MIR.masterKey", "props": {"disabled": true}}]}}}}, "SIM": {"type": "object", "title": "##Смартфон (SIM-карта)##", "widget": "section", "dependencies": {"true": [{"item": "parameters_mifare_settings.command.write_key", "props": {"visible": false}}]}}, "bank_cards": {"type": "object", "title": "##Банковские карты##", "clientReader": true, "widget": "section", "dependencies": {"true": [{"item": "parameters_mifare_settings.command.write_key", "props": {"visible": false}}]}, "properties": {"ID_mode": {"enum": [1, 2, 4], "type": "string", "title": "##Используемый идентификатор##", "widget": "select", "clientReader": true, "default": 1, "enumNames": ["##PAN карты##", "ID mifare classic", "##ID приложения НСПК МИР##"]}}}, "command": {"type": "object", "title": "##Команды управления картами##", "widget": "commands", "properties": {"write_key": {"type": "object", "title": "##Изменить ключ##", "widget": "button", "command_type": "0", "command_number": "7"}, "formatting": {"type": "object", "title": "##Форматировать##", "widget": "button", "command_type": "0", "command_number": "10", "visible": false}, "get_card_info": {"type": "object", "title": "##Получить информацию о карте##", "widget": "button", "command_type": "1", "command_number": "1"}, "up_security_level_SL": {"type": "object", "title": "##Повысить уровень безопасности SL##", "widget": "button", "command_type": "0", "command_number": "8", "visible": false}, "write_config_to_memory": {"type": "object", "title": "##Запись конфигурации в память##", "widget": "button", "command_type": "1", "command_number": "51", "save_form": true, "dependencies": {"success": [{"item": "parameters_mifare_settings.general.next_lock_key_mstr", "props": {"isChange": {"item": "parameters_mifare_settings.general.lock_general", "value": true}}}, {"item": "parameters_mifare_settings.Classic_common.access_type", "props": {"isChange": {"item": "parameters_mifare_settings.Classic_common.lock_classic", "value": true}}}, {"item": "parameters_mifare_settings.Classic_common.key", "props": {"isChange": {"item": "parameters_mifare_settings.Classic_common.lock_classic", "value": true}}}, {"item": "parameters_mifare_settings.Ultralight_C_144_byte.access_key", "props": {"isChange": {"item": "parameters_mifare_settings.Ultralight_C_144_byte.lock_ultralight", "value": true}}}, {"item": "parameters_mifare_settings.Plus_common.access_type", "props": {"isChange": {"item": "parameters_mifare_settings.Plus_common.lock_access_key", "value": true}}}, {"item": "parameters_mifare_settings.Plus_common.key", "props": {"isChange": {"item": "parameters_mifare_settings.Plus_common.lock_access_key", "value": true}}}, {"item": "parameters_mifare_settings.Plus_common.aes_a_key", "props": {"isChange": {"item": "parameters_mifare_settings.Plus_common.lock_aes_a_key", "value": true}}}, {"item": "parameters_mifare_settings.Plus_common.aes_b_key", "props": {"isChange": {"item": "parameters_mifare_settings.Plus_common.lock_aes_b_key", "value": true}}}, {"item": "parameters_mifare_settings.Plus_common.mstr_key", "props": {"isChange": {"item": "parameters_mifare_settings.Plus_common.lock_mstr_key", "value": true}}}, {"item": "parameters_mifare_settings.Plus_common.config_key", "props": {"isChange": {"item": "parameters_mifare_settings.Plus_common.lock_config_key", "value": true}}}, {"item": "parameters_mifare_settings.Plus_common.keysl1_aes", "props": {"isChange": {"item": "parameters_mifare_settings.Plus_common.lock_keysl1_aes", "value": true}}}, {"item": "parameters_mifare_settings.Plus_common.switch_key3", "props": {"isChange": {"item": "parameters_mifare_settings.Plus_common.lock_switch_key3", "value": true}}}, {"item": "parameters_mifare_settings.DESFire.app_id", "props": {"isChange": {"item": "parameters_mifare_settings.DESFire.lock_desfire", "value": true}}}, {"item": "parameters_mifare_settings.DESFire.key_app_old", "props": {"sourceValue": {"source": "parameters_mifare_settings.DESFire.key_app"}}}, {"item": "parameters_mifare_settings.DESFire.app_id_old", "props": {"sourceValue": {"source": "parameters_mifare_settings.DESFire.app_id"}}}, {"item": "parameters_mifare_settings.DESFire.type_key_mstr_old", "props": {"sourceValue": {"source": "parameters_mifare_settings.DESFire.type_key_mstr"}}}, {"item": "parameters_mifare_settings.DESFire.key_mstr_old", "props": {"sourceValue": {"source": "parameters_mifare_settings.DESFire.key_mstr"}}}, {"item": "parameters_mifare_settings.DESFire.type_key_app_old", "props": {"sourceValue": {"source": "parameters_mifare_settings.DESFire.type_key_app"}}}, {"item": "parameters_mifare_settings.general.lock_key_mstr", "props": {"sourceValue": {"source": "parameters_mifare_settings.general.next_lock_key_mstr"}}}, {"item": "parameters_mifare_settings.Ultralight_C_144_byte.access_key_old", "props": {"sourceValue": {"source": "parameters_mifare_settings.Ultralight_C_144_byte.access_key"}}}, {"item": "parameters_mifare_settings.Classic_common.access_type_old", "props": {"sourceValue": {"source": "parameters_mifare_settings.Classic_common.access_type"}}}, {"item": "parameters_mifare_settings.Classic_common.key_old", "props": {"sourceValue": {"source": "parameters_mifare_settings.Classic_common.key"}}}, {"item": "parameters_mifare_settings.Plus_common.access_type_old", "props": {"sourceValue": {"source": "parameters_mifare_settings.Plus_common.access_type"}}}, {"item": "parameters_mifare_settings.Plus_common.key_old", "props": {"sourceValue": {"source": "parameters_mifare_settings.Plus_common.key"}}}, {"item": "parameters_mifare_settings.Plus_common.aes_a_key_old", "props": {"sourceValue": {"source": "parameters_mifare_settings.Plus_common.aes_a_key"}}}, {"item": "parameters_mifare_settings.Plus_common.aes_b_key_old", "props": {"sourceValue": {"source": "parameters_mifare_settings.Plus_common.aes_b_key"}}}]}}, "write_config_to_master-card": {"type": "object", "title": "##Запись конфигурации на мастер-карту##", "widget": "button", "command_type": "1", "command_number": "2", "dependencies": {"0": [{"item": "parameters_mifare_settings.Classic_common.lock_classic", "props": {"defined": false}}, {"item": "parameters_mifare_settings.general.lock_general", "props": {"defined": false}}, {"item": "parameters_mifare_settings.Ultralight_C_144_byte.lock_ultralight", "props": {"defined": false}}, {"item": "parameters_mifare_settings.Plus_common.lock_access_key", "props": {"defined": false}}, {"item": "parameters_mifare_settings.Plus_common.lock_aes_a_key", "props": {"defined": false}}, {"item": "parameters_mifare_settings.Plus_common.lock_aes_b_key", "props": {"defined": false}}, {"item": "parameters_mifare_settings.Plus_common.lock_mstr_key", "props": {"defined": false}}, {"item": "parameters_mifare_settings.Plus_common.lock_config_key", "props": {"defined": false}}, {"item": "parameters_mifare_settings.Plus_common.lock_keysl1_aes", "props": {"defined": false}}, {"item": "parameters_mifare_settings.Plus_common.lock_switch_key3", "props": {"defined": false}}, {"item": "parameters_mifare_settings.DESFire.lock_desfire", "props": {"defined": false}}], "1": [{"item": "parameters_mifare_settings.general.mstr_level", "props": {"add": 1}}, {"item": "parameters_mifare_settings.Classic_common.lock_classic", "props": {"defined": false}}, {"item": "parameters_mifare_settings.general.lock_general", "props": {"defined": false}}, {"item": "parameters_mifare_settings.Ultralight_C_144_byte.lock_ultralight", "props": {"defined": false}}, {"item": "parameters_mifare_settings.Plus_common.lock_access_key", "props": {"defined": false}}, {"item": "parameters_mifare_settings.Plus_common.lock_aes_a_key", "props": {"defined": false}}, {"item": "parameters_mifare_settings.Plus_common.lock_aes_b_key", "props": {"defined": false}}, {"item": "parameters_mifare_settings.Plus_common.lock_mstr_key", "props": {"defined": false}}, {"item": "parameters_mifare_settings.Plus_common.lock_config_key", "props": {"defined": false}}, {"item": "parameters_mifare_settings.Plus_common.lock_keysl1_aes", "props": {"defined": false}}, {"item": "parameters_mifare_settings.Plus_common.lock_switch_key3", "props": {"defined": false}}, {"item": "parameters_mifare_settings.DESFire.lock_desfire", "props": {"defined": false}}]}}}}}}
5	suprema_settings	\N	{"type":"object","title":"##Контроллеры Suprema##","widget":"section","properties":{"normal":{"type":"object","title":"##Норма##","widget":"section","properties":{"color":{"type":"object","title":"##Подсветка##","widget":"section","properties":{"counter":{"type":"string","title":"##Количество повторов##","default":"0","readonly":true},"infinite":{"type":"boolean","title":"##Бесконечно##","default":true,"readonly":true},"color_settings":{"type":"object","title":"##Цвета##","widget":"section","properties":{"color_1":{"type":"object","title":"##Первый цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":5,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"2000","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}},"color_2":{"type":"object","title":"##Второй цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":4,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"2000","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}},"color_3":{"type":"object","title":"##Третий цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":0,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}}}}}},"tone":{"type":"object","title":"##Звук##","widget":"section","properties":{"counter":{"type":"string","title":"##Количество повторов##","default":"0","readonly":true},"infinite":{"type":"boolean","title":"##Бесконечно##","default":true,"readonly":true},"tone_settings":{"type":"object","title":"##Тональности##","widget":"section","properties":{"tone_1":{"type":"object","title":"##Первый тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":0,"readonly":true,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","readonly":true},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","readonly":true},"fadeout":{"type":"boolean","title":"##Затухание##","default":false,"readonly":true}}},"tone_2":{"type":"object","title":"##Второй тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":0,"readonly":true,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","readonly":true},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","readonly":true},"fadeout":{"type":"boolean","title":"##Затухание##","default":false,"readonly":true}}},"tone_3":{"type":"object","title":"##Третий тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":0,"readonly":true,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","readonly":true},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","readonly":true},"fadeout":{"type":"boolean","title":"##Затухание##","default":false,"readonly":true}}}}}}}}},"locked":{"type":"object","title":"##Блокировка##","widget":"section","properties":{"color":{"type":"object","title":"##Подсветка##","widget":"section","properties":{"counter":{"type":"string","title":"##Количество повторов##","default":"0","validator":{"min":0,"max":9999,"minLength":1,"maxLength":4,"pattern":"number"}},"infinite":{"type":"boolean","title":"##Бесконечно##","default":true,"dependencies":{"true":[{"item":"parameters_suprema_settings.locked.color.counter","props":{"disabled":true}}]}},"color_settings":{"type":"object","title":"##Цвета##","widget":"section","properties":{"color_1":{"type":"object","title":"##Первый цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":1,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"2000","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}},"color_2":{"type":"object","title":"##Второй цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":6,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"2000","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}},"color_3":{"type":"object","title":"##Третий цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":0,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}}}}}},"tone":{"type":"object","title":"##Звук##","widget":"section","properties":{"counter":{"type":"string","title":"##Количество повторов##","default":"0","validator":{"min":0,"max":9999,"minLength":1,"maxLength":4,"pattern":"number"}},"infinite":{"type":"boolean","title":"##Бесконечно##","dependencies":{"true":[{"item":"parameters_suprema_settings.locked.tone.counter","props":{"disabled":true}}]},"default":false},"tone_settings":{"type":"object","title":"##Тональности##","widget":"section","properties":{"tone_1":{"type":"object","title":"##Первый тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":0,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":false}}},"tone_2":{"type":"object","title":"##Второй тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":0,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":false}}},"tone_3":{"type":"object","title":"##Третий тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":0,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":false}}}}}}}}},"rtc_error":{"type":"object","title":"##Ошибка RTC##","widget":"section","properties":{"color":{"type":"object","title":"##Подсветка##","widget":"section","properties":{"counter":{"type":"string","title":"##Количество повторов##","default":"0","validator":{"min":0,"max":9999,"minLength":1,"maxLength":4,"pattern":"number"}},"infinite":{"type":"boolean","title":"##Бесконечно##","default":true,"dependencies":{"true":[{"item":"parameters_suprema_settings.rtc_error.color.counter","props":{"disabled":true}}]}},"color_settings":{"type":"object","title":"##Цвета##","widget":"section","properties":{"color_1":{"type":"object","title":"##Первый цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":5,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"2000","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}},"color_2":{"type":"object","title":"##Второй цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":1,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"2000","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}},"color_3":{"type":"object","title":"##Третий цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":0,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}}}}}},"tone":{"type":"object","title":"##Звук##","widget":"section","properties":{"counter":{"type":"string","title":"##Количество повторов##","default":"0","validator":{"min":0,"max":9999,"minLength":1,"maxLength":4,"pattern":"number"}},"infinite":{"type":"boolean","title":"##Бесконечно##","default":false,"dependencies":{"true":[{"item":"parameters_suprema_settings.rtc_error.tone.counter","props":{"disabled":true}}]}},"tone_settings":{"type":"object","title":"##Тональности##","widget":"section","properties":{"tone_1":{"type":"object","title":"##Первый тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":0,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":false}}},"tone_2":{"type":"object","title":"##Второй тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":0,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":false}}},"tone_3":{"type":"object","title":"##Третий тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":0,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":false}}}}}}}}},"waiting_input":{"type":"object","title":"##Ожидание поднесения пальца##","widget":"section","properties":{"color":{"type":"object","title":"##Подсветка##","widget":"section","properties":{"counter":{"type":"string","title":"##Количество повторов##","default":"0","validator":{"min":0,"max":9999,"minLength":1,"maxLength":4,"pattern":"number"}},"infinite":{"type":"boolean","title":"##Бесконечно##","default":true,"dependencies":{"true":[{"item":"parameters_suprema_settings.waiting_input.color.counter","props":{"disabled":true}}]}},"color_settings":{"type":"object","title":"##Цвета##","widget":"section","properties":{"color_1":{"type":"object","title":"##Первый цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":2,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"250","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"250","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}},"color_2":{"type":"object","title":"##Второй цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":0,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}},"color_3":{"type":"object","title":"##Третий цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":0,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}}}}}},"tone":{"type":"object","title":"##Звук##","widget":"section","properties":{"counter":{"type":"string","title":"##Количество повторов##","default":"0","validator":{"min":0,"max":9999,"minLength":1,"maxLength":4,"pattern":"number"}},"infinite":{"type":"boolean","title":"##Бесконечно##","default":false,"dependencies":{"true":[{"item":"parameters_suprema_settings.waiting_input.tone.counter","props":{"disabled":true}}]}},"tone_settings":{"type":"object","title":"##Тональности##","widget":"section","properties":{"tone_1":{"type":"object","title":"##Первый тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":0,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":false}}},"tone_2":{"type":"object","title":"##Второй тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":0,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":false}}},"tone_3":{"type":"object","title":"##Третий тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":0,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":false}}}}}}}}},"waiting_dhcp":{"type":"object","title":"##Ожидание DHCP##","widget":"section","properties":{"color":{"type":"object","title":"##Подсветка##","widget":"section","properties":{"counter":{"type":"string","title":"##Количество повторов##","default":"0","validator":{"min":0,"max":9999,"minLength":1,"maxLength":4,"pattern":"number"}},"infinite":{"type":"boolean","title":"##Бесконечно##","default":true,"dependencies":{"true":[{"item":"parameters_suprema_settings.waiting_dhcp.color.counter","props":{"disabled":true}}]}},"color_settings":{"type":"object","title":"##Цвета##","widget":"section","properties":{"color_1":{"type":"object","title":"##Первый цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":2,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"1000","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}},"color_2":{"type":"object","title":"##Второй цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":5,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"1000","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}},"color_3":{"type":"object","title":"##Третий цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":0,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}}}}}},"tone":{"type":"object","title":"##Звук##","widget":"section","properties":{"counter":{"type":"string","title":"##Количество повторов##","default":"0","validator":{"min":0,"max":9999,"minLength":1,"maxLength":4,"pattern":"number"}},"infinite":{"type":"boolean","title":"##Бесконечно##","default":false,"dependencies":{"true":[{"item":"parameters_suprema_settings.waiting_dhcp.tone.counter","props":{"disabled":true}}]}},"tone_settings":{"type":"object","title":"##Тональности##","widget":"section","properties":{"tone_1":{"type":"object","title":"##Первый тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":0,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":false}}},"tone_2":{"type":"object","title":"##Второй тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":0,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":false}}},"tone_3":{"type":"object","title":"##Третий тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":0,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":false}}}}}}}}},"scan_finger":{"type":"object","title":"##Сканирование пальца##","widget":"section","properties":{"color":{"type":"object","title":"##Подсветка##","widget":"section","properties":{"counter":{"type":"string","title":"##Количество повторов##","default":"0","validator":{"min":0,"max":9999,"minLength":1,"maxLength":4,"pattern":"number"}},"infinite":{"type":"boolean","title":"##Бесконечно##","default":true,"dependencies":{"true":[{"item":"parameters_suprema_settings.scan_finger.color.counter","props":{"disabled":true}}]}},"color_settings":{"type":"object","title":"##Цвета##","widget":"section","properties":{"color_1":{"type":"object","title":"##Первый цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":6,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"2500","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}},"color_2":{"type":"object","title":"##Второй цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":0,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}},"color_3":{"type":"object","title":"##Третий цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":0,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}}}}}},"tone":{"type":"object","title":"##Звук##","widget":"section","properties":{"counter":{"type":"string","title":"##Количество повторов##","default":"1","validator":{"min":0,"max":9999,"minLength":1,"maxLength":4,"pattern":"number"}},"infinite":{"type":"boolean","title":"##Бесконечно##","default":false,"dependencies":{"true":[{"item":"parameters_suprema_settings.scan_finger.tone.counter","props":{"disabled":true}}]}},"tone_settings":{"type":"object","title":"##Тональности##","widget":"section","properties":{"tone_1":{"type":"object","title":"##Первый тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":3,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"100","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":false}}},"tone_2":{"type":"object","title":"##Второй тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":0,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":false}}},"tone_3":{"type":"object","title":"##Третий тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":0,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":false}}}}}}}}},"scan_card":{"type":"object","title":"##Сканирование карты##","widget":"section","properties":{"color":{"type":"object","title":"##Подсветка##","widget":"section","properties":{"counter":{"type":"string","title":"##Количество повторов##","default":"0","validator":{"min":0,"max":9999,"minLength":1,"maxLength":4,"pattern":"number"}},"infinite":{"type":"boolean","title":"##Бесконечно##","default":true,"dependencies":{"true":[{"item":"parameters_suprema_settings.scan_card.color.counter","props":{"disabled":true}}]}},"color_settings":{"type":"object","title":"##Цвета##","widget":"section","properties":{"color_1":{"type":"object","title":"##Первый цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":6,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"2500","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}},"color_2":{"type":"object","title":"##Второй цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":0,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}},"color_3":{"type":"object","title":"##Третий цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":0,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}}}}}},"tone":{"type":"object","title":"##Звук##","widget":"section","properties":{"counter":{"type":"string","title":"##Количество повторов##","default":"1","validator":{"min":0,"max":9999,"minLength":1,"maxLength":4,"pattern":"number"}},"infinite":{"type":"boolean","title":"##Бесконечно##","default":false,"dependencies":{"true":[{"item":"parameters_suprema_settings.scan_card.tone.counter","props":{"disabled":true}}]}},"tone_settings":{"type":"object","title":"##Тональности##","widget":"section","properties":{"tone_1":{"type":"object","title":"##Первый тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":3,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"100","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":false}}},"tone_2":{"type":"object","title":"##Второй тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":0,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":false}}},"tone_3":{"type":"object","title":"##Третий тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":0,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":false}}}}}}}}},"auth_success":{"type":"object","title":"##Идентификация успешна##","widget":"section","properties":{"color":{"type":"object","title":"##Подсветка##","widget":"section","properties":{"counter":{"type":"string","title":"##Количество повторов##","default":"1","validator":{"min":0,"max":9999,"minLength":1,"maxLength":4,"pattern":"number"}},"infinite":{"type":"boolean","title":"##Бесконечно##","default":false,"dependencies":{"true":[{"item":"parameters_suprema_settings.auth_success.color.counter","props":{"disabled":true}}]}},"color_settings":{"type":"object","title":"##Цвета##","widget":"section","properties":{"color_1":{"type":"object","title":"##Первый цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":3,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"1000","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"10","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}},"color_2":{"type":"object","title":"##Второй цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":0,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}},"color_3":{"type":"object","title":"##Третий цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":0,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}}}}}},"tone":{"type":"object","title":"##Звук##","widget":"section","properties":{"counter":{"type":"string","title":"##Количество повторов##","default":"1","validator":{"min":0,"max":9999,"minLength":1,"maxLength":4,"pattern":"number"}},"infinite":{"type":"boolean","title":"##Бесконечно##","default":false,"dependencies":{"true":[{"item":"parameters_suprema_settings.auth_success.tone.counter","props":{"disabled":true}}]}},"tone_settings":{"type":"object","title":"##Тональности##","widget":"section","properties":{"tone_1":{"type":"object","title":"##Первый тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":1,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"200","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":true}}},"tone_2":{"type":"object","title":"##Второй тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":2,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"200","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":true}}},"tone_3":{"type":"object","title":"##Третий тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":3,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"1000","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":true}}}}}}}}},"auth_fail":{"type":"object","title":"##Ошибка идентификации##","widget":"section","properties":{"color":{"type":"object","title":"##Подсветка##","widget":"section","properties":{"counter":{"type":"string","title":"##Количество повторов##","default":"1","validator":{"min":0,"max":9999,"minLength":1,"maxLength":4,"pattern":"number"}},"infinite":{"type":"boolean","title":"##Бесконечно##","default":false,"dependencies":{"true":[{"item":"parameters_suprema_settings.auth_fail.color.counter","props":{"disabled":true}}]}},"color_settings":{"type":"object","title":"##Цвета##","widget":"section","properties":{"color_1":{"type":"object","title":"##Первый цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":1,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"1000","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"10","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}},"color_2":{"type":"object","title":"##Второй цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":0,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}},"color_3":{"type":"object","title":"##Третий цвет##","properties":{"color":{"enum":[0,1,2,3,4,5,6,7],"type":"string","title":"##Цвет##","widget":"select","default":0,"enumNames":["##Выключен##","##Красный##","##Желтый##","##Зеленый##","##Голубой##","##Синий##","##Пурпурный##","##Белый##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"0","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}}}}}}}},"tone":{"type":"object","title":"##Звук##","widget":"section","properties":{"counter":{"type":"string","title":"##Количество повторов##","default":"1","validator":{"min":0,"max":9999,"minLength":1,"maxLength":4,"pattern":"number"}},"infinite":{"type":"boolean","title":"##Бесконечно##","default":false,"dependencies":{"true":[{"item":"parameters_suprema_settings.auth_fail.tone.counter","props":{"disabled":true}}]}},"tone_settings":{"type":"object","title":"##Тональности##","widget":"section","properties":{"tone_1":{"type":"object","title":"##Первый тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":3,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"100","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"2","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":false}}},"tone_2":{"type":"object","title":"##Второй тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":3,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"100","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"2","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":false}}},"tone_3":{"type":"object","title":"##Третий тон##","properties":{"tone":{"enum":[0,1,2,3],"type":"string","title":"##Тон##","widget":"select","default":3,"enumNames":["##Выключен##","##Низкий##","##Средний##","##Высокий##"]},"duration":{"type":"string","title":"##Длительность (мс)##","default":"100","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"delay":{"type":"string","title":"##Задержка (мс)##","default":"2","validator":{"min":0,"max":999999,"minLength":1,"maxLength":6,"pattern":"number"}},"fadeout":{"type":"boolean","title":"##Затухание##","default":false}}}}}}}}}}}
6	network	\N	{"type":"object","widget":"section","expandable":true,"title":"##Сеть##","properties":{"ip_address":{"type":"string","title":"##IP-адрес##","default":"","validator":{"pattern":"ip-address"}},"subnet_mask":{"type":"string","title":"##Маска подсети##","default":"","validator":{"pattern":"ip-address"}},"gateway":{"type":"string","title":"##IP-адрес шлюза##","default":"","validator":{"pattern":"ip-address"}},"mac_address":{"type":"string","title":"##MAC-адрес##","readonly":true,"default":""}}}
7	settings	\N	{"type": "object", "widget": "section", "title": "##Разное##", "properties": {"is_web_interface": {"type": "boolean", "title": "##Доступ к Web-интерфейсу##", "default": false}, "firmware_version": {"type": "string", "title": "##Версия прошивки##", "default": "", "readonly": true}, "time_zone": {"type": "string", "title": "##Коррекция времени относительно сервера системы (час)##", "default": "0", "validator": {"pattern": "number-neg-pos", "min": -12, "max": 12}}}}
8	hw_state	\N	{"type":"object","widget":"section","title":"##Состояние##","properties":{"plc_connect_state":{"type":"object","widget":"section","title":"##Состояние соединения с контроллером##","properties":{"state":{"type":"string","widget":"select","enum":[0,1,2,3,4],"enumNames":["##Не определено##","##Работает##","##Подключение##","##Нет связи##","##Ошибка пароля##"],"title":"##Состояние соединения с контроллером##","readonly":true},"state_error":{"type":"string","widget":"select","enum":[255,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,16,32,33,34,35,48,49,50,51,52,53,54,55,56,57,58,59,60,62,63,64,128],"enumNames":["##0xFF Команда ещё не выполнена или принудительно удалена из очереди сервером оборудования##","##0x00 Нет ошибки##","##0x01 Неверное семейство команды##","##0x02 Неверный тип команды##","##0x03 Неверный параметр команды##","##0x04 Неверный тип ресурса##","##0x05 Неверный номер ресурса##","##0x06 Переполнение при записи##","##0x07 Ошибка поллинга I2C##","##0x08 Ошибка I2C - нет ответа на передачу адреса##","##0x09 Ошибка I2C - нет ответа на передачу данных##","##0x0A Ошибка чтения таймера##","##0x0B Ошибка записи в DATAFLASH##","##0x0C Ошибка CRC в DATAFLASH##","##0x0D Ошибка занятости в DATAFLASH##","##0x0E Неисправность контроллера##","##0x10 Отклонение запроса на регистрацию вер-го/инд-го уст-ва##","##0x20 Ошибка передачи адреса##","##0x21 Ошибка передачи данных##","##0x22 Ошибка приёма данных##","##0x23 Неисправность линии##","##0x30 Ошибка управления - отсутствует конфигурация##","##0x31 Ошибка разблокировки, происходит обработка кода карты##","##0x32 Ошибка - датчик прохода в неопределённом состоянии##","##0x33 Ошибка - попытка установки РКД \\"Охрана\\"##","##0x34 Невалидная команда##","##0x35 Ошибка управления - несоответствие типа ресурса##","##0x36 Ошибка конфигурации - группа на охране или в тревоге##","##0x37 Ошибка конфигурации - ресурс на охране или в тревоге##","##0x38 Ошибка управления - ресурс на охране##","##0x39 Ошибка управления - ресурс ставиться охрану##","##0x3A Ошибка управления/конф-и - контроллер форматируется##","##0x3B Ошибка - отсутствие конф-и##","##0x3C Ошибка управления выходом оповещения - КЗ выхода##","##0x3E Ошибка конфигурации CL201##","##0x3F Ошибка батареи часов##","##0x40 Ошибка часов##","##0x80 Ошибка пароля##"],"title":"##Код возврата команды подключения##","readonly":true}}},"public_state":{"type":"object","widget":"section","title":"##Общее состояние##","properties":{"public_state1":{"type":"string","widget":"select","enum":[1,0],"enumNames":["##Да##","##Нет##"],"title":"##тихая тревога - ОПС##","readonly":true},"public_state2":{"type":"string","widget":"select","enum":[0,1],"enumNames":["##исправен##","##неисправен##"],"title":"##неисправность ИП##","readonly":true}}},"test_mode_settings":{"type":"object","widget":"section","title":"##Режим тестирования прибора##","properties":{"test_mode":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##рабочий (дежурный)##","##тестирования##","##тестирования ШС##","##форматирование памяти прибора##"],"title":"##Режим##","readonly":true}}},"apparat_state":{"type":"object","widget":"section","title":"##Аппаратное состояние##","properties":{"apparat_state_word":{"type":"string","widget":"select","enum":[0,1],"enumNames":["##Да##","##Нет##"],"title":"##исправность встроенного источника питания ШС 18 В##","readonly":true}}},"$$childAlarmsForState":"$$","output_state_notify":{"type":"object","widget":"section","title":"##Состояние выхода оповещения №1##","properties":{"output_state_notify1":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["##норма##","##КЗ##","##Обрыв##"],"title":"##Состояние выхода оповещения №1 (исправность / неисправность)##","readonly":true}}},"$$allOutputsState":"$$","$$allInputsState":"$$","shs1":{"type":"object","widget":"section","title":"##Состояние ШС (Шина Сигнализации) №1##","properties":{"shs1_state":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["##неопределено##","##резерв##","##охранный##"],"title":"##Тип шлейфа##","readonly":true}}},"shs2":{"type":"object","widget":"section","title":"##Состояние ШС (Шина Сигнализации) №2##","properties":{"shs2_state":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["##неопределено##","##резерв##","##охранный##"],"title":"##Тип шлейфа##","readonly":true}}},"sys_state_input":{"type":"object","widget":"section","title":"##Состояния служебных входов (конфигурационных перемычек)##","properties":{"sys_state_input_state":{"type":"object","widget":"container","title":"##для каждого бита значение 0 – низкий логический уровень на входе / 1 – высокий логический уровень на входе##","properties":{"ip_mode":{"type":"string","widget":"select","enum":[0,1],"enumNames":["##Низкий##","##высокий##"],"title":"##Перемычка IP_MODE##","readonly":true,"default":0},"ip_default":{"type":"string","widget":"select","enum":[0,1],"enumNames":["##Низкий##","##высокий##"],"title":"##Перемычка IP_DEFAULT##","readonly":true,"default":0},"xp3_1":{"type":"string","widget":"select","enum":[0,1],"enumNames":["##Низкий##","##высокий##"],"title":"##Перемычка XP 3.1##","readonly":true,"default":0},"xp3_2":{"type":"string","widget":"select","enum":[0,1],"enumNames":["##Низкий##","##высокий##"],"title":"##Перемычка XP 3.2##","readonly":true,"default":0},"xp3_3":{"type":"string","widget":"select","enum":[0,1],"enumNames":["##Низкий##","##высокий##"],"title":"##Перемычка XP 3.3##","readonly":true,"default":0}}}}}}}
9	lock_type_7	\N	{"parent_schema":"lock","properties":{"change_zone":{"type":"boolean","title":"##Смена зоны при проходе##","default":false},"fire_alarm_in_guard":{"type":"boolean","title":"##Fire Alarm в режиме работы \\"Охрана\\"##","default":false},"normal_direction":{"type":"boolean","title":"##Прямое направление прохода##","default":true,"visible":false}}}
10	output_type_12	\N	{"type":"object","widget":"section","title":"##Дополнительный вывод##","properties":{"command":{"type":"object","widget":"commands","title":"##Команды управления выходом##","properties":{"normalize":{"type":"object","command_type":"2","command_value":"0","widget":"button","title":"##Нормализовать##"},"activate":{"type":"object","command_type":"2","command_value":"1","widget":"button","title":"##Активизировать##","command_param":{"type":"object","widget":"combotime","title":"##Время активизации##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"select","props":{"visible":true}}],"1":[{"item":"input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}}}}},"type":{"type":"string","widget":"select","enum":[0,1,2,5,4],"enumNames":["##Нет##","##Обычный выход##","##Генератор тревоги##","##Вход Fire Alarm##","##Синхронизирующий вход/выход##"],"title":"##Тип##","default":0,"dependencies":{"1":[{"item":"$$selfLink$$.normal_state","props":{"visible":true}},{"item":"$$selfLink$$.command","props":{"visible":true}}],"2":[{"item":"$$selfLink$$.normal_state","props":{"visible":true}},{"item":"$$selfLink$$.program_time","props":{"visible":true}}],"5":[{"item":"$$selfLink$$.normal_state","props":{"visible":true}}]}},"normal_state":{"type":"string","widget":"select","title":"##Нормальное состояние##","enum":[0,1],"enumNames":["##Не запитан##","##Запитан##"],"default":0},"program_time":{"type":"object","widget":"combotime","title":"##Время активизации##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.program_time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.program_time.input","props":{"visible":true}}]}},"input":{"type":"string","default":"1","validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}}}}
11	reader_type_5	CL05	{"parent_schema":"reader","properties":{"staff_antipass":{"properties":{"guard_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Охрана\\"##","default":0}}},"time_control_staff":{"properties":{"guard_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Охрана\\"##","default":0}}},"outputs_activated_unlocking_iu":{"type":"section","title":"##Дополнительные выходы, активизируемые при разблокировке ИУ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"output1":{"type":"boolean","title":"##Дополнительный выход##","default":false}}}}},"outputs_normalize_unlocking_iu":{"type":"section","title":"##Дополнительные выходы, нормализируемые при разблокировке ИУ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"output1":{"type":"boolean","title":"##Дополнительный выход##","default":false}}}}},"outputs_activated_staff":{"type":"section","title":"##Дополнительные выходы, активизируемые при предъявлении валидных идентификаторов СОТРУДНИКОВ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_staff.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_activated_staff.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_activated_staff.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated_staff.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_staff.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_activated_staff.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"output1":{"type":"boolean","title":"##Дополнительный выход##","default":false}}}}},"outputs_activated_visitor":{"type":"section","title":"##Дополнительные выходы, активизируемые при предъявлении валидных идентификаторов ПОСЕТИТЕЛЕЙ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_visitor.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_activated_visitor.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_activated_visitor.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated_visitor.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","title":"","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_visitor.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_activated_visitor.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"output1":{"type":"boolean","title":"##Дополнительный выход##","default":false}}}}}}}
12	alarm_gen_type_7	\N	{"parent_schema":"alarm_gen"}
13	device_type_cl05	\N	{"0":{"is_hub":0,"resources":{"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"resources":{"alarm_gen":{"type":7},"lock":{"type":7},"output":{"1":{"type":12}},"reader":{"type":5}},"comission_card_count":192}}
14	device_type_cl05_0	\N	{"0":{"is_hub":0,"is_active":1,"resources":{"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"resources":{"alarm_gen":{"type":7},"lock":{"type":5},"output":{"1":{"type":11}},"reader":{"type":5}},"comission_card_count":192}}
15	lock_type_5	\N	{"parent_schema":"lock"}
16	output_type_11	\N	{"type":"object","widget":"section","title":"##Дополнительный выход##","properties":{"command_control":{"type":"object","widget":"commands","title":"##Команды управления выходом##","properties":{"normalize":{"type":"object","command_type":"2","command_value":"0","widget":"button","title":"##Нормализовать##"},"activate":{"type":"object","command_type":"2","command_value":"1","widget":"button","title":"##Активизировать##","command_param":{"type":"object","widget":"combotime","title":"##Время активизации##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"select","props":{"visible":true}}],"1":[{"item":"input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}}}}},"type":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["##Нет##","##Обычный выход##","##Генератор тревоги##"],"title":"##Тип##","default":0,"dependencies":{"1":[{"item":"$$selfLink$$.normal_state","props":{"visible":true}},{"item":"$$selfLink$$.command_control","props":{"visible":true}}],"2":[{"item":"$$selfLink$$.normal_state","props":{"visible":true}},{"item":"$$selfLink$$.program_time","props":{"visible":true}}]}},"normal_state":{"type":"string","widget":"select","title":"##Нормальное состояние##","enum":[0,1],"enumNames":["##Не запитан##","##Запитан##"],"default":0},"program_time":{"type":"object","widget":"combotime","title":"##Время активизации##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.program_time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.program_time.input","props":{"visible":true}}]}},"input":{"type":"string","default":"1","validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}}}}
18	licon_config	\N	{"type":"object","widget":"section","title":"##Свойства ЛИКОНА##","properties":{"normal_direction":{"type":"boolean","title":"##Прямое направление прохода##","default":true},"staff_antipass":{"title":"##Защита от передачи идентификаторов СОТРУДНИКОВ (Antipass)##","type":"string","widget":"select","enum":[2,0,1],"enumNames":["##Жёсткая##","##Нет##","##Мягкая##"],"default":0},"time_control_staff":{"title":"##Контроль времени для идентификаторов СОТРУДНИКОВ##","type":"string","widget":"select","enum":[2,0,1],"enumNames":["##Жёсткий##","##Нет##","##Мягкий##"],"default":0},"display_info_time":{"type":"object","widget":"combotime","title":"##Время показа информации о сотруднике (по умолчанию 2 сек)##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.display_info_time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.display_info_time.input","props":{"visible":true}}]}},"input":{"type":"string","default":2,"visible":false,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","visible":false,"enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"server_reply_time":{"type":"object","widget":"combotime","title":"##Время ожидания ответа на запрос от сервера системы (максимально 12 сек; по умолчанию 5 сек)##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.server_reply_time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.server_reply_time.input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"visible":false,"validator":{"pattern":"number","min":1,"max":12}},"select":{"type":"string","widget":"select","visible":false,"enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}}}}
19	licon_string_1	\N	{"type":"object","widget":"section","title":"##Строки##","properties":{"table":{"type":"object","widget":"table","properties":{"cols":{"number":"№","target":"##Назначение##","value":"##Строка##","default":"##Оригинал строки##"},"rows":[{"number":"1","target":"##«Вход»##","value":"##Вход##","default":"##Вход##","font":2},{"number":"2","target":"##«Выход»##","value":"##Выход##","default":"##Выход##","font":2},{"number":"3","target":"##1-я строка «Карты нет в списке»##","value":"##Карты##","default":"##Карты##","font":2},{"number":"4","target":"##2-я строка «Карты нет в списке»##","value":"##нет в списке##","default":"##нет в списке##","font":2},{"number":"5","target":"##«зарегистрирован повторно» для входа##","value":"##Вход повторно##","default":"##Вход повторно##","font":2},{"number":"6","target":"##«зарегистрирован повторно» для выхода##","value":"##Выход повторно##","default":"##Выход повторно##","font":2},{"number":"7","target":"##«нарушение зоны» для входа##","value":"##Нарушение зоны: вход##","default":"##Нарушение зоны: вход##","font":1},{"number":"8","target":"##«нарушение зоны» для выхода##","value":"##Нарушение зоны: выход##","default":"##Нарушение зоны: выход##","font":1},{"number":"9","target":"##строка направления прохода правая верхняя##","value":"##вход##","default":"##вход##","font":2},{"number":"10","target":"##строка направления прохода левая нижняя##","value":"##выход##","default":"##выход##","font":2},{"number":"11","target":"##1-я строка «Вход не зарегистрирован. Нарушение зоны»##","value":"##Вход##","default":"##Вход##","font":1},{"number":"12","target":"##2-я строка «Вход не зарегистрирован. Нарушение зоны»##","value":"##не зарегистрирован##","default":"##не зарегистрирован##","font":1},{"number":"13","target":"##3-я строка «Вход не зарегистрирован. Нарушение зоны»##","value":"##Нарушение зоны##","default":"##Нарушение зоны##","font":1},{"number":"14","target":"##1-я строка «Выход не зарегистрирован. Нарушение зоны»##","value":"##Выход##","default":"##Выход##","font":1},{"number":"15","target":"##2-я строка «Выход не зарегистрирован. Нарушение зоны»##","value":"##не зарегистрирован##","default":"##не зарегистрирован##","font":1},{"number":"16","target":"##3-я строка «Выход не зарегистрирован. Нарушение зоны»##","value":"##Нарушение зоны##","default":"##Нарушение зоны##","font":1},{"number":"17","target":"##1-я строка «Для регистрации выхода используйте считыватель \\"Выход\\"»##","value":"##Для регистрации##","default":"##Для регистрации##","font":1},{"number":"18","target":"##2-я строка «Для регистрации выхода используйте считыватель \\"Выход\\"»##","value":"##выхода используйте##","default":"##выхода используйте##","font":1},{"number":"19","target":"##3-я строка «Для регистрации выхода используйте считыватель \\"Выход\\"»##","value":"##считыватель##","default":"##считыватель##","font":1},{"number":"20","target":"##1-я строка «Для регистрации входа используйте считыватель \\"Вход\\"»##","value":"##Для регистрации##","default":"##Для регистрации##","font":1},{"number":"21","target":"##2-я строка «Для регистрации входа используйте считыватель \\"Вход\\"»##","value":"##входа используйте##","default":"##входа используйте##","font":1},{"number":"22","target":"##3-я строка «Для регистрации входа используйте считыватель \\"Вход\\"»##","value":"##считыватель##","default":"##считыватель##","font":1}]}}}}
20	device_type_17	\N	{"0":{"is_hub":0,"resources":{"network":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"resources":{"licon_config":{"type":1},"licon_string":{"type":1}},"comission_card_count":0}}
21	device_type_21	\N	{"0":{"is_hub":1,"resources":{"input":{"1":{"type":5},"2":{"type":5}},"output":{"1":{"type":7},"2":{"type":7},"3":{"type":7},"4":{"type":7}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"device_type":600,"comission_card_count":192},"3":{"device_type":401,"comission_card_count":64},"4":{"device_type":401,"comission_card_count":64},"5":{"device_type":401,"comission_card_count":64},"6":{"device_type":401,"comission_card_count":64},"7":{"device_type":401,"comission_card_count":64},"8":{"device_type":401,"comission_card_count":64},"9":{"device_type":401,"comission_card_count":64},"10":{"device_type":401,"comission_card_count":64}}
22	input_type_5	\N	{"type":"object","widget":"section","title":"##Дополнительный вход##","properties":{"type":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Нет##","##Обычный##","##Специальный##","Fire alarm"],"title":"##Тип##","default":0,"dependencies":{"1":[{"item":"$$selfLink$$.normal_state","props":{"visible":true}},{"item":"$$selfLink$$.inputs_masked","props":{"visible":true}},{"item":"$$selfLink$$.outputs_normalize","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated","props":{"visible":true}}],"2":[{"item":"$$selfLink$$.normal_state","props":{"visible":true}},{"item":"$$selfLink$$.alarm_gen_reset","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.normal_state","props":{"visible":true}}]}},"normal_state":{"type":"string","widget":"select","title":"##Нормальное состояние контакта##","enum":[0,1],"enumNames":["##Разомкнут##","##Замкнут##"],"default":0},"inputs_masked":{"type":"object","title":"##Дополнительные входы, маскируемые при активизации##","widget":"container","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий маскирования##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.inputs_masked.inputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.inputs_masked.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.inputs_masked.time","props":{"visible":true}},{"item":"$$selfLink$$.inputs_masked.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.inputs_masked.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.inputs_masked.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"inputs":{"type":"object","widget":"container","title":"","properties":{"$$allInputsWithoutSelf":"$$"}}}},"outputs_normalize":{"type":"object","title":"##Дополнительные выходы, нормализуемые при активизации##","widget":"container","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий нормализации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_normalize.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_normalize.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_normalize.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_normalize.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_normalize.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_normalize.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allOutputs":"$$"}}}},"outputs_activated":{"type":"object","title":"##Дополнительные выходы, активизируемые при активизации##","widget":"container","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_activated.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_activated.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_activated.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allOutputs":"$$"}}}},"alarm_gen_reset":{"type":"boolean","title":"##Сброс тревоги (Генератор тревоги)##","default":false}}}
23	output_type_7	\N	{"parent_schema":"output"}
24	device_type_604	\N	{"resources":{"lock":{"type":6},"reader":{"1":{"type":4},"2":{"type":4}},"alarm_gen":{"type":5}},"is_hub":0}
25	reader_type_4	1v замок	{"parent_schema":"reader","properties":{"staff_antipass":{"properties":{"guard_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Охрана\\"##","default":0}}},"time_control_staff":{"properties":{"guard_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Охрана\\"##","default":0}}},"inputs_masked_unlocking_iu":{"type":"section","title":"##Дополнительные входы, маскируемые при разблокировке ИУ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.inputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time","props":{"visible":true}},{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"inputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentInputs":"$$"}}}},"outputs_activated_unlocking_iu":{"type":"section","title":"##Дополнительные выходы, активизируемые при разблокировке ИУ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentOutputs":"$$"}}}},"outputs_normalize_unlocking_iu":{"type":"section","title":"##Дополнительные выходы, нормализируемые при разблокировке ИУ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentOutputs":"$$"}}}},"outputs_activated_staff":{"type":"section","title":"##Дополнительные выходы, активизируемые при предъявлении валидных идентификаторов СОТРУДНИКОВ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_staff.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_activated_staff.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_activated_staff.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated_staff.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_staff.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_activated_staff.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentOutputs":"$$"}}}},"outputs_activated_visitor":{"type":"section","title":"##Дополнительные выходы, активизируемые при предъявлении валидных идентификаторов ПОСЕТИТЕЛЕЙ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_visitor.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_activated_visitor.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_activated_visitor.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated_visitor.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_visitor.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_activated_visitor.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentOutputs":"$$"}}}}}}
26	lock_type_6	\N	{"parent_schema":"lock","properties":{"fire_alarm_in_guard":{"type":"boolean","title":"##Fire Alarm в режиме работы \\"Охрана\\"##","default":false},"normal_direction":{"type":"boolean","title":"##Прямое направление прохода##","default":true,"visible":false}}}
27	alarm_gen_type_5	\N	{"parent_schema":"alarm_gen","properties":{"intrusion_sensor":{"type":"object","widget":"section","title":"##Генерация тревоги по датчику вскрытия корпуса##","properties":{"intrusion_sensor":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["##Нет##","##Тихая##","##Громкая##"],"title":"##Генерация тревоги##","default":0}}}}}
28	device_type_600	\N	{"resources":{"lock":{"type":4},"reader":{"1":{"type":4},"2":{"type":4}},"alarm_gen":{"type":6}},"is_hub":0}
29	alarm_gen_type_6	\N	{"parent_schema":"alarm_gen"}
30	lock_type_4	\N	{"parent_schema":"lock"}
31	device_type_20	\N	{"0":{"is_hub":1,"resources":{"input":{"1":{"type":5},"2":{"type":5}},"output":{"1":{"type":7},"2":{"type":7},"3":{"type":7},"4":{"type":7}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"device_type":600,"comission_card_count":192}}
32	s30_cl15	\N	{"0":{"is_hub":0,"resources":{"network":{"type":1},"settings":{"type":2}}}}
33	s30_ctl14	\N	{"0":{"is_hub":1,"resources":{"network":{"type":1},"settings":{"type":2}}}}
34	s30_cr11	\N	{"0":{"is_hub":0,"resources":{"network":{"type":1},"settings":{"type":2}}}}
35	s30_child_device	\N	{"resources":{},"is_hub":0}
36	s30_ct13	\N	{"0":{"is_hub":1,"resources":{"network":{"type":1},"settings":{"type":2}}}}
39	s30_settings	\N	{"type": "object", "widget": "section", "title": "##Разное##", "properties": {"firmware_version": {"type": "string", "title": "##Версия прошивки##", "default": "", "readonly": true}, "time_zone": {"type": "string", "widget": "select", "title": "##Часовой пояс##", "enum": [255, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, -1, -2, -3, -4, -5, -6, -7, -8, -9, -10, -11, -12], "enumNames": ["##Часовой пояс сервера системы##", "GMT-12", "GMT-11", "GMT-10", "GMT-9", "GMT-8", "GMT-7", "GMT-6", "GMT-5", "GMT-4", "GMT-3", "GMT-2", "GMT-1", "GMT", "GMT+1", "GMT+2", "GMT+3", "GMT+4", "GMT+5", "GMT+6", "GMT+7", "GMT+8", "GMT+9", "GMT+10", "GMT+11", "GMT+12"], "default": 255}, "packet_mode": {"type": "boolean", "title": "##Быстрая передача данных##", "default": true}}}
40	camera_onvif	\N	{"0":{"is_hub":0,"resources":{"network":{"type":1},"camera":{"title":"##Тест##","is_tab":true,"_settings":{"type":2},"_about":{"type":1},"_video":{"type":3}}}}}
41	camera_about_onvif	\N	{"type":"object","widget":"section","title":"##О камере##","properties":{"camera_manufacturer":{"type":"string","title":"##Производитель##","default":"","readonly":true},"camera_model":{"type":"string","title":"##Модель##","default":"","readonly":true},"camera_firmware":{"type":"string","title":"##Прошивка##","default":"","readonly":true},"camera_serial_number":{"type":"string","title":"##Серийный номер##","default":"","readonly":true},"camera_uri":{"type":"string","title":"URI","default":"","readonly":true}}}
42	camera_settings	\N	{"type": "object", "widget": "section", "title": "##Камера##", "properties": {"login": {"type": "string", "title": "##Логин##", "default": ""}, "password": {"type": "password", "title": "##Пароль##", "default": ""}, "port": {"type": "string", "title": "##Порт## ONVIF", "default": "80"}}}
43	camera_video	\N	{"type":"object","widget":"section","title":"##Видео##","properties":{"camera_video":{"type":"object","widget":"camera"}}}
44	lock	\N	{"type":"object","widget":"section","title":"##Замок##","properties":{"command":{"type":"object","widget":"commands","title":"##Управление охранными зонами##","properties":{"guard_on":{"type":"object","command_type":"5","command_value":"1","command_number":"$$resourceNumber$$","widget":"button","title":"##Поставить на охрану##"},"guard_off":{"type":"object","command_type":"5","command_value":"0","command_number":"$$resourceNumber$$","widget":"button","title":"##Снять с охраны##"},"reset_alarm":{"type":"object","command_type":"4","command_value":"0","command_number":"$$resourceNumber$$","widget":"button","title":"##Снять тревогу##"},"clear_spatial_zones":{"type":"object","command_type":"6","command_value":"0","command_number":"$$resourceNumber$$","widget":"button","title":"##Сбросить зональность##"}}},"normal_state_contact_input_iu":{"type":"string","widget":"select","enum":[0,1],"enumNames":["##Нормально разомкнут##","##Нормально замкнут##"],"title":"##Нормальное (т.е. заблокированное) состояние контакта (вход ИУ)##","default":1},"normal_state_closed_exit_iu":{"type":"string","widget":"select","enum":[0,1],"enumNames":["##Не запитан##","##Запитан##"],"title":"##Нормальное состояние \\"Закрыто \\" выхода ИУ##","default":0},"normalization_iu_output":{"type":"string","widget":"select","enum":[0,1],"enumNames":["##После \\"Открытия\\"##","##После \\"Закрытия\\"##"],"title":"##Нормализация выхода ИУ##","default":0},"max_unblock_time":{"type":"object","widget":"combotime","title":"##Предельное время разблокировки##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.max_unblock_time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.max_unblock_time.input","props":{"visible":true}}]}},"input":{"type":"string","default":8,"visible":false,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","visible":false,"enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"hold_time":{"type":"object","widget":"combotime","title":"##Время удержания в разблокированном состоянии (время анализа идентификатора)##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.hold_time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.hold_time.input","props":{"visible":true}}]}},"input":{"type":"string","default":8,"visible":false,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","visible":false,"enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"comission_time":{"type":"object","widget":"combotime","title":"##Время ожидания комиссионирования##","properties":{"selector":{"type":"string","widget":"select","enum":[3,4],"enumNames":["##Секунды##","##Минуты##"],"default":3,"dependencies":{"3":[{"item":"$$selfLink$$.comission_time.select","props":{"visible":true}}],"4":[{"item":"$$selfLink$$.comission_time.input","props":{"visible":true}}]}},"select":{"type":"string","widget":"select","visible":false,"enum":[0,1,2],"enumNames":["15","30","45"],"default":1},"input":{"type":"string","default":1,"visible":false,"validator":{"pattern":"number","min":1,"max":12}}}},"check_pass_presentation_id":{"type":"boolean","title":"##Регистрация прохода по предъявлению идентификатора##","default":false},"is_antipass":{"type":"boolean","title":"##Внутренняя защита от передачи идентификаторов (Local Antipass)##","default":false},"operation_mode_control_output_iu":{"type":"string","widget":"select","enum":[1,0],"enumNames":["##Потенциальный##","##Импульсный##"],"title":"##Режим работы выхода управления ИУ##","default":1,"dependencies":{"0":[{"item":"$$selfLink$$.control_pulse_time","props":{"visible":true}}]}},"control_pulse_time":{"type":"string","widget":"select","title":"##Длительность импульса управления ИУ (миллисекунд)##","enum":[250,500,750],"enumNames":["250","500","750"],"default":500}}}
45	reader	1v parent	{"type":"object","widget":"section","title":"##Считыватель##","properties":{"command":{"type":"commands","title":"##Команды считывателя##","properties":{"set_mode_open":{"command_type":"0","command_value":"0","command_number":"$$resourceNumber$$","title":"##Установить режим работы \\"Открыто\\"##"},"set_mode_control":{"command_type":"0","command_value":"1","command_number":"$$resourceNumber$$","title":"##Установить режим работы \\"Контроль\\"##"},"set_mode_closed":{"command_type":"0","command_value":"3","command_number":"$$resourceNumber$$","title":"##Установить режим работы \\"Закрыто\\"##"},"open_iu":{"command_type":"1","command_value":"1","command_number":"$$resourceNumber$$","title":"##Открыть (разблокировать) ИУ##","command_param":{"type":"object","widget":"combotime","title":"##Время активизации##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"select","props":{"visible":true}}],"1":[{"item":"input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}}},"close_iu":{"command_type":"1","command_value":"0","command_number":"$$resourceNumber$$","title":"##Закрыть (заблокировать) ИУ##"}}},"staff_antipass":{"type":"object","widget":"section","title":"##Защита от передачи идентификаторов СОТРУДНИКОВ (Antipass)##","properties":{"control_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":0}}},"visitor_antipass":{"type":"section","title":"##Защита от передачи идентификаторов ПОСЕТИТЕЛЕЙ (Antipass)##","properties":{"control_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":0}}},"time_control_staff":{"type":"section","title":"##Контроль времени для идентификаторов СОТРУДНИКОВ##","properties":{"control_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":0}}},"time_control_visitors":{"type":"section","title":"##Контроль времени для идентификаторов ПОСЕТИТЕЛЕЙ##","properties":{"control_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":0}}},"confirmation_du":{"type":"object","widget":"section","title":"##Подтверждение от ДУ##","properties":{"control_mode":{"type":"string","widget":"select","enum":[0,1],"enumNames":["##Нет##","##Да##"],"title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":0,"dependencies":{"1":[{"item":"$$selfLink$$.confirmation_du.verify_staff_du","props":{"visible":true}},{"item":"$$selfLink$$.confirmation_du.verify_visitor_du","props":{"visible":true}}]}},"verify_staff_du":{"type":"object","widget":"container","title":"##Верифицировать идентификаторы СОТРУДНИКОВ##","properties":{"pass":{"type":"boolean","title":"##При проходе##","default":false},"time_violation":{"type":"boolean","title":"##При проходе с НАРУШЕНИЕМ ВРЕМЕНИ##","default":false},"place_violation":{"type":"boolean","title":"##При проходе с НАРУШЕНИЕМ ЗОНАЛЬНОСТИ##","default":false}}},"verify_visitor_du":{"type":"object","widget":"container","title":"##Верифицировать идентификаторы ПОСЕТИТЕЛЕЙ##","properties":{"pass":{"type":"boolean","title":"##При проходе##","default":false},"time_violation":{"type":"boolean","title":"##При проходе с НАРУШЕНИЕМ ВРЕМЕНИ##","default":false},"place_violation":{"type":"boolean","title":"##При проходе с НАРУШЕНИЕМ ЗОНАЛЬНОСТИ##","default":false}}},"confirm_time_du":{"type":"object","widget":"combotime","title":"##Время ожидания подтверждения при верификации##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.confirmation_du.confirm_time_du.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.confirmation_du.confirm_time_du.input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}}}},"permission_du":{"type":"object","widget":"section","expandable":true,"title":"##Разрешение ДУ##","properties":{"control_mode":{"type":"boolean","title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":true}}},"is_card_extract":{"type":"object","widget":"section","title":"##Изымать идентификаторы посетителей после прохода##","properties":{"extract":{"type":"boolean","title":"##Изымать идентификаторы посетителей после прохода##","default":false}}}}}
46	alarm_gen	\N	{"type":"object","widget":"section","title":"##Генератор тревоги##","properties":{"command":{"type":"object","widget":"commands","title":"##Команды управления тревогой СКУД##","properties":{"reset_alarm":{"type":"object","command_type":"3","command_value":"0","command_number":"$$resourceNumber$$","widget":"button","title":"##Сбросить тревогу##"},"raise_alarm":{"type":"object","command_type":"3","command_value":"1","command_number":"$$resourceNumber$$","widget":"button","title":"##Поднять тревогу##"}}},"key_present_alarm":{"type":"object","widget":"section","title":"##Генерация тревоги при предъявлении идентификатора##","properties":{"not_registered":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["##Нет##","##Тихая##","##Громкая##"],"title":"##Если ИДЕНТИФИКАТОР НЕ ЗАРЕГИСТРИРОВАН##","default":0},"prohibited":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["##Нет##","##Тихая##","##Громкая##"],"title":"##Если ИДЕНТИФИКАТОР ЗАПРЕЩЁН##","default":0},"expired":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["##Нет##","##Тихая##","##Громкая##"],"title":"##Если ИСТЁК СРОК ДЕЙСТВИЯ##","default":0},"break_time":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["##Нет##","##Тихая##","##Громкая##"],"title":"##Если НАРУШЕНО ВРЕМЯ##","default":0},"break_zone":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["##Нет##","##Тихая##","##Громкая##"],"title":"##Если НАРУШЕНА ЗОНАЛЬНОСТЬ##","default":0},"break_mode":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["##Нет##","##Тихая##","##Громкая##"],"title":"##Если НАРУШЕН РЕЖИМ РАБОТЫ##","default":0},"break_comission":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["##Нет##","##Тихая##","##Громкая##"],"title":"##Если НАРУШЕНО КОМИССИОНИРОВАНИЕ##","default":0}}},"unauthorized_unlocking_alarm":{"type":"object","widget":"section","title":"##Генерация тревоги при несанкционированной разблокировке ИУ##","properties":{"control_mode":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["##Нет##","##Тихая##","##Громкая##"],"title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":0},"close_mode":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["##Нет##","##Тихая##","##Громкая##"],"title":"##В РЕЖИМЕ РАБОТЫ \\"Закрыто\\"##","default":0}}},"long_open_door_alarm":{"type":"object","widget":"section","title":"##Генерация тревоги по недопустимо долгому открытию ИУ##","properties":{"mode":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["##Нет##","##Тихая##","##Громкая##"],"title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":0}}}}}
47	alarm_gen_type_1	\N	{"parent_schema":"alarm_gen"}
48	alarm_gen_type_2	\N	{"parent_schema":"alarm_gen"}
49	alarm_gen_type_3	\N	{"parent_schema":"alarm_gen","properties":{"intrusion_sensor":{"type":"object","widget":"section","title":"##Генерация тревоги по датчику вскрытия корпуса##","properties":{"intrusion_sensor":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["##Нет##","##Тихая##","##Громкая##"],"title":"##Генерация тревоги##","default":0}}}}}
50	alarm_gen_type_4	\N	{"parent_schema":"alarm_gen"}
51	lock_type_1	\N	{"type": "object", "widget": "section", "title": "##Турникет##", "properties": {"command": {"type": "object", "widget": "commands", "title": "##Управление ИУ##", "properties": {"clear_spatial_zones": {"type": "object", "command_type": "6", "command_value": "0", "command_number": "$$resourceNumber$$", "widget": "button", "title": "##Сбросить зональность##"}}}, "normal_state_contact_input_iu": {"type": "string", "widget": "select", "enum": [0, 1], "enumNames": ["##Нормально разомкнут##", "##Нормально замкнут##"], "title": "##Нормальное (т.е. заблокированное) состояние контакта (вход ИУ)##", "default": 1}, "normal_state_closed_exit_iu": {"type": "string", "widget": "select", "enum": [0, 1], "enumNames": ["##Не запитан##", "##Запитан##"], "title": "##Нормальное состояние \\"Закрыто \\" выхода ИУ##", "default": 0}, "normalization_iu_output": {"type": "string", "widget": "select", "enum": [0, 1], "enumNames": ["##После \\"Открытия\\"##", "##После \\"Закрытия\\"##"], "title": "##Нормализация выхода ИУ##", "default": 0}, "max_unblock_time": {"type": "object", "widget": "combotime", "title": "##Предельное время разблокировки##", "properties": {"selector": {"type": "select", "widget": "select", "enum": [0, 1, 2], "enumNames": ["##Миллисекунды##", "##Секунды##", "##Бесконечность##"], "default": 1, "dependencies": {"0": [{"item": "$$selfLink$$.max_unblock_time.select", "props": {"visible": true}}], "1": [{"item": "$$selfLink$$.max_unblock_time.input", "props": {"visible": true}}]}}, "input": {"type": "string", "default": 8, "visible": false, "validator": {"pattern": "number", "min": 1, "max": 251}}, "select": {"type": "string", "widget": "select", "visible": false, "enum": [0, 1, 2], "enumNames": ["250", "500", "750"], "default": 0}}}, "hold_time": {"type": "object", "widget": "combotime", "title": "##Время удержания в разблокированном состоянии (время анализа идентификатора)##", "properties": {"selector": {"type": "select", "widget": "select", "enum": [0, 1, 2], "enumNames": ["##Миллисекунды##", "##Секунды##", "##Бесконечность##"], "default": 1, "dependencies": {"0": [{"item": "$$selfLink$$.hold_time.select", "props": {"visible": true}}], "1": [{"item": "$$selfLink$$.hold_time.input", "props": {"visible": true}}]}}, "input": {"type": "string", "default": 8, "visible": false, "validator": {"pattern": "number", "min": 1, "max": 251}}, "select": {"type": "string", "widget": "select", "visible": false, "enum": [0, 1, 2], "enumNames": ["250", "500", "750"], "default": 0}}}, "comission_time": {"type": "object", "widget": "combotime", "title": "##Время ожидания комиссионирования##", "properties": {"selector": {"type": "string", "widget": "select", "enum": [3, 4], "enumNames": ["##Секунды##", "##Минуты##"], "default": 3, "dependencies": {"3": [{"item": "$$selfLink$$.comission_time.select", "props": {"visible": true}}], "4": [{"item": "$$selfLink$$.comission_time.input", "props": {"visible": true}}]}}, "select": {"type": "string", "widget": "select", "visible": false, "enum": [0, 1, 2], "enumNames": ["15", "30", "45"], "default": 1}, "input": {"type": "string", "default": 1, "visible": false, "validator": {"pattern": "number", "min": 1, "max": 12}}}}, "check_pass_presentation_id": {"type": "boolean", "title": "##Регистрация прохода по предъявлению идентификатора##", "default": false}, "is_antipass": {"type": "boolean", "title": "##Внутренняя защита от передачи идентификаторов (Local Antipass)##", "default": false}, "reverse_direction": {"type": "boolean", "title": "##Обратное направление прохода##", "default": false}}}
52	lock_type_2	\N	{"parent_schema":"lock"}
53	lock_type_3	\N	{"parent_schema":"lock"}
155	reader_zkteco	ZKTeco	{"type": "object", "widget": "section", "title": "##Считыватель##", "properties": {"info": {"type": "string", "title": "##Параметры считывателя настраиваются в терминале##", "default": "", "readonly": true}, "temperature_threshold": {"type": "string", "title": "##Сообщение при превышении температуры##", "default": "37.3"}}}
179	device_type_29	\N	{"0":{"is_hub":1,"resources":{"input":{"1":{"type":1},"2":{"type":1}},"output":{"3":{"type":1},"4":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"device_type":403,"commission_card_count":192}}
54	input	\N	{"type":"object","widget":"section","title":"##Дополнительный вход##","properties":{"type":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Нет##","##Обычный##","##Специальный##","Fire alarm"],"title":"##Тип##","default":0,"dependencies":{"1":[{"item":"$$selfLink$$.normal_state","props":{"visible":true}},{"item":"$$selfLink$$.inputs_masked","props":{"visible":true}},{"item":"$$selfLink$$.outputs_normalize","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated","props":{"visible":true}}],"2":[{"item":"$$selfLink$$.normal_state","props":{"visible":true}},{"item":"$$selfLink$$.alarm_gen_reset","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.normal_state","props":{"visible":true}}]}},"normal_state":{"type":"string","widget":"select","title":"##Нормальное состояние контакта##","enum":[0,1],"enumNames":["##Разомкнут##","##Замкнут##"],"default":0},"inputs_masked":{"type":"object","title":"##Дополнительные входы, маскируемые при активизации##","widget":"container","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий маскирования##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.inputs_masked.inputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.inputs_masked.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.inputs_masked.time","props":{"visible":true}},{"item":"$$selfLink$$.inputs_masked.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.inputs_masked.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.inputs_masked.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"inputs":{"type":"object","widget":"container","title":"","properties":{"$$allInputsWithoutSelf":"$$"}}}},"outputs_normalize":{"type":"object","title":"##Дополнительные выходы, нормализуемые при активизации##","widget":"container","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий нормализации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_normalize.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_normalize.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_normalize.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_normalize.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_normalize.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_normalize.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allOutputs":"$$"}}}},"outputs_activated":{"type":"object","title":"##Дополнительные выходы, активизируемые при активизации##","widget":"container","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_activated.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_activated.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_activated.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allOutputs":"$$"}}}},"alarm_gen_reset":{"type":"boolean","title":"##Сброс тревоги (Генератор тревоги)##","default":false}}}
55	output	\N	{"type":"object","widget":"section","title":"##Дополнительный выход##","properties":{"command":{"type":"object","widget":"commands","title":"##Команды управления выходом##","properties":{"normalize":{"type":"object","command_type":"2","command_value":"0","command_number":"$$resourceNumber$$","widget":"button","title":"##Нормализовать##"},"activate":{"type":"object","command_type":"2","command_value":"1","command_number":"$$resourceNumber$$","widget":"button","title":"##Активизировать##","command_param":{"type":"object","widget":"combotime","title":"##Время активизации##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"select","props":{"visible":true}}],"1":[{"item":"input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}}}}},"type":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["##Нет##","##Обычный##","##Генератор тревоги##"],"title":"##Тип##","default":0,"dependencies":{"1":[{"item":"$$selfLink$$.command","props":{"visible":true}},{"item":"$$selfLink$$.normal_state","props":{"visible":true}},{"item":"$$inputs:all$$.outputs_normalize.outputs.$$selfNumber$$","props":{"visible":true}},{"item":"$$inputs:all$$.outputs_activated.outputs.$$selfNumber$$","props":{"visible":true}}],"2":[{"item":"$$selfLink$$.normal_state","props":{"visible":true}},{"item":"$$selfLink$$.program_time","props":{"visible":true}}]}},"normal_state":{"type":"string","widget":"select","title":"##Нормальное состояние##","enum":[0,1],"enumNames":["##Не запитан##","##Запитан##"],"default":0},"program_time":{"type":"object","widget":"combotime","title":"##Время активизации##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.program_time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.program_time.input","props":{"visible":true}}]}},"input":{"type":"string","default":"1","validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}}}}
56	reader_type_1	1v турникет	{"parent_schema":"reader","properties":{"inputs_masked_unlocking_iu":{"type":"section","title":"##Дополнительные входы, маскируемые при разблокировке ИУ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.inputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time","props":{"visible":true}},{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"inputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentInputs":"$$"}}}},"outputs_activated_unlocking_iu":{"type":"section","title":"##Дополнительные выходы, активизируемые при разблокировке ИУ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentOutputs":"$$"}}}},"outputs_normalize_unlocking_iu":{"type":"section","title":"##Дополнительные выходы, нормализируемые при разблокировке ИУ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentOutputs":"$$"}}}},"outputs_activated_staff":{"type":"section","title":"##Дополнительные выходы, активизируемые при предъявлении валидных идентификаторов СОТРУДНИКОВ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_staff.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_activated_staff.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_activated_staff.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated_staff.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_staff.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_activated_staff.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentOutputs":"$$"}}}},"outputs_activated_visitor":{"type":"section","title":"##Дополнительные выходы, активизируемые при предъявлении валидных идентификаторов ПОСЕТИТЕЛЕЙ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_visitor.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_activated_visitor.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_activated_visitor.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated_visitor.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_visitor.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_activated_visitor.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentOutputs":"$$"}}}}}}
57	input_type_1	\N	{"parent_schema":"input"}
58	output_type_1	\N	{"parent_schema":"output"}
59	device_type_18	\N	{"0":{"is_hub":1,"resources":{"input":{"1":{"type":1},"2":{"type":1}},"output":{"3":{"type":1},"4":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"device_type":400,"commission_card_count":192}}
60	device_type_400	\N	{"resources":{"lock":{"type":1},"reader":{"1":{"type":1},"2":{"type":1}},"alarm_gen":{"type":1}}}
61	device_type_401	\N	{"resources":{"lock":{"type":3},"reader":{"type":4},"alarm_gen":{"type":2}}}
62	device_type_19	\N	{"0":{"is_hub":1,"resources":{"input":{"1":{"type":1},"2":{"type":1}},"output":{"3":{"type":1},"4":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"device_type":400,"comission_card_count":192},"3":{"device_type":401,"comission_card_count":64},"4":{"device_type":401,"comission_card_count":64},"5":{"device_type":401,"comission_card_count":64},"6":{"device_type":401,"comission_card_count":64},"7":{"device_type":401,"comission_card_count":64},"8":{"device_type":401,"comission_card_count":64},"9":{"device_type":401,"comission_card_count":64},"10":{"device_type":401,"comission_card_count":64}}
63	device_type_22	\N	{"0":{"is_hub":1,"resources":{"input":{"1":{"type":5},"2":{"type":5}},"output":{"1":{"type":7},"2":{"type":7},"3":{"type":7},"4":{"type":7}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"device_type":700,"comission_card":192},"2":{"device_type":700,"comission_card":192},"3":{"device_type":401,"comission_card":64},"4":{"device_type":401,"comission_card":64},"5":{"device_type":401,"comission_card":64},"6":{"device_type":401,"comission_card":64},"7":{"device_type":401,"comission_card":64},"8":{"device_type":401,"comission_card":64},"9":{"device_type":401,"comission_card":64},"10":{"device_type":401,"comission_card":64}}
64	device_type_700	\N	{"resources":{"reader":{"type":4},"lock":{"type":3},"alarm_gen":{"type":3}}}
65	input_type_6	\N	{"type":"object","widget":"section","title":"$$optionsName$$","link":"$$selfLink$$","properties":{"type":{"type":"string","widget":"select","enum":[1,2,3,4,5,6,7,8],"enumNames":["##Обычный##","##Кнопка ПДУ - выход##","##Кнопка ПДУ - стоп##","##Сигнал прохода##","##Вход Fire alarm##","##Вход подтверждения ВВУ##","##Вход запрета ВВУ##","##Вход сброса тревоги##"],"title":"##Тип##","default":1,"dependencies":{"1":[{"item":"$$selfLink$$.controller","props":{"visible":false}},{"item":"$$selfLink$$.direction","props":{"visible":false}}],"3":[{"item":"$$selfLink$$.direction","props":{"visible":false}}],"5":"use 1","8":"use 3"}},"controller":{"type":"string","widget":"select","title":"##Контроллер##","$$childControllersSelector$$":"$$","default":"1"},"direction":{"type":"string","widget":"select","title":"##Направление##","enum":[],"enumNames":[],"default":"1"},"normal_state":{"type":"string","widget":"select","title":"##Нормальное состояние контакта##","enum":[0,1],"enumNames":["##Разомкнут##","##Замкнут##"],"default":0}}}
66	output_type_13	\N	{"type":"object","widget":"section","title":"$$optionsName$$","link":"$$selfLink$$","properties":{"command":{"type":"object","widget":"commands","title":"##Команды управления выходом##","properties":{"normalize":{"type":"object","command_type":"2","command_value":"0","command_number":"$$resourceNumber$$","widget":"button","title":"##Нормализовать##"},"activate":{"type":"object","command_type":"2","command_value":"1","command_number":"$$resourceNumber$$","widget":"button","title":"##Активизировать##","command_param":{"type":"object","widget":"combotime","title":"##Время активизации##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"select","props":{"visible":true}}],"1":[{"item":"input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}}}}},"type":{"type":"string","widget":"select","enum":[1,2,3],"enumNames":["##Обычный##","##Выход управления ИУ##","##Выход индикации ПДУ##"],"title":"##Тип##","default":1,"dependencies":{"1":[{"item":"$$selfLink$$.controller","props":{"visible":false}},{"item":"$$selfLink$$.direction","props":{"visible":false}},{"item":"$$selfLink$$.command","props":{"visible":true}}]}},"controller":{"type":"string","widget":"select","title":"##Контроллер##","default":"$$optionsHardNumbers$$","$$childControllersSelector$$":"$$"},"direction":{"type":"string","widget":"select","title":"##Направление##","enum":[],"enumNames":[],"default":"$$optionsDir$$"},"normal_state":{"type":"string","widget":"select","title":"##Нормальное состояние##","enum":[0,1],"enumNames":["##Не запитан##","##Запитан##"],"default":0}}}
67	lock_type_9	\N	{"type": "object", "widget": "section", "title": "##ИУ##", "properties": {"command": {"type": "object", "widget": "commands", "title": "##Управление охранными зонами##", "properties": {"guard_on": {"type": "object", "command_type": "5", "command_value": "1", "command_number": "$$resourceNumber$$", "widget": "button", "title": "##Поставить на охрану##"}, "guard_off": {"type": "object", "command_type": "5", "command_value": "0", "command_number": "$$resourceNumber$$", "widget": "button", "title": "##Снять с охраны##"}, "reset_alarm": {"type": "object", "command_type": "4", "command_value": "0", "command_number": "$$resourceNumber$$", "widget": "button", "title": "##Снять тревогу##"}, "clear_spatial_zones": {"type": "object", "command_type": "6", "command_value": "0", "command_number": "$$resourceNumber$$", "widget": "button", "title": "##Сбросить зональность##"}}}, "algorithm": {"type": "string", "widget": "select", "title": "##Алгоритм##", "enum": [1, 2, 3, 4], "enumNames": ["##Замок##", "##Турникет##", "##АТП##", "##Шлюз##"], "default": 1, "dependencies": {"3": [{"item": "$$selfLink$$.barrier_close_delay_time", "props": {"visible": true}}]}}, "check_pass_presentation_id": {"type": "boolean", "title": "##Регистрация прохода по предъявлению идентификатора##", "default": false}, "hold_time": {"type": "object", "widget": "combotime", "title": "##Время удержания в разблокированном состоянии (время анализа идентификатора)##", "properties": {"selector": {"type": "select", "widget": "select", "enum": [1, 2], "enumNames": ["##Секунды##", "##Бесконечность##"], "default": 1, "dependencies": {"1": [{"item": "$$selfLink$$.hold_time.input", "props": {"visible": true}}]}}, "input": {"type": "string", "default": 8, "visible": false, "validator": {"pattern": "number", "min": 1, "max": 251}}}}, "max_unblock_time": {"type": "object", "widget": "combotime", "title": "##Предельное время разблокировки##", "properties": {"selector": {"type": "select", "widget": "select", "enum": [0, 1, 2], "enumNames": ["##Миллисекунды##", "##Секунды##", "##Бесконечность##"], "default": 1, "dependencies": {"0": [{"item": "$$selfLink$$.max_unblock_time.select", "props": {"visible": true}}], "1": [{"item": "$$selfLink$$.max_unblock_time.input", "props": {"visible": true}}]}}, "input": {"type": "string", "default": 8, "visible": false, "validator": {"pattern": "number", "min": 1, "max": 251}}, "select": {"type": "string", "widget": "select", "visible": false, "enum": [0, 1, 2], "enumNames": ["250", "500", "750"], "default": 0}}}, "operation_mode_control_output_iu": {"type": "string", "widget": "select", "enum": [1, 0], "enumNames": ["##Потенциальный##", "##Импульсный##"], "title": "##Режим работы выхода управления ИУ##", "default": 1, "dependencies": {"0": [{"item": "$$selfLink$$.control_pulse_time", "props": {"visible": true}}]}}, "control_pulse_time": {"type": "string", "widget": "select", "title": "##Длительность импульса управления ИУ (миллисекунд)##", "enum": [250, 500, 750], "enumNames": ["250", "500", "750"], "default": 500}, "normalization_iu_output": {"type": "string", "widget": "select", "enum": [0, 1], "enumNames": ["##После \\"Открытия\\"##", "##После \\"Закрытия\\"##"], "title": "##Нормализация выхода ИУ##", "default": 0}, "barrier_close_delay_time": {"type": "object", "widget": "combotime", "title": "##Задержка на закрытие шлагбаума##", "visible": false, "properties": {"selector": {"type": "select", "widget": "select", "enum": [0, 1], "enumNames": ["##Миллисекунды##", "##Секунды##"], "default": 0, "dependencies": {"0": [{"item": "$$selfLink$$.barrier_close_delay_time.select", "props": {"visible": true}}], "1": [{"item": "$$selfLink$$.barrier_close_delay_time.input", "props": {"visible": true}}]}}, "input": {"type": "string", "default": 1, "visible": false, "validator": {"pattern": "number", "min": 1, "max": 251}}, "select": {"type": "string", "widget": "select", "visible": false, "enum": [0, 1, 2], "enumNames": ["250", "500", "750"], "default": 0}}}, "fire_alarm_reaction": {"type": "string", "widget": "select", "title": "##Реакция на Fire alarm в режиме работы \\"Охрана\\"##", "enum": [0, 1], "enumNames": ["##Блокировать ИУ##", "##Разблокировать ИУ##"], "default": 1}, "guard_identify_time": {"type": "object", "widget": "combotime", "title": "##Время идентификации постановки/снятия РКД \\"Охрана\\"##", "properties": {"selector": {"type": "select", "widget": "select", "enum": [1, 2], "enumNames": ["##Секунды##", "##Бесконечность##"], "default": 1, "dependencies": {"1": [{"item": "$$selfLink$$.guard_identify_time.input", "props": {"visible": true}}]}}, "input": {"type": "string", "default": 8, "visible": false, "validator": {"pattern": "number", "min": 1, "max": 251}}}}, "is_antipass": {"type": "boolean", "title": "##Внутренняя защита от передачи идентификаторов (Local Antipass)##", "default": false}, "reverse_direction": {"type": "boolean", "title": "##Обратное направление прохода##", "default": false}}}
68	direction_type_1	\N	{"type":"object","widget":"section","title":"##Направление##","properties":{"command":{"type":"commands","title":"##Команды считывателя##","properties":{"set_mode_open":{"command_type":"0","command_value":"0","command_direction":"$$directionNumber$$","command_number":"$$resourceNumber$$","title":"##Установить режим работы \\"Открыто\\"##"},"set_mode_control":{"command_type":"0","command_value":"1","command_direction":"$$directionNumber$$","command_number":"$$resourceNumber$$","title":"##Установить режим работы \\"Контроль\\"##"},"set_mode_closed":{"command_type":"0","command_value":"3","command_direction":"$$directionNumber$$","command_number":"$$resourceNumber$$","title":"##Установить режим работы \\"Закрыто\\"##"},"open_iu":{"command_type":"1","command_value":"1","command_direction":"$$directionNumber$$","command_number":"$$resourceNumber$$","title":"##Открыть (разблокировать) ИУ##","command_param":{"type":"object","widget":"combotime","title":"##Время активизации##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"select","props":{"visible":true}}],"1":[{"item":"input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}}},"close_iu":{"command_type":"1","command_value":"0","command_direction":"$$directionNumber$$","command_number":"$$resourceNumber$$","title":"##Закрыть (заблокировать) ИУ##"}}},"staff_antipass":{"type":"object","widget":"section","title":"##Защита от передачи идентификаторов СОТРУДНИКОВ (Antipass)##","properties":{"open_mode":{"type":"string","widget":"select","title":"##В РЕЖИМЕ РАБОТЫ \\"Открыто\\"##","enum":[0,1],"enumNames":["##Нет##","##Да##"],"default":0},"control_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":0},"guard_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Охрана\\"##","default":0}}},"visitor_antipass":{"type":"section","title":"##Защита от передачи идентификаторов ПОСЕТИТЕЛЕЙ (Antipass)##","properties":{"control_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":0}}},"time_control_staff":{"type":"section","title":"##Контроль времени для идентификаторов СОТРУДНИКОВ##","properties":{"open_mode":{"type":"string","widget":"select","title":"##В РЕЖИМЕ РАБОТЫ \\"Открыто\\"##","enum":[0,1],"enumNames":["##Нет##","##Да##"],"default":0},"control_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":0},"guard_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Охрана\\"##","default":0}}},"time_control_visitors":{"type":"section","title":"##Контроль времени для идентификаторов ПОСЕТИТЕЛЕЙ##","properties":{"control_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":0}}},"verification":{"type":"section","title":"##Верификация##","properties":{"level":{"type":"section","title":"##Уровни##","properties":{"l1":{"type":"object","widget":"container","title":"##Уровень 1##","properties":{"soft":{"type":"boolean","title":"##Софт##","default":false},"soft_if_connect":{"type":"boolean","title":"##Софт, если подключен##","default":false},"pdu":{"type":"boolean","title":"##ПДУ##","default":false},"vvu":{"type":"boolean","title":"##ВВУ##","default":false},"pdu_random":{"type":"boolean","title":"##ПДУ выборочно##","default":false},"vvu_random":{"type":"boolean","title":"##ВВУ выборочно##","default":false},"pass_counter":{"type":"boolean","title":"##Счетчик проходов##","default":false}}},"l2":{"type":"object","widget":"container","title":"##Уровень 2##","properties":{"soft":{"type":"boolean","title":"##Софт##","default":false},"soft_if_connect":{"type":"boolean","title":"##Софт, если подключен##","default":false},"pdu":{"type":"boolean","title":"##ПДУ##","default":false},"vvu":{"type":"boolean","title":"##ВВУ##","default":false},"pdu_random":{"type":"boolean","title":"##ПДУ выборочно##","default":false},"vvu_random":{"type":"boolean","title":"##ВВУ выборочно##","default":false},"pass_counter":{"type":"boolean","title":"##Счетчик проходов##","default":false}}},"l3":{"type":"object","widget":"container","title":"##Уровень 3##","properties":{"soft":{"type":"boolean","title":"##Софт##","default":false},"soft_if_connect":{"type":"boolean","title":"##Софт, если подключен##","default":false},"pdu":{"type":"boolean","title":"##ПДУ##","default":false},"vvu":{"type":"boolean","title":"##ВВУ##","default":false},"pdu_random":{"type":"boolean","title":"##ПДУ выборочно##","default":false},"vvu_random":{"type":"boolean","title":"##ВВУ выборочно##","default":false},"pass_counter":{"type":"boolean","title":"##Счетчик проходов##","default":false}}},"l4":{"type":"object","widget":"container","title":"##Уровень 4##","properties":{"soft":{"type":"boolean","title":"##Софт##","default":false},"soft_if_connect":{"type":"boolean","title":"##Софт, если подключен##","default":false},"pdu":{"type":"boolean","title":"##ПДУ##","default":false},"vvu":{"type":"boolean","title":"##ВВУ##","default":false},"pdu_random":{"type":"boolean","title":"##ПДУ выборочно##","default":false},"vvu_random":{"type":"boolean","title":"##ВВУ выборочно##","default":false},"pass_counter":{"type":"boolean","title":"##Счетчик проходов##","default":false}}}}},"soft":{"type":"section","title":"##Софт##","properties":{"wait_time":{"type":"object","widget":"combotime","title":"##Время ожидания подтверждения##","properties":{"selector":{"type":"select","widget":"select","enum":[1,2],"enumNames":["##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"1":[{"item":"$$selfLink$$.verification.soft.wait_time.input","props":{"visible":true}}]}},"input":{"type":"string","default":8,"visible":false,"validator":{"pattern":"number","min":1,"max":251}}}}}},"pdu":{"type":"section","title":"##ПДУ##","properties":{"pass":{"type":"object","widget":"container","title":"##Подтверждение прохода##","properties":{"staff":{"type":"boolean","title":"##При проходе СОТРУДНИКОВ##","default":false},"staff_time_violation":{"type":"boolean","title":"##При проходе СОТРУДНИКОВ с НАРУШЕНИЕМ ВРЕМЕНИ##","default":false},"staff_place_violation":{"type":"boolean","title":"##При проходе СОТРУДНИКОВ c НАРУШЕНИЕМ ЗОНАЛЬНОСТИ##","default":false},"visitor":{"type":"boolean","title":"##При проходе ПОСЕТИТЕЛЕЙ##","default":false},"visitor_time_violation":{"type":"boolean","title":"##При проходе ПОСЕТИТЕЛЕЙ с НАРУШЕНИЕМ ВРЕМЕНИ##","default":false},"visitor_place_violation":{"type":"boolean","title":"##При проходе ПОСЕТИТЕЛЕЙ с НАРУШЕНИЕМ ЗОНАЛЬНОСТИ##","default":false}}},"visitor_pass_confirm":{"type":"string","widget":"select","title":"##Подтверждение прохода для ПОСЕТИТЕЛЕЙ##","enum":[0,1],"enumNames":["##Постоянно##","##В последний день действия идентификатора##"],"default":0},"wait_time":{"type":"object","widget":"combotime","title":"##Время ожидания подтверждения##","properties":{"selector":{"type":"select","widget":"select","enum":[1,2],"enumNames":["##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"1":[{"item":"$$selfLink$$.verification.pdu.wait_time.input","props":{"visible":true}}]}},"input":{"type":"string","default":8,"visible":false,"validator":{"pattern":"number","min":1,"max":251}}}},"random":{"type":"string","title":"##Вероятность запуска верификации## (0..100%)","validator":{"minLength":1,"min":0,"max":100,"pattern":"number"},"default":"0"}}},"vvu":{"type":"section","title":"##ВВУ##","properties":{"pass":{"type":"object","widget":"container","title":"##Подтверждение прохода##","properties":{"staff":{"type":"boolean","title":"##При проходе СОТРУДНИКОВ##","default":false},"staff_time_violation":{"type":"boolean","title":"##При проходе СОТРУДНИКОВ с НАРУШЕНИЕМ ВРЕМЕНИ##","default":false},"staff_place_violation":{"type":"boolean","title":"##При проходе СОТРУДНИКОВ c НАРУШЕНИЕМ ЗОНАЛЬНОСТИ##","default":false},"visitor":{"type":"boolean","title":"##При проходе ПОСЕТИТЕЛЕЙ##","default":false},"visitor_time_violation":{"type":"boolean","title":"##При проходе ПОСЕТИТЕЛЕЙ с НАРУШЕНИЕМ ВРЕМЕНИ##","default":false},"visitor_place_violation":{"type":"boolean","title":"##При проходе ПОСЕТИТЕЛЕЙ с НАРУШЕНИЕМ ЗОНАЛЬНОСТИ##","default":false}}},"visitor_pass_confirm":{"type":"string","widget":"select","title":"##Подтверждение прохода для ПОСЕТИТЕЛЕЙ##","enum":[0,1],"enumNames":["##Постоянно##","##В последний день действия идентификатора##"],"default":0},"wait_time":{"type":"object","widget":"combotime","title":"##Время ожидания подтверждения##","properties":{"selector":{"type":"select","widget":"select","enum":[1,2],"enumNames":["##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"1":[{"item":"$$selfLink$$.verification.vvu.wait_time.input","props":{"visible":true}}]}},"input":{"type":"string","default":8,"visible":false,"validator":{"pattern":"number","min":1,"max":251}}}},"no_response":{"type":"string","widget":"select","title":"##По истечению времени подтверждения генерировать событие##","enum":[0,1],"enumNames":["##Запрет прохода от ВВУ##","##Отказ от прохода, нет ответа от ВВУ##"],"default":0},"random":{"type":"string","title":"##Вероятность запуска верификации## (0..100%)","validator":{"minLength":1,"min":0,"max":100,"pattern":"number"},"default":"0"}}},"pass_counter":{"type":"section","title":"##Счётчик##","properties":{"wait_time":{"type":"object","widget":"combotime","title":"##Время ожидания подтверждения##","properties":{"selector":{"type":"select","widget":"select","enum":[1,2],"enumNames":["##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"1":[{"item":"$$selfLink$$.verification.pass_counter.wait_time.input","props":{"visible":true}}]}},"input":{"type":"string","default":8,"visible":false,"validator":{"pattern":"number","min":1,"max":251}}}}}}}},"commission":{"type":"section","title":"##Комиссионирование##","properties":{"wait_confirm_time":{"type":"object","widget":"combotime","title":"##Время ожидания##","properties":{"selector":{"type":"select","widget":"select","enum":[1,2],"enumNames":["##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"1":[{"item":"$$selfLink$$.commission.wait_confirm_time.input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"visible":false,"validator":{"pattern":"number","min":1,"max":251}}}},"confirm_identify_time":{"type":"object","widget":"combotime","title":"##Время идентификации##","properties":{"selector":{"type":"select","widget":"select","enum":[1,2],"enumNames":["##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"1":[{"item":"$$selfLink$$.commission.confirm_identify_time.input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"visible":false,"validator":{"pattern":"number","min":1,"max":251}}}}}},"card_extract":{"type":"object","widget":"section","title":"##Изымать идентификаторы ПОСЕТИТЕЛЕЙ##","properties":{"extract":{"type":"select","title":"##Изымать идентификаторы ПОСЕТИТЕЛЕЙ##","enum":[0,1,2],"enumNames":["##Нет##","##После любого прохода##","##После прохода в последний день действия идентификатора##"],"default":0}}},"card_storage":{"type":"object","widget":"section","title":"##Поддержка картоприемника для идентификаторов ПОСЕТИТЕЛЕЙ##","properties":{"is_enable":{"type":"select","title":"##Поддержка картоприемника для идентификаторов ПОСЕТИТЕЛЕЙ##","enum":[0,1],"enumNames":["##Нет##","##Да##"],"default":0,"dependencies":{"1":[{"item":"$$selfLink$$.card_storage.output","props":{"visible":true}}]}},"output":{"type":"string","widget":"select","title":"##Номер выхода##","default":"1","$$allOutputsSelector":"$$"}}}}}
78	direction_type_2	\N	{"type":"object","widget":"section","title":"##Направление##","properties":{"staff_antipass":{"type":"boolean","title":"##Защита от передачи идентификаторов СОТРУДНИКОВ (Antipass)##","default":false},"visitor_antipass":{"type":"boolean","title":"##Защита от передачи идентификаторов ПОСЕТИТЕЛЕЙ (Antipass)##","default":false},"time_control_staff":{"type":"boolean","title":"##Контроль времени для идентификаторов СОТРУДНИКОВ##","default":false},"time_control_visitors":{"type":"boolean","title":"##Контроль времени для идентификаторов ПОСЕТИТЕЛЕЙ##","default":false},"identification_time":{"type":"object","widget":"combotime","title":"##Время идентификации##","properties":{"selector":{"type":"select","widget":"select","enum":[1,2],"enumNames":["##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"1":[{"item":"$$selfLink$$.identification_time.input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"visible":false,"validator":{"pattern":"number","min":1,"max":251}}}}}}
79	lock_type_10	licon s30	{"type":"object","widget":"section","title":"##Свойства##","properties":{"is_antipass":{"type":"boolean","title":"##Внутренняя защита от передачи идентификаторов (Local Antipass)##","default":false},"personalization_time":{"type":"object","widget":"combotime","title":"##Время ожидания персонализации от сервера##","properties":{"selector":{"type":"select","widget":"select","enum":[1,2],"enumNames":["##Секунды##","##Бесконечность##"],"default":1,"visible":false},"input":{"type":"string","default":5,"visible":true,"validator":{"pattern":"number","min":1,"max":251}}}},"visible_time":{"type":"object","widget":"combotime","title":"##Время отображения информации на дисплее##","properties":{"selector":{"type":"select","widget":"select","enum":[1,2],"enumNames":["##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"1":[{"item":"$$selfLink$$.visible_time.input","props":{"visible":true}}]}},"input":{"type":"string","default":3,"visible":false,"validator":{"pattern":"number","min":1,"max":251}}}},"time_zone_in":{"type":"string","widget":"select","title":"##Временная зона входа##","$$timeZoneSelector":"$$"},"time_zone_out":{"type":"string","widget":"select","title":"##Временная зона выхода##","$$timeZoneSelector":"$$"}}}
80	alarm_gen_type_8	\N	{"type":"object","widget":"section","title":"##Генератор тревоги##","properties":{"command":{"type":"object","widget":"commands","title":"##Команды управления тревогой СКУД##","properties":{"reset_alarm":{"type":"object","command_type":"3","command_value":"0","command_number":"$$resourceNumber$$","widget":"button","title":"##Сбросить тревогу##"},"raise_alarm":{"type":"object","command_type":"3","command_value":"1","command_number":"$$resourceNumber$$","widget":"button","title":"##Поднять тревогу##"}}},"key_present_alarm":{"type":"object","widget":"section","title":"##Генерация тревоги при предъявлении идентификатора##","properties":{"not_registered":{"type":"boolean","title":"##Если ИДЕНТИФИКАТОР НЕ ЗАРЕГИСТРИРОВАН##","default":false},"prohibited":{"type":"boolean","title":"##Если ИДЕНТИФИКАТОР ЗАПРЕЩЁН##","default":false},"expired":{"type":"boolean","title":"##Если ИСТЁК СРОК ДЕЙСТВИЯ##","default":false},"break_time":{"type":"boolean","title":"##Если НАРУШЕНО ВРЕМЯ##","default":false},"break_zone":{"type":"boolean","title":"##Если НАРУШЕНА ЗОНАЛЬНОСТЬ##","default":false},"break_mode":{"type":"boolean","title":"##Если НАРУШЕН РЕЖИМ РАБОТЫ##","default":false},"break_comission":{"type":"boolean","title":"##Если НАРУШЕНО КОМИССИОНИРОВАНИЕ##","default":false}}},"unauthorized_unlocking_alarm":{"type":"object","widget":"section","title":"##Генерация тревоги при несанкционированной разблокировке ИУ##","properties":{"control_mode":{"type":"boolean","title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":false},"close_mode":{"type":"boolean","title":"##В РЕЖИМЕ РАБОТЫ \\"Закрыто\\"##","default":false}}},"long_open_door_alarm":{"type":"object","widget":"section","title":"##Генерация тревоги по недопустимо долгому открытию ИУ##","properties":{"on":{"type":"boolean","title":"##Включена##","default":false}}}}}
82	gateway_type_2	\N	{"type":"object","widget":"section","title":"##Шлюз##","link":"$$selfLink$$","properties":{"settings":{"type":"object","widget":"section","title":"##Настройки##","properties":{"algorithm":{"type":"string","widget":"select","title":"##Алгоритм прохода##","enum":[1,2],"enumNames":["##Мягкий##","##Жесткий##"],"default":1},"time":{"type":"string","title":"##Время нахождения в шлюзе##","validator":{"minLength":1,"min":1,"max":1000,"pattern":"number"},"default":100}}},"in1":{"type":"object","widget":"section","title":"##Дверь## 1 - ##вход в шлюз##","properties":{"controller":{"type":"number","widget":"select","title":"##Контроллер##","validator":{"required":true},"$$selectCL15controller":"$$"},"access_mode":{"type":"string","widget":"select","title":"##Режим доступа##","enum":[1,2,3],"enumNames":["##По считывателю##","##ПО ДУ##","##По считывателю и ДУ##"],"default":1}}},"out1":{"type":"object","widget":"section","title":"##Дверь## 1 - ##выход из шлюза##","properties":{"controller":{"type":"number","widget":"select","title":"##Контроллер##","validator":{"required":true},"$$selectCL15controller":"$$"},"access_mode":{"type":"string","widget":"select","title":"##Режим доступа##","enum":[1,2,3],"enumNames":["##По считывателю##","##ПО ДУ##","##По считывателю и ДУ##"],"default":1}}},"out2":{"type":"object","widget":"section","title":"##Дверь## 2 - ##выход из шлюза##","properties":{"controller":{"type":"number","widget":"select","title":"##Контроллер##","validator":{"required":true},"$$selectCL15controller":"$$"},"access_mode":{"type":"string","widget":"select","title":"##Режим доступа##","enum":[1,2,3],"enumNames":["##По считывателю##","##ПО ДУ##","##По считывателю и ДУ##"],"default":1}}},"in2":{"type":"object","widget":"section","title":"##Дверь## 2 - ##вход в шлюз##","properties":{"controller":{"type":"number","widget":"select","title":"##Контроллер##","validator":{"required":true},"$$selectCL15controller":"$$"},"access_mode":{"type":"string","widget":"select","title":"##Режим доступа##","enum":[1,2,3],"enumNames":["##По считывателю##","##ПО ДУ##","##По считывателю и ДУ##"],"default":1}}}}}
83	gateway_type_1	\N	{"type":"object","widget":"section","title":"##Шлюз##","link":"$$selfLink$$","properties":{"settings":{"type":"object","widget":"section","title":"##Настройки##","properties":{"algorithm":{"type":"string","widget":"select","title":"##Алгоритм прохода##","enum":[1,2],"enumNames":["##Мягкий##","##Жесткий##"],"default":1},"time":{"type":"string","title":"##Время нахождения в шлюзе##","validator":{"minLength":1,"min":1,"max":1000,"pattern":"number"},"default":100}}},"in1":{"type":"object","widget":"section","title":"##Дверь## 1 - ##вход в шлюз##","properties":{"controller":{"type":"string","widget":"select","title":"##Контроллер##","htmlClass":"flat_select_large","validator":{"required":true},"$$selectCTL14controller":"$$"},"access_mode":{"type":"string","widget":"select","title":"##Режим доступа##","enum":[1,2,3],"enumNames":["##По считывателю##","##ПО ДУ##","##По считывателю и ДУ##"],"default":1}}},"out1":{"type":"object","widget":"section","title":"##Дверь## 1 - ##выход из шлюза##","properties":{"controller":{"type":"string","widget":"select","title":"##Контроллер##","htmlClass":"flat_select_large","validator":{"required":true},"$$selectCTL14controller":"$$"},"access_mode":{"type":"string","widget":"select","title":"##Режим доступа##","enum":[1,2,3],"enumNames":["##По считывателю##","##ПО ДУ##","##По считывателю и ДУ##"],"default":1}}},"out2":{"type":"object","widget":"section","title":"##Дверь## 2 - ##выход из шлюза##","properties":{"controller":{"type":"string","widget":"select","title":"##Контроллер##","htmlClass":"flat_select_large","validator":{"required":true},"$$selectCTL14controller":"$$"},"access_mode":{"type":"string","widget":"select","title":"##Режим доступа##","enum":[1,2,3],"enumNames":["##По считывателю##","##ПО ДУ##","##По считывателю и ДУ##"],"default":1}}},"in2":{"type":"object","widget":"section","title":"##Дверь## 2 - ##вход в шлюз##","properties":{"controller":{"type":"string","widget":"select","title":"##Контроллер##","htmlClass":"flat_select_large","validator":{"required":true},"$$selectCTL14controller":"$$"},"access_mode":{"type":"string","widget":"select","title":"##Режим доступа##","enum":[1,2,3],"enumNames":["##По считывателю##","##ПО ДУ##","##По считывателю и ДУ##"],"default":1}}}}}
89	suprema	\N	{"0":{"is_hub":0,"resources":{"network":{"type":1},"settings":{"type":2}}},"1":{"resources":{"lock":{"type":8},"reader":{"type":7}}}}
97	device_type_68	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"4":{"type":7},"6":{"type":7}},"output":{"4":{"type":1},"5":{"type":1},"6":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":603,"comission_card_count":192},"3":{"is_active":1,"device_type":602,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
90	lock_suprema	\N	{"type": "object", "widget": "section", "title": "##Замок##", "properties": {"is_enable": {"type": "boolean", "title": "##Управление замком##", "visible": true, "default": true, "dependencies": {"false": [{"item": "$$selfLink$$.door_sensor", "props": {"visible": false}}, {"item": "$$selfLink$$.exit_button", "props": {"visible": false}}, {"item": "$$selfLink$$.door_sensor_input", "props": {"visible": false}}, {"item": "$$selfLink$$.exit_button_input", "props": {"visible": false}}, {"item": "$$selfLink$$.max_unblock_time", "props": {"visible": false}}, {"item": "$$selfLink$$.block_after_close", "props": {"visible": false}}, {"item": "$$selfLink$$.hold_time", "props": {"visible": false}}, {"item": "$$selfLink$$.check_pass_presentation_id", "props": {"visible": false}}]}}, "door_sensor": {"type": "select", "title": "##Датчик двери##", "enum": [1, 2], "enumNames": ["##Нормально замкнут##", "##Нормально разомкнут##"], "default": 1}, "exit_button": {"type": "select", "title": "##Кнопка \\"Выход\\"##", "enum": [1, 2], "enumNames": ["##Нормально замкнута##", "##Нормально разомкнута##"], "default": 1}, "door_sensor_input": {"type": "select", "title": "##Вход датчика двери##", "enum": [0, 1], "enumNames": ["##Вход 0##", "##Вход 1##"], "default": 0}, "exit_button_input": {"type": "select", "title": "##Вход кнопки \\"Выход\\"##", "enum": [0, 1], "enumNames": ["##Вход 0##", "##Вход 1##"], "default": 1}, "max_unblock_time": {"type": "object", "widget": "combotime", "title": "##Предельное время открытия двери##", "properties": {"selector": {"type": "select", "widget": "select", "enum": [0, 1, 2], "enumNames": ["##Миллисекунды##", "##Секунды##", "##Бесконечность##"], "default": 1, "dependencies": {"0": [{"item": "$$selfLink$$.max_unblock_time.select", "props": {"visible": true}}], "1": [{"item": "$$selfLink$$.max_unblock_time.input", "props": {"visible": true}}]}}, "input": {"type": "string", "default": 8, "visible": false, "validator": {"pattern": "number", "min": 1, "max": 251}}, "select": {"type": "string", "widget": "select", "visible": false, "enum": [0, 1, 2], "enumNames": ["250", "500", "750"], "default": 0}}}, "block_after_close": {"type": "boolean", "title": "##Блокировать дверь после закрытия##", "default": false}, "hold_time": {"type": "object", "widget": "combotime", "title": "##Время открытия двери##", "properties": {"selector": {"type": "select", "widget": "select", "enum": [0, 1, 2], "enumNames": ["##Миллисекунды##", "##Секунды##", "##Бесконечность##"], "default": 1, "dependencies": {"0": [{"item": "$$selfLink$$.hold_time.select", "props": {"visible": true}}], "1": [{"item": "$$selfLink$$.hold_time.input", "props": {"visible": true}}]}}, "input": {"type": "string", "default": 4, "visible": false, "validator": {"pattern": "number", "min": 1, "max": 251}}, "select": {"type": "string", "widget": "select", "visible": false, "enum": [0, 1, 2], "enumNames": ["250", "500", "750"], "default": 0}}}, "check_pass_presentation_id": {"type": "boolean", "title": "##Регистрация прохода по предъявлению идентификатора##", "default": false}, "controller_pdu": {"type": "string", "widget": "select", "title": "##Подтверждение прохода от контроллера##", "$$selectPDUcontroller": "$$"}}}
91	reader_suprema	\N	{"type":"object","widget":"section","title":"##Считыватель##","properties":{"command":{"type":"commands","title":"##Команды считывателя##","properties":{"set_mode_open":{"command_type":"0","command_value":"0","command_number":"$$resourceNumber$$","title":"##Установить режим работы \\"Открыто\\"##"},"set_mode_control":{"command_type":"0","command_value":"1","command_number":"$$resourceNumber$$","title":"##Установить режим работы \\"Контроль\\"##"},"set_mode_closed":{"command_type":"0","command_value":"3","command_number":"$$resourceNumber$$","title":"##Установить режим работы \\"Закрыто\\"##"}}},"sensitivity":{"type":"select","title":"##Чувствительность##","enum":[0,1,2,3,4,5,6,7],"enumNames":["##Низкая##","##Уровень 1##","##Уровень 2##","##Уровень 3##","##Уровень 4##","##Уровень 5##","##Уровень 6##","##Высокая##"],"default":0},"wiegand_mode":{"type":"select","title":"##Режим Wiegand##","enum":[0,1],"enumNames":["##Вход##","##Выход##"],"default":0,"dependencies":{"1":[{"item":"$$selfLink$$.wiegand_auth","props":{"visible":true}}]}},"wiegand_auth":{"title":"##Использовать аутентификацию##","type":"boolean","visible":false,"default":true},"ident_byte_order":{"enum":[0,1],"type":"string","title":"##Порядок байт в идентификаторе##","widget":"select","default":0,"enumNames":["##От старшего к младшему##","##От младшему к старшему##"]}}}
92	reader_type_10	2v турникет	{"parent_schema":"reader2","properties":{"inputs_masked_unlocking_iu":{"type":"section","title":"##Дополнительные входы, маскируемые при разблокировке ИУ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.inputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time","props":{"visible":true}},{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"inputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentInputs":"$$"}}}},"outputs_activated_unlocking_iu":{"type":"section","title":"##Дополнительные выходы, активизируемые при разблокировке ИУ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentOutputs":"$$"}}}},"outputs_normalize_unlocking_iu":{"type":"section","title":"##Дополнительные выходы, нормализируемые при разблокировке ИУ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentOutputs":"$$"}}}},"outputs_activated_staff":{"type":"section","title":"##Дополнительные выходы, активизируемые при предъявлении валидных идентификаторов СОТРУДНИКОВ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_staff.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_activated_staff.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_activated_staff.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated_staff.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_staff.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_activated_staff.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentOutputs":"$$"}}}},"outputs_activated_visitor":{"type":"section","title":"##Дополнительные выходы, активизируемые при предъявлении валидных идентификаторов ПОСЕТИТЕЛЕЙ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_visitor.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_activated_visitor.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_activated_visitor.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated_visitor.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_visitor.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_activated_visitor.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentOutputs":"$$"}}}}}}
93	reader_type_9	2v замок	{"parent_schema":"reader2","properties":{"staff_antipass":{"properties":{"protection_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Охрана\\"##","default":0}}},"time_control_staff":{"properties":{"protection_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Охрана\\"##","default":0}}},"inputs_masked_unlocking_iu":{"type":"section","title":"##Дополнительные входы, маскируемые при разблокировке ИУ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.inputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time","props":{"visible":true}},{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"inputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentInputs":"$$"}}}},"outputs_activated_unlocking_iu":{"type":"section","title":"##Дополнительные выходы, активизируемые при разблокировке ИУ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentOutputs":"$$"}}}},"outputs_normalize_unlocking_iu":{"type":"section","title":"##Дополнительные выходы, нормализируемые при разблокировке ИУ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentOutputs":"$$"}}}},"outputs_activated_staff":{"type":"section","title":"##Дополнительные выходы, активизируемые при предъявлении валидных идентификаторов СОТРУДНИКОВ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_staff.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_activated_staff.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_activated_staff.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated_staff.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_staff.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_activated_staff.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentOutputs":"$$"}}}},"outputs_activated_visitor":{"type":"section","title":"##Дополнительные выходы, активизируемые при предъявлении валидных идентификаторов ПОСЕТИТЕЛЕЙ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_staff.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_activated_staff.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_activated_staff.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated_staff.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_visitor.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_activated_visitor.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentOutputs":"$$"}}}}}}
94	input_type_7	\N	{"type":"section","title":"##Дополнительный вход##","properties":{"type":{"type":"string","widget":"select","enum":[0,1,2,3,4,5],"enumNames":["##Нет##","##Обычный##","##Специальный##","Fire alarm","##Подтверждение от ВВУ##","##Запрет от ВВУ##"],"title":"##Тип##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.normal_state","props":{"visible":false}}],"1":[{"item":"$$selfLink$$.inputs_masked","props":{"visible":true}},{"item":"$$selfLink$$.outputs_normalize","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated","props":{"visible":true}}],"2":[{"item":"$$selfLink$$.alarm_gen_reset","props":{"visible":true}}],"4":[{"item":"$$selfLink$$.iu_number","props":{"visible":true}}],"5":"use 4"}},"normal_state":{"type":"string","widget":"select","title":"##Нормальное состояние контакта##","enum":[0,1],"enumNames":["##Разомкнут##","##Замкнут##"],"default":0},"inputs_masked":{"type":"object","title":"##Дополнительные входы, маскируемые при активизации##","widget":"container","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий маскирования##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.inputs_masked.inputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.inputs_masked.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.inputs_masked.time","props":{"visible":true}},{"item":"$$selfLink$$.inputs_masked.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.inputs_masked.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.inputs_masked.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"inputs":{"type":"object","widget":"container","title":"","properties":{"$$allInputsWithoutSelf":"$$"}}}},"outputs_normalize":{"type":"object","title":"##Дополнительные выходы, нормализуемые при активизации##","widget":"container","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий нормализации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_normalize.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_normalize.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_normalize.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_normalize.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_normalize.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_normalize.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allOutputs":"$$"}}}},"outputs_activated":{"type":"object","title":"##Дополнительные выходы, активизируемые при активизации##","widget":"container","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_activated.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_activated.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_activated.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allOutputs":"$$"}}}},"alarm_gen_reset":{"type":"boolean","title":"##Сброс тревоги (Генератор тревоги)##","default":false},"iu_number":{"type":"select","title":"##Номер ИУ##","$$ChildIuSelector":"$$","default":1}}}
95	device_type_603	\N	{"resources":{"lock":{"type":1},"reader":{"1":{"type":10},"2":{"type":10}},"alarm_gen":{"type":1}}}
96	device_type_67	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"3":{"type":7},"4":{"type":7},"5":{"type":7},"6":{"type":7}},"output":{"3":{"type":1},"4":{"type":1},"5":{"type":1},"6":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":603,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
98	device_type_602	\N	{"resources":{"lock":{"type":3},"reader":{"type":9},"alarm_gen":{"type":3}}}
99	device_type_70	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"4":{"type":7},"6":{"type":7}},"output":{"4":{"type":1},"5":{"type":1},"6":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":603,"comission_card_count":192},"3":{"is_active":1,"device_type":601,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
100	device_type_601	\N	{"resources":{"lock":{"type":6},"reader":{"1":{"type":9},"2":{"type":9}},"alarm_gen":{"type":5}},"is_active":1,"is_hub":0}
101	device_type_69	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"output":{"5":{"type":1},"6":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":603,"comission_card_count":192},"3":{"is_active":1,"device_type":602,"comission_card_count":192},"4":{"is_active":1,"device_type":602,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
102	device_type_76	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"2":{"type":7},"3":{"type":7},"4":{"type":7},"8":{"type":7},"9":{"type":7}},"output":{"2":{"type":1},"3":{"type":1},"4":{"type":1},"5":{"type":1},"6":{"type":1},"7":{"type":1},"8":{"type":1},"9":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":602,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
103	device_type_77	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"2":{"type":7},"3":{"type":7},"4":{"type":7},"5":{"type":7},"8":{"type":7},"9":{"type":7}},"output":{"2":{"type":1},"3":{"type":1},"4":{"type":1},"5":{"type":1},"6":{"type":1},"7":{"type":1},"8":{"type":1},"9":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":602,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
104	device_type_78	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"2":{"type":7},"3":{"type":7},"4":{"type":7},"5":{"type":7},"6":{"type":7},"8":{"type":7},"9":{"type":7}},"output":{"2":{"type":1},"3":{"type":1},"4":{"type":1},"5":{"type":1},"6":{"type":1},"7":{"type":1},"8":{"type":1},"9":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":602,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
105	device_type_79	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"3":{"type":7},"4":{"type":7},"8":{"type":7},"9":{"type":7}},"output":{"3":{"type":1},"4":{"type":1},"5":{"type":1},"6":{"type":1},"7":{"type":1},"8":{"type":1},"9":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":602,"comission_card_count":192},"2":{"is_active":1,"device_type":602,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
106	device_type_80	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"3":{"type":7},"4":{"type":7},"5":{"type":7},"8":{"type":7},"9":{"type":7}},"output":{"3":{"type":1},"4":{"type":1},"5":{"type":1},"6":{"type":1},"7":{"type":1},"8":{"type":1},"9":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":602,"comission_card_count":192},"2":{"is_active":1,"device_type":602,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
123	device_type_96	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"3":{"type":7},"4":{"type":7},"5":{"type":7},"6":{"type":7}},"output":{"3":{"type":1},"4":{"type":1},"5":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":603,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
107	device_type_81	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"3":{"type":7},"4":{"type":7},"5":{"type":7},"6":{"type":7},"8":{"type":7},"9":{"type":7}},"output":{"3":{"type":1},"4":{"type":1},"5":{"type":1},"6":{"type":1},"7":{"type":1},"8":{"type":1},"9":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":602,"comission_card_count":192},"2":{"is_active":1,"device_type":602,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
108	device_type_82	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"4":{"type":7},"8":{"type":7}},"output":{"4":{"type":1},"5":{"type":1},"6":{"type":1},"7":{"type":1},"8":{"type":1},"9":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":602,"comission_card_count":192},"2":{"is_active":1,"device_type":602,"comission_card_count":192},"3":{"is_active":1,"device_type":602,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
109	device_type_83	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"4":{"type":7},"6":{"type":7},"8":{"type":7}},"output":{"4":{"type":1},"5":{"type":1},"6":{"type":1},"7":{"type":1},"8":{"type":1},"9":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":602,"comission_card_count":192},"2":{"is_active":1,"device_type":602,"comission_card_count":192},"3":{"is_active":1,"device_type":602,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
110	device_type_84	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"8":{"type":7}},"output":{"5":{"type":1},"6":{"type":1},"7":{"type":1},"8":{"type":1},"9":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":602,"comission_card_count":192},"2":{"is_active":1,"device_type":602,"comission_card_count":192},"3":{"is_active":1,"device_type":602,"comission_card_count":192},"4":{"is_active":1,"device_type":602,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
111	device_type_85	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"2":{"type":7},"3":{"type":7},"4":{"type":7},"8":{"type":7},"9":{"type":7}},"output":{"2":{"type":1},"3":{"type":1},"4":{"type":1},"5":{"type":1},"6":{"type":1},"7":{"type":1},"8":{"type":1},"9":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":601,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
112	device_type_86	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"2":{"type":7},"3":{"type":7},"4":{"type":7},"5":{"type":7},"8":{"type":7},"9":{"type":7}},"output":{"2":{"type":1},"3":{"type":1},"4":{"type":1},"5":{"type":1},"6":{"type":1},"7":{"type":1},"8":{"type":1},"9":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":601,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
114	device_type_87	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"2":{"type":7},"3":{"type":7},"4":{"type":7},"5":{"type":7},"6":{"type":7},"8":{"type":7},"9":{"type":7}},"output":{"2":{"type":1},"3":{"type":1},"4":{"type":1},"5":{"type":1},"6":{"type":1},"7":{"type":1},"8":{"type":1},"9":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":601,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
124	connections	\N	{"type":"object","widget":"section","title":"##Внешние подключения##","properties":{"port_config":{"type":"object","widget":"section","title":"##Порт для конфигурации, управления и диагностики##","properties":{"ip_address":{"type":"string","title":"##Удалённый IP-адрес##","readonly":true},"mac_address":{"type":"string","title":"##Удалённый MAC-адрес##","readonly":true},"socket_state":{"type":"string","title":"##Состояние сокета##","readonly":true},"ip_remote_port":{"type":"string","title":"##Удалённый порт##","readonly":true},"ip_local_port":{"type":"string","title":"##Локальный порт##","readonly":true}}},"port_monitoring":{"type":"object","widget":"section","title":"##Порт для передачи журнала мониторинга##","properties":{"ip_address":{"type":"string","title":"##Удалённый IP-адрес##","readonly":true},"mac_address":{"type":"string","title":"##Удалённый MAC-адрес##","readonly":true},"socket_state":{"type":"string","title":"##Состояние сокета##","readonly":true},"ip_remote_port":{"type":"string","title":"##Удалённый порт##","readonly":true},"ip_local_port":{"type":"string","title":"##Локальный порт##","readonly":true}}},"port_register":{"type":"object","widget":"section","title":"##Порт для передачи журнала регистрации##","properties":{"ip_address":{"type":"string","title":"##Удалённый IP-адрес##","readonly":true},"mac_address":{"type":"string","title":"##Удалённый MAC-адрес##","readonly":true},"socket_state":{"type":"string","title":"##Состояние сокета##","readonly":true},"ip_remote_port":{"type":"string","title":"##Удалённый порт##","readonly":true},"ip_local_port":{"type":"string","title":"##Локальный порт##","readonly":true}}},"port_identify":{"type":"object","widget":"section","title":"##Порт для обмена с индицирующим устройством##","properties":{"ip_address":{"type":"string","title":"##Удалённый IP-адрес##","readonly":true},"mac_address":{"type":"string","title":"##Удалённый MAC-адрес##","readonly":true},"socket_state":{"type":"string","title":"##Состояние сокета##","readonly":true},"ip_remote_port":{"type":"string","title":"##Удалённый порт##","readonly":true},"ip_local_port":{"type":"string","title":"##Локальный порт##","readonly":true}}},"port_verify":{"type":"object","widget":"section","title":"##Порт для обмена с верифицирующим устройством##","properties":{"ip_address":{"type":"string","title":"##Удалённый IP-адрес##","readonly":true},"mac_address":{"type":"string","title":"##Удалённый MAC-адрес##","readonly":true},"socket_state":{"type":"string","title":"##Состояние сокета##","readonly":true},"ip_remote_port":{"type":"string","title":"##Удалённый порт##","readonly":true},"ip_local_port":{"type":"string","title":"##Локальный порт##","readonly":true}}},"port_debug":{"type":"object","widget":"section","title":"##Порт для передачи журнала отладки##","properties":{"ip_address":{"type":"string","title":"##Удалённый IP-адрес##","readonly":true},"mac_address":{"type":"string","title":"##Удалённый MAC-адрес##","readonly":true},"socket_state":{"type":"string","title":"##Состояние сокета##","readonly":true},"ip_remote_port":{"type":"string","title":"##Удалённый порт##","readonly":true},"ip_local_port":{"type":"string","title":"##Локальный порт##","readonly":true}}}}}
125	verify_point_full	\N	{"0":{"is_hub":0,"is_active":1,"resources":{"verify_point":{"is_tab":true,"_settings":{"type":1},"_events":{"type":2}}}}}
115	device_type_88	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"2":{"type":7},"4":{"type":7},"8":{"type":7},"9":{"type":7}},"output":{"2":{"type":1},"4":{"type":1},"5":{"type":1},"6":{"type":1},"7":{"type":1},"8":{"type":1},"9":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":601,"comission_card_count":192},"3":{"is_active":1,"device_type":602,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
116	device_type_89	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"2":{"type":7},"4":{"type":7},"6":{"type":7},"8":{"type":7},"9":{"type":7}},"output":{"2":{"type":1},"4":{"type":1},"5":{"type":1},"6":{"type":1},"7":{"type":1},"8":{"type":1},"9":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":601,"comission_card_count":192},"3":{"is_active":1,"device_type":602,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
117	device_type_90	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"2":{"type":7},"8":{"type":7},"9":{"type":7}},"output":{"2":{"type":1},"5":{"type":1},"6":{"type":1},"7":{"type":1},"8":{"type":1},"9":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":601,"comission_card_count":192},"3":{"is_active":1,"device_type":602,"comission_card_count":192},"4":{"is_active":1,"device_type":602,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
118	device_type_91	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"4":{"type":7},"8":{"type":7}},"output":{"4":{"type":1},"5":{"type":1},"6":{"type":1},"7":{"type":1},"8":{"type":1},"9":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":601,"comission_card_count":192},"3":{"is_active":1,"device_type":601,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
119	device_type_92	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"4":{"type":7},"6":{"type":7},"8":{"type":7}},"output":{"4":{"type":1},"5":{"type":1},"6":{"type":1},"7":{"type":1},"8":{"type":1},"9":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":601,"comission_card_count":192},"3":{"is_active":1,"device_type":601,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
120	device_type_93	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"3":{"type":7},"4":{"type":7},"5":{"type":7},"6":{"type":7}},"output":{"3":{"type":1},"4":{"type":1},"5":{"type":1},"6":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":603,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
121	device_type_94	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"3":{"type":7},"4":{"type":7},"5":{"type":7},"6":{"type":7}},"output":{"3":{"type":1},"4":{"type":1},"5":{"type":1},"6":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":603,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
122	device_type_95	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"3":{"type":7},"4":{"type":7},"5":{"type":7},"6":{"type":7}},"output":{"3":{"type":1},"4":{"type":1},"5":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":603,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
126	verify_point_settings	\N	{"type": "object", "widget": "section", "title": "##Параметры точки верификации##", "properties": {"info": {"type": "object", "widget": "section", "title": "##Параметры отображения информации##", "properties": {"info_time_type": {"type": "select", "title": "##Отображение информации (в течение какого времени после прохода (или другого события) будет отображаться информация о проходе/событии)##", "enum": [2, 1], "enumNames": ["##Постоянно##", "##Не более чем##"], "default": 1, "dependencies": {"2": [{"item": "$$selfLink$$.info.info_time", "props": {"visible": false}}]}}, "info_time": {"type": "string", "title": "##Значение (секунд, 2 - 120)##", "default": 2, "validator": {"pattern": "number", "min": 2, "max": 120}}, "verify_timeout": {"type": "object", "widget": "combotime", "title": "##Таймаут верификации (время, в течение которого контроллер, отправивший запрос на верификацию, будет ожидать ответа оператора)##", "properties": {"selector": {"type": "select", "enum": [1, 2], "enumNames": ["##Секунды##", "##Бесконечность##"], "default": 1, "dependencies": {"2": [{"item": "$$selfLink$$.info.verify_timeout.input", "props": {"visible": false}}]}}, "input": {"type": "string", "default": 5, "validator": {"pattern": "number", "min": 1, "max": 255}}}}}}, "video": {"type": "object", "widget": "section", "title": "##Параметры видеозаписи##", "properties": {"pre_recording_time": {"type": "string", "title": "##Продолжительность предзаписи (секунд)##", "default": 8, "validator": {"max": 120, "pattern": "number"}}, "record_time": {"type": "string", "title": "##Продолжительность записи (секунд)##", "default": 6, "validator": {"max": 255, "pattern": "number"}}, "frame_rate": {"type": "string", "title": "##Частота записи видеокадров##", "default": 2, "validator": {"pattern": "number", "max": 10}}}}}}
127	verify_point_reaction	\N	{"type":"object","widget":"section","title":"##Реакция на события##","properties":{"staff":{"type":"object","widget":"section","title":"##События при проходе сотрудников##","properties":{"pass_allowed":{"type":"object","widget":"container","title":"##Проход##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.staff.pass_allowed.video","props":{"visible":false}},{"item":"$$selfLink$$.staff.pass_allowed.verify","props":{"visible":false}},{"item":"$$selfLink$$.staff.pass_allowed.auto_confirm","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false},"verify":{"type":"select","title":"##Верификация##","enum":[0,1],"enumNames":["##Нет (режим индикации)##","##Да (режим верификации)##"],"default":0,"dependencies":{"0":[{"item":"$$selfLink$$.staff.pass_allowed.auto_confirm","props":{"visible":false}}],"1":[{"item":"$$selfLink$$.staff.pass_allowed.auto_confirm","props":{"visible":true}}]}},"auto_confirm":{"type":"boolean","title":"##Автоподтверждение##","default":false}}},"time_violation":{"type":"object","widget":"container","title":"##Проход с нарушением ВРЕМЕНИ##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.staff.time_violation.video","props":{"visible":false}},{"item":"$$selfLink$$.staff.time_violation.verify","props":{"visible":false}},{"item":"$$selfLink$$.staff.time_violation.auto_confirm","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false},"verify":{"type":"select","title":"##Верификация##","enum":[0,1],"enumNames":["##Нет (режим индикации)##","##Да (режим верификации)##"],"default":0,"dependencies":{"0":[{"item":"$$selfLink$$.staff.time_violation.auto_confirm","props":{"visible":false}}],"1":[{"item":"$$selfLink$$.staff.time_violation.auto_confirm","props":{"visible":true}}]}},"auto_confirm":{"type":"boolean","title":"##Автоподтверждение##","default":false}}},"place_violation":{"type":"object","widget":"container","title":"##Проход с нарушением ЗОНАЛЬНОСТИ##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.staff.place_violation.video","props":{"visible":false}},{"item":"$$selfLink$$.staff.place_violation.verify","props":{"visible":false}},{"item":"$$selfLink$$.staff.place_violation.auto_confirm","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false},"verify":{"type":"select","title":"##Верификация##","enum":[0,1],"enumNames":["##Нет (режим индикации)##","##Да (режим верификации)##"],"default":0,"dependencies":{"0":[{"item":"$$selfLink$$.staff.place_violation.auto_confirm","props":{"visible":false}}],"1":[{"item":"$$selfLink$$.staff.place_violation.auto_confirm","props":{"visible":true}}]}},"auto_confirm":{"type":"boolean","title":"##Автоподтверждение##","default":false}}},"guard_on":{"type":"object","widget":"container","title":"##Постановка на охрану (только для контроллеров замка)##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.staff.guard_on.video","props":{"visible":false}},{"item":"$$selfLink$$.staff.guard_on.verify","props":{"visible":false}},{"item":"$$selfLink$$.staff.guard_on.auto_confirm","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false},"verify":{"type":"select","title":"##Верификация##","enum":[0,1],"enumNames":["##Нет (режим индикации)##","##Да (режим верификации)##"],"default":0,"dependencies":{"0":[{"item":"$$selfLink$$.staff.guard_on.auto_confirm","props":{"visible":false}}],"1":[{"item":"$$selfLink$$.staff.guard_on.auto_confirm","props":{"visible":true}}]}},"auto_confirm":{"type":"boolean","title":"##Автоподтверждение##","default":false}}},"guard_off":{"type":"object","widget":"container","title":"##Снятие с охраны (только для контроллеров замка)##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.staff.guard_off.video","props":{"visible":false}},{"item":"$$selfLink$$.staff.guard_off.verify","props":{"visible":false}},{"item":"$$selfLink$$.staff.guard_off.auto_confirm","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false},"verify":{"type":"select","title":"##Верификация##","enum":[0,1],"enumNames":["##Нет (режим индикации)##","##Да (режим верификации)##"],"default":0,"dependencies":{"0":[{"item":"$$selfLink$$.staff.guard_off.auto_confirm","props":{"visible":false}}],"1":[{"item":"$$selfLink$$.staff.guard_off.auto_confirm","props":{"visible":true}}]}},"auto_confirm":{"type":"boolean","title":"##Автоподтверждение##","default":false}}}}},"visitor":{"type":"object","widget":"section","title":"##События при проходе посетителей##","properties":{"time_violation":{"type":"object","widget":"container","title":"##Проход с нарушением ВРЕМЕНИ##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.visitor.time_violation.video","props":{"visible":false}},{"item":"$$selfLink$$.visitor.time_violation.verify","props":{"visible":false}},{"item":"$$selfLink$$.visitor.time_violation.auto_confirm","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false},"verify":{"type":"select","title":"##Верификация##","enum":[0,1],"enumNames":["##Нет (режим индикации)##","##Да (режим верификации)##"],"default":0,"dependencies":{"0":[{"item":"$$selfLink$$.visitor.time_violation.auto_confirm","props":{"visible":false}}],"1":[{"item":"$$selfLink$$.visitor.time_violation.auto_confirm","props":{"visible":true}}]}},"auto_confirm":{"type":"boolean","title":"##Автоподтверждение##","default":false}}},"place_violation":{"type":"object","widget":"container","title":"##Проход с нарушением ЗОНАЛЬНОСТИ##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.visitor.place_violation.video","props":{"visible":false}},{"item":"$$selfLink$$.visitor.place_violation.verify","props":{"visible":false}},{"item":"$$selfLink$$.visitor.place_violation.auto_confirm","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false},"verify":{"type":"select","title":"##Верификация##","enum":[0,1],"enumNames":["##Нет (режим индикации)##","##Да (режим верификации)##"],"default":0,"dependencies":{"0":[{"item":"$$selfLink$$.visitor.place_violation.auto_confirm","props":{"visible":false}}],"1":[{"item":"$$selfLink$$.visitor.place_violation.auto_confirm","props":{"visible":true}}]}},"auto_confirm":{"type":"boolean","title":"##Автоподтверждение##","default":false}}},"pass_allowed":{"type":"object","widget":"container","title":"##Проход##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.visitor.pass_allowed.video","props":{"visible":false}},{"item":"$$selfLink$$.visitor.pass_allowed.verify","props":{"visible":false}},{"item":"$$selfLink$$.visitor.pass_allowed.auto_confirm","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false},"verify":{"type":"select","title":"##Верификация##","enum":[0,1],"enumNames":["##Нет (режим индикации)##","##Да (режим верификации)##"],"default":0,"dependencies":{"0":[{"item":"$$selfLink$$.visitor.pass_allowed.auto_confirm","props":{"visible":false}}],"1":[{"item":"$$selfLink$$.visitor.pass_allowed.auto_confirm","props":{"visible":true}}]}},"auto_confirm":{"type":"boolean","title":"##Автоподтверждение##","default":false}}}}},"notice":{"type":"object","widget":"section","title":"##Уведомляющие события##","properties":{"not_in_list":{"type":"object","widget":"container","title":"##Идентификатор НЕ ЗАРЕГИСТРИРОВАН##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.notice.not_in_list.video","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false}}},"ban":{"type":"object","widget":"container","title":"##Идентификатор ЗАБЛОКИРОВАН##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.notice.ban.video","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false}}},"ended_duration":{"type":"object","widget":"container","title":"##Идентификатор ПРОСРОЧЕН##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.notice.ended_duration.video","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false}}},"acm_violation":{"type":"object","widget":"container","title":"##Нарушение РКД##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.notice.acm_violation.video","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false}}},"brake":{"type":"object","widget":"container","title":"##Взлом ИУ##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.notice.brake.video","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false}}},"pass_allowed_rc":{"type":"object","widget":"container","title":"##Проход от ДУ##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.notice.pass_allowed_rc.video","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false}}}}}}}
128	reader2	2v parent	{"type":"object","widget":"section","title":"##Считыватель##","properties":{"command":{"type":"commands","title":"##Команды считывателя##","properties":{"set_mode_open":{"command_type":"0","command_value":"0","command_number":"$$resourceNumber$$","title":"##Установить режим работы \\"Открыто\\"##"},"set_mode_control":{"command_type":"0","command_value":"1","command_number":"$$resourceNumber$$","title":"##Установить режим работы \\"Контроль\\"##"},"set_mode_closed":{"command_type":"0","command_value":"3","command_number":"$$resourceNumber$$","title":"##Установить режим работы \\"Закрыто\\"##"},"open_iu":{"command_type":"1","command_value":"1","command_number":"$$resourceNumber$$","title":"##Открыть (разблокировать) ИУ##","command_param":{"type":"object","widget":"combotime","title":"##Время активизации##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"select","props":{"visible":true}}],"1":[{"item":"input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}}},"close_iu":{"command_type":"1","command_value":"0","command_number":"$$resourceNumber$$","title":"##Закрыть (заблокировать) ИУ##"}}},"staff_antipass":{"type":"object","widget":"section","title":"##Защита от передачи идентификаторов СОТРУДНИКОВ (Antipass)##","properties":{"control_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":0}}},"visitor_antipass":{"type":"section","title":"##Защита от передачи идентификаторов ПОСЕТИТЕЛЕЙ (Antipass)##","properties":{"control_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":0}}},"time_control_staff":{"type":"section","title":"##Контроль времени для идентификаторов СОТРУДНИКОВ##","properties":{"control_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":0}}},"time_control_visitors":{"type":"section","title":"##Контроль времени для идентификаторов ПОСЕТИТЕЛЕЙ##","properties":{"control_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":0}}},"permission_du":{"type":"object","widget":"section","expandable":true,"title":"##Разрешение ДУ##","properties":{"control_mode":{"type":"boolean","title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":true}}},"confirmation_du":{"type":"object","widget":"section","title":"##Верификация##","properties":{"control_mode":{"type":"select","title":"##Верификация##","enum":[0,1,2,3,4,5,6,7,8,9],"enumNames":["##Нет##","##ПДУ##","##Софт##","##ВВУ##","##При доступности софт, иначе ПДУ##","##ПДУ или софт##","##Сначала ПДУ затем софт##","##Сначала ВВУ затем ПДУ##","##Сначала ВВУ затем софт##","##При доступности софт, иначе ВВУ##"],"default":0},"verify_staff_du":{"type":"object","widget":"container","title":"##Верифицировать идентификаторы СОТРУДНИКОВ от ПДУ##","properties":{"pass":{"type":"boolean","title":"##При проходе##","default":false},"time_violation":{"type":"boolean","title":"##При проходе с НАРУШЕНИЕМ ВРЕМЕНИ##","default":false},"place_violation":{"type":"boolean","title":"##При проходе с НАРУШЕНИЕМ ЗОНАЛЬНОСТИ##","default":false}}},"verify_visitor_du":{"type":"object","widget":"container","title":"##Верифицировать идентификаторы ПОСЕТИТЕЛЕЙ от ПДУ##","properties":{"pass":{"type":"boolean","title":"##При проходе##","default":false},"time_violation":{"type":"boolean","title":"##При проходе с НАРУШЕНИЕМ ВРЕМЕНИ##","default":false},"place_violation":{"type":"boolean","title":"##При проходе с НАРУШЕНИЕМ ЗОНАЛЬНОСТИ##","default":false}}},"confirm_time_du":{"type":"object","widget":"combotime","title":"##Время ожидания подтверждения при верификации от ПДУ##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.confirmation_du.confirm_time_du.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.confirmation_du.confirm_time_du.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"verify_staff_vvu":{"type":"object","widget":"container","title":"##Верифицировать идентификаторы СОТРУДНИКОВ от ВВУ##","properties":{"pass":{"type":"boolean","title":"##При проходе##","default":false},"time_violation":{"type":"boolean","title":"##При проходе с НАРУШЕНИЕМ ВРЕМЕНИ##","default":false},"place_violation":{"type":"boolean","title":"##При проходе с НАРУШЕНИЕМ ЗОНАЛЬНОСТИ##","default":false}}},"verify_visitor_vvu":{"type":"object","widget":"container","title":"##Верифицировать идентификаторы ПОСЕТИТЕЛЕЙ от ВВУ##","properties":{"pass":{"type":"boolean","title":"##При проходе##","default":false},"time_violation":{"type":"boolean","title":"##При проходе с НАРУШЕНИЕМ ВРЕМЕНИ##","default":false},"place_violation":{"type":"boolean","title":"##При проходе с НАРУШЕНИЕМ ЗОНАЛЬНОСТИ##","default":false}}},"confirm_time_vvu":{"type":"object","widget":"combotime","title":"##Время ожидания подтверждения при верификации от ВВУ##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.confirmation_du.confirm_time_vvu.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.confirmation_du.confirm_time_vvu.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"vvu_not_answer":{"type":"select","title":"##При отсутствии ответа от ВВУ##","enum":[0,1],"enumNames":["##Запрет##","##Отказ от прохода##"],"default":0}}},"is_card_extract":{"type":"object","widget":"section","title":"##Изымать идентификаторы посетителей после прохода##","properties":{"extract":{"type":"boolean","title":"##Изымать идентификаторы посетителей после прохода##","default":false}}}}}
129	verify_point_licon	\N	{"0":{"is_hub":0,"is_active":1,"resources":{"verify_point":{"is_tab":true,"_settings":{"type":4},"_events":{"type":3}}}}}
130	verify_point_reaction_licon	\N	{"type":"object","widget":"section","title":"##Реакция на события##","properties":{"staff":{"type":"object","widget":"section","title":"##События при проходе сотрудников##","properties":{"pass_allowed":{"type":"object","widget":"container","title":"##Проход##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.staff.pass_allowed.video","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false}}},"time_violation":{"type":"object","widget":"container","title":"##Проход с нарушением ВРЕМЕНИ##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.staff.time_violation.video","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false}}},"place_violation":{"type":"object","widget":"container","title":"##Проход с нарушением ЗОНАЛЬНОСТИ##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.staff.place_violation.video","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false}}}}},"visitor":{"type":"object","widget":"section","title":"##События при проходе посетителей##","properties":{"pass_allowed":{"type":"object","widget":"container","title":"##Проход##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.visitor.pass_allowed.video","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false}}},"time_violation":{"type":"object","widget":"container","title":"##Проход с нарушением ВРЕМЕНИ##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.visitor.time_violation.video","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false}}},"place_violation":{"type":"object","widget":"container","title":"##Проход с нарушением ЗОНАЛЬНОСТИ##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.visitor.place_violation.video","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false}}}}},"notice":{"type":"object","widget":"section","title":"##Уведомляющие события##","properties":{"not_in_list":{"type":"object","widget":"container","title":"##Идентификатор НЕ ЗАРЕГИСТРИРОВАН##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.notice.not_in_list.video","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false}}},"ban":{"type":"object","widget":"container","title":"##Идентификатор ЗАБЛОКИРОВАН##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.notice.ban.video","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false}}},"ended_duration":{"type":"object","widget":"container","title":"##Идентификатор ПРОСРОЧЕН##","properties":{"watch":{"type":"select","enum":[0,1],"enumNames":["##Не отслеживать##","##Отслеживать##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.notice.ended_duration.video","props":{"visible":false}}]}},"video":{"type":"boolean","title":"##Запись кадров видеокамеры##","default":false}}}}}}}
131	reader_type_8	s30	{"type":"object","widget":"section","title":"$$optionsName$$","link":"$$selfLink$$","properties":{"controller":{"type":"string","widget":"select","title":"##Контроллер##","default":"$$optionsHardNumbers$$","$$childControllersSelector$$":"$$"},"direction":{"type":"string","widget":"select","title":"##Направление##","enum":[],"enumNames":[],"default":"$$optionsDir$$"}}}
132	camera_about_mjpeg	\N	{"type":"object","widget":"section","title":"##О камере##","properties":{"camera_manufacturer":{"type":"string","title":"##Производитель##","default":"","readonly":true},"camera_uri":{"type":"string","title":"URI","default":"","readonly":true}}}
133	camera_settings_mjpeg	\N	{"type":"object","widget":"section","title":"##Камера##","properties":{"port":{"type":"string","title":"##Порт##","default":""},"login":{"type":"string","title":"##Логин##","default":""},"password":{"type":"password","title":"##Пароль##","default":""}}}
134	camera_mjpeg	\N	{"0":{"is_hub":0,"resources":{"network":{"type":1},"camera":{"is_tab":true,"_settings":{"type":5},"_about":{"type":4},"_video":{"type":3}}}}}
135	device_type_402	\N	{"resources":{"lock":{"type":3},"reader":{"type":2},"alarm_gen":{"type":2}}}
136	reader_type_2	\N	{"type":"object","widget":"section","title":"##Считыватель##","properties":{"command":{"type":"commands","title":"##Команды считывателя##","properties":{"set_mode_open":{"command_type":"0","command_value":"0","command_number":"$$resourceNumber$$","title":"##Установить режим работы \\"Открыто\\"##"},"set_mode_control":{"command_type":"0","command_value":"1","command_number":"$$resourceNumber$$","title":"##Установить режим работы \\"Контроль\\"##"},"set_mode_closed":{"command_type":"0","command_value":"3","command_number":"$$resourceNumber$$","title":"##Установить режим работы \\"Закрыто\\"##"},"open_iu":{"command_type":"1","command_value":"1","command_number":"$$resourceNumber$$","title":"##Открыть (разблокировать) ИУ##","command_param":{"type":"object","widget":"combotime","title":"##Время активизации##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"select","props":{"visible":true}}],"1":[{"item":"input","props":{"visible":true}}]}},"input":{"type":"string","default":5,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}}},"close_iu":{"command_type":"1","command_value":"0","command_number":"$$resourceNumber$$","title":"##Закрыть (заблокировать) ИУ##"}}},"staff_antipass":{"type":"object","widget":"section","title":"##Защита от передачи идентификаторов СОТРУДНИКОВ (Antipass)##","properties":{"control_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":0},"guard_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Охрана\\"##","default":0}}},"visitor_antipass":{"type":"section","title":"##Защита от передачи идентификаторов ПОСЕТИТЕЛЕЙ (Antipass)##","properties":{"control_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":0}}},"time_control_staff":{"type":"section","title":"##Контроль времени для идентификаторов СОТРУДНИКОВ##","properties":{"control_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":0},"guard_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Охрана\\"##","default":0}}},"time_control_visitors":{"type":"section","title":"##Контроль времени для идентификаторов ПОСЕТИТЕЛЕЙ##","properties":{"control_mode":{"type":"antipass","title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":0}}},"permission_du":{"type":"object","widget":"section","title":"##Разрешение ДУ##","properties":{"control_mode":{"type":"boolean","title":"##В РЕЖИМЕ РАБОТЫ \\"Контроль\\"##","default":true}}},"confirmation_du":{"type":"section","title":"##Верификация##","properties":{"control_mode":{"type":"select","title":"##Верификация##","enum":[0,1,2,3,4,5,6,7,8,9],"enumNames":["##Нет##","##ПДУ##","##Софт##","##ВВУ##","##При доступности софт, иначе ПДУ##","##ПДУ или софт##","##Сначала ПДУ затем софт##","##Сначала ВВУ затем ПДУ##","##Сначала ВВУ затем софт##","##При доступности софт, иначе ВВУ##"],"default":0},"verify_staff_du":{"type":"object","widget":"container","title":"##Верифицировать идентификаторы СОТРУДНИКОВ от ПДУ##","properties":{"pass":{"type":"boolean","title":"##При проходе##","default":false},"time_violation":{"type":"boolean","title":"##При проходе с НАРУШЕНИЕМ ВРЕМЕНИ##","default":false},"place_violation":{"type":"boolean","title":"##При проходе с НАРУШЕНИЕМ ЗОНАЛЬНОСТИ##","default":false}}},"verify_visitor_du":{"type":"object","widget":"container","title":"##Верифицировать идентификаторы ПОСЕТИТЕЛЕЙ от ПДУ##","properties":{"pass":{"type":"boolean","title":"##При проходе##","default":false},"time_violation":{"type":"boolean","title":"##При проходе с НАРУШЕНИЕМ ВРЕМЕНИ##","default":false},"place_violation":{"type":"boolean","title":"##При проходе с НАРУШЕНИЕМ ЗОНАЛЬНОСТИ##","default":false}}},"confirm_time_du":{"type":"object","widget":"combotime","title":"##Время ожидания подтверждения при верификации от ПДУ##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.confirmation_du.confirm_time_du.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.confirmation_du.confirm_time_du.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"verify_staff_vvu":{"type":"object","widget":"container","title":"##Верифицировать идентификаторы СОТРУДНИКОВ от ВВУ##","properties":{"pass":{"type":"boolean","title":"##При проходе##","default":false},"time_violation":{"type":"boolean","title":"##При проходе с НАРУШЕНИЕМ ВРЕМЕНИ##","default":false},"place_violation":{"type":"boolean","title":"##При проходе с НАРУШЕНИЕМ ЗОНАЛЬНОСТИ##","default":false}}},"verify_visitor_vvu":{"type":"object","widget":"container","title":"##Верифицировать идентификаторы ПОСЕТИТЕЛЕЙ от ВВУ##","properties":{"pass":{"type":"boolean","title":"##При проходе##","default":false},"time_violation":{"type":"boolean","title":"##При проходе с НАРУШЕНИЕМ ВРЕМЕНИ##","default":false},"place_violation":{"type":"boolean","title":"##При проходе с НАРУШЕНИЕМ ЗОНАЛЬНОСТИ##","default":false}}},"confirm_time_vvu":{"type":"object","widget":"combotime","title":"##Время ожидания подтверждения при верификации от ВВУ##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.confirmation_du.confirm_time_vvu.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.confirmation_du.confirm_time_vvu.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"vvu_not_answer":{"type":"select","title":"##При отсутствии ответа от ВВУ##","enum":[1,2],"enumNames":["##Запрет##","##Отказ от прохода##"],"default":1}}},"is_card_extract":{"type":"object","widget":"section","title":"##Изымать идентификаторы посетителей после прохода##","properties":{"extract":{"type":"boolean","title":"##Изымать идентификаторы посетителей после прохода##","default":false}}},"inputs_masked_unlocking_iu":{"type":"section","title":"##Дополнительные входы, маскируемые при разблокировке ИУ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.inputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time","props":{"visible":true}},{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.inputs_masked_unlocking_iu.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"inputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentInputs":"$$"}}}},"outputs_activated_unlocking_iu":{"type":"section","title":"##Дополнительные выходы, активизируемые при разблокировке ИУ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_activated_unlocking_iu.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentOutputs":"$$"}}}},"outputs_normalize_unlocking_iu":{"type":"section","title":"##Дополнительные выходы, нормализируемые при разблокировке ИУ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_normalize_unlocking_iu.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentOutputs":"$$"}}}},"outputs_activated_staff":{"type":"section","title":"##Дополнительные выходы, активизируемые при предъявлении валидных идентификаторов СОТРУДНИКОВ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_staff.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_activated_staff.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_activated_staff.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated_staff.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_staff.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_activated_staff.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentOutputs":"$$"}}}},"outputs_activated_visitor":{"type":"section","title":"##Дополнительные выходы, активизируемые при предъявлении валидных идентификаторов ПОСЕТИТЕЛЕЙ##","properties":{"time_prop":{"type":"string","widget":"select","enum":[0,1,2,3],"enumNames":["##Не задано##","##На время срабатывания##","##На указанное время##","##На время срабатывания и после срабатывания##"],"title":"##Критерий активизации##","default":0,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_visitor.outputs","props":{"visible":false}}],"2":[{"item":"$$selfLink$$.outputs_activated_visitor.time","props":{"visible":true}}],"3":[{"item":"$$selfLink$$.outputs_activated_visitor.time","props":{"visible":true}},{"item":"$$selfLink$$.outputs_activated_visitor.time.selector","props":{"enum":[0,1],"enumNames":["##Миллисекунды##","##Секунды##"],"default":1}}]}},"time":{"type":"object","widget":"combotime","title":"##Время##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.outputs_activated_visitor.time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.outputs_activated_visitor.time.input","props":{"visible":true}}]}},"input":{"type":"string","default":1,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"outputs":{"type":"object","widget":"container","title":"","properties":{"$$allParentOutputs":"$$"}}}}}}
137	verify_point_s30	\N	{"0":{"is_hub":0,"is_active":1,"resources":{"verify_point":{"is_tab":true,"_settings":{"type":4},"_events":{"type":2}}}}}
153	zkt_settings	ZKTeco	{ "type": "object", "widget": "section", "title": "##Разное##", "properties": { "firmware_version": { "type": "string", "title": "##Версия прошивки##", "default": "", "readonly": true }, "model": { "type": "string", "title": "##Модель##", "default": "", "readonly": true }, "serial_number": { "type": "string", "title": "##Серийный номер##", "default": "", "readonly": true } } }
154	zkt_common_settings	ZKTeco	{"type": "object", "title": "##Контроллеры ZKTeco##", "widget": "section", "properties": {"server_port": {"type": "string", "title": "##Порт сервера##", "default": "8081", "validator": {"min": 1, "max": 65535, "minLength": 4, "maxLength": 5, "pattern": "number"}}}}
138	verify_point_settings_s30	\N	{"type": "object", "widget": "section", "title": "##Параметры точки верификации##", "properties": {"info": {"type": "object", "widget": "section", "title": "##Параметры отображения информации##", "properties": {"info_time_type": {"type": "select", "title": "##Отображение информации (в течение какого времени после прохода (или другого события) будет отображаться информация о проходе/событии)##", "enum": [2, 1], "enumNames": ["##Постоянно##", "##Не более чем##"], "default": 1, "dependencies": {"2": [{"item": "$$selfLink$$.info.info_time", "props": {"visible": false}}]}}, "info_time": {"type": "string", "title": "##Значение (секунд, 2 - 120)##", "default": 2, "validator": {"pattern": "number", "min": 2, "max": 120}}}}, "video": {"type": "object", "widget": "section", "title": "##Параметры видеозаписи##", "properties": {"pre_recording_time": {"type": "string", "title": "##Продолжительность предзаписи (секунд)##", "default": 8, "validator": {"pattern": "number", "max": 120}}, "record_time": {"type": "string", "title": "##Продолжительность записи (секунд)##", "default": 6, "validator": {"pattern": "number", "max": 255}}, "frame_rate": {"type": "string", "title": "##Частота записи видеокадров##", "default": 2, "validator": {"pattern": "number", "max": 10}}}}}}
139	lock_type_11	\N	{"type":"object","widget":"section","title":"##ИУ##","properties":{"command":{"type":"object","widget":"commands","title":"##Управление охранными зонами##","properties":{"guard_on":{"type":"object","command_type":"5","command_value":"1","command_number":"$$resourceNumber$$","widget":"button","title":"##Поставить на охрану##"},"guard_off":{"type":"object","command_type":"5","command_value":"0","command_number":"$$resourceNumber$$","widget":"button","title":"##Снять с охраны##"},"reset_alarm":{"type":"object","command_type":"4","command_value":"0","command_number":"$$resourceNumber$$","widget":"button","title":"##Снять тревогу##"},"clear_spatial_zones":{"type":"object","command_type":"6","command_value":"0","command_number":"$$resourceNumber$$","widget":"button","title":"##Сбросить зональность##"}}},"algorithm":{"type":"string","widget":"select","title":"##Алгоритм##","enum":[1,2,4],"enumNames":["##Замок##","##Турникет##","##Шлюз##"],"default":1},"check_pass_presentation_id":{"type":"boolean","title":"##Регистрация прохода по предъявлению идентификатора##","default":false},"hold_time":{"type":"object","widget":"combotime","title":"##Время удержания в разблокированном состоянии (время анализа идентификатора)##","properties":{"selector":{"type":"select","widget":"select","enum":[1,2],"enumNames":["##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"1":[{"item":"$$selfLink$$.hold_time.input","props":{"visible":true}}]}},"input":{"type":"string","default":8,"visible":false,"validator":{"pattern":"number","min":1,"max":251}}}},"max_unblock_time":{"type":"object","widget":"combotime","title":"##Предельное время разблокировки##","properties":{"selector":{"type":"select","widget":"select","enum":[0,1,2],"enumNames":["##Миллисекунды##","##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"0":[{"item":"$$selfLink$$.max_unblock_time.select","props":{"visible":true}}],"1":[{"item":"$$selfLink$$.max_unblock_time.input","props":{"visible":true}}]}},"input":{"type":"string","default":8,"visible":false,"validator":{"pattern":"number","min":1,"max":251}},"select":{"type":"string","widget":"select","visible":false,"enum":[0,1,2],"enumNames":["250","500","750"],"default":0}}},"operation_mode_control_output_iu":{"type":"string","widget":"select","enum":[1,0],"enumNames":["##Потенциальный##","##Импульсный##"],"title":"##Режим работы выхода управления ИУ##","default":1,"dependencies":{"0":[{"item":"$$selfLink$$.control_pulse_time","props":{"visible":true}}]}},"control_pulse_time":{"type":"string","widget":"select","title":"##Длительность импульса управления ИУ (миллисекунд)##","enum":[250,500,750],"enumNames":["250","500","750"],"default":500},"normalization_iu_output":{"type":"string","widget":"select","enum":[0,1],"enumNames":["##После \\"Открытия\\"##","##После \\"Закрытия\\"##"],"title":"##Нормализация выхода ИУ##","default":0},"fire_alarm_reaction":{"type":"string","widget":"select","title":"##Реакция на Fire alarm в режиме работы \\"Охрана\\"##","enum":[0,1],"enumNames":["##Блокировать ИУ##","##Разблокировать ИУ##"],"default":1},"guard_identify_time":{"type":"object","widget":"combotime","title":"##Время идентификации постановки/снятия РКД \\"Охрана\\"##","properties":{"selector":{"type":"select","widget":"select","enum":[1,2],"enumNames":["##Секунды##","##Бесконечность##"],"default":1,"dependencies":{"1":[{"item":"$$selfLink$$.guard_identify_time.input","props":{"visible":true}}]}},"input":{"type":"string","default":8,"visible":false,"validator":{"pattern":"number","min":1,"max":251}}}},"is_antipass":{"type":"boolean","title":"##Внутренняя защита от передачи идентификаторов (Local Antipass)##","default":false}}}
141	gateway_type_3	\N	{"type":"object","widget":"section","title":"##Составной объект##","properties":{"algorithm":{"type":"string","widget":"select","title":"##Алгоритм##","enum":[1,2],"enumNames":["##Турникет##","##Двусторонний замок##"],"default":1},"controller1":{"type":"number","$$selectCL15controller":"$$","title":"##Контроллер## 1","validator":{"required":true}},"controller2":{"type":"number","$$selectCL15controller":"$$","title":"##Контроллер## 2","validator":{"required":true}}}}
142	gate_ctl14	\N	{"0":{"is_hub":1,"resources":{"gateway":{"type":1}}}}
143	gate_cl15	\N	{"0":{"is_hub":1,"resources":{"gateway":{"type":2}}}}
144	object_cl15	\N	{"0":{"is_hub":1,"resources":{"gateway":{"type":3}}}}
146	licon_string_2	\N	{"type":"object","widget":"section","title":"##Строки##","properties":{"table":{"type":"object","widget":"table","properties":{"cols":{"number":"№","target":"##Назначение##","value":"##Строка##","default":"##Оригинал строки##"},"rows":[{"number":"1","target":"##«Вход»##","value":"##Вход##","default":"##Вход##","font":2},{"number":"2","target":"##«Выход»##","value":"##Выход##","default":"##Выход##","font":2},{"number":"3","target":"##1-я строка «Карты нет в списке»##","value":"##Карты##","default":"##Карты##","font":2},{"number":"4","target":"##2-я строка «Карты нет в списке»##","value":"##нет в списке##","default":"##нет в списке##","font":2},{"number":"7","target":"##«нарушение зоны» для входа##","value":"##Нарушение зоны: вход##","default":"##Нарушение зоны: вход##","font":1},{"number":"8","target":"##«нарушение зоны» для выхода##","value":"##Нарушение зоны: выход##","default":"##Нарушение зоны: выход##","font":1},{"number":"9","target":"##строка направления прохода левая нижняя##","value":"##вход##","default":"##вход##","font":2},{"number":"10","target":"##строка направления прохода правая верхняя##","value":"##выход##","default":"##выход##","font":2},{"number":"11","target":"##1-я строка «Вход не зарегистрирован. Нарушение зоны»##","value":"##Вход##","default":"##Вход##","font":1},{"number":"12","target":"##2-я строка «Вход не зарегистрирован. Нарушение зоны»##","value":"##не зарегистрирован##","default":"##не зарегистрирован##","font":1},{"number":"13","target":"##3-я строка «Вход не зарегистрирован. Нарушение зоны»##","value":"##Нарушение зоны##","default":"##Нарушение зоны##","font":1},{"number":"14","target":"##1-я строка «Выход не зарегистрирован. Нарушение зоны»##","value":"##Выход##","default":"##Выход##","font":1},{"number":"15","target":"##2-я строка «Выход не зарегистрирован. Нарушение зоны»##","value":"##не зарегистрирован##","default":"##не зарегистрирован##","font":1},{"number":"16","target":"##3-я строка «Выход не зарегистрирован. Нарушение зоны»##","value":"##Нарушение зоны##","default":"##Нарушение зоны##","font":1}]}}}}
147	device_type_65	\N	{"0":{"is_hub":0,"resources":{"network":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"resources":{"licon_config":{"type":1},"licon_string":{"type":2}},"comission_card_count":0}}
148	reader_type_11	s30 morpho CT13	{"type":"object","widget":"section","title":"$$optionsName$$","link":"$$selfLink$$","properties":{"controller":{"type":"string","widget":"select","title":"##Контроллер##","default":"$$optionsHardNumbers$$","$$childControllersSelector$$":"$$"},"direction":{"type":"string","widget":"select","title":"##Направление##","enum":[],"enumNames":[],"default":"$$optionsDir$$"},"model":{"type":"string","title":"##Модель##","default":"","readonly":true},"serial":{"type":"string","title":"##Серийный номер##","default":"","readonly":true},"total":{"type":"string","title":"##Всего отпечатков##","default":"","readonly":true},"used":{"type":"string","title":"##Использовано отпечатков##","default":"","readonly":true},"free":{"type":"string","title":"##Свободно отпечатков##","default":"","readonly":true},"sensor_position":{"type":"string","widget":"select","title":"##Положение сенсора##","enum":[1,2,3],"enumNames":["##Нормальное##","##Развёрнутое на 180 градусов##","##Нормальное и развёрнутое##"],"default":1},"far_level":{"type":"string","widget":"select","title":"##Вероятность несанкционированного допуска##","enum":[1,2,3,4,5,6,7,8,9],"enumNames":["##меньше 1 %##","##меньше 0.5 %##","##меньше 0.1 %##","##меньше 0.05 %##","##меньше 0.01 %##","##меньше 0.001 %##","##меньше 0.0001 %##","##меньше 0.00001 %##","##меньше 0.0000001 %##"],"default":1}}}
149	reader_type_12	s30 morpho	{"type":"object","widget":"section","title":"$$optionsName$$","link":"$$selfLink$$","properties":{"controller":{"type":"string","widget":"select","title":"##Контроллер##","default":"$$optionsHardNumbers$$","$$childControllersSelector$$":"$$"},"direction":{"type":"string","widget":"select","title":"##Направление##","enum":[],"enumNames":[],"default":"$$optionsDir$$"},"model":{"type":"string","title":"##Модель##","default":"","readonly":true},"serial":{"type":"string","title":"##Серийный номер##","default":"","readonly":true},"total":{"type":"string","title":"##Всего отпечатков##","default":"","readonly":true},"used":{"type":"string","title":"##Использовано отпечатков##","default":"","readonly":true},"free":{"type":"string","title":"##Свободно отпечатков##","default":"","readonly":true}}}
152	zkt_device	ZKTeco	{"0":{"is_hub":0,"resources":{"network":{"type":1},"settings":{"type":3}}},"1":{"resources":{"lock":{"type":12},"reader":{"type":11}}}}
156	lock_zkteco	zkteco	{"type": "object", "widget": "section", "title": "##Замок##", "properties": {"command": {"type": "commands", "title": "##Команды замка##", "properties": {"open_iu": {"command_type": "1", "command_value": "1", "command_number": "$$resourceNumber$$", "title": "##Открыть (разблокировать) ИУ##", "command_param": {"type": "object", "widget": "combotime", "title": "##Время##", "properties": {"selector": {"type": "select", "widget": "select", "enum": [1, 255], "enumNames": ["##Время прохода##", "##Бесконечность##"], "default": 1}}}}, "close_iu": {"command_type": "1", "command_value": "0", "command_number": "$$resourceNumber$$", "title": "##Закрыть (заблокировать) ИУ##"}, "reset_alarm": {"type": "object", "command_type": "4", "command_value": "0", "command_number": "$$resourceNumber$$", "widget": "button", "title": "##Снять тревогу##"}}}, "door_sensor": {"type": "select", "title": "##Датчик двери##", "enum": [1, 2], "enumNames": ["##Нормально замкнут##", "##Нормально разомкнут##"], "default": 1}, "max_unblock_time": {"type": "object", "widget": "combotime", "title": "##Предельное время открытия двери##", "properties": {"selector": {"type": "select", "widget": "select", "enum": [1], "enumNames": ["##Секунды##"], "default": 1, "dependencies": {"1": [{"item": "$$selfLink$$.max_unblock_time.input", "props": {"visible": true}}]}}, "input": {"type": "string", "default": 8, "visible": false, "validator": {"pattern": "number", "min": 1, "max": 99}}}}, "block_after_close": {"type": "boolean", "title": "##Блокировать дверь после закрытия##", "default": false}, "hold_time": {"type": "object", "widget": "combotime", "title": "##Время открытия двери##", "properties": {"selector": {"type": "select", "widget": "select", "enum": [1], "enumNames": ["##Секунды##"], "default": 1, "dependencies": {"1": [{"item": "$$selfLink$$.hold_time.input", "props": {"visible": true}}]}}, "input": {"type": "string", "default": 4, "visible": false, "validator": {"pattern": "number", "min": 1, "max": 251}}}}, "controller_pdu": {"type": "string", "widget": "select", "title": "##Подтверждение прохода от контроллера##", "$$selectPDUcontroller": "$$"}}}
157	verify_point_zkteco	ZKTeco	{"0":{"is_hub":0,"is_active":1,"resources":{"verify_point":{"is_tab":true,"_settings":{"type":1},"_events":{"type":6}}}}}
158	verify_point_reaction_zkteco	ZKTeco	{"type": "object", "widget": "section", "title": "##Реакция на события##", "properties": {"staff": {"type": "object", "widget": "section", "title": "##События при проходе сотрудников##", "properties": {"pass_allowed": {"type": "object", "widget": "container", "title": "##Проход##", "properties": {"watch": {"type": "select", "enum": [0, 1], "enumNames": ["##Не отслеживать##", "##Отслеживать##"], "default": 1, "dependencies": {"0": [{"item": "$$selfLink$$.staff.pass_allowed.video", "props": {"visible": false}}, {"item": "$$selfLink$$.staff.pass_allowed.verify", "props": {"visible": false}}, {"item": "$$selfLink$$.staff.pass_allowed.auto_confirm", "props": {"visible": false}}]}}, "video": {"type": "boolean", "title": "##Запись кадров видеокамеры##", "default": false}, "verify": {"type": "select", "title": "##Верификация##", "enum": [0, 1], "enumNames": ["##Нет (режим индикации)##", "##Да (режим верификации)##"], "default": 0, "dependencies": {"0": [{"item": "$$selfLink$$.staff.pass_allowed.auto_confirm", "props": {"visible": false}}], "1": [{"item": "$$selfLink$$.staff.pass_allowed.auto_confirm", "props": {"visible": true}}]}}, "auto_confirm": {"type": "boolean", "title": "##Автоподтверждение##", "default": false}}}, "time_violation": {"type": "object", "widget": "container", "title": "##Проход с нарушением ВРЕМЕНИ##", "properties": {"watch": {"type": "select", "enum": [0, 1], "enumNames": ["##Не отслеживать##", "##Отслеживать##"], "default": 1, "dependencies": {"0": [{"item": "$$selfLink$$.staff.time_violation.video", "props": {"visible": false}}]}}, "video": {"type": "boolean", "title": "##Запись кадров видеокамеры##", "default": false}}}}}, "visitor": {"type": "object", "widget": "section", "title": "##События при проходе посетителей##", "properties": {"pass_allowed": {"type": "object", "widget": "container", "title": "##Проход##", "properties": {"watch": {"type": "select", "enum": [0, 1], "enumNames": ["##Не отслеживать##", "##Отслеживать##"], "default": 1, "dependencies": {"0": [{"item": "$$selfLink$$.visitor.pass_allowed.video", "props": {"visible": false}}, {"item": "$$selfLink$$.visitor.pass_allowed.verify", "props": {"visible": false}}, {"item": "$$selfLink$$.visitor.pass_allowed.auto_confirm", "props": {"visible": false}}]}}, "video": {"type": "boolean", "title": "##Запись кадров видеокамеры##", "default": false}, "verify": {"type": "select", "title": "##Верификация##", "enum": [0, 1], "enumNames": ["##Нет (режим индикации)##", "##Да (режим верификации)##"], "default": 0, "dependencies": {"0": [{"item": "$$selfLink$$.visitor.pass_allowed.auto_confirm", "props": {"visible": false}}], "1": [{"item": "$$selfLink$$.visitor.pass_allowed.auto_confirm", "props": {"visible": true}}]}}, "auto_confirm": {"type": "boolean", "title": "##Автоподтверждение##", "default": false}}}, "time_violation": {"type": "object", "widget": "container", "title": "##Проход с нарушением ВРЕМЕНИ##", "properties": {"watch": {"type": "select", "enum": [0, 1], "enumNames": ["##Не отслеживать##", "##Отслеживать##"], "default": 1, "dependencies": {"0": [{"item": "$$selfLink$$.visitor.time_violation.video", "props": {"visible": false}}]}}, "video": {"type": "boolean", "title": "##Запись кадров видеокамеры##", "default": false}}}}}, "notice": {"type": "object", "widget": "section", "title": "##Уведомляющие события##", "properties": {"not_in_list": {"type": "object", "widget": "container", "title": "##Идентификатор НЕ ЗАРЕГИСТРИРОВАН##", "properties": {"watch": {"type": "select", "enum": [0, 1], "enumNames": ["##Не отслеживать##", "##Отслеживать##"], "default": 1, "dependencies": {"0": [{"item": "$$selfLink$$.notice.not_in_list.video", "props": {"visible": false}}]}}, "video": {"type": "boolean", "title": "##Запись кадров видеокамеры##", "default": false}}}}}}}
159	suprema_face	Suprema	{"0":{"is_hub":0,"resources":{"network":{"type":1},"settings":{"type":2}}},"1":{"resources":{"lock":{"type":8},"reader":{"type":12}}}}
160	reader_suprema_face	Suprema	{"type": "object", "widget": "section", "title": "##Считыватель##", "properties": {"command": {"type": "commands", "title": "##Команды считывателя##", "properties": {"set_mode_open": {"command_type": "0", "command_value": "0", "command_number": "$$resourceNumber$$", "title": "##Установить режим работы \\"Открыто\\"##"}, "set_mode_control": {"command_type": "0", "command_value": "1", "command_number": "$$resourceNumber$$", "title": "##Установить режим работы \\"Контроль\\"##"}, "set_mode_closed": {"command_type": "0", "command_value": "3", "command_number": "$$resourceNumber$$", "title": "##Установить режим работы \\"Закрыто\\"##"}}}, "security_level": {"type": "select", "title": "##Уровень безопасности##", "enum": [0, 1, 2], "enumNames": ["##Нормальный##", "##Высокий##", "##Самый высокий##"], "default": 0}, "sensitivity": {"type": "select", "title": "##Датчик движения##", "enum": [0, 1, 2, 3], "enumNames": ["##Выключен##", "##Близкий##", "##Средний##", "##Далекий##"], "default": 2}, "light_condition": {"type": "select", "title": "##Уровень освещенности##", "enum": [0, 1, 2], "enumNames": ["##Нормальный##", "##Высокий##", "##Автоматический##"], "default": 0}, "lfd_level": {"type": "select", "title": "##Защита от подделки лица##", "enum": [0, 1, 2, 3], "enumNames": ["##Выключена##", "##Уровень## 1", "##Уровень## 2", "##Уровень## 3"], "default": 0}, "wiegand_mode": {"type": "select", "title": "##Режим Wiegand##", "enum": [0, 1], "enumNames": ["##Вход##", "##Выход##"], "default": 0, "dependencies": {"1": [{"item": "$$selfLink$$.wiegand_auth", "props": {"visible": true}}]}}, "wiegand_auth": {"title": "##Использовать аутентификацию##", "type": "boolean", "visible": false, "default": true}, "ident_byte_order": {"enum": [0, 1], "type": "string", "title": "##Порядок байт в идентификаторе##", "widget": "select", "default": 0, "enumNames": ["##От старшего к младшему##", "##От младшему к старшему##"]}}}
161	verify_point_suprema	Superema	{"0":{"is_hub":0,"is_active":1,"resources":{"verify_point":{"is_tab":true,"_settings":{"type":4},"_events":{"type":5}}}}}
162	verify_point_reaction_suprema	Superema	{ "type": "object", "widget": "section", "title": "##Реакция на события##", "properties": { "staff": { "type": "object", "widget": "section", "title": "##События при проходе сотрудников##", "properties": { "pass_allowed": { "type": "object", "widget": "container", "title": "##Проход##", "properties": { "watch": { "type": "select", "enum": [ 0, 1 ], "enumNames": [ "##Не отслеживать##", "##Отслеживать##" ], "default": 1, "dependencies": { "0": [ { "item": "$$selfLink$$.staff.pass_allowed.video", "props": { "visible": false } } ] } }, "video": { "type": "boolean", "title": "##Запись кадров видеокамеры##", "default": false } } }, "time_violation": { "type": "object", "widget": "container", "title": "##Проход с нарушением ВРЕМЕНИ##", "properties": { "watch": { "type": "select", "enum": [ 0, 1 ], "enumNames": [ "##Не отслеживать##", "##Отслеживать##" ], "default": 1, "dependencies": { "0": [ { "item": "$$selfLink$$.staff.time_violation.video", "props": { "visible": false } } ] } }, "video": { "type": "boolean", "title": "##Запись кадров видеокамеры##", "default": false } } } } }, "visitor": { "type": "object", "widget": "section", "title": "##События при проходе посетителей##", "properties": { "pass_allowed": { "type": "object", "widget": "container", "title": "##Проход##", "properties": { "watch": { "type": "select", "enum": [ 0, 1 ], "enumNames": [ "##Не отслеживать##", "##Отслеживать##" ], "default": 1, "dependencies": { "0": [ { "item": "$$selfLink$$.visitor.pass_allowed.video", "props": { "visible": false } } ] } }, "video": { "type": "boolean", "title": "##Запись кадров видеокамеры##", "default": false } } }, "time_violation": { "type": "object", "widget": "container", "title": "##Проход с нарушением ВРЕМЕНИ##", "properties": { "watch": { "type": "select", "enum": [ 0, 1 ], "enumNames": [ "##Не отслеживать##", "##Отслеживать##" ], "default": 1, "dependencies": { "0": [ { "item": "$$selfLink$$.visitor.time_violation.video", "props": { "visible": false } } ] } }, "video": { "type": "boolean", "title": "##Запись кадров видеокамеры##", "default": false } } } } }, "notice": { "type": "object", "widget": "section", "title": "##Уведомляющие события##", "properties": { "not_in_list": { "type": "object", "widget": "container", "title": "##Идентификатор НЕ ЗАРЕГИСТРИРОВАН##", "properties": { "watch": { "type": "select", "enum": [ 0, 1 ], "enumNames": [ "##Не отслеживать##", "##Отслеживать##" ], "default": 1, "dependencies": { "0": [ { "item": "$$selfLink$$.notice.not_in_list.video", "props": { "visible": false } } ] } }, "video": { "type": "boolean", "title": "##Запись кадров видеокамеры##", "default": false } } }, "ban": { "type": "object", "widget": "container", "title": "##Идентификатор ЗАБЛОКИРОВАН##", "properties": { "watch": { "type": "select", "enum": [ 0, 1 ], "enumNames": [ "##Не отслеживать##", "##Отслеживать##" ], "default": 1, "dependencies": { "0": [ { "item": "$$selfLink$$.notice.ban.video", "props": { "visible": false } } ] } }, "video": { "type": "boolean", "title": "##Запись кадров видеокамеры##", "default": false } } }, "ended_duration": { "type": "object", "widget": "container", "title": "##Идентификатор ПРОСРОЧЕН##", "properties": { "watch": { "type": "select", "enum": [ 0, 1 ], "enumNames": [ "##Не отслеживать##", "##Отслеживать##" ], "default": 1, "dependencies": { "0": [ { "item": "$$selfLink$$.notice.ended_duration.video", "props": { "visible": false } } ] } }, "video": { "type": "boolean", "title": "##Запись кадров видеокамеры##", "default": false } } } } } } }
163	camera_trassir	TRASSIR	{"0":{"is_hub":0,"resources":{"camera":{"title":"##Тест##","is_tab":true,"_about":{"type":6},"_video":{"type":7}},"reader":{"type":13}}}}
164	server_trassir	TRASSIR	{"0":{"is_hub":0,"resources":{"network":{"type":2}}}}
165	network_trassir	TRASSIR	{"type": "object", "widget": "section", "expandable": true, "title": "##Сеть##", "properties": {"ip_address": {"type": "string", "title": "##IP-адрес##", "default": "", "validator": {"pattern": "ip-address"}}, "port_server": {"type": "string", "title": "##Порт сервера##", "default": "8089"}, "port_stream_http": {"type": "string", "title": "##Порт потокового вещания HTTP##", "default": "555"}, "sdk_password": {"type": "password", "title": "##Пароль SDK##", "default": ""}, "user_login": {"type": "string", "title": "##Логин оператора##", "default": ""}, "user_password": {"type": "password", "title": "##Пароль оператора##", "default": ""}}}
166	camera_about_trassir	TRASSIR	{"type": "object", "widget": "section", "title": "##О камере##", "properties": {"camera_model": {"type": "string", "title": "##Модель##", "default": "", "readonly": true}}}
167	camera_video_trassir	TRASSIR	{"type": "object", "widget": "section", "title": "##Видео##", "properties": {"command": {"type": "object", "widget": "commands", "title": "##Управление камерой##", "properties": {"record_on": {"type": "object", "command_type": "18", "command_value": "1", "command_number": "$$resourceNumber$$", "widget": "button", "title": "##Включить запись##"}, "record_off": {"type": "object", "command_type": "18", "command_value": "0", "command_number": "$$resourceNumber$$", "widget": "button", "title": "##Выключить запись##"}, "screenshot": {"type": "object", "command_type": "19", "command_value": "0", "command_number": "$$resourceNumber$$", "widget": "button", "title": "##Сохранить снимок##"}, "video_archive": {"type": "object", "command_type": "20", "command_value": "0", "command_number": "$$resourceNumber$$", "widget": "button", "title": "##Просмотр архива##"}}}, "camera_video": {"type": "object", "widget": "camera"}}}
177	lock_bolid_zone	Bolid	{"type": "object", "widget": "section", "title": "##Зона##", "properties": {"command": {"type": "object", "widget": "commands", "title": "##Управление зонами##", "htmlClass": "wide", "properties": {"guard_on": {"type": "object", "command_type": "5", "command_value": "1", "command_number": "$$resourceNumber$$", "widget": "button", "title": "##Поставить на охрану##"}, "guard_off": {"type": "object", "command_type": "5", "command_value": "0", "command_number": "$$resourceNumber$$", "widget": "button", "title": "##Снять с охраны##"}}}, "sub_type": {"type": "string", "widget": "select", "title": "##Вид отображения на плане##", "enum": [0, 1, 2, 3, 4, 5], "enumNames": ["##охранный датчик##", "##охранный датчик геркон##", "##охранный датчик ИК##", "##пожарный датчик##", "##пожарный датчик дымовой##", "##пожарный датчик ручной##"], "default": 0}, "control_enable": {"type": "boolean", "title": "##Управление разрешено##", "default": true}}}
168	reader_trassir	TRASSIR	{"type": "object", "widget": "section", "title": "##Распознавание##", "properties": {"face_recognition": {"title": "##Распознавание по лицу##", "type": "boolean", "default": true}, "car_recognition": {"title": "##Распознавание по номеру ТС##", "type": "boolean", "visible": true, "default": true, "dependencies": {"false": [{"item": "$$selfLink$$.car_lane", "props": {"visible": false}}, {"item": "$$selfLink$$.car_direction", "props": {"visible": false}}]}}, "car_lane": {"type": "string", "title": "##Полоса движения ТС##", "min": 0, "max": 255, "default": "", "validator": {"pattern": "number", "min": 0, "max": 255}}, "car_direction": {"type": "string", "widget": "select", "title": "##Направление движения ТС##", "enum": [0, 1, 2], "enumNames": ["##Любое##", "##Вверх##", "##Вниз##"], "default": 0}, "time_control_staff": {"type": "string", "widget": "select", "title": "##Контроль времени для сотрудников##", "enum": [0, 1, 2], "enumNames": ["##Нет##", "##Мягкий##", "##Жесткий##"], "default": 0}, "time_control_visitors": {"type": "string", "widget": "select", "title": "##Контроль времени для посетителей##", "enum": [0, 1, 2], "enumNames": ["##Нет##", "##Мягкий##", "##Жесткий##"], "default": 0}, "controller": {"type": "string", "widget": "select", "title": "##Назначение доступа контроллеру##", "$$selectPDUcontroller": "$$"}, "direction": {"type": "string", "widget": "select", "title": "##Направление прохода##", "enum": [1, 2], "enumNames": ["##Направление## 1", "##Направление## 2"], "default": 1}}}
169	verify_point_trassir	TRASSIR	{"0":{"is_hub":0,"is_active":1,"resources":{"verify_point":{"is_tab":true,"_settings":{"type":8},"_events":{"type":7}}}}}
170	verify_point_settings_trassir	TRASSIR	{"type": "object", "widget": "section", "title": "##Параметры точки верификации##", "properties": {"info": {"type": "object", "widget": "section", "title": "##Параметры отображения информации##", "properties": {"info_time_type": {"type": "select", "title": "##Отображение информации (в течение какого времени после прохода (или другого события) будет отображаться информация о проходе/событии)##", "enum": [2, 1], "enumNames": ["##Постоянно##", "##Не более чем##"], "default": 1, "dependencies": {"2": [{"item": "$$selfLink$$.info.info_time", "props": {"visible": false}}]}}, "info_time": {"type": "string", "title": "##Значение (секунд, 2 - 120)##", "default": 2, "validator": {"pattern": "number", "min": 2, "max": 120}}, "verify_timeout": {"type": "object", "widget": "combotime", "title": "##Таймаут верификации (время, в течение которого контроллер, отправивший запрос на верификацию, будет ожидать ответа оператора)##", "properties": {"selector": {"type": "select", "enum": [1, 2], "enumNames": ["##Секунды##", "##Бесконечность##"], "default": 1, "dependencies": {"2": [{"item": "$$selfLink$$.info.verify_timeout.input", "props": {"visible": false}}]}}, "input": {"type": "string", "default": 5, "validator": {"pattern": "number", "min": 1, "max": 255}}}}}}, "video": {"type": "object", "widget": "section", "title": "##Параметры видеозаписи##", "properties": {"pre_recording_time": {"type": "string", "title": "##Продолжительность предзаписи (секунд)##", "default": 8, "validator": {"max": 255, "pattern": "number"}}, "record_time": {"type": "string", "title": "##Продолжительность записи (секунд)##", "default": 6, "validator": {"max": 255, "pattern": "number"}}, "frame_rate": {"type": "string", "title": "##Количество кадров в секунду при просмотре##", "default": 2, "validator": {"pattern": "number", "max": 10}}}}}}
171	verify_point_reaction_trassir	TRASSIR	{"type": "object", "widget": "section", "title": "##Реакция на события##", "properties": {"staff": {"type": "object", "widget": "section", "title": "##События при проходе сотрудников##", "properties": {"pass_allowed": {"type": "object", "widget": "container", "title": "##Проход##", "properties": {"watch": {"type": "select", "enum": [0, 1], "enumNames": ["##Не отслеживать##", "##Отслеживать##"], "default": 1, "dependencies": {"0": [{"item": "$$selfLink$$.staff.pass_allowed.video", "props": {"visible": false}}, {"item": "$$selfLink$$.staff.pass_allowed.verify", "props": {"visible": false}}, {"item": "$$selfLink$$.staff.pass_allowed.auto_confirm", "props": {"visible": false}}]}}, "video": {"type": "boolean", "title": "##Запись кадров видеокамеры##", "default": false}, "verify": {"type": "select", "title": "##Верификация##", "enum": [0, 1], "enumNames": ["##Нет (режим индикации)##", "##Да (режим верификации)##"], "default": 0, "dependencies": {"0": [{"item": "$$selfLink$$.staff.pass_allowed.auto_confirm", "props": {"visible": false}}], "1": [{"item": "$$selfLink$$.staff.pass_allowed.auto_confirm", "props": {"visible": true}}]}}, "auto_confirm": {"type": "boolean", "title": "##Автоподтверждение##", "default": false}}}, "time_violation": {"type": "object", "widget": "container", "title": "##Проход с нарушением ВРЕМЕНИ##", "properties": {"watch": {"type": "select", "enum": [0, 1], "enumNames": ["##Не отслеживать##", "##Отслеживать##"], "default": 1, "dependencies": {"0": [{"item": "$$selfLink$$.staff.time_violation.video", "props": {"visible": false}}, {"item": "$$selfLink$$.staff.time_violation.verify", "props": {"visible": false}}, {"item": "$$selfLink$$.staff.time_violation.auto_confirm", "props": {"visible": false}}]}}, "video": {"type": "boolean", "title": "##Запись кадров видеокамеры##", "default": false}, "verify": {"type": "select", "title": "##Верификация##", "enum": [0, 1], "enumNames": ["##Нет (режим индикации)##", "##Да (режим верификации)##"], "default": 0, "dependencies": {"0": [{"item": "$$selfLink$$.staff.time_violation.auto_confirm", "props": {"visible": false}}], "1": [{"item": "$$selfLink$$.staff.time_violation.auto_confirm", "props": {"visible": true}}]}}, "auto_confirm": {"type": "boolean", "title": "##Автоподтверждение##", "default": false}}}}}, "visitor": {"type": "object", "widget": "section", "title": "##События при проходе посетителей##", "properties": {"pass_allowed": {"type": "object", "widget": "container", "title": "##Проход##", "properties": {"watch": {"type": "select", "enum": [0, 1], "enumNames": ["##Не отслеживать##", "##Отслеживать##"], "default": 1, "dependencies": {"0": [{"item": "$$selfLink$$.visitor.pass_allowed.video", "props": {"visible": false}}, {"item": "$$selfLink$$.visitor.pass_allowed.verify", "props": {"visible": false}}, {"item": "$$selfLink$$.visitor.pass_allowed.auto_confirm", "props": {"visible": false}}]}}, "video": {"type": "boolean", "title": "##Запись кадров видеокамеры##", "default": false}, "verify": {"type": "select", "title": "##Верификация##", "enum": [0, 1], "enumNames": ["##Нет (режим индикации)##", "##Да (режим верификации)##"], "default": 0, "dependencies": {"0": [{"item": "$$selfLink$$.visitor.pass_allowed.auto_confirm", "props": {"visible": false}}], "1": [{"item": "$$selfLink$$.visitor.pass_allowed.auto_confirm", "props": {"visible": true}}]}}, "auto_confirm": {"type": "boolean", "title": "##Автоподтверждение##", "default": false}}}, "time_violation": {"type": "object", "widget": "container", "title": "##Проход с нарушением ВРЕМЕНИ##", "properties": {"watch": {"type": "select", "enum": [0, 1], "enumNames": ["##Не отслеживать##", "##Отслеживать##"], "default": 1, "dependencies": {"0": [{"item": "$$selfLink$$.visitor.time_violation.video", "props": {"visible": false}}, {"item": "$$selfLink$$.visitor.time_violation.verify", "props": {"visible": false}}, {"item": "$$selfLink$$.visitor.time_violation.auto_confirm", "props": {"visible": false}}]}}, "video": {"type": "boolean", "title": "##Запись кадров видеокамеры##", "default": false}, "verify": {"type": "select", "title": "##Верификация##", "enum": [0, 1], "enumNames": ["##Нет (режим индикации)##", "##Да (режим верификации)##"], "default": 0, "dependencies": {"0": [{"item": "$$selfLink$$.visitor.time_violation.auto_confirm", "props": {"visible": false}}], "1": [{"item": "$$selfLink$$.visitor.time_violation.auto_confirm", "props": {"visible": true}}]}}, "auto_confirm": {"type": "boolean", "title": "##Автоподтверждение##", "default": false}}}}}, "notice": {"type": "object", "widget": "section", "title": "##Уведомляющие события##", "properties": {"ban": {"type": "object", "widget": "container", "title": "##Идентификатор ЗАБЛОКИРОВАН##", "properties": {"watch": {"type": "select", "enum": [0, 1], "enumNames": ["##Не отслеживать##", "##Отслеживать##"], "default": 1, "dependencies": {"0": [{"item": "$$selfLink$$.notice.ban.video", "props": {"visible": false}}]}}, "video": {"type": "boolean", "title": "##Запись кадров видеокамеры##", "default": false}}}, "ended_duration": {"type": "object", "widget": "container", "title": "##Идентификатор ПРОСРОЧЕН##", "properties": {"watch": {"type": "select", "enum": [0, 1], "enumNames": ["##Не отслеживать##", "##Отслеживать##"], "default": 1, "dependencies": {"0": [{"item": "$$selfLink$$.notice.ended_duration.video", "props": {"visible": false}}]}}, "video": {"type": "boolean", "title": "##Запись кадров видеокамеры##", "default": false}}}}}}}
172	lock_cl201	CL201	{"type": "object", "widget": "section", "title": "##ИУ##", "properties": {"command": {"type": "object", "widget": "commands", "title": "##Управление охранными зонами##", "properties": {"guard_on": {"type": "object", "command_type": "5", "command_value": "1", "command_number": "$$resourceNumber$$", "widget": "button", "title": "##Поставить на охрану##"}, "guard_off": {"type": "object", "command_type": "5", "command_value": "0", "command_number": "$$resourceNumber$$", "widget": "button", "title": "##Снять с охраны##"}, "reset_alarm": {"type": "object", "command_type": "4", "command_value": "0", "command_number": "$$resourceNumber$$", "widget": "button", "title": "##Снять тревогу##"}, "clear_spatial_zones": {"type": "object", "command_type": "6", "command_value": "0", "command_number": "$$resourceNumber$$", "widget": "button", "title": "##Сбросить зональность##"}}}, "algorithm": {"type": "string", "widget": "select", "title": "##Алгоритм##", "enum": [1], "enumNames": ["##Замок##"], "default": 1}, "check_pass_presentation_id": {"type": "boolean", "title": "##Регистрация прохода по предъявлению идентификатора##", "default": false}, "hold_time": {"type": "object", "widget": "combotime", "title": "##Время удержания в разблокированном состоянии (время анализа идентификатора)##", "properties": {"selector": {"type": "select", "widget": "select", "enum": [1, 2], "enumNames": ["##Секунды##", "##Бесконечность##"], "default": 1, "dependencies": {"1": [{"item": "$$selfLink$$.hold_time.input", "props": {"visible": true}}]}}, "input": {"type": "string", "default": 8, "visible": false, "validator": {"pattern": "number", "min": 1, "max": 251}}}}, "max_unblock_time": {"type": "object", "widget": "combotime", "title": "##Предельное время разблокировки##", "properties": {"selector": {"type": "select", "widget": "select", "enum": [0, 1, 2], "enumNames": ["##Миллисекунды##", "##Секунды##", "##Бесконечность##"], "default": 1, "dependencies": {"0": [{"item": "$$selfLink$$.max_unblock_time.select", "props": {"visible": true}}], "1": [{"item": "$$selfLink$$.max_unblock_time.input", "props": {"visible": true}}]}}, "input": {"type": "string", "default": 8, "visible": false, "validator": {"pattern": "number", "min": 1, "max": 251}}, "select": {"type": "string", "widget": "select", "visible": false, "enum": [0, 1, 2], "enumNames": ["250", "500", "750"], "default": 0}}}, "operation_mode_control_output_iu": {"type": "string", "widget": "select", "enum": [1, 0], "enumNames": ["##Потенциальный##", "##Импульсный##"], "title": "##Режим работы выхода управления ИУ##", "default": 1, "dependencies": {"0": [{"item": "$$selfLink$$.control_pulse_time", "props": {"visible": true}}]}}, "control_pulse_time": {"type": "string", "widget": "select", "title": "##Длительность импульса управления ИУ (миллисекунд)##", "enum": [250, 500, 750], "enumNames": ["250", "500", "750"], "default": 500}, "normalization_iu_output": {"type": "string", "widget": "select", "enum": [0, 1], "enumNames": ["##После \\"Открытия\\"##", "##После \\"Закрытия\\"##"], "title": "##Нормализация выхода ИУ##", "default": 0}, "normal_iu_input_state": {"type": "string", "widget": "select", "enum": [0, 1], "enumNames": ["##Замкнут##", "##Разомкнут##"], "title": "##Нормальное состояние входа ИУ##", "default": 0}, "normal_iu_output_state": {"type": "string", "widget": "select", "enum": [0, 1], "enumNames": ["##Не запитан##", "##Запитан##"], "title": "##Нормальное состояние выхода управления ИУ##", "default": 0}, "fire_alarm_reaction": {"type": "string", "widget": "select", "title": "##Реакция на Fire alarm в режиме работы \\"Охрана\\"##", "enum": [0, 1], "enumNames": ["##Блокировать ИУ##", "##Разблокировать ИУ##"], "default": 1}, "guard_identify_time": {"type": "object", "widget": "combotime", "title": "##Время идентификации постановки/снятия РКД \\"Охрана\\"##", "properties": {"selector": {"type": "select", "widget": "select", "enum": [1, 2], "enumNames": ["##Секунды##", "##Бесконечность##"], "default": 1, "dependencies": {"1": [{"item": "$$selfLink$$.guard_identify_time.input", "props": {"visible": true}}]}}, "input": {"type": "string", "default": 8, "visible": false, "validator": {"pattern": "number", "min": 1, "max": 251}}}}, "is_antipass": {"type": "boolean", "title": "##Внутренняя защита от передачи идентификаторов (Local Antipass)##", "default": false}}}
173	bolid_system	Bolid system	{"0":{"is_hub":0,"resources":{"network":{"type":3}}}}
174	bolid_zone	Bolid zone	{"0":{"is_hub":0,"resources":{}},"1":{"resources":{"lock":{"type":14}}}}
175	bolid_relay	Bolid relay	{"0":{"is_hub":0,"resources":{}},"1":{"resources":{"lock":{"type":15}}}}
176	network_bolid	Bolid	{"type": "object", "widget": "section", "expandable": true, "title": "##Настройка##", "properties": {"command": {"type": "commands", "title": "##Конфигурация##", "htmlClass": "wide", "properties": {"add_zone": {"command_type": "23", "command_value": "6001", "command_number": "0", "title": "##Добавить зону##"}, "add_relay": {"command_type": "23", "command_value": "6002", "command_number": "0", "title": "##Добавить реле##"}, "import_config": {"command_type": "24", "command_value": "6000", "command_number": "0", "title": "##Импортировать##"}}}, "device_address": {"type": "string", "title": "##Адрес прибора C2000-ПП##", "default": "1"}, "connect_type": {"type": "string", "widget": "select", "title": "##Тип подключения прибора C2000-ПП##", "enum": [2, 3], "enumNames": ["C2000-Ethernet", "##Шлюз## ModBus TCP"], "default": 2}, "ip_address": {"type": "string", "title": "##IP-адрес##", "default": "", "validator": {"pattern": "ip-address"}}, "port": {"type": "string", "title": "##Порт##", "default": "40000"}}}
178	lock_bolid_relay	Bolid	{"type": "object", "widget": "section", "title": "##Реле##", "properties": {"command": {"type": "object", "widget": "commands", "title": "##Управление реле##", "htmlClass": "wide", "properties": {"relay_on": {"type": "object", "command_type": "1", "command_value": "1", "command_number": "$$resourceNumber$$", "widget": "button", "title": "##Включить##"}, "relay_off": {"type": "object", "command_type": "1", "command_value": "0", "command_number": "$$resourceNumber$$", "widget": "button", "title": "##Выключить##"}}}, "control_enable": {"type": "boolean", "title": "##Управление разрешено##", "default": true}}}
180	device_type_30	\N	{"0":{"is_hub":1,"resources":{"input":{"1":{"type":1},"2":{"type":1}},"output":{"3":{"type":1},"4":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"device_type":403,"comission_card_count":192},"3":{"device_type":401,"comission_card_count":64},"4":{"device_type":401,"comission_card_count":64},"5":{"device_type":401,"comission_card_count":64},"6":{"device_type":401,"comission_card_count":64},"7":{"device_type":401,"comission_card_count":64},"8":{"device_type":401,"comission_card_count":64},"9":{"device_type":401,"comission_card_count":64},"10":{"device_type":401,"comission_card_count":64}}
181	device_type_72	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"3":{"type":7},"4":{"type":7},"5":{"type":7},"6":{"type":7}},"output":{"3":{"type":1},"4":{"type":1},"5":{"type":1},"6":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":605,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
182	device_type_73	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"4":{"type":7},"6":{"type":7}},"output":{"4":{"type":1},"5":{"type":1},"6":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":605,"comission_card_count":192},"3":{"is_active":1,"device_type":602,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
183	device_type_74	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"output":{"5":{"type":1},"6":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":605,"comission_card_count":192},"3":{"is_active":1,"device_type":602,"comission_card_count":192},"4":{"is_active":1,"device_type":602,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
184	device_type_75	\N	{"0":{"is_hub":1,"is_active":1,"resources":{"input":{"4":{"type":7},"6":{"type":7}},"output":{"4":{"type":1},"5":{"type":1},"6":{"type":1}},"network":{"type":1},"hw_state":{"type":1},"settings":{"type":1},"connection":{"type":1}}},"1":{"is_active":1,"device_type":605,"comission_card_count":192},"3":{"is_active":1,"device_type":601,"comission_card_count":192},"5":{"is_active":1,"device_type":402,"comission_card_count":64},"6":{"is_active":1,"device_type":402,"comission_card_count":64},"7":{"is_active":1,"device_type":402,"comission_card_count":64},"8":{"is_active":1,"device_type":402,"comission_card_count":64},"9":{"is_active":1,"device_type":402,"comission_card_count":64},"10":{"is_active":1,"device_type":402,"comission_card_count":64},"11":{"is_active":1,"device_type":402,"comission_card_count":64},"12":{"is_active":1,"device_type":402,"comission_card_count":64}}
185	device_type_403	\N	{"resources":{"lock":{"type":16},"reader":{"1":{"type":1},"2":{"type":1}},"alarm_gen":{"type":1}}}
186	device_type_605	\N	{"resources":{"lock":{"type":16},"reader":{"1":{"type":10},"2":{"type":10}},"alarm_gen":{"type":1}}}
187	lock_barrier	\N	{"type": "object", "widget": "section", "title": "##Шлагбаум##", "properties": {"command": {"type": "object", "widget": "commands", "title": "##Управление ИУ##", "properties": {"clear_spatial_zones": {"type": "object", "command_type": "6", "command_value": "0", "command_number": "$$resourceNumber$$", "widget": "button", "title": "##Сбросить зональность##"}}}, "normal_state_contact_input_iu": {"type": "string", "widget": "select", "enum": [0, 1], "enumNames": ["##Нормально разомкнут##", "##Нормально замкнут##"], "title": "##Нормальное (т.е. заблокированное) состояние контакта (вход ИУ)##", "default": 1}, "normal_state_closed_exit_iu": {"type": "string", "widget": "select", "enum": [0, 1], "enumNames": ["##Не запитан##", "##Запитан##"], "title": "##Нормальное состояние \\"Закрыто\\" выхода ИУ##", "default": 0}, "normalization_iu_output": {"type": "string", "widget": "select", "enum": [0, 1], "enumNames": ["##После \\"Открытия\\"##", "##После \\"Закрытия\\"##"], "title": "##Нормализация выхода ИУ##", "default": 0}, "max_unblock_time": {"type": "object", "widget": "combotime", "title": "##Предельное время разблокировки##", "properties": {"selector": {"type": "select", "widget": "select", "enum": [0, 1, 2], "enumNames": ["##Миллисекунды##", "##Секунды##", "##Бесконечность##"], "default": 1, "dependencies": {"0": [{"item": "$$selfLink$$.max_unblock_time.select", "props": {"visible": true}}], "1": [{"item": "$$selfLink$$.max_unblock_time.input", "props": {"visible": true}}]}}, "input": {"type": "string", "default": 8, "visible": false, "validator": {"pattern": "number", "min": 1, "max": 251}}, "select": {"type": "string", "widget": "select", "visible": false, "enum": [0, 1, 2], "enumNames": ["250", "500", "750"], "default": 0}}}, "hold_time": {"type": "object", "widget": "combotime", "title": "##Задержка на закрытие шлагбаума##", "properties": {"selector": {"type": "select", "widget": "select", "enum": [0, 1], "enumNames": ["##Миллисекунды##", "##Секунды##"], "default": 1, "dependencies": {"0": [{"item": "$$selfLink$$.hold_time.select", "props": {"visible": true}}], "1": [{"item": "$$selfLink$$.hold_time.input", "props": {"visible": true}}]}}, "input": {"type": "string", "default": 8, "visible": false, "validator": {"pattern": "number", "min": 1, "max": 251}}, "select": {"type": "string", "widget": "select", "visible": false, "enum": [0, 1, 2], "enumNames": ["250", "500", "750"], "default": 0}}}, "comission_time": {"type": "object", "widget": "combotime", "title": "##Время ожидания комиссионирования##", "properties": {"selector": {"type": "string", "widget": "select", "enum": [3, 4], "enumNames": ["##Секунды##", "##Минуты##"], "default": 3, "dependencies": {"3": [{"item": "$$selfLink$$.comission_time.select", "props": {"visible": true}}], "4": [{"item": "$$selfLink$$.comission_time.input", "props": {"visible": true}}]}}, "select": {"type": "string", "widget": "select", "visible": false, "enum": [0, 1, 2], "enumNames": ["15", "30", "45"], "default": 1}, "input": {"type": "string", "default": 1, "visible": false, "validator": {"pattern": "number", "min": 1, "max": 12}}}}, "check_pass_presentation_id": {"type": "boolean", "title": "##Отсутствие датчика проезда##", "default": false}, "is_antipass": {"type": "boolean", "title": "##Внутренняя защита от передачи идентификаторов (Local Antipass)##", "default": false}}}
188	reader_trassir_s30	TRASSIR s30	{"type": "object", "widget": "section", "title": "$$optionsName$$", "link": "$$selfLink$$", "properties": {"controller": {"type": "string", "widget": "select", "title": "##Контроллер##", "default": "$$optionsHardNumbers$$", "$$childControllersSelector$$": "$$"}, "direction": {"type": "string", "widget": "select", "title": "##Направление##", "enum": [], "enumNames": [], "default": "$$optionsDir$$"}, "channel": {"type": "string", "widget": "select", "title": "##Видеокамера## TRASSIR", "$$selectTrassirChannel": "$$"}, "lane": {"type": "string", "title": "##Полоса движения ТС##", "default": "1"}, "motion": {"type": "select", "title": "##Направление движения ТС##", "enum": ["both", "forward", "backward"], "enumNames": ["##Любое##", "##Вниз##", "##Вверх##"], "default": "both"}}}
\.


--
-- Data for Name: device_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.device_type (id, device_type, name, is_off, device_vendor, schema_title) FROM stdin;
0	0	##Общие настройки##	\N	0	common_settings
1	16	##Контроллер замка## CL05	\N	0	device_type_cl05_0
2	17	##ЛИКОН##	\N	0	device_type_17
3	18	##Контроллер турникета## CT/L04 [1]	\N	0	device_type_18
4	19	##Контроллер турникета## CT/L04 [1+8]	\N	0	device_type_19
5	20	##Контроллер замка## CT/L04 [1]	\N	0	device_type_20
6	21	##Контроллер замка## CT/L04 [1+8]	\N	0	device_type_21
7	22	##Контроллер замка## CT/L04 [2+8]	\N	0	device_type_22
8	23	##Электронная проходная## KT02.3 [1]	\N	0	device_type_18
9	24	##Электронная проходная## KT02.3 [1+8]	\N	0	device_type_19
10	25	##Электронная проходная## KR05 [1]	\N	0	device_type_18
11	26	##Электронная проходная## KR05 [1+8]	\N	0	device_type_19
12	27	##Электронная проходная с картоприёмником## КТС01.3 [1]	\N	0	device_type_18
13	28	##Электронная проходная с картоприёмником## КТС01.3 [1+8]	\N	0	device_type_19
14	29	##Контроллер АТП## CT/L04 [1]	\N	0	device_type_29
15	30	##Контроллер АТП## CT/L04 [1+8]	\N	0	device_type_30
32	32	##Электронная проходная## KT05.3A [1]	\N	0	device_type_18
33	33	##Электронная проходная## KT05.3A [1+8]	\N	0	device_type_19
34	34	##Электронная проходная с картоприемником## KTC01.3A [1]	\N	0	device_type_18
35	35	##Электронная проходная с картоприемником## KTC01.3A [1+8]	\N	0	device_type_19
36	36	##Контроллер замка## CL05.1	\N	0	device_type_cl05
64	64	##Контроллер замка## CL05.2	\N	0	device_type_cl05
65	65	##ЛИКОН## 2	\N	0	device_type_65
67	67	##Контроллер турникета## CT/L04.2	\N	0	device_type_67
68	68	##Контроллер турникета## CT/L04.2	\N	0	device_type_68
69	69	##Контроллер турникета## CT/L04.2	\N	0	device_type_69
70	70	##Контроллер турникета## CT/L04.2	\N	0	device_type_70
71	71	##Электронная проходная## KR05	\N	0	device_type_67
72	72	##Контроллер АТП## CT/L04.2	\N	0	device_type_72
73	73	##Контроллер АТП## CT/L04.2	\N	0	device_type_73
74	74	##Контроллер АТП## CT/L04.2	\N	0	device_type_74
75	75	##Контроллер АТП## CT/L04.2	\N	0	device_type_75
76	76	##Контроллер замка## CT/L04.2	\N	0	device_type_76
77	77	##Контроллер замка## CT/L04.2	\N	0	device_type_77
78	78	##Контроллер замка## CT/L04.2	\N	0	device_type_78
79	79	##Контроллер замка## CT/L04.2	\N	0	device_type_79
80	80	##Контроллер замка## CT/L04.2	\N	0	device_type_80
81	81	##Контроллер замка## CT/L04.2	\N	0	device_type_81
82	82	##Контроллер замка## CT/L04.2	\N	0	device_type_82
83	83	##Контроллер замка## CT/L04.2	\N	0	device_type_83
84	84	##Контроллер замка## CT/L04.2	\N	0	device_type_84
85	85	##Контроллер замка## CT/L04.2	\N	0	device_type_85
86	86	##Контроллер замка## CT/L04.2	\N	0	device_type_86
87	87	##Контроллер замка## CT/L04.2	\N	0	device_type_87
88	88	##Контроллер замка## CT/L04.2	\N	0	device_type_88
89	89	##Контроллер замка## CT/L04.2	\N	0	device_type_89
90	90	##Контроллер замка## CT/L04.2	\N	0	device_type_90
91	91	##Контроллер замка## CT/L04.2	\N	0	device_type_91
92	92	##Контроллер замка## CT/L04.2	\N	0	device_type_92
93	93	##Электронная проходная## КТ02.x/КТ05.x	\N	0	device_type_93
94	94	##Электронная проходная KTC01.x с картоприёмником##	\N	0	device_type_94
95	95	##Электронная проходная КТ0х.A с антипаникой##	\N	0	device_type_95
96	96	##Электронная проходная КТС0х.A с картоприемником и антипаникой##	\N	0	device_type_96
97	97	##Электронная проходная## КТ02.x/КТ05.x	\N	0	device_type_93
98	98	##Электронная проходная KTC01.x с картоприёмником##	\N	0	device_type_94
99	99	##Электронная проходная КТ0х.A с антипаникой##	\N	0	device_type_95
100	100	##Электронная проходная КТС0х.A с картоприемником и антипаникой##	\N	0	device_type_96
256	256	##Контроллер замка##	\N	0	\N
400	400	##Стойка турникета##	\N	0	device_type_400
401	401	##Контроллер замка## CL201	\N	0	device_type_401
402	402	##Контроллер замка## CL201	\N	0	device_type_402
403	403	##Шлагбаум##	\N	0	device_type_403
600	600	##Контроллер замка##	\N	0	device_type_600
601	601	##Двусторонний замок##	\N	0	device_type_601
602	602	##Односторонний замок##	\N	0	device_type_602
603	603	##Контроллер турникета##	\N	0	device_type_603
604	604	##Двусторонний замок##	\N	0	device_type_604
605	605	##Шлагбаум##	\N	0	device_type_605
700	700	##Контроллер замка##	\N	0	device_type_700
901	901	##Контроллер## CТL14	\N	0	s30_ctl14
902	902	##Контроллер## CL15	\N	0	s30_cl15
903	903	##Контроллер## CR11	\N	0	s30_cr11
904	904	##Контроллер## CT13	\N	0	s30_ct13
950	950	##ЛИКОН##	\N	0	s30_child_device
951	951	##Односторонний замок##	\N	0	s30_child_device
952	952	##Двусторонний замок##	\N	0	s30_child_device
953	953	##Электронная проходная##	\N	0	s30_child_device
954	954	##Турникет##	\N	0	s30_child_device
955	955	##Шлагбаум##	\N	0	s30_child_device
956	956	##Контроллер 2-го уровня##	\N	0	s30_child_device
999	999	##Контроллер системы S20 (импорт)##	\N	0	\N
1001	1001	##Контроллер## Suprema BioEntry Plus	\N	1	suprema
1010	1010	##Контроллер## Suprema FaceStation2	\N	1	suprema_face
1013	1013	##Контроллер## Suprema BioEntry W2	\N	1	suprema
1017	1017	##Контроллер## Suprema BioEntry P2	\N	1	suprema
1025	1025	##Контроллер## Suprema FaceLite	\N	1	suprema_face
2000	2000	##Видеокамера##	\N	2	camera_onvif
2001	2001	##Видеокамера##	\N	2	camera_mjpeg
2002	2002	##Видеокамера## TRASSIR	\N	4	camera_trassir
3000	3000	##Шлюз## CТL14	\N	0	gate_ctl14
3001	3001	##Шлюз## CL15	\N	0	gate_cl15
3002	3002	##Составной объект## CL15	\N	0	object_cl15
4000	4000	##Контроллер## ZKTeco	\N	3	zkt_device
5000	5000	##Сервер## TRASSIR	\N	4	server_trassir
6000	6000	##ИСО "Орион"## (Bolid)	\N	5	bolid_system
6001	6001	##Зона##	\N	5	bolid_zone
6002	6002	##Реле##	\N	5	bolid_relay
\.


--
-- Data for Name: device_user_change; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.device_user_change (device_id, user_id, identifier, change_type) FROM stdin;
\.


--
-- Data for Name: device_vendor; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.device_vendor (id, name) FROM stdin;
5	Bolid
0	PERCo
1	Suprema
4	TRASSIR
2	Video
3	ZKTeco
\.


--
-- Data for Name: division; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.division (id, is_const, parent_id, name, comment, accompanying_id, staff_access_template_id, visitor_access_template_id, work_schedule_id, is_removed, tel) FROM stdin;
1	1	\N	##Администраторы системы##	\N	\N	\N	\N	\N	0	\N
\.


--
-- Data for Name: doc; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.doc (id, type_id, sort_id, name, char_code, digit_code, is_work_time, calc_method_id, is_holiday_overtime, is_removed) FROM stdin;
135	3	\N	##Отпуск##	\N	\N	0	1	0	0
5	1	\N	Продолжительность работы вахтовым методом	ВМ	5	1	1	0	0
7	1	\N	Повышение квалификации с отрывом от работы	ПК	7	0	1	0	0
8	1	\N	Повышение квалификации с отрывом от работы в другой местности	ПМ	8	0	1	0	0
9	1	\N	Ежегодный основной оплачиваемый отпуск	ОТ	9	0	1	0	0
10	1	\N	Ежегодный дополнительный оплачиваемый отпуск	ОД	10	0	1	0	0
11	1	\N	Дополнительный отпуск в связи с обучением с сохранением среднего заработка работникам, совмещающим работу с обучением	У	11	0	2	0	0
12	1	\N	Сокращенная продолжительность рабочего времени для обучающихся без отрыва от производства с частичным сохранением заработной платы	УВ	12	0	1	0	0
13	1	\N	Дополнительный отпуск в связи с обучением без сохранения заработной платы	УД	13	0	1	0	0
14	1	\N	Отпуск по беременности и родам (отпуск в связи с усыновлением новорожденного ребенка)	Р	14	0	2	0	0
15	1	\N	Отпуск по уходу за ребенком до достижения им возраста трех лет	ОЖ	15	0	2	0	0
17	1	\N	Отпуск без сохранения заработной платы при условиях, предусмотренных действующим  законодательством Российской Федерации	ОЗ	17	0	2	0	0
18	1	\N	Ежегодный дополнительный отпуск без сохранения заработной платы	ДБ	18	0	2	0	0
22	1	\N	Время вынужденного прогула в случае признания увольнения, перевода на другую работу или отстранения от работы незаконными с восстановлением на прежней работе	ПВ	22	0	1	0	0
23	1	\N	Невыходы на время исполнения государственных или общественных обязанностей согласно законодательству	Г	23	0	1	0	0
25	1	\N	Продолжительность работы в режиме неполного рабочего времени по инициативе работодателя в случаях, предусмотренных законодательством	НС	25	0	1	0	0
26	1	\N	Выходные дни (еженедельный отпуск) и нерабочие праздничные дни	В	26	0	2	0	0
27	1	\N	Дополнительные выходные дни (оплачиваемые)	ОВ	27	0	1	0	0
28	1	\N	Дополнительные выходные дни (без сохранения заработной платы)	НВ	28	0	1	0	0
29	1	\N	Забастовка (при условиях и в порядке, предусмотренных законом)	ЗБ	29	0	1	0	0
30	1	\N	Неявки по невыясненным причинам (до выяснения обстоятельств)	НН	30	0	1	0	0
31	1	\N	Время простоя по вине работодателя	РП	31	0	1	0	0
34	1	\N	Отстранение от работы (недопущение к работе) с оплатой (пособием) в соответствии с законодательством	НО	34	0	1	0	0
35	1	\N	Отстранение от работы (недопущение к работе) по причинам, предусмотренным законодательством, без начисления заработной платы	НБ	35	0	1	0	0
36	1	\N	Время приостановки работы в случае задержки выплаты заработной платы	НЗ	36	0	1	0	0
92	2	\N	Продолжительность сверхурочной работы	С	4	0	1	0	0
93	2	\N	Продолжительность работы в выходные и нерабочие праздничные дни	РВ	3	0	1	1	0
97	1	\N	Временная нетрудоспособность (кроме случаев, предусмотренных кодом "Т") с назначением пособия согласно законодательству	Б	19	1	1	0	0
98	1	\N	Временная нетрудоспособность без назначения пособия в случаях, предусмотренных законодательством	Т	20	0	3	0	0
99	1	\N	Время простоя по вине работника	ВП	33	0	1	0	0
100	1	\N	Время простоя по причинам, не зависящим от работодателя и работника	НП	32	0	1	0	0
105	1	\N	Отпуск без сохранения заработной платы, предоставленный работнику по разрешению работодателя	ДО	16	0	2	0	0
106	1	\N	Прогулы (отсутствие на рабочем месте без уважительных причин в течение времени, установленного законодательством)	ПР	24	0	1	0	0
107	1	\N	Служебная командировка	К	6	0	1	0	0
134	1	\N	Сокращенная продолжительность рабочего времени против нормальной продолжительности рабочего дня в случаях, предусмотренных законодательством	ЛЧ	21	0	1	0	0
136	3	\N	##Выходной день##	\N	\N	0	1	0	0
137	3	\N	##Командировка##	\N	\N	0	1	0	0
138	3	\N	##Больничный##	\N	\N	0	1	0	0
139	3	\N	##Отпуск без сохранения ЗП##	\N	\N	0	1	0	0
\.


--
-- Data for Name: doc_calc_method; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.doc_calc_method (id, name) FROM stdin;
2	##В календарных днях включая праздничные дни##
3	##В календарных днях исключая праздничные дни##
1	##В рабочих днях##
\.


--
-- Data for Name: doc_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.doc_type (id, name) FROM stdin;
3	##Объяснительная##
1	##Оправдательный##
2	##Сверхурочный##
\.


--
-- Data for Name: event; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.event (id, time_label, event_type, device_id, resource_type, resource_number, data, identifier, user_id, operator_id, access_zone_id1, access_zone_id2, description, db_time_label, comment, segment_id, time_label_utc) FROM stdin;
\.


--
-- Data for Name: event_action; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.event_action (id, name) FROM stdin;
\.


--
-- Data for Name: event_action_object; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.event_action_object (id, action_id, type_id, object_id, options) FROM stdin;
\.


--
-- Data for Name: event_action_object_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.event_action_object_type (id, name) FROM stdin;
1	событие
2	устройство
3	помещение
4	сотрудник
5	подразделение
6	команда в устройство
7	сообщение оператору
8	SMS сообщение
9	Viber сообщение
\.


--
-- Data for Name: event_action_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.event_action_type (id, name) FROM stdin;
2	sms уведомление
3	Viber уведомление
1	текстовое сообщение
\.


--
-- Data for Name: event_category; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.event_category (id, name, en_name, es_name, it_name, fr_name) FROM stdin;
1	События контроллеров	Controller events	Eventos de los controladores	Eventi dei controller	Evénements des contrôleurs
2	Действия пользователя	User activity	Actividad de usuario	Azioni dell'utente	Activités de l'utilisateur
3	События сервера	Server events	События сервера	События сервера	События сервера
4	События верификации	Verification events	Eventos de verificación	Eventi di verificazione	Evénements de vérification
5	События видеонаблюдения	Video monitoring events	Eventos de monitoreo de video	Evento di monitoraggio video	Evénement de surveillance vidéo
\.


--
-- Data for Name: event_resource_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.event_resource_type (id, name) FROM stdin;
4	##Вход##
5	##Выход##
3	##Генератор тревоги##
2	##Исполнительное устройство##
10	##Код ошибки##
11	##Лицензия##
13	##Направление##
14	##Отпечаток##
6	##Охранная зона##
8	##Причина сброса##
7	##Ресурс##
15	##Сообщение##
1	##Считыватель##
12	##Точка верификации##
9	##Шаблон верификации##
\.


--
-- Data for Name: event_subcategory; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.event_subcategory (id, event_category_id, name, en_name, fr_name, es_name, it_name) FROM stdin;
1	1	События, связанные с доступом по коду идентификатора	Events connected with an access by identifier's code	Evénements liés à l'accès par le code d'identifiant	Eventos relacionados con acceso según código de identificador	Eventi legati all'accesso sul codice di identificatore
2	1	События, связанные с Тревогой, ОЗ и ШС	Events connected with protected zone state	Evénements liés au changement d'état de la zone protégée	Eventos relacionados con cambios de estados de la zona protegida	Eventi legati al cambiamento degli stati della zona di protezione
4	1	События, связанные с состояниями входов/выходов	Events connected with inputs/outputs state	Evénements liés à l'état des entrées/sorties	Eventos relacionados con estados entrada/salida	Eventi legati allo stato di input/output
5	1	События, связанные с проходами через ИУ без идентификаторов	Events connected with passaged through operating device without identifiers	Evénements liés aux passages par le dispositif sans identifiants	Eventos relacionados con pasos a través de dispositivo sin identificadores	Eventi legati ai passaggi a traverso il dispositivo esecutivo senza identificatori
6	1	События, связанные с функционированием	Events connected with functionality	Evénements liés au fonctionnement	Eventos relacionados con funcionamiento	Eventi legati al funzionamento
9	3	Соединение с контроллером	Connection with the controller	Connexion avec le contrôleur	Conexión al controlador	Collegamento con il controller
11	4	События, связанные с верификацией	Events associated with verification	Evénements liés avec la vérification	Eventos relacionados con verificación	Eventi legati alla verificazione
12	3	Функционирование сервера	Functioning of server	Fonctionnement avec le serveur	Funcionamiento de servidor	Funzionamento del server
13	2	Лицензирование	Licensing	Délivrance d'une licence	Licenciamiento	Concessione di licenza
14	2	Команды пользователя в контроллер	User commands to the controller	Commandes de l'utilisateur dans contrôleur	Comandos de los usuarios al controlador	Comandi dell'utente nel controller
15	3	Команды записи конфигурации в контроллер	Commands of the configuration registration to the controller	Commandes d'enregistrement de la configuration dans contrôleur	Comandos del registro de configuración al controlador	Comandi della registrazione della configurazione in controller
16	2	Работа с картами Mifare	Working with Mifare cards	Travail avec les cartes Mifare	Operación con tarjetas Mifare	Elaborazione delle card Mifare
17	5	События видеонаблюдения	Video monitoring events	Evénement de surveillance vidéo	Eventos de monitoreo de video	Evento di monitoraggio video
18	1	События охранно-пожарной сигнализации	Events of security system	Événements du système de sécurité	Eventos del sistema de seguridad	Eventi del sistema di sicurezza
10000	2	Изменение учетных данных	Credentials change	Changement des données	Cambio de credenciales	Modifica delle credenziali
10011	2	Работа с графиками работы	Working with schedules	Travail avec les horaires	Trabajo con horarios	Lavoro con gli orari di lavoro
10012	2	Работа с подразделениями	Working with departments	Travail avec des départements	Trabajo con departamentos	Lavoro con sottoreparti
10014	2	Работа с сотрудниками	Work with employees	Travail avec les employés	Trabajo con empleados	Lavoro con gli impiegati
10015	2	Работа с посетителями	Work with visitors	Travail avec les visiteurs	Trabajo con visitantes	lavoro con i visitatori
10016	2	Работа с шаблонами доступа	Working with access templates	Travail avec les modèles d'accès	Trabajo con modelos de acceso	Elaborazione dei template di accesso
10017	2	Работа с временными критериями доступа	Operation with time access criteria	Travail avec les critères d'accès temporaires	Operación con criterios de acceso temporales	Lavoro coi criteri temporali di accesso
10025	2	Работа с событиями прохода	Work with the events of the passage	Travail avec les événements du passage	Actividad con eventos del paso	Elaborazione degli eventi del passaggio
10032	2	Работа с ролями операторов	Working with operator roles	Travail avec les rôles d'opérateurs	Trabajo con roles de los operadores	Lavoro coi ruoli degli operatori
10036	2	Работа с оправдательными документами	Working with supporting documents	Travail avec des documents justificatifs	Trabajo con documento justificativos	Lavoro con documenti giustificativi
10037	2	Работа с дополнительными данными	Working with additional data	Travail avec des données supplémentaires	Trabajo con datos adicionales	Lavoro con dati aggiuntivi
10038	2	Работа с операторами	Working with operators	Travail avec les opérateurs	Trabajo con operadores	Lavoro con operatori
10050	2	Работа с дизайнами пропуска	Working with card designs	Travail avec le design de la carte	Trabajo con diseños del pase	Lavoro con il design della tessera
10054	2	Работа с должностями	Working with positions	Travail avec des postes	Trabajo con cargos	Lavoro con le carice
10059	2	Работа с помещениями	Working with rooms	Travail avec des salles	Trabajo con locales	Lavoro con gli ambienti
10061	3	Работа с планировщиком заданий	Work with task planner	Travail avec le planificateur des tâches	Trabajo con planificador de tareas	Lavoro con il pianificatore di compiti
10064	2	Работа с конфигурацией верификации	Working with verification configuration	Travail avec la configuration de vérification	Trabajo con configuración de verificación	Lavoro con configurazione di verificazione
10069	2	Работа с лицензиями	Working with licenses	Travail avec les licences	Operación con licencias	Lavoro con le licenze
10070	2	Работа с интерактивным планом	Working with an interactive plan	Utilisation d'un plan interactif	Trabajar con un plan interactivo	Utilizzo di un piano interattivo
11059	2	Работа с контроллерами	Working with controllers	Travail avec des contrôleurs	Trabajo con controladores	Lavoro coi controller
12000	2	Учет рабочего времени	Working hours record	Gestion du temps de présence	Registro de horario de trabajo	Monitoraggio del tempo di lavoro
\.


--
-- Data for Name: event_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.event_type (id, name, event_subcategory_id, event_resource_type_id, event_resource_table, event_resource_field, en_name, fr_name, it_name, es_name) FROM stdin;
-100	Изменение учетных данных пользователя	10000	\N	\N	\N	User credentials change	Changement des données de l'utilisateur	Modifica delle credenziali utente	Cambio de credenciales del usuario
1	Идентификатор не зарегистрирован	1	1	\N	\N	Identifier is not registered	Identifiant n'est pas enregistré	L`identificatore non è registrato	Identificador no está identificado
2	Идентификатор запрещен	1	1	\N	\N	Identifier banned	Identifiant est interdit	L'identificatore è vietato	Identificador está prohibido
3	Идентификатор из "стоп-листа"	1	1	\N	\N	Identificator from a "stop list"	Indentifiant de la liste des interdits	Identificatore dalla \\"lista stop\\"	Identificador desde ¨Stop list¨
4	Идентификатор просрочен	1	1	\N	\N	Identifier expired	Identifiant est expiré	Identificatore scaduto	Identificador está expirado
8	Запрет прохода	1	1	\N	\N	Passage restriction	Interdiction du passage	Divieto di passaggio	Prohibición de paso
11	Предъявление запрещенной карты: нарушение РКД	1	1	\N	\N	Presentation of a banned card: ACM violation	Présentation de la carte interdite: la violation du mode de contrôle d'accès	Presentazione della tessera bloccata: violazione del regime di controllo accessi	Presentación de tarjeta prohibida: ACM violación
12	Запрет прохода от ВВУ	1	1	\N	\N	Passage denial from external verification device	Interdiction de passage de dispositif de vérification externe	Divieto di passaggio dal dispositivo esterno di verificazione	Denegación de paso del dispositivo de verificación externa
14	Запрет прохода по команде оператора: 	1	1	\N	\N	Passage denial by the operator command:	Passage interdit par la commande de l'opérateur	Passaggio bloccato sull'ordine dell'operatore:	Denegación de paso por orden del operador
15	Запрет прохода по команде от ДУ	1	1	\N	\N	Passage denial by the remote control command	Interdiction de passage du pupitre de commandes	Passaggio bloccato a comando dal comando a distanza	Denegación de paso por un comando del control remoto
16	Отказ от прохода: 	1	1	\N	\N	Passage refusal	Refus du passage:	Rifiuto di passaggio:	Denegación de paso
17	Проход по идентификатору	1	1	\N	\N	Passage with the ID:	Passage avec l'identifiant	Passaggio sull'identificatore:	Paso por identificador
23	Проход с подтверждением от ДУ	1	1	\N	\N	Passage with the confirmation from the remote control	Passage avec la confirmation du pupitre de commandes	Passaggio con la conferma dal comando a distanza	Paso con la confirmación del control remoto
27	Проход с подтверждением от верификации: 	1	1	\N	\N	Passage with the confirmation from verification:	Passage par la confirmation de la vérification:	Passaggio con la conferma dalla verifica:	Paso con confirmación de verificación
31	ИУ не закрыто после прохода по идентификатору: 	1	1	\N	\N	Device is not closed after passage by identifier	Dispositif n'est pas fermé après le passge par l'identifiant:	Il dispositivo esecutivo non è chiuso dopo il passaggio su identificatore	Dispositivo sigue siendo abierto después de paso por identificador
41	Попытка взятия ОЗ (невозможно взять) по идентификатору: отказ от постановки	2	6	\N	\N	Attempt to arm the protected zone (can not be armed) by the identifier: arming denial	Tentative d'activation du mode de sécurité de la zone sécurisée (impossible d'armer) avec l'identifiant: le refus d'activation du mode de sécurité	Il tentativo di messa della Zona di protezione (non può essere messa) sull'identificatore: il rifiuto della messa	Intento de armar la zona protegida(no puede ser armada)por identificador: denegación de armamento
47	Попытка снятия ОЗ (невозможно снять) по идентификатору: отказ от снятия	2	6	\N	\N	Attempt to disarm the protected zone (can not be disarmed) by the identifier: denial of disarmour	Tentative du retrait de la protection de la zone sécurisée (impossible de désarmer) avec l'identifiant: Retrait de la protection de vérification refusé	Il tentativo di togliere la Zona di protezione (non può essere tolta) sull'identificatore: il rifiuto di togliere	Intento de desarmar la zona protegida(no puede serdesarmada) por identificador: denegación de desarmamento
69	Корпус извещателя вскрыт	2	7	\N	\N	Housing of the sending box is tampered	Boîtier de l'avertisseur est ouvert	Il corpo del rivelatore è aperto:	Cuerpo del detector está abierto
70	Корпус извещателя закрыт: 	2	7	\N	\N	Housing of the sending box is closed:	Boîtier de l'avertisseur est fermé:	Il corpo del rivelatore è chiuso:	Cuerpo del detector está cerrado
96	Активизация входа	4	4	\N	\N	Input activation	Activation d'entrée	Attivazione dell'input	Activación de entrada
97	Нормализация входа	4	4	\N	\N	Input normalization	Normalisation d'entrée	Normalizzazione input	Normalización de entrada
98	Активизация выхода	4	5	\N	\N	Output activation	Activation de sortie	Attivazione dell'output	Activación de salida
99	Нормализация выхода	4	5	\N	\N	Output normalization	Normalisation de sortie	Normalizzazione output	Normalización de salida
100	Запуск задержки активизации выхода	4	5	\N	\N	Starting the output activation detention	Lancement de détention de l'activation de sortie	Avviamento del ritardo di attivazione di output	Inicio de la detención de activación de salida
101	КЗ на выходе: Только для выходов с контролем состояния	4	5	\N	\N	Short circuit at the output: for outputs with status check only	Court-circuit à la sorie: Seulement pour les sorties avec le contrôle d'état	Cortocircuito in output: solo per uscite con controllo di stato	Cortocircuito a la salida: Solo para salidas con control de estatus
102	Обрыв на выходе: Только для выходов с контролем состояния	4	5	\N	\N	Output disconnection: For outputs with status check only	Déconnexion à la sortie: Seulement pour les sorties avec le contrôle d'état	Distacco di output: solo per output con controllo di stato	Disconexión a la entrada: solo para salidas con control deestatus
103	Активация выхода невозможна, причина - КЗ: Только для выходов с контролем состояния	4	5	\N	\N	Activation of exit is not possible, due to short circuit: Only for exits with status monitoring	Activation de la sortie n'est pas possible à cause de court-circuit: Seulement pour les sorties avec le contrôle d'état	Attivazione dell'output non è possibile, la ragione è cortocircuito: solo per le uscite con il monitoraggio dello stato	Activación de salida es imposible pese a cortocircuito:Solo para salidas con estatus de control
104	Восстановление выхода: Только для выходов с контролем состояния. Восстановление линии после КЗ или обрыва.	4	5	\N	\N	Output recovery: only for outputs with status control. Recovery of line after short circuit or line break.	Restauration de la sortie: Seuelement pour les sorties avec le contrôle d'état. Restauration de laligne après le court circuit ou la rupture.	Ripristino dell'output: solo per gli output con il controllo di stato. Il ripristino della linea dopo cortocircuito o dopo interruzione.	Recuperación de salida: solo para salidas con control de estatus. Recuperación de línea después de un cortocircuito o corte de línea.
105	FireAlarm on	2	4	\N	\N	FireAlarm on	FireAlarm on	FireAlarm on	FireAlarm on
106	FireAlarm off	2	4	\N	\N	FireAlarm off	FireAlarm off	FireAlarm off	FireAlarm off
112	Проход по команде от ДУ 	5	1	\N	\N	Passage by a command from RC	Passage par la commande du pupitre de commandes	Passaggio sull'ordine dal commando a distanza	Paso por comando desde el dispositivo
113	Проход по команде от ПК	5	1	\N	\N	Passage by the PC command	Passage par la commande de l'ordinateur	Passaggio all'ordine di PC	Paso por orden del PC
114	Несанкционированный проход через ИУ (взлом ИУ)	5	1	\N	\N	Unauthorized passage through device (OD break in)	Passage non-autorisé par le dispositif (l'effraction du dispositif)	Passaggio non autorizzato tramite dispositivo esecutivo (scasso)	Paso no autorizado mediante dispositivo( hackeo del dispositivo)
117	ИУ разблокировано	5	2	\N	\N	Device unlocked	Dispositif est débloqué	Dispositivo esecutivo sbloccato	Dispositivo está desbloqueado
118	ИУ заблокировано	5	2	\N	\N	Device is blocked	Dispositif est bloqué	Dispositivo esecutivo è bloccato	Dispositivo está bloqueado
119	Проход по команде ИК-пульта	5	1	\N	\N	Passage by the IR-remote command	Passage par la commande du pupitre de commande infra-rouge	Passaggio all'ordine di telecomando IR	Paso por orden del panel de control remoto
129	Включение питания контроллера	6	8	\N	\N	Controller power-on	Allumer le contrôleur	Accensione di alimentazione del controller	Activación de alimentación del controlador
130	Выключение питания контроллера	6	\N	\N	\N	Controller power-off	Eteindre l'alimentation du contrôleur	Disinserzione dell'alimentazione del controller	Desactivación de alimentación del controlador
131	Нарушение связи	6	\N	\N	\N	Connection failure	Panne de connexion	Interruzione del collegamento	Violación de conexión
132	Восстановление связи	6	\N	\N	\N	Connection recovery	Reprise de connexion	Ripristino della connessione	Recuperación de conexión
133	Переполнение журнала регистрации	6	\N	\N	\N	Log file trashing	Saturation du log	Traboccamento del registro	Repleción del registrador
134	Очистка журнала регистрации	6	\N	\N	\N	Cleaning log	Elimination du log	Svuotare il giornale di registrazione	Limpia del registrador
136	Перезапуск контроллера: WatchDog	6	8	\N	\N	Restart controller: WatchDog	Redémmarrage du contrôleur: WatchDog	Ripresa controller: WatchDog	Reinicio de controlador: WatchDog
137	Перезапуск приложения контроллера	6	\N	\N	\N	Device app restarted	Application de l'appareil redémarrée	Applicazione del dispositivo riavviata	Reiniciada la aplicación del dispositivo
138	Переполнение списка идентификаторов	6	\N	\N	\N	Identifier list trashing	Saturation du de la liste d'identifiants	Traboccamento  della lista di identificatori	Repleción de la lista de identificadores
145	Изменение конфигурации физического контакта	6	\N	\N	\N	Changing configuration of a physical contact	Изменение конфигурации физического контакта	Изменение конфигурации физического контакта	Изменение конфигурации физического контакта
149	Корпус контроллера открыт	6	\N	\N	\N	Controller housing is opened	Boîtier du contrôleur est ouvert	Il corpo del controller è aperto	Cuerpo del controlador está abierto
150	Корпус контроллера закрыт	6	\N	\N	\N	Controller housing is closed	Boîtier du contrôleur est fermé	Il corpo del controller è chiuso	Cuerpo del controlador está cerrado
155	Тревога по команде ИК-пульта	2	2	\N	\N	Alarm on an IR-remote signal	Alarme par la commande du pupitre infra-rouge	Allarme dal pannello di controllo remoto a infrarossi	Alarma por orden de panel de control remoto
159	Неисправность ИП: Формируется встроенным АЦП при выходе напряжения питания за рабочий диапазон	6	\N	\N	\N	Fault of the power supply: Formed with the integrated ADC on power voltage overrange	Faute d'alimentation +18V: Générée par l'alimentation CC intégrée quand la tension d'alimentation sort hors de la plage de fonctionnement	Guasto del fonte di alimentazione: viene formato dalla scheda di conversione incorporata in caso dell'eccesso della tensione sopra il raggio di lavoro	Avería enl fuente de alimentación : se forma mediante ADC empotrado en caso si una tensión de aimentación esté fuera de modo de operación
160	Восстановление ИП: При условии, что напряжение питания в рабочем диапазоне.	6	\N	\N	\N	Power supply recovery: Provided that the power voltage is in the operating range.	Restauration d'alimentation: sous la codition que la tension d'alimentation et dans la plage de fonctionnement.	Ripristino del sorso di alimentazione: a condizione che la tensione si trova nel intervallo operativo.	Recuperación de fuente de alimentación: en caso siuna tensión de alimentación esté en modo de operacion
161	Тревога: От Генератора тревоги	2	2	\N	\N	Alarm: From the Alarm Generator	Alarme: Du Générateur d'alarme	Allarme: dal generatore allarme	Alarma: del Generador de alarma
162	Сброс тревоги: По команде от ПО	2	2	\N	\N	Alarm reset: By signal from software	Réinitialisation d'alarme: par commande du logiciel	Reset di allarme: al comando del software	Reseteo de alarma: por señal de software
163	Автономный сброс тревоги: Кнопкой "Сброс"	2	2	\N	\N	Autonomous alarm reset: Press the "Reset" button	Réinitialisation autonome de l'alarme: Par le bouton \\"Réinitialiser\\"	Reset di allarme autonomo: con il buttone "Reset"	Reseteo autónomo de alarma: Presiona el boton¨Reseteo¨
245	Тестирование прибора начато	6	\N	\N	\N	Device testing has begun	Tests de dispositif est commencé	Il test dell'impianto è avviato	Prueba de dispositivo se ha empezado
246	Тестирование ШС начато	6	\N	\N	\N	Alarm line testing has begun	Test de ligne d'alarme est commencé	Il testing dei sistemi di cavi allarme è iniziato	Prueba de contactos de señalización
248	Неисправность ИП +18В: Формируется встроенным АЦП при выходе напряжения питания ШС за рабочий диапазон	6	\N	\N	\N	+18 V power supply fault: Formed with the integrated ADC on alarm line power voltage overrange1	Faute d'alimentation +18V: Générée par l'alimentation CC intégrée quand la tension d'alimentation de la ligne d'alarme sort hors de la plage de fonctionnement	Guasto del fonte di alimentazione +18V: viene formato dalla scheda di conversione incorporata in caso dell'eccesso della tensione del doppino d'accoppiamento sopra il raggio di lavoro	Avería en fuente de alimentación +18B: se forma mediante ADC empotrado en caso si una línea de seguridadde alarma esté fuera de modo de operación
249	Пропадание связи с контроллером 2-го уровня	6	1	\N	\N	Connection loss with the 2nd level controller	Perte de connexion avec le contrôleur du deuxième niveau	Caduta del collegamento con il controller del livello 2	Pérdida de conexión con controlador de segundo nivel
264	Запрет прохода: несоответствие текущему местоположению	1	1	\N	\N	Passage denial: mismatch to the current location	Refus de passage: le décalage d'emplacement actuel	Passaggio bloccato: non conformità alla posizione attuale	Denegación de paso: disconformidad con la localizacióncorriente
273	Проход по идентификатору: с несоответствием текущему местоположению	1	1	\N	\N	Passage with the ID: with the mismatch to the current location	Passage par identifiant: non confotmité d'emplacement actuel	Passaggio sull'identificatore: con la non conformità alla posizione attuale	Paso por identificador: con disconformidad con la localización corriente
279	Проход с подтверждением от ДУ: с несоответствием текущему местоположению	1	1	\N	\N	Passage with the confirmation from the remote control: with the mismatch to the current location	Passage par la confirmation du pupitre de commandes: non confirmité de l'emplacement actuel	Passaggio con la conferma dal comando a distanza: con la non conformità alla posizione attuale	Paso con confirmación de control remoto: con  disconformidad con la localización corriente
283	Проход с подтверждением от верификации: с несоответствием текущему местоположению	1	1	\N	\N	Passage with the confirmation from verification: with the mismatch to the current location	Passage par la confirmation de la vérification: non confirmité l'emplacement actuel	Passaggio con la conferma dalla verifica: con la non conformità alla posizione attuale	Paso con confirmación de verificación: con desconformidadcon la localización corriente
288	ОЗ взята на охрану по идентификатору: ОЗ перешла в режим ОХРАНА	2	6	\N	\N	Protected zone is armed by the identifier: protected zone switched to the SECURITY mode	Zone Sécurisée est armée par l'identifiant: la zone Sécurisée est dans le mode SÉCURITÉ	La Zona di protezione è messa sotto protezione sull'identificatore: è passata al modo PROTEZIONE	Zona protegida está armada por identificador: zona protegida está en modo ¨SEGURIDAD¨
289	ОЗ снята с охраны по идентификатору: ОЗ перешла в режим СНЯТА	2	6	\N	\N	Protected zone is disarmed by the identifier: protected zone switched to the DISARMED mode	Zone Sécurisée est désarmée par l'identifiant: la zoneSécurisée est en  mode DÉSARMÉ	La protezione della Zona di protezione è tolta sull'identificatore: è passata al modo TOLTA	Zona protegida está desarmada por identificador: zona protegida está en modo ¨DESARMAMENTO¨
290	Попытка взятия ОЗ (невозможно взять) по идентификатору: несоответствие текущему местоположению	2	6	\N	\N	Attempt to arm the protected zone (can not be armed) by the identifier: mismatch to the current location	Tentative d'activation du mode de sécurité de la zone sécurisée (impossible d'armer) avec l'identifiant: le décalage de l'emplacement actuel	ll tentativo di messa della Zona di protezione (non può essere messa) sull'identificatore: non conformità alla posizione attuale	Intento de armar la zona protegida(no puede ser armada)por identificador: disconformidad a la localización corriente
298	Попытка снятия ОЗ (невозможно снять) по идентификатору: несоответствие текущему местоположению	2	6	\N	\N	Attempt to disarm the protected zone (can not be disarmed) by the identifier: mismatch to the current location	Tentative du retrait de la protection de la zone sécurisée (impossible de désarmer) avec l'identifiant: le décalage de l'emplacement actuel	Il tentativo di togliere la Zona di protezione (non può essere tolta) sull'identificatore: non conforme alla posizione attuale	Intento de desarmar la zona protegida(no puede serdesarmada) por identificador: disconformidad a la localización corriente
305	ОЗ взята на охрану по идентификатору с подтверждением: ОЗ перешла в режим ОХРАНА	2	6	\N	\N	Protected zone is armed by the identifier with the confirmation: protected zone switched to the SECURITY mode	Zone Sécurisée est armée par l'identifiant avec la confirmation: la zone Sécurisée est dans le mode SÉCURITÉ	La Zona di protezione è messa sotto protezione su comando dell'operatore: è passata al modo PROTEZIONE	Zona protegida está armada por identificador con confirmación: zona protegida está en modo ¨SEGURIDAD¨
501403	Удаление сотрудника	10014	\N	\N	\N	Employee removal	Elimination de l'employé	Eliminazione dell'impiegato	Remocion de un empleado
306	ОЗ снята с охраны по идентификатору с подтверждением: ОЗ перешла в режим СНЯТА	2	6	\N	\N	Protected zone is disarmed by the identifier with the confirmation: protected zone switched to the DISARMED mode	Zone Sécurisée est désarmée par l'identifiant avec la confirmation: la zone Sécurisée est en mode DÉSARMÉ	La protezione della Zona di protezione è tolta sull'identificatore con la conferma: è passata al modo TOLTA	Zona protegida está desarmada por identificador conconfirmación: zona protegida está en modo¨DESARMAMENTO¨
307	ОЗ взята на охрану по команде оператора: ОЗ перешла в режим ОХРАНА	2	6	\N	\N	Protected zone is armed by the operator command: protected zone switched to the SECURITY mode	Zone Sécurisée est armée par la commande de l'opérateur: la zone Sécurisée est en mode SÉCURITÉ	La  Zona di protezione è messa sotto protezione sul comando dell'operatore: è passata al modo PROTEZIONE	Zona protegida está armada por orden del operador:zona protegida está en modo ¨SEGURIDAD¨
308	ОЗ снята с охраны по команде оператора: ОЗ перешла в режим СНЯТА	2	6	\N	\N	Protected zone is disarmed by the operator command: protected zone siwtched to the "DISARMED" mode	Zone Sécurisée est désarmée par la commande de l'opérateur: la zone Sécurisée en le mode DÉSARMÉ	La protezione della Zona di protezione è tolta sul comando dell'operatore: è passata al modo TOLTA	Zona protegida está desarmada por orden del operador:zona protegida está en modo ¨DESARMAMENTO¨
312	Тихая тревога по охранной зоне	2	6	\N	\N	Silent alarm on the protected zone	Alarme douce sur la zone protégée	Allarme silenzioso nella Zona di protezione	Alarma silenciosa sobre la zona protegida
313	Тревога по охранной зоне	2	6	\N	\N	Alarm on the protected zone	Alarme sur la zone protégée	Allarme nella Zona di protezione	Alarma sobre la zona protegida
314	Сброс тревоги по ОЗ	2	6	\N	\N	Reset alarm on the protected zone	Réinitialisation de l'alarme sur la zone protégée	Reset di allarme nella Zona di protezione	Reseteo de alarma de la zona protegida
315	Взятие ОЗ на охрану по идентификатору: ОЗ перешла в режим ВЗЯТИЕ	2	6	\N	\N	Protected zone arming by the identifier: protected zone switched to the ARMING mode	Armer la zone protégée avec l'identifiant: la zone protégée est au mode D'ACTIVATION DE SÉCURITÉ	Messa della Zona di Protezione sotto protezione sull'identificatore: è passata nel modo MESSA	Armamento de zona protegida por identificador: zona protegida está en modo ¨ARMAMENTO¨
316	Взятие ОЗ на охрану по команде оператора: ОЗ перешла в режим ВЗЯТИЕ	2	6	\N	\N	Protected zone arming by the operator command: protected zone switched to the ARMING mode	Armer la zone protégée avec la commande de l'opérateur: la zone protégée est au mode D'ACTIVATION DE SÉCURITÉ	Messa della Zona di protezione sotto protezione sull'ordine dell'operatore: è passata nel modo MESSA	Armamento de zona protegida por un orden de un operador: zona protegida está en modo ¨ARMAMENTO¨
323	ОШС отключен	2	7	\N	\N	Security alarm line is turned off	Ligne d'alarme de sécurité est désactivée	Il ciclo di allarme è staccato	Contactos de señalización están desactivados
395	Неисправность контроллера: память FRAM	6	\N	\N	\N	Fault of controller: FRAM memory	Défaillance du contrôleur : la mémoire FRAM	Guasto controller: memoria FRAM	Avería de un controlador: FRAM memoria
400	Форматирование памяти: журнал событий	6	\N	\N	\N	Memory formating: event log	Formatage de mémoire: le journal des événements	Formattazione della memoria: registro eventi	Formateo de memoria: registrador
409	Изменение режима работы по команде оператора: режим "Открыто"	6	1	\N	\N	Changing the operating mode by the operator command: "Open" mode	Changement du mode de fonctionement par la commande de l'opérateur: le mode \\"Ouvert\\"	Modifica del modo di funzionamento sull'ordine di operatore: modo "Aperto"	Сambio de modo de operación por orden del operador:modo "Abierto"
410	Изменение режима работы по команде ИК-пульта: режим "Открыто"	6	1	\N	\N	Changing the operating mode by the IR-remote command: "Open" mode	Changement du mode de fonctionement par la commande du pupitre de commande infrarouge: le mode \\"Ouvert\\"	Modifica del modo di funzionamento sull'ordine di telecomando IR: modo "Aperto"	Сambio de modo de operación por orden del panel decontrol remoto: modo "Abierto"
414	Изменение режима работы с режима "Охрана" по идентификатору: режим "Открыто"	6	1	\N	\N	Changing the operating mode from the "Security" mode by the identifier: "Open" mode	Changement du mode de fonctionement u mode\\"Sécurité\\" par l'identifiant: le mode \\"Ouvert\\"	Modifica del modo di funzionamento dal modo "Protezione" sull'identificatore: modo "Aperto"	Сambio de modo de operación del modo "Seguridad" poridentificador: modo "Abierto"
501	Тестирование прибора завершено успешно	6	\N	\N	\N	Device testing is successfully completed	Test de dispositif est terminé avec succès	Il testing dell'impianto è completato con successo	Prueba de dispositivo se ha acabado exitosamente
502	Тестирование ШС завершено	6	\N	\N	\N	Alarm line testing is completed	Test de ligne d'alarme est accompli	Il testing dei sistemi di cavi allarme è completato	Prueba de contactos de señalización
504	Восстановление ИП +18В: Формируется встроенным АЦП при возвращении напряжения питания ШС в рабочий диапазон	6	\N	\N	\N	+18 Power supply recovery: Formed with integrated ADC when power voltage of alarm line returns in the operating range	Restauration d'alimentation +18V: générée (fournie) par l'alimentation du CC intégrée quand la tension d'alimentation de la ligne d'alarme revient à la plage de fonctionnement	Ripristino del sorso di alimentazione +18V:: Formato dalla scheda di conversazione integrata al ritorno della tensione del ciclo di allarme nel campo operativo	Recuperación de fuente de alimentación + 18B: se forma con ADC empotrado en caso de regreso defuente de alimentación de contactos de señalización  en modo de operación
505	Восстановление связи с контроллером 2-го уровня	6	1	\N	\N	Connection recovery with the controller of level 2	Reprise de connexion avec le contrôleur du deuxième niveau	Ripristino di collegamento con il controller del secondo livello	Recuperación de conexión con controlador de segundo nivel
520	Запрет прохода: несоответствие режиму доступа	1	1	\N	\N	Passage denial: access mode mismatch	Interdiction de passage: le non-conformité de mode d'accès	Divieto di passaggio: non conformità con il regime di accesso	Denegación de paso: disconformidad al modo de acceso
529	Проход по идентификатору: с несоответствием временным критериям доступа	1	1	\N	\N	Passage with the ID: with the mismatch to the time access criteria	Passage par identifiant: non confotmité de critères de temps d'accès	Passaggio sull'identificatore: con la non conformità ai criteri temporali di accesso	Paso por identificador: con disconformidad con los criteriosde acceso de tiempo
535	Проход с подтверждением от ДУ: с несоответствием временным критериям доступа	1	1	\N	\N	Passage with the confirmation from the remote control: with the mismatch to the time access criteria	Passage par la confirmation du pupitre de commandes: non confirmité des critères d'accès de temps	Passaggio con la conferma dal comando a distanza: con la non conformità ai criteri temporali di accesso	Paso con confirmación de control remoto: disconformidad con los criterios de acceso de tiempo
539	Проход с подтверждением от верификации: с несоответствием временным критериям доступа	1	1	\N	\N	Passage with the confirmation from verification: with the mismatch to the time access criteria	Passage par la confirmation de la vérification: non conformité des critères d'accès de temps	Passaggio con la conferma dalla verifica: con la non conformità ai criteri temporali di accesso	Paso con confirmación de verificación: con desconformidada los criterios de acceso de tiempo
546	Попытка взятия ОЗ (невозможно взять) по идентификатору: несоответствие временных критериев доступа	2	6	\N	\N	Attempt to arm the protected zone (can not be armed) by the identifier: mismatch of the time access criteria	Tentative d'activation du mode de sécurité de la zone sécurisée (impossible d'armer) avec l'identifiant: le décalage des critères de temps	ll tentativo di messa della Zona di protezione (non può essere messa) sull'identificatore: non conformità ai criteri temporanei di accesso	Intento de armar la zona protegida(no puede ser armada)por identificador: disconformidad a los criterios de accesode tiempo
554	Попытка снятия ОЗ (невозможно снять) по идентификатору: несоответствие временных критериев доступа	2	6	\N	\N	Attempt to disarm the protected zone (can not be disarmed) by the identifier: mismatch of the time access criteria	Tentative du retrait de la protection de la zone sécurisée (impossible de désarmer) avec l'identifiant: le décalage des critères d'accès et de l'emplacement actuel	Il tentativo di togliere la Zona di protezione (non può essere tolta) sull'identificatore: incoerenza criteri di accesso temporaneo	Intento de desarmar la zona protegida(no puede serdesarmada) por identificador: disconformidad a los criterios de acceso de tiempo
577	ИУ взят на охрану: ИУ перешел в режим ОХРАНА	2	2	\N	\N	Device is armed: device switched to the SECURITY mode	Dispositif est armé: le dispositif est en mode SÉCURITÉ	Dispositivo esecutivo messo sotto protezione: passato al modo ALLARME	Armamento de dispositivo : dispositivo está en modo ¨SEGURIDAD¨
578	Взятие ИУ на охрану: ИУ перешел в режим ВЗЯТИЕ	2	2	\N	\N	Device arming: the device switched to the ARMING mode	Armer le dispositif: le dispositif est au mode D'ACTIVATION DE SÉCURITÉ	Dispositivo esecutivo messo sotto protezione: dispositivo è passato nel modo MESSA	Armamento de dispositivo: dispositivo está en modo ¨ARMAMENTO¨
580	ИУ снят с охраны: ИУ перешел в режим СНЯТ, в том числе и если стоит "снять при невзятии"	2	2	\N	\N	Device is disarmed: device switched to the DISARMED mode, including "disarming" mode	Dispositif est désarmé: le dispositif est en mode LA DÉSACTIVATION DE SÉCURITÉ, y compris \\"désarmé\\"	La protezione del dispositivo esecutore è tolta: il dispositivo è passato nel modo TOLTA, anche se è inserito "togliere nel caso di non presa"	Desarmamento de dispositivo: dispositivo está enmodo ¨DESARMAMENTO¨ incluso en caso si haya una función ¨Disarmar sin armamento¨
585	Нарушение ИУ, режим ТРЕВОГА: ИУ перешел в режим ТРЕВОГА	2	2	\N	\N	Device violation, ALARM mode: device switched to the ALARM mode	Violation de dispositif, le mode ALARME: le dispositif est dans le mode ALARME	Violazione del dispositivo esecutivo, modalità ALLARME: Dispositivo esecutivo è passato nella modalità ALLARME	Violación del dispositivo, modo ALARMA: dispositivo está en modo de ALARMA
591	Сброс тревоги ИУ	2	2	\N	\N	Reset alarm of the device	Réinitialisation de l'alarme du dispositif	Reset di allarme del dispositivo esecutivo	Reseteo de alarma del dispositivo
645	Сбой физического уровня Ethernet	6	\N	\N	\N	Ethernet physical level failure	Echec du niveau physique Ethernet	Staratura di livello fisico Ethernet	Fallo de nivel físico de Ethernet
651	Неисправность контроллера: память DataFlash	6	\N	\N	\N	Fault of controller: DataFlash memory	Défaillance du contrôleur : la mémoire DataFlash	Guasto controller: memoria DataFlash	Avería de un controlador: Data flash memoria
656	Форматирование памяти: список карт	6	\N	\N	\N	Memory formating: card list	Formatage de mémoire: la liste de cartes	Formattazione della memoria: elenco di carte di prossimità	Formateo de memoria: lista de tarjetas
665	Изменение режима работы по команде оператора: режим "Контроль"	6	1	\N	\N	Changing the operating mode by the operator command: "Control" mode	Changement du mode de fonctionement par la commande de l'opérateur: le mode \\"Contrôle\\"	Modifica del modo di funzionamento sull'ordine di operatore: modo "Controllo"	Сambio de modo de operación por orden del operador:modo "Control"
666	Изменение режима работы по команде ИК-пульта: режим "Контроль"	6	1	\N	\N	Changing the operating mode by the IR-remote command: "Control" mode	Changement du mode de fonctionement par la commande du pupitre de commande infrarouge: le mode \\"Contrôle\\"	Modifica del modo di funzionamento sull'ordine di telecomando IR: modo "Controllo"	Сambio de modo de operación por orden del panel decontrol remoto: modo "Control"
1168	Форматирование памяти: конфигурация	6	\N	\N	\N	Memory formating: configuration	Formatage de mémoire: la configuration	Formattazione della memoria: configurazione	Formateo de memoria: configuración
670	Изменение режима работы на режим "Контроль" по идентификатору	6	1	\N	\N	Changing the operating mode from the "Security" mode by the identifier: "Control" mode	Changement du mode de fonctionement du mode\\"Sécurité\\" par l'identifiant: le mode \\"Contrôle\\"	Modifica del modo di funzionamento dal modo "Protezione" sull'identificatore: modo "Controllo"	Сambio de modo de operación del modo "Seguridad" poridentificador: modo "Control"
671	Изменение режима работы на режим "Контроль" по идентификатору с нарушением времени	6	1	\N	\N	Changing the operating mode from the "Security" mode by the identifier: "Control" mode	Changement du mode de fonctionement du mode"Sécurité" par l'identifiant: le mode "Contrôle"	Modifica del modo di funzionamento dal modo "Protezione" sull'identificatore: modo "Controllo"	Сambio de modo de operación del modo "Seguridad" poridentificador: modo "Control"
672	Изменение режима работы на режим "Контроль" по идентификатору с нарушением местоположения	6	1	\N	\N	Changing the operating mode from the "Security" mode by the identifier: "Control" mode	Changement du mode de fonctionement du mode"Sécurité" par l'identifiant: le mode "Contrôle"	Modifica del modo di funzionamento dal modo "Protezione" sull'identificatore: modo "Controllo"	Сambio de modo de operación del modo "Seguridad" poridentificador: modo "Control"
673	Изменение режима работы на режим "Контроль" по идентификатору с нарушением времени и местоположения	6	1	\N	\N	Changing the operating mode from the "Security" mode by the identifier: "Control" mode	Changement du mode de fonctionement du mode"Sécurité" par l'identifiant: le mode "Contrôle"	Modifica del modo di funzionamento dal modo "Protezione" sull'identificatore: modo "Controllo"	Сambio de modo de operación del modo "Seguridad" poridentificador: modo "Control"
757	Тестирование прибора выявило неисправности	6	\N	\N	\N	Device testing has detected failures	Test de dispositif est détecté a défaillances	Il testing dell'impianto ha rivelato un guasto	Prueba de dispositivo ha detectado averías
761	Неисправность контроллера 2-го уровня	6	1	\N	\N	Fault of the 2nd level controller	Défaillance du contrôleur du deuxième niveau	Guasto del controller di 2 ° livello	Avería de un controlador de segundo nivel
776	Запрет прохода: несоответствие временным критериям доступа и текущему местоположению	1	1	\N	\N	Passage denial: mismatch to the time access criteria and to the current location	Refus de passage: le décalage des critères de temps d'accès à l'emplacement actuel	Passaggio bloccato: non conformità ai criteri del tempo di accesso e alla posizione attuale	Denegación de paso: disconformidad con los criterios deaccesode tiempo y localización corriente
785	Проход по идентификатору: несоответствие временным критериям доступа и текущему местоположению	1	1	\N	\N	Passage with the ID: mismatch to the time access criteria and to the current location	Passage avec l'identifiant: le décalage des critères de temps d'accès et d'emplacement actuel	Passaggio sull'identificatore: non conformità ai criteri di tempo di accesso  e alla posizione attuale	Paso por identificador: disconformidad con los criterios deacceso de tiempo y localización corriente
791	Проход с подтверждением от ДУ: несоответствие временным критериям доступа и текущему местоположению	1	1	\N	\N	Passage with the confirmation from the remote control: mismatch to the time criteria and to the current location	Passage avec la confirmation du pupitre de commandes: le décalage des critères de temps et l'emplacement actuel	Passaggio con la conferma dal comando a distanza: non conformità ai criteri temporali di accesso e alla posizione attuale	Paso con confirmación de control remoto: disconformidad con los criterios de acceso de tiempo y localización corriente
795	Проход с подтверждением от верификации: несоответствие временным критериям доступа и текущему местоположению	1	1	\N	\N	Passage with the confirmation from verification: with the mismatch of the access criteria to the current location	Passage par confirmation de la vérification: non conformité des critères de temps et l'emplacement actuel	Passaggio con la conferma dalla verifica: non conformità ai criteri temporali di accesso e alla posizione attuale	Paso con confirmación de verificación: desconformidadcon los criterios de acceso de tiempo y localización corriente
802	Попытка взятия ОЗ (невозможно взять) по идентификатору: несоответствие временным критериям доступа и текущему местоположению	2	6	\N	\N	Attempt to arm the protected zone (can not be armed) by the identifier: mismatch to the time access criteria and to the current location	Tentative d'activation du mode de sécurité de la zone sécurisée (impossible d'armer) avec l'identifiant: le décalage des critères de temps et de l'emplacement actuel	ll tentativo  della messa di  Zona di protezione (non può essere messa) sull'identificatore: non conformità ai criteri di accesso temporanei e alla posizione attuale	Intento de armar la zona protegida(no puede ser armada)por identificador: disconformidad a los criterios de accesode tiempo y localización corriente
810	Попытка снятия ОЗ (невозможно снять) по идентификатору: несоответствие временным критериям доступа и текущему местоположению	2	6	\N	\N	Attempt to disarm the protected zone (can not be disarmed) by the identifier: mismatch to the time access criteria and to the current location	Tentative du retrait de la protection de la zone sécurisée (impossible de désarmer) avec l'identifiant: le décalage des critères d'accès et de l'emplacement actuel	Il tentativo di togliere la  Zona di protezione (non può essere tolta) sull'identificatore: incoerenza dei criteri di ammissibilità temporanee e posizione attuale	Intento de desarmar la zona protegida(no puede serdesarmada) por identificador: disconformidad a los criterios de acceso de tiempo y localización corriente
1029	Предъявлена комиссионирующая карта: 	1	1	\N	\N	Commissioning card presented	Carte de révérification est présentée	Presentata la tessera di doppio controllo:	Presentación de tarjeta comisionada
5200	Проход через мобильный терминал	1	1	\N	\N	Passage through a mobile terminal	Passage par le terminal mobile	Passaggio a traverso il terminale mobile	Paso a través de terminal móvil
1032	Запрет прохода: нарушение комиссионирования	1	1	\N	\N	Passage denial: double-check access violation	Refus de passage: la violation de révérification	Passaggio bloccato: violazione di doppio controllo	Denegación de paso: violación de verificación doble deacceso
1041	Проход по идентификатору: с нарушением комиссионирования	1	1	\N	\N	Passage with the ID: with double-check access violation	Passage par identifiant: avec la violation de révérification	Passaggio sull'identificatore: con la violazione del doppio controllo	Paso por identificador: con violación de confirmación doble de acceso
1058	Попытка взятия ОЗ (невозможно взять) по идентификатору: нарушение комиссионирования	2	6	\N	\N	Attempt to arm the protected zone (can not be armed) by the identifier: double-check access violation	Tentative d'activation du mode de sécurité de la zone protégée (impossible d'armer) avec l'identifiant: la violation de révérification	ll tentativo di messa della Zona di protezione (non può essere messa) sull'identificatore: violazione del doppio controllo	Intento de armar la zona protegida(no puede ser armada)por identificador: violación de verificación doble de acceso
1066	Попытка снятия ОЗ (невозможно снять) по идентификатору: нарушение комиссионирования	2	6	\N	\N	Attempt to disarm the protected zone (can not be disarmed) by the identifier: double-check access violation	Tentative du retrait de la protection de la zone sécurisée (impossible de désarmer) avec l'identifiant: la violation de réverification	Il tentativo di togliere la Zona di protezione (non può essere tolta) sull'identificatore: violazione del doppio controllo	Intento de desarmar la zona protegida(no puede ser desarmada) por identificador: violación de acceso de verificación doble
1088	ОШС не взят на охрану: ОШС перешел в режим АВТОПЕРЕВЗЯТИЕ	2	7	\N	\N	Security alarm line is disarmed: Security alarm line switched to the AUTOREARMING mode	Ligne d'alarme de sécurité n'est pas armée: la Ligne d'alarme en mode D'ACTIVATION DE SÉCURITÉ AUTOMATIQUE	Il ciclo di allarme non è messo sotto protezione: il ciclo di allarme è passato al modo AUTORIMETTERE	Contactos de señalización están desarmados: línea de seguridad de alarma están en modo ¨AUTOREARMAMENTO"
1089	ОШС взят на охрану: ОШС перешел в режим ОХРАНА	2	7	\N	\N	Security alarm line is armed: Security alarm line switched to SECURITY mode	Ligne d'alarme de sécurité est armée: la ligne d'alarme en mode SÉCURITÉ	Il ciclo di protezione è messo sotto protezione: è passato al modo PROTEZIONE	Contactos de señalización están armados: contactos de señalización están en modo ¨SEGURIDAD¨
1090	Взятие ОШС на охрану: ОШС перешел в режим ВЗЯТИЕ	2	7	\N	\N	Security alarm line arming: security alarm line switched to the ARMING mode	Armer la ligne d'alarme de sécurité: la ligne d'alarme de sécurité est au mode D'ACTIVATION DE SÉCURITÉ	Messa del ciclo di allarme sotto protezione: è passato nel modo MESSA	Armamento de contactos de señalización:contactos de señalización están en modo¨ARMAMENTO¨
1092	ОШС снят с охраны: ОШС перешел в режим СНЯТ, в том числе и если стоит "снять при невзятии"	2	7	\N	\N	Security alarm line is disarmed: Security alarm line switched to DISARMED mode, including "disarming" mode	Ligne d'alarme de sécurité est désarmée: la ligne d'alarme est en désarmé, y compris le mode RETRAIT DE LA PROTECTION	La protezione del ciclo di allarme è tolta: il ciclo di allarme, anche se è messa "togliere nel caso di non messa"	Contactos de señalización están desarmados: contactos de señalización están en modo ¨DESARMAMENTO"incluso en caso si haya una función ¨desarmar sin armamento¨
1095	Нарушение снятого ОШС	2	7	\N	\N	Disarmed security alarm line violation	Violation de ligne d'alarme désarmée	Violazione del ciclo di allarme tolto	Violación de contactos desarmados de señalización
1096	Нормализация снятого ОШС	2	7	\N	\N	Normalization of the disarmed security alarm line	Normalisation de ligne d'alarme désarmée	Normalizzazione del ciclo di allarme tolto	Normalización de contactos desarmados de señalización
1097	Нарушение ОШС, режим ТРЕВОГА: ОШС перешел в режим ТРЕВОГА, в том числе и если стоит "тревога при невзятии"	2	7	\N	\N	Security alarm line violation, ALARM mode: security alarm line switched to the ALARM mode, including "alarm in disarming" mode	Violation de la ligne d'alarme de sécurité est en mode ALARME, y compris le mode \\"l'alarme désarmée\\"	Violazione del ciclo di allarme, modo ALLARME - è passato al modo ALLARME, anche se è  inserito "allarme nel caso di non messa sotto protezione"	Violación de contactos de señalización, modo ¨ALARMA¨: contactos de señalización están en modo ¨ALARMA¨, incluso en caso si haya una función ¨alarma sin armamento¨
1098	Нарушение ОШС, режим ТРЕВОГА с опцией тихая: ОШС перешел в режим ТРЕВОГА, в том числе и если стоит "тревога при невзятии"	2	7	\N	\N	Security alarm line violation, ALARM mode with "silent" option: security alarm line switched to the ALARM mode, including "alarm in disarming" mode	Violation de la ligne d'alarme de sécurité, le mode ALARME avec l'option \\"douce\\", y compris le mode \\"l'alarme désarmée\\"	Violazione del ciclo di allarme, modo ALLARME con modalità "piano" - è passato al modo ALLARME, anche se è  inserito "allarme nel caso di non messa sotto protezione"	Violación de contactos de señalización, modo ¨ALARMA¨con opción ¨silenciosa¨: contactos de señalización están en modo ¨ALARMA¨ incluso en caso si haya una función ¨alarma sin armamento¨
1099	Нарушение ОШС в режиме ТРЕВОГА	2	7	\N	\N	Security alarm line violation in the ALARM mode	Violation de ligne d'alarme de sécurité dans le mode ALARME	Violazione del ciclo d'allarme nella modalità ALARME	Violación de contactos de señalización en modo ¨ALARMA¨
1100	Восстановление ОШС в режиме ТРЕВОГА	2	7	\N	\N	Security alarm line recovery in ALARM mode	Restauration de la ligne d'alarme de sécurité dans le mode ALARME	Ripristino del ciclo di allarme in modo ALLARME	Recuperación de contactos de señalización en modo ¨ALARMA¨
1103	Сброс тревоги ОШС	2	7	\N	\N	Reset alarm of the security alarm line	Réinitialisation de l'alarme de la ligne d'alarme de sécurité	Reset di allarme del ciclo di allarme	Reseteo de alarma de contactos de señalización
501203	Удаление подразделения	10012	\N	\N	\N	Department removal	Supprimer le département	Eliminazione del reparto	Eliminación de departamento
1177	Изменение режима работы по команде оператора: режим "Совещание"	6	1	\N	\N	Changing the operating mode by the operator command: "Conference" mode	Changement du mode de fonctionement par la commande de l'opérateur: le mode \\"Conférence\\"	Modifica del modo di funzionamento sull'ordine di operatore: modo "Riunione"	Сambio de modo de operación por orden del operador:modo "Conferencia"
1178	Изменение режима работы по команде ИК-пульта: режим "Совещание"	6	1	\N	\N	Changing the operating mode by the IR-remote command: "Conference" mode	Changement du mode de fonctionement par la commande du pupitre de commande infrarouge: le mode \\"Conférence\\"	Modifica del modo di funzionamento sull'ordine di telecomando IR: modo "Riunione"	Сambio de modo de operación por orden del panel decontrol remoto: modo "Conferencia"
1182	Изменение режима работы с режима "Охрана" по идентификатору: режим "Совещание"	6	1	\N	\N	Changing the operating mode from the "Security" mode by the identifier: "Conference" mode	Changement du mode de fonctionement du mode\\"Sécurité\\" par l'identifiant: le mode \\"Conférence\\"	Modifica del modo di funzionamento dal modo "Protezione" sull'identificatore: modo "Riunione"	Сambio de modo de operación del modo "Seguridad" poridentificador: modo "Conferencia"
1273	Восстановление после неисправности контроллера 2-го уровня	6	1	\N	\N	Recovery after a failure of controller of level 2	Reprise après la défaillance du contrôleur du deuxième niveau	Ripristino dopo un errore del controller del secondo livello	Recuperación después de una avería en un controladorde segundo nivel
1297	Проход по идентификатору: с несоответствием текущему местоположению и с нарушением комиссионирования	1	1	\N	\N	Passage with the ID: with the mismatch to the current location and with double-check access violation	Passage par identifiant: non confotmité d'emplacement actuel et avec la violation de révérification	Passaggio sull'identificatore: con la non conformità alla posizione corrente e con ala violazione di doppio controllo	Paso por identificador: con disconformidad con la localización corriente y con violación de confirmación doble de acceso
1553	Проход по идентификатору: с несоответствием временным критериям доступа и с нарушением комиссионирования	1	1	\N	\N	Passage with the ID: with the mismatch to the time access criteria and with double-check access violation	Passage par identifiant: non confotmité de critères de temps d'accès et la violation de révérification	Passaggio sull'identificatore: con la non conformità ai criteri temporali di accesso  e con la violazione del doppio controllo	Paso por identificador: con disconformidad con los criteriosde acceso de tiempo y en caso de denegación deconfirmación de paso de verificación y con violación de confirmación doble de acceso
1809	Проход по идентификатору: несоответствие временным критериям доступа и текущему местоположению и с нарушением комиссионирования	1	1	\N	\N	Passage with the ID: mismatch to the time access criteria and to the current location and with the double-check access violation	Passage par identifiant: non confotmité des critères de temps d'accès et d'emplacement actuel avec la violation de révérification	Passaggio sull'identificatore: non conformità ai criteri temporali di accesso e alla posizione attuale e con la violazione del doppio controllo	Paso por identificador: disconformidad con los criterios deacceso de tiempo y localización corriente y con violaciónde confirmación doble de acceso
2056	Запрет прохода: отказ в подтверждении прохода от верификации	1	1	\N	\N	Passage denial: passage disaffirmance from the verification	Refus de passage: le refus de la confirmation de passage de la vérification	Passaggio bloccato: divieto autorizzazione passaggio dalla verifica	Denegación de paso: denegación de confirmación de armamento de verificación
2065	Проход по идентификатору: при отказе в подтверждении прохода от верификации	1	1	\N	\N	Passage with the ID: in case of failure to confirm the passage by verification	Passage par identifiant: en cas de refus de confirmation de passage de la vérification	Passaggio sull'identificatore: manca l'autorizzazione del passaggio della verifica	Paso por identificador: en caso de denegación deconfirmación de paso de verificación
2082	Попытка взятия ОЗ (невозможно взять) по идентификатору: отказ в подтверждении взятия от верификации	2	6	\N	\N	Attempt to arm the protected zone (can not be armed) by the identifier: refusal of arming confirmation from the verification	Tentative d'activation du mode de sécurité de la zone sécurisée (impossible d'armer) avec l'identifiant: le refus de confirmation d'activation du mode de sécurité de la vérification	Il tentativo di messa della Zona di protezione (non può essere messa) sull'identificatore: il rifiuto della conferma della messa dalla verifica	Intento de armar la zona protegida(no puede ser armada)por identificador: denegación de confirmación de armamento de verificación
2090	Попытка снятия ОЗ (невозможно снять) по идентификатору: отказ в подтверждении снятия от верификации	2	6	\N	\N	Attempt to disarm the protected zone (can not be disarmed) by the identifier: denial of disarmour confirmation from the verification	Tentative du retrait de la protection de la zone sécurisée (impossible de désarmer) avec l'identifiant:Retrait de la protection de vérification refusé	Il tentativo di togliere la Zona di protezione (non può essere tolta) sull'identificatore: il rifiuto di accettazione del togliere dalla verifica	Intento de desarmar la zona protegida(no puede serdesarmada) por identificador: denegación de confirmación de armamento de verificación
2187	Неисправность контроллера: часы RTC	6	\N	\N	\N	Fault of controller: RTC clock	Défaillance du contrôleur : l'horloge temps réel (RTC)	Guasto controller: orologio RTC	Avería de un controlador: RTC reloj
2192	Форматирование памяти: прошивка	6	\N	\N	\N	Memory formating: firmware	Formatage de mémoire: le logiciel	Formattazione della memoria: brocciatura	Formateo de memoria: firmware
5446	Обрыв двухпроводной линии связи	6	\N	\N	\N	Two-wire line fault	Обрыв двухпроводной линии связи	Обрыв двухпроводной линии связи	Обрыв двухпроводной линии связи
2201	Изменение режима работы по команде оператора: режим "Закрыто"	6	1	\N	\N	Changing the operating mode by the operator command: "Closed" mode	Changement du mode de fonctionement  par la commande de l'opérateur: le mode \\"Fermé\\"	Modifica del modo di funzionamento sull'ordine di operatore: modo "Chiuso"	Сambio de modo de operación por orden del operador:modo "Cerrado"
2202	Изменение режима работы по команде ИК-пульта: режим "Закрыто"	6	1	\N	\N	Changing the operating mode by the IR-remote command: "Closed" mode	Changement du mode de fonctionement par la commande du pupitre de commande infrarouge: le mode \\"Fermé\\"	Modifica del modo di funzionamento sull'ordine di telecomando IR: modo "Chiuso"	Сambio de modo de operación por orden del panel decontrol remoto: modo "Cerrado"
2321	Проход по идентификатору: с несоответствием текущему местоположению и при отказе в подтверждении прохода от верификации	1	1	\N	\N	Passage with the ID: with the mismatch to the current location and in case of failure to confirm the passage by verification	Passage par identifiant: non confotmité d'emplacement actuel en cas de refus de confirmation de passage de la vérification	Passaggio sull'identificatore: con la non conformità alla posizione attuale e nel caso di mancanza dell'autorizzazione di passaggio da parte della verifica	Paso por identificador: con disconformidad con la localización corriente y en caso de denegación de confirmación de paso de verificación
2577	Проход по идентификатору: с несоответствием временным критериям доступа и при отказе в подтверждении прохода от верификации	1	1	\N	\N	Passage with the ID: with the mismatch to the time access criteria and in case of failure to confirm the passage by verification	Passage par identifiant: non confotmité de critères de temps d'accès et le refus de confirmation de passage de la vérification	Passaggio sull'identificatore: con la non conformità ai criteri temporali di accesso e quando manca l'autorizzazione del passaggio della verifica	Paso por identificador: con disconformidad con los criteriosde acceso de tiempo y en caso de denegación deconfirmación de paso de verificación
2833	Проход по идентификатору: несоответствие временным критериям доступа и текущему местоположению и при отказе в подтверждении прохода от верификации	1	1	\N	\N	Passage with the ID: mismatch to the time access criteria and to the current location and with the failure to confirm the passage by verification	Passage par identifiant: non confotmité des critères de temps d'accès et d'emplacement actuel en cas de refus de confirmation de passage  de la vérification	Passaggio sull'identificatore: non conformità ai criteri temporali di accesso  e alla posizione attuale e quando manca l'autorizzazione del passaggio della verifica	Paso por identificador: disconformidad con los criterios deacceso de tiempo y localización corriente y en caso de denegación de confirmación de paso de verificación
4113	Проход с подтверждением от ВВУ	1	1	\N	\N	Passage with verification from external verification device	Passage avec la confirmation du dispositif de vérification externe	Passaggio con la conferma dal dispositivo esterno di verificazione	Paso con confirmación del dispositivo de verificación externa
4130	Попытка взятия ОЗ (невозможно взять) по идентификатору: нарушение состояния ресурса ИУ	2	6	\N	\N	Attempt to arm the protected zone (can not be armed) by the identifier: violation of the device resource state	Tentative d'activation du mode de sécurité de la zone sécurisée (impossible d'armer) avec l'identifiant: la violation d'état de ressource du dispositif	ll tentativo di messa della Zona di protezione (non può essere messa) sull'identificatore: violazione dello stato delle risorse del Dispositivo esecutivo	Intento de armar la zona protegida(no puede ser armada)por identificador: violación de estatus de recurso dedispositivo
4149	Попытка взятия ОЗ (невозможно взять) по команде оператора: нарушение состояния ресурса ИУ	2	6	\N	\N	Attempt to arm the protected zone (can not be armed) by the operator command: violation of the device resource state	Tentative d'activation du mode de sécurité de la zone sécurisée (impossible d'armer) sous la commande de l'opérateur: la violation d'état de ressource du dispositif	Il tentativo di messa della Zona di protezione (non può essere messa) sul comando dell'operatore: violazione dello stato di risorse del dispositivo esecutivo	Intento de armar la zona protegida(no puede ser armada)por orden del operador: violación de estatus de recurso del dispositivo
4235	Неисправность контроллера: шина I2C	6	\N	\N	\N	Fault of controller: I2C wire	Défaillance du contrôleur : le fil l2C	Guasto controller: sbarra conduttrice I2C	Avería de un controlador: barra I2C
4240	Форматирование памяти: текущие установки (режимы работы и т.д.)	6	\N	\N	\N	Memory formating: the current settings (operating modes, etc.)	Formatage de mémoire: les paramètres actuels (les modes de fonctionnement, etc)	Formattazione della memoria: impostazioni correnti (modalità operative, ecc)	Formateo de memoria: ajustes corrientes(modos deoperación y etc.)
4249	Изменение режима работы по команде оператора: режим "Охрана"	6	1	\N	\N	Changing the operating mode by the operator command: "Security" mode	Changement du mode de fonctionement par la commande de l'opérateur: le mode \\"Sécurité\\"	Modifica del modo di funzionamento sull'ordine di operatore: modo "Protezione"	Сambio de modo de operación por orden del operador:modo "Seguridad"
4253	Изменение режима работы на режим "Охрана" по идентификатору	6	1	\N	\N	Changing the operating mode to the "Security" mode by the identifier: "Security" mode	Changement du mode de fonctionement au mode \\"Sécurité\\" par l'identifiant: le mode \\"Sécurité\\"	Modifica del modo di funzionamento a "Protezione" con l'identificatore: modo "Protezione"	Сambio de modo de operación al modo ¨Seguridad¨ poridentificador: modo "Seguridad"
4254	Изменение режима работы на режим "Охрана" по идентификатору с нарушением времени	6	1	\N	\N	Changing the operating mode to the "Security" mode by the identifier	Changement du mode de fonctionement au mode "Sécurité" par l'identifiant	Modifica del modo di funzionamento a "Protezione" con l'identificatore	Сambio de modo de operación al modo ¨Seguridad¨ poridentificador
4255	Изменение режима работы на режим "Охрана" по идентификатору с нарушением местоположения	6	1	\N	\N	Changing the operating mode to the "Security" mode by the identifier	Changement du mode de fonctionement au mode "Sécurité" par l'identifiant	Modifica del modo di funzionamento a "Protezione" con l'identificatore	Сambio de modo de operación al modo ¨Seguridad¨ poridentificador
4256	Изменение режима работы на режим "Охрана" по идентификатору с нарушением времени и местоположения	6	1	\N	\N	Changing the operating mode to the "Security" mode by the identifier	Changement du mode de fonctionement au mode "Sécurité" par l'identifiant	Modifica del modo di funzionamento a "Protezione" con l'identificatore	Сambio de modo de operación al modo ¨Seguridad¨ poridentificador
4369	Проход с подтверждением от ВВУ: с несоответствием текущему местоположению	1	1	\N	\N	Passage with verification from external verification device: with a mismatch to current location	Passage avec la confirmation du dispositif de vérification externe: avec le non-conformité de l'emplacement actuel	Passaggio con la conferma dall’impianto esterno di verificazione: con la mancanza della conformità con la locazione attuale	Paso con confirmación del dispositivo de verificación externa:con disconformidad a la localización corriente
4625	Проход с подтверждением от ВВУ: с несоответствием временным критериям доступа	1	1	\N	\N	Passage with verification from external verification device: with a mismatch to access time criteria	Passage avec la confirmation du dispositif de vérification externe: avec le non-conformité des critères d'accès temporels	Passaggio con la conferma dall’impianto esterno di verificazione: con la mancanza della conformità con i criteri temporali d’accesso	Paso con confirmación del dispositivo de verificación externa:con disconformidad a los criterios de acceso temporales
4881	Проход с подтверждением от ВВУ: с несоответствием временным критериям доступа и текущему местоположению	1	1	\N	\N	Passage with verification from external verification device: with a mismatch of access time criteria and current location	Passage avec la confirmation du dispositif de vérification externe: avec le non-conformité des critères d'accès temporels et l'emplacement actuel	Passaggio con la conferma dall’impianto esterno di verificazione: con la mancanza della conformità con i criteri temporali d’accesso e la locazione attuale	Paso con confirmación del dispositivo de verificación externa: con disconformidad a los criterios temporales de acceso
5000	Ошибка конфигурации - группа на охране или в тревоге	15	\N	\N	\N	Configuration error - group under security or in alarm	Erreur de configuration - le groupe est sous la sécurité ou en alarme	Errore di configurazione - gruppo sotto protezione o in allarme	Error de configuración - un grupo bajo seguridad o en alarma
5001	Ошибка конфигурации - ресурс на охране или в тревоге	15	7	\N	\N	Configuration error - resoource under security or in alarm	Erreur de configuration - la ressource est sécurisée ou en alarme	Errore di configurazione - la risorsa è sulla Protezione o in allarme	Error de configuración  - el recurso está bajo armamento o estado de alarma
5002	Ошибка управления - ресурс на охране	15	7	\N	\N	Management error - resource protected	Erreur de gestion - la ressource est protégéée	L'errore di gestione - risorsa protetta	Error de administración - recurso bajo seguridad
5003	Ошибка управления - ресурс ставится охрану	15	7	\N	\N	Operation error - security mode for the resource is activating	Erreur de contrôle - la ressource est en cours d'armement	Errore di operazione - la risorsa si mette alla Protezione	Error de operación - el recurso en la actualidad está en proceso de armamento
5004	Ошибка управления - контроллер форматируется	15	\N	\N	\N	Operation error - controller is being formatted	Erreur de contrôle -  le contrôleur est formaté	Errore di operazione - il controller sta formattando	Error de operación - el controlador se esta formateando
5005	Ошибка конфигурации - превышение максимального количества карт сотрудников	15	\N	\N	\N	Configuration error - maximum amount of employees' cards is exceeded	Erreur de configuration - le nombre maximal de cartes d'émployés dépasse	Errore di configurazione - il numero massimale delle card di impiegati è sovrappassato	Error de configuración  - superación de cantidad máxima de tarjetas de los empleados
5006	Изменение конфигурации устройства	1	1	\N	\N	Change device configuration	Changement de configuration du dispositif	Modificare configurazione del dispositivo	Cambio de configuración del dispositivo
5007	Запрет прохода: неисправны датчики ИУ	1	1	\N	\N	Passage denial: device sensors fault	Refus de passage: la défaillance des détecteurs du dispositif	Divieto di passaggio: i sensori del dispositivo esecutivo sono guasti	Denegación de paso: sensores del dispositivo son defectuosos
5008	Запрет прохода: смена РКД	1	1	\N	\N	Passage denial: access control mode change	Refus de passge: le changement du mode du contrôle d'accès	Divieto di passaggio: cambiamento del regime di controllo accessi	Denegación de paso: cambio de modo de control de acceso
5009	Запрет прохода: таймаут верификации	1	\N	\N	\N	Passage denial: verification time out	Refus de passage: la temporisation de la vérification	Divieto di passaggio: time-out di verificazione	Denegación de paso
5010	Очистка событий журнала регистрации	1	\N	\N	\N	Registration log events cleaning	Suppression des événements du log	Cancellazione degli eventi del giornale di registrazione	Limpia de eventos del libro de registro
5011	Ошибка записи отпечатка в контроллер	15	\N	\N	\N	Fingerptint record to the controller error	Erreur d'enregistrement de l'empreinte au contrôleur	Errore di registrazione della impronta nel controller	Error de registro de huella dactilar al controlador
5012	Ошибка записи в базу данных контроллера	15	\N	\N	\N	Record to the controller database error	Erreur d'enregistrement à la base de données du contrôleur	Errore di registrazione nella banca dati del controller	Error de registro al base de datos del controlador
501401	Добавление сотрудника	10014	\N	\N	\N	Employee adding	Ajout l'employé	Aggiunta di un impiegato	Adición de empleado
5013	Ошибка изменения сетевых параметров контроллера - включен режим DHCP	15	\N	\N	\N	Controller network parameters change error - DHCP mode is on	Erreur de changement des paramètres réseau du contrôleur - le mode DHCP est activé	Errore di cambiamento dei parametri della rete del controller - il regime DHCP è avviato	Error de cambio de parámetros de red del controlador - DHCP modo es activo
5100	Дверь открыта	1	1	\N	\N	The door is open	Porte est ouverte	La porta è aperta	La puerta está abierta
5101	Дверь закрыта	1	1	\N	\N	The door is closed	Porte est fermée	La porta è chiusa	La puerta está cerrada
5102	Дверь разблокирована по команде с ПК	1	1	\N	\N	Door is unlocked by signal from PC	Porte est débloquée par la commande de l'ordinateur	La porta è sbloccata dal segnale dal PC	La puerta está desbloqueada por señal de CP
5103	Дверь заблокирована  по команде с ПК	1	1	\N	\N	Door is blocked by a command from PC	Porte est bloquée par la commande de l'ordinateur	La porta è chiusa sull'ordine dal computer	Puerta está bloqueada por comando desde
5104	Отпечаток не распознан	1	1	\N	\N	Fingerprint is not identified	Empreinte n'est pas reconnue	L’impronto non è identificato	Huella dactilar no está indicado
5105	Ошибка авторизации	1	1	\N	\N	Authorization error	Erreur d'autorisation	Errore di autorizzazione	Error de autorización
5106	Дверь не закрыта после прохода	1	1	\N	\N	The door is not closed after the passage	Porte n'est pas fermée après le passage	La porta non è chiusa dopo il passaggio	La puerta no está cerrada después del paso
5107	ИУ разблокировано	5	13	\N	\N	Device unlocked	Dispositif est débloqué	Dispositivo esecutivo sbloccato	Dispositivo está desbloqueado
5108	ИУ заблокировано	5	13	\N	\N	Device is blocked	Dispositif est bloqué	Dispositivo esecutivo è bloccato	Dispositivo está bloqueado
5109	Вход в шлюз	1	1	\N	\N	Entry to a gateway	Entrée dans l'écluse	Entrata nella chiusa	Entrada a la esclusa
5110	Выход из шлюза	1	1	\N	\N	Exit from a gateway	Sortie de l'écluse	Uscita dalla chiusa	Salida de la esclusa
5111	Выход из шлюза запрещён: некорректный идентификатор	1	1	\N	\N	Exit from a gateway is prohibited: incorrect identifier	Sortie de l'écluse est interdite: l'identifiant n'est pas valide	Uscita dalla chiusa è vietata: l'identificatore scorretto	Salida de la esclusa está prohibida: identificador inválido
5112	Выход из шлюза запрещён по команде от ДУ	1	1	\N	\N	Exit from a gateway is prohibited by command from RC	Sortie de l'écluse est interdite par la commande du pupitre de commandes	Uscita dalla chiusa è vietata sull'ordine dal commando a distanza	Salida de la esclusa está prohibida por comando desde control remoto
5113	Выход из шлюза запрещён по команде оператора ПК	1	1	\N	\N	Exit from a gateway is prohibited by PC operator	Sortie de l'écluse est interdite par la commande de l'opérateur d'ordinateur	Uscita dalla chiusa è vietata sull'ordine dall'operatore di computer	Salida de esclusa está prohibida por comando del operador del PC
5114	Доступ запрещён: направление прохода заблокировано другим считывателем	1	1	\N	\N	Access denied: passage directoin is blocked by another reader	Accès est interdit: la direction du passage est bloquée par d'autre lecteur	L'accesso vietato: la direzione di passaggio è bloccata da un altro lettore	Acceso denegado: dirección de paso está bloqueada por otro lector
5115	Превышение времени пребывания в шлюзе	1	1	\N	\N	Stay in a gateway overtime	Temps de présence dans l'écluse est dépassé	Il tempo di presenza nella chiusa è sovrappassato	Exceso de tiempo de permanencia en la esclusa
5116	Нарушение режима доступа в шлюз	1	1	\N	\N	Violation of an access mode to gateway	Violation du mode d'accès dans l'écluse	Violazione del regime di accesso nella chiusa	Violación de régimen de acceso a la esclusa
5117	Вход в шлюз по команде от ДУ	1	1	\N	\N	Entry to a gateway by  the remote control command	Entrée dans l'écluse par la commande du pupitre de commandes	Entrata nella chiusa sull'ordine dal computer	Entrada a la esclusa por comando del control remoto
5118	Вход в шлюз по команде оператора ПК	1	1	\N	\N	Entry to a gateway by PC operator command	Entrée dans l'écluse par la commande de l'opérateur de l'ordinateur	Entrata nella chiusa sull'ordine dall'operatore di computer	Entrada a la esclusa por comando del operador de PC
5119	Выход из шлюза по команде от ДУ	1	1	\N	\N	Exit from a gateway by a command from RC	Sortie de l'écluse par la commande du pupitre de commandes	Uscita dalla chiusa sull'ordine dal commando a distanza	Salida de la esclusa por comando del control remoto
5120	Выход из шлюза по команде оператора ПК	1	1	\N	\N	Exit from a gateway by a command from PC operator	Sortie de l'écluse par la commande de l'opérateur de l'ordinateur	Uscita dalla chiusa sull'ordine dall'operatore di computer	Salida de la esclusa por comando del operador de PC
5121	Выход из шлюза запрещён по команде от ДУ	1	1	\N	\N	Exit from a gateway is prohibited by command from RC	Sortie de l'écluse est interdite par la commande du pupitre de commandes	Uscita dalla chiusa è vietata sull'ordine dal commando a distanza	Salida de la esclusa está prohibida por comando desde control remoto
5122	Выход из шлюза запрещён по команде оператора ПК	1	1	\N	\N	Exit from a gateway is prohibited by PC operator	Sortie de l'écluse est interdite par la commande de l'opérateur d'ordinateur	Uscita dalla chiusa è vietata sull'ordine dall'operatore di computer	Salida de esclusa está prohibida por comando del operador del PC
5123	Превышение времени пребывания в шлюзе	1	1	\N	\N	Stay in a gateway overtime	Temps de présence dans l'écluse est dépassé	Il tempo di presenza nella chiusa è sovrappassato	Exceso de tiempo de permanencia en la esclusa
5124	Нарушение режима доступа в шлюз	1	1	\N	\N	Violation of an access mode to gateway	Violation du mode d'accès dans l'écluse	Violazione del regime di accesso nella chiusa	Violación de régimen de acceso a la esclusa
5201	Запрет прохода через мобильный терминал: нарушение времени	1	1	\N	\N	Passage denial from mobile terminal: time violation	Запрет прохода через мобильный терминал: нарушение времени	Запрет прохода через мобильный терминал: нарушение времени	Запрет прохода через мобильный терминал: нарушение времени
5202	Проход без медицинской маски	1	1	\N	\N	Passage without a medical mask	Passage sans masque médical	Passaggio senza maschera medica	Passage without a medical mask
5203	Проход с повышенной температурой 	1	1	\N	\N	Passage with high temperature	Passage à haute température	Passaggio ad alta temperatura	Paso con alta temperatura
5300	Сигнал потерян	17	\N	\N	\N	Signal lost	Signal lost	Signal lost	Signal lost
5301	Сигнал восстановлен	17	\N	\N	\N	Signal restored	Signal restored	Signal restored	Signal restored
5302	Обнаружено возгорание	17	\N	\N	\N	Fire detected	Fire detected	Fire detected	Fire detected
5303	Обнаружено задымление	17	\N	\N	\N	Smoke detected	Smoke detected	Smoke detected	Smoke detected
5304	Возгорание прекращено	17	\N	\N	\N	Fire stopped	Fire stopped	Fire stopped	Fire stopped
5305	Задымление прекращено	17	\N	\N	\N	Smoke stopped	Smoke stopped	Smoke stopped	Smoke stopped
5306	Обнаружено лицо	17	\N	\N	\N	Face detected	Face detected	Face detected	Face detected
5307	Обнаружен оставленный предмет	17	\N	\N	\N	Item missing	Item missing	Item missing	Item missing
5308	Обнаружена группа людей	17	\N	\N	\N	People detected	People detected	People detected	People detected
5309	Обнаружено вторжение	17	\N	\N	\N	Intrusion detected	Intrusion detected	Intrusion detected	Intrusion detected
5310	Огнестрельное оружие	17	\N	\N	\N	Gunshot	Gunshot	Gunshot	Gunshot
5311	Взрыв	17	\N	\N	\N	Explosion	Explosion	Explosion	Explosion
5312	Разбитие стекла	17	\N	\N	\N	Glassbreak	Glassbreak	Glassbreak	Glassbreak
5313	Скопление людей	17	\N	\N	\N	Gathering	Gathering	Gathering	Gathering
5314	Обнаружен крик	17	\N	\N	\N	Scream detected	Scream detected	Scream detected	Scream detected
5404	Помеха	18	\N	\N	\N	Obstruction	Помеха	Помеха	Помеха
5406	Помеха устранена	18	\N	\N	\N	Obstruction removed	Помеха устранена	Помеха устранена	Помеха устранена
5409	Активация устройства дистанционного пуска	18	\N	\N	\N	Device remote start activation	Активация устройства дистанционного пуска	Активация устройства дистанционного пуска	Активация устройства дистанционного пуска
5410	Восстановление устройства дистанционного пуска	18	\N	\N	\N	Device remote start restoration	Восстановление устройства дистанционного пуска	Восстановление устройства дистанционного пуска	Восстановление устройства дистанционного пуска
5417	Неудачное взятие на охрану	18	\N	\N	\N	ARMED mode failure	Неудачное взятие на охрану	Неудачное взятие на охрану	Неудачное взятие на охрану
5418	Предъявлен код принуждения	18	\N	\N	\N	Duress code entered	Предъявлен код принуждения	Предъявлен код принуждения	Предъявлен код принуждения
5419	Тест извещателя	18	\N	\N	\N	Detector test	Тест извещателя	Тест извещателя	Тест извещателя
5420	Включение тестирования	18	\N	\N	\N	Test activation	Включение тестирования	Включение тестирования	Включение тестирования
5421	Выключение тестирования	18	\N	\N	\N	Test disactivation	Выключение тестирования	Выключение тестирования	Выключение тестирования
5422	Восстановление контроля входа	18	\N	\N	\N	Input control recovery	Восстановление контроля входа	Восстановление контроля входа	Восстановление контроля входа
5423	Задержка взятия	18	\N	\N	\N	Arming delay	Задержка взятия	Задержка взятия	Задержка взятия
5424	Взятие зоны на охрану	18	6	\N	\N	Взятие входа на охрану	Взятие входа на охрану	Взятие входа на охрану	Взятие входа на охрану
5434	Идентификация пользователя	18	\N	\N	\N	User identification	Идентификация пользователя	Идентификация пользователя	Идентификация пользователя
5437	Пожарная тревога	18	\N	\N	\N	Fire alarm	Fire alarm	Fire alarm	Fire alarm
5439	Восстановление нормы оборудования	18	\N	\N	\N	Restoring the normal equipment	Восстановление нормы оборудования	Восстановление нормы оборудования	Восстановление нормы оборудования
5441	Неисправность оборудования	18	\N	\N	\N	Equipment fault	Неисправность оборудования	Неисправность оборудования	Неисправность оборудования
5444	Опасность пожара	18	\N	\N	\N	Fire danger	Опасность пожара	Опасность пожара	Опасность пожара
5445	Обрыв входа	6	\N	\N	\N	Input breakdown	Обрыв входа	Обрыв входа	Обрыв входа
501122	Редактирование опций календаря	10011	\N	\N	\N	Calendar options editing	Editer les options du calendrier	Modificare gli opzioni del calendario	Edición de opciónes del calendario
5447	Восстановление двухпроводной линии связи	6	\N	\N	\N	Two-wire line restoration	Восстановление двухпроводной линии связи	Восстановление двухпроводной линии связи	Восстановление двухпроводной линии связи
5490	Неисправность канала связи	6	\N	\N	\N	Channel fault	Неисправность канала связи	Неисправность канала связи	Неисправность канала связи
5491	Восстановление канала связи	6	\N	\N	\N	Channel restoration	Восстановление канала связи	Восстановление канала связи	Восстановление канала связи
5509	Снятие зоны с охраны	18	6	\N	\N	Снятие входа с охраны	Снятие входа с охраны	Снятие входа с охраны	Снятие входа с охраны
5510	Сброс тревоги	18	\N	\N	\N	Alarm reset	Сброс тревоги	Сброс тревоги	Сброс тревоги
5517	Восстановление снятого входа	18	\N	\N	\N	Restoring the disarmed input	Восстановление снятого входа	Восстановление снятого входа	Восстановление снятого входа
5518	Тревога входной зоны	18	\N	\N	\N	Entry zone alarm	Тревога входной зоны	Тревога входной зоны	Тревога входной зоны
5519	Нарушение снятого входа	18	\N	\N	\N	Disarmed input violation	Нарушение снятого входа	Нарушение снятого входа	Нарушение снятого входа
5521	Обрыв выхода	6	\N	\N	\N	Output breakdown	Обрыв выхода	Обрыв выхода	Обрыв выхода
5522	Короткое замыкание выхода	6	\N	\N	\N	Output short circuit	Короткое замыкание выхода	Короткое замыкание выхода	Короткое замыкание выхода
5523	Восстановление выхода	6	\N	\N	\N	Restoring the output	Восстановление выхода	Восстановление выхода	Восстановление выхода
5526	Потеря связи с выходом	6	\N	\N	\N	Output connection lost	Потеря связи с выходом	Потеря связи с выходом	Потеря связи с выходом
5527	Восстановление связи с выходом	6	\N	\N	\N	Output connection restored	Восстановление связи с выходом	Восстановление связи с выходом	Восстановление связи с выходом
5528	Изменение состояния выхода	18	\N	\N	\N	Output state change	Изменение состояния выхода	Изменение состояния выхода	Изменение состояния выхода
5530	Включение насоса	18	\N	\N	\N	Activating pump	Включение насоса	Включение насоса	Включение насоса
5531	Выключение насоса	18	\N	\N	\N	Включение насоса	Включение насоса	Включение насоса	Включение насоса
5536	Восстановление напряжения питания	18	\N	\N	\N	Recovery of supply voltage	Восстановление напряжения питания	Восстановление напряжения питания	Восстановление напряжения питания
5537	Пуск	18	\N	\N	\N	Start	Пуск	Пуск	Пуск
5539	Неудачный пуск АУП	18	\N	\N	\N	AFS start failure	Неудачный пуск АУП	Неудачный пуск АУП	Неудачный пуск АУП
5541	Задержка пуска АУП	18	\N	\N	\N	AFS start delay	Задержка пуска АУП	Задержка пуска АУП	Задержка пуска АУП
5542	Автоматика АУП выключена	18	\N	\N	\N	AFS automatics is turned off	Автоматика АУП выключена	Автоматика АУП выключена	Автоматика АУП выключена
5543	Отмена пуска АУП	18	\N	\N	\N	AFS start cancellation	Отмена пуска АУП	Отмена пуска АУП	Отмена пуска АУП
5544	Тушение АУП	18	\N	\N	\N	AFS extinction	Тушение АУП	Тушение АУП	Тушение АУП
5545	Аварийный пуск АУП	18	\N	\N	\N	AFS emergency start	Аварийный пуск АУП	Аварийный пуск АУП	Аварийный пуск АУП
5546	Пуск АУП	18	\N	\N	\N	AFS start	Пуск АУП	Пуск АУП	Пуск АУП
5547	Блокировка пуска АУП	18	\N	\N	\N	AFS start block	Блокировка пуска АУП	Блокировка пуска АУП	Блокировка пуска АУП
5548	Автоматика АУП включена	18	\N	\N	\N	AFS automatics is turned on	Автоматика АУП включена	Автоматика АУП включена	Автоматика АУП включена
5550	Пуск речевого оповещения	18	\N	\N	\N	Activating voice announcement	Пуск речевого оповещения	Пуск речевого оповещения	Пуск речевого оповещения
5551	Отмена пуска речевого оповещения	18	\N	\N	\N	Disactivating voice announcement	Отмена пуска речевого оповещения	Отмена пуска речевого оповещения	Отмена пуска речевого оповещения
5553	ИУ в рабочем состоянии	6	\N	\N	\N	OD is in the operating state	ИУ в рабочем состоянии	ИУ в рабочем состоянии	ИУ в рабочем состоянии
5554	ИУ в исходном состоянии	6	\N	\N	\N	OD is in the initial state	ИУ в исходном состоянии	ИУ в исходном состоянии	ИУ в исходном состоянии
5555	Отказ ИУ	6	\N	\N	\N	OD denial	Отказ ИУ	Отказ ИУ	Отказ ИУ
5556	Ошибка ИУ	6	\N	\N	\N	OD error	Ошибка ИУ	Ошибка ИУ	Ошибка ИУ
501201	Добавление подразделения	10012	\N	\N	\N	Department adding	Ajouter le département	Aggiungere un reparto	Adición de departamento
5558	Восстановление внутренней зоны	18	\N	\N	\N	Inner zone recovery	Восстановление внутренней зоны	Восстановление внутренней зоны	Восстановление внутренней зоны
5559	Задержка пуска речевого оповещения	18	\N	\N	\N	Voice announcement activation delay	Задержка пуска речевого оповещения	Задержка пуска речевого оповещения	Задержка пуска речевого оповещения
5561	Останов задержки пуска АУП	18	\N	\N	\N	AFS start delay interruption	Останов задержки пуска АУП	Останов задержки пуска АУП	Останов задержки пуска АУП
5587	Потеря связи с входом	6	\N	\N	\N	Input connection lost	Потеря связи с входом	Потеря связи с входом	Потеря связи с входом
5588	Восстановление связи со входом	6	\N	\N	\N	Recovery of input connection	Восстановление связи со входом	Восстановление связи со входом	Восстановление связи со входом
5589	Потеря связи в двухпроводной линии	6	\N	\N	\N	Connection on a two-wire line is lost	Потеря связи в двухпроводной линии	Потеря связи в двухпроводной линии	Потеря связи в двухпроводной линии
5591	Восстановление связи в двухпроводной линии	6	\N	\N	\N	Connection on a two-wire line is restored	Восстановление связи в двухпроводной линии	Восстановление связи в двухпроводной линии	Восстановление связи в двухпроводной линии
5592	Отключение выходного напряжения	6	\N	\N	\N	Disabling the output voltage	Отключение выходного напряжения	Отключение выходного напряжения	Отключение выходного напряжения
5593	Подключение выходного напряжения	6	\N	\N	\N	Enabling the output voltage	Подключение выходного напряжения	Подключение выходного напряжения	Подключение выходного напряжения
5594	Перегрузка источника питания	6	\N	\N	\N	Power supply overload	Перегрузка источника питания	Перегрузка источника питания	Перегрузка источника питания
5595	Перегрузка источника устранена	6	\N	\N	\N	Power supply overload removed	Перегрузка источника устранена	Перегрузка источника устранена	Перегрузка источника устранена
5600	Восстановление батареи	6	\N	\N	\N	Battery recovery	Восстановление батареи	Восстановление батареи	Восстановление батареи
5602	Неисправность батареи	6	\N	\N	\N	Battery fault	Неисправность батареи	Неисправность батареи	Неисправность батареи
5603	Перезапуск устройства	6	\N	\N	\N	Restarting the device	Перезапуск устройства	Перезапуск устройства	Перезапуск устройства
5604	Требуется обслуживание	6	\N	\N	\N	Maintenance is required	Требуется обслуживание	Требуется обслуживание	Требуется обслуживание
5611	Разряд батареи	6	\N	\N	\N	Battery drain	Разряд батареи	Разряд батареи	Разряд батареи
5613	Восстановление батареи	6	\N	\N	\N	Battery recovery	Восстановление батареи	Восстановление батареи	Восстановление батареи
5614	Короткое замыкание входа	6	\N	\N	\N	Input short circuit	Короткое замыкание входа	Короткое замыкание входа	Короткое замыкание входа
5615	Короткое замыкание двухпроводной линии связи	6	\N	\N	\N	Short circuit in two-wire line	Короткое замыкание двухпроводной линии связи	Короткое замыкание двухпроводной линии связи	Короткое замыкание двухпроводной линии связи
5616	Сработка датчика	18	\N	\N	\N	Sensor activated	Сработка датчика	Сработка датчика	Сработка датчика
5617	Отключение линии связи RS-485	6	\N	\N	\N	Disable RS-485 connection line	Отключение линии связи RS-485	Отключение линии связи RS-485	Отключение линии связи RS-485
5618	Восстановление линии связи RS-485	6	\N	\N	\N	Enable RS-485 connection line	Восстановление линии связи RS-485	Восстановление линии связи RS-485	Восстановление линии связи RS-485
5622	Повышение напряжения двухпроводной линии связи	6	\N	\N	\N	Voltage boost on a two-wire line	Повышение напряжения двухпроводной линии связи	Повышение напряжения двухпроводной линии связи	Повышение напряжения двухпроводной линии связи
5637	Снято с охраны под принуждением	18	\N	\N	\N	Disarmed under duress	Снято с охраны под принуждением	Снято с охраны под принуждением	Снято с охраны под принуждением
5641	Поставлено на охрану	18	\N	\N	\N	Armed	Поставлено на охрану	Поставлено на охрану	Поставлено на охрану
5642	Снято с охраны	18	\N	\N	\N	Disarmed	Снято с охраны	Снято с охраны	Снято с охраны
5643	Соединение с сегментом установлено	9	\N	\N	\N	Connection with the segment is made	Connexion avec le segment est établie	Il collegamento col segmento è stabilito	Conexión con segmento está establecida
5644	Соединение с сегментом разорвано	9	\N	\N	\N	Connection with the segment is broken	Connexion avec le segment est interrompue	Il collegamento col segmento è interrotto	Conexión con segmento está desconectada
5645	Отказ от прохода, нет ответа от ВВУ	1	1	\N	\N	Passage denial, no response from external verification device	Refus de passage, pas de réponse du dispositif de vérification externe	Rifiuto dal passaggio, non c'è la risposta dal dispositivo esterno di verificazione	Denegación de paso, no hay respuesta desde el dispositivo externo de verificación
8209	Проход с подтверждением от ПДУ/верификации	1	1	\N	\N	Passage with the confirmation from remote control/verification	Passage avec la confirmation du pupitre de commandes / de vérification	Passaggio con la conferma dal comando di controllo remoto / dalla verifica	Paso con confirmación del control remoto/verificación
8226	Попытка взятия ОЗ (невозможно взять) по идентификатору: нарушение состояния ресурса ШС (если стоит "снять при невзятии")	2	6	\N	\N	Attempt to arm the protected zone (can not be armed) by the identifier: violation of the alarm line resource state (in "disarming" mode)	Tentative d'activation du mode de sécurité de la zone sécurisée (impossible d'armer) avec l'identifiant: la violation d'état de ligne d'alarme (dans le mode \\"désarmer\\")	ll tentativo di messa della Zona di protezione (non può essere messa) sull'identificatore: violazione dello stato delle risorse del cicli di allarme (se è inserito "togliere nel caso di non messa")	Intento de armar la zona protegida(no puede ser armada)por identificador: violación de estatus de recurso de Contactos de señalización( si está en ¨desarmar sin armamento¨)
8245	Попытка взятия ОЗ (невозможно взять) по команде оператора: нарушение состояния ресурса ШС (если стоит "снять при невзятии")	2	6	\N	\N	Attempt to arm the protected zone (can not be armed) by the operator command: violation of the alarm line resource state (in "disarming" mode)	Tentative d'activation du mode de sécurité de la zone sécurisée (impossible d'armer) par la commande de l'opérateur: la violation d'état de la ligne de sécurité (dans le mode \\"retrait de la protection\\")	Il tentativo di messa della Zona di protezione (non può essere messa) sul comando dell'operatore: violazione dello stato del ciclo di allarme (se è inserito "togliere nel caso di non messa")	Intento de armar la zona protegida(no puede ser armada)por orden del operador: violación de estatus de recurso del dispositivo: violación de estatus de recurso de contactos de señalización ( si está en ¨desarmar sin armamento¨)
8465	Проход с подтверждением от ПДУ/верификации: с несоответствием текущему местоположению	1	1	\N	\N	Passage with the confirmation from remote control/verification: with the mismatch to the current location	Passage avec confirmation du pupitre de commandes / de vérification: avec le non-conformité de l'emplacement actuel	Passaggio con la conferma dal comando di controllo remoto / dalla verifica: con la non conformità con la posizione attuale	Paso con verificación de control remoto: disconformidad a la localización corriente
8721	Проход с подтверждением от ПДУ/верификации: с несоответствием временным критериям доступа	1	1	\N	\N	Passage with the confirmation from remote control/verification: with the mismatch to the time access criteria	Passage avec la confirmation du pupitre de commandes / de vérification: avec le décalage des critères d'accès de temps	Passaggio con la conferma dal comando di controllo remoto / dalla verifica: con la non conformità con i criteri di tempo di accesso	Paso con confirmación del control remoto/verificación: con discrepancia a los criterios de tiempo temporales
8977	Проход с подтверждением от ПДУ/верификации: с несоответствием временным критериям доступа и текущему местоположению	1	1	\N	\N	Passage with the confirmation from remote control/verification: with the mismatch of the access criteria to the current location	Passage avec la confirmation du pupitre de commandes / de vérification: avec non conformité  des critères d'accès à l'emplacement actuel	Passaggio con la conferma dal comando di controllo remoto / dalla verifica: non conformità con i criteri di tempo di accesso e con la posizione attuale	Paso con confirmación del control remoto/verificación: con discrepancia a los criterios de tiempo temporales y localizacióncorriente
12305	Проход с подтверждением от ВВУ и далее ПДУ/верификации	1	1	\N	\N	Passage with verification from external verification device and further RCP/verification	Passage avec la vérification du dispositif externe de vérification et après du pupitre de commandes/vérification	Passaggio con la conferma dall’impianto esterno di verificazione e la seguente verificazione dal quadro di comando	Paso con confirmación del dispositivo de verificación externa:y luego del panel de control remoto/verificación
12561	Проход с подтверждением от ВВУ и далее ПДУ/верификации: с несоответствием текущему местоположению	1	1	\N	\N	Passage with verification from external verification device and further RCP/verification: with a mismatch to current location	Passage avec la vérification du dispositif externe de vérification et après du pupitre de commandes/vérification: avec le non-conformité de l'emplacement actuel	Passaggio con la conferma dall’impianto esterno di verificazione e la seguente verificazione dal quadro di comando: con la mancanza della conformità con la locazione attuale	Paso con confirmación del dispositivo de verificación externa:y luego del panel de control remoto/verificación: con disconformidad a la localización corriente
12817	Проход с подтверждением от ВВУ и далее ПДУ/верификации: с несоответствием временным критериям доступа	1	1	\N	\N	Passage with verification from external verification device and further RCP/verification: with a mismatch to access time criteria	Passage avec la vérification du dispositif externe de vérification et après du pupitre de commandes/vérification: avec le non-conformité des critères temporaires d'accès	Passaggio con la conferma dall’impianto esterno di verificazione e la seguente verificazione dal quadro di comando: con la mancanza della conformità con i criteri temporali d’accesso	Paso con confirmación del dispositivo de verificación externa:y luego del panel de control remoto/verificación: con disconformidad a los criterios temporales de acceso
501202	Редактирование подразделения	10012	\N	\N	\N	Department editing	Edition du département	Modificare il reparto	Edición de departamento
13073	Проход с подтверждением от ВВУ и далее ПДУ/верификации: с несоответствием временным критериям доступа и текущему местоположению	1	1	\N	\N	Passage with verification from external verification device and further RCP/verification: with a mismatch to  access time criteria and current location	Passage avec la vérification du dispositif externe de vérification et après du pupitre de commandes/vérification: avec le décalage des critères temporaires d'accès et l'mplacement actuel	Passaggio con la conferma dall’impianto esterno di verificazione e la seguente verificazione dal quadro di comando: con la mancanza della conformità con i criteri temporali d’accesso e la locazione attuale	Paso con confirmación del dispositivo de verificación externa:y luego del panel de control remoto/verificación: con disconformidad a los criterios temporales de acceso y la localización corriente
14000	Соединение с контроллером установлено	9	\N	\N	\N	Connection with the controller is made	Connexion avec le contrôleur est établie	Il collegamento col controller è stabilito	Conexión con controlador está establecida
14001	Соединение с контроллером разорвано	9	\N	\N	\N	Connection with the controller is broken	Connexion avec le contrôleur est interrompue	Il collegamento col controller è interrotto	Conexión con controlador está desconectada
14002	Сессия с контроллером открыта	9	\N	\N	\N	Session with the controller is open	Session avec le contrôleur est ouverte	La sessione con il controller è aperta	Sesión con controlador está abierta
14003	Объект контроллер создан	9	\N	\N	\N	Object controller is created	Objet le contrôleur est créé	Oggetto controller è creato	Objeto controlador está creado
14004	Объект контроллер удалён	9	\N	\N	\N	Object controller is deleted	Objet le contrôleur est éliminé	Oggetto controller è eliminato	Objeto controlador está eliminado
14005	Сессия с контроллером не установлена и контроллер деактивирован: неверный пароль	9	\N	\N	\N	Session with controller is not installed and controller is deactivated: invalid password	Session avec le contrôleur n'est pas installée et le contrôleur est désactivé: le mot de passe est invalide	Sessione con il controller non è stabilita e il controller è disattivato: la password è sbagliata	Seccíon con controlador no está instalada y controlador estádesactivada: contraseña incorrecta
14050	Соединение с базой данных установлено	12	\N	\N	\N	Connection with the database is made	Connexion avec la base de données est établie	La connessione alla banca dati è stabilita	Conexión con base de datos está establecida
14051	Соединение с базой данных разорвано	12	\N	\N	\N	Connection with the database is broken	Connexion avec la base de données est interrompue	La connessione alla banca dati è interrotta	Conexión con base de datos está desconectada
14100	Соединение с web-сервером установлено	12	\N	\N	\N	Connection with the web-server is made	Connexion avec le serveur web est établie	Il collegamento col web-server è stabilito	Conexión con servidor web está establecida
14101	Соединение с web-сервером разорвано	12	\N	\N	\N	Connection with the web-server is broken	Connexion avec le serveur web est coupée	Il collegamento col web-server è interrotto	Conexión con sevidor web está desconectada
14280	Сервер оборудования запущен	12	\N	\N	\N	Equipment server is started	Serveur d'équipement est démaré	Server dell'impianto è lanciato	Servidor del equipo está puesta en marcha
14281	Сервер оборудования остановлен	12	\N	\N	\N	Equipment server is stopped	Serveur d'équipement est arrêté	Server dell'impianto è fermato	Servidor del equipo está parado
14282	Заканчивается место на диске	12	15	\N	\N	The disk is almost full	Заканчивается место на диске	Заканчивается место на диске	Заканчивается место на диске
15000	Попытка ввода лицензионного ключа	13	11	\N	\N	Attempt entering a license key	Essai de saisie  de la clé de licence	Il tentativo di inserimento della chiave di licenza	Intento de introducción de una llave licenciada
15001	Попытка обновления лицензий	13	11	\N	\N	Trial to update the licenses	Tentative de mise à jour des licences	Tentativo di renovare le licenze	Intento de actualización de licencias
15002	Установлен новый шаблон	6	\N	\N	\N	New template installed	New template installed	New template installed	New template installed
15003	Изменение конфигурации входа	6	4	\N	\N	Change input configuration	Change input configuration	Change input configuration	Change input configuration
15004	Изменение конфигурации выхода	6	5	\N	\N	Change ouput configuration	Change ouput configuration	Change ouput configuration	Change ouput configuration
16000	Установить РКД «Открыто»: Выполнено	14	1	\N	\N	Set the access control mode "Open": Done	Etablir le mode de contrôle d'accès \\"Ouvert\\": Accompli	Installare la modalità di accesso «Aperto»: Eseguito	Instalar modo de control de acceso ¨Abierto¨ : Hecho
16001	Установить РКД «Контроль»: Выполнено	14	1	\N	\N	Set the access control mode "Control": Done	Etablir le mode de contrôle d'accès \\"Contrôle\\": Accompli	Installare la modalità di accesso «Controllo»: Eseguito	Instalar modo de control de acceso ¨Control¨ : Hecho
16002	Установить РКД «Совещание»: Выполнено	14	1	\N	\N	Set the access control mode "Meeting": Done	Etablir le mode de contrôle d'accès \\"Conférence\\": Accompli	Installare la modalità di accesso «Incontro»: Eseguito	Instalar modo de control de acceso ¨Conferencia¨ : Hecho
16003	Установить РКД «Закрыто»: Выполнено	14	1	\N	\N	Set the access control mode "Closed": Done	Etablir le mode de contrôle d'accès \\"Fermé\\": Accompli	Installare la modalità di accesso «Chiuso»: Eseguito	Instalar modo de control de acceso ¨Cerrado¨ : Hecho
16004	Установить РКД «Открыто»: Не выполнено	14	1	\N	\N	Set the access control mode "Open": Not done	Etablir le mode de contrôle d'accès \\"Ouvert\\": Pas accompli	Installare la modalità di accesso «Aperto»: Non  eseguito	Instalar modo de control de acceso ¨Abierto¨ : No hecho
16005	Установить РКД «Контроль»: Не выполнено	14	1	\N	\N	Set the access control mode "Control": Not done	Etablir le mode de contrôle d'accès \\"Contrôle\\": Pas accompli	Installare la modalità di accesso «Controllo»: Non eseguito	Instalar modo de control de acceso ¨Control¨ : No hecho
16006	Установить РКД «Совещание»: Не выполнено	14	1	\N	\N	Set the access control mode "Meeting": Not done	Etablir le mode de contrôle d'accès \\"Conférence\\": Pas accompli	Installare la modalità di accesso «Incontro»: Non eseguito	Instalar modo de control de acceso ¨Conferencia¨ : No hecho
16007	Установить РКД «Закрыто»: Не выполнено	14	1	\N	\N	Set the access control mode "Closed": Not done	Etablir le mode de contrôle d'accès \\"Fermé\\": Pas accompli	Installare la modalità di accesso «Chiuso»: Non eseguito	Instalar modo de control de acceso ¨Cerrado¨ : No hecho
16010	Открыть (разблокировать) ИУ: Выполнено	14	1	\N	\N	Open (unlock) the device: implemented	Ouvrir (débloquer) le dispositif: Accompli	Aprire (sbloccare) il dispositivo esecutivo: Eseguito	Abrir(desbloquear) el dispositivo: cumplido
16011	Закрыть (заблокировать) ИУ: Выполнено	14	1	\N	\N	Close (block) the device: Implemented	Fermer (débloquer) le dispositif: Accompli	Chiudere (bloccare) il dispositivo esecutivo: Eseguito	Cerrar(bloquear) el dispositivo: cumplido
16012	Открыть (разблокировать) ИУ: Не выполнено	14	1	\N	\N	Open (unlock) the device: Not implemented	Ouvrir (débloquer) le dispositif: N'est pas accompli	Aprire (sbloccare) il dispositivo esecutivo: Non eseguito	Abrir(desbloquear) el dispositivo: no cumplido
16013	Закрыть (заблокировать) ИУ: Не выполнено	14	1	\N	\N	Close (block) the device: implemented	Fermer (bloquer) le dispositif: N'est pas accompli	Chiudere (bloccare) il dispositivo esecutivo: Non eseguito	Abrir(bloquear) el dispositivo: no cumplido
16020	Нормализовать выход: Выполнено	14	5	\N	\N	Normalize output: Implemented	Normaliser la sortie: Accompli	Normalizzare uscita: Eseguito	Normalizar salida: Hecho
16021	Активизировать выход: Выполнено	14	5	\N	\N	Activate output: Done	Activer la sortie: Accompli	Attivare uscita: Eseguito	Activar entrada: Hecho
16022	Нормализовать выход: Не выполнено	14	5	\N	\N	Normalize output: Not done	Normaliser la sortie: Pas accompli	Normalizzare uscita: Non eseguito	Normalizar salida: No hecho
16023	Активизировать выход: Не выполнено	14	5	\N	\N	Activate output: Not done	Activer la sortie: Pas accompli	Attivare l'uscita: Non eseguito	Activar salida: No hecho
16030	Сбросить тревогу: Выполнено	14	2	\N	\N	Reset the alarm: Implemented	Réinitialiser l'alarme: Accompli	Resettare l'allarme: Eseguito	Resetear la alarma: cumplido
16031	Поднять тревогу: Выполнено	14	2	\N	\N	Raise the alarm: Done	Donner l'alarme: Accompli	Scattare l'allarme: Eseguito	Dar la señal de alarma: cumplido
16032	Сбросить тревогу: Не выполнено	14	2	\N	\N	Reset the alarm: Not done	Réinitialiser l'alarme: Pas effectué	Resettare l'allarme: Non eseguito	Resetear alarma: no cumplido
16033	Поднять тревогу: Не выполнено	14	2	\N	\N	Raise the alarm: Not done	Désarmement: Pas effectué	Scattare l'allarme: Non eseguito	Dar la señal de alarma: no cumplido
16040	Снять тревогу с зоны: Выполнено	14	6	\N	\N	To turn off the alarm: Done	Désactiver l'alarme de la zone: Accompli	Revocare l'allarme dalla zona: Eseguito	Desarmar la zona: cumplido
16041	Снять тревогу с зоны: Не выполнено	14	6	\N	\N	To remove the alarm from the zone failed	Désactiver l'alarme de la zone: N'est pas accompli	Togliere l’allarme dalla zona: non eseguito	Desactivar la alarma: No cumplido
16050	Снять зону с охраны: Выполнено	14	6	\N	\N	To disarm the area: Done	Désarmer la zone: Accompli	Revocare la zona dalla protezione: Eseguito	Desarmar la seguridad: cumplido
16051	Поставить зону на охрану: Выполнено	14	6	\N	\N	To arm the zone: Done	Armer la zone: Accompli	Mettere la zona sotto protezione: Eseguito	Armar la zona: cumplido
16052	Снять зону с охраны: Не выполнено	14	6	\N	\N	To arm the zone: Not done	Desarmer la zone: N'est pas accompli	Togliere la protezione della zona: non eseguito	Desarmar la zona: No cumplido
16053	Поставить зону на охрану: Не выполнено	14	6	\N	\N	To arm the zone: Not done	Armer la zone: N'est pas accompli	Mettere la zona alla protezione: non eseguito	Armar la zona: No cumplido
16055	Очистить пространственные зоны для идентификаторов: Выполнено	14	2	\N	\N	Clear the space zone for identifiers:  Done	Effacer les zones d'espace pour les identifiants: Accompli	Liberare le zone di spazio per gli identificatori: Eseguito	Limpiar zonas espaciosas para los identificadores: cumplido
16056	Очистить пространственные зоны для идентификаторов: Не выполнено	14	2	\N	\N	Clear the space zone for identifiers:  Done	Nettoyer les zones d'espace pour les identifiants: N'est pas accompli	Liberare le zone spaziale per identificatori: non eseguito	Limpiar zonas espaciosas para los identificadores: No cumplido
65536	Верификация: проход посетителя	11	1	\N	\N	Verification: visitor's passage	Vérification: le passage du visiteur	Verificazione: il passaggio di visitatore	Verificación: paso de visitante
65537	Верификация: проход посетителя и нарушение времени	11	1	\N	\N	Verification: the passage of the visitor and the violation of time	Vérification: le passage du visiteur et la violation du temps	Verificazione: il passaggio di visitatore e la violazione del tempo	Verificación: paso de visitante y violación de tiempo
65538	Верификация: проход посетителя и нарушение местоположения	11	1	\N	\N	Verification: the passage of the visitor and the violation of location	Vérification: le passage du visiteur et la violation de l'emplacement	Verificazione: il passaggio di visitatore e la violazione della localizzazione	Verificación: paso de visitante y violación de localización
501402	Редактирование сотрудника	10014	\N	\N	\N	Edit the employee	Edition de l'employé	Modificare l'impiegato	Edición de empleado
65539	Верификация: проход посетителя и нарушение местоположения и нарушение времени	11	1	\N	\N	Verification: the passage of the visitor and the violation of location and the violation of time	Vérification: le passage du visiteur et la violation de l'emplacement et la violation du temps	Verificazione: il passaggio di visitatore e l'infrazione della localizzazione e l'infrazione del tempo	Verificación: paso de visitante y violación de localización yviolación de tiempo
65540	Верификация: снятие верификации в связи с несанкционированным проходом	11	1	\N	\N	Verification: removal of verification due to the unauthorized passage	Vérification: le retrait de vérification à cause du passage non-autorisé	Verificazione: rimozione di verificazione a causa del passaggio non autorizzato	Verificación: remoción de verificación debido al paso no autorizado
65544	Верификация: проход сотрудника	11	1	\N	\N	Verification: the passage of the employee	Vérification: le passage de l'employé	Verificazione: il passaggio di impiegato	Verificación: paso de empleado
65545	Верификация: проход сотрудника и нарушение времени	11	1	\N	\N	Verification: the passage of the employee and the violation of time	Vérification: le passage de l'employé et la violation du temps	Verificazione: il passaggio di impiegato e la violazione del tempo	Verificación: paso de empleado y violación de tiempo
65546	Верификация: проход сотрудника и нарушение местоположения	11	1	\N	\N	Verification: the passage of the employee and the violation of location	Vérification: le passage de l'employé et la violation de l'emplacement	Verificazione: il passaggio di impiegato e la violazione della localizzazione	Verificación: paso de empleado y violación de localización
65547	Верификация: проход сотрудника и нарушение местоположения и нарушение времени	11	1	\N	\N	Verification: the passage of the employee and the violation of location and the violation of time	Vérification: le passage de l'employé et la violation de l'emplacement et la violation du temps	Verificazione: il passaggio di impiegato e la violazione della localizzazione e la violazione  del tempo	Verificación: paso de empleado y violación de localización yviolación de tiempo
65552	Верификация: постановка на «Охрану»	11	1	\N	\N	Verification: arming	Vérification: Armement	Verificazione: impostazione "protezione"	Verificación: armamento
65560	Верификация: снятие с «Охраны»	11	1	\N	\N	Verification: disarming	Vérification: désarmement	Verifica: rimozione dalla "protezione"	Verificación: desarmamento
70000	Регистрация верифицирующего устройства	12	\N	\N	\N	Registration of verification device	L'enregistrement du dispositif de vérification	Registrazione del dispositivo verificante	Registración de dispositivo de verificación
131072	Индикация: проход сотрудника	11	1	\N	\N	Indication: passage of employee	Indication: le passage de l'employé	Indicazione: passaggio di impiegato	Indicación: paso de empleado
131073	Индикация: проход посетителя	11	1	\N	\N	Indication: passage of visitor	Indication: le passage du visiteur	Indicazione: passaggio di visitatore	Indicación: paso de visitante
131074	Индикация: проход сотрудника и нарушение времени	11	1	\N	\N	Indication: employee's passage and time violation	Indication: le passage d'employé et la violation de temps	Indicazione: passaggio di impiegato e violazione del tempo	Indicación: paso de empleado y violación de tiempo
131075	Индикация: проход посетителя и нарушение времени	11	1	\N	\N	Indication: visitor's passage and time violation	Indication: le passage de visiteur et la violation de temps	Indicazione: passaggio di visitatore e violazione del tempo	Indicación: paso de visitante y violación de tiempo
131076	Индикация: проход сотрудника и нарушение местоположения	11	1	\N	\N	Indication: employee's passage and location violation	Indication: le passage d'employé et la violation d'emplacement	Indicazione: passaggio di impiegato e violazione della localizzazione	Indicación: paso de empleado y violación de localización
131077	Индикация: проход посетителя и нарушение местоположения	11	1	\N	\N	Indication: visitor's passage and location violation	Indication: le passage de visiteur et la violation d'emplacement	Indicazione: passaggio di visitatore e violazione della localizzazione	Indicación: paso de visitante y violación de localización
131078	Индикация: проход сотрудника и нарушение времени и нарушение местоположения	11	1	\N	\N	Indication: employee's passage, time and location violation	Indication: le passage d'employé et la violation de temps, la violation d'emplacement	Indicazione: passaggio di impiegato e violazione del tempo e violazione della localizzazione	Indicación: paso de empleado y violación de tiempo y violación de localización
131079	Индикация: проход посетителя и нарушение времени и нарушение местоположения	11	1	\N	\N	Indication: visitor's passage, time and location violation	Indication: le passage de visiteur et la violation de temps, la violation d'emplacement	Indicazione: passaggio di visitatore e violazione del tempo e violazione della localizzazione	Indicación: paso de visitante y violación de tiempo y violación de localización
131080	Индикация: проход сотрудника и нарушение режима доступа	11	1	\N	\N	Indication: employee's passage and access mode violation	Indication: le passage de l'employé et la violation de mode d'accès	Indicazione: passaggio dell'impiegato e violazione della modalità di accesso	Indicacion: paso de empleado y violación de modo de acceso
131081	Индикация: проход посетителя и нарушение режима доступа	11	1	\N	\N	Indication: visitor's passage and access mode violation	Indication: le passage de visiteur et la violation de mode d'accès	Indicazione: passaggio di visitatore e violazione del regimo accesso	Indicación: paso de visitante  y violacion de régimen de acceso
131136	Индикация: проход сотрудника и постановка на «Охрану»	11	1	\N	\N	Indication: employee's passage and arming	Indication: le passage d'employé et Armement	Indicazione: passaggio di impiegato e messa sulla \\"Protezione\\"	Indicación: paso de empleado y armamento
131137	Индикация: проход посетителя и постановка на «Охрану»	11	1	\N	\N	Indication: visitor's passage and arming	Indication: le passage de visiteur et Armement	Indicazione: passaggio di visitatore e messa sulla \\"Protezione\\"	Indicación: paso de visitante y armamento
131200	Индикация: проход сотрудника и снятие с «Охраны»	11	1	\N	\N	Indication: employee's passage and disaming	Indication: le passage d'employé et Désarmement	Indicazione: passaggio di impiegato e sottrazione dalla \\"Protezione\\"	Indicación: paso de empleado y desarmamento
131201	Индикация: проход посетителя и снятие с «Охраны»	11	1	\N	\N	Indication: visitor's passage and disarming	Indication: le passage de visiteur et Désarmement	Indicazione: passaggio di visitatore e sottrazione dalla \\"Protezione\\"	Indicación: paso de visitante y desarmamento
131328	Индикация: карта не зарегистрирована	11	1	\N	\N	Indication: card not registered	Indication: la carte n'est pas enregistrée	Indicazione: la tessera non è registrata	Indicación: tarjeta no está registrada
131584	Индикация: карта заблокирована	11	1	\N	\N	Indication: card is blocked	Indication: la carte est bloquée	Indicazione: la tessera è bloccata	Indicación: tarjeta está bloqueada
132096	Индикация: карта в стоп-листе	11	1	\N	\N	Indication: card is in a stop-list	Indication: la carte est dans la liste des interdits	Indicazione: la card nella lista stop	Indicación: la tarjeta está en stop-list
133120	Индикация: истек срок действия карты	11	1	\N	\N	Indication: expired card	Indication: la carte est expirée	Indicazione: la tessera è scaduta	Indicación: el período de validez de la tarjeta está expirada
135168	Индикация: взлом ИУ	11	1	\N	\N	Indication: OD break in	Indication: l'effraction du dispositif	Indicazione: hacking del dispositivo esecutivo	Indicación: hackeo de dispositivo
139264	Индикация: разрешение прохода от ДУ	11	1	\N	\N	Indication: permission of passage from remote control	Indication: l'autorisation de passage du pupitre de commandes	Indicazione: permesso del passaggio dal comando a distanza	Indicación: permiso de paso del control remoto
196609	Объект шаблон верификации загружен	12	9	VERIFY_TEMPLATE	ID	Verification template object is created	Objet du modèle de vérification est déjà créé	Oggetto template di verificazione è caricato	Objeto modelo de verificación está cargado
196610	Объект шаблон верификации выгружен	12	9	VERIFY_TEMPLATE	ID	Verification template has been uploaded	Modèle de vérification était téléchargé	Il template di verifica è stato caricato	El modelo de verificación ha sido descargado
196619	Верификация: разрешено оператором	11	1	\N	\N	Verification: authorised by the operator	Vérification: autorisé par l'opérateur	Verificazione: è consentito dall'operatore	Verificación: está permitido por operador
196620	Верификация: проход разрешён автоматически	11	1	\N	\N	Verification: the passage is allowed automatically	Vérification: le passage est autorisé automatiquement	Verificazione: il passaggio è consentito automaticamente	Verificación: paso está permitido de modo automático
196621	Верификация: запрещено оператором	11	1	\N	\N	Verification: banned by operator	Vérification: interdit par l'opérateur	Verificazione: è vietato dall'operatore	Verificación: está prohibido por operador
196622	Выполнение задания	10061	15	\N	\N	Task execution	Exécution de tâche	Esecuzione del processo	Cumplimiento de tarea
196623	Выполнение рассылки	10061	15	\N	\N	Sending status	Statut d'envoi	Stato di invio	Estado de envío
196624	Верификация: проход запрещён автоматически	11	1	\N	\N	Verification: banned automatically	Vérification: interdit automatiquement	Verificazione: è vietato automaticamente	Verificación: está prohibido de modo automático
196625	Выполнение команды по событию	10061	15	\N	\N	Executing command by event	Exécuter une commande par événement	Esecuzione di un comando per evento	Ejecutando un comando por evento
200000	Регистрация Индицирующего устройства	12	\N	\N	\N	Registration of indicating device	Enregistrement du dispositif indicatif	Registrazione del dispositivo indicante	Registración de dispositivo indicado
300000	Пользовательский запуск пересчета рабочего времени	12000	\N	\N	\N	User working time recalculation start	Démarrage par utilisateur pour le  recalcul du temps travaillé	Avvio personalizzato di ricalcolo del tempo di lavoro	Puesta en marcha de recalculación de horario de trabajo por elusuario
300001	Окончание пересчета рабочего времени	12000	\N	\N	\N	Working time recalculation end	Fin de recalcul du temps travaillé	Fine di ricalcolo di tempo di lavoro	Terminación de recalculación de horario de trabajo
300050	Запись идентификатора в карту	16	\N	\N	\N	Identifier's registration to the card	Enregistrement de l'identifiant à la carte	Registrazione dell'identificatore sulla card	Registro de identificador a la tarjeta
500000	Вход оператора в систему	10000	\N	\N	\N	Entrance of the operator into the system	Entrée de l'opérateur dans le système	L'ingresso dell'operatore nel sistema	Entrada del operador en el sistema
500001	Выход оператора из системы	10000	\N	\N	\N	The exit of the operator from the system	Sortie de l'opérateur du système	L'uscita dell'operatore dal sistema	Salida del operador del sistema
501101	Добавление графика работы	10011	\N	\N	\N	Work schedule adding	Ajouter l'horaire de travail	Aggiungere orario di lavoro	Adición de horario de trabajo
501102	Редактирование графика работы	10011	\N	\N	\N	Schedule editing	Edition de l'horaire de travail	Modificare l'orario di lavoro	Edición de horario de trabajo
501103	Удаление графика работы	10011	\N	\N	\N	Working schedule removal	Supprimer l'horaire de travail	Eliminazione dell'orario di lavoro	Eliminación de horario de trabajo
501112	Редактирование календаря	10011	\N	\N	\N	Calendar editing	Editer le calendrier	Modificare il calendario	Edición de calendario
501404	Блокировка сотрудника	10014	\N	\N	\N	Employee blocking	Blocage de l'employé	Blocco di un impiegato	Bloqueo de empleado
501405	Снятие блокировки сотрудника	10014	\N	\N	\N	Employee unblocking	Déblocage d'employé	Sottrazione di bloccaggio dell'impiegato	Desbloqueo de empleado
501501	Добавление посетителя	10015	\N	\N	\N	Visitor adding	Ajout le visiteur	Aggiunta di un visitatore	Adición de visitante
501502	Редактирование посетителя	10015	\N	\N	\N	Edit the visitor	Edition du visiteur	Modificare il visitatore	Edición de visitante
501503	Удаление посетителя	10015	\N	\N	\N	Visitor removal	Suppression du visiteur	Eliminazione del visitatore	Remoción de visitante
501504	Блокировка посетителя	10015	\N	\N	\N	Visitor blocking	Blocage du visiteur	Blocco del visitatore	Bloqueo de visitante
501505	Снятие блокировки посетителя	10015	\N	\N	\N	Visitior unblocking	Déblocage de visiteur	Sottrazione di bloccaggio del visitatore	Desbloqueo de visitante
501601	Добавление шаблона доступа	10016	\N	\N	\N	Access template adding	Ajouter le modèle d'accès	Aggiungere il template di accesso	Adición de modelo de acceso
501602	Редактирование шаблона доступа	10016	\N	\N	\N	Access template editing	Edition du modèle d'accès	Modificare  il template di accesso	Edición de modelo de acceso
501603	Удаление шаблона доступа	10016	\N	\N	\N	Access template removal	Supprimer le modèle d'accès	Eliminazione del template di accesso	Eliminación de modelo de acceso
501612	Редактирование временной зоны	10017	\N	\N	\N	Time zone editing	Editer la zone temporaire	Modificare la zona temporale	Edición de zona tremporal
501622	Редактирование недельного режима доступа	10017	\N	\N	\N	Weekly access mode editing	Editer le mode d'accès de la semaine	Modificare la modalità d'accesso settimanale	Edición de modo de acceso semanal
501632	Редактирование сменного суточного режима доступа	10017	\N	\N	\N	Shift-day schedule editing	Edition de l'horaire du quart de jour	Modificare la modalità d'accesso flessibile di turno giornaliero.	Edición de modo de acceso de turno
501642	Редактирование скользящего недельного режима доступа	10017	\N	\N	\N	Editing of the flexible weekly access mode	Edition du mode d'accès de la semaine flexible	Modificare la modalità d'accesso flessibile settimanale	Edición de modo de acceso flexible semanal
501652	Редактирование календаря праздников для недельных графиков	10017	\N	\N	\N	Editing holiday calendar for weekly schedule	Editer le calendrier des fêtes pour les horaires de la semaine	Modificare il calendario delle festività per i piani settimanali	Edición de calendario de ferias para horarios semanales
502502	Редактирование события прохода	10025	\N	\N	\N	Editing of the event of the passage	Edition de l'événement du passage	Modificare l'evento di passaggio	Edición de evento del paso
503201	Добавление роли	10032	\N	\N	\N	Role adding	Ajouter le rôle	Aggiungere ruolo	Adición de rol
503202	Редактирование роли	10032	\N	\N	\N	Role editing	Edition du rôle	Modificare il ruolo	Redacción de rol
503203	Удаление роли	10032	\N	\N	\N	Role removal	Suppression du rôle	Eliminazione del ruolo	Eliminación de rol
503204	Изменение полномочий роли	10032	\N	\N	\N	Role authorities changing	Changement des autorités du rôle	Modifica delle autorizzazioni di ruolo	Cambio de facultades del rol
503601	Добавление документа	10036	\N	\N	\N	Add a document	Ajout d'un document	Aggiunta di un documento	Agregación de documento
503602	Редактирование документа	10036	\N	\N	\N	Document editing	Edition du document	Modificare il documento	Edición de documento
503603	Удаление документа	10036	\N	\N	\N	Document removal	Eliminer le document	Eliminazione del documento	Eliminación de documento
503701	Добавление поля	10037	\N	\N	\N	Field adding	Ajouter le champ	Aggiungere il campo	Adición de campo
503702	Редактирование поля	10037	\N	\N	\N	Field editing	Edition du champ	Modificare il campo	Edición de campo
503703	Удаление поля	10037	\N	\N	\N	Field removal	Supprimer le champ	Eliminazione del campo	Eliminación de campo
503801	Добавление оператора	10038	\N	\N	\N	Operator adding	Ajouter l'opérateur	Aggiungere operatore	Adición al operador
503802	Редактирование оператора	10038	\N	\N	\N	Operator editing	Editer l'opérateur	Modificare l'operatore	Redacción de operador
503803	Удаление оператора	10038	\N	\N	\N	Operator removal	Supprimer l'opérateur	Eliminazione dell'operatore	Eliminación de operador
503804	Блокировка оператора	10038	\N	\N	\N	Operator blocking	Bloquer l'opérateur	Blocco dell'operatore	Bloqueo de operador
503805	Снятие блокировки оператора	10038	\N	\N	\N	Operator unblocking	Débloquer l'opérateur	Sblocco dell'operatore	Desbloqueo de operador
503806	Смена полномочий оператора	10038	\N	\N	\N	Change of operator's rights	Changer les autorités de l'opérateur	Cambiamento di autorizzazione dell'operatore	Cambio de facultades del operador
503807	Сообщение оператору	10038	15	\N	\N	Message to operator	Message to operator	Message to operator	Message to operator
505001	Добавление дизайна пропуска	10050	\N	\N	\N	Pass design adding	Ajouter le design de la carte	Aggiungere il design della tessera	Adición de diseño del pase
505002	Редактирование дизайна пропуска	10050	\N	\N	\N	Card design editing	Edition du design de  la carte	Modificare il design della tessera	Edición de diseño del pase
505003	Удаление дизайна пропуска	10050	\N	\N	\N	Card design removal	Supprimer le design de la carte	Eliminazione del design della tessera	Eliminación de diseño del pase
505401	Добавление должности	10054	\N	\N	\N	Position adding	Ajouter le poste	Aggiungere l'incarico	Adición de cargo
505402	Редактирование должности	10054	\N	\N	\N	Position editing	Edition du poste	Modificare incarichi	Edición de cargo
505403	Удаление должности	10054	\N	\N	\N	Position removal	Supprimer le poste	Eliminazione dell'incarico	Eliminación de cargo
505901	Добавление помещения	10059	\N	\N	\N	Room adding	Ajouter la salle	Aggiungere l'area	Adición de local
505902	Редактирование помещения	10059	\N	\N	\N	Room editing	Edition de la salle	Modificare l'ambiente	Edición de local
505903	Удаление помещения	10059	\N	\N	\N	Room removal	Suppression de la salle	Eliminazione di ambiente	Eliminación de local
505911	Добавление устройства	11059	\N	\N	\N	Add a device	Ajouter le dispositif	Aggiunta di un dispositivo	Agregación de dispositivo
505912	Редактирование устройства	11059	\N	\N	\N	Device editing	Editer le dispositif	Redazione del dispositivo	Edición de dispositivo
505913	Удаление устройства	11059	\N	\N	\N	Delet a device	Supprimer le dispositif	Eliminazione del dispositivo	Eliminación de dispositivo
505914	Деактивация устройства	11059	\N	\N	\N	Device deactivation	Désactivation du dispositif	Disattivazione del dispositivo	Deactivación de dispositivo
505915	Активация устройства	11059	\N	\N	\N	Device activation	Activation du dispositif	Attivazione del dispositivo	Activación de dispositivo
505916	Удаление устройства из помещения	11059	\N	\N	\N	Delete a device from the room	Suppression du dispositif de la salle	Sottrazione del dispositivo dall'ambiente	Eliminación de dispositivo desde el local
505917	Установка устройства в помещение	11059	\N	\N	\N	Device installation in a room	Installation du dispositif dans la salle	Installazione del dispositivo nel ambiente	Instalación de dispositivo al local
505918	Редактирование общих параметров устройств	11059	\N	\N	\N	Editing of commo device settings	Edition des paramètres généraux des dispositifs	Redazione dei parametri communi dei dispositivi	Edición de parámetros básicos de los dispositivos
506101	Добавление задания	10061	\N	\N	\N	Task adding	Ajouter la tâche	Aggiungere il compito	Adición de tarea
506102	Редактирование задания	10061	\N	\N	\N	Task editing	Edition de la tâche	Modifica del compito	Edición de tarea
506103	Удаление задания	10061	\N	\N	\N	Task removal	Supprimer la tâche	Eliminazione del compito	Eliminación de tarea
506401	Добавление шаблона верификации	10064	\N	\N	\N	Verification template adding	Ajouter le modèle de vérification	Aggiungere il template di verificazione	Adición de modelo de verificación
506402	Редактирование шаблона верификации	10064	\N	\N	\N	Verification template editing	Edition du modèle de vérification	Modificare il template di verificazione	Edición de modelo de verificación
506403	Удаление шаблона верификации	10064	\N	\N	\N	Template verification removal	Suppression du modèle de vérification	Eliminazione del template della verificazione	Eliminación de modelo de verificación
506404	Добавление видеосервера	10064	\N	\N	\N	Video server adding	Ajouter le serveur vidéo	Aggiungere il server video	Adición de video servidor
506405	Редактирование видеосервера	10064	\N	\N	\N	Video server editing	Edition du serveur vidéo	Modificare il server video	Edición de video servidor
506406	Удаление видеосервера	10064	\N	\N	\N	Video server removal	Suppression du serveur vidéo	Eliminazione di server video	Eliminación de video servidor
506407	Добавление шаблона камеры	10064	\N	\N	\N	Camera template adding	Ajouter le modèle de caméra	Aggiungere il template della videocamera	Adición de modelo de cámara
506408	Редактирование шаблона камеры	10064	\N	\N	\N	Camera template editing	Edition du modèle de caméra	Modificare il template della videocamera	Edición de modelo de cámara
506409	Удаление шаблона камеры	10064	\N	\N	\N	Camera template removal	Suppression du modèle de caméra	Eliminazione del template della camera	Eliminación de modelo de cámara
506901	Включение лицензии	10069	\N	\N	\N	Activation of the license	Activation de la licence	Attivazione della licenza	Activación de la licencia
506902	Смена лицензионного контроллера	10069	\N	\N	\N	Change the license controller	Changement du contrôleur licencié	Cambio del controller di licenza	Cambio del controlador licenciado
506903	Отключение лицензии	10069	\N	\N	\N	Deactivation of the license	Désactvation de la licence	Disattivazione della licenza	Desactivación de la licencia
506904	Оператор записал идентификатор	10037	\N	\N	\N	Operator recorded the identificator	Opérateur a enregistré l'identifiant	L'operatore ha registrato l'identificatore	El operador registró el identificador
506911	Добавление интерактивного плана	10070	\N	\N	\N	Adding an interactive plan	Ajout d'un plan interactif	Aggiunta di un piano interattivo	Agregar un plan interactivo
506912	Редактирование интерактивного плана	10070	\N	\N	\N	Editing an interactive plan	Modification d'un plan interactif	Modifica di un piano interattivo	Editar un plan interactivo
506913	Удаление интерактивного плана	10070	\N	\N	\N	Deleting an interactive plan	Suppression d'un plan interactif	Eliminazione di un piano interattivo	Eliminar un plan interactivo
\.


--
-- Data for Name: event_verify_result; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.event_verify_result (id, name) FROM stdin;
1	##Нет подтверждения##
2	##Проход разрешён оператором##
3	##Проход разрешён автоматически##
4	##Проход запрещён оператором##
5	##Проход запрещён автоматически##
\.


--
-- Data for Name: language; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.language (id, name, code, is_active) FROM stdin;
1	Русский	ru	1
2	English	en	1
3	Italiano	it	0
4	Español	es	0
5	Français	fr	0
\.


--
-- Data for Name: license; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.license (id, module_number, name, license_key, demo_begin_date, demo_day_count, last_verify, connection_count, short_name, bad_verify_day_count, data, license_state_id, is_active, description, string_constant) FROM stdin;
7	18	##Верификация##	\N	\N	60	2022-03-21 16:19:08.296301+03	1	PERCo-WM02	30	\N	0	0	##Модуль «Верификация» предназначен для усиления контроля доступа на территорию предприятия и предотвращения случаев прохода по чужому пропуску. Модуль устанавливается на рабочее место сотрудника службы охраны и позволяет производить идентификацию владельца карты доступа, сравнивая личность проходящего сотрудника или изображение с видеокамеры и его фото, хранящееся в базе данных системы.##	Verification
8	19	##Интеграция с 1С##	\N	\N	60	2022-03-21 16:19:08.296301+03	1	PERCo-WM03	30	\N	0	0	##Модуль интеграции с 1С [url href="/1s/1s-module.zip"]Скачать модуль интеграции[/url]##	1s
9	20	##Интеграция с внешними системами##	\N	\N	60	2022-03-21 16:19:08.296301+03	1	PERCo-WM04	30	\N	0	0	##Модуль интеграции с внешними системами [url href="/dev"]Документация[/url]##	sdk
10	24	##Мониторинг##	\N	\N	60	2022-03-21 16:19:08.296301+03	1	PERCo-WM05	30	\N	0	0	##«Мониторинг» позволяет создавать интерактивные планы помещений, размещать на них устройства, осуществлять управление ими и отслеживать события системы в реальном времени.##	monitoring
11	25	##Интеграция с TRASSIR##	\N	\N	60	2022-03-21 16:19:08.296301+03	\N	PERCo-WM06	30	\N	0	0	##Модуль интеграции с системой видеонаблюдения TRASSIR с поддержкой видеонаблюдения, видеозаписи, реакций на события и распознавания по лицам##	trassir
12	26	##Интеграция с ИСО "ОРИОН" (НВП "Болид")##	\N	\N	60	2022-03-21 16:19:08.296301+03	1	PERCo-WM07	30	\N	0	0	##Модуль интеграции с ИСО "ОРИОН". Позволяет осуществлять мониторинг и управление охранно-пожарной сигнализацией производства НВП "Болид" с поддержкой отображения приборов и датчиков на плане и реакций на события##	bolid
5	16	##Стандартный пакет##	\N	\N	60	2022-03-21 16:19:08.296301+03	1	PERCo-WS	30	953f153fe6ab4dc54e21fc7ed40ff3bc	0	0	##«Стандартный пакет ПО» предназначен для организации полноценной СКУД с поддержкой всех основных функций обеспечения безопасности, в том числе: контроль доступа по времени, контроль зональности (antipass), доступ с комиссионированием. Раздел «Администрирование» позволяет произвести первичное конфигурирование оборудования системы, добавление операторов системы и ее лицензирование, контролировать работу системы, составляя отчеты о событиях системы. Раздел «Персонал» позволяет автоматизировать процесс ввода и хранения учетных данных сотрудников и создания графиков работы. В разделе предусмотрена возможность ведения списка должностей и подразделений предприятия. Раздел «Бюро пропусков» позволяет автоматизировать процесс выдачи пропусков сотрудникам и посетителям предприятия. Раздел «Контроль доступа» позволяет автоматизировать формирование отчетов о проходах через турникеты, входах/выходах в помещения. При необходимости оперативного реагирования предусмотрена возможность удаленного управления устройствами системы. Раздел «Заказ пропуска» позволяет автоматизировать процесс предварительного заказа пропусков посетителям. Вкладка Заказ пропуска предназначена для заказа пропусков посетителям для последующей выдачи в разделе «Бюро пропусков». Вкладка Архив предназначена для повторного заказа пропусков посетителям, данные которых были сохранены в архиве ранее.##	Standart
4	15	##Базовый пакет##	\N	\N	60	2022-03-21 16:19:08.296301+03	1	PERCo-WB	30	\N	0	1	##«Базовый пакет ПО» предназначен для организации системы контроля доступа на предприятии, имеющем в штате не более 100 сотрудников. Базовое ПО поддерживает все основные функции обеспечения безопасности, в том числе: контроль доступа по времени, контроль зональности (antipass), доступ с комиссионированием. Раздел «Администрирование» позволяет произвести первичное конфигурирование оборудования системы, добавление операторов системы и ее лицензирование, контролировать работу системы, составляя отчеты о событиях системы. Раздел «Персонал» позволяет автоматизировать процесс ввода и хранения учетных данных сотрудников и создания графиков работы. В разделе предусмотрена возможность ведения списка должностей и подразделений предприятия. Раздел «Бюро пропусков» позволяет автоматизировать процесс выдачи пропусков сотрудникам предприятия. Раздел «Контроль доступа» позволяет автоматизировать формирование отчетов о правах доступа сотрудников. При необходимости оперативного реагирования предусмотрена возможность удаленного управления устройствами системы.##	Base
6	17	##Учёт рабочего времени##	\N	\N	60	2022-03-21 16:19:08.296301+03	1	PERCo-WM01	30	4b78f958ec650af86a498a6ed1bcf3d9	0	0	##Раздел «Учет рабочего времени» позволяет автоматизировать построение отчетов об отработанном времени и дисциплине труда, формирование табеля учета рабочего времени в формате Т-13. В разделе предусмотрена возможность добавления новых типов оправдательных документов и документов на сверхурочную работу. Для работы раздела необходимо, чтобы каждому сотруднику в подразделе «Сотрудники» раздела «Персонал» был установлен график работы, определяющий его расписание работы, норму рабочего времени, параметры контроля дисциплины труда и место работы (регистрирующие помещения). В процессе работы сотрудник предъявляет карту доступа при входе и выходе из регистрирующих помещений. На основании данных о проходах и установленного графика работы автоматически подсчитывается рабочее время сотрудника. Вследствие некорректного предъявления сотрудником карты доступа возможен некорректный подсчет рабочего времени. Контроль и корректировка подобных случаев осуществляется в подразделе «Журнал отработанного времени». Для контроля трудовой дисциплины сотрудников используется подраздел «Отчеты по дисциплине». К нарушениям трудовой дисциплины относятся неявка, опоздание, выход в течение рабочего дня, уход раньше. Документы на сверхурочную работу оформляются в подразделе «Журнал отработанного времени» или «Сотрудники» раздела «Персонал». При необходимости, новые типы документов создаются в подразделе «Оправдательные документы».##	TimeTracking
\.


--
-- Data for Name: license_state; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.license_state (id, name) FROM stdin;
0	##Не проверена##
1	##Ключ не проверен##
2	##Повреждена##
3	##Проверена##
4	##Не действительна##
5	##Новый ключ установлен##
6	##Новый ключ некорректен##
7	##Отсутствует лицензионный контроллер##
8	##Приостановлена##
9	##Не включена##
10	##Лицензионный контроллер не включен##
11	##Ошибка лицензионного контроллера##
\.


--
-- Data for Name: mobile_terminal_device; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mobile_terminal_device (id, uid, name, model, is_active, device_id, sync_date, sync_token) FROM stdin;
\.


--
-- Data for Name: pass_template_design; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.pass_template_design (id, name, data, user_type) FROM stdin;
\.


--
-- Data for Name: plan; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.plan (id, name, building, floor, property, event_filter) FROM stdin;
\.


--
-- Data for Name: position; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."position" (id, is_const, name, comment, is_removed) FROM stdin;
\.


--
-- Data for Name: property_table; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.property_table (id, default_language, first_enter, license_device_mac_address, date_format, languages, version_db, region_id, is_migrate, multi_server) FROM stdin;
1	ru	1	\N	dd.MM.yyyy	ru	140	1	0	0
\.


--
-- Data for Name: region; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.region (id, name, settings) FROM stdin;
1	##Россия##	\N
2	##Европа##	{"excludedCategories": [18]}
3	##США##/##Канада##	{"excludedCategories": [18]}
\.


--
-- Data for Name: schedule; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.schedule (id, is_const, name, comment, schedule_type_id, date) FROM stdin;
1	1	##Никогда##	\N	1	\N
2	1	##Всегда##	\N	1	\N
3	0	##Праздничное расписание##	\N	5	\N
4	0	##Тип## 1	\N	6	\N
5	0	##Тип## 2	\N	6	\N
6	0	##Тип## 3	\N	6	\N
7	0	##Тип## 4	\N	6	\N
8	0	##Тип## 5	\N	6	\N
9	0	##Тип## 6	\N	6	\N
10	0	##Тип## 7	\N	6	\N
11	0	##Тип## 8	\N	6	\N
\.


--
-- Data for Name: schedule_item; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.schedule_item (id, type, number, schedule_id, parent_id, data) FROM stdin;
1	1	1	\N	1	{"end": "00:00:00", "begin": "00:00:00"}
2	1	1	\N	2	{"end": "23:59:00", "begin": "00:00:00"}
\.


--
-- Data for Name: schedule_item_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.schedule_item_type (id, item, description) FROM stdin;
1	HOUR	Часовой интервал
2	DAY	День недели
3	HOLIDAY	Дата праздника
4	WEEK	Недельное расписание
5	YEAR	Идентификатор годового расписания (зарезервировано для дальнейшего расширения)
6	HOLIDAY_TYPE	Праздничная группа
\.


--
-- Data for Name: schedule_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.schedule_type (id, name, schema_title) FROM stdin;
0	##Все##	all
1	##Временные зоны##	time_zone_schedule
2	##Недельный график##	weekly_schedule
3	##Скользящий посуточный график##	shift_day_schedule
4	##Скользящий понедельный график##	shift_weekly_schedule
5	##Праздничное расписание##	holiday_schedule
6	##Виртуальное праздничное расписание##	virtual_holiday_schedule
\.


--
-- Data for Name: screenshot; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.screenshot (id, name, image) FROM stdin;
\.


--
-- Data for Name: segment; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.segment (id, name, is_lock, is_main, host, port, protocol, token) FROM stdin;
\.


--
-- Data for Name: settings; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.settings (id, title, json) FROM stdin;
3	video	{"videoPreRecordTime":"8","videoRecordTime":"10","videoFrameRate":"2","videoStorageDir":""}
\.


--
-- Data for Name: task; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.task (id, name, date, days, time_start, time_end, task_state_id, date_exec, segments) FROM stdin;
1	##Резервное копирование базы данных##	\N	127	00:00:00	01:00:00	\N	\N	\N
\.


--
-- Data for Name: task_action; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.task_action (id, task_id, type_id, object_id, options) FROM stdin;
1	1	1	\N	\N
\.


--
-- Data for Name: task_state; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.task_state (id, name) FROM stdin;
2	##Выполнено с ошибками##
1	##Выполнено##
3	##Выполняется##
\.


--
-- Data for Name: task_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.task_type (id, name) FROM stdin;
2	##Команда в устройство##
3	##Отправить отчет по email##
1	##Резервное копирование базы данных##
\.


--
-- Data for Name: user; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."user" (id, last_name, first_name, middle_name, user_type_id, is_operator, division_id, position_id, access_template_id, is_active, is_block, is_removed, create_date, begin_date, end_date) FROM stdin;
1	##Администратор##		\N	1	1	\N	\N	\N	0	0	0	2018-10-12 14:07:48+03	2018-10-12 14:00:34+03	\N
2	Сервер	Системы	\N	0	1	\N	\N	\N	0	0	0	2018-11-26 13:48:21+03	2018-11-26 13:48:21+03	\N
3	Менеджер	Перко-веб	\N	0	1	\N	\N	\N	0	0	0	2018-11-26 14:54:07+03	2018-11-26 14:54:07+03	\N
4	Мобильный	Терминал	\N	0	1	\N	\N	\N	0	0	0	2018-12-10 16:39:23+03	2018-12-10 16:39:23+03	\N
5	Event	Action	\N	0	1	\N	\N	\N	0	0	0	2019-01-22 14:54:47+03	2019-01-22 14:54:47+03	\N
6	1	С	\N	1	1	\N	\N	\N	1	1	0	2019-02-11 13:54:18+03	2019-02-11 13:54:18+03	\N
\.


--
-- Data for Name: user_additional_field; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_additional_field (id, type_id, name, comment, user_type, is_const) FROM stdin;
-6	5	Email	##Служебное поле##	2	1
-5	5	Email	##Служебное поле##	1	1
-4	4	##Телефон##	##Служебное поле##	1	1
-3	3	Viber	##Служебное поле##	1	1
-2	6	##Пин-код##	##Служебное поле##	1	1
-1	6	##Пин-код##	##Служебное поле##	2	1
1	2	##Фотография##	##Служебное поле##	1	1
2	2	##Фотография##	##Служебное поле##	2	1
\.


--
-- Data for Name: user_additional_field_data; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_additional_field_data (user_id, field_id, data) FROM stdin;
\.


--
-- Data for Name: user_additional_field_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_additional_field_type (id, name) FROM stdin;
2	##Графический##
6	##Пин-код##
1	##Текстовый##
4	##Телефон##
5	Email
3	Viber
\.


--
-- Data for Name: user_barcode; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_barcode (identifier_id, barcode_type_id) FROM stdin;
\.


--
-- Data for Name: user_bio; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_bio (id, user_id, bio_type, template_type, template, template2, image, number, name, operator_id, create_date) FROM stdin;
\.


--
-- Data for Name: user_car; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_car (id, user_id, number, model, photo, operator_id, create_date) FROM stdin;
\.


--
-- Data for Name: user_card; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_card (id, user_id, identifier, operator_id, create_date) FROM stdin;
\.


--
-- Data for Name: user_change; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_change (id, user_id, change_type_id, begin_date, end_date, old_value, value, is_execute, "timestamp") FROM stdin;
\.


--
-- Data for Name: user_change_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_change_type (id, description) FROM stdin;
1	##Подразделение##
2	##Должность##
3	##Шаблон доступа##
4	##График работы##
5	##Блокировка##
\.


--
-- Data for Name: user_doc; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_doc (id, user_id, doc_id, doc_creation_date, duration, doc_begin_date, doc_end_date, doc_number, no_calculate, is_complex, operator_id) FROM stdin;
\.


--
-- Data for Name: user_image; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_image (user_id, field_id, image, user_type) FROM stdin;
\.


--
-- Data for Name: user_operator; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_operator (user_id, type_id, login, password, description, user_role_id, language, is_const, is_block, api_permissions, open_key, is_migrate, time_zone) FROM stdin;
6	2	1s	fc6b5d4440c2cc9b03bacd197c548794add573ec65f9e401288cfa64006f0257	\N	1	ru	1	1	{"all": {}, "usersIdGET": {}, "usersStaffTableGET": {}, "usersStaffTableHtmlGET": {}, "usersStaffListGET": {}, "usersStaffPUT": {}, "usersStaffIdGET": {}, "usersStaffIdPOST": {}, "usersAdditionalFieldListGET": {}, "usersIdDocsTableGET": {}, "usersIdDocsPUT": {}, "usersIdPlannerGET": {}, "usersIdPlannerPUT": {}, "usersIdErrorsGET": {}, "usersPlannerIdGET": {}, "usersPlannerIdPOST": {}, "usersPlannerIdDELETE": {}, "usersIdDocsIdGET": {}, "userDocsIdPOST": {}, "usersDocsIdDELETE": {}, "usersGetFingerprintCount": {}, "usersGetFingerprints": {}, "usersAddFingerprint": {}, "usersDeleteFingerprint": {}, "divisionsPUT": {}, "divisionsTreeGET": {}, "divisionsListGET": {}, "positionsListGET": {}, "positionsPUT": {}, "passDesignTemplatesListGET": {}, "passDesignTemplateUserData": {}, "devicesGET": {}, "devicesIdReaderGET": {}, "roomsWithDeviceTypeGET": {}, "accessTemplatesListGET": {}, "accessTemplatesPUT": {}, "accessTemplatesIdGET": {}, "accessSchedulesTypesGET": {}, "accessSchedulesListGET": {}, "accessSchedulesPUT": {}, "accessSchedulesIdGET": {}, "accessSchedulesIdPOST": {}, "accessTemplatesAccessRightsGET": {}, "accessTemplatesComissionTypesGET": {}, "timeAttendanceScheduleListGET": {}, "timeAttendanceSchedulePUT": {}, "timeAttendanceDocsListGET": {}, "parseFilePOST": {}, "associatePOST": {}, "importPOST": {}, "exportPOST": {}, "exportUnimportedPOST": {}, "getStatusImportGET": {}, "roomsTreeGET": {}, "timeAttendanceScheduleIdGET": {}, "divisionsTreeHtmlGET": {}, "divisionsListHtmlGET": {}, "divisionsIdGET": {}, "divisionsIdPOST": {}, "divisionsIdDELETE": {}, "timeAttendanceScheduleHolidaysListGET": {}, "timeAttendanceScheduleHolidaysPUT": {}, "timeAttendanceScheduleHolidaysFillPOST": {}, "timeAttendanceScheduleHolidaysClearPOST": {}, "timeAttendanceScheduleHolidaysIdGET": {}, "timeAttendanceScheduleHolidaysIdPOST": {}, "timeAttendanceScheduleHolidaysIdDELETE": {}, "timeAttendancePresetHolidaysGET": {}, "timeAttendancePresetHolidaysPUT": {}, "timeAttendancePresetHolidaysIdDELETE": {}, "usersAdditionalFieldsTableGET": {}, "usersAdditionalFieldsPUT": {}, "usersAdditionalFieldsIdGET": {}, "usersAdditionalFieldsIdPOST": {}, "usersAdditionalFieldsIdDELETE": {}, "usersVisitorTableGET": {}, "usersVisitorPUT": {}, "usersVisitorIdGET": {}, "usersVisitorIdPOST": {}, "accessTemplatesTableGET": {}, "accessTemplatesIdPOST": {}, "accessTemplatesIdDELETE": {}, "accessSchedulesTableGET": {}, "accessSchedulesIdDELETE": {}, "passDesignTemplatesTableGET": {}, "passDesignTemplatesItemGET": {}, "passDesignTemplatesItemPOST": {}, "passDesignTemplatesItemDELETE": {}, "passDesignTemplatesItemPUT": {}, "accessReportsVisitorsGET": {}, "timeAttendanceReportsTimeTrackingGET": {}, "timeAttendanceReportsEventsTableGET": {}, "timeAttendanceDocsTableGET": {}, "timeAttendanceDocsIdPOST": {}, "timeAttendanceDocsIdDELETE": {}, "timeAttendanceDocsPUT": {}, "timeAttendanceDocsTypesGET": {}, "timeAttendanceDocsCalcMethodsGET": {}, "timeAttendanceReportsTimesheetHtmlGET": {}, "timeAttendanceReportsTimesheetGET": {}, "timeAttendanceReportsViolatorsGET": {}, "timeAttendanceReportsPresenceGET": {}, "timeAttendanceReportsAbsenceGET": {}, "timeAttendanceReportsLateGET": {}, "timeAttendanceReportsEarlyGET": {}, "timeAttendanceReportsOverworkGET": {}, "accessReportsEventsGET": {}, "devicesIdGET": {}, "roomWithDevicesGET": {}, "accessReportsAccessZoneGET": {}, "accessReportsWhereaboutsGET": {}, "verifyTemplatesLIST": {}, "verifyGetTemplate": {}, "verifyTemplateTABLE": {}, "verifyTemplatePUT": {}, "verifyTemplateGET": {}, "verifyTemplatePOST": {}, "verifyTemplateDELETE": {}, "verifyGetPoint": {}, "verifyPointPUT": {}, "verifyPointPOST": {}, "verifyPointDELETE": {}, "verifyPointLIST": {}, "verifyPointTABLE": {}, "devicesPUT": {}, "devicesIdPOST": {}, "devicesIdDELETE": {}, "devicesIdActivatePOST": {}, "devicesIdDeactivatePOST": {}, "devicesIdAttachPOST": {}, "devicesIdDetachPOST": {}, "devicesSearchGET": {}, "roomsListGET": {}, "roomsPUT": {}, "roomsIdPOST": {}, "roomsIdDELETE": {}, "eventsystemGET": {}, "tasksGET": {}, "tasksPUT": {}, "tasksIdGET": {}, "tasksIdPOST": {}, "tasksIdDELETE": {}, "tasksIdStatusPOST": {}, "tasksTypesGET": {}, "operatorsGET": {}, "operatorsPUT": {}, "operatorsIdGET": {}, "operatorsIdPOST": {}, "operatorsIdDELETE": {}, "operatorsIdLockPOST": {}, "operatorsIdUnlockPOST": {}, "rolesListGET": {}, "rolesTableGET": {}, "rolesPUT": {}, "rolesIdGET": {}, "rolesIdPOST": {}, "rolesIdDELETE": {}, "licensesGET": {}, "licensesLicenseControllersGET": {}, "licensesSetLicenseKeyPOST": {}, "licensesCurrentLicenseControllerGET": {}, "licensesSetLicenseControllerPOST": {}, "licensesLicenseActivatePOST": {}, "licensesLicenseDeactivatePOST": {}, "timeAttendanceScheduleTableGET": {}, "timeAttendanceScheduleIdPOST": {}, "timeAttendanceScheduleIdDELETE": {}, "timeAttendanceScheduleNightTimeGET": {}, "timeAttendanceScheduleNightTimePOST": {}, "positionsTableGET": {}, "positionsTableHtmlGET": {}, "positionsIdGET": {}, "positionsIdPOST": {}, "positionsIdDELETE": {}}	GqPMWBuEqqtyqXEN	0	\N
2	1	sysserver	b99e557e4bb593f5490e0466442c8eb49ef3384a1fc3c15ed11ddf8fbe9c736f	\N	1	ru	1	0	{"all":{}}	ZQBYzD60KuqoNIAW	0	\N
3	1	pwmanager	e275a9135b18cae2c48e6288ff92aa379f37aa4c35cb7fc48330c35c1b2a55ac	\N	1	ru	1	0	{"all":{}}	waVehJFMzhjVqjxo	0	\N
4	1	mobileTerminal	a6dbe1d9b16049d2e5588e6f4efd3bcf1c46df28b31a139a9b221ecf299a6c3d	\N	1	ru	1	0	{"all":{}}	AdJKh3O88KYN605F	0	\N
5	1	event action	3323f2feec494b7c8f7dacb53ca4102cc2669646e095485f379960e5849b7aa7	\N	1	ru	1	0	{"all":{}}	tu4aeQEJwulgZXoF	0	\N
1	2	admin	28b1c46050f6ad76e8e3f89fa8da48aa107b2c13bce0d077f54a4413314caa32	\N	1	ru	1	0	{ "all": {} }	\N	0	\N
\.


--
-- Data for Name: user_operator_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_operator_type (id, name) FROM stdin;
3	Пользовательский
2	Предустановленный
1	Системный
\.


--
-- Data for Name: user_role; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_role (id, name, description, rights, is_const) FROM stdin;
1	admin	\N	\N	1
\.


--
-- Data for Name: user_staff; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_staff (user_id, hiring_date, tabel_number, is_dismissed, dismissed_date, work_schedule_id, viber_id) FROM stdin;
1	2022-03-21	0001	0	\N	\N	\N
\.


--
-- Data for Name: user_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_type (id, type, description) FROM stdin;
0	service	Служба
1	staff	Сотрудник
2	visitor	Посетитель
\.


--
-- Data for Name: user_visitor; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_visitor (user_id, accompanying_id, supporting_document, supporting_document_number, is_archived, archive_datetime) FROM stdin;
\.


--
-- Data for Name: verify_point; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.verify_point (id, verify_template_id, name, reader_device_id, reader_direction, camera_device_id, sort_id, hot_key_allow, hot_key_deny, schema_data, options) FROM stdin;
\.


--
-- Data for Name: verify_template; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.verify_template (id, is_const, name, comment, field_visibility_staff, field_visibility_visitor) FROM stdin;
\.


--
-- Data for Name: work_event_ignore; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.work_event_ignore (event_access_id) FROM stdin;
12515
12519
16699
16700
16705
\.


--
-- Data for Name: work_event_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.work_event_type (id, event_type_id, description) FROM stdin;
1	17	Проход по идентификатору
2	529	Проход по идентификатору с несоответствием временным критериям доступа
3	273	Проход по идентификатору с несоответствием текущему местоположению
4	785	Проход по идентификатору несоответствие временным критериям доступа и текущему местоположению
5	1041	Проход по идентификатору с нарушением комиссионирования
6	1553	Проход по идентификатору с несоответствием временным критериям доступа и с нарушением комиссионирования
7	1297	Проход по идентификатору с несоответствием текущему местоположению и с нарушением комиссионирования
8	1809	Проход по идентификатору несоответствие временным критериям доступа и текущему местоположению и с нарушением комиссионирования
9	2065	Проход по идентификаторупри отказе в подтверждении прохода от верификации
10	2577	Проход по идентификатору с несоответствием временным критериям доступа и при отказе в подтверждении прохода от верификации
11	2321	Проход по идентификатору с несоответствием текущему местоположению и при отказе в подтверждении прохода от верификации
12	2833	Проход по идентификатору несоответствие временным критериям доступа и текущему местоположению и при отказе в подтверждении прохода от верификации
13	23	Проход с подтверждением от ДУ
14	535	Проход с подтверждением от ДУ с несоответствием временным критериям доступа
15	279	Проход с подтверждением от ДУ с несоответствием текущему местоположению
16	791	Проход с подтверждением от ДУ несоответствие временным критериям доступа и текущему местоположению
17	27	Проход с подтверждением от верификации
18	539	Проход с подтверждением от верификации с несоответствием временным критериям доступа
19	283	Проход с подтверждением от верификации с несоответствием текущему местоположению
20	795	Проход с подтверждением от верификации несоответствие временным критериям доступа и текущему местоположению
21	5200	Проход через мобильный терминал
22	5109	Вход в шлюз
23	5110	Выход из шлюза
24	8209	Проход с подтверждением от ПДУ/верификации
25	8465	Проход с подтверждением от ПДУ/верификации: с несоответствием текущему местоположению 
26	8721	Проход с подтверждением от ПДУ/верификации: с несоответствием временным критериям доступа
27	8977	Проход с подтверждением от ПДУ/верификации: с несоответствием временным критериям доступа и текущему местоположению
28	12305	Проход с подтверждением от ВВУ и далее ПДУ/верификации
29	12561	Проход с подтверждением от ВВУ и далее ПДУ/верификации: с несоответствием текущему местоположению
30	12817	Проход с подтверждением от ВВУ и далее ПДУ/верификации: с несоответствием временным критериям доступа
31	13073	Проход с подтверждением от ВВУ и далее ПДУ/верификации: с несоответствием временным критериям доступа и текущему местоположению
32	4113	Проход с подтверждением от ВВУ
33	4369	Проход с подтверждением от ВВУ: с несоответствием текущему местоположению
34	4625	Проход с подтверждением от ВВУ: с несоответствием временным критериям доступа
35	4881	Проход с подтверждением от ВВУ: с несоответствием временным критериям доступа и текущему местоположению
36	5202	Проход без медицинской маски
37	5203	Проход с повышенной температурой
\.


--
-- Data for Name: work_holiday; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.work_holiday (day, name, work_holiday_type_id, reduction, transfer_date) FROM stdin;
\.


--
-- Data for Name: work_holiday_parameters; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.work_holiday_parameters (night_time_begin, night_time_end, evening_time_begin, evening_time_end, is_evening_time) FROM stdin;
03:56:00	07:00:00	01:00:00	05:00:00	0
\.


--
-- Data for Name: work_holyday_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.work_holyday_type (id, name) FROM stdin;
4	##Пометка##
1	##Праздник##
2	##Предпраздничный день##
3	##Рабочий выходной##
\.


--
-- Data for Name: work_schedule; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.work_schedule (id, is_const, name, comment, is_not_holiday, is_first_input_last_output, work_schedule_type_id, begin_date, control_coming_before, control_leaving_later, allow_coming_later, allow_leaving_before, allow_slide_coming_later, allow_slide_leaving_before, is_removed, overtime, undertime, allow_breaks, worktime_begin, worktime_end, balance_stored, workday_list) FROM stdin;
\.


--
-- Data for Name: work_schedule_access_zone; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.work_schedule_access_zone (work_schedule_id, access_zone_id, is_discipline_control) FROM stdin;
\.


--
-- Data for Name: work_schedule_day; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.work_schedule_day (id, work_schedule_id, constant_component) FROM stdin;
\.


--
-- Data for Name: work_schedule_interval; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.work_schedule_interval (work_schedule_id, begin_time, end_time, schedule_interval_type) FROM stdin;
\.


--
-- Data for Name: work_schedule_no_access_device; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.work_schedule_no_access_device (work_schedule_id, device_id) FROM stdin;
\.


--
-- Data for Name: work_schedule_no_access_zone; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.work_schedule_no_access_zone (work_schedule_id, access_zone_id) FROM stdin;
\.


--
-- Data for Name: work_schedule_preset_holiday; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.work_schedule_preset_holiday (id, day, month, name) FROM stdin;
\.


--
-- Data for Name: work_schedule_type; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.work_schedule_type (id, name) FROM stdin;
2	##Недельный##
1	##Никогда##
4	##По присутствию##
6	##С накоплением нарушений на основе баланса##
5	##С накоплением нарушений##
3	##Сменный##
\.


--
-- Name: access_template_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.access_template_id_seq', 1, true);


--
-- Name: access_zone_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.access_zone_id_seq', 1, true);


--
-- Name: available_right_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.available_right_id_seq', 1, true);


--
-- Name: available_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.available_type_id_seq', 11, true);


--
-- Name: barcode_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.barcode_type_id_seq', 1, true);


--
-- Name: category_tab_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.category_tab_id_seq', 99, true);


--
-- Name: device_camera_stream_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.device_camera_stream_id_seq', 4, true);


--
-- Name: device_camera_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.device_camera_type_id_seq', 10, true);


--
-- Name: device_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.device_id_seq', 1, true);


--
-- Name: device_resource_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.device_resource_id_seq', 109, true);


--
-- Name: device_resource_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.device_resource_type_id_seq', 35, true);


--
-- Name: device_schema_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.device_schema_id_seq', 188, true);


--
-- Name: division_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.division_id_seq', 1, true);


--
-- Name: doc_calc_method_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.doc_calc_method_id_seq', 3, true);


--
-- Name: doc_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.doc_id_seq', 139, true);


--
-- Name: doc_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.doc_type_id_seq', 3, true);


--
-- Name: event_action_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.event_action_id_seq', 1, true);


--
-- Name: event_action_object_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.event_action_object_id_seq', 1, true);


--
-- Name: event_action_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.event_action_type_id_seq', 3, true);


--
-- Name: event_category_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.event_category_id_seq', 5, true);


--
-- Name: event_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.event_id_seq', 17, true);


--
-- Name: event_resource_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.event_resource_type_id_seq', 15, true);


--
-- Name: event_subcategory_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.event_subcategory_id_seq', 12000, true);


--
-- Name: event_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.event_type_id_seq', 506913, true);


--
-- Name: event_verify_result_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.event_verify_result_id_seq', 5, true);


--
-- Name: language_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.language_id_seq', 5, true);


--
-- Name: license_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.license_id_seq', 12, true);


--
-- Name: mobile_terminal_device_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.mobile_terminal_device_id_seq', 1, true);


--
-- Name: pass_template_design_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.pass_template_design_id_seq', 1, true);


--
-- Name: plan_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.plan_id_seq', 1, true);


--
-- Name: position_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.position_id_seq', 6, true);


--
-- Name: region_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.region_id_seq', 3, true);


--
-- Name: schedule_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.schedule_id_seq', 11, true);


--
-- Name: schedule_item_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.schedule_item_id_seq', 2, true);


--
-- Name: schedule_item_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.schedule_item_type_id_seq', 6, true);


--
-- Name: schedule_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.schedule_type_id_seq', 6, true);


--
-- Name: segment_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.segment_id_seq', 1, true);


--
-- Name: settings_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.settings_id_seq', 3, true);


--
-- Name: task_action_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.task_action_id_seq', 1, true);


--
-- Name: task_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.task_id_seq', 1, true);


--
-- Name: task_state_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.task_state_id_seq', 3, true);


--
-- Name: task_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.task_type_id_seq', 3, true);


--
-- Name: user_additional_field_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.user_additional_field_id_seq', 2, true);


--
-- Name: user_additional_field_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.user_additional_field_type_id_seq', 6, true);


--
-- Name: user_bio_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.user_bio_id_seq', 1, true);


--
-- Name: user_car_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.user_car_id_seq', 1, true);


--
-- Name: user_card_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.user_card_id_seq', 1, true);


--
-- Name: user_change_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.user_change_id_seq', 1, true);


--
-- Name: user_change_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.user_change_type_id_seq', 5, true);


--
-- Name: user_doc_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.user_doc_id_seq', 1, true);


--
-- Name: user_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.user_id_seq', 6, true);


--
-- Name: user_operator_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.user_operator_type_id_seq', 3, true);


--
-- Name: user_role_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.user_role_id_seq', 1, true);


--
-- Name: user_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.user_type_id_seq', 2, true);


--
-- Name: verify_point_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.verify_point_id_seq', 1, true);


--
-- Name: verify_template_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.verify_template_id_seq', 1, true);


--
-- Name: work_event_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.work_event_type_id_seq', 37, true);


--
-- Name: work_holyday_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.work_holyday_type_id_seq', 4, true);


--
-- Name: work_schedule_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.work_schedule_id_seq', 1, true);


--
-- Name: work_schedule_preset_holiday_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.work_schedule_preset_holiday_id_seq', 1, true);


--
-- Name: work_schedule_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.work_schedule_type_id_seq', 6, true);


--
-- Name: access_template idx_16387_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.access_template
    ADD CONSTRAINT idx_16387_primary PRIMARY KEY (id);


--
-- Name: access_template_params idx_16396_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.access_template_params
    ADD CONSTRAINT idx_16396_primary PRIMARY KEY (access_template_id, access_zone_id, template_type);


--
-- Name: access_template_type idx_16404_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.access_template_type
    ADD CONSTRAINT idx_16404_primary PRIMARY KEY (id);


--
-- Name: access_type idx_16410_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.access_type
    ADD CONSTRAINT idx_16410_primary PRIMARY KEY (id);


--
-- Name: access_zone idx_16418_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.access_zone
    ADD CONSTRAINT idx_16418_primary PRIMARY KEY (id);


--
-- Name: access_zone_commission idx_16427_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.access_zone_commission
    ADD CONSTRAINT idx_16427_primary PRIMARY KEY (access_zone_id, user_id);


--
-- Name: available_category_tab idx_16430_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.available_category_tab
    ADD CONSTRAINT idx_16430_primary PRIMARY KEY (user_id, cat_id);


--
-- Name: available_right idx_16436_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.available_right
    ADD CONSTRAINT idx_16436_primary PRIMARY KEY (id);


--
-- Name: available_type idx_16442_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.available_type
    ADD CONSTRAINT idx_16442_primary PRIMARY KEY (id);


--
-- Name: barcode_type idx_16451_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.barcode_type
    ADD CONSTRAINT idx_16451_primary PRIMARY KEY (id);


--
-- Name: category_tab idx_16460_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.category_tab
    ADD CONSTRAINT idx_16460_primary PRIMARY KEY (id);


--
-- Name: device idx_16470_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device
    ADD CONSTRAINT idx_16470_primary PRIMARY KEY (id);


--
-- Name: device_camera_stream idx_16480_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_camera_stream
    ADD CONSTRAINT idx_16480_primary PRIMARY KEY (id);


--
-- Name: device_camera_type idx_16489_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_camera_type
    ADD CONSTRAINT idx_16489_primary PRIMARY KEY (id);


--
-- Name: device_resource idx_16499_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_resource
    ADD CONSTRAINT idx_16499_primary PRIMARY KEY (id);


--
-- Name: device_resource_change idx_16506_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_resource_change
    ADD CONSTRAINT idx_16506_primary PRIMARY KEY (device_id, resource_type, resource_number);


--
-- Name: device_resource_type idx_16511_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_resource_type
    ADD CONSTRAINT idx_16511_primary PRIMARY KEY (id);


--
-- Name: device_schema idx_16520_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_schema
    ADD CONSTRAINT idx_16520_primary PRIMARY KEY (id);


--
-- Name: device_type idx_16527_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_type
    ADD CONSTRAINT idx_16527_primary PRIMARY KEY (id);


--
-- Name: device_vendor idx_16539_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_vendor
    ADD CONSTRAINT idx_16539_primary PRIMARY KEY (id);


--
-- Name: division idx_16547_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.division
    ADD CONSTRAINT idx_16547_primary PRIMARY KEY (id);


--
-- Name: doc idx_16558_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.doc
    ADD CONSTRAINT idx_16558_primary PRIMARY KEY (id);


--
-- Name: doc_calc_method idx_16571_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.doc_calc_method
    ADD CONSTRAINT idx_16571_primary PRIMARY KEY (id);


--
-- Name: doc_type idx_16580_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.doc_type
    ADD CONSTRAINT idx_16580_primary PRIMARY KEY (id);


--
-- Name: event idx_16589_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.event
    ADD CONSTRAINT idx_16589_primary PRIMARY KEY (id);


--
-- Name: event_action idx_16599_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.event_action
    ADD CONSTRAINT idx_16599_primary PRIMARY KEY (id);


--
-- Name: event_action_object idx_16608_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.event_action_object
    ADD CONSTRAINT idx_16608_primary PRIMARY KEY (id);


--
-- Name: event_action_type idx_16623_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.event_action_type
    ADD CONSTRAINT idx_16623_primary PRIMARY KEY (id);


--
-- Name: event_category idx_16632_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.event_category
    ADD CONSTRAINT idx_16632_primary PRIMARY KEY (id);


--
-- Name: event_resource_type idx_16641_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.event_resource_type
    ADD CONSTRAINT idx_16641_primary PRIMARY KEY (id);


--
-- Name: event_subcategory idx_16650_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.event_subcategory
    ADD CONSTRAINT idx_16650_primary PRIMARY KEY (id);


--
-- Name: event_type idx_16659_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.event_type
    ADD CONSTRAINT idx_16659_primary PRIMARY KEY (id);


--
-- Name: event_verify_result idx_16668_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.event_verify_result
    ADD CONSTRAINT idx_16668_primary PRIMARY KEY (id);


--
-- Name: language idx_16677_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.language
    ADD CONSTRAINT idx_16677_primary PRIMARY KEY (id);


--
-- Name: license idx_16687_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.license
    ADD CONSTRAINT idx_16687_primary PRIMARY KEY (id);


--
-- Name: license_state idx_16695_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.license_state
    ADD CONSTRAINT idx_16695_primary PRIMARY KEY (id);


--
-- Name: mobile_terminal_device idx_16703_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mobile_terminal_device
    ADD CONSTRAINT idx_16703_primary PRIMARY KEY (id);


--
-- Name: pass_template_design idx_16714_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.pass_template_design
    ADD CONSTRAINT idx_16714_primary PRIMARY KEY (id);


--
-- Name: plan idx_16723_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.plan
    ADD CONSTRAINT idx_16723_primary PRIMARY KEY (id);


--
-- Name: position idx_16732_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."position"
    ADD CONSTRAINT idx_16732_primary PRIMARY KEY (id);


--
-- Name: property_table idx_16741_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.property_table
    ADD CONSTRAINT idx_16741_primary PRIMARY KEY (id);


--
-- Name: region idx_16752_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.region
    ADD CONSTRAINT idx_16752_primary PRIMARY KEY (id);


--
-- Name: schedule idx_16761_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.schedule
    ADD CONSTRAINT idx_16761_primary PRIMARY KEY (id);


--
-- Name: schedule_item idx_16771_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.schedule_item
    ADD CONSTRAINT idx_16771_primary PRIMARY KEY (id);


--
-- Name: schedule_item_type idx_16780_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.schedule_item_type
    ADD CONSTRAINT idx_16780_primary PRIMARY KEY (id);


--
-- Name: schedule_type idx_16789_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.schedule_type
    ADD CONSTRAINT idx_16789_primary PRIMARY KEY (id);


--
-- Name: segment idx_16804_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.segment
    ADD CONSTRAINT idx_16804_primary PRIMARY KEY (id);


--
-- Name: settings idx_16815_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.settings
    ADD CONSTRAINT idx_16815_primary PRIMARY KEY (id);


--
-- Name: task idx_16824_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.task
    ADD CONSTRAINT idx_16824_primary PRIMARY KEY (id);


--
-- Name: task_action idx_16833_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.task_action
    ADD CONSTRAINT idx_16833_primary PRIMARY KEY (id);


--
-- Name: task_state idx_16842_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.task_state
    ADD CONSTRAINT idx_16842_primary PRIMARY KEY (id);


--
-- Name: task_type idx_16851_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.task_type
    ADD CONSTRAINT idx_16851_primary PRIMARY KEY (id);


--
-- Name: user idx_16860_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."user"
    ADD CONSTRAINT idx_16860_primary PRIMARY KEY (id);


--
-- Name: user_additional_field idx_16875_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_additional_field
    ADD CONSTRAINT idx_16875_primary PRIMARY KEY (id);


--
-- Name: user_additional_field_data idx_16883_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_additional_field_data
    ADD CONSTRAINT idx_16883_primary PRIMARY KEY (user_id, field_id);


--
-- Name: user_additional_field_type idx_16891_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_additional_field_type
    ADD CONSTRAINT idx_16891_primary PRIMARY KEY (id);


--
-- Name: user_bio idx_16903_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_bio
    ADD CONSTRAINT idx_16903_primary PRIMARY KEY (id);


--
-- Name: user_car idx_16913_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_car
    ADD CONSTRAINT idx_16913_primary PRIMARY KEY (id);


--
-- Name: user_card idx_16922_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_card
    ADD CONSTRAINT idx_16922_primary PRIMARY KEY (id);


--
-- Name: user_change idx_16931_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_change
    ADD CONSTRAINT idx_16931_primary PRIMARY KEY (id);


--
-- Name: user_change_type idx_16939_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_change_type
    ADD CONSTRAINT idx_16939_primary PRIMARY KEY (id);


--
-- Name: user_doc idx_16948_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_doc
    ADD CONSTRAINT idx_16948_primary PRIMARY KEY (id);


--
-- Name: user_operator idx_16963_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_operator
    ADD CONSTRAINT idx_16963_primary PRIMARY KEY (user_id);


--
-- Name: user_operator_type idx_16975_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_operator_type
    ADD CONSTRAINT idx_16975_primary PRIMARY KEY (id);


--
-- Name: user_role idx_16984_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_role
    ADD CONSTRAINT idx_16984_primary PRIMARY KEY (id);


--
-- Name: user_staff idx_16992_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_staff
    ADD CONSTRAINT idx_16992_primary PRIMARY KEY (user_id);


--
-- Name: user_type idx_17001_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_type
    ADD CONSTRAINT idx_17001_primary PRIMARY KEY (id);


--
-- Name: user_visitor idx_17008_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_visitor
    ADD CONSTRAINT idx_17008_primary PRIMARY KEY (user_id);


--
-- Name: verify_point idx_17017_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.verify_point
    ADD CONSTRAINT idx_17017_primary PRIMARY KEY (id);


--
-- Name: verify_template idx_17026_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.verify_template
    ADD CONSTRAINT idx_17026_primary PRIMARY KEY (id);


--
-- Name: work_event_ignore idx_17033_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.work_event_ignore
    ADD CONSTRAINT idx_17033_primary PRIMARY KEY (event_access_id);


--
-- Name: work_event_type idx_17041_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.work_event_type
    ADD CONSTRAINT idx_17041_primary PRIMARY KEY (id);


--
-- Name: work_holiday idx_17048_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.work_holiday
    ADD CONSTRAINT idx_17048_primary PRIMARY KEY (day);


--
-- Name: work_holyday_type idx_17060_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.work_holyday_type
    ADD CONSTRAINT idx_17060_primary PRIMARY KEY (id);


--
-- Name: work_schedule idx_17069_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.work_schedule
    ADD CONSTRAINT idx_17069_primary PRIMARY KEY (id);


--
-- Name: work_schedule_access_zone idx_17076_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.work_schedule_access_zone
    ADD CONSTRAINT idx_17076_primary PRIMARY KEY (work_schedule_id, access_zone_id);


--
-- Name: work_schedule_day idx_17079_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.work_schedule_day
    ADD CONSTRAINT idx_17079_primary PRIMARY KEY (id, work_schedule_id);


--
-- Name: work_schedule_preset_holiday idx_17093_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.work_schedule_preset_holiday
    ADD CONSTRAINT idx_17093_primary PRIMARY KEY (id);


--
-- Name: work_schedule_type idx_17102_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.work_schedule_type
    ADD CONSTRAINT idx_17102_primary PRIMARY KEY (id);


--
-- Name: idx_16387_access_template_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16387_access_template_id_uindex ON public.access_template USING btree (id);


--
-- Name: idx_16387_unq1_access_template; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16387_unq1_access_template ON public.access_template USING btree (name);


--
-- Name: idx_16404_access_template_type_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16404_access_template_type_id_uindex ON public.access_template_type USING btree (id);


--
-- Name: idx_16404_access_template_type_name_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16404_access_template_type_name_uindex ON public.access_template_type USING btree (name);


--
-- Name: idx_16410_access_type_name_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16410_access_type_name_uindex ON public.access_type USING btree (name);


--
-- Name: idx_16418_access_zone_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16418_access_zone_id_uindex ON public.access_zone USING btree (id);


--
-- Name: idx_16418_access_zone_segment_id_fk; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16418_access_zone_segment_id_fk ON public.access_zone USING btree (segment_id);


--
-- Name: idx_16427_access_zone_commission_user_id_fk; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16427_access_zone_commission_user_id_fk ON public.access_zone_commission USING btree (user_id);


--
-- Name: idx_16436_available_right_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16436_available_right_id_uindex ON public.available_right USING btree (id);


--
-- Name: idx_16442_available_type_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16442_available_type_id_uindex ON public.available_type USING btree (id);


--
-- Name: idx_16442_available_type_source_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16442_available_type_source_uindex ON public.available_type USING btree (source);


--
-- Name: idx_16451_barcode_type_name_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16451_barcode_type_name_uindex ON public.barcode_type USING btree (name);


--
-- Name: idx_16460_category_tab_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16460_category_tab_id_uindex ON public.category_tab USING btree (id);


--
-- Name: idx_16470_device_segment_id_fk; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16470_device_segment_id_fk ON public.device USING btree (segment_id);


--
-- Name: idx_16470_plc_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16470_plc_id_uindex ON public.device USING btree (id);


--
-- Name: idx_16470_plc_idx1; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16470_plc_idx1 ON public.device USING btree (ip_addr);


--
-- Name: idx_16470_plc_idx2; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16470_plc_idx2 ON public.device USING btree (access_zone_id1);


--
-- Name: idx_16470_plc_idx3; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16470_plc_idx3 ON public.device USING btree (access_zone_id2);


--
-- Name: idx_16480_camera_stream_type_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16480_camera_stream_type_id_uindex ON public.device_camera_stream USING btree (id);


--
-- Name: idx_16480_unq1_camera_stream_type; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16480_unq1_camera_stream_type ON public.device_camera_stream USING btree (name);


--
-- Name: idx_16489_camera_type_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16489_camera_type_id_uindex ON public.device_camera_type USING btree (id);


--
-- Name: idx_16489_unq1_camera_type; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16489_unq1_camera_type ON public.device_camera_type USING btree (manufacturer, model, camera_stream_type_id);


--
-- Name: idx_16499_resource_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16499_resource_id_uindex ON public.device_resource USING btree (id);


--
-- Name: idx_16511_resource_type_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16511_resource_type_id_uindex ON public.device_resource_type USING btree (id);


--
-- Name: idx_16520_schema_new_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16520_schema_new_id_uindex ON public.device_schema USING btree (id);


--
-- Name: idx_16520_schema_new_title_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16520_schema_new_title_uindex ON public.device_schema USING btree (title);


--
-- Name: idx_16527_plc_type_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16527_plc_type_id_uindex ON public.device_type USING btree (id);


--
-- Name: idx_16527_unq3_plc_type; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16527_unq3_plc_type ON public.device_type USING btree (device_type);


--
-- Name: idx_16533_device_user_change_device_id_fk; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16533_device_user_change_device_id_fk ON public.device_user_change USING btree (device_id);


--
-- Name: idx_16533_device_user_change_user_id_fk; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16533_device_user_change_user_id_fk ON public.device_user_change USING btree (user_id);


--
-- Name: idx_16539_plc_vendor_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16539_plc_vendor_id_uindex ON public.device_vendor USING btree (id);


--
-- Name: idx_16539_plc_vendor_name_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16539_plc_vendor_name_uindex ON public.device_vendor USING btree (name);


--
-- Name: idx_16547_division_access_template_id_fk; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16547_division_access_template_id_fk ON public.division USING btree (staff_access_template_id);


--
-- Name: idx_16547_division_access_template_id_fk_2; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16547_division_access_template_id_fk_2 ON public.division USING btree (visitor_access_template_id);


--
-- Name: idx_16547_division_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16547_division_id_uindex ON public.division USING btree (id);


--
-- Name: idx_16547_division_user_id_fk; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16547_division_user_id_fk ON public.division USING btree (accompanying_id);


--
-- Name: idx_16547_division_work_schedule_id_fk; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16547_division_work_schedule_id_fk ON public.division USING btree (work_schedule_id);


--
-- Name: idx_16547_unq1_division; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16547_unq1_division ON public.division USING btree (name, parent_id);


--
-- Name: idx_16558_doc_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16558_doc_id_uindex ON public.doc USING btree (id);


--
-- Name: idx_16558_doc_name; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16558_doc_name ON public.doc USING btree (name);


--
-- Name: idx_16571_calc_method_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16571_calc_method_id_uindex ON public.doc_calc_method USING btree (id);


--
-- Name: idx_16571_unq1_calc_method; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16571_unq1_calc_method ON public.doc_calc_method USING btree (name);


--
-- Name: idx_16580_doc_type_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16580_doc_type_id_uindex ON public.doc_type USING btree (id);


--
-- Name: idx_16580_doc_type_name_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16580_doc_type_name_uindex ON public.doc_type USING btree (name);


--
-- Name: idx_16589_event_access_zone_id1_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16589_event_access_zone_id1_index ON public.event USING btree (access_zone_id1);


--
-- Name: idx_16589_event_access_zone_id2_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16589_event_access_zone_id2_index ON public.event USING btree (access_zone_id2);


--
-- Name: idx_16589_event_device_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16589_event_device_id_index ON public.event USING btree (device_id);


--
-- Name: idx_16589_event_identifier_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16589_event_identifier_index ON public.event USING btree (identifier);


--
-- Name: idx_16589_event_plc_card_holder_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16589_event_plc_card_holder_id_index ON public.event USING btree (user_id);


--
-- Name: idx_16589_event_plc_event_type_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16589_event_plc_event_type_index ON public.event USING btree (event_type);


--
-- Name: idx_16589_event_plc_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16589_event_plc_id_uindex ON public.event USING btree (id);


--
-- Name: idx_16589_event_plc_idx1; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16589_event_plc_idx1 ON public.event USING btree (time_label);


--
-- Name: idx_16589_event_segment_id_fk; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16589_event_segment_id_fk ON public.event USING btree (segment_id);


--
-- Name: idx_16589_event_time_label_utc_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16589_event_time_label_utc_index ON public.event USING btree (time_label_utc);


--
-- Name: idx_16599_event_action_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16599_event_action_id_uindex ON public.event_action USING btree (id);


--
-- Name: idx_16599_name; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16599_name ON public.event_action USING btree (name);


--
-- Name: idx_16623_event_action_type_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16623_event_action_type_id_uindex ON public.event_action_type USING btree (id);


--
-- Name: idx_16623_name; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16623_name ON public.event_action_type USING btree (name);


--
-- Name: idx_16632_event_category_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16632_event_category_id_uindex ON public.event_category USING btree (id);


--
-- Name: idx_16632_unq1_event_category; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16632_unq1_event_category ON public.event_category USING btree (name);


--
-- Name: idx_16641_event_resource_type_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16641_event_resource_type_id_uindex ON public.event_resource_type USING btree (id);


--
-- Name: idx_16641_unq1_event_resource_type; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16641_unq1_event_resource_type ON public.event_resource_type USING btree (name);


--
-- Name: idx_16650_event_subcategory_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16650_event_subcategory_id_uindex ON public.event_subcategory USING btree (id);


--
-- Name: idx_16650_unq1_event_subcategory; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16650_unq1_event_subcategory ON public.event_subcategory USING btree (name);


--
-- Name: idx_16659_event_type_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16659_event_type_id_uindex ON public.event_type USING btree (id);


--
-- Name: idx_16668_event_verify_result_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16668_event_verify_result_id_uindex ON public.event_verify_result USING btree (id);


--
-- Name: idx_16677_language_code_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16677_language_code_uindex ON public.language USING btree (code);


--
-- Name: idx_16677_language_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16677_language_id_uindex ON public.language USING btree (id);


--
-- Name: idx_16677_language_name_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16677_language_name_uindex ON public.language USING btree (name);


--
-- Name: idx_16687_license_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16687_license_id_uindex ON public.license USING btree (id);


--
-- Name: idx_16687_license_string_constant_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16687_license_string_constant_uindex ON public.license USING btree (string_constant);


--
-- Name: idx_16687_unq1_license; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16687_unq1_license ON public.license USING btree (module_number);


--
-- Name: idx_16687_unq2_license; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16687_unq2_license ON public.license USING btree (name);


--
-- Name: idx_16687_unq3_license; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16687_unq3_license ON public.license USING btree (license_key);


--
-- Name: idx_16695_license_state_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16695_license_state_id_uindex ON public.license_state USING btree (id);


--
-- Name: idx_16703_mobile_terminal_device_device_id_fk; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16703_mobile_terminal_device_device_id_fk ON public.mobile_terminal_device USING btree (device_id);


--
-- Name: idx_16703_mobile_terminal_device_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16703_mobile_terminal_device_id_uindex ON public.mobile_terminal_device USING btree (id);


--
-- Name: idx_16703_mobile_terminal_device_uid_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16703_mobile_terminal_device_uid_uindex ON public.mobile_terminal_device USING btree (uid);


--
-- Name: idx_16714_pass_template_design_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16714_pass_template_design_id_uindex ON public.pass_template_design USING btree (id);


--
-- Name: idx_16714_unq1_pass_template_design; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16714_unq1_pass_template_design ON public.pass_template_design USING btree (name);


--
-- Name: idx_16723_plan_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16723_plan_id_uindex ON public.plan USING btree (id);


--
-- Name: idx_16723_plan_name_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16723_plan_name_uindex ON public.plan USING btree (name);


--
-- Name: idx_16732_staff_position_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16732_staff_position_id_uindex ON public."position" USING btree (id);


--
-- Name: idx_16732_unq1_staff_position; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16732_unq1_staff_position ON public."position" USING btree (name);


--
-- Name: idx_16741_property_table_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16741_property_table_id_uindex ON public.property_table USING btree (id);


--
-- Name: idx_16752_region_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16752_region_id_uindex ON public.region USING btree (id);


--
-- Name: idx_16752_region_name_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16752_region_name_uindex ON public.region USING btree (name);


--
-- Name: idx_16761_schedule_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16761_schedule_id_uindex ON public.schedule USING btree (id);


--
-- Name: idx_16771_schedule_day_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16771_schedule_day_id_uindex ON public.schedule_item USING btree (id);


--
-- Name: idx_16780_schedule_item_type_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16780_schedule_item_type_id_uindex ON public.schedule_item_type USING btree (id);


--
-- Name: idx_16789_schedule_type_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16789_schedule_type_id_uindex ON public.schedule_type USING btree (id);


--
-- Name: idx_16789_schedule_type_schema_title_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16789_schedule_type_schema_title_uindex ON public.schedule_type USING btree (schema_title);


--
-- Name: idx_16789_unq1_schedule_type; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16789_unq1_schedule_type ON public.schedule_type USING btree (name);


--
-- Name: idx_16804_segment_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16804_segment_id_uindex ON public.segment USING btree (id);


--
-- Name: idx_16804_segment_name_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16804_segment_name_uindex ON public.segment USING btree (name);


--
-- Name: idx_16815_settings_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16815_settings_id_uindex ON public.settings USING btree (id);


--
-- Name: idx_16815_settings_title_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16815_settings_title_uindex ON public.settings USING btree (title);


--
-- Name: idx_16824_task_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16824_task_id_uindex ON public.task USING btree (id);


--
-- Name: idx_16842_task_state_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16842_task_state_id_uindex ON public.task_state USING btree (id);


--
-- Name: idx_16842_unq1_task_state; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16842_unq1_task_state ON public.task_state USING btree (name);


--
-- Name: idx_16851_task_type_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16851_task_type_id_uindex ON public.task_type USING btree (id);


--
-- Name: idx_16851_unq1_task_type; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16851_unq1_task_type ON public.task_type USING btree (name);


--
-- Name: idx_16860_user_access_template_id_fk; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16860_user_access_template_id_fk ON public."user" USING btree (access_template_id);


--
-- Name: idx_16860_user_division_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16860_user_division_id_index ON public."user" USING btree (division_id);


--
-- Name: idx_16860_user_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16860_user_id_uindex ON public."user" USING btree (id);


--
-- Name: idx_16860_user_last_name_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16860_user_last_name_index ON public."user" USING btree (last_name);


--
-- Name: idx_16860_user_position_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16860_user_position_id_index ON public."user" USING btree (position_id);


--
-- Name: idx_16860_user_user_type_id_fk; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16860_user_user_type_id_fk ON public."user" USING btree (user_type_id);


--
-- Name: idx_16875_user_additional_field_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16875_user_additional_field_id_uindex ON public.user_additional_field USING btree (id);


--
-- Name: idx_16883_user_additional_field_data_user_additional_field_id_f; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16883_user_additional_field_data_user_additional_field_id_f ON public.user_additional_field_data USING btree (field_id);


--
-- Name: idx_16891_user_additional_field_type_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16891_user_additional_field_type_id_uindex ON public.user_additional_field_type USING btree (id);


--
-- Name: idx_16891_user_additional_field_type_name_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16891_user_additional_field_type_name_uindex ON public.user_additional_field_type USING btree (name);


--
-- Name: idx_16898_user_barcode_barcode_type_id_fk; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16898_user_barcode_barcode_type_id_fk ON public.user_barcode USING btree (barcode_type_id);


--
-- Name: idx_16898_user_barcode_user_card_id_fk; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16898_user_barcode_user_card_id_fk ON public.user_barcode USING btree (identifier_id);


--
-- Name: idx_16903_user_fingerprint_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16903_user_fingerprint_id_uindex ON public.user_bio USING btree (id);


--
-- Name: idx_16903_user_fingerprint_user_id_fk; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16903_user_fingerprint_user_id_fk ON public.user_bio USING btree (user_id);


--
-- Name: idx_16913_user_car_user_id_fk; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16913_user_car_user_id_fk ON public.user_car USING btree (user_id);


--
-- Name: idx_16922_user_card_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16922_user_card_id_uindex ON public.user_card USING btree (id);


--
-- Name: idx_16922_user_card_identifier_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16922_user_card_identifier_uindex ON public.user_card USING btree (identifier);


--
-- Name: idx_16922_user_card_user_id_fk; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16922_user_card_user_id_fk ON public.user_card USING btree (user_id);


--
-- Name: idx_16931_fk_user_change_user_id; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16931_fk_user_change_user_id ON public.user_change USING btree (user_id);


--
-- Name: idx_16931_user_change_begin_date_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16931_user_change_begin_date_index ON public.user_change USING btree (begin_date);


--
-- Name: idx_16931_user_change_end_date_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16931_user_change_end_date_index ON public.user_change USING btree (end_date);


--
-- Name: idx_16931_user_change_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16931_user_change_id_uindex ON public.user_change USING btree (id);


--
-- Name: idx_16939_user_change_type_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16939_user_change_type_id_uindex ON public.user_change_type USING btree (id);


--
-- Name: idx_16948_user_doc_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16948_user_doc_id_uindex ON public.user_doc USING btree (id);


--
-- Name: idx_16948_user_doc_user_operator_user_id_fk; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16948_user_doc_user_operator_user_id_fk ON public.user_doc USING btree (operator_id);


--
-- Name: idx_16957_user_image_user_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16957_user_image_user_id_index ON public.user_image USING btree (user_id);


--
-- Name: idx_16963_user_operator_login_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16963_user_operator_login_uindex ON public.user_operator USING btree (login);


--
-- Name: idx_16963_user_operator_user_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16963_user_operator_user_id_uindex ON public.user_operator USING btree (user_id);


--
-- Name: idx_16963_user_operator_user_operator_type_id_fk; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16963_user_operator_user_operator_type_id_fk ON public.user_operator USING btree (type_id);


--
-- Name: idx_16975_user_operator_type_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16975_user_operator_type_id_uindex ON public.user_operator_type USING btree (id);


--
-- Name: idx_16975_user_operator_type_name_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16975_user_operator_type_name_uindex ON public.user_operator_type USING btree (name);


--
-- Name: idx_16984_unq1_user_role; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16984_unq1_user_role ON public.user_role USING btree (name);


--
-- Name: idx_16984_user_role_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16984_user_role_id_uindex ON public.user_role USING btree (id);


--
-- Name: idx_16992_user_staff_user_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16992_user_staff_user_id_uindex ON public.user_staff USING btree (user_id);


--
-- Name: idx_16992_user_staff_work_schedule_id_fk; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16992_user_staff_work_schedule_id_fk ON public.user_staff USING btree (work_schedule_id);


--
-- Name: idx_17001_user_type_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_17001_user_type_id_uindex ON public.user_type USING btree (id);


--
-- Name: idx_17001_user_type_type_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_17001_user_type_type_uindex ON public.user_type USING btree (type);


--
-- Name: idx_17008_user_visitor_accompanying_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17008_user_visitor_accompanying_id_index ON public.user_visitor USING btree (accompanying_id);


--
-- Name: idx_17008_user_visitor_user_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_17008_user_visitor_user_id_uindex ON public.user_visitor USING btree (user_id);


--
-- Name: idx_17017_verify_point_device_id_fk; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17017_verify_point_device_id_fk ON public.verify_point USING btree (reader_device_id);


--
-- Name: idx_17017_verify_point_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_17017_verify_point_id_uindex ON public.verify_point USING btree (id);


--
-- Name: idx_17026_unq1_verify_template; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_17026_unq1_verify_template ON public.verify_template USING btree (name);


--
-- Name: idx_17026_verify_template_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_17026_verify_template_id_uindex ON public.verify_template USING btree (id);


--
-- Name: idx_17041_work_event_type_event_type_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_17041_work_event_type_event_type_id_uindex ON public.work_event_type USING btree (event_type_id);


--
-- Name: idx_17041_work_event_type_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_17041_work_event_type_id_uindex ON public.work_event_type USING btree (id);


--
-- Name: idx_17060_unq1_work_holyday_type; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_17060_unq1_work_holyday_type ON public.work_holyday_type USING btree (name);


--
-- Name: idx_17060_work_holyday_type_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_17060_work_holyday_type_id_uindex ON public.work_holyday_type USING btree (id);


--
-- Name: idx_17069_unq1_work_schedule; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_17069_unq1_work_schedule ON public.work_schedule USING btree (name);


--
-- Name: idx_17069_work_schedule_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_17069_work_schedule_id_uindex ON public.work_schedule USING btree (id);


--
-- Name: idx_17085_work_schedule_no_access_device_work_schedule_id_fk; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17085_work_schedule_no_access_device_work_schedule_id_fk ON public.work_schedule_no_access_device USING btree (work_schedule_id);


--
-- Name: idx_17093_work_schedule_preset_holiday_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_17093_work_schedule_preset_holiday_id_uindex ON public.work_schedule_preset_holiday USING btree (id);


--
-- Name: idx_17102_unq1_work_schedule_type; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_17102_unq1_work_schedule_type ON public.work_schedule_type USING btree (name);


--
-- Name: idx_17102_work_schedule_type_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_17102_work_schedule_type_id_uindex ON public.work_schedule_type USING btree (id);


--
-- Name: access_zone_commission access_zone_commission_access_zone_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.access_zone_commission
    ADD CONSTRAINT access_zone_commission_access_zone_id_fk FOREIGN KEY (access_zone_id) REFERENCES public.access_zone(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: access_zone_commission access_zone_commission_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.access_zone_commission
    ADD CONSTRAINT access_zone_commission_user_id_fk FOREIGN KEY (user_id) REFERENCES public."user"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: access_zone access_zone_segment_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.access_zone
    ADD CONSTRAINT access_zone_segment_id_fk FOREIGN KEY (segment_id) REFERENCES public.segment(id) ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- Name: device device_segment_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device
    ADD CONSTRAINT device_segment_id_fk FOREIGN KEY (segment_id) REFERENCES public.segment(id) ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- Name: device_user_change device_user_change_device_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_user_change
    ADD CONSTRAINT device_user_change_device_id_fk FOREIGN KEY (device_id) REFERENCES public.device(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: device_user_change device_user_change_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.device_user_change
    ADD CONSTRAINT device_user_change_user_id_fk FOREIGN KEY (user_id) REFERENCES public."user"(id) ON UPDATE RESTRICT ON DELETE CASCADE;


--
-- Name: division division_access_template_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.division
    ADD CONSTRAINT division_access_template_id_fk FOREIGN KEY (staff_access_template_id) REFERENCES public.access_template(id) ON UPDATE CASCADE ON DELETE SET NULL;


--
-- Name: division division_access_template_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.division
    ADD CONSTRAINT division_access_template_id_fk_2 FOREIGN KEY (visitor_access_template_id) REFERENCES public.access_template(id) ON UPDATE CASCADE ON DELETE SET NULL;


--
-- Name: division division_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.division
    ADD CONSTRAINT division_user_id_fk FOREIGN KEY (accompanying_id) REFERENCES public."user"(id) ON UPDATE CASCADE ON DELETE SET NULL;


--
-- Name: division division_work_schedule_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.division
    ADD CONSTRAINT division_work_schedule_id_fk FOREIGN KEY (work_schedule_id) REFERENCES public.work_schedule(id) ON UPDATE CASCADE ON DELETE SET NULL;


--
-- Name: event event_segment_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.event
    ADD CONSTRAINT event_segment_id_fk FOREIGN KEY (segment_id) REFERENCES public.segment(id) ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- Name: user_change fk_user_change_user_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_change
    ADD CONSTRAINT fk_user_change_user_id FOREIGN KEY (user_id) REFERENCES public."user"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: mobile_terminal_device mobile_terminal_device_device_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mobile_terminal_device
    ADD CONSTRAINT mobile_terminal_device_device_id_fk FOREIGN KEY (device_id) REFERENCES public.device(id) ON UPDATE CASCADE ON DELETE SET NULL;


--
-- Name: user user_access_template_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."user"
    ADD CONSTRAINT user_access_template_id_fk FOREIGN KEY (access_template_id) REFERENCES public.access_template(id) ON UPDATE CASCADE ON DELETE SET NULL;


--
-- Name: user_additional_field_data user_additional_field_data_user_additional_field_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_additional_field_data
    ADD CONSTRAINT user_additional_field_data_user_additional_field_id_fk FOREIGN KEY (field_id) REFERENCES public.user_additional_field(id) ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- Name: user_additional_field_data user_additional_field_data_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_additional_field_data
    ADD CONSTRAINT user_additional_field_data_user_id_fk FOREIGN KEY (user_id) REFERENCES public."user"(id) ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- Name: user_barcode user_barcode_barcode_type_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_barcode
    ADD CONSTRAINT user_barcode_barcode_type_id_fk FOREIGN KEY (barcode_type_id) REFERENCES public.barcode_type(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_barcode user_barcode_user_card_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_barcode
    ADD CONSTRAINT user_barcode_user_card_id_fk FOREIGN KEY (identifier_id) REFERENCES public.user_card(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_car user_car_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_car
    ADD CONSTRAINT user_car_user_id_fk FOREIGN KEY (user_id) REFERENCES public."user"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_card user_card_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_card
    ADD CONSTRAINT user_card_user_id_fk FOREIGN KEY (user_id) REFERENCES public."user"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user user_division_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."user"
    ADD CONSTRAINT user_division_id_fk FOREIGN KEY (division_id) REFERENCES public.division(id) ON UPDATE CASCADE ON DELETE SET NULL;


--
-- Name: user_doc user_doc_user_operator_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_doc
    ADD CONSTRAINT user_doc_user_operator_user_id_fk FOREIGN KEY (operator_id) REFERENCES public.user_operator(user_id) ON UPDATE CASCADE ON DELETE SET NULL;


--
-- Name: user_bio user_fingerprint_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_bio
    ADD CONSTRAINT user_fingerprint_user_id_fk FOREIGN KEY (user_id) REFERENCES public."user"(id) ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- Name: user_image user_image_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_image
    ADD CONSTRAINT user_image_user_id_fk FOREIGN KEY (user_id) REFERENCES public."user"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_operator user_operator_user_operator_type_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_operator
    ADD CONSTRAINT user_operator_user_operator_type_id_fk FOREIGN KEY (type_id) REFERENCES public.user_operator_type(id) ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- Name: user user_position_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."user"
    ADD CONSTRAINT user_position_id_fk FOREIGN KEY (position_id) REFERENCES public."position"(id) ON UPDATE CASCADE ON DELETE SET NULL;


--
-- Name: user_staff user_staff_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_staff
    ADD CONSTRAINT user_staff_user_id_fk FOREIGN KEY (user_id) REFERENCES public."user"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_staff user_staff_work_schedule_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_staff
    ADD CONSTRAINT user_staff_work_schedule_id_fk FOREIGN KEY (work_schedule_id) REFERENCES public.work_schedule(id) ON UPDATE CASCADE ON DELETE SET NULL;


--
-- Name: user user_user_type_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."user"
    ADD CONSTRAINT user_user_type_id_fk FOREIGN KEY (user_type_id) REFERENCES public.user_type(id) ON UPDATE RESTRICT ON DELETE RESTRICT;


--
-- Name: verify_point verify_point_device_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.verify_point
    ADD CONSTRAINT verify_point_device_id_fk FOREIGN KEY (reader_device_id) REFERENCES public.device(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: work_schedule_no_access_device work_schedule_no_access_device_work_schedule_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.work_schedule_no_access_device
    ADD CONSTRAINT work_schedule_no_access_device_work_schedule_id_fk FOREIGN KEY (work_schedule_id) REFERENCES public.work_schedule(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- PostgreSQL database dump complete
--

